#!/usr/bin/env node

const fs = require('fs');
const path = require('path');

const template = plugins => `/* This file was generated by './scripts/generate-plugin-combinations.js'! */
const Raven = require('../../src/singleton');
${plugins.map(plugin => `const ${plugin}Plugin = require('../${plugin}');`).join('\n')}

Raven
${plugins.map(plugin => `  .addPlugin(${plugin}Plugin)`).join('\n')};
`;

/**
 * Taken from http://dzone.com/snippets/calculate-all-combinations
 */
function combine(a) {
  const fn = function(n, src, got, all) {
    if (n === 0) {
      all.push(got);
      return;
    }

    for (let j = 0; j < src.length; j++) {
      fn(n - 1, src.slice(j + 1), got.concat([src[j]]), all);
    }
  };

  const all = [a];

  for (let i = 0; i < a.length; i++) {
    fn(i, a, [], all);
  }

  all.splice(1, 1); // Remove the empty array

  return all;
}

/**
 * Generate all plugin combinations.
 *
 * @param {array} plugins
 * @param {string} dest
 */
function generate(plugins, dest) {
  const pluginNames = plugins.map((plugin) => {
    return path.basename(plugin, '.js');
  });

  const pluginCombinations = combine(pluginNames);

  pluginCombinations.forEach((pluginCombination) => {
    fs.writeFileSync(
      path.resolve(dest, `${pluginCombination.join(',')}.js`),
      template(pluginCombination),
    );
  });
}

module.exports = generate;
