define(function() {

/**
 * removeLiteralQuotes( string )
 *
 * Return:
 * - `'` if input string is `''`.
 * - `o'clock` if input string is `'o''clock'`.
 * - `foo` if input string is `foo`, i.e., return the same value in case it isn't a single-quoted
 *   string.
 */
return function( string ) {
	if ( string[ 0 ] + string[ string.length - 1 ] !== "''" ) {
		return string;
	}
	if ( string === "''" ) {
		return "'";
	}
	return string.replace( /''/g, "'" ).slice( 1, -1 );
};

});
