/*
 * @license
 * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */

window.data = [{"name":"Source/core/dom/Document.cpp","metadata":{"status":"M","num_chunks":3,"no_base_file":false,"property_changes":"","num_added":27,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should take a Node, not a renderer. You need to do a style recalc just like in updateLayoutIgnorePendingStylesheet (you probably want to refactor that method) to make sure the renderer for Node is correct, then you can set it as the stop renderer.","draft":false,"lineno":1801,"date":"2013-08-18 03:43:15.754400","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"true? You should probably delete this.","draft":false,"lineno":1806,"date":"2013-08-18 03:43:15.754600","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This is wrong, the style recalc inside updateLayoutIgnorePendingStylesheet can change all these renderers and then your check here is not correct.","draft":false,"lineno":1815,"date":"2013-08-18 03:43:15.754780","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"You don't call any methods on it, but storing a renderer before a recalc style is a use after free.","draft":false,"lineno":1817,"date":"2013-08-18 03:43:15.754960","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should take a Node, not a renderer. You need to do a style recalc just like\n> in updateLayoutIgnorePendingStylesheet (you probably want to refactor that\n> method) to make sure the renderer for Node is correct, then you can set it as\n> the stop renderer.\n\nGreat catch!\n\nI refactored the common style recalc as \"recalcStyleForLayoutIgnoringPendingStylesheets()\".","draft":false,"lineno":1801,"date":"2013-08-20 06:19:10.780110","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> true? You should probably delete this.\n\nI'd like to leave this in for a bit longer since it makes performance testing possible on Linux. Android and OSX have overlay scrollbars which don't take up space (or CSS causes them to always take up space). Linux unfortunately has scrollbars that appear if there's enough content which will force a second layout, which breaks partial layout. I've updated the comment to be explicit about why I've left it in, and I'll remove this before landing. The layouttests will keep me honest here ;)","draft":false,"lineno":1806,"date":"2013-08-20 06:19:10.780380","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This is wrong, the style recalc inside updateLayoutIgnorePendingStylesheet can\n> change all these renderers and then your check here is not correct.\n\nDone.","draft":false,"lineno":1815,"date":"2013-08-20 06:19:10.780690","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> You don't call any methods on it, but storing a renderer before a recalc style\n> is a use after free.\n\nNo use so... just \"after free\"? :)\n\nFixed.","draft":false,"lineno":1817,"date":"2013-08-20 06:19:10.780940","left":false}],"id":24001,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":""}],[{"type":"both","beforeNumber":"151","afterNumber":"151","text":"#include \"core/platform/DateComponents.h\""},{"type":"both","beforeNumber":152,"afterNumber":152,"text":"#include \"core/platform/HistogramSupport.h\""},{"type":"both","beforeNumber":153,"afterNumber":153,"text":"#include \"core/platform/Language.h\""}],[{"type":"add","beforeNumber":154,"afterNumber":154,"text":"#include \"core/platform/ScrollbarTheme.h\""}],[{"type":"both","beforeNumber":154,"afterNumber":155,"text":"#include \"core/platform/Timer.h\""},{"type":"both","beforeNumber":155,"afterNumber":156,"text":"#include \"core/platform/chromium/TraceEvent.h\""},{"type":"both","beforeNumber":156,"afterNumber":157,"text":"#include \"core/platform/network/HTTPParsers.h\""}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void Document::updateLayout()"}],[{"type":"both","beforeNumber":"1748","afterNumber":"1749","text":" if (frameView && renderer() && (frameView->layoutPending() || renderer()->needsLayout()))"},{"type":"both","beforeNumber":1749,"afterNumber":1750,"text":" frameView->layout();"},{"type":"both","beforeNumber":1750,"afterNumber":1751,"text":""}],[{"type":"add","beforeNumber":1751,"afterNumber":1752,"text":" if (frameView)"},{"type":"add","beforeNumber":1751,"afterNumber":1753,"text":" frameView->resetPartialLayoutState();"},{"type":"add","beforeNumber":1751,"afterNumber":1754,"text":""}],[{"type":"both","beforeNumber":1751,"afterNumber":1755,"text":" setNeedsFocusedElementCheck();"},{"type":"both","beforeNumber":1752,"afterNumber":1756,"text":"}"},{"type":"both","beforeNumber":1753,"afterNumber":1757,"text":""}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void Document::updateLayoutIgnorePendingStylesheets()"}],[{"type":"both","beforeNumber":"1794","afterNumber":"1798","text":" m_ignorePendingStylesheets = oldIgnore;"},{"type":"both","beforeNumber":1795,"afterNumber":1799,"text":"}"},{"type":"both","beforeNumber":1796,"afterNumber":1800,"text":""}],[{"type":"add","beforeNumber":1797,"afterNumber":1801,"text":"void Document::tryPartialUpdateLayoutIgnorePendingStylesheets(RenderObject* stopLayoutAtRenderer)","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should take a Node, not a renderer. You need to do a style recalc just like in updateLayoutIgnorePendingStylesheet (you probably want to refactor that method) to make sure the renderer for Node is correct, then you can set it as the stop renderer.","draft":false,"lineno":1801,"date":"2013-08-18 03:43:15.754400","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should take a Node, not a renderer. You need to do a style recalc just like\n> in updateLayoutIgnorePendingStylesheet (you probably want to refactor that\n> method) to make sure the renderer for Node is correct, then you can set it as\n> the stop renderer.\n\nGreat catch!\n\nI refactored the common style recalc as \"recalcStyleForLayoutIgnoringPendingStylesheets()\".","draft":false,"lineno":1801,"date":"2013-08-20 06:19:10.780110","left":false}]},{"type":"add","beforeNumber":1797,"afterNumber":1802,"text":"{"},{"type":"add","beforeNumber":1797,"afterNumber":1803,"text":" if (stopLayoutAtRenderer) {"},{"type":"add","beforeNumber":1797,"afterNumber":1804,"text":" // Non-overlay scrollbars can cause layout during layout."},{"type":"add","beforeNumber":1797,"afterNumber":1805,"text":" // FIXME: Temporarily ignore non-overlay scrollbars for test coverage."},{"type":"add","beforeNumber":1797,"afterNumber":1806,"text":" if (true || ScrollbarTheme::theme()->usesOverlayScrollbars()) {","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"true? You should probably delete this.","draft":false,"lineno":1806,"date":"2013-08-18 03:43:15.754600","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> true? You should probably delete this.\n\nI'd like to leave this in for a bit longer since it makes performance testing possible on Linux. Android and OSX have overlay scrollbars which don't take up space (or CSS causes them to always take up space). Linux unfortunately has scrollbars that appear if there's enough content which will force a second layout, which breaks partial layout. I've updated the comment to be explicit about why I've left it in, and I'll remove this before landing. The layouttests will keep me honest here ;)","draft":false,"lineno":1806,"date":"2013-08-20 06:19:10.780380","left":false}]},{"type":"add","beforeNumber":1797,"afterNumber":1807,"text":" // FIXME: Text autosizing will not work with partial layout."},{"type":"add","beforeNumber":1797,"afterNumber":1808,"text":" bool canPartialLayout = true;"},{"type":"add","beforeNumber":1797,"afterNumber":1809,"text":" RenderObject* renderer = stopLayoutAtRenderer;"},{"type":"add","beforeNumber":1797,"afterNumber":1810,"text":" do {"},{"type":"add","beforeNumber":1797,"afterNumber":1811,"text":" if (!renderer->supportsPartialLayout()) {"},{"type":"add","beforeNumber":1797,"afterNumber":1812,"text":" canPartialLayout = false;"},{"type":"add","beforeNumber":1797,"afterNumber":1813,"text":" break;"},{"type":"add","beforeNumber":1797,"afterNumber":1814,"text":" }"},{"type":"add","beforeNumber":1797,"afterNumber":1815,"text":" } while ((renderer = renderer->parent()));","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This is wrong, the style recalc inside updateLayoutIgnorePendingStylesheet can change all these renderers and then your check here is not correct.","draft":false,"lineno":1815,"date":"2013-08-18 03:43:15.754780","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This is wrong, the style recalc inside updateLayoutIgnorePendingStylesheet can\n> change all these renderers and then your check here is not correct.\n\nDone.","draft":false,"lineno":1815,"date":"2013-08-20 06:19:10.780690","left":false}]},{"type":"add","beforeNumber":1797,"afterNumber":1816,"text":" if (canPartialLayout)"},{"type":"add","beforeNumber":1797,"afterNumber":1817,"text":" view()->setStopLayoutAtRenderer(stopLayoutAtRenderer);","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"You don't call any methods on it, but storing a renderer before a recalc style is a use after free.","draft":false,"lineno":1817,"date":"2013-08-18 03:43:15.754960","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> You don't call any methods on it, but storing a renderer before a recalc style\n> is a use after free.\n\nNo use so... just \"after free\"? :)\n\nFixed.","draft":false,"lineno":1817,"date":"2013-08-20 06:19:10.780940","left":false}]},{"type":"add","beforeNumber":1797,"afterNumber":1818,"text":" }"},{"type":"add","beforeNumber":1797,"afterNumber":1819,"text":" }"},{"type":"add","beforeNumber":1797,"afterNumber":1820,"text":""},{"type":"add","beforeNumber":1797,"afterNumber":1821,"text":" updateLayoutIgnorePendingStylesheets();"},{"type":"add","beforeNumber":1797,"afterNumber":1822,"text":"}"},{"type":"add","beforeNumber":1797,"afterNumber":1823,"text":""}],[{"type":"both","beforeNumber":1797,"afterNumber":1824,"text":"PassRefPtr<RenderStyle> Document::styleForElementIgnoringPendingStylesheets(Element* element)"},{"type":"both","beforeNumber":1798,"afterNumber":1825,"text":"{"},{"type":"both","beforeNumber":1799,"afterNumber":1826,"text":" ASSERT_ARG(element, element->document() == this);"}]]},{"name":"Source/core/dom/Document.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Remove the \"try\" prefix. That only really makes sense when this returns a boolean.\n\nLets just do partialLayoutIgnorePendingStylesheets(...)","draft":false,"lineno":491,"date":"2013-08-18 03:43:15.755130","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Remove the \"try\" prefix. That only really makes sense when this returns a\n> boolean.\n> \n> Lets just do partialLayoutIgnorePendingStylesheets(...)\n\nDone.","draft":false,"lineno":491,"date":"2013-08-20 06:19:10.781200","left":false}],"id":24002,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"488","afterNumber":"488","text":" void updateStyleForNodeIfNeeded(Node*);"},{"type":"both","beforeNumber":489,"afterNumber":489,"text":" void updateLayout();"},{"type":"both","beforeNumber":490,"afterNumber":490,"text":" void updateLayoutIgnorePendingStylesheets();"}],[{"type":"add","beforeNumber":491,"afterNumber":491,"text":" void tryPartialUpdateLayoutIgnorePendingStylesheets(RenderObject*);","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Remove the \"try\" prefix. That only really makes sense when this returns a boolean.\n\nLets just do partialLayoutIgnorePendingStylesheets(...)","draft":false,"lineno":491,"date":"2013-08-18 03:43:15.755130","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Remove the \"try\" prefix. That only really makes sense when this returns a\n> boolean.\n> \n> Lets just do partialLayoutIgnorePendingStylesheets(...)\n\nDone.","draft":false,"lineno":491,"date":"2013-08-20 06:19:10.781200","left":false}]}],[{"type":"both","beforeNumber":491,"afterNumber":492,"text":" PassRefPtr<RenderStyle> styleForElementIgnoringPendingStylesheets(Element*);"},{"type":"both","beforeNumber":492,"afterNumber":493,"text":" PassRefPtr<RenderStyle> styleForPage(int pageIndex);"},{"type":"both","beforeNumber":493,"afterNumber":494,"text":""}]]},{"name":"Source/core/dom/Element.cpp","metadata":{"status":"M","num_chunks":4,"no_base_file":false,"property_changes":"","num_added":4,"num_removed":4,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"partialUpdateLayoutIgnorePendingStylesheet(this)","draft":false,"lineno":571,"date":"2013-08-18 03:43:15.755310","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> partialUpdateLayoutIgnorePendingStylesheet(this)\n\nDone.","draft":false,"lineno":571,"date":"2013-08-20 06:19:10.781480","left":false}],"id":24003,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"static int adjustForLocalZoom(LayoutUnit value, RenderObject* renderer)"}],[{"type":"both","beforeNumber":"568","afterNumber":"568","text":""},{"type":"both","beforeNumber":569,"afterNumber":569,"text":"int Element::offsetLeft()"},{"type":"both","beforeNumber":570,"afterNumber":570,"text":"{"}],[{"type":"remove","beforeNumber":571,"afterNumber":571,"text":" document()->updateLayoutIgnorePendingStylesheets();","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"partialUpdateLayoutIgnorePendingStylesheet(this)","draft":false,"lineno":571,"date":"2013-08-18 03:43:15.755310","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> partialUpdateLayoutIgnorePendingStylesheet(this)\n\nDone.","draft":false,"lineno":571,"date":"2013-08-20 06:19:10.781480","left":false}]},{"type":"add","beforeNumber":572,"afterNumber":571,"text":" document()->tryPartialUpdateLayoutIgnorePendingStylesheets(renderer());","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"partialUpdateLayoutIgnorePendingStylesheet(this)","draft":false,"lineno":571,"date":"2013-08-18 03:43:15.755310","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> partialUpdateLayoutIgnorePendingStylesheet(this)\n\nDone.","draft":false,"lineno":571,"date":"2013-08-20 06:19:10.781480","left":false}]}],[{"type":"both","beforeNumber":572,"afterNumber":572,"text":" if (RenderBoxModelObject* renderer = renderBoxModelObject())"},{"type":"both","beforeNumber":573,"afterNumber":573,"text":" return adjustForLocalZoom(renderer->pixelSnappedOffsetLeft(), renderer);"},{"type":"both","beforeNumber":574,"afterNumber":574,"text":" return 0;"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"int Element::offsetLeft()"}],[{"type":"both","beforeNumber":"576","afterNumber":"576","text":""},{"type":"both","beforeNumber":577,"afterNumber":577,"text":"int Element::offsetTop()"},{"type":"both","beforeNumber":578,"afterNumber":578,"text":"{"}],[{"type":"remove","beforeNumber":579,"afterNumber":579,"text":" document()->updateLayoutIgnorePendingStylesheets();"},{"type":"add","beforeNumber":580,"afterNumber":579,"text":" document()->tryPartialUpdateLayoutIgnorePendingStylesheets(renderer());"}],[{"type":"both","beforeNumber":580,"afterNumber":580,"text":" if (RenderBoxModelObject* renderer = renderBoxModelObject())"},{"type":"both","beforeNumber":581,"afterNumber":581,"text":" return adjustForLocalZoom(renderer->pixelSnappedOffsetTop(), renderer);"},{"type":"both","beforeNumber":582,"afterNumber":582,"text":" return 0;"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"int Element::offsetWidth()"}],[{"type":"both","beforeNumber":"591","afterNumber":"591","text":" return adjustLayoutUnitForAbsoluteZoom(renderer->fixedOffsetWidth(), renderer).round();"},{"type":"both","beforeNumber":592,"afterNumber":592,"text":" }"},{"type":"both","beforeNumber":593,"afterNumber":593,"text":""}],[{"type":"remove","beforeNumber":594,"afterNumber":594,"text":" document()->updateLayoutIgnorePendingStylesheets();"},{"type":"add","beforeNumber":595,"afterNumber":594,"text":" document()->tryPartialUpdateLayoutIgnorePendingStylesheets(renderer());"}],[{"type":"both","beforeNumber":595,"afterNumber":595,"text":" if (RenderBoxModelObject* renderer = renderBoxModelObject())"},{"type":"both","beforeNumber":596,"afterNumber":596,"text":" return adjustLayoutUnitForAbsoluteZoom(renderer->pixelSnappedOffsetWidth(), renderer).round();"},{"type":"both","beforeNumber":597,"afterNumber":597,"text":" return 0;"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"int Element::offsetWidth()"}],[{"type":"both","beforeNumber":"599","afterNumber":"599","text":""},{"type":"both","beforeNumber":600,"afterNumber":600,"text":"int Element::offsetHeight()"},{"type":"both","beforeNumber":601,"afterNumber":601,"text":"{"}],[{"type":"remove","beforeNumber":602,"afterNumber":602,"text":" document()->updateLayoutIgnorePendingStylesheets();"},{"type":"add","beforeNumber":603,"afterNumber":602,"text":" document()->tryPartialUpdateLayoutIgnorePendingStylesheets(renderer());"}],[{"type":"both","beforeNumber":603,"afterNumber":603,"text":" if (RenderBoxModelObject* renderer = renderBoxModelObject())"},{"type":"both","beforeNumber":604,"afterNumber":604,"text":" return adjustLayoutUnitForAbsoluteZoom(renderer->pixelSnappedOffsetHeight(), renderer).round();"},{"type":"both","beforeNumber":605,"afterNumber":605,"text":" return 0;"}]]},{"name":"Source/core/html/shadow/SliderThumbElement.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24004,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"93","afterNumber":"93","text":""},{"type":"both","beforeNumber":94,"afterNumber":94,"text":"private:"},{"type":"both","beforeNumber":95,"afterNumber":95,"text":" virtual bool isSliderThumb() const;"}],[{"type":"add","beforeNumber":96,"afterNumber":96,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":96,"afterNumber":97,"text":"};"},{"type":"both","beforeNumber":97,"afterNumber":98,"text":""},{"type":"both","beforeNumber":98,"afterNumber":99,"text":"// --------------------------------"}]]},{"name":"Source/core/page/FrameView.cpp","metadata":{"status":"M","num_chunks":6,"no_base_file":false,"property_changes":"","num_added":37,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should be a FIXME for text autosizing not to do that.","draft":false,"lineno":990,"date":"2013-08-18 03:43:15.755470","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"m_frame cannot be null here. I'm pretty sure that'd be catastrophic to do layout on a frameless document.","draft":false,"lineno":993,"date":"2013-08-18 03:43:15.755700","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This check should be inline.","draft":false,"lineno":1122,"date":"2013-08-18 03:43:15.755870","left":false},{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Why do you need to check this twice? Doing it either before or after should be enough?","draft":false,"lineno":1129,"date":"2013-08-18 03:43:15.756040","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should be a FIXME for text autosizing not to do that.\n\nAdded fixme and a reference to crbug.com/256657.","draft":false,"lineno":990,"date":"2013-08-20 06:19:10.781760","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> m_frame cannot be null here. I'm pretty sure that'd be catastrophic to do layout\n> on a frameless document.\n\nDone.","draft":false,"lineno":993,"date":"2013-08-20 06:19:10.782030","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This check should be inline.\n\nDone.","draft":false,"lineno":1122,"date":"2013-08-20 06:19:10.782290","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Why do you need to check this twice? Doing it either before or after should be\n> enough?\n\nThe supportsPartialLayout loop was intended to just be an assert. I've cleaned this up like so:\n1) I've inlined checkPartialLayoutComplete and changed it to return a bool if layout is complete.\n2) I've moved the assertion loop behind an #ifndef NDEBUG check and into a private function \"checkPartialLayoutAllowed\". The purpose of checkPartialLayoutAllowed is just to assert that everything is working properly.","draft":false,"lineno":1129,"date":"2013-08-20 06:19:10.782540","left":false}],"id":24005,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"FrameView::FrameView(Frame* frame)"}],[{"type":"both","beforeNumber":"179","afterNumber":"179","text":" , m_didRunAutosize(false)"},{"type":"both","beforeNumber":180,"afterNumber":180,"text":" , m_hasSoftwareFilters(false)"},{"type":"both","beforeNumber":181,"afterNumber":181,"text":" , m_visibleContentScaleFactor(1)"}],[{"type":"add","beforeNumber":182,"afterNumber":182,"text":" , m_shouldStopPartialLayout(false)"},{"type":"add","beforeNumber":182,"afterNumber":183,"text":" , m_stopLayoutAtRenderer(0)"}],[{"type":"both","beforeNumber":182,"afterNumber":184,"text":"{"},{"type":"both","beforeNumber":183,"afterNumber":185,"text":" init();"},{"type":"both","beforeNumber":184,"afterNumber":186,"text":""}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void FrameView::layout(bool allowSubtree)"}],[{"type":"both","beforeNumber":"846","afterNumber":"848","text":" if (m_inLayout)"},{"type":"both","beforeNumber":847,"afterNumber":849,"text":" return;"},{"type":"both","beforeNumber":848,"afterNumber":850,"text":""}],[{"type":"add","beforeNumber":849,"afterNumber":851,"text":" ASSERT(!shouldStopPartialLayout());"},{"type":"add","beforeNumber":849,"afterNumber":852,"text":""}],[{"type":"both","beforeNumber":849,"afterNumber":853,"text":" TRACE_EVENT0(\"webkit\", \"FrameView::layout\");"},{"type":"both","beforeNumber":850,"afterNumber":854,"text":" TRACE_EVENT_SCOPED_SAMPLING_STATE(\"Blink\", \"Layout\");"},{"type":"both","beforeNumber":851,"afterNumber":855,"text":""}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void FrameView::layout(bool allowSubtree)"}],[{"type":"both","beforeNumber":"983","afterNumber":"987","text":""},{"type":"both","beforeNumber":984,"afterNumber":988,"text":" m_actionScheduler->pause();"},{"type":"both","beforeNumber":985,"afterNumber":989,"text":""}],[{"type":"add","beforeNumber":986,"afterNumber":990,"text":" // Text Autosizing requires two-pass layout which is incompatible with partial layout. If","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should be a FIXME for text autosizing not to do that.","draft":false,"lineno":990,"date":"2013-08-18 03:43:15.755470","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should be a FIXME for text autosizing not to do that.\n\nAdded fixme and a reference to crbug.com/256657.","draft":false,"lineno":990,"date":"2013-08-20 06:19:10.781760","left":false}]},{"type":"add","beforeNumber":986,"afterNumber":991,"text":" // enabled, only do partial layout for the second layout."},{"type":"add","beforeNumber":986,"afterNumber":992,"text":" RenderObject* delayPartialLayoutForRenderer = 0;"},{"type":"add","beforeNumber":986,"afterNumber":993,"text":" if (m_frame && m_frame->settings() && m_frame->settings()->textAutosizingEnabled()) {","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"m_frame cannot be null here. I'm pretty sure that'd be catastrophic to do layout on a frameless document.","draft":false,"lineno":993,"date":"2013-08-18 03:43:15.755700","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> m_frame cannot be null here. I'm pretty sure that'd be catastrophic to do layout\n> on a frameless document.\n\nDone.","draft":false,"lineno":993,"date":"2013-08-20 06:19:10.782030","left":false}]},{"type":"add","beforeNumber":986,"afterNumber":994,"text":" delayPartialLayoutForRenderer = m_stopLayoutAtRenderer;"},{"type":"add","beforeNumber":986,"afterNumber":995,"text":" m_stopLayoutAtRenderer = 0;"},{"type":"add","beforeNumber":986,"afterNumber":996,"text":" }"},{"type":"add","beforeNumber":986,"afterNumber":997,"text":""}],[{"type":"both","beforeNumber":986,"afterNumber":998,"text":" {"},{"type":"both","beforeNumber":987,"afterNumber":999,"text":" bool disableLayoutState = false;"},{"type":"both","beforeNumber":988,"afterNumber":1000,"text":" if (inSubtreeLayout) {"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void FrameView::layout(bool allowSubtree)"}],[{"type":"both","beforeNumber":"997","afterNumber":"1009","text":" forceLayoutParentViewIfNeeded();"},{"type":"both","beforeNumber":998,"afterNumber":1010,"text":" rootForThisLayout->layout();"},{"type":"both","beforeNumber":999,"afterNumber":1011,"text":""}],[{"type":"add","beforeNumber":1000,"afterNumber":1012,"text":" // If text autosizing is enabled, do a partial layout for the second layout."},{"type":"add","beforeNumber":1000,"afterNumber":1013,"text":" if (delayPartialLayoutForRenderer) {"},{"type":"add","beforeNumber":1000,"afterNumber":1014,"text":" ASSERT(!shouldStopPartialLayout());"},{"type":"add","beforeNumber":1000,"afterNumber":1015,"text":" m_stopLayoutAtRenderer = delayPartialLayoutForRenderer;"},{"type":"add","beforeNumber":1000,"afterNumber":1016,"text":" }"}],[{"type":"both","beforeNumber":1000,"afterNumber":1017,"text":" bool autosized = document->textAutosizer()->processSubtree(rootForThisLayout);"},{"type":"both","beforeNumber":1001,"afterNumber":1018,"text":" if (autosized && rootForThisLayout->needsLayout()) {"},{"type":"both","beforeNumber":1002,"afterNumber":1019,"text":" TRACE_EVENT0(\"webkit\", \"2nd layout due to Text Autosizing\");"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void FrameView::layout(bool allowSubtree)"}],[{"type":"both","beforeNumber":"1012","afterNumber":"1029","text":" m_layoutRoot = 0;"},{"type":"both","beforeNumber":1013,"afterNumber":1030,"text":" } // Reset m_layoutSchedulingEnabled to its previous value."},{"type":"both","beforeNumber":1014,"afterNumber":1031,"text":""}],[{"type":"add","beforeNumber":1015,"afterNumber":1032,"text":" // Reset partial layout state post-layout and exit here if a partial layout was done."},{"type":"add","beforeNumber":1015,"afterNumber":1033,"text":" if (shouldStopPartialLayout()) {"},{"type":"add","beforeNumber":1015,"afterNumber":1034,"text":" resetPartialLayoutState();"},{"type":"add","beforeNumber":1015,"afterNumber":1035,"text":" return;"},{"type":"add","beforeNumber":1015,"afterNumber":1036,"text":" }"},{"type":"add","beforeNumber":1015,"afterNumber":1037,"text":" resetPartialLayoutState();"},{"type":"add","beforeNumber":1015,"afterNumber":1038,"text":""}],[{"type":"both","beforeNumber":1015,"afterNumber":1039,"text":" bool neededFullRepaint = m_doFullRepaint;"},{"type":"both","beforeNumber":1016,"afterNumber":1040,"text":""},{"type":"both","beforeNumber":1017,"afterNumber":1041,"text":" if (!inSubtreeLayout && !toRenderView(rootForThisLayout)->printing())"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void FrameView::layout(bool allowSubtree)"}],[{"type":"both","beforeNumber":"1095","afterNumber":"1119","text":" frame()->page()->chrome().client()->layoutUpdated(frame());"},{"type":"both","beforeNumber":1096,"afterNumber":1120,"text":"}"},{"type":"both","beforeNumber":1097,"afterNumber":1121,"text":""}],[{"type":"add","beforeNumber":1098,"afterNumber":1122,"text":"void FrameView::checkPartialLayoutComplete(RenderObject* renderer)","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This check should be inline.","draft":false,"lineno":1122,"date":"2013-08-18 03:43:15.755870","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This check should be inline.\n\nDone.","draft":false,"lineno":1122,"date":"2013-08-20 06:19:10.782290","left":false}]},{"type":"add","beforeNumber":1098,"afterNumber":1123,"text":"{"},{"type":"add","beforeNumber":1098,"afterNumber":1124,"text":" ASSERT(renderer);"},{"type":"add","beforeNumber":1098,"afterNumber":1125,"text":" if (renderer == m_stopLayoutAtRenderer) {"},{"type":"add","beforeNumber":1098,"afterNumber":1126,"text":" // Make sure a partial layout was allowed."},{"type":"add","beforeNumber":1098,"afterNumber":1127,"text":" do {"},{"type":"add","beforeNumber":1098,"afterNumber":1128,"text":" ASSERT(renderer->supportsPartialLayout());"},{"type":"add","beforeNumber":1098,"afterNumber":1129,"text":" } while ((renderer = renderer->parent()));","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Why do you need to check this twice? Doing it either before or after should be enough?","draft":false,"lineno":1129,"date":"2013-08-18 03:43:15.756040","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Why do you need to check this twice? Doing it either before or after should be\n> enough?\n\nThe supportsPartialLayout loop was intended to just be an assert. I've cleaned this up like so:\n1) I've inlined checkPartialLayoutComplete and changed it to return a bool if layout is complete.\n2) I've moved the assertion loop behind an #ifndef NDEBUG check and into a private function \"checkPartialLayoutAllowed\". The purpose of checkPartialLayoutAllowed is just to assert that everything is working properly.","draft":false,"lineno":1129,"date":"2013-08-20 06:19:10.782540","left":false}]},{"type":"add","beforeNumber":1098,"afterNumber":1130,"text":""},{"type":"add","beforeNumber":1098,"afterNumber":1131,"text":" m_shouldStopPartialLayout = true;"},{"type":"add","beforeNumber":1098,"afterNumber":1132,"text":" }"},{"type":"add","beforeNumber":1098,"afterNumber":1133,"text":"}"},{"type":"add","beforeNumber":1098,"afterNumber":1134,"text":""}],[{"type":"both","beforeNumber":1098,"afterNumber":1135,"text":"RenderBox* FrameView::embeddedContentBox() const"},{"type":"both","beforeNumber":1099,"afterNumber":1136,"text":"{"},{"type":"both","beforeNumber":1100,"afterNumber":1137,"text":" RenderView* renderView = this->renderView();"}]]},{"name":"Source/core/page/FrameView.h","metadata":{"status":"M","num_chunks":2,"no_base_file":false,"property_changes":"","num_added":8,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Isn't shouldStopPartialLayout the same as checking if stopLayoutAtRenderer is not null? Why do you need a boolean?","draft":false,"lineno":341,"date":"2013-08-18 03:43:15.756200","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Isn't shouldStopPartialLayout the same as checking if stopLayoutAtRenderer is\n> not null? Why do you need a boolean?\n\nWe need the boolean to track that we're exiting in the middle of layout.\n\nm_stopLayoutAtRenderer is used to determine which renderer we need to stop layout on.\nm_shouldStopPartialLayout is used to say 'STOP' to all the layout methods.\n\nIn a full, complete layout, m_stopLayoutAtRenderer will be 0 and m_shouldStopPartialLayout will be false.\nIn a partial layout, before we've laid out the target renderer, m_shouldStopPartialLayout will be false.\nIn a partial layout, after we've laid out the target renderer, m_shouldStopPartialLayout will be true.\n\nHappy to update these names if we can make this more understandable. One idea is to move this state into a small struct or class such as PartialLayoutState to hide some of these details. We could also hide some kind of temporarilyDisablePartialLayout functionality in a class for working around two-pass layouts.","draft":false,"lineno":341,"date":"2013-08-20 06:19:10.782820","left":false}],"id":24006,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"335","afterNumber":"335","text":" // DEPRECATED: Use viewportConstrainedVisibleContentRect() instead."},{"type":"both","beforeNumber":336,"afterNumber":336,"text":" IntSize scrollOffsetForFixedPosition() const;"},{"type":"both","beforeNumber":337,"afterNumber":337,"text":""}],[{"type":"add","beforeNumber":338,"afterNumber":338,"text":" bool shouldStopPartialLayout() const { return m_shouldStopPartialLayout; }"},{"type":"add","beforeNumber":338,"afterNumber":339,"text":" void checkPartialLayoutComplete(RenderObject*);"},{"type":"add","beforeNumber":338,"afterNumber":340,"text":" void setStopLayoutAtRenderer(RenderObject* renderer) { m_stopLayoutAtRenderer = renderer; }"},{"type":"add","beforeNumber":338,"afterNumber":341,"text":" void resetPartialLayoutState() { m_stopLayoutAtRenderer = 0; m_shouldStopPartialLayout = false; }","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Isn't shouldStopPartialLayout the same as checking if stopLayoutAtRenderer is not null? Why do you need a boolean?","draft":false,"lineno":341,"date":"2013-08-18 03:43:15.756200","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Isn't shouldStopPartialLayout the same as checking if stopLayoutAtRenderer is\n> not null? Why do you need a boolean?\n\nWe need the boolean to track that we're exiting in the middle of layout.\n\nm_stopLayoutAtRenderer is used to determine which renderer we need to stop layout on.\nm_shouldStopPartialLayout is used to say 'STOP' to all the layout methods.\n\nIn a full, complete layout, m_stopLayoutAtRenderer will be 0 and m_shouldStopPartialLayout will be false.\nIn a partial layout, before we've laid out the target renderer, m_shouldStopPartialLayout will be false.\nIn a partial layout, after we've laid out the target renderer, m_shouldStopPartialLayout will be true.\n\nHappy to update these names if we can make this more understandable. One idea is to move this state into a small struct or class such as PartialLayoutState to hide some of these details. We could also hide some kind of temporarilyDisablePartialLayout functionality in a class for working around two-pass layouts.","draft":false,"lineno":341,"date":"2013-08-20 06:19:10.782820","left":false}]},{"type":"add","beforeNumber":338,"afterNumber":342,"text":""}],[{"type":"both","beforeNumber":338,"afterNumber":343,"text":"protected:"},{"type":"both","beforeNumber":339,"afterNumber":344,"text":" virtual bool scrollContentsFastPath(const IntSize& scrollDelta, const IntRect& rectToScroll, const IntRect& clipRect);"},{"type":"both","beforeNumber":340,"afterNumber":345,"text":" virtual void scrollContentsSlowPath(const IntRect& updateRect);"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"526","afterNumber":"531","text":" bool m_hasSoftwareFilters;"},{"type":"both","beforeNumber":527,"afterNumber":532,"text":""},{"type":"both","beforeNumber":528,"afterNumber":533,"text":" float m_visibleContentScaleFactor;"}],[{"type":"add","beforeNumber":529,"afterNumber":534,"text":""},{"type":"add","beforeNumber":529,"afterNumber":535,"text":" bool m_shouldStopPartialLayout;"},{"type":"add","beforeNumber":529,"afterNumber":536,"text":" RenderObject* m_stopLayoutAtRenderer;"}],[{"type":"both","beforeNumber":529,"afterNumber":537,"text":"};"},{"type":"both","beforeNumber":530,"afterNumber":538,"text":""},{"type":"both","beforeNumber":531,"afterNumber":539,"text":"inline void FrameView::incrementVisuallyNonEmptyCharacterCount(unsigned count)"}]]},{"name":"Source/core/rendering/RenderBlock.cpp","metadata":{"status":"M","num_chunks":5,"no_base_file":false,"property_changes":"","num_added":19,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"you should add frameView() to RenderObject if you want to do this.","draft":false,"lineno":2530,"date":"2013-08-18 03:43:15.756410","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> you should add frameView() to RenderObject if you want to do this.\n\nDone.","draft":false,"lineno":2530,"date":"2013-08-20 06:19:10.783050","left":false}],"id":24007,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderBlock::layout()"}],[{"type":"both","beforeNumber":"1387","afterNumber":"1387","text":" // layoutBlock()."},{"type":"both","beforeNumber":1388,"afterNumber":1388,"text":" layoutBlock(false);"},{"type":"both","beforeNumber":1389,"afterNumber":1389,"text":""}],[{"type":"add","beforeNumber":1390,"afterNumber":1390,"text":" if (document()->view()->shouldStopPartialLayout())"},{"type":"add","beforeNumber":1390,"afterNumber":1391,"text":" return;"},{"type":"add","beforeNumber":1390,"afterNumber":1392,"text":""}],[{"type":"both","beforeNumber":1390,"afterNumber":1393,"text":" // It's safe to check for control clip here, since controls can never be table cells."},{"type":"both","beforeNumber":1391,"afterNumber":1394,"text":" // If we have a lightweight clip, there can never be any overflow from children."},{"type":"both","beforeNumber":1392,"afterNumber":1395,"text":" if (hasControlClip() && m_overflow)"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderBlock::layoutBlock(bool relayoutChildren, LayoutUnit pageLogicalHeigh"}],[{"type":"both","beforeNumber":"1595","afterNumber":"1598","text":" else"},{"type":"both","beforeNumber":1596,"afterNumber":1599,"text":" layoutBlockChildren(relayoutChildren, maxFloatLogicalBottom);"},{"type":"both","beforeNumber":1597,"afterNumber":1600,"text":""}],[{"type":"add","beforeNumber":1598,"afterNumber":1601,"text":" // If layout was just for one of our children, stop early (before setting setNeedsLayout=false!)"},{"type":"add","beforeNumber":1598,"afterNumber":1602,"text":" if (document()->view()->shouldStopPartialLayout()) {"},{"type":"add","beforeNumber":1598,"afterNumber":1603,"text":" statePusher.pop();"},{"type":"add","beforeNumber":1598,"afterNumber":1604,"text":" return;"},{"type":"add","beforeNumber":1598,"afterNumber":1605,"text":" }"},{"type":"add","beforeNumber":1598,"afterNumber":1606,"text":""}],[{"type":"both","beforeNumber":1598,"afterNumber":1607,"text":" // Expand our intrinsic height to encompass floats."},{"type":"both","beforeNumber":1599,"afterNumber":1608,"text":" LayoutUnit toAdd = borderAfter() + paddingAfter() + scrollbarLogicalHeight();"},{"type":"both","beforeNumber":1600,"afterNumber":1609,"text":" if (lowestFloatLogicalBottom() > (logicalHeight() - toAdd) && expandsToEncloseOverhangingFloats())"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderBlock::layoutBlock(bool relayoutChildren, LayoutUnit pageLogicalHeigh"}],[{"type":"both","beforeNumber":"1642","afterNumber":"1651","text":""},{"type":"both","beforeNumber":1643,"afterNumber":1652,"text":" fitBorderToLinesIfNeeded();"},{"type":"both","beforeNumber":1644,"afterNumber":1653,"text":""}],[{"type":"add","beforeNumber":1645,"afterNumber":1654,"text":" if (document()->view()->shouldStopPartialLayout())"},{"type":"add","beforeNumber":1645,"afterNumber":1655,"text":" return;"},{"type":"add","beforeNumber":1645,"afterNumber":1656,"text":""}],[{"type":"both","beforeNumber":1645,"afterNumber":1657,"text":" if (renderView->layoutState()->m_pageLogicalHeight)"},{"type":"both","beforeNumber":1646,"afterNumber":1658,"text":" setPageLogicalOffset(renderView->layoutState()->pageLogicalOffset(this, logicalTop()));"},{"type":"both","beforeNumber":1647,"afterNumber":1659,"text":""}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderBlock::layoutBlockChildren(bool relayoutChildren, LayoutUnit& maxFloa"}],[{"type":"both","beforeNumber":"2514","afterNumber":"2526","text":""},{"type":"both","beforeNumber":2515,"afterNumber":2527,"text":" // Lay out the child."},{"type":"both","beforeNumber":2516,"afterNumber":2528,"text":" layoutBlockChild(child, marginInfo, previousFloatLogicalBottom, maxFloatLogicalBottom);"}],[{"type":"add","beforeNumber":2517,"afterNumber":2529,"text":""},{"type":"add","beforeNumber":2517,"afterNumber":2530,"text":" document()->view()->checkPartialLayoutComplete(child);","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"you should add frameView() to RenderObject if you want to do this.","draft":false,"lineno":2530,"date":"2013-08-18 03:43:15.756410","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> you should add frameView() to RenderObject if you want to do this.\n\nDone.","draft":false,"lineno":2530,"date":"2013-08-20 06:19:10.783050","left":false}]},{"type":"add","beforeNumber":2517,"afterNumber":2531,"text":" if (document()->view()->shouldStopPartialLayout())"},{"type":"add","beforeNumber":2517,"afterNumber":2532,"text":" break;"}],[{"type":"both","beforeNumber":2517,"afterNumber":2533,"text":" }"},{"type":"both","beforeNumber":2518,"afterNumber":2534,"text":""},{"type":"both","beforeNumber":2519,"afterNumber":2535,"text":" // Now do the handling of the bottom of the block, adding in our bottom border/padding and"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderBlock::layoutBlockChild(RenderBox* child, MarginInfo& marginInfo, Lay"}],[{"type":"both","beforeNumber":"2578","afterNumber":"2594","text":" if (childNeededLayout)"},{"type":"both","beforeNumber":2579,"afterNumber":2595,"text":" child->layout();"},{"type":"both","beforeNumber":2580,"afterNumber":2596,"text":""}],[{"type":"add","beforeNumber":2581,"afterNumber":2597,"text":" if (document()->view()->shouldStopPartialLayout())"},{"type":"add","beforeNumber":2581,"afterNumber":2598,"text":" return;"},{"type":"add","beforeNumber":2581,"afterNumber":2599,"text":""}],[{"type":"both","beforeNumber":2581,"afterNumber":2600,"text":" // Cache if we are at the top of the block right now."},{"type":"both","beforeNumber":2582,"afterNumber":2601,"text":" bool atBeforeSideOfBlock = marginInfo.atBeforeSideOfBlock();"},{"type":"both","beforeNumber":2583,"afterNumber":2602,"text":""}]]},{"name":"Source/core/rendering/RenderBlock.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":3,"num_removed":0,"messages":[],"id":24008,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"492","afterNumber":"492","text":" void layoutPositionedObjects(bool relayoutChildren, bool fixedPositionObjectsOnly = false);"},{"type":"both","beforeNumber":493,"afterNumber":493,"text":" void markFixedPositionObjectForLayoutIfNeeded(RenderObject* child);"},{"type":"both","beforeNumber":494,"afterNumber":494,"text":""}],[{"type":"add","beforeNumber":495,"afterNumber":495,"text":" // FIXME: This should be pure virtual with an implementation in the header."},{"type":"add","beforeNumber":495,"afterNumber":496,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return true; };"},{"type":"add","beforeNumber":495,"afterNumber":497,"text":""}],[{"type":"both","beforeNumber":495,"afterNumber":498,"text":" virtual void paint(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":496,"afterNumber":499,"text":" virtual void paintObject(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":497,"afterNumber":500,"text":" virtual void paintChildren(PaintInfo&, const LayoutPoint&);"}]]},{"name":"Source/core/rendering/RenderDeprecatedFlexibleBox.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24009,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"64","afterNumber":"64","text":" bool m_stretchingChildren;"},{"type":"both","beforeNumber":65,"afterNumber":65,"text":""},{"type":"both","beforeNumber":66,"afterNumber":66,"text":"private:"}],[{"type":"add","beforeNumber":67,"afterNumber":67,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":67,"afterNumber":68,"text":""}],[{"type":"both","beforeNumber":67,"afterNumber":69,"text":" void applyLineClamp(FlexBoxIterator&, bool relayoutChildren);"},{"type":"both","beforeNumber":68,"afterNumber":70,"text":" void clearLineClamp();"},{"type":"both","beforeNumber":69,"afterNumber":71,"text":"};"}]]},{"name":"Source/core/rendering/RenderDetailsMarker.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24010,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"35","afterNumber":"35","text":""},{"type":"both","beforeNumber":36,"afterNumber":36,"text":"private:"},{"type":"both","beforeNumber":37,"afterNumber":37,"text":" virtual const char* renderName() const { return \"RenderDetailsMarker\"; }"}],[{"type":"add","beforeNumber":38,"afterNumber":38,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":38,"afterNumber":39,"text":" virtual bool isDetailsMarker() const { return true; }"},{"type":"both","beforeNumber":39,"afterNumber":40,"text":" virtual void paint(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":40,"afterNumber":41,"text":""}]]},{"name":"Source/core/rendering/RenderFieldset.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24011,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"44","afterNumber":"44","text":" virtual void computePreferredLogicalWidths();"},{"type":"both","beforeNumber":45,"afterNumber":45,"text":" virtual bool avoidsFloats() const { return true; }"},{"type":"both","beforeNumber":46,"afterNumber":46,"text":""}],[{"type":"add","beforeNumber":47,"afterNumber":47,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":47,"afterNumber":48,"text":""}],[{"type":"both","beforeNumber":47,"afterNumber":49,"text":" virtual void paintBoxDecorations(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":48,"afterNumber":50,"text":" virtual void paintMask(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":49,"afterNumber":51,"text":"};"}]]},{"name":"Source/core/rendering/RenderFileUploadControl.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24012,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"52","afterNumber":"52","text":""},{"type":"both","beforeNumber":53,"afterNumber":53,"text":" virtual bool requiresForcedStyleRecalcPropagation() const { return true; }"},{"type":"both","beforeNumber":54,"afterNumber":54,"text":""}],[{"type":"add","beforeNumber":55,"afterNumber":55,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":55,"afterNumber":56,"text":""}],[{"type":"both","beforeNumber":55,"afterNumber":57,"text":" int maxFilenameWidth() const;"},{"type":"both","beforeNumber":56,"afterNumber":58,"text":""},{"type":"both","beforeNumber":57,"afterNumber":59,"text":" virtual PositionWithAffinity positionForPoint(const LayoutPoint&) OVERRIDE FINAL;"}]]},{"name":"Source/core/rendering/RenderFlexibleBox.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24013,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"61","afterNumber":"61","text":"protected:"},{"type":"both","beforeNumber":62,"afterNumber":62,"text":" virtual void computeIntrinsicLogicalWidths(LayoutUnit& minLogicalWidth, LayoutUnit& maxLogicalWidth) const OVERRIDE;"},{"type":"both","beforeNumber":63,"afterNumber":63,"text":""}],[{"type":"add","beforeNumber":64,"afterNumber":64,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":64,"afterNumber":65,"text":""}],[{"type":"both","beforeNumber":64,"afterNumber":66,"text":" virtual void styleDidChange(StyleDifference, const RenderStyle* oldStyle);"},{"type":"both","beforeNumber":65,"afterNumber":67,"text":""},{"type":"both","beforeNumber":66,"afterNumber":68,"text":"private:"}]]},{"name":"Source/core/rendering/RenderFlowThread.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":4,"num_removed":0,"messages":[],"id":24014,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"268","afterNumber":"268","text":" bool m_pageLogicalSizeChanged : 1;"},{"type":"both","beforeNumber":269,"afterNumber":269,"text":" bool m_inConstrainedLayoutPhase : 1;"},{"type":"both","beforeNumber":270,"afterNumber":270,"text":" bool m_needsTwoPhasesLayout : 1;"}],[{"type":"add","beforeNumber":271,"afterNumber":271,"text":""},{"type":"add","beforeNumber":271,"afterNumber":272,"text":"private:"},{"type":"add","beforeNumber":271,"afterNumber":273,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":271,"afterNumber":274,"text":""}],[{"type":"both","beforeNumber":271,"afterNumber":275,"text":"};"},{"type":"both","beforeNumber":272,"afterNumber":276,"text":""},{"type":"both","beforeNumber":273,"afterNumber":277,"text":"inline RenderFlowThread* toRenderFlowThread(RenderObject* object)"}]]},{"name":"Source/core/rendering/RenderFullScreen.cpp","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24015,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"39","afterNumber":"39","text":" }"},{"type":"both","beforeNumber":40,"afterNumber":40,"text":"private:"},{"type":"both","beforeNumber":41,"afterNumber":41,"text":" virtual bool isRenderFullScreenPlaceholder() const { return true; }"}],[{"type":"add","beforeNumber":42,"afterNumber":42,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":42,"afterNumber":43,"text":" virtual void willBeDestroyed();"},{"type":"both","beforeNumber":43,"afterNumber":44,"text":" RenderFullScreen* m_owner;"},{"type":"both","beforeNumber":44,"afterNumber":45,"text":"};"}]]},{"name":"Source/core/rendering/RenderFullScreen.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24016,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"47","afterNumber":"47","text":""},{"type":"both","beforeNumber":48,"afterNumber":48,"text":"private:"},{"type":"both","beforeNumber":49,"afterNumber":49,"text":" RenderFullScreen();"}],[{"type":"add","beforeNumber":50,"afterNumber":50,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":50,"afterNumber":51,"text":" virtual void willBeDestroyed();"},{"type":"both","beforeNumber":51,"afterNumber":52,"text":""},{"type":"both","beforeNumber":52,"afterNumber":53,"text":"protected:"}]]},{"name":"Source/core/rendering/RenderGrid.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24017,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"92","afterNumber":"92","text":""},{"type":"both","beforeNumber":93,"afterNumber":93,"text":" void layoutGridItems();"},{"type":"both","beforeNumber":94,"afterNumber":94,"text":""}],[{"type":"add","beforeNumber":95,"afterNumber":95,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":95,"afterNumber":96,"text":""}],[{"type":"both","beforeNumber":95,"afterNumber":97,"text":" typedef LayoutUnit (RenderGrid::* SizingFunction)(RenderBox*, TrackSizingDirection, Vector<GridTrack>&);"},{"type":"both","beforeNumber":96,"afterNumber":98,"text":" typedef LayoutUnit (GridTrack::* AccumulatorGetter)() const;"},{"type":"both","beforeNumber":97,"afterNumber":99,"text":" typedef void (GridTrack::* AccumulatorGrowFunction)(LayoutUnit);"}]]},{"name":"Source/core/rendering/RenderListBox.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24018,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"82","afterNumber":"82","text":""},{"type":"both","beforeNumber":83,"afterNumber":83,"text":" virtual void layout();"},{"type":"both","beforeNumber":84,"afterNumber":84,"text":""}],[{"type":"add","beforeNumber":85,"afterNumber":85,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":85,"afterNumber":86,"text":""}],[{"type":"both","beforeNumber":85,"afterNumber":87,"text":" virtual void addFocusRingRects(Vector<IntRect>&, const LayoutPoint& additionalOffset, const RenderLayerModelObject* paintContainer = 0) OVERRIDE;"},{"type":"both","beforeNumber":86,"afterNumber":88,"text":""},{"type":"both","beforeNumber":87,"afterNumber":89,"text":" virtual bool canBeProgramaticallyScrolled() const { return true; }"}]]},{"name":"Source/core/rendering/RenderListItem.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24019,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"68","afterNumber":"68","text":""},{"type":"both","beforeNumber":69,"afterNumber":69,"text":" virtual void layout();"},{"type":"both","beforeNumber":70,"afterNumber":70,"text":""}],[{"type":"add","beforeNumber":71,"afterNumber":71,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":71,"afterNumber":72,"text":""}],[{"type":"both","beforeNumber":71,"afterNumber":73,"text":" void positionListMarker();"},{"type":"both","beforeNumber":72,"afterNumber":74,"text":""},{"type":"both","beforeNumber":73,"afterNumber":75,"text":" virtual void styleDidChange(StyleDifference, const RenderStyle* oldStyle);"}]]},{"name":"Source/core/rendering/RenderMarquee.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24020,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"88","afterNumber":"88","text":""},{"type":"both","beforeNumber":89,"afterNumber":89,"text":" virtual void layoutBlock(bool relayoutChildren, LayoutUnit pageLogicalHeight = 0) OVERRIDE FINAL;"},{"type":"both","beforeNumber":90,"afterNumber":90,"text":""}],[{"type":"add","beforeNumber":91,"afterNumber":91,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":91,"afterNumber":92,"text":""}],[{"type":"both","beforeNumber":91,"afterNumber":93,"text":" void timerFired(Timer<RenderMarquee>*);"},{"type":"both","beforeNumber":92,"afterNumber":94,"text":""},{"type":"both","beforeNumber":93,"afterNumber":95,"text":" int m_currentLoop;"}]]},{"name":"Source/core/rendering/RenderMediaControlElements.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24021,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"40","afterNumber":"40","text":""},{"type":"both","beforeNumber":41,"afterNumber":41,"text":"private:"},{"type":"both","beforeNumber":42,"afterNumber":42,"text":" virtual void layout();"}],[{"type":"add","beforeNumber":43,"afterNumber":43,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":43,"afterNumber":44,"text":"};"},{"type":"both","beforeNumber":44,"afterNumber":45,"text":""},{"type":"both","beforeNumber":45,"afterNumber":46,"text":""}]]},{"name":"Source/core/rendering/RenderMeter.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24022,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"40","afterNumber":"40","text":" virtual void updateLogicalWidth() OVERRIDE;"},{"type":"both","beforeNumber":41,"afterNumber":41,"text":" virtual void computeLogicalHeight(LayoutUnit logicalHeight, LayoutUnit logicalTop, LogicalExtentComputedValues&) const OVERRIDE;"},{"type":"both","beforeNumber":42,"afterNumber":42,"text":""}],[{"type":"add","beforeNumber":43,"afterNumber":43,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":43,"afterNumber":44,"text":""}],[{"type":"both","beforeNumber":43,"afterNumber":45,"text":" virtual const char* renderName() const { return \"RenderMeter\"; }"},{"type":"both","beforeNumber":44,"afterNumber":46,"text":" virtual bool isMeter() const { return true; }"},{"type":"both","beforeNumber":45,"afterNumber":47,"text":" virtual bool requiresForcedStyleRecalcPropagation() const { return true; }"}]]},{"name":"Source/core/rendering/RenderMultiColumnBlock.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24023,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"59","afterNumber":"59","text":" virtual void checkForPaginationLogicalHeightChange(LayoutUnit& pageLogicalHeight, bool& pageLogicalHeightChanged, bool& hasSpecifiedPageLogicalHeight) OVERRIDE;"},{"type":"both","beforeNumber":60,"afterNumber":60,"text":" virtual bool relayoutForPagination(bool hasSpecifiedPageLogicalHeight, LayoutUnit pageLogicalHeight, LayoutStateMaintainer&) OVERRIDE;"},{"type":"both","beforeNumber":61,"afterNumber":61,"text":""}],[{"type":"add","beforeNumber":62,"afterNumber":62,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":62,"afterNumber":63,"text":""}],[{"type":"both","beforeNumber":62,"afterNumber":64,"text":" virtual void addChild(RenderObject* newChild, RenderObject* beforeChild = 0) OVERRIDE;"},{"type":"both","beforeNumber":63,"afterNumber":65,"text":""},{"type":"both","beforeNumber":64,"afterNumber":66,"text":" void computeColumnCountAndWidth();"}]]},{"name":"Source/core/rendering/RenderObject.cpp","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":10,"num_removed":0,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Add a frameView(), also I don't know how this can be null. Frameless documents never have renderers.\n\nIf it can be null this should be an early return.","draft":false,"lineno":752,"date":"2013-08-18 03:43:15.756610","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Add a frameView(), also I don't know how this can be null. Frameless documents\n> never have renderers.\n> \n> If it can be null this should be an early return.\n\nDone.\n\nI changed this to not even check for null so we'll null deref crash in debug if our assumption is wrong.","draft":false,"lineno":752,"date":"2013-08-20 06:19:10.783280","left":false}],"id":24024,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderObject::checkBlockPositionedObjectsNeedLayout()"}],[{"type":"both","beforeNumber":"746","afterNumber":"746","text":" if (isRenderBlock())"},{"type":"both","beforeNumber":747,"afterNumber":747,"text":" toRenderBlock(this)->checkPositionedObjectsNeedLayout();"},{"type":"both","beforeNumber":748,"afterNumber":748,"text":"}"}],[{"type":"add","beforeNumber":749,"afterNumber":749,"text":""},{"type":"add","beforeNumber":749,"afterNumber":750,"text":"void RenderObject::checkNotInPartialLayout()"},{"type":"add","beforeNumber":749,"afterNumber":751,"text":"{"},{"type":"add","beforeNumber":749,"afterNumber":752,"text":" if (frame()) {","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"Add a frameView(), also I don't know how this can be null. Frameless documents never have renderers.\n\nIf it can be null this should be an early return.","draft":false,"lineno":752,"date":"2013-08-18 03:43:15.756610","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> Add a frameView(), also I don't know how this can be null. Frameless documents\n> never have renderers.\n> \n> If it can be null this should be an early return.\n\nDone.\n\nI changed this to not even check for null so we'll null deref crash in debug if our assumption is wrong.","draft":false,"lineno":752,"date":"2013-08-20 06:19:10.783280","left":false}]},{"type":"add","beforeNumber":749,"afterNumber":753,"text":" if (FrameView* view = frame()->view()) {"},{"type":"add","beforeNumber":749,"afterNumber":754,"text":" // During partial layout, setNeedsLayout(true or false) should not be called."},{"type":"add","beforeNumber":749,"afterNumber":755,"text":" ASSERT(!view->shouldStopPartialLayout());"},{"type":"add","beforeNumber":749,"afterNumber":756,"text":" }"},{"type":"add","beforeNumber":749,"afterNumber":757,"text":" }"},{"type":"add","beforeNumber":749,"afterNumber":758,"text":"}"}],[{"type":"both","beforeNumber":749,"afterNumber":759,"text":"#endif"},{"type":"both","beforeNumber":750,"afterNumber":760,"text":""},{"type":"both","beforeNumber":751,"afterNumber":761,"text":"void RenderObject::setPreferredLogicalWidthsDirty(bool shouldBeDirty, MarkingBehavior markParents)"}]]},{"name":"Source/core/rendering/RenderObject.h","metadata":{"status":"M","num_chunks":5,"no_base_file":false,"property_changes":"","num_added":11,"num_removed":0,"messages":[],"id":24025,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"class RenderNamedFlowThread;"}],[{"type":"both","beforeNumber":"67","afterNumber":"67","text":"class RenderSVGResourceContainer;"},{"type":"both","beforeNumber":68,"afterNumber":68,"text":"class RenderTable;"},{"type":"both","beforeNumber":69,"afterNumber":69,"text":"class RenderTheme;"}],[{"type":"add","beforeNumber":70,"afterNumber":70,"text":"class RenderView;"}],[{"type":"both","beforeNumber":70,"afterNumber":71,"text":"class TransformState;"},{"type":"both","beforeNumber":71,"afterNumber":72,"text":""},{"type":"both","beforeNumber":72,"afterNumber":73,"text":"struct PaintInfo;"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"674","afterNumber":"675","text":" void forceLayout();"},{"type":"both","beforeNumber":675,"afterNumber":676,"text":" void forceChildLayout();"},{"type":"both","beforeNumber":676,"afterNumber":677,"text":""}],[{"type":"add","beforeNumber":677,"afterNumber":678,"text":" // True if we can abort layout, leaving a partially laid out tree."},{"type":"add","beforeNumber":677,"afterNumber":679,"text":" virtual bool supportsPartialLayout() const { return false; }"},{"type":"add","beforeNumber":677,"afterNumber":680,"text":""}],[{"type":"both","beforeNumber":677,"afterNumber":681,"text":" // used for element state updates that cannot be fixed with a"},{"type":"both","beforeNumber":678,"afterNumber":682,"text":" // repaint and do not need a relayout"},{"type":"both","beforeNumber":679,"afterNumber":683,"text":" virtual void updateFromElement() { }"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"1073","afterNumber":"1077","text":""},{"type":"both","beforeNumber":1074,"afterNumber":1078,"text":"#ifndef NDEBUG"},{"type":"both","beforeNumber":1075,"afterNumber":1079,"text":" void checkBlockPositionedObjectsNeedLayout();"}],[{"type":"add","beforeNumber":1076,"afterNumber":1080,"text":" void checkNotInPartialLayout();"}],[{"type":"both","beforeNumber":1076,"afterNumber":1081,"text":"#endif"},{"type":"both","beforeNumber":1077,"afterNumber":1082,"text":""},{"type":"both","beforeNumber":1078,"afterNumber":1083,"text":" RefPtr<RenderStyle> m_style;"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"inline bool RenderObject::isBeforeOrAfterContent() const"}],[{"type":"both","beforeNumber":"1243","afterNumber":"1248","text":""},{"type":"both","beforeNumber":1244,"afterNumber":1249,"text":"inline void RenderObject::setNeedsLayout(MarkingBehavior markParents, SubtreeLayoutScope* layouter)"},{"type":"both","beforeNumber":1245,"afterNumber":1250,"text":"{"}],[{"type":"add","beforeNumber":1246,"afterNumber":1251,"text":"#ifndef NDEBUG"},{"type":"add","beforeNumber":1246,"afterNumber":1252,"text":" checkNotInPartialLayout();"},{"type":"add","beforeNumber":1246,"afterNumber":1253,"text":"#endif"}],[{"type":"both","beforeNumber":1246,"afterNumber":1254,"text":" ASSERT(!isSetNeedsLayoutForbidden());"},{"type":"both","beforeNumber":1247,"afterNumber":1255,"text":" bool alreadyNeededLayout = m_bitfields.needsLayout();"},{"type":"both","beforeNumber":1248,"afterNumber":1256,"text":" m_bitfields.setNeedsLayout(true);"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"inline void RenderObject::setNeedsLayout(MarkingBehavior markParents, SubtreeLay"}],[{"type":"both","beforeNumber":"1256","afterNumber":"1264","text":""},{"type":"both","beforeNumber":1257,"afterNumber":1265,"text":"inline void RenderObject::clearNeedsLayout()"},{"type":"both","beforeNumber":1258,"afterNumber":1266,"text":"{"}],[{"type":"add","beforeNumber":1259,"afterNumber":1267,"text":"#ifndef NDEBUG"},{"type":"add","beforeNumber":1259,"afterNumber":1268,"text":" checkNotInPartialLayout();"},{"type":"add","beforeNumber":1259,"afterNumber":1269,"text":"#endif"}],[{"type":"both","beforeNumber":1259,"afterNumber":1270,"text":" m_bitfields.setNeedsLayout(false);"},{"type":"both","beforeNumber":1260,"afterNumber":1271,"text":" setEverHadLayout(true);"},{"type":"both","beforeNumber":1261,"afterNumber":1272,"text":" setPosChildNeedsLayout(false);"}]]},{"name":"Source/core/rendering/RenderProgress.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24026,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"45","afterNumber":"45","text":" virtual const char* renderName() const { return \"RenderProgress\"; }"},{"type":"both","beforeNumber":46,"afterNumber":46,"text":" virtual bool isProgress() const { return true; }"},{"type":"both","beforeNumber":47,"afterNumber":47,"text":" virtual bool requiresForcedStyleRecalcPropagation() const { return true; }"}],[{"type":"add","beforeNumber":48,"afterNumber":48,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":48,"afterNumber":49,"text":" virtual bool canBeReplacedWithInlineRunIn() const OVERRIDE;"},{"type":"both","beforeNumber":49,"afterNumber":50,"text":""},{"type":"both","beforeNumber":50,"afterNumber":51,"text":" void animationTimerFired(Timer<RenderProgress>*);"}]]},{"name":"Source/core/rendering/RenderRegion.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24027,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"164","afterNumber":"164","text":" virtual void willBeRemovedFromTree() OVERRIDE;"},{"type":"both","beforeNumber":165,"afterNumber":165,"text":""},{"type":"both","beforeNumber":166,"afterNumber":166,"text":" virtual void layoutBlock(bool relayoutChildren, LayoutUnit pageLogicalHeight = 0) OVERRIDE;"}],[{"type":"add","beforeNumber":167,"afterNumber":167,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":167,"afterNumber":168,"text":" virtual void paintObject(PaintInfo&, const LayoutPoint&) OVERRIDE;"},{"type":"both","beforeNumber":168,"afterNumber":169,"text":""},{"type":"both","beforeNumber":169,"afterNumber":170,"text":" virtual void installFlowThread();"}]]},{"name":"Source/core/rendering/RenderRuby.h","metadata":{"status":"M","num_chunks":2,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24028,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"65","afterNumber":"65","text":"private:"},{"type":"both","beforeNumber":66,"afterNumber":66,"text":" virtual bool isRuby() const { return true; }"},{"type":"both","beforeNumber":67,"afterNumber":67,"text":" virtual const char* renderName() const { return \"RenderRuby (inline)\"; }"}],[{"type":"add","beforeNumber":68,"afterNumber":68,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":68,"afterNumber":69,"text":" virtual bool createsAnonymousWrapper() const { return true; }"},{"type":"both","beforeNumber":69,"afterNumber":70,"text":" virtual void removeLeftoverAnonymousBlock(RenderBlock*) { ASSERT_NOT_REACHED(); }"},{"type":"both","beforeNumber":70,"afterNumber":71,"text":"};"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"84","afterNumber":"85","text":"private:"},{"type":"both","beforeNumber":85,"afterNumber":86,"text":" virtual bool isRuby() const { return true; }"},{"type":"both","beforeNumber":86,"afterNumber":87,"text":" virtual const char* renderName() const { return \"RenderRuby (block)\"; }"}],[{"type":"add","beforeNumber":87,"afterNumber":88,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":87,"afterNumber":89,"text":" virtual bool createsAnonymousWrapper() const { return true; }"},{"type":"both","beforeNumber":88,"afterNumber":90,"text":" virtual void removeLeftoverAnonymousBlock(RenderBlock*) { ASSERT_NOT_REACHED(); }"},{"type":"both","beforeNumber":89,"afterNumber":91,"text":"};"}]]},{"name":"Source/core/rendering/RenderRubyBase.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24029,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"55","afterNumber":"55","text":" virtual ETextAlign textAlignmentForLine(bool endsWithSoftBreak) const;"},{"type":"both","beforeNumber":56,"afterNumber":56,"text":" virtual void adjustInlineDirectionLineBounds(int expansionOpportunityCount, float& logicalLeft, float& logicalWidth) const;"},{"type":"both","beforeNumber":57,"afterNumber":57,"text":""}],[{"type":"add","beforeNumber":58,"afterNumber":58,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":58,"afterNumber":59,"text":""}],[{"type":"both","beforeNumber":58,"afterNumber":60,"text":" void moveChildren(RenderRubyBase* toBase, RenderObject* beforeChild = 0);"},{"type":"both","beforeNumber":59,"afterNumber":61,"text":" void moveInlineChildren(RenderRubyBase* toBase, RenderObject* beforeChild = 0);"},{"type":"both","beforeNumber":60,"afterNumber":62,"text":" void moveBlockChildren(RenderRubyBase* toBase, RenderObject* beforeChild = 0);"}]]},{"name":"Source/core/rendering/RenderRubyRun.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24030,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"74","afterNumber":"74","text":""},{"type":"both","beforeNumber":75,"afterNumber":75,"text":" virtual bool isRubyRun() const { return true; }"},{"type":"both","beforeNumber":76,"afterNumber":76,"text":" virtual const char* renderName() const { return \"RenderRubyRun (anonymous)\"; }"}],[{"type":"add","beforeNumber":77,"afterNumber":77,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":77,"afterNumber":78,"text":" virtual bool createsAnonymousWrapper() const { return true; }"},{"type":"both","beforeNumber":78,"afterNumber":79,"text":" virtual void removeLeftoverAnonymousBlock(RenderBlock*) { }"},{"type":"both","beforeNumber":79,"afterNumber":80,"text":"};"}]]},{"name":"Source/core/rendering/RenderRubyText.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24031,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"49","afterNumber":"49","text":"private:"},{"type":"both","beforeNumber":50,"afterNumber":50,"text":" virtual bool avoidsFloats() const;"},{"type":"both","beforeNumber":51,"afterNumber":51,"text":""}],[{"type":"add","beforeNumber":52,"afterNumber":52,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":52,"afterNumber":53,"text":""}],[{"type":"both","beforeNumber":52,"afterNumber":54,"text":" virtual ETextAlign textAlignmentForLine(bool endsWithSoftBreak) const;"},{"type":"both","beforeNumber":53,"afterNumber":55,"text":" virtual void adjustInlineDirectionLineBounds(int expansionOpportunityCount, float& logicalLeft, float& logicalWidth) const;"},{"type":"both","beforeNumber":54,"afterNumber":56,"text":"};"}]]},{"name":"Source/core/rendering/RenderScrollbarPart.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24032,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"66","afterNumber":"66","text":""},{"type":"both","beforeNumber":67,"afterNumber":67,"text":" virtual void computePreferredLogicalWidths();"},{"type":"both","beforeNumber":68,"afterNumber":68,"text":""}],[{"type":"add","beforeNumber":69,"afterNumber":69,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":69,"afterNumber":70,"text":""}],[{"type":"both","beforeNumber":69,"afterNumber":71,"text":" void layoutHorizontalPart();"},{"type":"both","beforeNumber":70,"afterNumber":72,"text":" void layoutVerticalPart();"},{"type":"both","beforeNumber":71,"afterNumber":73,"text":""}]]},{"name":"Source/core/rendering/RenderTable.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24033,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"278","afterNumber":"278","text":" virtual void paintBoxDecorations(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":279,"afterNumber":279,"text":" virtual void paintMask(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":280,"afterNumber":280,"text":" virtual void layout();"}],[{"type":"add","beforeNumber":281,"afterNumber":281,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":281,"afterNumber":282,"text":" virtual void computeIntrinsicLogicalWidths(LayoutUnit& minWidth, LayoutUnit& maxWidth) const OVERRIDE;"},{"type":"both","beforeNumber":282,"afterNumber":283,"text":" virtual void computePreferredLogicalWidths() OVERRIDE;"},{"type":"both","beforeNumber":283,"afterNumber":284,"text":" virtual bool nodeAtPoint(const HitTestRequest&, HitTestResult&, const HitTestLocation& locationInContainer, const LayoutPoint& accumulatedOffset, HitTestAction) OVERRIDE;"}]]},{"name":"Source/core/rendering/RenderTableCaption.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24034,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"35","afterNumber":"35","text":"private:"},{"type":"both","beforeNumber":36,"afterNumber":36,"text":" virtual bool isTableCaption() const OVERRIDE { return true; }"},{"type":"both","beforeNumber":37,"afterNumber":37,"text":""}],[{"type":"add","beforeNumber":38,"afterNumber":38,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":38,"afterNumber":39,"text":""}],[{"type":"both","beforeNumber":38,"afterNumber":40,"text":" virtual void insertedIntoTree() OVERRIDE;"},{"type":"both","beforeNumber":39,"afterNumber":41,"text":" virtual void willBeRemovedFromTree() OVERRIDE;"},{"type":"both","beforeNumber":40,"afterNumber":42,"text":""}]]},{"name":"Source/core/rendering/RenderTableCell.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24035,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"121","afterNumber":"121","text":""},{"type":"both","beforeNumber":122,"afterNumber":122,"text":" virtual void layout();"},{"type":"both","beforeNumber":123,"afterNumber":123,"text":""}],[{"type":"add","beforeNumber":124,"afterNumber":124,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":124,"afterNumber":125,"text":""}],[{"type":"both","beforeNumber":124,"afterNumber":126,"text":" virtual void paint(PaintInfo&, const LayoutPoint&);"},{"type":"both","beforeNumber":125,"afterNumber":127,"text":""},{"type":"both","beforeNumber":126,"afterNumber":128,"text":" void paintCollapsedBorders(PaintInfo&, const LayoutPoint&);"}]]},{"name":"Source/core/rendering/RenderTextControl.h","metadata":{"status":"M","num_chunks":2,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":1,"messages":[],"id":24036,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"protected:"}],[{"type":"both","beforeNumber":"67","afterNumber":"67","text":"private:"},{"type":"both","beforeNumber":68,"afterNumber":68,"text":" virtual const char* renderName() const { return \"RenderTextControl\"; }"},{"type":"both","beforeNumber":69,"afterNumber":69,"text":" virtual bool isTextControl() const { return true; }"}],[{"type":"add","beforeNumber":70,"afterNumber":70,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":70,"afterNumber":71,"text":" virtual void computeIntrinsicLogicalWidths(LayoutUnit& minLogicalWidth, LayoutUnit& maxLogicalWidth) const OVERRIDE;"},{"type":"both","beforeNumber":71,"afterNumber":72,"text":" virtual void computePreferredLogicalWidths() OVERRIDE;"},{"type":"both","beforeNumber":72,"afterNumber":73,"text":" virtual void removeLeftoverAnonymousBlock(RenderBlock*) { }"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"113","afterNumber":"114","text":" }"},{"type":"both","beforeNumber":114,"afterNumber":115,"text":" virtual int firstLineBoxBaseline() const OVERRIDE { return RenderBlock::firstLineBoxBaseline(); }"},{"type":"both","beforeNumber":115,"afterNumber":116,"text":" virtual int inlineBlockBaseline(LineDirectionMode direction) const OVERRIDE { return lastLineBoxBaseline(direction); }"}],[{"type":"remove","beforeNumber":116,"afterNumber":117,"text":""},{"type":"add","beforeNumber":117,"afterNumber":117,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":117,"afterNumber":118,"text":"};"},{"type":"both","beforeNumber":118,"afterNumber":119,"text":""},{"type":"both","beforeNumber":119,"afterNumber":120,"text":""}]]},{"name":"Source/core/rendering/RenderTextTrackCue.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":1,"num_removed":0,"messages":[],"id":24037,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"41","afterNumber":"41","text":""},{"type":"both","beforeNumber":42,"afterNumber":42,"text":"private:"},{"type":"both","beforeNumber":43,"afterNumber":43,"text":" virtual void layout() OVERRIDE;"}],[{"type":"add","beforeNumber":44,"afterNumber":44,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"}],[{"type":"both","beforeNumber":44,"afterNumber":45,"text":""},{"type":"both","beforeNumber":45,"afterNumber":46,"text":" bool isOutside() const;"},{"type":"both","beforeNumber":46,"afterNumber":47,"text":" bool isOverlapping() const;"}]]},{"name":"Source/core/rendering/RenderView.cpp","metadata":{"status":"M","num_chunks":3,"no_base_file":false,"property_changes":"","num_added":15,"num_removed":0,"messages":[],"id":24038,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderView::layoutContent(const LayoutState& state)"}],[{"type":"both","beforeNumber":"120","afterNumber":"120","text":" ASSERT(needsLayout());"},{"type":"both","beforeNumber":121,"afterNumber":121,"text":""},{"type":"both","beforeNumber":122,"afterNumber":122,"text":" RenderBlock::layout();"}],[{"type":"add","beforeNumber":123,"afterNumber":123,"text":""},{"type":"add","beforeNumber":123,"afterNumber":124,"text":" if (m_frameView->shouldStopPartialLayout())"},{"type":"add","beforeNumber":123,"afterNumber":125,"text":" return;"},{"type":"add","beforeNumber":123,"afterNumber":126,"text":""}],[{"type":"both","beforeNumber":123,"afterNumber":127,"text":" if (hasRenderNamedFlowThreads())"},{"type":"both","beforeNumber":124,"afterNumber":128,"text":" flowThreadController()->layoutRenderNamedFlowThreads();"}],[{"type":"add","beforeNumber":125,"afterNumber":129,"text":""}],[{"type":"both","beforeNumber":125,"afterNumber":130,"text":"#ifndef NDEBUG"},{"type":"both","beforeNumber":126,"afterNumber":131,"text":" checkLayoutState(state);"},{"type":"both","beforeNumber":127,"afterNumber":132,"text":"#endif"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"bool RenderView::initializeLayoutState(LayoutState& state)"}],[{"type":"both","beforeNumber":"214","afterNumber":"219","text":"// as detected in the previous step."},{"type":"both","beforeNumber":215,"afterNumber":220,"text":"void RenderView::layoutContentInAutoLogicalHeightRegions(const LayoutState& state)"},{"type":"both","beforeNumber":216,"afterNumber":221,"text":"{"}],[{"type":"add","beforeNumber":217,"afterNumber":222,"text":" if (!m_frameView->shouldStopPartialLayout()) {"},{"type":"add","beforeNumber":217,"afterNumber":223,"text":" // disable partial layout for any two-pass layout algorithm."},{"type":"add","beforeNumber":217,"afterNumber":224,"text":" m_frameView->resetPartialLayoutState();"},{"type":"add","beforeNumber":217,"afterNumber":225,"text":" }"},{"type":"add","beforeNumber":217,"afterNumber":226,"text":""}],[{"type":"both","beforeNumber":217,"afterNumber":227,"text":" // We need to invalidate all the flows with auto-height regions if one such flow needs layout."},{"type":"both","beforeNumber":218,"afterNumber":228,"text":" // If none is found we do a layout a check back again afterwards."},{"type":"both","beforeNumber":219,"afterNumber":229,"text":" if (!flowThreadController()->updateFlowThreadsNeedingLayout()) {"}],[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"void RenderView::layout()"}],[{"type":"both","beforeNumber":"283","afterNumber":"293","text":" else"},{"type":"both","beforeNumber":284,"afterNumber":294,"text":" layoutContent(state);"},{"type":"both","beforeNumber":285,"afterNumber":295,"text":""}],[{"type":"add","beforeNumber":286,"afterNumber":296,"text":" if (m_frameView->shouldStopPartialLayout()) {"},{"type":"add","beforeNumber":286,"afterNumber":297,"text":" m_layoutState = 0;"},{"type":"add","beforeNumber":286,"afterNumber":298,"text":" return;"},{"type":"add","beforeNumber":286,"afterNumber":299,"text":" }"},{"type":"add","beforeNumber":286,"afterNumber":300,"text":""}],[{"type":"both","beforeNumber":286,"afterNumber":301,"text":"#ifndef NDEBUG"},{"type":"both","beforeNumber":287,"afterNumber":302,"text":" checkLayoutState(state);"},{"type":"both","beforeNumber":288,"afterNumber":303,"text":"#endif"}]]},{"name":"Source/core/rendering/RenderView.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24039,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"public:"}],[{"type":"both","beforeNumber":"59","afterNumber":"59","text":" virtual void updateLogicalWidth() OVERRIDE;"},{"type":"both","beforeNumber":60,"afterNumber":60,"text":" virtual void computeLogicalHeight(LayoutUnit logicalHeight, LayoutUnit logicalTop, LogicalExtentComputedValues&) const OVERRIDE;"},{"type":"both","beforeNumber":61,"afterNumber":61,"text":""}],[{"type":"add","beforeNumber":62,"afterNumber":62,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return true; }"},{"type":"add","beforeNumber":62,"afterNumber":63,"text":""}],[{"type":"both","beforeNumber":62,"afterNumber":64,"text":" virtual LayoutUnit availableLogicalHeight(AvailableLogicalHeightType) const OVERRIDE;"},{"type":"both","beforeNumber":63,"afterNumber":65,"text":""},{"type":"both","beforeNumber":64,"afterNumber":66,"text":" // The same as the FrameView's layoutHeight/layoutWidth but with null check guards."}]]},{"name":"Source/core/rendering/SubtreeLayoutScope.cpp","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":10,"num_removed":8,"messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should be an early return.","draft":false,"lineno":47,"date":"2013-08-18 03:43:15.756770","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should be an early return.\n\nDone.","draft":false,"lineno":47,"date":"2013-08-20 06:19:10.783530","left":false}],"id":24040,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"SubtreeLayoutScope::SubtreeLayoutScope(RenderObject* root)"}],[{"type":"both","beforeNumber":"44","afterNumber":"44","text":""},{"type":"both","beforeNumber":45,"afterNumber":45,"text":"SubtreeLayoutScope::~SubtreeLayoutScope()"},{"type":"both","beforeNumber":46,"afterNumber":46,"text":"{"}],[{"type":"remove","beforeNumber":47,"afterNumber":47,"text":" RELEASE_ASSERT(!m_root->needsLayout());","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should be an early return.","draft":false,"lineno":47,"date":"2013-08-18 03:43:15.756770","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should be an early return.\n\nDone.","draft":false,"lineno":47,"date":"2013-08-20 06:19:10.783530","left":false}]},{"type":"add","beforeNumber":48,"afterNumber":47,"text":" if (!m_root->document()->view()->shouldStopPartialLayout()) {","messages":[{"author":"esprehn","author_email":"esprehn@chromium.org","text":"This should be an early return.","draft":false,"lineno":47,"date":"2013-08-18 03:43:15.756770","left":false},{"author":"pdr","author_email":"pdr@chromium.org","text":"On 2013/08/18 03:43:15, esprehn wrote:\n> This should be an early return.\n\nDone.","draft":false,"lineno":47,"date":"2013-08-20 06:19:10.783530","left":false}]},{"type":"add","beforeNumber":48,"afterNumber":48,"text":" RELEASE_ASSERT(!m_root->needsLayout());"}],[{"type":"both","beforeNumber":48,"afterNumber":49,"text":""},{"type":"both","beforeNumber":49,"afterNumber":50,"text":"#ifndef NDEBUG"}],[{"type":"remove","beforeNumber":50,"afterNumber":51,"text":" for (HashSet<RenderObject*>::iterator it = m_renderersToLayout.begin(); it != m_renderersToLayout.end(); ++it) {"},{"type":"remove","beforeNumber":51,"afterNumber":51,"text":" RenderObject* renderer = *it;"},{"type":"remove","beforeNumber":52,"afterNumber":51,"text":" // FIXME: Thie patter is really common. Move it into an assertRendererLaidOut function."},{"type":"remove","beforeNumber":53,"afterNumber":51,"text":" if (renderer->needsLayout())"},{"type":"remove","beforeNumber":54,"afterNumber":51,"text":" showRenderTree(renderer);"},{"type":"remove","beforeNumber":55,"afterNumber":51,"text":" ASSERT(!renderer->needsLayout());"},{"type":"remove","beforeNumber":56,"afterNumber":51,"text":" }"},{"type":"add","beforeNumber":57,"afterNumber":51,"text":" for (HashSet<RenderObject*>::iterator it = m_renderersToLayout.begin(); it != m_renderersToLayout.end(); ++it) {"},{"type":"add","beforeNumber":57,"afterNumber":52,"text":" RenderObject* renderer = *it;"},{"type":"add","beforeNumber":57,"afterNumber":53,"text":" // FIXME: Thie patter is really common. Move it into an assertRendererLaidOut function."},{"type":"add","beforeNumber":57,"afterNumber":54,"text":" if (renderer->needsLayout())"},{"type":"add","beforeNumber":57,"afterNumber":55,"text":" showRenderTree(renderer);"},{"type":"add","beforeNumber":57,"afterNumber":56,"text":" ASSERT(!renderer->needsLayout());"},{"type":"add","beforeNumber":57,"afterNumber":57,"text":" }"}],[{"type":"both","beforeNumber":57,"afterNumber":58,"text":"#endif"}],[{"type":"add","beforeNumber":58,"afterNumber":59,"text":" }"}],[{"type":"both","beforeNumber":58,"afterNumber":60,"text":"}"},{"type":"both","beforeNumber":59,"afterNumber":61,"text":""},{"type":"both","beforeNumber":60,"afterNumber":62,"text":"void SubtreeLayoutScope::setNeedsLayout(RenderObject* descendant)"}]]},{"name":"Source/core/rendering/svg/RenderSVGBlock.h","metadata":{"status":"M","num_chunks":1,"no_base_file":false,"property_changes":"","num_added":2,"num_removed":0,"messages":[],"id":24041,"is_binary":false},"isImage":false,"groups":[[{"type":"header","beforeNumber":"@@","afterNumber":"@@","text":"private:"}],[{"type":"both","beforeNumber":"41","afterNumber":"41","text":""},{"type":"both","beforeNumber":42,"afterNumber":42,"text":" virtual bool isRenderSVGBlock() const OVERRIDE FINAL { return true; };"},{"type":"both","beforeNumber":43,"afterNumber":43,"text":""}],[{"type":"add","beforeNumber":44,"afterNumber":44,"text":" virtual bool supportsPartialLayout() const OVERRIDE { return false; }"},{"type":"add","beforeNumber":44,"afterNumber":45,"text":""}],[{"type":"both","beforeNumber":44,"afterNumber":46,"text":" virtual void absoluteRects(Vector<IntRect>&, const LayoutPoint& accumulatedOffset) const OVERRIDE FINAL;"},{"type":"both","beforeNumber":45,"afterNumber":47,"text":""},{"type":"both","beforeNumber":46,"afterNumber":48,"text":" virtual void styleWillChange(StyleDifference, const RenderStyle* newStyle) OVERRIDE FINAL;"}]]}];