Ext.data.JsonP.Autolinker_htmlParser_HtmlParser({"tagname":"class","name":"Autolinker.htmlParser.HtmlParser","autodetected":{},"files":[{"filename":"html-parser.js","href":"html-parser.html#Autolinker-htmlParser-HtmlParser"}],"extends":null,"members":[{"name":"createCommentNode","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-createCommentNode","meta":{"private":true}},{"name":"createElementNode","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-createElementNode","meta":{"private":true}},{"name":"createEntityNode","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-createEntityNode","meta":{"private":true}},{"name":"createTextNode","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-createTextNode","meta":{"private":true}},{"name":"parse","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-parse","meta":{}},{"name":"parseTextAndEntityNodes","tagname":"method","owner":"Autolinker.htmlParser.HtmlParser","id":"method-parseTextAndEntityNodes","meta":{"private":true}}],"alternateClassNames":[],"aliases":{},"id":"class-Autolinker.htmlParser.HtmlParser","short_doc":"An HTML parser implementation which simply walks an HTML string and returns an array of\nHtmlNodes that represent the ...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser' target='_blank'>html-parser.js</a></div></pre><div class='doc-contents'><p>An HTML parser implementation which simply walks an HTML string and returns an array of\n<a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">HtmlNodes</a> that represent the basic HTML structure of the input string.</p>\n\n<p>Autolinker uses this to only link URLs/emails/mentions within text nodes, effectively ignoring / \"walking\naround\" HTML tags.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-createCommentNode' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-createCommentNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-createCommentNode' class='name expandable'>createCommentNode</a>( <span class='pre'>offset, tagText, commentText</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Factory method to create an CommentNode. ...</div><div class='long'><p>Factory method to create an <a href=\"#!/api/Autolinker.htmlParser.CommentNode\" rel=\"Autolinker.htmlParser.CommentNode\" class=\"docClass\">CommentNode</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>offset</span> : Number<div class='sub-desc'><p>The offset of the match within the original HTML\n  string.</p>\n</div></li><li><span class='pre'>tagText</span> : String<div class='sub-desc'><p>The full text of the tag (comment) that was\n  matched, including its &lt;!-- and --&gt;.</p>\n</div></li><li><span class='pre'>commentText</span> : String<div class='sub-desc'><p>The full text of the comment that was matched.</p>\n</div></li></ul></div></div></div><div id='method-createElementNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-createElementNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-createElementNode' class='name expandable'>createElementNode</a>( <span class='pre'>offset, tagText, tagName, isClosingTag</span> ) : <a href=\"#!/api/Autolinker.htmlParser.ElementNode\" rel=\"Autolinker.htmlParser.ElementNode\" class=\"docClass\">Autolinker.htmlParser.ElementNode</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Factory method to create an ElementNode. ...</div><div class='long'><p>Factory method to create an <a href=\"#!/api/Autolinker.htmlParser.ElementNode\" rel=\"Autolinker.htmlParser.ElementNode\" class=\"docClass\">ElementNode</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>offset</span> : Number<div class='sub-desc'><p>The offset of the match within the original HTML\n  string.</p>\n</div></li><li><span class='pre'>tagText</span> : String<div class='sub-desc'><p>The full text of the tag (element) that was\n  matched, including its attributes.</p>\n</div></li><li><span class='pre'>tagName</span> : String<div class='sub-desc'><p>The name of the tag. Ex: An &lt;img&gt; tag would\n  be passed to this method as \"img\".</p>\n</div></li><li><span class='pre'>isClosingTag</span> : Boolean<div class='sub-desc'><p><code>true</code> if it's a closing tag, false\n  otherwise.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.htmlParser.ElementNode\" rel=\"Autolinker.htmlParser.ElementNode\" class=\"docClass\">Autolinker.htmlParser.ElementNode</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createEntityNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-createEntityNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-createEntityNode' class='name expandable'>createEntityNode</a>( <span class='pre'>offset, text</span> ) : <a href=\"#!/api/Autolinker.htmlParser.EntityNode\" rel=\"Autolinker.htmlParser.EntityNode\" class=\"docClass\">Autolinker.htmlParser.EntityNode</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Factory method to create a EntityNode. ...</div><div class='long'><p>Factory method to create a <a href=\"#!/api/Autolinker.htmlParser.EntityNode\" rel=\"Autolinker.htmlParser.EntityNode\" class=\"docClass\">EntityNode</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>offset</span> : Number<div class='sub-desc'><p>The offset of the match within the original HTML\n  string.</p>\n</div></li><li><span class='pre'>text</span> : String<div class='sub-desc'><p>The text that was matched for the HTML entity (such\n  as '&amp;nbsp;').</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.htmlParser.EntityNode\" rel=\"Autolinker.htmlParser.EntityNode\" class=\"docClass\">Autolinker.htmlParser.EntityNode</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createTextNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-createTextNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-createTextNode' class='name expandable'>createTextNode</a>( <span class='pre'>offset, text</span> ) : <a href=\"#!/api/Autolinker.htmlParser.TextNode\" rel=\"Autolinker.htmlParser.TextNode\" class=\"docClass\">Autolinker.htmlParser.TextNode</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Factory method to create a TextNode. ...</div><div class='long'><p>Factory method to create a <a href=\"#!/api/Autolinker.htmlParser.TextNode\" rel=\"Autolinker.htmlParser.TextNode\" class=\"docClass\">TextNode</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>offset</span> : Number<div class='sub-desc'><p>The offset of the match within the original HTML\n  string.</p>\n</div></li><li><span class='pre'>text</span> : String<div class='sub-desc'><p>The text that was matched.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.htmlParser.TextNode\" rel=\"Autolinker.htmlParser.TextNode\" class=\"docClass\">Autolinker.htmlParser.TextNode</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-parse' class='name expandable'>parse</a>( <span class='pre'>html</span> ) : <a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">Autolinker.htmlParser.HtmlNode</a>[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses an HTML string and returns a simple array of HtmlNodes\nto represent the HTML structure of the input string. ...</div><div class='long'><p>Parses an HTML string and returns a simple array of <a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">HtmlNodes</a>\nto represent the HTML structure of the input string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>html</span> : String<div class='sub-desc'><p>The HTML to parse.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">Autolinker.htmlParser.HtmlNode</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-parseTextAndEntityNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker.htmlParser.HtmlParser'>Autolinker.htmlParser.HtmlParser</span><br/><a href='source/html-parser.html#Autolinker-htmlParser-HtmlParser-method-parseTextAndEntityNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker.htmlParser.HtmlParser-method-parseTextAndEntityNodes' class='name expandable'>parseTextAndEntityNodes</a>( <span class='pre'>offset, text</span> ) : <a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">Autolinker.htmlParser.HtmlNode</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Parses text and HTML entity nodes from a given string. ...</div><div class='long'><p>Parses text and HTML entity nodes from a given string. The input string\nshould not have any HTML tags (elements) within it.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>offset</span> : Number<div class='sub-desc'><p>The offset of the text node match within the\n  original HTML string.</p>\n</div></li><li><span class='pre'>text</span> : String<div class='sub-desc'><p>The string of text to parse. This is from an HTML\n  text node.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.htmlParser.HtmlNode\" rel=\"Autolinker.htmlParser.HtmlNode\" class=\"docClass\">Autolinker.htmlParser.HtmlNode</a>[]</span><div class='sub-desc'><p>An array of HtmlNodes to\n  represent the <a href=\"#!/api/Autolinker.htmlParser.TextNode\" rel=\"Autolinker.htmlParser.TextNode\" class=\"docClass\">TextNodes</a> and\n  <a href=\"#!/api/Autolinker.htmlParser.EntityNode\" rel=\"Autolinker.htmlParser.EntityNode\" class=\"docClass\">EntityNodes</a> found.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});