Ext.data.JsonP.Autolinker({"tagname":"class","name":"Autolinker","autodetected":{},"files":[{"filename":"autolinker.js","href":"autolinker.html#Autolinker"}],"extends":null,"members":[{"name":"className","tagname":"cfg","owner":"Autolinker","id":"cfg-className","meta":{}},{"name":"context","tagname":"cfg","owner":"Autolinker","id":"cfg-context","meta":{}},{"name":"decodePercentEncoding","tagname":"cfg","owner":"Autolinker","id":"cfg-decodePercentEncoding","meta":{}},{"name":"email","tagname":"cfg","owner":"Autolinker","id":"cfg-email","meta":{}},{"name":"hashtag","tagname":"cfg","owner":"Autolinker","id":"cfg-hashtag","meta":{}},{"name":"mention","tagname":"cfg","owner":"Autolinker","id":"cfg-mention","meta":{}},{"name":"newWindow","tagname":"cfg","owner":"Autolinker","id":"cfg-newWindow","meta":{}},{"name":"phone","tagname":"cfg","owner":"Autolinker","id":"cfg-phone","meta":{}},{"name":"replaceFn","tagname":"cfg","owner":"Autolinker","id":"cfg-replaceFn","meta":{}},{"name":"stripPrefix","tagname":"cfg","owner":"Autolinker","id":"cfg-stripPrefix","meta":{}},{"name":"stripTrailingSlash","tagname":"cfg","owner":"Autolinker","id":"cfg-stripTrailingSlash","meta":{}},{"name":"truncate","tagname":"cfg","owner":"Autolinker","id":"cfg-truncate","meta":{}},{"name":"urls","tagname":"cfg","owner":"Autolinker","id":"cfg-urls","meta":{}},{"name":"matchers","tagname":"property","owner":"Autolinker","id":"property-matchers","meta":{"private":true}},{"name":"tagBuilder","tagname":"property","owner":"Autolinker","id":"property-tagBuilder","meta":{"private":true}},{"name":"version","tagname":"property","owner":"Autolinker","id":"property-version","meta":{}},{"name":"version","tagname":"property","owner":"Autolinker","id":"static-property-version","meta":{"static":true}},{"name":"constructor","tagname":"method","owner":"Autolinker","id":"method-constructor","meta":{}},{"name":"compactMatches","tagname":"method","owner":"Autolinker","id":"method-compactMatches","meta":{"private":true}},{"name":"createMatchReturnVal","tagname":"method","owner":"Autolinker","id":"method-createMatchReturnVal","meta":{"private":true}},{"name":"getMatchers","tagname":"method","owner":"Autolinker","id":"method-getMatchers","meta":{"private":true}},{"name":"getTagBuilder","tagname":"method","owner":"Autolinker","id":"method-getTagBuilder","meta":{"private":true}},{"name":"link","tagname":"method","owner":"Autolinker","id":"method-link","meta":{}},{"name":"normalizeStripPrefixCfg","tagname":"method","owner":"Autolinker","id":"method-normalizeStripPrefixCfg","meta":{"private":true}},{"name":"normalizeTruncateCfg","tagname":"method","owner":"Autolinker","id":"method-normalizeTruncateCfg","meta":{"private":true}},{"name":"normalizeUrlsCfg","tagname":"method","owner":"Autolinker","id":"method-normalizeUrlsCfg","meta":{"private":true}},{"name":"parse","tagname":"method","owner":"Autolinker","id":"method-parse","meta":{}},{"name":"parseText","tagname":"method","owner":"Autolinker","id":"method-parseText","meta":{"private":true}},{"name":"removeUnwantedMatches","tagname":"method","owner":"Autolinker","id":"method-removeUnwantedMatches","meta":{"private":true}},{"name":"link","tagname":"method","owner":"Autolinker","id":"static-method-link","meta":{"static":true}},{"name":"parse","tagname":"method","owner":"Autolinker","id":"static-method-parse","meta":{"static":true}}],"alternateClassNames":[],"aliases":{},"id":"class-Autolinker","short_doc":"Utility class used to process a given string of text, and wrap the matches in\nthe appropriate anchor (&lt;a&gt;) tags...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/autolinker.html#Autolinker' target='_blank'>autolinker.js</a></div></pre><div class='doc-contents'><p>Utility class used to process a given string of text, and wrap the matches in\nthe appropriate anchor (&lt;a&gt;) tags to turn them into links.</p>\n\n<p>Any of the configuration options may be provided in an Object provided\nto the Autolinker constructor, which will configure how the <a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link()</a>\nmethod will process the links.</p>\n\n<p>For example:</p>\n\n<pre><code>var autolinker = new Autolinker( {\n    newWindow : false,\n    truncate  : 30\n} );\n\nvar html = autolinker.link( \"Joe went to www.yahoo.com\" );\n// produces: 'Joe went to &lt;a href=\"http://www.yahoo.com\"&gt;yahoo.com&lt;/a&gt;'\n</code></pre>\n\n<p>The <a href=\"#!/api/Autolinker-static-method-link\" rel=\"Autolinker-static-method-link\" class=\"docClass\">static link()</a> method may also be used to inline\noptions into a single call, which may be more convenient for one-off uses.\nFor example:</p>\n\n<pre><code>var html = <a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">Autolinker.link</a>( \"Joe went to www.yahoo.com\", {\n    newWindow : false,\n    truncate  : 30\n} );\n// produces: 'Joe went to &lt;a href=\"http://www.yahoo.com\"&gt;yahoo.com&lt;/a&gt;'\n</code></pre>\n\n<h2>Custom Replacements of Links</h2>\n\n<p>If the configuration options do not provide enough flexibility, a <a href=\"#!/api/Autolinker-cfg-replaceFn\" rel=\"Autolinker-cfg-replaceFn\" class=\"docClass\">replaceFn</a>\nmay be provided to fully customize the output of Autolinker. This function is\ncalled once for each URL/Email/Phone#/Hashtag/Mention (Twitter, Instagram, Soundcloud)\nmatch that is encountered.</p>\n\n<p>For example:</p>\n\n<pre><code>var input = \"...\";  // string with URLs, Email Addresses, Phone #s, Hashtags, and Mentions (Twitter, Instagram, Soundcloud)\n\nvar linkedText = <a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">Autolinker.link</a>( input, {\n    replaceFn : function( match ) {\n        console.log( \"href = \", match.getAnchorHref() );\n        console.log( \"text = \", match.getAnchorText() );\n\n        switch( match.getType() ) {\n            case 'url' :\n                console.log( \"url: \", match.getUrl() );\n\n                if( match.getUrl().indexOf( 'mysite.com' ) === -1 ) {\n                    var tag = match.buildTag();  // returns an `<a href=\"#!/api/Autolinker.HtmlTag\" rel=\"Autolinker.HtmlTag\" class=\"docClass\">Autolinker.HtmlTag</a>` instance, which provides mutator methods for easy changes\n                    tag.setAttr( 'rel', 'nofollow' );\n                    tag.addClass( 'external-link' );\n\n                    return tag;\n\n                } else {\n                    return true;  // let Autolinker perform its normal anchor tag replacement\n                }\n\n            case 'email' :\n                var email = match.getEmail();\n                console.log( \"email: \", email );\n\n                if( email === \"my@own.address\" ) {\n                    return false;  // don't auto-link this particular email address; leave as-is\n                } else {\n                    return;  // no return value will have Autolinker perform its normal anchor tag replacement (same as returning `true`)\n                }\n\n            case 'phone' :\n                var phoneNumber = match.getPhoneNumber();\n                console.log( phoneNumber );\n\n                return '&lt;a href=\"http://newplace.to.link.phone.numbers.to/\"&gt;' + phoneNumber + '&lt;/a&gt;';\n\n            case 'hashtag' :\n                var hashtag = match.getHashtag();\n                console.log( hashtag );\n\n                return '&lt;a href=\"http://newplace.to.link.hashtag.handles.to/\"&gt;' + hashtag + '&lt;/a&gt;';\n\n            case 'mention' :\n                var mention = match.getMention();\n                console.log( mention );\n\n                return '&lt;a href=\"http://newplace.to.link.mention.to/\"&gt;' + mention + '&lt;/a&gt;';\n        }\n    }\n} );\n</code></pre>\n\n<p>The function may return the following values:</p>\n\n<ul>\n<li><code>true</code> (Boolean): Allow Autolinker to replace the match as it normally\nwould.</li>\n<li><code>false</code> (Boolean): Do not replace the current match at all - leave as-is.</li>\n<li>Any String: If a string is returned from the function, the string will be\nused directly as the replacement HTML for the match.</li>\n<li>An <a href=\"#!/api/Autolinker.HtmlTag\" rel=\"Autolinker.HtmlTag\" class=\"docClass\">Autolinker.HtmlTag</a> instance, which can be used to build/modify\nan HTML tag before writing out its HTML text.</li>\n</ul>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-className' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-className' class='name expandable'>className</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>A CSS class name to add to the generated links. ...</div><div class='long'><p>A CSS class name to add to the generated links. This class will be added\nto all links, as well as this class plus match suffixes for styling\nurl/email/phone/hashtag/mention links differently.</p>\n\n<p>For example, if this config is provided as \"myLink\", then:</p>\n\n<ul>\n<li>URL links will have the CSS classes: \"myLink myLink-url\"</li>\n<li>Email links will have the CSS classes: \"myLink myLink-email\", and</li>\n<li>Phone links will have the CSS classes: \"myLink myLink-phone\"</li>\n<li>Hashtag links will have the CSS classes: \"myLink myLink-hashtag\"</li>\n<li>Mention links will have the CSS classes: \"myLink myLink-mention myLink-[type]\"\nwhere [type] is either \"instagram\", \"twitter\" or \"soundcloud\"</li>\n</ul>\n\n<p>Defaults to: <code>&#39;&#39;</code></p></div></div></div><div id='cfg-context' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-context' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-context' class='name expandable'>context</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>The context object (this reference) to call the replaceFn with. ...</div><div class='long'><p>The context object (<code>this</code> reference) to call the <code>replaceFn</code> with.</p>\n\n<p>Defaults to this Autolinker instance.</p>\n</div></div></div><div id='cfg-decodePercentEncoding' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-decodePercentEncoding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-decodePercentEncoding' class='name expandable'>decodePercentEncoding</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true to decode percent-encoded characters in URL matches, false to keep\n the percent-encoded characters. ...</div><div class='long'><p><code>true</code> to decode percent-encoded characters in URL matches, <code>false</code> to keep\n the percent-encoded characters.</p>\n\n<p> Example when <code>true</code>: <code>https://en.wikipedia.org/wiki/San_Jos%C3%A9</code> will\n be displayed as <code>https://en.wikipedia.org/wiki/San_José</code>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-email' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-email' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-email' class='name expandable'>email</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true if email addresses should be automatically linked, false if they\nshould not be. ...</div><div class='long'><p><code>true</code> if email addresses should be automatically linked, <code>false</code> if they\nshould not be.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-hashtag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-hashtag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-hashtag' class='name expandable'>hashtag</a> : Boolean/String<span class=\"signature\"></span></div><div class='description'><div class='short'>A string for the service name to have hashtags (ex: \"#myHashtag\")\nauto-linked to. ...</div><div class='long'><p>A string for the service name to have hashtags (ex: \"#myHashtag\")\nauto-linked to. The currently-supported values are:</p>\n\n<ul>\n<li>'twitter'</li>\n<li>'facebook'</li>\n<li>'instagram'</li>\n</ul>\n\n\n<p>Pass <code>false</code> to skip auto-linking of hashtags.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-mention' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-mention' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-mention' class='name expandable'>mention</a> : String/Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>A string for the service name to have mentions (ex: \"@myuser\")\nauto-linked to. ...</div><div class='long'><p>A string for the service name to have mentions (ex: \"@myuser\")\nauto-linked to. The currently supported values are:</p>\n\n<ul>\n<li>'twitter'</li>\n<li>'instagram'</li>\n<li>'soundcloud'</li>\n</ul>\n\n\n<p>Defaults to <code>false</code> to skip auto-linking of mentions.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-newWindow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-newWindow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-newWindow' class='name expandable'>newWindow</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true if the links should open in a new window, false otherwise. ...</div><div class='long'><p><code>true</code> if the links should open in a new window, <code>false</code> otherwise.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-phone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-phone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-phone' class='name expandable'>phone</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true if Phone numbers (\"(555)555-5555\") should be automatically linked,\nfalse if they should not be. ...</div><div class='long'><p><code>true</code> if Phone numbers (\"(555)555-5555\") should be automatically linked,\n<code>false</code> if they should not be.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-replaceFn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-replaceFn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-replaceFn' class='name expandable'>replaceFn</a> : Function<span class=\"signature\"></span></div><div class='description'><div class='short'>A function to individually process each match found in the input string. ...</div><div class='long'><p>A function to individually process each match found in the input string.</p>\n\n<p>See the class's description for usage.</p>\n\n<p>The <code>replaceFn</code> can be called with a different context object (<code>this</code>\nreference) using the <a href=\"#!/api/Autolinker-cfg-context\" rel=\"Autolinker-cfg-context\" class=\"docClass\">context</a> cfg.</p>\n\n<p>This function is called with the following parameter:</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>match</span> : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a><div class='sub-desc'><p>The Match instance which\n  can be used to retrieve information about the match that the <code>replaceFn</code>\n  is currently processing. See <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a> subclasses\n  for details.</p>\n</div></li></ul></div></div></div><div id='cfg-stripPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-stripPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-stripPrefix' class='name expandable'>stripPrefix</a> : Boolean/Object<span class=\"signature\"></span></div><div class='description'><div class='short'>true if 'http://' (or 'https://') and/or the 'www.' should be stripped\nfrom the beginning of URL links' text, false o...</div><div class='long'><p><code>true</code> if 'http://' (or 'https://') and/or the 'www.' should be stripped\nfrom the beginning of URL links' text, <code>false</code> otherwise. Defaults to\n<code>true</code>.</p>\n\n<p>Examples:</p>\n\n<pre><code>stripPrefix: true\n\n// or\n\nstripPrefix: {\n    scheme : true,\n    www    : true\n}\n</code></pre>\n\n<p>As shown above, this option also accepts an Object form with 2 properties\nto allow for more customization of what exactly is prevented from being\ndisplayed. Both default to <code>true</code>:</p>\n<p>Defaults to: <code>true</code></p><ul><li><span class='pre'>scheme</span> : Boolean (optional)<div class='sub-desc'><p><code>true</code> to prevent the scheme part of\n  a URL match from being displayed to the user. Example:\n  <code>'http://google.com'</code> will be displayed as <code>'google.com'</code>. <code>false</code> to\n  not strip the scheme. NOTE: Only an <code>'http://'</code> or <code>'https://'</code> scheme\n  will be removed, so as not to remove a potentially dangerous scheme\n  (such as <code>'file://'</code> or <code>'javascript:'</code>)</p>\n</div></li><li><span class='pre'>www</span> : Boolean (optional)<div class='sub-desc'><p>www (Boolean): <code>true</code> to prevent the\n  <code>'www.'</code> part of a URL match from being displayed to the user. Ex:\n  <code>'www.google.com'</code> will be displayed as <code>'google.com'</code>. <code>false</code> to not\n  strip the <code>'www'</code>.</p>\n</div></li></ul></div></div></div><div id='cfg-stripTrailingSlash' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-stripTrailingSlash' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-stripTrailingSlash' class='name expandable'>stripTrailingSlash</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>true to remove the trailing slash from URL matches, false to keep\n the trailing slash. ...</div><div class='long'><p><code>true</code> to remove the trailing slash from URL matches, <code>false</code> to keep\n the trailing slash.</p>\n\n<p> Example when <code>true</code>: <code>http://google.com/</code> will be displayed as\n <code>http://google.com</code>.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-truncate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-truncate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-truncate' class='name expandable'>truncate</a> : Number/Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Number Form\n\nA number for how many characters matched text should be truncated to\ninside the text of a link. ...</div><div class='long'><h2>Number Form</h2>\n\n<p>A number for how many characters matched text should be truncated to\ninside the text of a link. If the matched text is over this number of\ncharacters, it will be truncated to this length by adding a two period\nellipsis ('..') to the end of the string.</p>\n\n<p>For example: A url like 'http://www.yahoo.com/some/long/path/to/a/file'\ntruncated to 25 characters might look something like this:\n'yahoo.com/some/long/pat..'</p>\n\n<p>Example Usage:</p>\n\n<pre><code>truncate: 25\n</code></pre>\n\n<p> Defaults to <code>0</code> for \"no truncation.\"</p>\n\n<h2>Object Form</h2>\n\n<p>An Object may also be provided with two properties: <code>length</code> (Number) and\n<code>location</code> (String). <code>location</code> may be one of the following: 'end'\n(default), 'middle', or 'smart'.</p>\n\n<p>Example Usage:</p>\n\n<pre><code>truncate: { length: 25, location: 'middle' }\n</code></pre>\n<p>Defaults to: <code>0</code></p><ul><li><span class='pre'>length</span> : Number (optional)<div class='sub-desc'><p>How many characters to allow before\n  truncation will occur. Defaults to <code>0</code> for \"no truncation.\"</p>\n<p>Defaults to: <code>0</code></p></div></li><li><span class='pre'>location</span> : \"end\"/\"middle\"/\"smart\" (optional)<div class='sub-desc'><ul>\n<li>'end' (default): will truncate up to the number of characters, and then\nadd an ellipsis at the end. Ex: 'yahoo.com/some/long/pat..'</li>\n<li>'middle': will truncate and add the ellipsis in the middle. Ex:\n'yahoo.com/s..th/to/a/file'</li>\n<li>'smart': for URLs where the algorithm attempts to strip out unnecessary\nparts first (such as the 'www.', then URL scheme, hash, etc.),\nattempting to make the URL human-readable before looking for a good\npoint to insert the ellipsis if it is still too long. Ex:\n'yahoo.com/some..to/a/file'. For more details, see\nAutolinker.truncate.TruncateSmart.</li>\n</ul>\n\n<p>Defaults to: <code>&quot;end&quot;</code></p></div></li></ul></div></div></div><div id='cfg-urls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-cfg-urls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-cfg-urls' class='name expandable'>urls</a> : Boolean/Object<span class=\"signature\"></span></div><div class='description'><div class='short'>true if URLs should be automatically linked, false if they should not\nbe. ...</div><div class='long'><p><code>true</code> if URLs should be automatically linked, <code>false</code> if they should not\nbe. Defaults to <code>true</code>.</p>\n\n<p>Examples:</p>\n\n<pre><code>urls: true\n\n// or\n\nurls: {\n    schemeMatches : true,\n    wwwMatches    : true,\n    tldMatches    : true\n}\n</code></pre>\n\n<p>As shown above, this option also accepts an Object form with 3 properties\nto allow for more customization of what exactly gets linked. All default\nto <code>true</code>:</p>\n<p>Defaults to: <code>{}</code></p><ul><li><span class='pre'>schemeMatches</span> : Boolean (optional)<div class='sub-desc'><p><code>true</code> to match URLs found prefixed\n  with a scheme, i.e. <code>http://google.com</code>, or <code>other+scheme://google.com</code>,\n  <code>false</code> to prevent these types of matches.</p>\n</div></li><li><span class='pre'>wwwMatches</span> : Boolean (optional)<div class='sub-desc'><p><code>true</code> to match urls found prefixed with\n  <code>'www.'</code>, i.e. <code>www.google.com</code>. <code>false</code> to prevent these types of\n  matches. Note that if the URL had a prefixed scheme, and\n  <code>schemeMatches</code> is true, it will still be linked.</p>\n</div></li><li><span class='pre'>tldMatches</span> : Boolean (optional)<div class='sub-desc'><p><code>true</code> to match URLs with known top\n  level domains (.com, .net, etc.) that are not prefixed with a scheme or\n  <code>'www.'</code>. This option attempts to match anything that looks like a URL\n  in the given text. Ex: <code>google.com</code>, <code>asdf.org/?page=1</code>, etc. <code>false</code>\n  to prevent these types of matches.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance properties</h3><div id='property-matchers' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-property-matchers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-property-matchers' class='name expandable'>matchers</a> : <a href=\"#!/api/Autolinker.matcher.Matcher\" rel=\"Autolinker.matcher.Matcher\" class=\"docClass\">Autolinker.matcher.Matcher</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>The Autolinker.matcher.Matcher instances for this Autolinker\ninstance. ...</div><div class='long'><p>The <a href=\"#!/api/Autolinker.matcher.Matcher\" rel=\"Autolinker.matcher.Matcher\" class=\"docClass\">Autolinker.matcher.Matcher</a> instances for this Autolinker\ninstance.</p>\n\n<p>This is lazily created in <a href=\"#!/api/Autolinker-method-getMatchers\" rel=\"Autolinker-method-getMatchers\" class=\"docClass\">getMatchers</a>.</p>\n</div></div></div><div id='property-tagBuilder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-property-tagBuilder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-property-tagBuilder' class='name expandable'>tagBuilder</a> : <a href=\"#!/api/Autolinker.AnchorTagBuilder\" rel=\"Autolinker.AnchorTagBuilder\" class=\"docClass\">Autolinker.AnchorTagBuilder</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>The AnchorTagBuilder instance used to build match replacement anchor tags. ...</div><div class='long'><p>The AnchorTagBuilder instance used to build match replacement anchor tags.\nNote: this is lazily instantiated in the <a href=\"#!/api/Autolinker-method-getTagBuilder\" rel=\"Autolinker-method-getTagBuilder\" class=\"docClass\">getTagBuilder</a> method.</p>\n</div></div></div><div id='property-version' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-property-version' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-property-version' class='name expandable'>version</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>The Autolinker version number exposed on the instance itself. ...</div><div class='long'><p>The Autolinker version number exposed on the instance itself.</p>\n\n<p>Ex: 0.25.1</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static properties</h3><div id='static-property-version' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-static-property-version' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-static-property-version' class='name expandable'>version</a> : String<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>The Autolinker version number in the form major.minor.patch\n\nEx: 0.25.1 ...</div><div class='long'><p>The Autolinker version number in the form major.minor.patch</p>\n\n<p>Ex: 0.25.1</p>\n<p>Defaults to: <code>&#39;3.11.1&#39;</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Autolinker-method-constructor' class='name expandable'>Autolinker</a>( <span class='pre'>[cfg]</span> ) : <a href=\"#!/api/Autolinker\" rel=\"Autolinker\" class=\"docClass\">Autolinker</a><span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object (optional)<div class='sub-desc'><p>The configuration options for the Autolinker instance,\n  specified in an Object (map).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker\" rel=\"Autolinker\" class=\"docClass\">Autolinker</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-compactMatches' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-compactMatches' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-compactMatches' class='name expandable'>compactMatches</a>( <span class='pre'>matches</span> ) : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>After we have found all matches, we need to remove matches that overlap\nwith a previous match. ...</div><div class='long'><p>After we have found all matches, we need to remove matches that overlap\nwith a previous match. This can happen for instance with URLs, where the\nurl 'google.com/<a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a>' would match '<a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a>' as a hashtag. Because the\n'<a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a>' part is contained in a larger match that comes before the HashTag\nmatch, we'll remove the HashTag match.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>matches</span> : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createMatchReturnVal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-createMatchReturnVal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-createMatchReturnVal' class='name expandable'>createMatchReturnVal</a>( <span class='pre'>match</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates the return string value for a given match in the input string. ...</div><div class='long'><p>Creates the return string value for a given match in the input string.</p>\n\n<p>This method handles the <a href=\"#!/api/Autolinker-cfg-replaceFn\" rel=\"Autolinker-cfg-replaceFn\" class=\"docClass\">replaceFn</a>, if one was provided.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>match</span> : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a><div class='sub-desc'><p>The Match object that represents\n  the match.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The string that the <code>match</code> should be replaced with.\n  This is usually the anchor tag string, but may be the <code>matchStr</code> itself\n  if the match is not to be replaced.</p>\n</div></li></ul></div></div></div><div id='method-getMatchers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-getMatchers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-getMatchers' class='name expandable'>getMatchers</a>( <span class='pre'></span> ) : <a href=\"#!/api/Autolinker.matcher.Matcher\" rel=\"Autolinker.matcher.Matcher\" class=\"docClass\">Autolinker.matcher.Matcher</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Lazily instantiates and returns the Autolinker.matcher.Matcher\ninstances for this Autolinker instance. ...</div><div class='long'><p>Lazily instantiates and returns the <a href=\"#!/api/Autolinker.matcher.Matcher\" rel=\"Autolinker.matcher.Matcher\" class=\"docClass\">Autolinker.matcher.Matcher</a>\ninstances for this Autolinker instance.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.matcher.Matcher\" rel=\"Autolinker.matcher.Matcher\" class=\"docClass\">Autolinker.matcher.Matcher</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTagBuilder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-getTagBuilder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-getTagBuilder' class='name expandable'>getTagBuilder</a>( <span class='pre'></span> ) : <a href=\"#!/api/Autolinker.AnchorTagBuilder\" rel=\"Autolinker.AnchorTagBuilder\" class=\"docClass\">Autolinker.AnchorTagBuilder</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the tagBuilder instance for this Autolinker instance,\nlazily instantiating it if it does not yet exist. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Autolinker-property-tagBuilder\" rel=\"Autolinker-property-tagBuilder\" class=\"docClass\">tagBuilder</a> instance for this Autolinker instance,\nlazily instantiating it if it does not yet exist.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.AnchorTagBuilder\" rel=\"Autolinker.AnchorTagBuilder\" class=\"docClass\">Autolinker.AnchorTagBuilder</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-link' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-link' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-link' class='name expandable'>link</a>( <span class='pre'>textOrHtml</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Automatically links URLs, Email addresses, Phone numbers, Hashtags,\nand Mentions (Twitter, Instagram, Soundcloud) fou...</div><div class='long'><p>Automatically links URLs, Email addresses, Phone numbers, Hashtags,\nand Mentions (Twitter, Instagram, Soundcloud) found in the given chunk of HTML. Does not link\nURLs found within HTML tags.</p>\n\n<p>For instance, if given the text: <code>You should go to http://www.yahoo.com</code>,\nthen the result will be <code>You should go to\n&amp;lt;a href=\"http://www.yahoo.com\"&amp;gt;http://www.yahoo.com&amp;lt;/a&amp;gt;</code></p>\n\n<p>This method finds the text around any HTML elements in the input\n<code>textOrHtml</code>, which will be the text that is processed. Any original HTML\nelements will be left as-is, as well as the text that is already wrapped\nin anchor (&lt;a&gt;) tags.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>textOrHtml</span> : String<div class='sub-desc'><p>The HTML or text to autolink matches within\n  (depending on if the <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a>, <a href=\"#!/api/Autolinker-cfg-email\" rel=\"Autolinker-cfg-email\" class=\"docClass\">email</a>, <a href=\"#!/api/Autolinker-cfg-phone\" rel=\"Autolinker-cfg-phone\" class=\"docClass\">phone</a>, <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtag</a>, and <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a> options are enabled).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The HTML, with matches automatically linked.</p>\n</div></li></ul></div></div></div><div id='method-normalizeStripPrefixCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-normalizeStripPrefixCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-normalizeStripPrefixCfg' class='name expandable'>normalizeStripPrefixCfg</a>( <span class='pre'>stripPrefix</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Normalizes the stripPrefix config into an Object with 2\nproperties: scheme, and www - both Booleans. ...</div><div class='long'><p>Normalizes the <a href=\"#!/api/Autolinker-cfg-stripPrefix\" rel=\"Autolinker-cfg-stripPrefix\" class=\"docClass\">stripPrefix</a> config into an Object with 2\nproperties: <code>scheme</code>, and <code>www</code> - both Booleans.</p>\n\n<p>See <a href=\"#!/api/Autolinker-cfg-stripPrefix\" rel=\"Autolinker-cfg-stripPrefix\" class=\"docClass\">stripPrefix</a> config for details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>stripPrefix</span> : Boolean/Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-normalizeTruncateCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-normalizeTruncateCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-normalizeTruncateCfg' class='name expandable'>normalizeTruncateCfg</a>( <span class='pre'>truncate</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Normalizes the truncate config into an Object with 2 properties:\nlength (Number), and location (String). ...</div><div class='long'><p>Normalizes the <a href=\"#!/api/Autolinker-cfg-truncate\" rel=\"Autolinker-cfg-truncate\" class=\"docClass\">truncate</a> config into an Object with 2 properties:\n<code>length</code> (Number), and <code>location</code> (String).</p>\n\n<p>See <a href=\"#!/api/Autolinker-cfg-truncate\" rel=\"Autolinker-cfg-truncate\" class=\"docClass\">truncate</a> config for details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>truncate</span> : Number/Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-normalizeUrlsCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-normalizeUrlsCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-normalizeUrlsCfg' class='name expandable'>normalizeUrlsCfg</a>( <span class='pre'>urls</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Normalizes the urls config into an Object with 3 properties:\nschemeMatches, wwwMatches, and tldMatches, all Booleans. ...</div><div class='long'><p>Normalizes the <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a> config into an Object with 3 properties:\n<code>schemeMatches</code>, <code>wwwMatches</code>, and <code>tldMatches</code>, all Booleans.</p>\n\n<p>See <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a> config for details.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>urls</span> : Boolean/Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-parse' class='name expandable'>parse</a>( <span class='pre'>textOrHtml</span> ) : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses the input textOrHtml looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (dependi...</div><div class='long'><p>Parses the input <code>textOrHtml</code> looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (depending on the configuration\nof the Autolinker instance), and returns an array of <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>\nobjects describing those matches (without making any replacements).</p>\n\n<p>This method is used by the <a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a> method, but can also be used to\nsimply do parsing of the input in order to discover what kinds of links\nthere are and how many.</p>\n\n<p>Example usage:</p>\n\n<pre><code>var autolinker = new Autolinker( {\n    urls: true,\n    email: true\n} );\n\nvar matches = autolinker.parse( \"Hello google.com, I am asdf@asdf.com\" );\n\nconsole.log( matches.length );           // 2\nconsole.log( matches[ 0 ].getType() );   // 'url'\nconsole.log( matches[ 0 ].getUrl() );    // 'google.com'\nconsole.log( matches[ 1 ].getType() );   // 'email'\nconsole.log( matches[ 1 ].getEmail() );  // 'asdf@asdf.com'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>textOrHtml</span> : String<div class='sub-desc'><p>The HTML or text to find matches within\n  (depending on if the <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a>, <a href=\"#!/api/Autolinker-cfg-email\" rel=\"Autolinker-cfg-email\" class=\"docClass\">email</a>, <a href=\"#!/api/Autolinker-cfg-phone\" rel=\"Autolinker-cfg-phone\" class=\"docClass\">phone</a>,\n  <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtag</a>, and <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a> options are enabled).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]</span><div class='sub-desc'><p>The array of Matches found in the\n  given input <code>textOrHtml</code>.</p>\n</div></li></ul></div></div></div><div id='method-parseText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-parseText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-parseText' class='name expandable'>parseText</a>( <span class='pre'>text, [offset]</span> ) : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Parses the input text looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (depending on ...</div><div class='long'><p>Parses the input <code>text</code> looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (depending on the configuration\nof the Autolinker instance), and returns an array of <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>\nobjects describing those matches.</p>\n\n<p>This method processes a <strong>non-HTML string</strong>, and is used to parse and\nmatch within the text nodes of an HTML string. This method is used\ninternally by <a href=\"#!/api/Autolinker-method-parse\" rel=\"Autolinker-method-parse\" class=\"docClass\">parse</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : String<div class='sub-desc'><p>The text to find matches within (depending on if the\n  <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a>, <a href=\"#!/api/Autolinker-cfg-email\" rel=\"Autolinker-cfg-email\" class=\"docClass\">email</a>, <a href=\"#!/api/Autolinker-cfg-phone\" rel=\"Autolinker-cfg-phone\" class=\"docClass\">phone</a>,\n  <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtag</a>, and <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a> options are enabled). This must be a non-HTML string.</p>\n</div></li><li><span class='pre'>offset</span> : Number (optional)<div class='sub-desc'><p>The offset of the text node within the\n  original string. This is used when parsing with the <a href=\"#!/api/Autolinker-method-parse\" rel=\"Autolinker-method-parse\" class=\"docClass\">parse</a>\n  method to generate correct offsets within the <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>\n  instances, but may be omitted if calling this method publicly.</p>\n<p>Defaults to: <code>0</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]</span><div class='sub-desc'><p>The array of Matches found in the\n  given input <code>text</code>.</p>\n</div></li></ul></div></div></div><div id='method-removeUnwantedMatches' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-method-removeUnwantedMatches' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-method-removeUnwantedMatches' class='name expandable'>removeUnwantedMatches</a>( <span class='pre'>matches</span> ) : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Removes matches for matchers that were turned off in the options. ...</div><div class='long'><p>Removes matches for matchers that were turned off in the options. For\nexample, if <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtags</a> were not to be matched, we'll\nremove them from the <code>matches</code> array here.</p>\n\n<p>Note: we <em>must</em> use all Matchers on the input string, and then filter\nthem out later. For example, if the options were <code>{ url: false, hashtag: true }</code>,\nwe wouldn't want to match the text '<a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a>' as a HashTag inside of the text\n'google.com/<a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">link</a>'. The way the algorithm works is that we match the full\nURL first (which prevents the accidental HashTag match), and then we'll\nsimply throw away the URL match.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>matches</span> : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<div class='sub-desc'><p>The array of matches to remove\n  the unwanted matches from. Note: this array is mutated for the\n  removals.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]</span><div class='sub-desc'><p>The mutated input <code>matches</code> array.</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-link' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-static-method-link' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-static-method-link' class='name expandable'>link</a>( <span class='pre'>textOrHtml, [options]</span> ) : String<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>Automatically links URLs, Email addresses, Phone Numbers, Twitter handles,\nHashtags, and Mentions found in the given ...</div><div class='long'><p>Automatically links URLs, Email addresses, Phone Numbers, Twitter handles,\nHashtags, and Mentions found in the given chunk of HTML. Does not link URLs\nfound within HTML tags.</p>\n\n<p>For instance, if given the text: <code>You should go to http://www.yahoo.com</code>,\nthen the result will be <code>You should go to &amp;lt;a href=\"http://www.yahoo.com\"&amp;gt;http://www.yahoo.com&amp;lt;/a&amp;gt;</code></p>\n\n<p>Example:</p>\n\n<pre><code>var linkedText = <a href=\"#!/api/Autolinker-method-link\" rel=\"Autolinker-method-link\" class=\"docClass\">Autolinker.link</a>( \"Go to google.com\", { newWindow: false } );\n// Produces: \"Go to &lt;a href=\"http://google.com\"&gt;google.com&lt;/a&gt;\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>textOrHtml</span> : String<div class='sub-desc'><p>The HTML or text to find matches within (depending\n  on if the <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a>, <a href=\"#!/api/Autolinker-cfg-email\" rel=\"Autolinker-cfg-email\" class=\"docClass\">email</a>, <a href=\"#!/api/Autolinker-cfg-phone\" rel=\"Autolinker-cfg-phone\" class=\"docClass\">phone</a>, <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a>,\n  <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtag</a>, and <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a> options are enabled).</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>Any of the configuration options for the Autolinker\n  class, specified in an Object (map). See the class description for an\n  example call.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The HTML text, with matches automatically linked.</p>\n</div></li></ul></div></div></div><div id='static-method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Autolinker'>Autolinker</span><br/><a href='source/autolinker.html#Autolinker-static-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Autolinker-static-method-parse' class='name expandable'>parse</a>( <span class='pre'>textOrHtml, [options]</span> ) : <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>Parses the input textOrHtml looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (dependi...</div><div class='long'><p>Parses the input <code>textOrHtml</code> looking for URLs, email addresses, phone\nnumbers, username handles, and hashtags (depending on the configuration\nof the Autolinker instance), and returns an array of <a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>\nobjects describing those matches (without making any replacements).</p>\n\n<p>Note that if parsing multiple pieces of text, it is slightly more efficient\nto create an Autolinker instance, and use the instance-level <a href=\"#!/api/Autolinker-method-parse\" rel=\"Autolinker-method-parse\" class=\"docClass\">parse</a>\nmethod.</p>\n\n<p>Example:</p>\n\n<pre><code>var matches = <a href=\"#!/api/Autolinker-method-parse\" rel=\"Autolinker-method-parse\" class=\"docClass\">Autolinker.parse</a>( \"Hello google.com, I am asdf@asdf.com\", {\n    urls: true,\n    email: true\n} );\n\nconsole.log( matches.length );           // 2\nconsole.log( matches[ 0 ].getType() );   // 'url'\nconsole.log( matches[ 0 ].getUrl() );    // 'google.com'\nconsole.log( matches[ 1 ].getType() );   // 'email'\nconsole.log( matches[ 1 ].getEmail() );  // 'asdf@asdf.com'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>textOrHtml</span> : String<div class='sub-desc'><p>The HTML or text to find matches within\n  (depending on if the <a href=\"#!/api/Autolinker-cfg-urls\" rel=\"Autolinker-cfg-urls\" class=\"docClass\">urls</a>, <a href=\"#!/api/Autolinker-cfg-email\" rel=\"Autolinker-cfg-email\" class=\"docClass\">email</a>, <a href=\"#!/api/Autolinker-cfg-phone\" rel=\"Autolinker-cfg-phone\" class=\"docClass\">phone</a>,\n  <a href=\"#!/api/Autolinker-cfg-hashtag\" rel=\"Autolinker-cfg-hashtag\" class=\"docClass\">hashtag</a>, and <a href=\"#!/api/Autolinker-cfg-mention\" rel=\"Autolinker-cfg-mention\" class=\"docClass\">mention</a> options are enabled).</p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>Any of the configuration options for the Autolinker\n  class, specified in an Object (map). See the class description for an\n  example call.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Autolinker.match.Match\" rel=\"Autolinker.match.Match\" class=\"docClass\">Autolinker.match.Match</a>[]</span><div class='sub-desc'><p>The array of Matches found in the\n  given input <code>textOrHtml</code>.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});