(function(w) {
  var
    publicMethods = [
      'addHook',
      'addHookOnce',
      'alter',
      'clear',
      'clearUndo',
      'colOffset',
      'colToProp',
      'countCols',
      'countEmptyCols',
      'countEmptyRows',
      'countRenderedCols',
      'countRenderedRows',
      'countRows',
      'countSourceCols',
      'countSourceRows',
      'countVisibleCols',
      'countVisibleRows',
      'deselectCell',
      'destroy',
      'destroyEditor',
      'emptySelectedCells',
      'getActiveEditor',
      'getCell',
      'getCellEditor',
      'getCellMeta',
      'getCellMetaAtRow',
      'getCellRenderer',
      'getCellValidator',
      'getCellsMeta',
      'getColHeader',
      'getColWidth',
      'getCoords',
      'getCopyableData',
      'getCopyableText',
      'getData',
      'getDataAtCell',
      'getDataAtCol',
      'getDataAtProp',
      'getDataAtRow',
      'getDataAtRowProp',
      'getDataType',
      'getInstance',
      'getPlugin',
      'getRowHeader',
      'getRowHeight',
      'getSchema',
      'getSelected',
      'getSelectedLast',
      'getSelectedRange',
      'getSelectedRangeLast',
      'getSettings',
      'getSourceData',
      'getSourceDataArray',
      'getSourceDataAtCell',
      'getSourceDataAtCol',
      'getSourceDataAtRow',
      'getTranslatedPhrase',
      'getValue',
      'hasColHeaders',
      'hasHook',
      'hasRowHeaders',
      // 'init', // Conflicted method
      'isColumnModificationAllowed',
      'isEmptyCol',
      'isEmptyRow',
      'isListening',
      'isRedoAvailable',
      'isUndoAvailable',
      'listen',
      'loadData',
      'populateFromArray',
      'propToCol',
      'redo',
      'removeCellMeta',
      'removeHook',
      'render',
      'rowOffset',
      'runHooks',
      'scrollViewportTo',
      'selectAll',
      'selectCell',
      'selectCellByProp',
      'selectCells',
      'selectColumns',
      'selectRows',
      'setCellMeta',
      'setCellMetaObject',
      'setDataAtCell',
      'setDataAtRowProp',
      'spliceCellsMeta',
      'spliceCol',
      'spliceRow',
      'toPhysicalColumn',
      'toPhysicalRow',
      'toVisualColumn',
      'toVisualRow',
      'undo',
      'unlisten',
      'updateSettings',
      'validateCell',
      'validateCells',
      'validateColumns',
      'validateRows'
    ];

  var PublicMethodsBehavior = {};

  publicMethods.forEach(function(method) {
    PublicMethodsBehavior[method] = function() {
      return this.hot[method].apply(this.hot, arguments);
    };
  });

  w.HotTableUtils = w.HotTableUtils || {};
  w.HotTableUtils.behaviors = w.HotTableUtils.behaviors || {};
  w.HotTableUtils.behaviors.PublicMethodsBehavior = PublicMethodsBehavior;
}(window));
