## Usage examples

**Views**

With [assemble][]:

```js
var assemble = require('assemble');
var app = assemble();

// create a collection (this is already done in assemble)
app.create('partials', {viewType: 'partial'});

// load a template onto the collection
app.partial('foo', {content: '# {{title}}', title: 'Heading'});
```

Use the helper, specify the name of the view you want to convert to HTML

```handlebars
{{md "foo"}}
```

**Files**

Or, you can specify a filepath to include content from external files.

```handlebars
{{md "posts/foo.md"}}
```

Both result in something like:


```html
<h1>Heading</h1>
```
