## Usage

The main export is the `log` helper function with other helpers decorated as properties on this function. Some apps, like [assemble][], [verb][] and [generate][] support this format. However, a non-enumberalbe `toObject` method is exposed for registering directly with engines like [handlebars][]

Example:

```js
var loggingHelpers = require('logging-helpers');
var hbs = require('handlebars');

hbs.registerHelper('log', helpers);
// register all of the other helpers
hbs.registerHelper(helpers.toObject);
```

## Template examples

Handlebars:

```handlebars
{{log "%s" "this is a message"}}
{{info "%s" "this is a message"}}
{{warning "%s" "this is a message"}}
{{warn "%s" "this is a message"}}  <!-- alias for "warning" -->
{{success "%s" "this is a message"}}
{{error "%s" "this is a message"}}
{{danger "%s" "this is a message"}}  <!-- alias for "error" -->
{{ok "%s" "this is a message"}}
{{bold "%s" "this is a message"}}
{{_debug this}}
{{_inspect foo.bar}}
```

Lo-Dash or Underscore:

```html
<%%= log("%s", "this is a message") %>
<%%= info("%s", "this is a message") %>
<%%= warn("%s", "this is a message") %>
<%%= warning("%s", "this is a message") %>
<%%= error("%s", "this is a message") %>
<%%= bold("%s", "this is a message") %>
<%%= _debug(data) %>
<%%= _inspect(foo.bar) %>
```

[Verb][] (uses lodash-style templates, but with special delimiters to avoid delimiter collision in documentation):

```js
{%%= log("%s", "this is a message") %}
{%%= info("%s", "this is a message") %}
{%%= bold("%s", "this is a message") %}
{%%= warn("%s", "this is a message") %}
{%%= error("%s", "this is a message") %}
{%%= debug(data) %}
{%%= inspect(foo.bar) %}
```

## Usage with [assemble][]

This should work with [assemble][], [verb][], [generate][], [update][] or any application based on [templates][].

```js
var helpers = require('{%= name %}');
var assemble = require('assemble');
var app = assemble();
app.helpers(helpers);
```

You can now use the helpers like this:

```handlebars
{{log "%s" "this is a message"}}
{{info "%s" "this is a message"}}
{{warning "%s" "this is a message"}}
{{warn "%s" "this is a message"}}  <!-- alias for "warning" -->
{{success "%s" "this is a message"}}
{{error "%s" "this is a message"}}
{{danger "%s" "this is a message"}}  <!-- alias for "error" -->
{{ok "%s" "this is a message"}}
{{bold "%s" "this is a message"}}
{{_debug this}}
{{_inspect foo.bar}}
```
