## Usage

With [snapdragon][] v0.9.0 and higher you can use `this.node()` to create a new `Node`, whenever it makes sense.

```js
var Node = require('{%= name %}');
var Snapdragon = require('snapdragon');
var snapdragon = new Snapdragon();

// example usage inside a parser visitor function
snapdragon.parser.set('foo', function() {
  // get the current "start" position
  var pos = this.position();

  // returns the match if regex matches the substring 
  // at the current position on `parser.input`
  var match = this.match(/foo/);
  if (match) {
    // call "pos" on the node, to set the start and end 
    // positions, and return the node to push it onto the AST
    // (snapdragon will push the node onto the correct
    // nodes array, based on the stack)
    return pos(new Node({type: 'bar', val: match[0]}));
  }
});
```

## API
{%= apidocs("index.js") %}

## Release history

Changelog entries are classified using the following labels from [keep-a-changelog][]:

* `added`: for new features
* `changed`: for changes in existing functionality
* `deprecated`: for once-stable features removed in upcoming releases
* `removed`: for deprecated features removed in this release
* `fixed`: for any bug fixes

Custom labels used in this changelog:

* `dependencies`: bumps dependencies
* `housekeeping`: code re-organization, minor edits, or other changes that don't fit in one of the other categories.

### [2.0.0] - 2017-05-01

**Changed**

- `.unshiftNode` was renamed to [.unshift](#unshift)
- `.pushNode` was renamed to [.push](#push)
- `.getNode` was renamed to [.find](#find)

**Added**

- [.isNode](#isNode)
- [.isEmpty](#isEmpty)
- [.pop](#pop)
- [.shift](#shift)
- [.remove](#remove)

### [0.1.0]

First release.

[keep-a-changelog]: https://github.com/olivierlacan/keep-a-changelog
