/*
 * Copyright (C) 2017-2019 HERE Europe B.V.
 * Licensed under Apache 2.0, see full license in LICENSE
 * SPDX-License-Identifier: Apache-2.0
 */
import { MultiPolygon } from "@here/harp-datasource-protocol";

const italy = [
    [
        [
            [15.520376010813834, 38.23115509699147],
            [15.160242954171736, 37.44404551853782],
            [15.309897902089006, 37.1342194687318],
            [15.099988234119449, 36.6199872909954],
            [14.335228712632016, 36.996630967754754],
            [13.826732618879928, 37.10453135838019],
            [12.431003859108813, 37.61294993748381],
            [12.570943637755136, 38.12638113051968],
            [13.741156447004585, 38.03496552179536],
            [14.76124922044616, 38.143873602850505],
            [15.520376010813834, 38.23115509699147]
        ]
    ],
    [
        [
            [9.210011834356266, 41.20999136002422],
            [9.809975213264977, 40.5000088567661],
            [9.669518670295673, 39.177376410471794],
            [9.21481774255949, 39.240473334300134],
            [8.80693566247973, 38.90661774347847],
            [8.428302443077115, 39.17184703221662],
            [8.38825320805094, 40.378310858718805],
            [8.15999840661766, 40.95000722916379],
            [8.709990675500109, 40.89998444270523],
            [9.210011834356266, 41.20999136002422]
        ]
    ],
    [
        [
            [12.376485223040843, 46.76755910906987],
            [13.806475457421556, 46.50930613869119],
            [13.698109978905478, 46.016778062517375],
            [13.937630242578335, 45.591015936864665],
            [13.141606479554298, 45.73669179949541],
            [12.328581170306306, 45.38177806251485],
            [12.383874952858605, 44.88537425391908],
            [12.261453484759159, 44.600482082694015],
            [12.589237094786483, 44.091365871754476],
            [13.526905958722494, 43.5877273626379],
            [14.029820997787027, 42.76100779883248],
            [15.142569614327956, 41.955139675456905],
            [15.926191033601896, 41.96131500911574],
            [16.169897088290412, 41.74029490820342],
            [15.889345737377797, 41.5410822617182],
            [16.785001661860576, 41.179605617836586],
            [17.519168735431208, 40.87714345963224],
            [18.376687452882575, 40.35562490494266],
            [18.4802470231954, 40.168866278639825],
            [18.293385044028096, 39.81077444107325],
            [17.738380161213286, 40.2776710068303],
            [16.869595981522338, 40.44223460546385],
            [16.448743116937322, 39.79540070246648],
            [17.1714896989715, 39.42469981542072],
            [17.05284061042934, 38.9028712021373],
            [16.635088331781844, 38.8435724960824],
            [16.100960727613057, 37.98589874933418],
            [15.684086948314501, 37.90884918878703],
            [15.687962680736321, 38.214592800441864],
            [15.891981235424707, 38.750942491199226],
            [16.109332309644312, 38.96454702407769],
            [15.718813510814641, 39.544072374014945],
            [15.413612501698822, 40.04835683853517],
            [14.998495721098237, 40.17294871679093],
            [14.70326826341477, 40.604550279292624],
            [14.060671827865264, 40.78634796809544],
            [13.627985060285397, 41.188287258461656],
            [12.88808190273042, 41.25308950455562],
            [12.10668257004491, 41.70453481705741],
            [11.191906365614187, 42.35542531998967],
            [10.511947869517797, 42.931462510747224],
            [10.200028924204048, 43.920006822274615],
            [9.702488234097814, 44.03627879493132],
            [8.88894616052687, 44.36633616797954],
            [8.428560825238577, 44.23122813575242],
            [7.850766635783201, 43.76714793555524],
            [7.435184767291843, 43.69384491634918],
            [7.549596388386163, 44.12790110938482],
            [7.007562290076663, 44.25476675066139],
            [6.749955275101711, 45.02851797136759],
            [7.096652459347837, 45.333098863295874],
            [6.802355177445662, 45.70857982032867],
            [6.843592970414562, 45.99114655210067],
            [7.273850945676685, 45.77694774025076],
            [7.755992058959833, 45.82449005795928],
            [8.31662967289438, 46.163642483090854],
            [8.489952426801295, 46.00515086525175],
            [8.966305779667834, 46.036931871111165],
            [9.182881707403112, 46.44021474871698],
            [9.922836541390353, 46.31489940040919],
            [10.363378126678668, 46.483571275409844],
            [10.442701450246602, 46.893546250997446],
            [11.048555942436508, 46.7513585475464],
            [11.164827915093326, 46.94157949481274],
            [12.153088006243081, 47.11539317482644],
            [12.376485223040843, 46.76755910906987]
        ]
    ]
];
const france = [
    [
        [
            [163.98193359375, -20.050771131126798],
            [164.15222167968747, -20.452749362534945],
            [164.586181640625, -20.96143961409684],
            [165.03662109375, -21.37124437061831],
            [166.4044189453125, -22.304343762932206],
            [166.9207763671875, -22.451648819126202],
            [167.0635986328125, -22.2992614997412],
            [166.9317626953125, -22.085639901650328],
            [165.355224609375, -20.935789244893726],
            [165.234375, -20.776659051878816],
            [164.300537109375, -20.21581109239457],
            [163.98193359375, -20.050771131126798]
        ]
    ],
    [
        [
            [-149.75601196289062, -17.489530732385404],
            [-149.91806030273438, -17.498699145678742],
            [-149.81231689453125, -17.596903076749182],
            [-149.75601196289062, -17.489530732385404]
        ]
    ],
    [
        [
            [-149.49508666992185, -17.5065574175233],
            [-149.6173095703125, -17.549771832589155],
            [-149.578857421875, -17.744762830153043],
            [-149.47723388671875, -17.785304836705027],
            [-149.32205200195312, -17.74083892258535],
            [-149.27947998046875, -17.844139760787332],
            [-149.1558837890625, -17.88465917954279],
            [-149.12841796875, -17.77353552371928],
            [-149.30007934570312, -17.721218095446066],
            [-149.30831909179688, -17.577266550648865],
            [-149.4140625, -17.51441534942315],
            [-149.49508666992185, -17.5065574175233]
        ]
    ],
    [
        [
            [68.9556884765625, -48.67826727167941],
            [68.79913330078125, -48.855679899769],
            [68.73870849609375, -49.06486885623367],
            [68.653564453125, -49.343020022896745],
            [68.75518798828125, -49.71027258210569],
            [68.9996337890625, -49.719152198289635],
            [69.26605224609375, -49.55016177711198],
            [69.46105957031249, -49.649848130257666],
            [70.103759765625, -49.740456653396414],
            [70.30426025390625, -49.58044524888519],
            [70.13671875, -49.42169406084924],
            [70.44708251953125, -49.43419877248739],
            [70.55419921875, -49.17272588782557],
            [70.3179931640625, -49.0558701819386],
            [69.70550537109375, -49.300053812446876],
            [69.598388671875, -48.96038404976429],
            [69.4171142578125, -48.832181625698475],
            [68.9556884765625, -48.67826727167941]
        ]
    ],
    [
        [
            [55.41229248046875, -20.88190917234547],
            [55.28594970703124, -20.9216796686097],
            [55.21728515625, -21.056307701901847],
            [55.28594970703124, -21.213860027911707],
            [55.498809814453125, -21.34054846908118],
            [55.6787109375, -21.372523226942395],
            [55.798187255859375, -21.334152680460594],
            [55.83526611328124, -21.156238366109417],
            [55.704803466796875, -21.026828137124237],
            [55.63201904296875, -20.906285888501603],
            [55.41229248046875, -20.88190917234547]
        ]
    ],
    [
        [
            [-61.47125244140625, 16.505882771835157],
            [-61.53991699218749, 16.454524718662547],
            [-61.52618408203125, 16.399200837347113],
            [-61.494598388671875, 16.34649680535433],
            [-61.52481079101562, 16.337272136282255],
            [-61.59484863281249, 16.268732408212443],
            [-61.6058349609375, 16.30168719358391],
            [-61.732177734375, 16.358356454087513],
            [-61.80496215820312, 16.303005269783544],
            [-61.755523681640625, 16.024695711685315],
            [-61.70333862304687, 15.950766025306109],
            [-61.560516357421875, 16.040534227979762],
            [-61.57699584960937, 16.231816480991775],
            [-61.46163940429687, 16.194893627937656],
            [-61.25701904296875, 16.247638441537],
            [-61.170501708984375, 16.242364596100327],
            [-61.32019042968749, 16.334636436572566],
            [-61.3861083984375, 16.342543429076194],
            [-61.403961181640625, 16.386026165001066],
            [-61.39846801757812, 16.443988051131818],
            [-61.435546875, 16.490081744746746],
            [-61.47125244140625, 16.505882771835157]
        ]
    ],
    [
        [
            [-61.0125732421875, 16.34649680535433],
            [-61.08810424804687, 16.313549560062796],
            [-61.09771728515625, 16.291142264799106],
            [-61.00433349609375, 16.32804703184379],
            [-61.0125732421875, 16.34649680535433]
        ]
    ],
    [
        [
            [-61.28448486328125, 16.000935579586685],
            [-61.332550048828125, 15.929638243169189],
            [-61.32156372070312, 15.875488156944243],
            [-61.248779296875, 15.867562531879626],
            [-61.19659423828124, 15.928317682918626],
            [-61.23504638671874, 15.985093921369806],
            [-61.28448486328125, 16.000935579586685]
        ]
    ],
    [
        [
            [-61.16363525390625, 14.875778165434696],
            [-61.21307373046874, 14.857195658870625],
            [-61.217193603515625, 14.78019397569999],
            [-61.18148803710937, 14.739026694833317],
            [-61.1773681640625, 14.696523273864466],
            [-61.08810424804687, 14.599531422729925],
            [-61.019439697265625, 14.60218930495232],
            [-60.97824096679687, 14.550354814393097],
            [-60.9906005859375, 14.526427094814961],
            [-61.05514526367187, 14.551684056143447],
            [-61.1004638671875, 14.515791721361213],
            [-61.05514526367187, 14.453298590545614],
            [-61.019439697265625, 14.485212176561356],
            [-60.86288452148438, 14.467926220174364],
            [-60.88623046875001, 14.41473022788048],
            [-60.849151611328125, 14.393448273221596],
            [-60.81619262695313, 14.483882535418681],
            [-60.89172363281249, 14.664640278887783],
            [-60.94390869140625, 14.675268460270555],
            [-60.90682983398437, 14.699179980225109],
            [-60.882110595703125, 14.774882506516272],
            [-60.9686279296875, 14.746995163665593],
            [-61.066131591796875, 14.855868275768431],
            [-61.16363525390625, 14.875778165434696]
        ]
    ],
    [
        [
            [-56.34544372558594, 47.142095293920434],
            [-56.38938903808594, 47.12668059965203],
            [-56.40106201171875, 47.106120723235996],
            [-56.385269165039055, 47.06404168695503],
            [-56.38114929199218, 47.01069385510927],
            [-56.36535644531249, 47.00741637293773],
            [-56.331024169921875, 46.90149244734082],
            [-56.33995056152344, 46.889762319202845],
            [-56.405181884765625, 46.829194076477336],
            [-56.33583068847656, 46.78877728793222],
            [-56.24382019042969, 46.854556538855746],
            [-56.24794006347656, 46.885538844934],
            [-56.30836486816406, 46.90243074674521],
            [-56.31454467773437, 46.960573239955984],
            [-56.27403259277344, 46.994772772074754],
            [-56.25205993652343, 47.030354524842664],
            [-56.25343322753906, 47.05889641405164],
            [-56.37016296386719, 47.09910985874962],
            [-56.37977600097656, 47.11686892229326],
            [-56.33857727050781, 47.130417905537925],
            [-56.34544372558594, 47.142095293920434]
        ]
    ],
    [
        [
            [-56.16828918457031, 46.823086510328395],
            [-56.25068664550781, 46.761031926011036],
            [-56.14631652832031, 46.75679832604253],
            [-56.16828918457031, 46.823086510328395]
        ]
    ],
    [
        [
            [-178.1927490234375, -14.253735226496016],
            [-178.04718017578125, -14.362851909594287],
            [-177.9840087890625, -14.344225986894427],
            [-178.16802978515625, -14.240424693263597],
            [-178.1927490234375, -14.253735226496016]
        ]
    ],
    [
        [
            [-176.22070312499997, -13.223903512667826],
            [-176.253662109375, -13.325484885597936],
            [-176.17401123046872, -13.381603686232227],
            [-176.121826171875, -13.277372689908304],
            [-176.22070312499997, -13.223903512667826]
        ]
    ],
    [
        [
            [-314.91554260253906, -12.672496436545643],
            [-314.95811462402344, -12.745507104009116],
            [-314.901123046875, -12.773634045919461],
            [-314.9107360839844, -12.853310028976455],
            [-314.84619140625, -12.91890657418042],
            [-314.857177734375, -12.940322128384613],
            [-314.9224090576172, -12.896819860748517],
            [-314.9114227294922, -12.965750710156396],
            [-314.84275817871094, -13.006564840836518],
            [-314.7981262207031, -12.984485897654391],
            [-314.82971191406244, -12.953036743736318],
            [-314.80979919433594, -12.917568041044982],
            [-314.78302001953125, -12.882763664161187],
            [-314.80567932128906, -12.837242952998404],
            [-314.7734069824219, -12.787026728058954],
            [-314.72053527832026, -12.815818588006746],
            [-314.71092224121094, -12.764258746077456],
            [-314.7651672363281, -12.773634045919461],
            [-314.7905731201172, -12.732781984712377],
            [-314.86473083496094, -12.726084296948184],
            [-314.91554260253906, -12.672496436545643]
        ]
    ],
    [
        [
            [-140.25421142578125, -8.800939712392442],
            [-140.18829345703125, -8.963758270450187],
            [-139.99603271484375, -8.874217009053554],
            [-140.18829345703125, -8.765652867885244],
            [-140.25421142578125, -8.800939712392442]
        ]
    ],
    [
        [
            [-139.5703125, -8.871503295265086],
            [-139.63348388671875, -8.91763369639607],
            [-139.581298828125, -8.950192825865779],
            [-139.482421875, -8.914920304406634],
            [-139.5703125, -8.871503295265086]
        ]
    ],
    [
        [
            [-140.07293701171875, -9.340672181980947],
            [-140.1361083984375, -9.384032109601689],
            [-140.0592041015625, -9.465317340414682],
            [-140.020751953125, -9.359642815950744],
            [-140.07293701171875, -9.340672181980947]
        ]
    ],
    [
        [
            [-139.010009765625, -9.709057068618208],
            [-139.17205810546872, -9.784851250750592],
            [-139.0374755859375, -9.86604011578546],
            [-139.00726318359375, -9.801090616449585],
            [-138.8836669921875, -9.814622813899064],
            [-138.77105712890625, -9.765904320896558],
            [-139.010009765625, -9.709057068618208]
        ]
    ],
    [
        [
            [-139.0924072265625, -9.903921416774965],
            [-139.1363525390625, -9.987785857426267],
            [-139.12811279296875, -10.017539021316143],
            [-139.03198242187497, -9.939092995832691],
            [-139.0924072265625, -9.903921416774965]
        ]
    ],
    [
        [
            [-138.68865966796872, -10.42298838833823],
            [-138.68865966796872, -10.531020008464976],
            [-138.63372802734375, -10.547221495690104],
            [-138.60076904296875, -10.441896638117157],
            [-138.68865966796872, -10.42298838833823]
        ]
    ],
    [
        [
            [-151.01394653320312, -16.6901323976794],
            [-151.0455322265625, -16.74274262581083],
            [-150.985107421875, -16.822945238563165],
            [-150.94802856445312, -16.816372528577872],
            [-150.95626831054688, -16.720385051693988],
            [-151.01394653320312, -16.6901323976794]
        ]
    ],
    [
        [
            [-151.47674560546875, -16.72959142923318],
            [-151.49322509765625, -16.805855718630397],
            [-151.46438598632812, -16.91099752698602],
            [-151.34765625, -16.85974819946167],
            [-151.44241333007812, -16.724330696497493],
            [-151.47674560546875, -16.72959142923318]
        ]
    ],
    [
        [
            [-151.52206420898435, -16.58618467276904],
            [-151.54815673828125, -16.6427708039953],
            [-151.4630126953125, -16.691447830122993],
            [-151.43142700195312, -16.61118990316615],
            [-151.49871826171875, -16.578287608637478],
            [-151.52206420898435, -16.58618467276904]
        ]
    ],
    [
        [
            [-151.76925659179688, -16.445305165857814],
            [-151.78710937499997, -16.475596336601203],
            [-151.776123046875, -16.537480951427145],
            [-151.69784545898438, -16.54801252874236],
            [-151.68685913085938, -16.475596336601203],
            [-151.76925659179688, -16.445305165857814]
        ]
    ],
    [
        [
            [-152.2543716430664, -16.417643880776698],
            [-152.2873306274414, -16.42455957122277],
            [-152.2972869873047, -16.459463584591557],
            [-152.2426986694336, -16.480534665654705],
            [-152.22827911376953, -16.453536930386626],
            [-152.23068237304688, -16.436085175129964],
            [-152.2543716430664, -16.417643880776698]
        ]
    ],
    [
        [
            [-52.55642473001839, 2.504705308437053],
            [-52.93965715189498, 2.124857692875622],
            [-53.418465135295264, 2.053389187016037],
            [-53.554839240113495, 2.334896551925965],
            [-53.77852067728889, 2.376702785650053],
            [-54.08806250671728, 2.105556545414629],
            [-54.52475419779975, 2.311848863123785],
            [-54.27122962097578, 2.738747870286943],
            [-54.18428402364474, 3.194172268075235],
            [-54.01150387227682, 3.622569891774858],
            [-54.399542202356514, 4.212611395683481],
            [-54.47863298197922, 4.896755682795643],
            [-53.95804460307093, 5.756548163267809],
            [-53.618452928264844, 5.646529038918402],
            [-52.88214128275408, 5.409850979021599],
            [-51.82334286152593, 4.565768133966145],
            [-51.65779741067888, 4.156232408053029],
            [-52.24933753112398, 3.241094468596287],
            [-52.55642473001839, 2.504705308437053]
        ]
    ],
    [
        [
            [9.560016310269134, 42.15249197037957],
            [9.229752231491773, 41.38000682226445],
            [8.77572309737536, 41.58361196549444],
            [8.54421268070783, 42.25651662858308],
            [8.746009148807588, 42.62812185319396],
            [9.390000848028905, 43.00998484961474],
            [9.560016310269134, 42.15249197037957]
        ]
    ],
    [
        [
            [3.588184441755715, 50.37899241800358],
            [4.28602298342514, 49.907496649772554],
            [4.799221632515753, 49.98537303323633],
            [5.674051954784885, 49.52948354755745],
            [5.897759230176376, 49.44266714130717],
            [6.186320428094206, 49.46380280211446],
            [6.658229607783539, 49.20195831969155],
            [8.099278598674772, 49.01778351500337],
            [7.593676385131062, 48.33301911070373],
            [7.46675906742223, 47.620581976911865],
            [7.192202182655535, 47.44976552997099],
            [6.736571079138088, 47.54180125588289],
            [6.768713820023634, 47.28770823830368],
            [6.037388950228972, 46.72577871356191],
            [6.022609490593567, 46.272989813820516],
            [6.500099724970454, 46.42967275652944],
            [6.843592970414562, 45.99114655210067],
            [6.802355177445662, 45.70857982032867],
            [7.096652459347837, 45.333098863295874],
            [6.749955275101711, 45.02851797136759],
            [7.007562290076663, 44.25476675066139],
            [7.549596388386163, 44.12790110938482],
            [7.435184767291843, 43.69384491634918],
            [6.529245232783068, 43.12889232031836],
            [4.556962517931396, 43.39965098731158],
            [3.10041059735272, 43.075200507167125],
            [2.985998976258486, 42.47301504166989],
            [1.826793247087181, 42.34338471126566],
            [0.701590610363922, 42.79573436133265],
            [0.338046909190581, 42.579546006839564],
            [-1.502770961910471, 43.03401439063049],
            [-1.901351284177735, 43.42280202897834],
            [-1.384225226232957, 44.02261037859017],
            [-1.193797573237362, 46.014917710954876],
            [-2.225724249673789, 47.06436269793821],
            [-2.963276129559574, 47.570326646507965],
            [-4.491554938159481, 47.95495433205642],
            [-4.592349819344747, 48.68416046812695],
            [-3.295813971357745, 48.901692409859635],
            [-1.616510789384932, 48.644421291694584],
            [-1.933494025063254, 49.776341864615766],
            [-0.98946895995536, 49.347375800160876],
            [1.338761020522753, 50.12717316344526],
            [1.6390010921385, 50.946606350297515],
            [2.513573032246171, 51.14850617126185],
            [2.658422071960331, 50.79684804951566],
            [3.123251580425716, 50.78036326761452],
            [3.588184441755715, 50.37899241800358]
        ]
    ]
];
const spain = [
    [
        [
            [3.812255859375, 40.04023218690451],
            [3.8232421874999996, 39.930800820752765],
            [3.9880371093749996, 39.930800820752765],
            [4.295654296875, 39.80431612840032],
            [4.3231201171875, 39.88866516883713],
            [4.141845703125, 40.07807142745009],
            [3.812255859375, 40.04023218690451]
        ]
    ],
    [
        [
            [3.1146240234375, 39.95185892663005],
            [2.30712890625, 39.57605638518604],
            [2.493896484375, 39.46164364205549],
            [2.724609375, 39.55911824217184],
            [2.8070068359375, 39.36827914916014],
            [3.0487060546875, 39.26628442213066],
            [3.4552001953125, 39.69873414348139],
            [3.14208984375, 39.7958755252971],
            [3.1146240234375, 39.95185892663005]
        ]
    ],
    [
        [
            [1.5216064453125, 39.095962936305476],
            [1.2799072265625, 39.04478604850143],
            [1.285400390625, 38.989302551359515],
            [1.2469482421875, 38.97222194853654],
            [1.2139892578125, 38.86109762182888],
            [1.40625, 38.8225909761771],
            [1.5985107421875, 39.02345139405935],
            [1.5216064453125, 39.095962936305476]
        ]
    ],
    [
        [
            [-15.6719970703125, 28.134971934813155],
            [-15.84228515625, 27.98955087395581],
            [-15.6060791015625, 27.712710260887476],
            [-15.347900390624998, 28.038046419369945],
            [-15.380859374999998, 28.188243641850313],
            [-15.6719970703125, 28.134971934813155]
        ]
    ],
    [
        [
            [-13.4857177734375, 29.27681632836857],
            [-13.826293945312498, 29.03215782622282],
            [-13.875732421875, 28.86872905602898],
            [-13.7384033203125, 28.85429649869795],
            [-13.447265624999998, 29.036960648558267],
            [-13.392333984375, 29.224096165685427],
            [-13.4857177734375, 29.27681632836857]
        ]
    ],
    [
        [
            [-13.8922119140625, 28.743580382306135],
            [-13.99658203125, 28.70504287929188],
            [-14.2218017578125, 28.222130007158565],
            [-14.490966796875, 28.091366281406945],
            [-14.353637695312498, 28.047742907226546],
            [-14.2437744140625, 28.168875180063345],
            [-13.8592529296875, 28.265682390146477],
            [-13.826293945312498, 28.724313406473463],
            [-13.8922119140625, 28.743580382306135]
        ]
    ],
    [
        [
            [-16.160888671874996, 28.570049879647403],
            [-16.34765625, 28.57487404744697],
            [-16.512451171875, 28.434883464940082],
            [-16.9024658203125, 28.372068829631633],
            [-16.6937255859375, 27.97984914504167],
            [-16.512451171875, 28.033197847676377],
            [-16.3421630859375, 28.37690204653979],
            [-16.160888671874996, 28.570049879647403]
        ]
    ],
    [
        [
            [-17.3199462890625, 28.2027676859484],
            [-17.347412109375, 28.120438687101064],
            [-17.2265625, 28.01865082183306],
            [-17.100219726562496, 28.101057958669447],
            [-17.2320556640625, 28.183401855246004],
            [-17.3199462890625, 28.2027676859484]
        ]
    ],
    [
        [
            [-17.946166992187496, 27.848790459862073],
            [-18.0450439453125, 27.766190642387496],
            [-18.1439208984375, 27.771051193172273],
            [-18.1549072265625, 27.741884632507087],
            [-17.9571533203125, 27.639740194861723],
            [-17.8802490234375, 27.809927780908378],
            [-17.946166992187496, 27.848790459862073]
        ]
    ],
    [
        [
            [-17.940673828125, 28.844673680771795],
            [-17.984619140625, 28.62310355452992],
            [-17.86376953125, 28.468691297348148],
            [-17.720947265625, 28.73394733840369],
            [-17.786865234375, 28.849485201023],
            [-17.940673828125, 28.844673680771795]
        ]
    ],
    [
        [
            [-9.034817674180246, 41.88057058365967],
            [-8.984433152695672, 42.59277517350627],
            [-9.392883673530648, 43.0266246608127],
            [-7.978189663108309, 43.748337714200986],
            [-6.754491746436756, 43.567909450853925],
            [-5.411886359061596, 43.574239813809676],
            [-4.347842779955783, 43.40344920508504],
            [-3.51753170410609, 43.4559007838613],
            [-1.901351284177764, 43.42280202897834],
            [-1.502770961910528, 43.03401439063043],
            [0.338046909190581, 42.57954600683954],
            [0.701590610363894, 42.7957343613326],
            [1.826793247087153, 42.34338471126569],
            [2.985998976258458, 42.47301504166986],
            [3.039484083680549, 41.892120266276905],
            [2.091841668312185, 41.22608856868309],
            [0.810524529635188, 41.01473196060934],
            [0.721331007499401, 40.678318386389236],
            [0.106691521819869, 40.12393362076202],
            [-0.278711310212941, 39.30997813573272],
            [0.111290724293838, 38.73851430923303],
            [-0.467123582349103, 38.29236583104115],
            [-0.683389451490598, 37.642353827457825],
            [-1.438382127274849, 37.443063666324214],
            [-2.146452602538119, 36.67414419203728],
            [-3.415780808923387, 36.65889964451118],
            [-4.368900926114719, 36.677839056946155],
            [-4.995219285492211, 36.32470815687964],
            [-5.377159796561457, 35.946850083961465],
            [-5.866432257500904, 36.02981659600606],
            [-6.236693894872175, 36.367677110330334],
            [-6.520190802425404, 36.94291331638732],
            [-7.453725551778092, 37.09778758396607],
            [-7.537105475281024, 37.42890432387623],
            [-7.166507941099865, 37.803894354802225],
            [-7.029281175148796, 38.07576406508977],
            [-7.374092169616318, 38.37305858006492],
            [-7.098036668313128, 39.03007274022378],
            [-7.498632371439725, 39.62957103124181],
            [-7.066591559263529, 39.71189158788277],
            [-7.026413133156595, 40.184524237624245],
            [-6.864019944679385, 40.33087189387483],
            [-6.851126674822552, 41.11108266861753],
            [-6.389087693700915, 41.381815497394655],
            [-6.668605515967656, 41.883386949219584],
            [-7.251308966490824, 41.91834605566505],
            [-7.422512986673795, 41.79207469335983],
            [-8.013174607769912, 41.790886135417125],
            [-8.263856980817792, 42.28046865495034],
            [-8.67194576662672, 42.13468943945496],
            [-9.034817674180246, 41.88057058365967]
        ]
    ]
];
const malta = [
    [
        [
            [14.188156127929688, 36.07463226007395],
            [14.187469482421875, 36.03799493963657],
            [14.256820678710938, 36.016337597992845],
            [14.336471557617186, 36.032997620005034],
            [14.238967895507812, 36.08073682174974],
            [14.188156127929688, 36.07463226007395]
        ]
    ],
    [
        [
            [14.328918457031252, 36.00633989397899],
            [14.335098266601562, 35.873472472521726],
            [14.53765869140625, 35.80389222782601],
            [14.570617675781252, 35.87514164836417],
            [14.328918457031252, 36.00633989397899]
        ]
    ]
];
const portugal = [
    [
        [
            [-31.116027832031246, 39.71141252523694],
            [-31.14898681640625, 39.675484393594814],
            [-31.06109619140625, 39.690280594818034],
            [-31.116027832031246, 39.71141252523694]
        ]
    ],
    [
        [
            [-31.225891113281246, 39.51675478434244],
            [-31.253356933593746, 39.37889504706486],
            [-31.13525390625, 39.37040245787161],
            [-31.12701416015625, 39.49132430037711],
            [-31.225891113281246, 39.51675478434244]
        ]
    ],
    [
        [
            [-28.2623291015625, 38.75408327579141],
            [-28.23760986328125, 38.67907761983558],
            [-27.77069091796875, 38.50948995925553],
            [-27.73223876953125, 38.55031345037904],
            [-28.2623291015625, 38.75408327579141]
        ]
    ],
    [
        [
            [-27.3394775390625, 38.79904887985135],
            [-27.38067626953125, 38.6897975322717],
            [-27.08404541015625, 38.65119833229951],
            [-27.05657958984375, 38.76693348394693],
            [-27.32574462890625, 38.788345355085625],
            [-27.3394775390625, 38.79904887985135]
        ]
    ],
    [
        [
            [-28.05084228515625, 39.08743603215884],
            [-27.97119140625, 38.989302551359515],
            [-27.97119140625, 39.09383130692365],
            [-28.05084228515625, 39.08743603215884]
        ]
    ],
    [
        [
            [-28.707275390624996, 38.638327308061875],
            [-28.8665771484375, 38.601846852838094],
            [-28.6083984375, 38.50519140240356],
            [-28.6029052734375, 38.591113776147445],
            [-28.707275390624996, 38.638327308061875]
        ]
    ],
    [
        [
            [-28.40240478515625, 38.56105262446978],
            [-28.5260009765625, 38.54816542304656],
            [-28.5150146484375, 38.44498466889473],
            [-28.2403564453125, 38.38472766885085],
            [-28.03985595703125, 38.43422817624596],
            [-28.40240478515625, 38.56105262446978]
        ]
    ],
    [
        [
            [-25.77667236328125, 37.9051994823157],
            [-25.853576660156246, 37.8553385894982],
            [-25.6805419921875, 37.727280276860036],
            [-25.17242431640625, 37.738141282210385],
            [-25.17791748046875, 37.87268533717655],
            [-25.64483642578125, 37.82497195707114],
            [-25.77667236328125, 37.9051994823157]
        ]
    ],
    [
        [
            [-25.0762939453125, 37.00913272027146],
            [-25.1806640625, 36.938916182818595],
            [-25.01312255859375, 36.938916182818595],
            [-25.0762939453125, 37.00913272027146]
        ]
    ],
    [
        [
            [-16.932678222656246, 32.84036602561056],
            [-17.0782470703125, 32.81728666309672],
            [-17.19085693359375, 32.86805334178712],
            [-17.281494140624996, 32.82421110161336],
            [-17.2100830078125, 32.731840896865684],
            [-16.84478759765625, 32.650938361757355],
            [-16.70745849609375, 32.74801260358348],
            [-16.932678222656246, 32.84036602561056]
        ]
    ],
    [
        [
            [-9.034817674180246, 41.88057058365967],
            [-8.67194576662672, 42.13468943945496],
            [-8.263856980817792, 42.28046865495034],
            [-8.013174607769912, 41.790886135417125],
            [-7.422512986673795, 41.79207469335983],
            [-7.251308966490824, 41.91834605566505],
            [-6.668605515967656, 41.883386949219584],
            [-6.389087693700915, 41.381815497394655],
            [-6.851126674822552, 41.11108266861753],
            [-6.864019944679385, 40.33087189387483],
            [-7.026413133156595, 40.184524237624245],
            [-7.066591559263529, 39.71189158788277],
            [-7.498632371439725, 39.62957103124181],
            [-7.098036668313128, 39.03007274022378],
            [-7.374092169616318, 38.37305858006492],
            [-7.029281175148796, 38.07576406508977],
            [-7.166507941099865, 37.803894354802225],
            [-7.537105475281024, 37.42890432387623],
            [-7.453725551778092, 37.09778758396607],
            [-7.855613165711985, 36.83826854099627],
            [-8.382816127953689, 36.97888011326246],
            [-8.898856980820327, 36.86880931248078],
            [-8.746101446965554, 37.65134552667661],
            [-8.839997524439879, 38.26624339451761],
            [-9.287463751655224, 38.3584858261586],
            [-9.526570603869715, 38.73742910415491],
            [-9.446988898140232, 39.39206614842837],
            [-9.048305223008427, 39.75509308527877],
            [-8.977353481471681, 40.15930613866581],
            [-8.768684047877102, 40.76063894303019],
            [-8.79085323733031, 41.18433401139126],
            [-8.99078935386757, 41.54345937760364],
            [-9.034817674180246, 41.88057058365967]
        ]
    ]
];
const belgium = [
    [
        [
            [3.314971144228537, 51.345780951536085],
            [4.047071160507527, 51.26725861266857],
            [4.973991326526914, 51.475023708698124],
            [5.606975945670001, 51.037298488969775],
            [6.156658155958779, 50.80372101501058],
            [6.043073357781111, 50.128051662794235],
            [5.782417433300906, 50.09032786722122],
            [5.674051954784829, 49.529483547557504],
            [4.799221632515809, 49.985373033236385],
            [4.286022983425084, 49.907496649772554],
            [3.588184441755686, 50.37899241800358],
            [3.123251580425801, 50.780363267614575],
            [2.658422071960274, 50.79684804951574],
            [2.513573032246143, 51.14850617126183],
            [3.314971144228537, 51.345780951536085]
        ]
    ]
];
const denmark = [
    [
        [
            [12.69000613775563, 55.609990953180784],
            [12.089991082414741, 54.80001455343793],
            [11.043543328504228, 55.364863796604254],
            [10.903913608451631, 55.77995473898875],
            [12.370904168353292, 56.111407375708836],
            [12.69000613775563, 55.609990953180784]
        ]
    ],
    [
        [
            [10.912181837618363, 56.458621324277914],
            [10.667803989309988, 56.08138336854722],
            [10.369992710011985, 56.19000722922473],
            [9.649984978889307, 55.469999498102055],
            [9.921906365609175, 54.98310415304806],
            [9.282048780971136, 54.83086538351616],
            [8.526229282270236, 54.96274363872499],
            [8.120310906617588, 55.517722683323626],
            [8.08997684086225, 56.540011705137594],
            [8.256581658571264, 56.8099693874303],
            [8.543437534223386, 57.110002753316905],
            [9.42446902836761, 57.17206614849948],
            [9.775558709358563, 57.447940782289656],
            [10.580005730846153, 57.73001658795485],
            [10.546105991262692, 57.215732733786155],
            [10.250000034230226, 56.89001618105047],
            [10.369992710011985, 56.609981594460834],
            [10.912181837618363, 56.458621324277914]
        ]
    ]
];
const ireland = [
    [
        [
            [-6.197884894220991, 53.86756500916336],
            [-6.03298539877761, 53.15316417094435],
            [-6.788856573910849, 52.260117906292336],
            [-8.56161658368356, 51.669301255899356],
            [-9.977085740590269, 51.82045482035307],
            [-9.16628251793078, 52.86462881124268],
            [-9.688524542672454, 53.8813626165853],
            [-8.327987433292009, 54.66451894796863],
            [-7.572167934591064, 55.13162221945487],
            [-7.366030646178785, 54.59584096945272],
            [-7.572167934591064, 54.059956366586],
            [-6.953730231138067, 54.073702297575636],
            [-6.197884894220991, 53.86756500916336]
        ]
    ]
];
const germany = [
    [
        [
            [9.921906365609232, 54.983104153048025],
            [9.9395797054529, 54.596641954153256],
            [10.950112338920519, 54.363607082733154],
            [10.939466993868448, 54.00869334575258],
            [11.956252475643282, 54.19648550070116],
            [12.518440382546714, 54.47037059184799],
            [13.647467075259499, 54.0755109727059],
            [14.119686313542559, 53.75702912049103],
            [14.353315463934168, 53.248171291713106],
            [14.074521111719434, 52.98126251892535],
            [14.4375997250022, 52.624850165408304],
            [14.685026482815713, 52.089947414755216],
            [14.607098422919648, 51.745188096719964],
            [15.016995883858781, 51.10667409932171],
            [14.570718214586122, 51.00233938252438],
            [14.307013380600665, 51.11726776794137],
            [14.056227654688314, 50.92691762959435],
            [13.338131951560397, 50.73323436136428],
            [12.96683678554325, 50.48407644306917],
            [12.240111118222671, 50.26633779560723],
            [12.415190870827473, 49.96912079528062],
            [12.521024204161336, 49.54741526956275],
            [13.031328973043514, 49.30706818297324],
            [13.595945672264577, 48.877171942737164],
            [13.243357374737116, 48.41611481382903],
            [12.884102817443873, 48.28914581968786],
            [13.025851271220517, 47.63758352313595],
            [12.932626987366064, 47.467645575544],
            [12.620759718484521, 47.672387600284424],
            [12.141357456112871, 47.70308340106578],
            [11.426414015354851, 47.52376618101306],
            [10.544504021861597, 47.5663992376538],
            [10.402083774465325, 47.30248769793916],
            [9.896068149463188, 47.580196845075704],
            [9.594226108446376, 47.5250580918202],
            [8.522611932009795, 47.83082754169135],
            [8.317301466514095, 47.61357982033627],
            [7.466759067422288, 47.62058197691192],
            [7.593676385131062, 48.33301911070373],
            [8.099278598674855, 49.01778351500343],
            [6.658229607783709, 49.20195831969164],
            [6.186320428094177, 49.463802802114515],
            [6.242751092156993, 49.90222565367873],
            [6.043073357781111, 50.128051662794235],
            [6.156658155958779, 50.80372101501058],
            [5.988658074577813, 51.851615709025054],
            [6.589396599970826, 51.852029120483394],
            [6.842869500362383, 52.22844025329755],
            [7.092053256873896, 53.14404328064489],
            [6.905139601274129, 53.48216217713064],
            [7.100424838905268, 53.69393219666267],
            [7.936239454793962, 53.74829580343379],
            [8.121706170289485, 53.52779246684429],
            [8.800734490604668, 54.020785630908904],
            [8.572117954145368, 54.39564647075405],
            [8.526229282270208, 54.96274363872516],
            [9.282048780971136, 54.83086538351631],
            [9.921906365609232, 54.983104153048025]
        ]
    ]
];
const netherlands = [
    [
        [
            [6.074182570020923, 53.510403347378144],
            [6.905139601274129, 53.48216217713064],
            [7.092053256873896, 53.14404328064489],
            [6.842869500362383, 52.22844025329755],
            [6.589396599970826, 51.852029120483394],
            [5.988658074577813, 51.851615709025054],
            [6.156658155958779, 50.80372101501058],
            [5.606975945670001, 51.037298488969775],
            [4.973991326526914, 51.475023708698124],
            [4.047071160507527, 51.26725861266857],
            [3.314971144228537, 51.34575511331991],
            [3.830288527043137, 51.62054454203195],
            [4.705997348661185, 53.09179840759776],
            [6.074182570020923, 53.510403347378144]
        ]
    ]
];
const austria = [
    [
        [
            [16.979666782304037, 48.123497015976305],
            [16.90375410326726, 47.71486562762833],
            [16.340584344150415, 47.71290192320123],
            [16.534267612380376, 47.49617096616912],
            [16.202298211337364, 46.85238597267696],
            [16.011663852612656, 46.6836107448117],
            [15.137091912504985, 46.65870270444703],
            [14.63247155117483, 46.43181732846955],
            [13.806475457421527, 46.509306138691215],
            [12.376485223040817, 46.76755910906985],
            [12.153088006243054, 47.11539317482645],
            [11.16482791509327, 46.94157949481273],
            [11.048555942436536, 46.75135854754634],
            [10.44270145024663, 46.89354625099743],
            [9.932448357796659, 46.92072805438296],
            [9.479969516649021, 47.10280996356337],
            [9.632931756232978, 47.34760122332999],
            [9.59422610844635, 47.52505809182027],
            [9.896068149463188, 47.580196845075704],
            [10.402083774465211, 47.30248769793916],
            [10.544504021861627, 47.56639923765377],
            [11.426414015354737, 47.523766181012974],
            [12.141357456112788, 47.703083401065776],
            [12.620759718484491, 47.67238760028441],
            [12.932626987365948, 47.467645575544],
            [13.02585127122049, 47.637583523135824],
            [12.884102817443903, 48.28914581968792],
            [13.243357374737, 48.416114813829054],
            [13.595945672264437, 48.87717194273715],
            [14.33889773932472, 48.5553052842072],
            [14.901447381254057, 48.964401760445824],
            [15.253415561593982, 49.039074205107575],
            [16.02964725105022, 48.73389903420793],
            [16.49928266771877, 48.78580801044511],
            [16.960288120194576, 48.5969823268506],
            [16.879982944413, 48.47001333270947],
            [16.979666782304037, 48.123497015976305]
        ]
    ]
];
const greece = [
    [
        [
            [23.699980096133004, 35.70500438083553],
            [24.24666507334868, 35.368022365860156],
            [25.02501549652888, 35.42499563246198],
            [25.769207797964185, 35.35401805270908],
            [25.745023227651586, 35.179997666966216],
            [26.290002882601723, 35.29999034274792],
            [26.16499759288766, 35.004995429009796],
            [24.724982130642303, 34.91998769788961],
            [24.735007358506945, 35.08499054619759],
            [23.51497846852811, 35.27999156345098],
            [23.699980096133004, 35.70500438083553]
        ]
    ],
    [
        [
            [26.604195590936282, 41.562114569661105],
            [26.29460208507578, 40.93626129817426],
            [26.056942172965506, 40.824123440100834],
            [25.447677036244187, 40.85254547786147],
            [24.92584842296094, 40.94706167252323],
            [23.714811232200816, 40.687129218095116],
            [24.407998894964066, 40.1249929876241],
            [23.899967889102584, 39.96200552017558],
            [23.3429993018608, 39.96099782974579],
            [22.81398766448896, 40.476005153966554],
            [22.62629886240478, 40.25656118423919],
            [22.849747755634805, 39.65931081802577],
            [23.3500272966526, 39.19001129816726],
            [22.973099399515547, 38.97090322524966],
            [23.530016310324953, 38.51000112563847],
            [24.025024855248944, 38.21999298761645],
            [24.040011020613605, 37.655014553369426],
            [23.115002882589152, 37.92001129816222],
            [23.409971958111072, 37.409990749657396],
            [22.774971958108633, 37.30501007745656],
            [23.15422529469862, 36.422505804992056],
            [22.490028110451107, 36.41000010837746],
            [21.670026482843696, 36.8449864771942],
            [21.295010613701574, 37.644989325504696],
            [21.120034213961333, 38.31032339126273],
            [20.730032179454582, 38.769985256498785],
            [20.217712029712857, 39.340234686839636],
            [20.15001590341052, 39.62499766698403],
            [20.615000441172782, 40.11000682225943],
            [20.674996779063633, 40.434999904943055],
            [20.99998986174728, 40.58000397395397],
            [21.02004031747643, 40.84272695572588],
            [21.674160597426976, 40.93127452245798],
            [22.05537763844427, 41.14986583105269],
            [22.597308383889015, 41.130487168943205],
            [22.76177, 41.3048],
            [22.952377150166566, 41.33799388281122],
            [23.692073601992462, 41.30908091894386],
            [24.49264489105803, 41.58389618587205],
            [25.197201368925533, 41.23448598893066],
            [26.106138136507184, 41.32889883072784],
            [26.117041863720914, 41.82690460872473],
            [26.604195590936282, 41.562114569661105]
        ]
    ]
];
const slovakia = [
    [
        [
            [18.853144158613617, 49.49622976337764],
            [18.909574822676316, 49.435845852244576],
            [19.320712517990472, 49.571574001659194],
            [19.825022820726872, 49.21712535256923],
            [20.41583947111985, 49.43145335549977],
            [20.887955356538413, 49.32877228453583],
            [21.607808058364213, 49.47010732685409],
            [22.558137648211755, 49.085738023467144],
            [22.28084191253356, 48.82539215758067],
            [22.08560835133485, 48.42226430927179],
            [21.872236362401736, 48.31997081155002],
            [20.801293979584926, 48.623854071642384],
            [20.473562045989866, 48.56285004332181],
            [20.239054396249347, 48.32756724709692],
            [19.769470656013112, 48.202691148463614],
            [19.661363559658497, 48.26661489520866],
            [19.17436486173989, 48.11137889260387],
            [18.77702477384767, 48.081768296900634],
            [18.696512892336926, 47.880953681014404],
            [17.857132602620027, 47.758428860050365],
            [17.48847293464982, 47.86746613218621],
            [16.979666782304037, 48.123497015976305],
            [16.879982944413, 48.47001333270947],
            [16.960288120194576, 48.5969823268506],
            [17.101984897538898, 48.81696889911711],
            [17.545006951577108, 48.80001902932537],
            [17.88648481616181, 48.90347524677371],
            [17.913511590250465, 48.996492824899086],
            [18.104972771891852, 49.04398346617531],
            [18.170498488037964, 49.271514797556435],
            [18.399993523846177, 49.31500051533004],
            [18.554971144289482, 49.49501536721878],
            [18.853144158613617, 49.49622976337764]
        ]
    ]
];
const slovenia = [
    [
        [
            [13.806475457421527, 46.509306138691215],
            [14.63247155117483, 46.43181732846955],
            [15.137091912504985, 46.65870270444703],
            [16.011663852612656, 46.6836107448117],
            [16.202298211337364, 46.85238597267696],
            [16.370504998447416, 46.8413272161665],
            [16.564808383864857, 46.50375092221983],
            [15.768732944408551, 46.23810822202345],
            [15.671529575267556, 45.83415355079788],
            [15.323953891672403, 45.73178253842768],
            [15.327674594797427, 45.45231639259323],
            [14.935243767972935, 45.471695054702685],
            [14.595109490627804, 45.634940904312714],
            [14.411968214585414, 45.46616567644746],
            [13.715059848697221, 45.50032379819237],
            [13.937630242578306, 45.59101593686462],
            [13.698109978905478, 46.01677806251735],
            [13.806475457421527, 46.509306138691215]
        ]
    ]
];
const czech = [
    [
        [
            [16.960288120194576, 48.5969823268506],
            [16.49928266771877, 48.78580801044511],
            [16.02964725105022, 48.73389903420793],
            [15.253415561593982, 49.039074205107575],
            [14.901447381254057, 48.964401760445824],
            [14.33889773932472, 48.5553052842072],
            [13.595945672264437, 48.87717194273715],
            [13.031328973043431, 49.30706818297324],
            [12.521024204161192, 49.547415269562734],
            [12.415190870827445, 49.96912079528057],
            [12.240111118222558, 50.266337795607285],
            [12.966836785543194, 50.484076443069085],
            [13.338131951560285, 50.73323436136435],
            [14.056227654688172, 50.92691762959429],
            [14.307013380600637, 51.117267767941414],
            [14.570718214586066, 51.002339382524276],
            [15.01699588385867, 51.10667409932158],
            [15.490972120839727, 50.78472992614321],
            [16.23862674323857, 50.69773265237984],
            [16.176253289462267, 50.42260732685791],
            [16.719475945714436, 50.21574656839354],
            [16.868769158605655, 50.47397370055603],
            [17.55456709155112, 50.36214590107641],
            [17.64944502123899, 50.049038397819956],
            [18.392913852622172, 49.98862864847075],
            [18.853144158613617, 49.49622976337764],
            [18.554971144289482, 49.49501536721878],
            [18.399993523846177, 49.31500051533004],
            [18.170498488037964, 49.271514797556435],
            [18.104972771891852, 49.04398346617531],
            [17.913511590250465, 48.996492824899086],
            [17.88648481616181, 48.90347524677371],
            [17.545006951577108, 48.80001902932537],
            [17.101984897538898, 48.81696889911711],
            [16.960288120194576, 48.5969823268506]
        ]
    ]
];
const hungary = [
    [
        [
            [16.202298211337364, 46.85238597267696],
            [16.534267612380376, 47.49617096616912],
            [16.340584344150415, 47.71290192320123],
            [16.90375410326726, 47.71486562762833],
            [16.979666782304037, 48.123497015976305],
            [17.48847293464982, 47.86746613218621],
            [17.857132602620027, 47.758428860050365],
            [18.696512892336926, 47.880953681014404],
            [18.77702477384767, 48.081768296900634],
            [19.17436486173989, 48.11137889260387],
            [19.661363559658497, 48.26661489520866],
            [19.769470656013112, 48.202691148463614],
            [20.239054396249347, 48.32756724709692],
            [20.473562045989866, 48.56285004332181],
            [20.801293979584926, 48.623854071642384],
            [21.872236362401736, 48.31997081155002],
            [22.08560835133485, 48.42226430927179],
            [22.640819939878753, 48.15023956968735],
            [22.710531447040495, 47.88219391538941],
            [22.099767693782834, 47.6724392767167],
            [21.62651492685387, 46.99423777931816],
            [21.02195234547125, 46.3160879583519],
            [20.220192498462836, 46.127468980486555],
            [19.596044549241583, 46.17172984474454],
            [18.82983808764996, 45.90887767189193],
            [18.45606245288286, 45.759481106136136],
            [17.630066359129557, 45.95176911069419],
            [16.8825150895953, 46.38063182228444],
            [16.564808383864857, 46.50375092221983],
            [16.370504998447416, 46.8413272161665],
            [16.202298211337364, 46.85238597267696]
        ]
    ]
];
const poland = [
    [
        [
            [15.01699588385867, 51.10667409932158],
            [14.607098422919535, 51.745188096719964],
            [14.685026482815688, 52.0899474147552],
            [14.4375997250022, 52.62485016540838],
            [14.074521111719491, 52.98126251892543],
            [14.353315463934138, 53.24817129171297],
            [14.119686313542587, 53.75702912049103],
            [14.802900424873458, 54.05070628520575],
            [16.36347700365573, 54.513158677785725],
            [17.622831658608675, 54.85153595643291],
            [18.62085859546164, 54.68260569927078],
            [18.696254510175464, 54.43871877706929],
            [19.660640089606403, 54.42608388937393],
            [20.892244500418624, 54.31252492941253],
            [22.731098667092652, 54.327536932993326],
            [23.24398725758951, 54.22056671814914],
            [23.48412763844985, 53.91249766704114],
            [23.527535841575002, 53.470121568406555],
            [23.80493493011778, 53.089731350306074],
            [23.799198846133375, 52.69109935160657],
            [23.199493849386187, 52.486977444053664],
            [23.508002150168693, 52.02364655212473],
            [23.52707075368437, 51.57845408793023],
            [24.029985792748903, 50.70540660257518],
            [23.922757195743262, 50.42488108987875],
            [23.426508416444392, 50.30850576435745],
            [22.518450148211603, 49.47677358661974],
            [22.776418898212626, 49.02739533140962],
            [22.558137648211755, 49.085738023467144],
            [21.607808058364213, 49.47010732685409],
            [20.887955356538413, 49.32877228453583],
            [20.41583947111985, 49.43145335549977],
            [19.825022820726872, 49.21712535256923],
            [19.320712517990472, 49.571574001659194],
            [18.909574822676316, 49.435845852244576],
            [18.853144158613617, 49.49622976337764],
            [18.392913852622172, 49.98862864847075],
            [17.64944502123899, 50.049038397819956],
            [17.55456709155112, 50.36214590107641],
            [16.868769158605655, 50.47397370055603],
            [16.719475945714436, 50.21574656839354],
            [16.176253289462267, 50.42260732685791],
            [16.23862674323857, 50.69773265237984],
            [15.490972120839727, 50.78472992614321],
            [15.01699588385867, 51.10667409932158]
        ]
    ]
];
const croatia = [
    [
        [
            [18.829838087650046, 45.908877671891844],
            [19.072768995854176, 45.52151113543209],
            [19.39047570158459, 45.236515611342384],
            [19.00548628101012, 44.86023366960916],
            [18.553214145591653, 45.08158966733145],
            [17.861783481526402, 45.067740383477144],
            [17.002146030351014, 45.233776760430935],
            [16.534939406000206, 45.21160757097772],
            [16.318156772535872, 45.00412669532591],
            [15.959367303133376, 45.233776760430935],
            [15.750026075918981, 44.81871165626256],
            [16.23966027188453, 44.35114329688571],
            [16.456442905348865, 44.04123973243128],
            [16.91615644701733, 43.66772247982567],
            [17.297373488034452, 43.44634064388736],
            [17.674921502358984, 43.02856252702361],
            [18.56, 42.65],
            [18.450016310304818, 42.47999136002932],
            [17.509970330483327, 42.849994615239154],
            [16.930005730871642, 43.20999848080038],
            [16.015384555737683, 43.50721548112722],
            [15.174453973052096, 44.243191229827914],
            [15.376250441151795, 44.31791535092208],
            [14.920309279040508, 44.73848399512946],
            [14.901602410550877, 45.07606028907611],
            [14.258747592839995, 45.233776760430935],
            [13.952254672917034, 44.80212352149687],
            [13.656975538801191, 45.13693512631596],
            [13.67940311041582, 45.48414907488501],
            [13.715059848697251, 45.500323798192426],
            [14.4119682145855, 45.46616567644742],
            [14.595109490627918, 45.63494090431282],
            [14.935243767972963, 45.471695054702764],
            [15.327674594797427, 45.452316392593325],
            [15.323953891672431, 45.731782538427694],
            [15.671529575267641, 45.8341535507979],
            [15.768732944408612, 46.23810822202353],
            [16.564808383864943, 46.50375092221981],
            [16.882515089595415, 46.38063182228444],
            [17.630066359129557, 45.9517691106941],
            [18.45606245288286, 45.75948110613615],
            [18.829838087650046, 45.908877671891844]
        ]
    ]
];
const bulgaria = [
    [
        [
            [22.65714969248299, 44.23492300066128],
            [22.944832391051847, 43.82378530534713],
            [23.33230228037632, 43.89701080990471],
            [24.100679152124172, 43.74105133724785],
            [25.569271681426926, 43.68844472917472],
            [26.065158725699746, 43.94349376075126],
            [27.242399529740908, 44.175986029632405],
            [27.970107049275075, 43.81246816667521],
            [28.558081495891997, 43.70746165625813],
            [28.03909508638472, 43.293171698574184],
            [27.67389773937805, 42.577892361006214],
            [27.99672041190539, 42.00735871028779],
            [27.135739373490477, 42.14148489030134],
            [26.117041863720797, 41.82690460872456],
            [26.106138136507212, 41.32889883072778],
            [25.197201368925445, 41.23448598893053],
            [24.49264489105803, 41.583896185872035],
            [23.692073601992348, 41.30908091894385],
            [22.952377150166452, 41.33799388281115],
            [22.88137373219743, 41.99929718685026],
            [22.380525750424592, 42.32025950781509],
            [22.54501183440962, 42.46136200618804],
            [22.43659467946128, 42.580321153323936],
            [22.60480146657133, 42.898518785161144],
            [22.986018507588483, 43.211161200526966],
            [22.50015669118028, 43.64281443946099],
            [22.410446404721597, 44.00806346289995],
            [22.65714969248299, 44.23492300066128]
        ]
    ]
];
const latvia = [
    [
        [
            [21.055800408622414, 56.03107636171106],
            [21.09042361825797, 56.78387278912293],
            [21.581866489353672, 57.41187063254993],
            [22.524341261492875, 57.75337433535076],
            [23.318452996522097, 57.00623647727487],
            [24.12072960785343, 57.02569265403277],
            [24.312862583114622, 57.79342357037698],
            [25.16459354014927, 57.97015696881519],
            [25.602809685984365, 57.84752879498657],
            [26.463532342237787, 57.47638865826633],
            [27.28818484875151, 57.47452830670383],
            [27.77001590344093, 57.24425812441123],
            [27.855282016722526, 56.75932648378429],
            [28.176709425577993, 56.16912995057881],
            [27.10245975109453, 55.783313707087686],
            [26.494331495883753, 55.615106919977634],
            [25.533046502390334, 56.10029694276603],
            [25.000934279080894, 56.16453074810484],
            [24.860684441840757, 56.37252838807963],
            [23.878263787539964, 56.273671373105266],
            [22.201156853939494, 56.33780182557948],
            [21.055800408622414, 56.03107636171106]
        ]
    ]
];
const lituania = [
    [
        [
            [22.731098667092652, 54.327536932993326],
            [22.65105187347254, 54.582740993866736],
            [22.75776370615526, 54.85657440858138],
            [22.315723504330577, 55.015298570365864],
            [21.268448927503467, 55.190481675835315],
            [21.055800408622414, 56.03107636171106],
            [22.201156853939494, 56.33780182557948],
            [23.878263787539964, 56.273671373105266],
            [24.860684441840757, 56.37252838807963],
            [25.000934279080894, 56.16453074810484],
            [25.533046502390334, 56.10029694276603],
            [26.494331495883753, 55.615106919977634],
            [26.58827924979039, 55.16717560487167],
            [25.7684326514798, 54.84696259217509],
            [25.536353794056993, 54.28242340760253],
            [24.450683628037037, 53.905702216194754],
            [23.48412763844985, 53.91249766704114],
            [23.24398725758951, 54.22056671814914],
            [22.731098667092652, 54.327536932993326]
        ]
    ]
];
const romania = [
    [
        [
            [22.710531447040495, 47.88219391538941],
            [23.142236362406802, 48.09634105080695],
            [23.76095828623741, 47.985598456405455],
            [24.40205610525038, 47.98187775328042],
            [24.866317172960578, 47.73752574318831],
            [25.20774336111299, 47.89105642352747],
            [25.9459411964024, 47.987148749374214],
            [26.19745039236693, 48.22088125263035],
            [26.619336785597795, 48.22072622333347],
            [26.924176059687568, 48.123264472030996],
            [27.233872918412743, 47.82677094175638],
            [27.551166212684848, 47.40511709247083],
            [28.128030226359044, 46.810476386088254],
            [28.160017937947714, 46.37156260841722],
            [28.0544429867754, 45.944586086605625],
            [28.233553501099042, 45.48828318946837],
            [28.679779493939378, 45.304030870131704],
            [29.149724969201653, 45.46492544207245],
            [29.603289015427432, 45.293308010431126],
            [29.626543409958767, 45.03539093686239],
            [29.141611769331835, 44.82021027279904],
            [28.837857700320203, 44.913873806328056],
            [28.558081495891997, 43.70746165625813],
            [27.970107049275075, 43.81246816667521],
            [27.242399529740908, 44.175986029632405],
            [26.065158725699746, 43.94349376075126],
            [25.569271681426926, 43.68844472917472],
            [24.100679152124172, 43.74105133724785],
            [23.33230228037632, 43.89701080990471],
            [22.944832391051847, 43.82378530534713],
            [22.65714969248299, 44.23492300066128],
            [22.4740084164406, 44.40922760678177],
            [22.705725538837356, 44.57800283464702],
            [22.459022251075936, 44.7025171982543],
            [22.14508792490281, 44.47842234962059],
            [21.562022739353605, 44.7689472519655],
            [21.483526238702233, 45.18117015235778],
            [20.874312778413355, 45.416375433934235],
            [20.762174920339987, 45.734573065771436],
            [20.220192498462836, 46.127468980486555],
            [21.02195234547125, 46.3160879583519],
            [21.62651492685387, 46.99423777931816],
            [22.099767693782834, 47.6724392767167],
            [22.710531447040495, 47.88219391538941]
        ]
    ]
];
const finland = [
    [
        [
            [28.591929559043194, 69.06477692328666],
            [28.445943637818658, 68.36461294216404],
            [29.977426385220607, 67.69829702419266],
            [29.054588657352326, 66.94428620062193],
            [30.21765, 65.80598],
            [29.544429559046986, 64.94867157659048],
            [30.44468468600371, 64.20445343693909],
            [30.035872430142714, 63.55281362573855],
            [31.51609215671112, 62.86768748641288],
            [31.139991082490894, 62.35769277612441],
            [30.211107212044446, 61.78002777774969],
            [28.069997592895277, 60.503516547275844],
            [26.25517296723697, 60.4239606797625],
            [24.496623976344523, 60.05731639265165],
            [22.869694858499457, 59.846373196036225],
            [22.290763787533592, 60.39192129174154],
            [21.322244093519316, 60.72016998965952],
            [21.544866163832694, 61.7053294948718],
            [21.05921105315369, 62.60739329695874],
            [21.536029493910803, 63.18973501245587],
            [22.442744174903993, 63.81781037053129],
            [24.730511508897536, 64.90234365504082],
            [25.398067661243942, 65.11142650009373],
            [25.294043003040404, 65.53434642197045],
            [23.903378533633802, 66.00692739527962],
            [23.565879754335583, 66.39605093043743],
            [23.53947309743444, 67.93600861273525],
            [21.978534783626117, 68.6168456081807],
            [20.645592889089528, 69.10624726020087],
            [21.244936150810673, 69.37044302029307],
            [22.356237827247412, 68.84174144151491],
            [23.66204959483076, 68.89124746365054],
            [24.735679152126725, 68.64955678982146],
            [25.68921268077636, 69.09211375596904],
            [26.17962202322624, 69.82529897732614],
            [27.732292107867863, 70.16419302029625],
            [29.01557295097197, 69.76649119737799],
            [28.591929559043194, 69.06477692328666]
        ]
    ]
];
const iceland = [
    [
        [
            [-14.508695441129236, 66.45589223903141],
            [-14.739637417041605, 65.8087482774403],
            [-13.60973222497981, 65.12667104761987],
            [-14.909833746794902, 64.36408193628868],
            [-17.794438035543422, 63.67874909123385],
            [-18.656245896874992, 63.49638296167582],
            [-19.97275468594276, 63.64363495549153],
            [-22.762971971110158, 63.960178941495386],
            [-21.778484259517683, 64.40211579045551],
            [-23.95504391121911, 64.89112986923348],
            [-22.184402635170358, 65.0849681667603],
            [-22.227423265053332, 65.37859365504272],
            [-24.326184047939336, 65.61118927678847],
            [-23.65051469572309, 66.26251902939522],
            [-22.134922451250883, 66.41046865504687],
            [-20.57628373867955, 65.73211212835143],
            [-19.05684160000159, 66.27660085719477],
            [-17.79862382655905, 65.99385325790978],
            [-16.167818976292125, 66.52679230413587],
            [-14.508695441129236, 66.45589223903141]
        ]
    ]
];
const estonia = [
    [
        [
            [24.312862583114622, 57.79342357037698],
            [24.42892785004216, 58.38341339785328],
            [24.061198357853186, 58.25737457949341],
            [23.42656009287668, 58.612753404364625],
            [23.339795363058645, 59.18724030215338],
            [24.604214308376182, 59.46585378685502],
            [25.86418908051664, 59.61109039981134],
            [26.949135776484525, 59.445803331125774],
            [27.981114129353244, 59.47538808861287],
            [28.13169925305175, 59.30082510033092],
            [27.42016645682494, 58.72458120384424],
            [27.71668582531572, 57.79189911562437],
            [27.28818484875151, 57.47452830670383],
            [26.463532342237787, 57.47638865826633],
            [25.602809685984365, 57.84752879498657],
            [25.16459354014927, 57.97015696881519],
            [24.312862583114622, 57.79342357037698]
        ]
    ]
];
const sweden = [
    [
        [
            [22.183173455501926, 65.72374054632017],
            [21.21351687997722, 65.02600535751527],
            [21.369631381930958, 64.41358795842429],
            [19.77887576669022, 63.60955434839504],
            [17.84777916837521, 62.74940013289681],
            [17.119554884518124, 61.34116567651097],
            [17.83134606290639, 60.63658336042741],
            [18.78772179533209, 60.081914374422595],
            [17.86922488777634, 58.9537661810587],
            [16.829185011470088, 58.71982697207339],
            [16.447709588291474, 57.041118069071885],
            [15.879785597403783, 56.10430186626866],
            [14.666681349352075, 56.200885118222175],
            [14.100721062891465, 55.40778107362265],
            [12.942910597392057, 55.36173737245058],
            [12.625100538797028, 56.30708018658197],
            [11.787942335668674, 57.44181712506307],
            [11.027368605196866, 58.85614940045936],
            [11.468271925511146, 59.43239329694604],
            [12.3003658382749, 60.11793284773003],
            [12.631146681375183, 61.293571682370136],
            [11.992064243221563, 61.80036245385656],
            [11.93056928879423, 63.12831757267698],
            [12.579935336973932, 64.06621898055833],
            [13.571916131248711, 64.04911408146971],
            [13.919905226302204, 64.44542064071608],
            [13.55568973150909, 64.78702769638151],
            [15.108411492583002, 66.19386688909547],
            [16.108712192456778, 67.30245555283689],
            [16.768878614985482, 68.01393667263139],
            [17.729181756265348, 68.01055186631628],
            [17.993868442464333, 68.56739126247736],
            [19.878559604581255, 68.40719432237258],
            [20.025268995857886, 69.0651386583127],
            [20.645592889089528, 69.10624726020087],
            [21.978534783626117, 68.6168456081807],
            [23.53947309743444, 67.93600861273525],
            [23.565879754335583, 66.39605093043743],
            [23.903378533633802, 66.00692739527962],
            [22.183173455501926, 65.72374054632017]
        ]
    ]
];
const cyprus = [
    [
        [
            [33.97361657078346, 35.058506374648],
            [34.00488081232004, 34.97809784600186],
            [32.97982710137845, 34.57186941175544],
            [32.49029625827753, 34.701654771456475],
            [32.25666710788596, 35.10323232679663],
            [32.73178022637745, 35.14002594658844],
            [32.919572381326134, 35.08783274997364],
            [33.19097700372305, 35.17312470147138],
            [33.3838334490363, 35.16271190036457],
            [33.45592207208347, 35.10142365166641],
            [33.475817498515845, 35.000344550103506],
            [33.5256852556775, 35.03868846286407],
            [33.675391880027064, 35.01786286065045],
            [33.86643965021011, 35.09359467217419],
            [33.97361657078346, 35.058506374648]
        ]
    ]
];
const luxembourg = [
    [
        [
            [6.043073357781111, 50.128051662794235],
            [6.242751092156993, 49.90222565367873],
            [6.186320428094177, 49.463802802114515],
            [5.897759230176405, 49.44266714130703],
            [5.674051954784829, 49.529483547557504],
            [5.782417433300906, 50.09032786722122],
            [6.043073357781111, 50.128051662794235]
        ]
    ]
];
const algeria = [
    [
        [
            [11.999505649471613, 23.47166840259645],
            [8.572893100629784, 21.565660712159143],
            [5.677565952180686, 19.601206976799716],
            [4.267419467800039, 19.155265204337],
            [3.158133172222705, 19.057364203360038],
            [3.1466610042539, 19.69357859952144],
            [2.683588494486429, 19.856230170160114],
            [2.06099083823392, 20.142233384679486],
            [1.823227573259032, 20.610809434486043],
            [-1.550054897457613, 22.792665920497384],
            [-4.92333736817423, 24.974574082941],
            [-8.68439978680905, 27.395744126896005],
            [-8.665124477564191, 27.589479071558227],
            [-8.665589565454809, 27.656425889592356],
            [-8.674116176782974, 28.84128896739658],
            [-7.059227667661928, 29.57922842052453],
            [-6.060632290053774, 29.731699734001694],
            [-5.242129278982787, 30.000443020135588],
            [-4.859646165374471, 30.501187649043842],
            [-3.690441046554696, 30.896951605751152],
            [-3.647497931320146, 31.63729401298067],
            [-3.068980271812648, 31.724497992473214],
            [-2.616604783529567, 32.09434621838615],
            [-1.30789913573787, 32.2628889023061],
            [-1.124551153966308, 32.65152151135713],
            [-1.388049282222568, 32.86401500094131],
            [-1.733454555661467, 33.919712836231994],
            [-1.792985805661687, 34.527918606091205],
            [-2.169913702798624, 35.16839630791668],
            [-1.208602871089056, 35.7148487411871],
            [-0.127454392894606, 35.888662421200806],
            [0.503876580415209, 36.30127289483528],
            [1.466918572606545, 36.605647081034405],
            [3.161698846050825, 36.78390493422522],
            [4.81575809084913, 36.86503693292346],
            [5.320120070017793, 36.71651886651662],
            [6.261819695672613, 37.11065501560674],
            [7.33038496260397, 37.118380642234364],
            [7.737078484741004, 36.885707505840216],
            [8.420964389691676, 36.94642731378316],
            [8.217824334352315, 36.433176988260286],
            [8.376367628623768, 35.47987600355594],
            [8.140981479534304, 34.65514598239379],
            [7.524481642292244, 34.09737641045146],
            [7.612641635782182, 33.34411489514896],
            [8.430472853233368, 32.74833730725595],
            [8.439102817426118, 32.50628489840082],
            [9.055602654668148, 32.10269196220129],
            [9.482139926805274, 30.307556057246188],
            [9.805634392952411, 29.42463837332339],
            [9.859997999723447, 28.959989732371014],
            [9.683884718472767, 28.1441738957792],
            [9.756128370816782, 27.68825857188415],
            [9.629056023811074, 27.14095347748092],
            [9.716285841519749, 26.512206325785698],
            [9.319410841518163, 26.094324856057455],
            [9.910692579801776, 25.36545461679674],
            [9.94826134607797, 24.936953640232517],
            [10.303846876678362, 24.379313259370917],
            [10.771363559622927, 24.56253205006175],
            [11.560669386449005, 24.097909247325518],
            [11.999505649471613, 23.47166840259645]
        ]
    ]
];
const uk = [
    [
        [
            [-5.661948614921897, 54.55460317648385],
            [-6.197884894220977, 53.86756500916334],
            [-6.953730231137996, 54.073702297575636],
            [-7.572167934591079, 54.05995636658599],
            [-7.366030646178785, 54.595840969452695],
            [-7.572167934591079, 55.1316222194549],
            [-6.733847011736145, 55.1728600124238],
            [-5.661948614921897, 54.55460317648385]
        ]
    ],
    [
        [
            [-3.005004848635281, 58.63500010846633],
            [-4.073828497728016, 57.55302480735525],
            [-3.055001796877661, 57.69001902936095],
            [-1.959280564776918, 57.68479970969951],
            [-2.219988165689301, 56.87001740175353],
            [-3.119003058271118, 55.973793036515474],
            [-2.085009324543023, 55.90999848085127],
            [-2.005675679673857, 55.80490285035023],
            [-1.11499101399221, 54.62498647726539],
            [-0.4304849918542, 54.46437612570216],
            [0.184981316742039, 53.32501414653103],
            [0.469976840831777, 52.92999949809197],
            [1.681530795914739, 52.739520168664],
            [1.559987827164377, 52.09999848083601],
            [1.050561557630914, 51.806760565795685],
            [1.449865349950301, 51.28942780212196],
            [0.550333693045502, 50.765738837275876],
            [-0.78751746255864, 50.77498891865622],
            [-2.489997524414377, 50.50001862243124],
            [-2.956273972984036, 50.696879991247016],
            [-3.617448085942328, 50.22835561787272],
            [-4.542507900399244, 50.34183706318566],
            [-5.245023159191135, 49.95999990498108],
            [-5.776566941745301, 50.15967763935682],
            [-4.309989793301838, 51.21000112568916],
            [-3.414850633142123, 51.42600861266925],
            [-3.422719467108323, 51.42684816740609],
            [-4.984367234710874, 51.593466091510976],
            [-5.267295701508885, 51.99140045837458],
            [-4.222346564134853, 52.301355699261364],
            [-4.770013393564113, 52.840004991255626],
            [-4.579999152026915, 53.49500377055517],
            [-3.093830673788659, 53.404547400669685],
            [-3.092079637047106, 53.404440822963544],
            [-2.945008510744344, 53.984999701546684],
            [-3.614700825433034, 54.600936773292574],
            [-3.63000545898933, 54.615012925833014],
            [-4.844169073903004, 54.790971177786844],
            [-5.082526617849226, 55.06160065369937],
            [-4.719112107756644, 55.50847260194348],
            [-5.047980922862109, 55.78398550070752],
            [-5.586397670911139, 55.31114614523682],
            [-5.644998745130181, 56.275014960344805],
            [-6.149980841486354, 56.78500967063354],
            [-5.786824713555291, 57.81884837506465],
            [-5.009998745127575, 58.63001333275005],
            [-4.211494513353557, 58.55084503847917],
            [-3.005004848635281, 58.63500010846633]
        ]
    ]
];
const frg = [
    [
        [
            [9.921906365609232, 54.983104153048025],
            [9.282048780971136, 54.83086538351631],
            [8.526229282270208, 54.96274363872516],
            [8.572117954145368, 54.39564647075405],
            [8.800734490604668, 54.020785630908904],
            [8.121706170289485, 53.52779246684429],
            [7.936239454793962, 53.74829580343379],
            [7.100424838905268, 53.69393219666267],
            [6.905139601274129, 53.48216217713064],
            [7.092053256873896, 53.14404328064489],
            [6.842869500362383, 52.22844025329755],
            [6.589396599970826, 51.852029120483394],
            [5.988658074577813, 51.851615709025054],
            [6.156658155958779, 50.80372101501058],
            [6.043073357781111, 50.128051662794235],
            [6.242751092156993, 49.90222565367873],
            [6.186320428094177, 49.463802802114515],
            [6.658229607783709, 49.20195831969164],
            [8.099278598674855, 49.01778351500343],
            [7.593676385131062, 48.33301911070373],
            [7.466759067422288, 47.62058197691192],
            [8.317301466514095, 47.61357982033627],
            [8.522611932009795, 47.83082754169135],
            [9.594226108446376, 47.5250580918202],
            [9.896068149463188, 47.580196845075704],
            [10.402083774465325, 47.30248769793916],
            [10.544504021861597, 47.5663992376538],
            [11.426414015354851, 47.52376618101306],
            [12.141357456112871, 47.70308340106578],
            [12.620759718484521, 47.672387600284424],
            [12.932626987366064, 47.467645575544],
            [13.025851271220517, 47.63758352313595],
            [12.884102817443873, 48.28914581968786],
            [13.243357374737116, 48.41611481382903],
            [13.595945672264577, 48.877171942737164],
            [13.031328973043514, 49.30706818297324],
            [12.521024204161336, 49.54741526956275],
            [12.415190870827473, 49.96912079528062],
            [12.240111118222671, 50.26633779560723],
            [11.93115234375, 50.42951794712287],
            [10.832519531249998, 50.21909462044748],
            [10.04150390625, 50.65294336725709],
            [9.909667968749998, 51.440312757160115],
            [10.74462890625, 51.56341232867588],
            [10.74462890625, 52.03897658307622],
            [11.162109375, 52.09300763963822],
            [10.7666015625, 52.84259457223949],
            [11.689453125, 52.9883372533954],
            [10.634765625, 53.34399288223422],
            [10.939466993868448, 54.00869334575258],
            [10.950112338920519, 54.363607082733154],
            [9.9395797054529, 54.596641954153256],
            [9.921906365609232, 54.983104153048025]
        ]
    ],
    [
        [
            [13.311309814453125, 52.62472735573713],
            [13.30169677734375, 52.65972593335803],
            [13.265991210937498, 52.63556324144265],
            [13.209686279296875, 52.594706282077965],
            [13.152008056640625, 52.59971122365474],
            [13.105316162109375, 52.51956352925745],
            [13.160247802734375, 52.507027222951635],
            [13.086090087890625, 52.41666021079324],
            [13.149261474609375, 52.39487748111347],
            [13.24676513671875, 52.41414736782131],
            [13.42529296875, 52.376437538867776],
            [13.45001220703125, 52.417497793298324],
            [13.327789306640625, 52.520399155853454],
            [13.311309814453125, 52.62472735573713]
        ]
    ]
];
const greenland = [
    [
        [
            [-46.76379, 82.62796],
            [-43.40644, 83.22516],
            [-39.89753, 83.18018],
            [-38.62214, 83.54905],
            [-35.08787, 83.64513],
            [-27.10046, 83.51966],
            [-20.84539, 82.72669],
            [-22.69182, 82.34165],
            [-26.51753, 82.29765],
            [-31.9, 82.2],
            [-31.39646, 82.02154],
            [-27.85666, 82.13178],
            [-24.84448, 81.78697],
            [-22.90328, 82.09317],
            [-22.07175, 81.73449],
            [-23.16961, 81.15271],
            [-20.62363, 81.52462],
            [-15.76818, 81.91245],
            [-12.77018, 81.71885],
            [-12.20855, 81.29154],
            [-16.28533, 80.58004],
            [-16.85, 80.35],
            [-20.04624, 80.17708],
            [-17.73035, 80.12912],
            [-18.9, 79.4],
            [-19.70499, 78.75128],
            [-19.67353, 77.63859],
            [-18.47285, 76.98565],
            [-20.03503, 76.94434],
            [-21.67944, 76.62795],
            [-19.83407, 76.09808],
            [-19.59896, 75.24838],
            [-20.66818, 75.15585],
            [-19.37281, 74.29561],
            [-21.59422, 74.22382],
            [-20.43454, 73.81713],
            [-20.76234, 73.46436],
            [-22.17221, 73.30955],
            [-23.56593, 73.30663],
            [-22.31311, 72.62928],
            [-22.29954, 72.18409],
            [-24.27834, 72.59788],
            [-24.79296, 72.3302],
            [-23.44296, 72.08016],
            [-22.13281, 71.46898],
            [-21.75356, 70.66369],
            [-23.53603, 70.471],
            [-24.30702, 70.85649],
            [-25.54341, 71.43094],
            [-25.20135, 70.75226],
            [-26.36276, 70.22646],
            [-23.72742, 70.18401],
            [-22.34902, 70.12946],
            [-25.02927, 69.2588],
            [-27.74737, 68.47046],
            [-30.67371, 68.12503],
            [-31.77665, 68.12078],
            [-32.81105, 67.73547],
            [-34.20196, 66.67974],
            [-36.35284, 65.9789],
            [-37.04378, 65.93768],
            [-38.37505, 65.69213],
            [-39.81222, 65.45848],
            [-40.66899, 64.83997],
            [-40.68281, 64.13902],
            [-41.1887, 63.48246],
            [-42.81938, 62.68233],
            [-42.41666, 61.90093],
            [-42.86619, 61.07404],
            [-43.3784, 60.09772],
            [-44.7875, 60.03676],
            [-46.26364, 60.85328],
            [-48.26294, 60.85843],
            [-49.23308, 61.40681],
            [-49.90039, 62.38336],
            [-51.63325, 63.62691],
            [-52.14014, 64.27842],
            [-52.27659, 65.1767],
            [-53.66166, 66.09957],
            [-53.30161, 66.8365],
            [-53.96911, 67.18899],
            [-52.9804, 68.35759],
            [-51.47536, 68.72958],
            [-51.08041, 69.14781],
            [-50.87122, 69.9291],
            [-52.013585, 69.574925],
            [-52.55792, 69.42616],
            [-53.45629, 69.283625],
            [-54.68336, 69.61003],
            [-54.75001, 70.28932],
            [-54.35884, 70.821315],
            [-53.431315, 70.835755],
            [-51.39014, 70.56978],
            [-53.10937, 71.20485],
            [-54.00422, 71.54719],
            [-55, 71.40653],
            [-55.83468, 71.65444],
            [-54.71819, 72.58625],
            [-55.32634, 72.95861],
            [-56.12003, 73.64977],
            [-57.32363, 74.71026],
            [-58.59679, 75.09861],
            [-58.58516, 75.51727],
            [-61.26861, 76.10238],
            [-63.39165, 76.1752],
            [-66.06427, 76.13486],
            [-68.50438, 76.06141],
            [-69.66485, 76.37975],
            [-71.40257, 77.00857],
            [-68.77671, 77.32312],
            [-66.76397, 77.37595],
            [-71.04293, 77.63595],
            [-73.297, 78.04419],
            [-73.15938, 78.43271],
            [-69.37345, 78.91388],
            [-65.7107, 79.39436],
            [-65.3239, 79.75814],
            [-68.02298, 80.11721],
            [-67.15129, 80.51582],
            [-63.68925, 81.21396],
            [-62.23444, 81.3211],
            [-62.65116, 81.77042],
            [-60.28249, 82.03363],
            [-57.20744, 82.19074],
            [-54.13442, 82.19962],
            [-53.04328, 81.88833],
            [-50.39061, 82.43883],
            [-48.00386, 82.06481],
            [-46.59984, 81.985945],
            [-44.523, 81.6607],
            [-46.9007, 82.19979],
            [-46.76379, 82.62796]
        ]
    ]
];

/**
 * All exported country geometries are handled as the GeoJson's MultiPolygon coordinates type.
 */
export const COUNTRIES: { [key: string]: MultiPolygon["coordinates"] } = {
    algeria,
    france,
    italy,
    poland,
    croatia,
    spain,
    portugal,
    belgium,
    denmark,
    ireland,
    germany,
    netherlands,
    greece,
    slovakia,
    slovenia,
    austria,
    czech,
    hungary,
    bulgaria,
    latvia,
    lituania,
    iceland,
    romania,
    finland,
    estonia,
    cyprus,
    sweden,
    luxembourg,
    uk,
    frg,
    greenland,
    malta
};
