/*
 * Copyright (C) 2017-2019 HERE Europe B.V.
 * Licensed under Apache 2.0, see full license in LICENSE
 * SPDX-License-Identifier: Apache-2.0
 */
export const faults = {
    trenches: {
        "Ryukyu Trench": [
            [137, 33],
            [133, 31],
            [131, 29],
            [127, 25]
        ],
        "Japan and Kurile Trench": [
            [169, 59],
            [164, 57],
            [163, 54],
            [156, 48],
            [144, 41],
            [143, 39]
        ],
        "Izu-Ogazawara Trench": [
            [143, 39],
            [141, 33]
        ],
        "Mariane Trench": [
            [141, 33],
            [143, 22],
            [147, 19],
            [148, 14],
            [146, 8],
            [142, 7],
            [138, 6],
            [138, 5]
        ],
        "Aleutian Trench": [
            [171, 52],
            [181, 50],
            [193, 52],
            [208, 56],
            [214, 59]
        ],
        "Sunda and Java Trench": [
            [92, 15],
            [90, 8],
            [96, -0],
            [105, -9],
            [120, -11]
        ],
        "Philippines Trench": [
            [126, 13],
            [128, 4],
            [130, 2],
            [139, 0]
        ],
        unknown: [
            [152, -9],
            [149, -8],
            [153, -6],
            [158, -11],
            [164, -13],
            [168, -21],
            [173, -22]
        ],
        "Kermadec Trench": [
            [177, -41],
            [181, -34],
            [183, -26],
            [185, -17]
        ]
    },
    ridges: {
        "Juan de Fuca Ridge": [
            [-137, 50],
            [-135, 47],
            [-129, 46],
            [-128, 44],
            [-125, 42]
        ],
        "Mid-Atlantic Ridge": [
            [-12, 70],
            [-33, 51],
            [-40, 32],
            [-42, 13],
            [-28, -1],
            [-13, -7],
            [-14, -29],
            [-14, -36],
            [-17, -44],
            [-15, -54]
        ],
        "Arctic Ridge": [
            [142, 67],
            [132, 72],
            [123, 83],
            [92, 84],
            [38, 84],
            [22, 83],
            [3, 79],
            [9, 74],
            [-12, 70]
        ],
        "Southwest Indian Ridge": [
            [71, -26],
            [58, -34],
            [33, -50],
            [25, -52],
            [-12, -54]
        ],
        unknown: [
            [37, 23],
            [39, 19],
            [43, 12],
            [44, 11],
            [53, 14],
            [56, 12],
            [54, 10],
            [56, 9],
            [60, 5],
            [62, 5],
            [68, -7],
            [68, -9],
            [65, -14],
            [67, -19],
            [65, -22],
            [71, -26]
        ],
        "South East Indian Ridge": [
            [71, -26],
            [85, -31],
            [92, -39],
            [110, -45],
            [128, -46],
            [149, -52],
            [160, -56],
            [167, -62]
        ],
        "Pacific Antarctic Ridge": [
            [167, -62],
            [194, -63],
            [213, -61],
            [225, -56],
            [232, -55],
            [243, -56]
        ],
        "East Pacific Ridge": [
            [243, -56],
            [254, -50],
            [257, -45],
            [249, -27],
            [249, -22],
            [257, -15],
            [261, -5],
            [255, 17],
            [246, 30]
        ],
        "African Ridge": [
            [43, 12],
            [36, 4],
            [31, 2],
            [29, -2],
            [30, -6],
            [34, -11],
            [34, -15]
        ]
    }
};

export const hotspots = [
    [6.9, 50.2],
    [2.8, 45.5],
    [2.5, 42.2],
    [10.9, 43.2],
    [11.6, 42.9],
    [11.9, 42.6],
    [12.7, 41.7],
    [14.1, 40.8],
    [14.4, 40.8],
    [13.9, 40.7],
    [15.2, 38.8],
    [15.0, 38.5],
    [15.0, 38.4],
    [15.0, 37.7],
    [12.7, 37.1],
    [12.0, 36.8],
    [23.3, 37.6],
    [24.4, 36.7],
    [25.4, 36.4],
    [27.2, 36.6],
    [27.1, 36.6],
    [27.3, 36.8],
    [28.5, 38.6],
    [33.6, 37.7],
    [34.2, 38.1],
    [34.6, 38.2],
    [34.5, 38.6],
    [35.5, 38.5],
    [39.8, 37.7],
    [42.0, 38.6],
    [42.8, 38.9],
    [43.3, 39.2],
    [43.8, 39.3],
    [44.3, 39.7],
    [42.9, 40.7],
    [42.4, 43.3],
    [44.5, 42.7],
    [44.0, 42.5],
    [44.3, 42.4],
    [43.6, 41.5],
    [44.1, 40.5],
    [44.8, 40.3],
    [45.5, 39.7],
    [41.7, 15.7],
    [42.2, 15.1],
    [39.8, 15.0],
    [39.9, 14.9],
    [40.3, 14.2],
    [40.4, 14.0],
    [40.4, 13.9],
    [40.6, 13.8],
    [40.6, 13.8],
    [40.6, 13.7],
    [40.7, 13.6],
    [40.6, 13.5],
    [40.7, 13.5],
    [41.8, 13.6],
    [41.7, 13.4],
    [41.7, 13.3],
    [41.7, 13.2],
    [41.6, 13.1],
    [41.1, 13.1],
    [41.1, 13.3],
    [41.0, 13.3],
    [40.9, 13.1],
    [40.2, 13.0],
    [40.6, 12.9],
    [40.5, 12.6],
    [40.1, 12.4],
    [40.8, 12.2],
    [40.3, 11.7],
    [41.2, 11.9],
    [41.4, 11.6],
    [42.2, 12.4],
    [42.4, 12.5],
    [42.5, 12.5],
    [42.4, 12.9],
    [42.5, 11.6],
    [42.0, 11.5],
    [42.2, 11.4],
    [41.8, 11.2],
    [41.6, 11.3],
    [41.5, 11.3],
    [41.3, 11.1],
    [41.0, 10.6],
    [40.7, 10.1],
    [40.8, 10.1],
    [40.3, 9.8],
    [40.3, 9.6],
    [40.1, 9.3],
    [39.9, 9.0],
    [39.7, 8.9],
    [39.7, 8.8],
    [39.6, 8.7],
    [39.5, 8.6],
    [39.0, 8.8],
    [39.0, 8.6],
    [39.3, 8.4],
    [39.2, 8.3],
    [39.0, 8.3],
    [39.1, 8.2],
    [39.1, 8.1],
    [38.9, 7.9],
    [38.3, 8.0],
    [38.8, 7.8],
    [38.6, 7.5],
    [38.4, 7.2],
    [38.1, 7.1],
    [35.4, 7.4],
    [37.8, 6.8],
    [38.1, 6.6],
    [37.6, 5.9],
    [37.7, 5.6],
    [35.9, 5.1],
    [37.4, 4.1],
    [36.0, 4.1],
    [36.0, 3.5],
    [36.6, 2.6],
    [38.0, 2.3],
    [36.6, 2.3],
    [36.3, 1.9],
    [37.9, 1.6],
    [36.3, 1.5],
    [36.2, 1.1],
    [36.2, 0.9],
    [36.1, 0.8],
    [36.1, 0.6],
    [37.9, 0.2],
    [36.1, -0.2],
    [34.5, -0.4],
    [36.3, -0.5],
    [36.2, -0.6],
    [36.3, -0.9],
    [36.5, -0.9],
    [36.3, -1.2],
    [35.9, -2.8],
    [37.9, -2.7],
    [37.3, -3.1],
    [36.8, -3.2],
    [31.9, -4.9],
    [33.6, -8.6],
    [33.8, -8.7],
    [33.6, -9.0],
    [33.4, -8.9],
    [33.7, -9.1],
    [33.8, -9.2],
    [30.4, 0.7],
    [30.2, 0.7],
    [30.2, 0.4],
    [29.9, -0.1],
    [30.1, -0.2],
    [30.2, -0.5],
    [29.3, -0.9],
    [29.2, -1.4],
    [29.3, -1.5],
    [29.4, -1.5],
    [29.5, -1.5],
    [29.7, -1.4],
    [29.7, -1.2],
    [28.7, -2.3],
    [12.0, 10.7],
    [13.7, 7.2],
    [10.5, 6.2],
    [9.8, 5.0],
    [9.2, 4.2],
    [8.7, 3.6],
    [8.6, 3.3],
    [8.5, 3.3],
    [6.7, 0.3],
    [17.5, 27.2],
    [16.3, 21.3],
    [16.5, 21.0],
    [17.3, 20.9],
    [18.5, 19.8],
    [24.3, 12.9],
    [25.8, 14.5],
    [26.2, 15.1],
    [32.8, 18.3],
    [33.8, 18.2],
    [40.9, 36.5],
    [37.0, 36.7],
    [36.9, 33.3],
    [36.3, 33.1],
    [37.2, 33.1],
    [36.4, 32.7],
    [36.2, 27.8],
    [37.3, 27.1],
    [37.7, 25.2],
    [40.2, 26.6],
    [39.9, 25.0],
    [39.8, 23.1],
    [41.4, 22.8],
    [42.8, 17.0],
    [44.1, 15.6],
    [44.2, 15.3],
    [44.8, 15.4],
    [44.7, 14.6],
    [44.8, 14.0],
    [45.0, 12.2],
    [46.1, 13.6],
    [48.3, 14.0],
    [50.6, 15.5],
    [52.1, 35.9],
    [57.6, 29.4],
    [60.0, 28.1],
    [60.7, 28.2],
    [61.6, 28.6],
    [67.9, 33.9],
    [68.0, 34.2],
    [43.3, -11.5],
    [43.4, -11.7],
    [55.7, -21.2],
    [49.1, -12.5],
    [48.5, -13.3],
    [48.7, -14.3],
    [46.8, -19.0],
    [47.2, -19.4],
    [73.5, -53.1],
    [69.5, -49.6],
    [77.5, -38.7],
    [77.5, -37.8],
    [51.6, -46.4],
    [50.2, -46.1],
    [37.9, -46.6],
    [37.7, -46.9],
    [80.7, 11.7],
    [173.9, -35.3],
    [174.3, -35.7],
    [174.9, -36.9],
    [176.2, -37.3],
    [174.1, -39.3],
    [177.2, -37.5],
    [177.0, -37.9],
    [176.3, -38.1],
    [176.5, -38.1],
    [176.3, -38.4],
    [176.1, -38.4],
    [176.0, -38.8],
    [175.6, -39.1],
    [175.6, -39.3],
    [178.9, -35.5],
    [178.6, -35.4],
    [178.5, -35.7],
    [178.1, -36.2],
    [178.2, -36.1],
    [-178.6, -30.5],
    [-178.9, -30.2],
    [-178.5, -30.2],
    [-177.9, -29.3],
    [-177.9, -29.2],
    [-177.2, -25.9],
    [-175.6, -21.4],
    [-175.5, -20.8],
    [-175.4, -20.6],
    [-175.4, -20.3],
    [-175.1, -19.7],
    [-174.9, -19.2],
    [-174.8, -19.0],
    [-174.6, -18.8],
    [-174.3, -18.0],
    [-173.7, -15.6],
    [-175.6, -15.6],
    [-169.1, -14.2],
    [-169.5, -14.2],
    [-169.6, -14.2],
    [-170.7, -14.3],
    [-171.7, -13.9],
    [-172.5, -13.6],
    [-176.2, -13.3],
    [-180.0, -16.8],
    [179.4, -17.3],
    [147.4, -2.4],
    [147.3, -2.6],
    [147.8, -3.0],
    [144.6, -3.5],
    [144.6, -3.6],
    [144.8, -3.6],
    [145.0, -4.0],
    [145.1, -4.1],
    [146.0, -4.6],
    [146.3, -4.3],
    [146.8, -4.9],
    [147.1, -5.4],
    [147.9, -5.6],
    [148.1, -5.5],
    [148.1, -5.4],
    [148.6, -5.2],
    [148.4, -5.5],
    [149.1, -4.5],
    [149.4, -4.6],
    [149.5, -4.7],
    [150.1, -5.1],
    [150.0, -5.1],
    [150.1, -5.3],
    [150.0, -5.4],
    [150.5, -5.5],
    [150.5, -5.6],
    [150.9, -5.5],
    [151.1, -5.3],
    [151.2, -5.2],
    [151.3, -5.0],
    [151.2, -4.9],
    [150.9, -4.7],
    [152.2, -4.3],
    [143.1, -5.9],
    [145.1, -6.6],
    [145.9, -7.0],
    [146.7, -7.3],
    [147.6, -9.2],
    [148.1, -8.9],
    [148.4, -9.0],
    [148.1, -9.3],
    [148.3, -9.1],
    [149.1, -9.2],
    [149.1, -9.5],
    [149.1, -9.6],
    [150.3, -9.5],
    [150.5, -9.5],
    [150.9, -9.6],
    [152.6, -3.1],
    [153.6, -4.1],
    [154.9, -5.8],
    [155.0, -5.8],
    [155.2, -6.1],
    [155.2, -6.1],
    [155.6, -6.4],
    [155.6, -6.5],
    [156.6, -7.7],
    [156.5, -8.3],
    [157.0, -8.7],
    [157.2, -8.8],
    [158.0, -9.0],
    [158.0, -8.9],
    [159.7, -9.3],
    [159.8, -9.1],
    [165.8, -10.4],
    [167.7, -13.7],
    [167.5, -13.8],
    [167.5, -14.3],
    [168.0, -14.4],
    [167.8, -15.4],
    [168.1, -16.2],
    [168.3, -16.5],
    [168.4, -16.7],
    [168.3, -16.7],
    [168.4, -16.8],
    [168.5, -16.8],
    [168.6, -17.0],
    [168.3, -17.4],
    [169.2, -18.7],
    [169.4, -19.5],
    [169.8, -20.2],
    [171.3, -22.3],
    [172.0, -22.4],
    [168.6, -25.8],
    [142.5, -37.8],
    [94.2, 13.4],
    [93.9, 12.3],
    [95.3, 5.9],
    [95.6, 5.4],
    [96.3, 4.9],
    [96.8, 4.8],
    [96.8, 4.8],
    [97.6, 3.9],
    [98.5, 3.2],
    [98.4, 3.2],
    [98.8, 2.6],
    [98.9, 2.0],
    [99.3, 1.6],
    [99.5, 0.7],
    [100.0, 0.1],
    [100.5, -0.4],
    [100.3, -0.4],
    [100.7, -1.0],
    [101.3, -1.7],
    [101.6, -2.3],
    [101.7, -2.4],
    [101.6, -2.6],
    [102.0, -2.8],
    [102.2, -2.8],
    [102.4, -3.4],
    [102.6, -3.5],
    [103.1, -4.0],
    [103.3, -4.3],
    [103.6, -4.2],
    [103.7, -4.4],
    [103.9, -4.8],
    [104.3, -5.1],
    [104.3, -5.2],
    [104.6, -5.3],
    [105.6, -5.8],
    [105.4, -6.1],
    [106.0, -6.2],
    [106.0, -6.3],
    [106.6, -6.7],
    [106.7, -6.7],
    [106.7, -6.7],
    [107.0, -6.8],
    [107.4, -7.1],
    [107.6, -7.2],
    [107.6, -6.8],
    [107.7, -7.3],
    [107.7, -7.2],
    [107.8, -7.1],
    [107.8, -7.1],
    [107.9, -6.8],
    [108.0, -7.2],
    [108.1, -7.2],
    [108.1, -7.2],
    [108.4, -6.9],
    [109.2, -7.2],
    [109.9, -7.2],
    [110.0, -7.3],
    [110.1, -7.4],
    [110.3, -7.2],
    [110.4, -7.4],
    [110.4, -7.4],
    [110.4, -7.5],
    [111.2, -7.6],
    [111.8, -7.8],
    [112.3, -7.9],
    [112.4, -7.9],
    [112.6, -7.7],
    [112.6, -7.6],
    [112.7, -8.0],
    [112.9, -8.1],
    [113.0, -7.9],
    [113.3, -8.0],
    [113.6, -7.7],
    [113.6, -8.0],
    [114.0, -8.1],
    [114.2, -8.1],
    [114.4, -7.8],
    [115.1, -8.3],
    [115.4, -8.2],
    [115.5, -8.3],
    [116.5, -8.4],
    [118.0, -8.2],
    [119.1, -8.2],
    [119.4, -8.5],
    [120.0, -8.7],
    [120.5, -8.7],
    [120.5, -8.6],
    [120.9, -8.9],
    [121.0, -8.7],
    [121.2, -8.8],
    [121.6, -8.9],
    [121.8, -8.8],
    [121.8, -8.7],
    [121.8, -8.8],
    [121.7, -8.3],
    [122.5, -8.7],
    [122.7, -8.5],
    [122.8, -8.5],
    [122.8, -8.4],
    [122.9, -8.3],
    [123.3, -8.3],
    [123.5, -8.3],
    [123.4, -8.5],
    [123.6, -8.5],
    [123.6, -7.8],
    [124.1, -8.5],
    [123.9, -7.5],
    [124.2, -6.6],
    [124.7, -6.6],
    [126.6, -6.6],
    [128.7, -7.1],
    [129.1, -6.9],
    [129.5, -6.7],
    [130.0, -6.3],
    [130.3, -5.5],
    [129.9, -4.5],
    [121.6, -0.2],
    [124.4, 0.7],
    [124.7, 1.1],
    [124.7, 1.1],
    [124.8, 1.2],
    [124.8, 1.4],
    [124.9, 1.4],
    [125.0, 1.5],
    [125.2, 1.5],
    [125.4, 2.3],
    [125.5, 2.8],
    [125.5, 3.1],
    [125.5, 3.7],
    [124.2, 4.0],
    [127.9, 1.7],
    [127.6, 1.5],
    [127.5, 1.4],
    [127.4, 1.3],
    [127.3, 1.2],
    [127.3, 0.8],
    [127.4, 0.4],
    [127.4, 0.3],
    [117.9, 4.4],
    [121.1, 5.9],
    [125.4, 5.4],
    [125.1, 6.4],
    [125.3, 7.0],
    [126.4, 7.4],
    [126.1, 7.4],
    [124.3, 7.6],
    [124.5, 7.6],
    [124.5, 7.7],
    [124.8, 7.9],
    [125.1, 7.9],
    [123.6, 8.2],
    [124.9, 8.8],
    [124.7, 9.2],
    [125.5, 9.6],
    [123.2, 9.3],
    [123.1, 10.4],
    [123.2, 10.6],
    [123.2, 10.8],
    [125.2, 10.3],
    [124.9, 10.9],
    [124.5, 11.5],
    [124.0, 12.8],
    [124.0, 13.0],
    [123.7, 13.3],
    [123.6, 13.3],
    [123.6, 13.4],
    [123.5, 13.5],
    [123.4, 13.7],
    [122.8, 14.0],
    [122.0, 13.2],
    [121.1, 13.5],
    [120.9, 13.7],
    [121.5, 14.1],
    [121.3, 14.1],
    [121.2, 14.1],
    [121.0, 14.0],
    [121.3, 14.3],
    [120.5, 14.5],
    [120.4, 14.7],
    [120.4, 15.1],
    [120.7, 15.2],
    [120.8, 15.8],
    [120.5, 16.3],
    [121.0, 17.1],
    [121.1, 17.3],
    [121.1, 17.3],
    [122.1, 18.2],
    [121.9, 18.8],
    [122.2, 19.1],
    [121.9, 19.5],
    [121.8, 20.3],
    [122.0, 20.5],
    [109.8, 20.8],
    [109.1, 15.4],
    [108.0, 14.9],
    [108.2, 11.6],
    [107.2, 10.8],
    [109.0, 10.2],
    [109.0, 9.8],
    [95.2, 20.9],
    [95.1, 22.3],
    [96.0, 22.7],
    [98.5, 25.3],
    [134.8, 20.9],
    [132.2, 19.2],
    [121.2, 21.8],
    [121.8, 24.0],
    [121.9, 24.8],
    [121.5, 25.2],
    [122.3, 25.4],
    [122.1, 25.6],
    [122.5, 26.2],
    [124.0, 24.6],
    [128.3, 27.8],
    [129.6, 29.4],
    [129.7, 29.5],
    [129.9, 29.8],
    [129.9, 30.0],
    [130.2, 30.4],
    [130.3, 30.8],
    [130.6, 31.2],
    [130.7, 31.6],
    [130.6, 31.8],
    [130.9, 31.9],
    [130.3, 32.7],
    [131.1, 32.9],
    [131.3, 33.1],
    [131.4, 33.3],
    [131.6, 34.5],
    [132.6, 35.1],
    [133.3, 36.2],
    [133.5, 35.4],
    [134.7, 35.5],
    [139.1, 34.9],
    [139.0, 35.2],
    [138.7, 35.3],
    [138.3, 36.1],
    [137.5, 35.9],
    [136.8, 36.1],
    [137.6, 36.1],
    [137.6, 36.2],
    [137.6, 36.6],
    [138.0, 36.9],
    [138.1, 36.9],
    [138.1, 36.8],
    [138.1, 36.7],
    [138.5, 36.4],
    [138.6, 36.6],
    [138.5, 36.7],
    [138.9, 36.5],
    [139.2, 36.5],
    [139.3, 36.9],
    [139.4, 36.8],
    [139.5, 36.8],
    [139.5, 36.8],
    [139.8, 36.9],
    [140.0, 37.1],
    [139.6, 37.4],
    [140.1, 37.6],
    [140.3, 37.6],
    [140.3, 37.7],
    [140.4, 38.1],
    [140.2, 38.6],
    [140.7, 38.7],
    [140.8, 38.9],
    [140.0, 39.1],
    [140.8, 39.7],
    [141.0, 39.8],
    [140.9, 39.9],
    [140.8, 40.0],
    [139.9, 39.9],
    [139.7, 39.9],
    [140.3, 40.6],
    [140.9, 40.5],
    [140.9, 40.6],
    [141.1, 41.3],
    [141.1, 41.4],
    [139.4, 34.7],
    [139.3, 34.5],
    [139.3, 34.4],
    [139.2, 34.2],
    [139.5, 34.1],
    [139.7, 33.4],
    [139.8, 33.1],
    [139.8, 32.4],
    [139.9, 31.9],
    [140.0, 31.3],
    [140.3, 30.5],
    [140.8, 29.2],
    [140.9, 27.2],
    [144.5, 26.1],
    [141.1, 26.1],
    [141.2, 25.4],
    [141.3, 24.7],
    [141.5, 24.3],
    [141.9, 23.5],
    [142.3, 23.1],
    [143.4, 21.9],
    [143.7, 21.8],
    [142.9, 21.0],
    [143.2, 20.3],
    [144.9, 20.5],
    [145.0, 20.4],
    [145.1, 20.1],
    [145.4, 19.7],
    [145.7, 18.8],
    [145.8, 18.1],
    [145.8, 17.6],
    [145.8, 17.3],
    [145.8, 16.7],
    [145.7, 16.3],
    [145.6, 15.6],
    [145.3, 15.0],
    [139.4, 41.5],
    [141.2, 41.8],
    [140.7, 42.1],
    [140.4, 42.1],
    [140.8, 42.5],
    [140.6, 42.9],
    [140.8, 42.8],
    [140.9, 42.8],
    [141.2, 42.5],
    [141.3, 42.7],
    [141.3, 45.2],
    [142.7, 43.4],
    [142.9, 43.7],
    [143.0, 43.4],
    [143.1, 43.3],
    [144.0, 43.4],
    [144.4, 43.5],
    [144.6, 43.6],
    [145.1, 44.1],
    [145.2, 44.1],
    [145.5, 43.8],
    [145.7, 44.0],
    [146.1, 44.4],
    [146.3, 44.4],
    [146.9, 44.5],
    [147.0, 44.6],
    [147.1, 44.8],
    [147.4, 44.8],
    [147.2, 45.0],
    [147.9, 45.0],
    [148.0, 45.1],
    [147.9, 45.4],
    [148.4, 45.2],
    [148.8, 45.4],
    [148.8, 45.5],
    [149.7, 45.8],
    [149.8, 45.9],
    [149.9, 45.9],
    [150.1, 46.0],
    [150.5, 46.1],
    [150.9, 46.5],
    [151.3, 46.5],
    [151.8, 46.8],
    [151.8, 46.8],
    [151.9, 46.9],
    [152.1, 47.0],
    [152.2, 47.1],
    [152.5, 47.3],
    [152.8, 47.5],
    [152.9, 47.6],
    [153.0, 47.8],
    [153.3, 48.1],
    [153.2, 48.1],
    [153.3, 48.3],
    [153.5, 49.0],
    [153.9, 49.0],
    [154.0, 48.8],
    [154.2, 48.9],
    [154.5, 49.1],
    [154.7, 49.3],
    [154.8, 49.6],
    [155.0, 50.2],
    [155.3, 50.3],
    [155.4, 50.1],
    [155.4, 50.2],
    [155.5, 50.3],
    [156.0, 50.5],
    [156.0, 50.7],
    [155.6, 50.9],
    [156.7, 51.1],
    [156.9, 51.3],
    [156.7, 51.4],
    [156.6, 51.6],
    [156.9, 51.4],
    [157.2, 51.5],
    [157.3, 51.6],
    [157.3, 51.6],
    [157.3, 51.7],
    [157.5, 51.8],
    [157.4, 51.9],
    [157.5, 52.0],
    [157.7, 52.1],
    [157.8, 52.1],
    [157.5, 52.1],
    [157.3, 52.2],
    [157.4, 52.2],
    [157.3, 52.3],
    [157.6, 52.2],
    [158.2, 52.5],
    [157.8, 52.3],
    [157.8, 52.4],
    [157.9, 52.4],
    [158.0, 52.6],
    [157.3, 52.5],
    [157.0, 52.6],
    [157.6, 52.6],
    [158.3, 52.7],
    [158.3, 52.8],
    [158.5, 52.9],
    [158.3, 52.9],
    [157.8, 52.9],
    [158.7, 53.3],
    [158.8, 53.3],
    [158.1, 53.6],
    [158.4, 53.6],
    [158.9, 53.6],
    [159.1, 53.6],
    [158.4, 53.9],
    [158.1, 53.9],
    [159.4, 54.0],
    [159.4, 54.0],
    [159.7, 54.1],
    [160.0, 54.3],
    [159.8, 54.5],
    [160.0, 54.5],
    [160.3, 54.5],
    [160.3, 54.6],
    [160.5, 54.8],
    [160.7, 55.0],
    [160.7, 55.0],
    [160.8, 55.1],
    [160.3, 55.1],
    [160.6, 55.2],
    [161.8, 55.9],
    [160.3, 55.8],
    [160.5, 55.8],
    [160.6, 55.9],
    [160.6, 56.0],
    [160.6, 56.0],
    [160.6, 56.1],
    [160.5, 56.1],
    [160.8, 56.4],
    [160.9, 56.5],
    [161.4, 56.7],
    [167.3, 55.4],
    [157.4, 54.7],
    [157.7, 55.7],
    [158.0, 55.8],
    [157.8, 55.9],
    [158.5, 55.2],
    [158.7, 55.4],
    [158.4, 55.6],
    [158.8, 55.6],
    [158.4, 56.1],
    [157.8, 56.5],
    [158.4, 56.4],
    [158.7, 56.3],
    [158.8, 56.3],
    [159.0, 56.4],
    [158.8, 56.4],
    [158.5, 56.6],
    [159.0, 56.8],
    [159.5, 56.5],
    [159.7, 56.7],
    [159.7, 56.8],
    [159.8, 56.8],
    [160.0, 56.9],
    [159.8, 57.0],
    [159.9, 57.1],
    [160.4, 57.1],
    [160.1, 57.2],
    [160.2, 57.3],
    [159.8, 57.3],
    [160.0, 57.3],
    [160.1, 57.4],
    [160.2, 57.4],
    [160.4, 57.4],
    [160.5, 57.5],
    [160.4, 57.7],
    [160.6, 57.7],
    [160.7, 57.8],
    [160.3, 57.8],
    [160.5, 57.9],
    [160.7, 58.0],
    [160.8, 58.0],
    [160.8, 58.1],
    [160.8, 58.2],
    [161.0, 58.2],
    [160.9, 58.3],
    [161.1, 58.4],
    [160.6, 58.4],
    [165.6, 66.1],
    [165.2, 67.2],
    [143.7, 66.4],
    [135.5, 44.5],
    [118.1, 56.3],
    [117.5, 56.2],
    [103.2, 50.5],
    [102.5, 51.5],
    [99.0, 52.7],
    [98.0, 52.3],
    [99.7, 48.2],
    [102.8, 48.7],
    [109.1, 47.1],
    [114.0, 45.3],
    [106.7, 45.3],
    [89.2, 42.9],
    [86.5, 42.5],
    [80.2, 35.5],
    [91.7, 35.8],
    [113.3, 40.0],
    [113.0, 41.5],
    [125.9, 49.4],
    [126.1, 48.7],
    [128.8, 44.1],
    [126.5, 42.3],
    [128.1, 42.0],
    [128.0, 41.3],
    [127.3, 38.3],
    [130.9, 37.5],
    [126.5, 33.4],
    [176.0, 52.4],
    [177.6, 52.1],
    [178.1, 52.0],
    [178.3, 52.0],
    [178.5, 51.9],
    [179.6, 51.9],
    [-178.8, 51.8],
    [-178.1, 51.9],
    [-178.0, 51.9],
    [-177.4, 51.9],
    [-177.2, 51.9],
    [-176.7, 51.9],
    [-176.6, 52.0],
    [-176.1, 52.1],
    [-175.5, 52.2],
    [-175.1, 52.2],
    [-174.9, 52.0],
    [-174.2, 52.4],
    [-172.5, 52.3],
    [-171.2, 52.5],
    [-171.1, 52.6],
    [-170.6, 52.6],
    [-170.1, 52.7],
    [-170.1, 52.9],
    [-169.9, 52.8],
    [-169.8, 53.1],
    [-169.7, 53.0],
    [-168.7, 53.1],
    [-168.5, 53.1],
    [-168.1, 53.4],
    [-168.0, 53.9],
    [-166.9, 53.9],
    [-166.7, 54.0],
    [-166.0, 54.1],
    [-164.7, 54.5],
    [-164.3, 54.7],
    [-164.0, 54.7],
    [-163.7, 54.7],
    [-163.6, 54.8],
    [-163.2, 55.4],
    [-162.8, 55.1],
    [-162.3, 55.2],
    [-162.1, 55.3],
    [-161.9, 55.4],
    [-161.9, 55.4],
    [-161.2, 55.6],
    [-160.0, 55.9],
    [-159.8, 56.0],
    [-159.4, 56.2],
    [-158.8, 56.5],
    [-158.2, 56.9],
    [-157.2, 57.0],
    [-157.0, 57.1],
    [-156.8, 57.4],
    [-155.4, 57.9],
    [-156.4, 57.7],
    [-156.5, 57.8],
    [-155.4, 58.2],
    [-155.2, 58.2],
    [-155.1, 58.2],
    [-155.0, 58.3],
    [-155.2, 58.3],
    [-155.1, 58.3],
    [-154.7, 58.3],
    [-154.5, 58.4],
    [-154.4, 58.4],
    [-154.4, 58.5],
    [-154.3, 58.5],
    [-154.1, 58.6],
    [-153.7, 58.8],
    [-153.5, 58.9],
    [-153.4, 59.4],
    [-153.1, 60.0],
    [-152.7, 60.5],
    [-152.3, 61.3],
    [-152.5, 61.6],
    [-164.3, 66.3],
    [-163.9, 65.6],
    [-170.4, 63.6],
    [-162.1, 63.4],
    [-164.5, 61.4],
    [-166.3, 60.0],
    [-170.3, 57.2],
    [-148.4, 64.1],
    [-144.1, 62.2],
    [-144.0, 62.0],
    [-143.1, 62.1],
    [-141.8, 61.4],
    [-135.7, 57.0],
    [-133.1, 56.5],
    [-133.3, 55.2],
    [-131.0, 55.3],
    [-137.4, 62.9],
    [-135.4, 60.4],
    [-133.3, 59.7],
    [-132.0, 58.6],
    [-131.3, 58.4],
    [-130.6, 57.7],
    [-130.7, 57.4],
    [-131.3, 56.8],
    [-130.6, 56.6],
    [-128.9, 55.1],
    [-130.2, 54.7],
    [-128.7, 52.5],
    [-124.7, 52.5],
    [-123.7, 52.9],
    [-120.6, 52.3],
    [-126.3, 51.4],
    [-123.4, 50.8],
    [-123.5, 50.6],
    [-123.0, 49.9],
    [-123.0, 49.8],
    [-121.8, 48.8],
    [-121.1, 48.1],
    [-121.8, 46.9],
    [-121.5, 46.2],
    [-122.2, 46.2],
    [-122.1, 45.9],
    [-121.8, 45.9],
    [-121.7, 45.4],
    [-121.8, 44.7],
    [-121.8, 44.4],
    [-121.9, 44.4],
    [-121.8, 44.3],
    [-121.8, 44.3],
    [-121.8, 44.2],
    [-121.8, 44.1],
    [-121.7, 44.0],
    [-121.8, 43.6],
    [-121.2, 43.7],
    [-120.9, 43.5],
    [-120.8, 43.5],
    [-120.7, 43.4],
    [-122.1, 43.2],
    [-122.1, 42.9],
    [-122.2, 42.5],
    [-118.7, 43.1],
    [-117.8, 43.0],
    [-117.4, 43.0],
    [-117.6, 43.6],
    [-122.2, 41.4],
    [-121.6, 41.6],
    [-121.4, 41.2],
    [-121.4, 41.0],
    [-121.6, 40.8],
    [-121.6, 40.7],
    [-121.4, 40.6],
    [-121.5, 40.5],
    [-120.8, 40.6],
    [-122.8, 39.0],
    [-119.0, 38.0],
    [-119.0, 37.9],
    [-119.0, 37.7],
    [-118.9, 37.7],
    [-119.0, 37.6],
    [-117.5, 37.0],
    [-118.3, 36.4],
    [-117.8, 36.0],
    [-116.6, 34.7],
    [-115.8, 34.5],
    [-114.4, 43.1],
    [-113.5, 43.4],
    [-113.2, 42.9],
    [-112.5, 43.5],
    [-110.7, 44.4],
    [-119.7, 39.4],
    [-116.0, 38.5],
    [-116.6, 36.8],
    [-113.6, 37.3],
    [-113.1, 37.3],
    [-112.4, 37.3],
    [-112.7, 37.6],
    [-112.5, 39.0],
    [-107.0, 39.6],
    [-113.1, 36.4],
    [-111.5, 35.4],
    [-105.9, 33.8],
    [-108.0, 34.8],
    [-106.6, 35.9],
    [-104.1, 36.4],
    [-129.6, 46.5],
    [-130.2, 45.0],
    [-124.2, 31.7],
    [-155.3, 18.9],
    [-155.3, 19.4],
    [-155.6, 19.5],
    [-155.5, 19.8],
    [-155.9, 19.7],
    [-156.6, 20.6],
    [-156.2, 20.7],
    [-157.8, 21.4],
    [-158.8, 21.7],
    [-163.8, 23.6],
    [-104.3, 9.8],
    [-86.2, 0.8],
    [-148.9, -17.6],
    [-148.6, -17.6],
    [-148.7, -18.3],
    [-148.1, -17.9],
    [-140.2, -29.0],
    [-109.4, -27.1],
    [178.8, -49.7],
    [-140.3, -53.9],
    [-143.2, -56.0],
    [-115.3, 32.4],
    [-113.5, 31.8],
    [-116.0, 30.5],
    [-114.4, 29.8],
    [-114.5, 29.3],
    [-113.5, 29.1],
    [-118.3, 29.1],
    [-113.8, 28.5],
    [-115.0, 28.0],
    [-112.6, 27.5],
    [-111.9, 27.4],
    [-110.8, 19.3],
    [-110.9, 18.8],
    [-104.4, 24.1],
    [-104.7, 21.4],
    [-104.7, 21.3],
    [-104.5, 21.1],
    [-104.8, 20.6],
    [-103.6, 19.5],
    [-102.3, 19.5],
    [-99.8, 19.7],
    [-99.5, 19.1],
    [-99.1, 19.1],
    [-98.8, 19.2],
    [-99.0, 19.3],
    [-98.8, 19.7],
    [-98.7, 19.9],
    [-98.7, 19.3],
    [-98.6, 19.2],
    [-98.6, 19.0],
    [-98.0, 19.2],
    [-97.3, 19.0],
    [-95.2, 18.6],
    [-93.2, 17.4],
    [-92.1, 15.1],
    [-91.9, 15.0],
    [-91.6, 14.8],
    [-91.5, 14.8],
    [-91.4, 14.7],
    [-91.2, 14.6],
    [-91.2, 14.6],
    [-90.9, 14.5],
    [-90.9, 14.5],
    [-90.7, 14.5],
    [-90.6, 14.4],
    [-90.4, 14.3],
    [-90.4, 14.2],
    [-90.1, 14.0],
    [-90.0, 14.3],
    [-89.7, 14.1],
    [-89.9, 14.3],
    [-89.8, 14.4],
    [-89.7, 14.4],
    [-89.6, 14.5],
    [-89.6, 14.8],
    [-89.3, 14.6],
    [-89.8, 13.9],
    [-89.6, 14.0],
    [-89.5, 14.3],
    [-89.6, 13.9],
    [-89.6, 13.8],
    [-89.6, 13.9],
    [-89.3, 13.7],
    [-89.1, 13.9],
    [-89.1, 13.7],
    [-88.9, 13.6],
    [-88.8, 13.7],
    [-88.5, 13.4],
    [-88.5, 13.5],
    [-88.5, 13.4],
    [-88.3, 13.5],
    [-88.3, 13.4],
    [-87.9, 13.3],
    [-87.8, 13.2],
    [-87.6, 13.3],
    [-87.6, 13.3],
    [-88.0, 15.0],
    [-86.9, 16.1],
    [-87.6, 13.0],
    [-87.0, 12.7],
    [-86.8, 12.6],
    [-86.8, 12.5],
    [-86.7, 12.5],
    [-86.7, 12.5],
    [-86.5, 12.4],
    [-86.3, 12.2],
    [-86.3, 12.1],
    [-86.2, 12.0],
    [-86.0, 11.9],
    [-86.0, 11.8],
    [-85.8, 11.7],
    [-85.6, 11.5],
    [-85.5, 11.4],
    [-83.9, 12.7],
    [-85.5, 11.0],
    [-85.3, 10.8],
    [-85.2, 10.7],
    [-85.0, 10.7],
    [-85.1, 10.5],
    [-84.7, 10.5],
    [-84.7, 10.3],
    [-84.3, 10.4],
    [-84.4, 10.3],
    [-84.2, 10.2],
    [-84.1, 10.1],
    [-83.9, 10.0],
    [-83.8, 10.0],
    [-82.6, 8.8],
    [-80.9, 8.5],
    [-75.3, 5.1],
    [-75.3, 4.9],
    [-75.4, 4.8],
    [-75.3, 4.7],
    [-75.4, 4.5],
    [-76.0, 2.9],
    [-76.4, 2.3],
    [-76.6, 2.1],
    [-76.8, 1.6],
    [-76.9, 1.5],
    [-77.4, 1.2],
    [-77.7, 1.1],
    [-77.9, 1.0],
    [-78.0, 0.8],
    [-77.6, 0.6],
    [-78.4, 0.3],
    [-78.3, 0.1],
    [-78.0, 0.0],
    [-77.7, -0.1],
    [-78.5, 0.0],
    [-78.6, -0.2],
    [-78.6, -0.4],
    [-78.3, -0.4],
    [-78.1, -0.5],
    [-77.7, -0.4],
    [-77.6, -0.5],
    [-78.7, -0.7],
    [-78.4, -0.7],
    [-78.9, -0.8],
    [-78.4, -1.5],
    [-78.6, -1.8],
    [-78.3, -2.0],
    [-91.6, -0.4],
    [-91.5, -0.0],
    [-91.3, 0.0],
    [-91.3, -0.2],
    [-91.1, -0.4],
    [-91.2, -0.8],
    [-91.4, -0.9],
    [-90.7, 0.6],
    [-90.5, 0.3],
    [-90.0, 0.3],
    [-90.8, -0.2],
    [-90.3, -0.6],
    [-90.4, -1.3],
    [-89.5, -0.9],
    [-72.6, -15.2],
    [-72.6, -15.5],
    [-72.3, -15.4],
    [-71.9, -15.8],
    [-71.2, -14.4],
    [-71.5, -16.2],
    [-71.4, -16.3],
    [-70.9, -16.4],
    [-70.9, -16.6],
    [-70.6, -16.8],
    [-70.4, -17.0],
    [-70.2, -17.2],
    [-69.8, -17.5],
    [-69.8, -17.7],
    [-69.5, -17.9],
    [-69.0, -18.0],
    [-68.9, -17.9],
    [-68.5, -18.2],
    [-68.8, -18.3],
    [-69.2, -18.2],
    [-69.1, -18.4],
    [-69.2, -18.4],
    [-68.1, -18.5],
    [-68.8, -18.6],
    [-69.1, -18.7],
    [-68.5, -19.1],
    [-68.8, -19.1],
    [-69.0, -19.4],
    [-68.7, -19.5],
    [-66.5, -19.8],
    [-68.5, -20.7],
    [-68.6, -20.8],
    [-68.2, -20.8],
    [-68.5, -20.9],
    [-68.5, -21.2],
    [-67.8, -21.2],
    [-68.2, -21.3],
    [-67.5, -21.5],
    [-66.9, -21.6],
    [-66.5, -21.7],
    [-67.5, -21.7],
    [-68.2, -21.8],
    [-68.4, -21.9],
    [-67.9, -21.9],
    [-68.1, -22.1],
    [-68.1, -22.2],
    [-67.4, -22.2],
    [-67.2, -22.3],
    [-68.0, -22.3],
    [-67.9, -22.4],
    [-67.9, -22.6],
    [-67.9, -22.7],
    [-67.9, -22.8],
    [-67.6, -22.9],
    [-67.8, -23.0],
    [-67.7, -23.2],
    [-67.6, -23.3],
    [-67.7, -23.3],
    [-67.7, -23.4],
    [-67.7, -23.6],
    [-67.5, -23.7],
    [-67.6, -23.8],
    [-67.9, -23.8],
    [-68.1, -24.2],
    [-68.2, -24.2],
    [-67.8, -24.3],
    [-68.2, -24.4],
    [-68.6, -24.3],
    [-68.5, -24.7],
    [-66.5, -24.0],
    [-68.4, -25.1],
    [-68.5, -25.2],
    [-68.5, -25.3],
    [-68.6, -25.4],
    [-68.0, -25.5],
    [-67.5, -26.1],
    [-68.6, -26.5],
    [-68.4, -26.6],
    [-68.1, -26.6],
    [-67.7, -26.8],
    [-68.4, -26.8],
    [-68.5, -27.1],
    [-68.5, -27.2],
    [-69.1, -27.3],
    [-80.1, -26.3],
    [-78.8, -33.7],
    [-76.8, -33.6],
    [-69.8, -33.4],
    [-69.9, -33.8],
    [-69.8, -34.2],
    [-70.3, -34.6],
    [-70.4, -34.8],
    [-70.6, -35.2],
    [-70.8, -35.5],
    [-70.5, -35.6],
    [-70.8, -35.6],
    [-70.8, -35.7],
    [-70.8, -35.7],
    [-70.6, -36.0],
    [-70.8, -36.0],
    [-71.2, -36.2],
    [-71.0, -36.3],
    [-70.9, -36.4],
    [-69.2, -36.4],
    [-70.4, -36.6],
    [-71.4, -36.9],
    [-70.0, -37.1],
    [-69.6, -37.5],
    [-71.3, -37.4],
    [-71.2, -37.8],
    [-71.5, -37.9],
    [-71.6, -38.3],
    [-71.6, -38.4],
    [-71.1, -38.4],
    [-71.7, -38.7],
    [-71.5, -39.0],
    [-71.8, -39.2],
    [-71.7, -39.3],
    [-71.8, -39.3],
    [-71.9, -39.4],
    [-71.7, -39.5],
    [-71.5, -39.6],
    [-71.6, -39.9],
    [-72.0, -39.9],
    [-72.1, -40.3],
    [-72.2, -40.5],
    [-72.1, -40.6],
    [-72.0, -40.5],
    [-71.9, -40.8],
    [-72.2, -40.8],
    [-72.3, -41.0],
    [-72.5, -41.1],
    [-72.6, -41.3],
    [-72.3, -41.2],
    [-72.4, -41.8],
    [-72.4, -41.9],
    [-71.6, -42.1],
    [-72.6, -42.4],
    [-72.4, -42.8],
    [-72.6, -42.8],
    [-72.8, -43.2],
    [-72.8, -43.4],
    [-72.5, -43.7],
    [-72.9, -44.1],
    [-72.5, -44.3],
    [-73.1, -44.7],
    [-73.2, -45.1],
    [-73.0, -45.9],
    [-73.6, -49.0],
    [-73.3, -49.4],
    [-73.8, -50.2],
    [-73.7, -51.0],
    [-73.4, -52.3],
    [-70.0, -52.0],
    [-70.3, -54.9],
    [-63.2, 17.6],
    [-63.0, 17.5],
    [-62.8, 17.4],
    [-62.6, 17.1],
    [-62.2, 16.7],
    [-61.7, 16.0],
    [-61.4, 15.6],
    [-61.4, 15.5],
    [-61.3, 15.3],
    [-61.4, 15.2],
    [-61.2, 14.8],
    [-61.0, 13.8],
    [-61.2, 13.3],
    [-61.6, 12.3],
    [-61.7, 12.1],
    [-23.8, 64.8],
    [-23.2, 64.9],
    [-22.2, 64.9],
    [-23.3, 63.7],
    [-22.5, 63.9],
    [-22.1, 63.9],
    [-21.8, 63.9],
    [-21.3, 64.2],
    [-20.9, 64.0],
    [-20.6, 64.6],
    [-20.0, 64.7],
    [-18.9, 64.8],
    [-19.3, 64.6],
    [-20.3, 63.4],
    [-19.6, 63.6],
    [-19.0, 63.6],
    [-19.6, 63.8],
    [-19.2, 63.9],
    [-19.7, 63.9],
    [-19.7, 64.0],
    [-17.3, 64.4],
    [-17.8, 64.5],
    [-17.5, 64.6],
    [-17.9, 64.7],
    [-16.7, 64.6],
    [-16.7, 65.0],
    [-16.6, 65.4],
    [-16.8, 65.7],
    [-16.8, 65.9],
    [-17.1, 66.3],
    [-16.6, 64.0],
    [-16.6, 64.3],
    [-18.5, 66.7],
    [-8.2, 71.1],
    [-65.6, 88.3],
    [-34.5, 49.0],
    [-25.8, 39.9],
    [-38.1, 38.7],
    [-31.2, 39.4],
    [-28.7, 38.6],
    [-28.4, 38.5],
    [-28.1, 38.6],
    [-28.0, 39.0],
    [-27.3, 38.7],
    [-26.6, 38.2],
    [-25.8, 37.9],
    [-25.7, 37.8],
    [-25.5, 37.8],
    [-25.3, 37.8],
    [-25.9, 37.6],
    [-17.8, 28.6],
    [-18.0, 27.7],
    [-16.6, 28.3],
    [-15.6, 28.0],
    [-14.0, 28.4],
    [-13.6, 29.0],
    [-24.4, 14.9],
    [-24.7, 14.8],
    [-25.2, 17.1],
    [-25.0, 16.8],
    [-21.8, 7.0],
    [-21.4, 4.2],
    [-15.8, -0.6],
    [-24.5, -3.5],
    [-14.4, -7.9],
    [-29.3, -20.5],
    [-12.3, -37.1],
    [3.4, -54.4],
    [5.5, -53.9],
    [163.2, -66.8],
    [162.5, -66.4],
    [164.8, -67.4],
    [165.5, -72.7],
    [164.6, -73.4],
    [164.7, -74.3],
    [163.0, -76.8],
    [167.2, -77.5],
    [163.6, -78.2],
    [-136.0, -76.0],
    [-132.3, -75.8],
    [-126.9, -77.2],
    [-126.7, -73.4],
    [-115.8, -75.8],
    [-112.1, -76.3],
    [-99.4, -74.3],
    [-90.6, -68.8],
    [-60.6, -63.0],
    [-57.9, -62.1],
    [-56.8, -62.0],
    [-55.8, -63.6],
    [-60.0, -65.0],
    [-72.2, -56.2],
    [-27.4, -59.4],
    [-26.6, -59.0],
    [-26.5, -57.8],
    [-26.7, -57.1],
    [-27.2, -56.7],
    [-28.1, -56.7],
    [-27.6, -56.3],
    [-28.1, -55.9]
];
