/*
 * Copyright (C) 2017-2019 HERE Europe B.V.
 * Licensed under Apache 2.0, see full license in LICENSE
 * SPDX-License-Identifier: Apache-2.0
 */

export class EarthConstants {
    /** The equatorial circumference in meters. */
    static EQUATORIAL_CIRCUMFERENCE: number = 40075016.6855784861531768177614;

    /** The equatorial radius in meters. */
    static EQUATORIAL_RADIUS: number = 6378137.0;

    /** The lowest point on earth (Dead Sea) in meters. */
    static MIN_ELEVATION: number = -433.0;

    /** The highest point on earth (Mt. Everest) in meters. */
    static MAX_ELEVATION: number = 8848.0;

    /** The highest artificial structure (building) on earth, Burj Khalifa tower in Dubai */
    static MAX_BUILDING_HEIGHT: number = 828;
}
