# Harp.gl Webpack Utilities

## Usage

Install the webpack utilities into your project:

```shell
npm install --save-dev @here/harp-webpack-utils
```

Add the following lines to your `webpack.config.js`:

```javascript
const { addHarpWebpackConfig } = require("@here/harp-webpack-utils/scripts/HarpWebpackConfig");
const myConfig = {};
module.exports = addHarpWebpackConfig(
    myConfig,
    { mainEntry: "./index.js", decoderEntry: "./harp-gl-decoders.js", htmlTemplate: "./index.html" }
);
```

`myConfig` is your existing Webpack configuration. Configuration values in `myConfig` will override any values generated by `addHarpWebpackConfig`.
`./index.js` is the path to your main application code. Will be used as the entry point for the main application bundle. May be omitted if Webpack `entry` configuration is included in `myConfig`.
`./harp-gl-decoders.js` is the path to your decoder service. Will be used as the entry point for the web worker decoder bundle. If omitted no decoder bundle will be created.
`./index.html` is the path to your HTML template index page. May be omitted if HTML configuration is included in `myConfig`.
