/*
Language: Axapta
Author: Dmitri Roudakov <dmitri@roudakov.ru>
*/

function(hljs) {
  return {
    defaultMode: {
      keywords: 'false int abstract private char interface boolean static null if for true ' +
        'while long throw finally protected extends final implements return void enum else ' +
        'break new catch byte super class case short default double public try this switch ' +
        'continue reverse firstfast firstonly forupdate nofetch sum avg minof maxof count ' +
        'order group by asc desc index hint like dispaly edit client server ttsbegin ' +
        'ttscommit str real date container anytype common div mod',
      contains: [
        hljs.C_LINE_COMMENT_MODE,
        hljs.C_BLOCK_COMMENT_MODE,
        hljs.APOS_STRING_MODE,
        hljs.QUOTE_STRING_MODE,
        hljs.C_NUMBER_MODE,
        {
          className: 'preprocessor',
          begin: '#', end: '$'
        },
        {
          className: 'class',
          beginWithKeyword: true, end: '{',
          illegal: ':',
          keywords: 'class interface',
          contains: [
            {
              className: 'inheritance',
              beginWithKeyword: true,
              keywords: 'extends implements',
              relevance: 10
            },
            {
              className: 'title',
              begin: hljs.UNDERSCORE_IDENT_RE
            }
          ]
        }
      ]
    }
  };
}
