/*
Language: Diff
Description: Unified and context diff
Author: Vasily Polovnyov <vast@whiteants.net>
*/

function(hljs) {
  return {
    case_insensitive: true,
    defaultMode: {
      contains: [
        {
          className: 'chunk',
          begin: '^\\@\\@ +\\-\\d+,\\d+ +\\+\\d+,\\d+ +\\@\\@$',
          relevance: 10
        },
        {
          className: 'chunk',
          begin: '^\\*\\*\\* +\\d+,\\d+ +\\*\\*\\*\\*$',
          relevance: 10
        },
        {
          className: 'chunk',
          begin: '^\\-\\-\\- +\\d+,\\d+ +\\-\\-\\-\\-$',
          relevance: 10
        },
        {
          className: 'header',
          begin: 'Index: ', end: '$'
        },
        {
          className: 'header',
          begin: '=====', end: '=====$'
        },
        {
          className: 'header',
          begin: '^\\-\\-\\-', end: '$'
        },
        {
          className: 'header',
          begin: '^\\*{3} ', end: '$'
        },
        {
          className: 'header',
          begin: '^\\+\\+\\+', end: '$'
        },
        {
          className: 'header',
          begin: '\\*{5}', end: '\\*{5}$'
        },
        {
          className: 'addition',
          begin: '^\\+', end: '$'
        },
        {
          className: 'deletion',
          begin: '^\\-', end: '$'
        },
        {
          className: 'change',
          begin: '^\\!', end: '$'
        }
      ]
    }
  };
}
