/*
Language: Markdown
Requires: xml.js
Author: John Crepezzi <john.crepezzi@gmail.com>
Website: http://seejohncode.com/
*/

function(hljs) {
  return {
    case_insensitive: true,
    defaultMode: {
      contains: [
        // highlight headers
        {
          className: 'header',
          begin: '^#{1,3}', end: '$'
        },
        {
          className: 'header',
          begin: '^.+?\\n[=-]{2,}$'
        },
        // inline html
        {
          begin: '<', end: '>',
          subLanguage: 'xml',
          relevance: 0
        },
        // lists (indicators only)
        {
          className: 'bullet',
          begin: '^([*+-]|(\\d+\\.))\\s+'
        },
        // strong segments
        {
          className: 'strong',
          begin: '[*_]{2}.+?[*_]{2}'
        },
        // emphasis segments
        {
          className: 'emphasis',
          begin: '\\*.+?\\*'
        },
        {
          className: 'emphasis',
          begin: '_.+?_',
          relevance: 0
        },
        // blockquotes
        {
          className: 'blockquote',
          begin: '^>\\s+', end: '$'
        },
        // code snippets
        {
          className: 'code',
          begin: '`.+?`'
        },
        {
          className: 'code',
          begin: '^    ', end: '$',
          relevance: 0
        },
        // horizontal rules
        {
          className: 'horizontal_rule',
          begin: '^-{3,}', end: '$'
        },
        // using links - title and link
        {
          begin: '\\[.+?\\]\\(.+?\\)',
          returnBegin: true,
          contains: [
            {
              className: 'link_label',
              begin: '\\[.+\\]'
            },
            {
              className: 'link_url',
              begin: '\\(', end: '\\)',
              excludeBegin: true, excludeEnd: true
            }
          ]
        }
      ]
    }
  };
}
