/*
Language: SQL
*/

function(hljs) {
  return {
    case_insensitive: true,
    defaultMode: {
      illegal: '[^\\s]',
      contains: [
        {
          className: 'operator',
          begin: '(begin|start|commit|rollback|savepoint|lock|alter|create|drop|rename|call|delete|do|handler|insert|load|replace|select|truncate|update|set|show|pragma|grant)\\b', end: ';', endsWithParent: true,
          keywords: {
            keyword: 'all partial global month current_timestamp using go revoke smallint ' +
              'indicator end-exec disconnect zone with character assertion to add current_user ' +
              'usage input local alter match collate real then rollback get read timestamp ' +
              'session_user not integer bit unique day minute desc insert execute like ilike|2 ' +
              'level decimal drop continue isolation found where constraints domain right ' +
              'national some module transaction relative second connect escape close system_user ' +
              'for deferred section cast current sqlstate allocate intersect deallocate numeric ' +
              'public preserve full goto initially asc no key output collation group by union ' +
              'session both last language constraint column of space foreign deferrable prior ' +
              'connection unknown action commit view or first into float year primary cascaded ' +
              'except restrict set references names table outer open select size are rows from ' +
              'prepare distinct leading create only next inner authorization schema ' +
              'corresponding option declare precision immediate else timezone_minute external ' +
              'varying translation true case exception join hour default double scroll value ' +
              'cursor descriptor values dec fetch procedure delete and false int is describe ' +
              'char as at in varchar null trailing any absolute current_time end grant ' +
              'privileges when cross check write current_date pad begin temporary exec time ' +
              'update catalog user sql date on identity timezone_hour natural whenever interval ' +
              'work order cascade diagnostics nchar having left call do handler load replace ' +
              'truncate start lock show pragma',
            aggregate: 'count sum min max avg'
          },
          contains: [
            {
              className: 'string',
              begin: '\'', end: '\'',
              contains: [hljs.BACKSLASH_ESCAPE, {begin: '\'\''}],
              relevance: 0
            },
            {
              className: 'string',
              begin: '"', end: '"',
              contains: [hljs.BACKSLASH_ESCAPE, {begin: '""'}],
              relevance: 0
            },
            {
              className: 'string',
              begin: '`', end: '`',
              contains: [hljs.BACKSLASH_ESCAPE]
            },
            hljs.C_NUMBER_MODE
          ]
        },
        hljs.C_BLOCK_COMMENT_MODE,
        {
          className: 'comment',
          begin: '--', end: '$'
        }
      ]
    }
  };
}
