/*
Language: Vala
Author: Antono Vasiljev <antono.vasiljev@gmail.com>
Description: Vala is a new programming language that aims to bring modern programming language features to GNOME developers without imposing any additional runtime requirements and without using a different ABI compared to applications and libraries written in C.
*/

function(hljs) {
  return {
    defaultMode: {
      keywords: {
        keyword:
          // Value types
          'char uchar unichar int uint long ulong short ushort int8 int16 int32 int64 uint8 ' +
          'uint16 uint32 uint64 float double bool struct enum string void ' +
          // Reference types
          'weak unowned owned ' +
          // Modifiers
          'async signal static abstract interface override ' +
          // Control Structures
          'while do for foreach else switch case break default return try catch ' +
          // Visibility
          'public private protected internal ' +
          // Other
          'using new this get set const stdout stdin stderr var',
        built_in:
          'DBus GLib CCode Gee Object',
        literal:
          'false true null'
      },
      contains: [
        {
          className: 'class',
          beginWithKeyword: true, end: '{',
          keywords: 'class interface delegate namespace',
          contains: [
            {
              beginWithKeyword: true,
              keywords: 'extends implements'
            },
            {
              className: 'title',
              begin: hljs.UNDERSCORE_IDENT_RE
            }
          ]
        },
        hljs.C_LINE_COMMENT_MODE,
        hljs.C_BLOCK_COMMENT_MODE,
        {
          className: 'string',
          begin: '"""', end: '"""',
          relevance: 5
        },
        hljs.APOS_STRING_MODE,
        hljs.QUOTE_STRING_MODE,
        hljs.C_NUMBER_MODE,
        {
          className: 'preprocessor',
          begin: '^#', end: '$',
          relevance: 2
        },
        {
          className: 'constant',
          begin: ' [A-Z_]+ ',
          relevance: 0
        }
      ]
    }
  };
}
