# Contributing

I welcome contributions from anyone and everyone. If you want to make any major changes please open an issue first, but for small changes you can simply create a pull. 

Before you make an contribution, please read GitHub Terms of Service: (Everything works as you think it works, but just make sure that you have the right to contribute the code you want to hand over.)
https://help.github.com/articles/github-terms-of-service/#6-contributions-under-repository-license

## Coding standards

Code that you write should be validated with the included .eslintrc file, and formated with the standard settings in prettier. The recommended editor is VS Code and configuration files are included in the project.

https://github.com/eslint/eslint

https://github.com/prettier/prettier

During development the code can be built by running `npm run build-dev`, before committing your code you should run `npm run build`, this will format all code with prettier, run the tests, and build your code.

## Examples

If you would like to contribute with examples of milsymbol usage, please create them in the same structure as bl.ocks use, and include a preview.png with the size 960*500px. https://bl.ocks.org/-/about 
