## Usage

```js
var createFrame = require('{%= name %}');
```

## Example

Create private variables from options hash arguments.

**Template**

The `@post` variable inside the block is created by the `post` hash argument. So the context of `@post` is the `this` object that is passed to the block.

```handlebars
\{{#block post=this}}
<h1>\{{@post.title}}</h1>
\{{/block}}
```

**Helper**

The following helper uses `createFrame`, then it extends the "frame" with hash arguments.

```js
handlebars.registerHelper('block', function (options) {
  var frame = createFrame(options.data);
  // extend the frame with hash arguments
  frame.extend(options.hash);
  return options.fn(options, {data: frame});
});

var fn = handlebars.compile(str);
fn({title: 'My Blog Post'});
```
