
What makes this lib unique (and fun) is the option to pass an array of values that should always evuate as "falsey". 

This is useful for CLI prompts, web forms, etc. For example, you might want to allow users to define `nil` or `nope` to disable something. 

## Usage

```js
var isFalsey = require('{%= name %}');

console.log(isFalsey('nil');
//=> `true`
```

## Examples

All of the following return `true`

```js
isFalsey(undefined);
isFalsey(null);
isFalsey(false);
isFalsey(0);
isFalsey('');
isFalsey(NaN);
isFalsey({});
isFalsey([]);
```

All of the following return `false`:

```js
isFalsey('foo');
isFalsey(true);
isFalsey(50);
isFalsey('10');
isFalsey({a: 'b'});
isFalsey([0]);
```

### Special cases

There are several additional "falsey" words built in, but these can be overridden or turned off by passing a value as the second argument.

**Built-in additional falsey keywords**

- `none`
- `nil`
- `nope`
- `no`
- `nada`
- `0`
- `false`

**Disable additions**

```js
isFalsey('nil', []);
//=> false
```

**Customize additions**

Pass one or more keywords that should return `true` when evaluated as _falsey_:

```js
isFalsey('zilch', ['no', 'nope', 'nada', 'zilch']);
//=> true
```

**Extend additions**

Built-in keywords are exposed on the `.keywords` property. These can be used to extend the defaults:

```js
isFalsey('zilch', isFalsey.keywords.concat(['zilch']));
//=> true
```