# falsey [![NPM version](https://img.shields.io/npm/v/falsey.svg?style=flat)](https://www.npmjs.com/package/falsey) [![NPM monthly downloads](https://img.shields.io/npm/dm/falsey.svg?style=flat)](https://npmjs.org/package/falsey)  [![NPM total downloads](https://img.shields.io/npm/dt/falsey.svg?style=flat)](https://npmjs.org/package/falsey) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/falsey.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/falsey) [![Windows Build Status](https://img.shields.io/appveyor/ci/jonschlinkert/falsey.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/jonschlinkert/falsey)

> Returns true if `value` is falsey. Works for strings, arrays and `arguments` objects with a length of `0`, and objects with no own enumerable properties are considered falsey.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save falsey
```

What makes this lib unique (and fun) is the option to pass an array of values that should always evuate as "falsey".

This is useful for CLI prompts, web forms, etc. For example, you might want to allow users to define `nil` or `nope` to disable something.

## Usage

```js
var isFalsey = require('falsey');

console.log(isFalsey('nil');
//=> `true`
```

## Examples

All of the following return `true`

```js
isFalsey(undefined);
isFalsey(null);
isFalsey(false);
isFalsey(0);
isFalsey('');
isFalsey(NaN);
isFalsey({});
isFalsey([]);
```

All of the following return `false`:

```js
isFalsey('foo');
isFalsey(true);
isFalsey(50);
isFalsey('10');
isFalsey({a: 'b'});
isFalsey([0]);
```

### Special cases

There are several additional "falsey" words built in, but these can be overridden or turned off by passing a value as the second argument.

**Built-in additional falsey keywords**

* `none`
* `nil`
* `nope`
* `no`
* `nada`
* `0`
* `false`

**Disable additions**

```js
isFalsey('nil', []);
//=> false
```

**Customize additions**

Pass one or more keywords that should return `true` when evaluated as _falsey_:

```js
isFalsey('zilch', ['no', 'nope', 'nada', 'zilch']);
//=> true
```

**Extend additions**

Built-in keywords are exposed on the `.keywords` property. These can be used to extend the defaults:

```js
isFalsey('zilch', isFalsey.keywords.concat(['zilch']));
//=> true
```

## About

### Related projects

* [is-number](https://www.npmjs.com/package/is-number): Returns true if the value is a number. comprehensive tests. | [homepage](https://github.com/jonschlinkert/is-number "Returns true if the value is a number. comprehensive tests.")
* [is-primitive](https://www.npmjs.com/package/is-primitive): Returns `true` if the value is a primitive.  | [homepage](https://github.com/jonschlinkert/is-primitive "Returns `true` if the value is a primitive. ")
* [isobject](https://www.npmjs.com/package/isobject): Returns true if the value is an object and not an array or null. | [homepage](https://github.com/jonschlinkert/isobject "Returns true if the value is an object and not an array or null.")
* [kind-of](https://www.npmjs.com/package/kind-of): Get the native type of a value. | [homepage](https://github.com/jonschlinkert/kind-of "Get the native type of a value.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on September 11, 2017._