## Install

{%= include("install-bower", {save: true}) %}

## Usage

```js
var get = require('{%= name %}');

var obj = {a: {b : {c: {d: 'foo'}}}, e: [{f: 'g'}]};
get(obj, 'a.b.c');
//=> {d: 'foo'}

get(obj, 'a.b.c.d');
//=> 'foo'

// works with arrays
get(obj, 'e.0.f');
//=> 'g'
```

**Escape dots**

```js
var obj = {'foo/bar.md': {b: 'c'}};
get(obj, 'foo/bar\\.md');
//=> {b: c}
```

**key as an array**

Optionally pass the key as an array (this is useful when you need to dynamically build up the property name)

```js
var obj = {a: {b: 'c'}};
get(obj, ['a', 'b']);
//=> 'c'
```
