# get-value [![NPM version](https://img.shields.io/npm/v/get-value.svg?style=flat)](https://www.npmjs.com/package/get-value) [![NPM downloads](https://img.shields.io/npm/dm/get-value.svg?style=flat)](https://npmjs.org/package/get-value) [![Build Status](https://img.shields.io/travis/jonschlinkert/get-value.svg?style=flat)](https://travis-ci.org/jonschlinkert/get-value)

Use property paths (`a.b.c`) to get a nested value from an object.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save get-value
```

Install with [bower](http://bower.io/)

```sh
$ bower install get-value --save
```

## Usage

```js
var get = require('get-value');

var obj = {a: {b : {c: {d: 'foo'}}}, e: [{f: 'g'}]};
get(obj, 'a.b.c');
//=> {d: 'foo'}

get(obj, 'a.b.c.d');
//=> 'foo'

// works with arrays
get(obj, 'e.0.f');
//=> 'g'
```

**Escape dots**

```js
var obj = {'foo/bar.md': {b: 'c'}};
get(obj, 'foo/bar\\.md');
//=> {b: c}
```

**key as an array**

Optionally pass the key as an array (this is useful when you need to dynamically build up the property name)

```js
var obj = {a: {b: 'c'}};
get(obj, ['a', 'b']);
//=> 'c'
```

## Related projects

You might also be interested in these projects:

* [has-any](https://www.npmjs.com/package/has-any): Returns true if an object has any of the specified keys. | [homepage](https://github.com/jonschlinkert/has-any)
* [has-any-deep](https://www.npmjs.com/package/has-any-deep): Return true if `key` exists deeply on the given object.  | [homepage](https://github.com/jonschlinkert/has-any-deep)
* [has-value](https://www.npmjs.com/package/has-value): Returns true if a value exists, false if empty. Works with deeply nested values using… [more](https://github.com/jonschlinkert/has-value) | [homepage](https://github.com/jonschlinkert/has-value)
* [set-value](https://www.npmjs.com/package/set-value): Create nested values and any intermediaries using dot notation (`'a.b.c'`) paths. | [homepage](https://github.com/jonschlinkert/set-value)
* [unset-value](https://www.npmjs.com/package/unset-value): Delete nested properties from an object using dot notation. | [homepage](https://github.com/jonschlinkert/unset-value)

## Contributing

This document was generated by [verb-readme-generator](https://github.com/verbose/verb-readme-generator) (a [verb](https://github.com/verbose/verb) generator), please don't edit directly. Any changes to the readme must be made in [.verb.md](.verb.md). See [Building Docs](#building-docs).

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new). Or visit the [verb-readme-generator](https://github.com/verbose/verb-readme-generator) project to submit bug reports or pull requests for the readme layout template.

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-readme-generator && verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/get-value/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on June 18, 2016._