## Usage

```js
var hasValue = require('{%= name %}');

hasValue('a');
//=> true

hasValue('');
//=> false

hasValue(1);
//=> true

hasValue(0);
//=> false

hasValue({a: 'a'}});
//=> true

hasValue({});
hasValue({foo: undefined});
//=> false

hasValue({foo: null});
//=> true

hasValue(['a']);
//=> true

hasValue([]);
hasValue([[], []]);
hasValue([[[]]]);
//=> false

hasValue(['foo']);
hasValue([0]);
//=> true

hasValue(function(foo) {}); 
//=> true

hasValue(function() {});
//=> true

hasValue(true);
//=> true

hasValue(false);
//=> true
```

## isEmpty

To test for empty values, do:

```js
function isEmpty(o, isZero) {
  return !hasValue(o, isZero);
}
```

## Release history

### v1.0.0

- `zero` always returns true
- `array` now recurses, so that an array of empty arrays will return `false`
- `null` now returns true