# Inline rules

The inline rules are responsible for parsing inline Markdown syntax formatting
only part of a line of text and emitting the [tokens][tokens] required to
represent them. For example, a link, bold, emphasis, super/sub scripts, inline
code, and so on.

An inline rule is a function expecting two argumnents:

1. `state`: an instance of `StateInline`
4. `checkMode`: a flag indicating whether we should simply check if the current
   position marks the begining of the syntax we are trying to parse.

The `checkMode` is here for optimization, if it's set to `true`, we can return
`true` as soon as we are sure the present position marks the beginning of an
inline syntax we are trying to parse (For example, in the case of emphasized
(italic) text, the check would be "Is the current position a '\*' or a '\_'?").

## State inline

The definition for `StateInline` prototype is in `rules_inline/state_inline.js`
and its data consists of:

* `src`: the complete string the parser is currently working on (i.e. the
  current line/block content).
* `parser`: The current inline parser (here to make nested calls easier)
* `env`: a namespaced data key-value store to allow core rules to exchange data
* `tokens`: the tokens generated by the parser up to now
* `pos`: the current position in `src` reached by the parser
* `posMax`: the last position available in `src`
* `level`: the nested level for the current inline rule

The most important methods are:

* `push(token)`: adds a new token to the (end of the) output
* `cacheSet(key, value)`: adds a new value to the cache key-value store. `key`
  MUST be a non-negative integer (`>= 0`) and value MUST a positive integer (`>
  0`)
* `cacheGet(key)`: fetches a value from the cache key-value store. `key` MUST be
  a non-negative integer (`>= 0`)

## Rule parser behaviour

If `checkMode` is set to true, simply return a boolean depending on whether the
current position should be considered has the begining of your
syntax. Otherwise, proceed with the complete parsing.

NB: It is your responsibility to make sure you have reached the maximum nesting
level allowed by comparing `state.level` and `state.options.maxNesting`.

NB: If for any reason, the syntax you are trying to parse is incorrectly
formated and you are unable to parse it, you must abort and return `false`
without modifying `state` in any way.

To completely parse a block, you will need to push new [tokens][tokens] by
calling `state.push(token)`.

Once you are sure the current position marks the beginning of the syntax you are
trying to parse, you should push an [open tag token][tokens] corresponding to
the begining of your inline section. You will also need to find its end.

Your next decision should be whether you wish to allow other inline syntaxes to
be nested in your content or not. If you do, you will need to invoke
`state.parser.tokenize(state)` with an updated `state` accordingly to allow the
next batch of rules to run smoothly (incl. updating `pos`, `posMax` and
`level`). Don't forget to restore the previous values afterward.

The last token you will need to emit is the [end tag token][tokens] for your
inline section.

Finally, you will need to update `state.pos` to the first position after the
part of `src` you processed and return `true`.

[renderer doc]: renderer.md
[tokens]: parser.md
