/*!
 * krajee-markdown-editor v1.0.0
 * http://plugins.krajee.com/krajee-markdown-editor
 *
 * Krajee Markdown Editor Main Plugin Library
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2021, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD 3-Clause
 * https://github.com/kartik-v/krajee-markdown-editor/blob/master/LICENSE.md
 */!function(e){"use strict";"function"==typeof define&&define.amd?define(["jquery","window","document"],e):"object"==typeof module&&"object"==typeof module.exports?e(require("jquery"),window,document):e(window.jQuery,window,document)}(function(e,t,n,o){"use strict";e.fn.markdownEditorLocales={},e.fn.markdownEditorThemes={},e.fn.markdownEditorBsVersion||(e.fn.markdownEditorBsVersion=t.Alert&&t.Alert.VERSION||t.bootstrap&&t.bootstrap.Alert&&bootstrap.Alert.VERSION||"3.x.x");var a,r,i,s,l,d;a={CREDITS:'<a class="text-info" href="http://plugins.krajee.com/markdown-editor">krajee-markdown-editor</a>',CREDITS_MD:"[krajee-markdown-editor](http://plugins.krajee.com/markdown-editor)",DEFAULT_TIMEOUT:250,EMPTY:"",NAMESPACE:".markdownEditor",LINK_CM:'<a href="http://spec.commonmark.org/" target="_blank">CommonMark</a>',LINK_MI:'<a href="https://markdown-it.github.io/markdown-it/" target="_blank">markdown-it</a>',htmlEncode:function(e){return e===o?"":e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")},parseHtml:function(e){return e===o?"":a.kvUnescape(encodeURIComponent(e))},isBs:function(t){var n=e.trim((e.fn.markdownEditorBsVersion||"")+"");return t=parseInt(t,10),n?t===parseInt(n.charAt(0),10):4===t},bsVer:function(){var t=e.trim((e.fn.markdownEditorBsVersion||"")+"");return parseInt(t.charAt(0),10)},getBsCss:function(){var e,t=a.bsVer();return e=5===t?"5.1.1":4===t?"4.6.0":"3.4.1","https://cdn.jsdelivr.net/npm/bootstrap@"+e+"/dist/css/bootstrap.min.css"},bsMap:function(){var e='<label class="{LABEL_CSS}" for="{ID}" title="{LABEL_TITLE}">\n{LABEL}\n',t='<input id="{ID}" type="radio" value="{VALUE}" name="mdMode" autocomplete="off" accesskey="{KEY}" {CHECK}>';return{floatRight:{3:"pull-right",4:"float-right",5:"float-end"},tagDialogHeader:{3:"h4",4:"h5"},layoutDialogHeader:{3:"{CLOSE}\n{TITLE}",4:"{TITLE}\n{CLOSE}"},layoutMenuItem:{3:"{CONTENT}",4:"<li>{CONTENT}</li>"},layoutBtnRadioGroup:{3:e+t+"</label>",4:e+t+"</label>",5:t.replace(">",' class="btn-check">')+"\n"+e+"</label>"},dataPrefix:{3:"data-",4:"data-",5:"data-bs-"}}},getBsProp:function(e){var t=a.bsMap()[e],n=a.bsVer(),o=t?t[n]:null;return t?o?o:n>4?t[4]:null:null},create:function(t,o){var r=e(n.createElement(t));return a.isEmpty(o)||r.attr(o),r},addCss:function(e,t){t&&e.removeClass(t).addClass(t)},uniqueId:function(){return Math.round((new Date).getTime()+100*Math.random())},isEmpty:function(t,n){return null===t||t===o||0===t.length||n&&e.trim(t)===a.EMPTY},isNumber:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},trimRight:function(e,t){return t===o&&(t="s"),e.replace(new RegExp("["+t+"]+$"),"")},getMarkUp:function(e,t,n,o){var a,r,i,s=t.length,l=n.length,d=e,c="",u="",f=!1;return o&&(d=e.replace(/^\s+|\s+$/g,""),d!==e&&(f=!0)),s>0&&(d=d.slice(0,s)===t?d.slice(s):t+d),l>0&&(d=d.slice(-l)===n?d.slice(0,-l):d+n),f&&(c=e.replace(/^\s+/,""),u=e.replace(/\s+$/,""),i=e.length,a=i-c.length,r=u.length,a>0&&(d=e.substring(0,a)+d),r>0&&(d+=e.substring(r,i))),d},getBlockMarkUp:function(t,n,o,r){var i=t,s=[];return i.indexOf("\n")<0?i=a.getMarkUp(t,n,o,r):(s=t.split("\n"),e.each(s,function(e,t){s[e]=a.getMarkUp(a.trimRight(t),n,o+"  ",r)}),i=s.join("\n")),i},setWhitespace:function(e,t){try{e.style.whiteSpace=t}catch(n){}},setSelectionRange:function(o,r,i){var s,l;if(o.setSelectionRange)o.focus(),o.setSelectionRange(r,i),o.scrollTop=0,r>100&&(s=n.createElement("pre"),o.parentNode.appendChild(s),l=t.getComputedStyle(o,""),s.style={visibility:"hidden",lineHeight:l.lineHeight,fontFamily:l.fontFamily,fontSize:l.fontSize,padding:0,border:l.border,outline:l.outline,overflow:"scroll",letterSpacing:l.letterSpacing},a.setWhitespace(s,"-moz-pre-wrap"),a.setWhitespace(s,"-o-pre-wrap"),a.setWhitespace(s,"-pre-wrap"),a.setWhitespace(s,"pre-wrap"),s.textContent=e(o).val().substring(0,r-100),o.scrollTop=s.scrollHeight,s.parentNode.removeChild(s));else if(o.createTextRange){var d=o.createTextRange();d.collapse(!0),d.moveEnd("character",i),d.moveStart("character",r),d.select()}},kvUnescape:function(e){return e.replace(/%([0-9A-F]{2})/gi,function(e,t){return String.fromCharCode(parseInt(t,16))})},handler:function(e,t){e&&e.isDefaultPrevented()||t()},delay:function(){var e=0;return function(t,n){clearTimeout(e),e=setTimeout(t,n||a.DEFAULT_TIMEOUT)}}()},r={click:"click"+a.NAMESPACE,input:"input"+a.NAMESPACE,change:"change"+a.NAMESPACE,focus:"focus"+a.NAMESPACE,blur:"blur"+a.NAMESPACE,keyup:"keyup"+a.NAMESPACE,keydown:"keydown"+a.NAMESPACE,resize:"resize"+a.NAMESPACE,reset:"reset"+a.NAMESPACE,scroll:"scroll"+a.NAMESPACE,touchstart:"touchstart"+a.NAMESPACE,mouseover:"mouseover"+a.NAMESPACE,modalShown:"shown.bs.modal"+a.NAMESPACE,modalHidden:"hidden.bs.modal"+a.NAMESPACE,buttonPress:"buttonPress"+a.NAMESPACE,beforePreview:"beforePreview"+a.NAMESPACE,successPreview:"successPreview"+a.NAMESPACE,emptyPreview:"emptyPreview"+a.NAMESPACE,errorPreview:"errorPreview"+a.NAMESPACE};var c=a.getBsProp("floatRight"),u=a.getBsProp("dataPrefix")+"dismiss";i={toolbar:{toolbarHeaderL:[["undo","redo"],["bold","italic","ins","del","sup","sub","mark"],["paragraph","newline","heading"],["link","image"],["indent","outdent","ul","ol","dl"],["footnote","blockquote","hr"],["code","codeblock"],["emoji"]],toolbarHeaderR:[["fullscreen"]],toolbarFooterL:[["hint"],["export"]],toolbarFooterR:[["mode"]]},templates:{main:'<div class="md-editor" tabindex="0">\n  {HEADER}\n  <table class="md-input-preview">\n    <tr>\n      <td class="md-input-cell">{INPUT}</td>\n      <td class="md-preview-cell">{PREVIEW}</td>\n    </tr>  </table>\n  {FOOTER}\n  {DIALOG}\n</div>',header:'<div class="md-header">\n  <div class="md-toolbar-header-r '+c+'">\n    {TOOLBAR_HEADER_R}\n  </div>\n  <div class="md-toolbar-header-l">\n    {TOOLBAR_HEADER_L}\n  </div>\n  <div class="clearfix">\n  </div>\n</div>',preview:'<div class="md-preview" tabindex="0">\n</div>',footer:'<div class="md-footer">\n  <div class="md-toolbar-footer-r '+c+'">\n    {TOOLBAR_FOOTER_R}\n  </div>\n  <div class="md-toolbar-footer-l">\n    {TOOLBAR_FOOTER_L}\n  </div>\n  <div class="clearfix">\n  </div>\n</div>',dialog:'<div class="md-dialog modal fade" tabindex="-1" role="dialog">\n  <div class="modal-dialog">\n    <div class="modal-content">\n      <div class="modal-header">\n         {HEADER}\n      </div>\n      <div class="modal-body">\n        <input class="md-dialog-input form-control">\n        <input class="md-dialog-title form-control">\n        <div class="md-dialog-content"></div>\n      </div>\n      <div class="modal-footer">\n        <button type="button" class="md-dialog-cancel btn btn-default btn-outline-secondary" '+u+'="modal">\n          {DIALOG_CANCEL_ICON} {DIALOG_CANCEL_TEXT}\n        </button>\n        <button type="button" class="md-dialog-submit btn btn-primary" '+u+'="modal">\n          {DIALOG_SUBMIT_ICON} {DIALOG_SUBMIT_TEXT}\n        </button>\n      </div>\n    </div>\n</div>',dialogClose:'<button type="button" class="md-dialog-close" '+u+'="modal" aria-label="Close">\n  <span aria-hidden="true">&times;</span>\n</button>\n',htmlMeta:'<!DOCTYPE html>\n  <meta http-equiv="Content-Type" content="text/html,charset=UTF-8"/>\n  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>\n',exportCssJs:"{EXPORT_PREPEND_CSS_JS}\n<style>\n  body{margin:20px;padding:20px;border:1px solid #ddd;border-radius:5px;}\n  .md-codeblock{padding:5px 8px;background-color:#f5f5f5;border:1px solid #ddd;border-radius:0}\n  .md-blockquote{border-left:5px solid #eee;padding: 10px 20px}\n  .md-line img{max-width:100%}\n</style>",exportHeader:"> - - -\n> Markdown Export\n> ==============\n> *Generated {TODAY} by {CREDITS}*\n> - - -\n\n",hint:"<ul>\n  <li><p>You may follow the {LINK_CM} specification (generated via {LINK_MI} plugin) for writing your markdown text.</p></li>\n  <li><p>In order to use the formatting buttons on the toolbar, you generally need to highlight a text   within the editor on which the formatting is to be applied. You can also undo the format action on the   highlighted text by clicking the button again (for most buttons).</p></li>\n  <li><p>Keyboard access shortcuts for buttons:</p>    {ACCESS_KEYS}  </li>\n</ul>"},icons:{undo:'<span class="fas fa-fw fa-undo"></span>',redo:'<span class="fas fa-fw fa-redo"></span>',bold:'<span class="fas fa-fw fa-bold"></span>',italic:'<span class="fas fa-fw fa-italic"></span>',ins:'<span class="fas fa-fw fa-underline"></span>',del:'<span class="fas fa-fw fa-strikethrough"></span>',sup:'<span class="fas fa-fw fa-superscript"></span>',sub:'<span class="fas fa-fw fa-subscript"></span>',mark:'<span class="fas fa-fw fa-eraser"></span>',paragraph:'<span class="fas fa-fw fa-paragraph"></span>',newline:'<span class="fas fa-fw fa-text-height"></span>',heading:'<span class="fas fa-fw fa-heading"></span>',link:'<span class="fas fa-fw fa-link"></span>',image:'<span class="far fa-fw fa-image"></span>',indent:'<span class="fas fa-fw fa-indent"></span>',outdent:'<span class="fas fa-fw fa-outdent"></span>',ul:'<span class="fas fa-fw fa-list-ul"></span>',ol:'<span class="fas fa-fw fa-list-ol"></span>',dl:'<span class="fas fa-fw fa-th-list"></span>',footnote:'<span class="far fa-fw fa-sticky-note"></span>',blockquote:'<span class="fas fa-fw fa-quote-right"></span>',code:'<span class="fas fa-fw fa-code"></span>',codeblock:'<span class="far fa-fw fa-file-code"></span>',hr:'<span class="fas fa-fw fa-minus"></span>',emoji:'<span class="far fa-fw fa-smile"></span>',fullscreen:'<span class="fas fa-fw fa-arrows-alt"></span>',minscreen:'<span class="fas fa-fw fa-compress"></span>',hint:'<span class="fas fa-fw fa-lightbulb"></span>',modePreview:'<span class="fas fa-fw fa-search"></span>',modeEditor:'<span class="fas fa-fw fa-edit"></span>',modeSplit:'<span class="fas fa-fw fa-arrows-alt-h"></span>',"export":'<span class="fas fa-fw fa-download"></span>',exportHtml:'<span class="fas fa-fw fa-file-alt"></span>',exportText:'<span class="fas fa-fw fa-file"></span>',alertMsg:'<span class="fas fa-fw fa-exclamation-circle"></span>',dialogCancel:'<span class="fas fa-fw fa-times"></span>',dialogSubmit:'<span class="fas fa-fw fa-check"></span>'},buttonAccessKeys:{undo:"z",redo:"y",bold:"b",italic:"i",ins:"u",del:"x",sup:"^",sub:"~",mark:"=",paragraph:"#",newline:"0",heading1:"1",heading2:"2",heading3:"3",heading4:"4",heading5:"5",heading6:"6",link:"l",image:"p",indent:">",outdent:"<",ul:"*",ol:"9",dl:"+",footnote:"n",blockquote:"q",code:"j",codeblock:"k",hr:"-",emoji:":",fullscreen:".",hint:"?",modeEditor:"(",modePreview:")",modeSplit:"_",exportHtml:"h",exportText:"t"},buttonTitles:{undo:"Undo",redo:"Redo",bold:"Bold",italic:"Italic",ins:"Underline / Inserted Text",del:"Strike Through",sup:"Superscript",sub:"Subscript",mark:"Highlighted Text",paragraph:"Paragraph",newline:"Append line break",heading:"Heading",link:"Hyperlink",image:"Image Link",indent:"Indent Text",outdent:"Outdent Text",ul:"Unordered List",ol:"Ordered List",dl:"Definition List",footnote:"Footnote",blockquote:"Block Quote",code:"Inline Code",codeblock:"Code Block",hr:"Horizontal Line",emoji:"Emojis / Emoticons",fullscreen:"Toggle full screen mode",hint:"Usage Hints",modeEditor:"Editor mode",modePreview:"Preview mode",modeSplit:"Split mode","export":"Export content",exportHtml:"Export as HTML",exportText:"Export as Text"},buttonCss:{hint:"btn btn-info"},dropdownCss:{emoji:"md-emojies-list "+c},buttonLabels:{"export":"Export",exportHtml:"HTML",exportText:"Text"},buttonPrompts:{link:{header:"Insert Hyperlink",hintInput:"Enter hyperlink address...",hintTitle:"Enter text for the link..."},image:{header:"Insert Image Link",hintInput:"Enter image link address...",hintTitle:"Enter alternate text for the image..."},ol:{header:"Ordered List Starting Number",hintInput:"Integer starting from 1"},codeblock:{header:"Enter code language",hintInput:"e.g. html, php, js"}},buttonActions:{bold:{before:"**",after:"**","default":"**(bold text here)**",skipSpaces:!0},italic:{before:"_",after:"_","default":"_(italic text here)_",skipSpaces:!0},ins:{before:"++",after:"++","default":"_(inserted text here)_",skipSpaces:!0},del:{before:"~~",after:"~~","default":"_(strikethrough text here)_",skipSpaces:!0},mark:{before:"==",after:"==","default":"_(marked text here)_",skipSpaces:!0},sup:{before:"^",after:"^","default":"_(superscript text here)_",skipSpaces:!0},sub:{before:"~",after:"~","default":"_(subscript text here)_",skipSpaces:!0},paragraph:{before:"\n",after:"\n","default":"\n(paragraph text here)\n",inline:!0},newline:{before:a.EMPTY,after:"  "},heading1:{before:"# ","default":"# (heading 1 text here)",inline:!0},heading2:{before:"## ","default":"## (heading 2 text here)",inline:!0},heading3:{before:"### ","default":"### (heading 3 text here)",inline:!0},heading4:{before:"#### ","default":"#### (heading 4 text here)",inline:!0},heading5:{before:"##### ","default":"##### (heading 5 text here)",inline:!0},heading6:{before:"###### ","default":"###### (heading 6 text here)",inline:!0},indent:function(t){var n,o="  ";return t.indexOf("\n")<0?t=o+t:(n=t.split("\n"),e.each(n,function(e,t){n[e]=o+t}),t=n.join("\n")),t},outdent:function(t){var n,o="  ";return t.indexOf("\n")<0&&t.substr(0,2)===o?t=t.slice(2):(n=t.split("\n"),e.each(n,function(e,t){n[e]=t,t.substr(0,2)===o&&(n[e]=t.slice(2))}),t=n.join("\n")),t},link:function(e){return function(t,n){return a.isEmpty(t)||("ftp://"!==t.substring(0,6)&&"http://"!==t.substring(0,7)&&"https://"!==t.substring(0,8)&&(t="http://"+t),e="["+n+"]("+t+")"),e}},image:function(e){return function(t,n){return a.isEmpty(t)||("ftp://"!==t.substring(0,6)&&"http://"!==t.substring(0,7)&&"https://"!==t.substring(0,8)&&(t="http://"+t),e="!["+n+"]("+t+")"),e}},ul:{before:"- ",after:a.EMPTY},ol:function(t){var n,o;return function(r){return a.isEmpty(r)?a.EMPTY:(a.isNumber(r)||(r=1),t.indexOf("\n")<0?t=a.getMarkUp(t,r+". ",a.EMPTY):(n=parseInt(r),o=t.split("\n"),e.each(o,function(e,t){o[e]=a.getMarkUp(t,n+". ",a.EMPTY),n++}),t=o.join("\n")),t)}},dl:function(t){var n,o,r;return t.indexOf("\n")>0?(n=1,r=t.split("\n"),e.each(r,function(e,t){o=n%2===0?":    ":a.EMPTY,r[e]=a.getMarkUp(t,o,a.EMPTY),n++}),t=r.join("\n")):t+="\n:    \n",t},footnote:function(t){var n,o,r,i="Enter footnote ",s=a.EMPTY;return t.indexOf("\n")<0?(s="[^1]: "+i+"1\n",t=a.getMarkUp(t,a.EMPTY,i+"[^1]")+"\n"+s):(n=1,r=t.split("\n"),e.each(r,function(e,t){o="[^"+n+"]",r[e]=a.getMarkUp(t,a.EMPTY,o+"  "),s=s+o+": "+i+n+"\n",n++}),t=r.join("\n")+"  \n\n"+s),t},blockquote:{before:"> ",after:"  "},code:{before:"`",after:"`",inline:!0},codeblock:function(e){return function(t){return a.isEmpty(t,!0)&&(t=a.EMPTY),a.getMarkUp(e,"~~~"+t+" \n","\n~~~  \n")}},hr:{before:a.EMPTY,after:"\n- - -",inline:!0}},exportConfig:{exportText:{ext:"txt",uri:"data:text/plain;base64,"},exportHtml:{ext:"htm",uri:"data:text/html;base64,"}}},s=function(){this.init()},s.prototype={constructor:s,init:function(){var e=this;e.commands=[],e.stackPosition=-1,e.savePosition=-1},execute:function(e){var t=this;t._clearRedo(),e.execute(),t.commands.push(e),t.stackPosition++,t.changed()},undo:function(){var e=this;e.commands[e.stackPosition].undo(),e.stackPosition--,e.changed()},canUndo:function(){var e=this;return e.stackPosition>=0},redo:function(){var e=this;e.stackPosition++,e.commands[e.stackPosition].redo(),e.changed()},canRedo:function(){var e=this;return e.stackPosition<e.commands.length-1},save:function(){var e=this;e.savePosition=e.stackPosition,e.changed()},dirty:function(){var e=this;return e.stackPosition!==e.savePosition},_clearRedo:function(){var e=this;e.commands=e.commands.slice(0,e.stackPosition+1)},changed:function(){}},l=function(e,t,n,o,a){var r=this;r.textarea=e,r.oldValue=t,r.newValue=n,r.oldPos=o,r.newPos=a},l.prototype={constructor:l,execute:function(){},undo:function(){var e=this,t=e.textarea,n=t[0];t.val(e.oldValue),a.setSelectionRange(n,e.oldPos[0],e.oldPos[1])},redo:function(){var e=this,t=e.textarea,n=t[0];t.val(e.newValue),a.setSelectionRange(n,e.newPos[0],e.newPos[1])}},d=function(t,n){var o=this;o.$element=e(t),o.init(n)},d.prototype={constructor:d,init:function(t){var n=this,r=n.$element;e.each(t,function(e,t){n[e]=t}),n.initToolbar(),n.isDisabled=r.attr("disabled")||r.attr("readonly"),r.attr("id")||r.attr("id",a.uniqueId()),n.exportPrependCssJs===o&&(n.exportPrependCssJs='<link href="'+a.getBsCss()+'" rel="stylesheet">'),n.setDefaults("icons"),n.setDefaults("buttonTitles"),n.setDefaults("buttonLabels"),n.setDefaults("buttonPrompts"),n.setDefaults("buttonAccessKeys"),n.setDefaults("buttonActions"),n.setDefaults("buttonCss"),n.setDefaults("buttonGroupCss"),n.setDefaults("dropdownCss"),n.setDefaults("exportConfig"),n.setDefaults("templates"),n.defaultInputHeight=r.height(),n.enableSplitMode&&n.enableLivePreview===o&&(n.enableLivePreview=!0),n.render(),n.$preview.height(n.defaultInputHeight),r.height(n.defaultInputHeight),n.startFullScreen&&n.toggleFullScreen(),n.initLibrary(),n.reset(),n.listen()},getLibrary:function(){return this._library||null},initLibrary:function(){var n,r=this;return t.markdownit?(n=r._library=t.markdownit(r.markdownItOptions),e.each(r.markdownItPlugins,function(e,o){t[e]&&n.use(t[e],o)}),a.isEmpty(r.markdownItDisabledRules)||n.disable(r.markdownItDisabledRules),void(a.isEmpty(r.parserUrl)&&r.parserMethod===o&&(r.parserMethod=function(e){return n.renderer.rules.emoji=function(e,n){return r.useTwemoji&&t.twemoji?t.twemoji.parse(e[n].content):'<span class="md-emoji">'+e[n].content+"</span>"},n.renderer.rules.paragraph_open=n.renderer.rules.heading_open=function(e,t,n,o,a){var r;return e[t].map&&0===e[t].level&&(r=e[t].map[0],e[t].attrJoin("class","md-line"),e[t].attrSet("data-line",String(r))),a.renderToken(e,t,n,o,a)},n.render(e)}))):void(console&&"function"==typeof console.log&&console.log("INIT LIBRARY ERROR: Markdown IT Library not found or not loaded."))},setDefaults:function(t){var n=this;"function"!=typeof n[t]&&(n[t]=e.extend(!0,{},i[t]||{},n[t]))},getConfig:function(t,n){var a,r=this,i=r[t],s=r.theme&&e.fn.markdownEditorThemes[r.theme]||{};return i===o?null:(a=s[t],"function"==typeof a?a(n):"function"==typeof i?i(n):i[n])},handleEvent:function(t,n,o){var r=this,i=n+a.NAMESPACE;t.off(i).on(i,e.proxy(r[o],r))},listen:function(){var o=this,a=o.$container,i=o.$element,s=o.$preview,l=i.closest("form"),d=r.resize,c=r.reset,u=r.keyup,f=r.buttonPress,p=r.focus,m=r.blur,h=r.change,g=r.click,b=r.touchstart+" "+r.mouseover,v=o.$editor.find(".md-emoji-search"),w=r.keydown;o.parseButtons(),a.find(".dropdown-toggle").dropdown(),o.handleEvent(o.$dialog,w,"keydownDialog"),o.handleEvent(i,p,"focus"),o.handleEvent(s,p,"focus"),o.handleEvent(i,m,"blur"),o.handleEvent(s,m,"blur"),o.handleEvent(e(n),w,"escapeFullScreen"),o.handleEvent(e(t),d,"resizeWindow"),l.length&&o.handleEvent(l,c,"reset"),o.handleEvent(o.$btnUndo,g,"undo"),o.handleEvent(o.$btnRedo,g,"redo"),o.handleEvent(i,u,"keyup"),o.handleEvent(i,f,"buttonPress"),o.handleEvent(i,b,"mouseoverEditor"),o.handleEvent(s,b,"mouseoverPreview"),o.handleEvent(o.$modeInput,h,"changeMode"),v.length&&(o.handleEvent(v.find("input"),u,"emojiSearch"),o.handleEvent(v.find(".md-close"),g,"emojiSearchClose"))},resizeWindow:function(n){var o,r,i=this,s=i.$container,l=i.$preview;a.handler(n,function(){s.hasClass("md-fullscreen-overlay")&&i.resizeFullScreen(),o=l.find(".md-preview-message"),o.length&&(r=e(t).width()<640?"100%":.5*l.width(),o.width(r))})},emojiSearch:function(t){var n=this,o=n.$editor.find(".md-emoji-search"),r=o.find("input"),i=r.val(),s=o.closest("ul");a.handler(t,function(){a.delay(function(){s.find("li").each(function(){var t=e(this),n=t.find("a").attr("data-key");t.hasClass("md-emoji-search")||n&&-1!==n.indexOf(i)?t.show():t.hide()})})})},emojiSearchClose:function(e){var t=this,n=t.$editor.find(".md-emoji-search");a.handler(e,function(){e.stopPropagation(),n.closest("ul").find("li").show(),n.find("input").val("")})},focus:function(e){var t=this;a.handler(e,function(){a.addCss(t.$editor,"active")})},blur:function(e){var t=this;a.handler(e,function(){t.$editor.removeClass("active")})},clickButton:function(e,t){var n,o,r=this,i=t.data("key"),s=t.hasClass("md-btn-heading"),l=t.hasClass("md-btn-export"),d=t.hasClass("md-btn-emoji");a.handler(e,function(){if(r.isDisabled&&!r.isPreviewModeButton(i))return!1;if(s||l||d){if(e.preventDefault(),l&&r.raise("clickExport",[i]))return void r.exportData(i);if(d&&r.raise("clickEmoji",[i,":"+i+":"]))return void r.replaceSelected(":"+i+":")}switch(i){case"fullscreen":r.toggleFullScreen();break;case"hint":n=r.getTitle(i)+" <small>"+a.CREDITS+"</small>",r.showPopup(n,r.renderHint(),!0);break;default:o=r.process(i),r.raise("clickButton",[i,o])&&!a.isEmpty(o)&&r.replaceSelected(o)}})},changeMode:function(e){var t,n,o=this;a.handler(e,function(){t=o.$mode.find('input:radio[name="mdMode"]:checked').val()||"modeEditor",n=t.substr(4).toLowerCase(),o.raise("changeMode",[n])&&(o.toggleMode(t),o.currentMode=n)})},reset:function(e){var t=this,n=t.$element,o=n[0];a.handler(e,function(){setTimeout(function(){t.enableUndoRedo?(t.undoStack=t.resetUndoStack(),t.startValue=n.val(),t.startPos=[o.selectionStart,o.selectionEnd]):t.undoStack=null,t.$preview.is(":visible")&&setTimeout(function(){t.generatePreview()},1)},1)})},undo:function(e){var t=this;t.enableUndoRedo&&t.raise("undo",[t.undoStack])&&a.handler(e,function(){t.undoStack.undo(),t.scrollMap=null,t.enableLivePreview&&t.generatePreview()})},redo:function(e){var t=this;t.enableUndoRedo&&t.raise("undo",[t.undoStack])&&a.handler(e,function(){t.undoStack.redo(),t.scrollMap=null,t.enableLivePreview&&t.generatePreview()})},keyup:function(e){var t=this,n=t.$element,o=n[0],r=t.undoStack;a.handler(e,function(){t.enableLivePreview&&t.$preview.is(":visible")&&a.delay(t.generatePreview()),t.enableUndoRedo&&a.delay(function(){var e=n.val(),a=[o.selectionEnd,o.selectionEnd];e!==t.startValue&&(r.execute(new l(n,t.startValue,e,t.startPos,a)),t.startValue=e,t.startPos=a,t.scrollMap=null)})})},keydownDialog:function(t){var n=this;a.handler(t,function(){var o=e(t.target),a=o.hasClass("md-dialog-input"),r=o.hasClass("md-dialog-title");13===t.keyCode&&(a||r)&&(t.stopPropagation(),t.preventDefault(),!r&&n.$dialogTitle.is(":visible")||n.$dialogSubmit.trigger("click"))})},buttonPress:function(e,t,n){var o,r=this,i=r.$element;a.handler(e,function(){r.isDisabled||(r.enableUndoRedo&&(o=i.val(),r.startPos=t,r.undoStack.execute(new l(i,r.startValue,o,r.startPos,n)),r.startValue=o,r.startPos=n),r.enableLivePreview&&r.$preview.is(":visible")&&r.generatePreview())})},_mouseover:function(e,t){var n=this,o=n.$element,a=n.$preview,i=r.scroll;e&&e.isDefaultPrevented()||!o.is(":visible")||!a.is(":visible")||("editor"===t?(a.off(i),o.on(i,function(){n.syncPreviewScroll()})):(o.off(i),a.on(i,function(){n.syncInputScroll()})))},mouseoverEditor:function(e){var t=this;a.handler(e,function(){t._mouseover(e,"editor")})},mouseoverPreview:function(e){var t=this;a.handler(e,function(){t._mouseover(e,"preview")})},buildScrollMap:function(){var t,n,o,r,i,s,l,d=this,c=d.$element,u=d.$preview,f=0,p=[],m=[],h=[];if(!d.enableScrollSync)return"";for(l=a.create("div").css({position:"absolute",visibility:"hidden",height:"auto",width:c[0].clientWidth,"font-size":c.css("font-size"),"font-family":c.css("font-family"),"line-height":c.css("line-height"),"white-space":c.css("white-space")}).appendTo("body"),n=u[0].scrollTop-u.offset().top,c.val().split("\n").forEach(function(e){var t,n;return p.push(f),0===e.length?void f++:(l.text(e),t=parseFloat(l.css("height")),n=parseFloat(l.css("line-height")),void(f+=Math.round(t/n)))}),l.remove(),p.push(f),s=f,t=0;s>t;t++)h.push(-1);for(m.push(0),h[0]=0,u.find(".md-line").each(function(t,o){var a=e(o),r=a.data("line");""!==r&&(r=p[r],0!==r&&m.push(r),h[r]=Math.round(a.offset().top+n))}),m.push(s),h[s]=u[0].scrollHeight,o=0,t=1;s>t;t++)-1===h[t]?(r=m[o],i=m[o+1],h[t]=Math.round((h[i]*(t-r)+h[r]*(i-t))/(i-r))):o++;return h},syncInputScroll:function(){var e,t,n,o=this,a=o.$element,r=o.$preview,i=o.scrollMap,s=r[0].scrollTop,l=parseFloat(a.css("line-height"));if(i||(i=o.scrollMap=o.buildScrollMap()),e=Object.keys(i),!(e.length<1)){for(n=e[0],t=1;t<e.length&&i[e[t]]<s;t++)n=e[t];a.stop(!0).animate({scrollTop:l*n},100,"linear")}},syncPreviewScroll:function(){var e,t=this,n=t.$element,o=t.$preview,a=t.scrollMap,r=parseFloat(n.css("line-height")),i=Math.floor(n[0].scrollTop/r);a||(a=t.scrollMap=t.buildScrollMap()),e=a[i],o.stop(!0).animate({scrollTop:e},100,"linear")},isPreviewModeButton:function(e){var t=this;return-1!==t.previewModeButtons.indexOf(e)},resetUndoStack:function(){var e=this,t=new s;return e.startValue=e.$element.val(),e.startPos=[0,0],t.changed=function(){e.disableButton(e.$btnUndo,!t.canUndo()),e.disableButton(e.$btnRedo,!t.canRedo())},t.changed(),t},parseButtons:function(){var t=this,n=t.$container,o=r.click;n.find(".md-btn,.md-btn-heading,.md-btn-export,.md-btn-emoji").each(function(){var n=e(this);n.off(o).on(o,function(e){t.clickButton(e,n)})})},getSelected:function(){var e=this,t=e.$element,n=t.val(),o=t[0];return n.substring(o.selectionStart,o.selectionEnd)},replaceSelected:function(e){var t=this,n=t.$element,o=n.val(),i=n[0],s=i.selectionStart,l=e.length,d=i.selectionEnd,c=o.substring(0,s)+e+o.substring(d),u=s+l;n.val(c).trigger(r.buttonPress,[[s,d],[s,u]]),a.setSelectionRange(i,s,u)},destroy:function(){var o=this,r=o.$element,i=o.$container,s=o.inputCss,l=a.NAMESPACE;s&&r.removeClass(s).show(),r.off(l),e(t).off(l),e(n).off(l),i.before(r).remove()},getLayout:function(e){var t,n,o,r,i=this,s=i.getConfig("templates",e)||a.EMPTY;return"dialog"===e&&(r=a.getBsProp("tagDialogHeader"),n="<"+r+' class="md-dialog-head-title modal-title"></'+r+">",o=i.getConfig("templates","dialogClose"),t=a.getBsProp("layoutDialogHeader").replace("{TITLE}",n).replace("{CLOSE}",o),s=s.replace("{HEADER}",t).replace("{DIALOG_CANCEL_ICON}",i.renderIcon("dialogCancel")).replace("{DIALOG_SUBMIT_ICON}",i.renderIcon("dialogSubmit")).replace("{DIALOG_CANCEL_TEXT}",i.dialogCancelText).replace("{DIALOG_SUBMIT_TEXT}",i.dialogSubmitText)),s},submitExportForm:function(t,n){var o,r,i,s=this,l=a.create("form"),d=s.$element.attr("id")+"-iframe",c=s.exportUrlAddlData;e("#"+d).length||a.create("iframe",{id:d,name:d,css:{display:"none"}}).appendTo("body"),o=a.create("input",{type:"hidden",name:"export_type",value:t}),r=a.create("input",{type:"hidden",name:"export_filename",value:s.exportFileName}),i=a.create("input",{name:"export_content",css:{display:"none"}}).val(n||s.noDataMsg),l.attr({target:d,action:s.exportUrl,method:s.exportUrlMethod}),l.append(o,r,i),c&&l.append("function"==typeof c?c():c),l.appendTo("body").hide().submit().remove()},showPopup:function(e,t,n){var o=this,a=r.modalShown;o.$dialogMain.removeClass("modal-lg"),n&&o.$dialogMain.addClass("modal-lg"),o.$dialogHeadTitle.html(e),o.$dialogContent.html(t).show(),o.$dialogInput.hide(),o.$dialogTitle.hide(),o.$dialogClose.show(),o.$dialogHeader.show(),o.$dialogFooter.hide(),o.$dialogSubmit.off(r.click),o.$dialog.modal("show"),o.$dialog.off(a).on(a,function(){o.$dialogClose.focus(),o.$dialog.off(a)})},showDialog:function(e,t,n){var o=this,i=o.getConfig("buttonPrompts",e),s=i.header||a.EMPTY,l=o.renderIcon(e),d=i.hintInput||a.EMPTY,c=i.hintTitle,u=r.modalShown,f=r.click;o.$dialogMain.removeClass("modal-lg"),o.$dialogHeadTitle.html(l?l+" "+s:s),o.$dialogContent.hide(),o.$dialogTitle.hide().val(n||a.EMPTY),o.$dialogClose.show(),o.$dialogHeader.show(),o.$dialogFooter.show(),o.$dialogInput.show().val(a.EMPTY).attr("placeholder",d),c&&!n&&o.$dialogTitle.show().attr("placeholder",c),o.$dialogSubmit.off(f).on(f,function(){var e=t(o.$dialogInput.val(),o.$dialogTitle.val());a.isEmpty(e)||o.replaceSelected(e)}),o.$dialog.modal("show"),o.$dialog.off(u).on(u,function(){o.$dialogInput.focus(),o.$dialog.off(u)})},raise:function(t,n,o){var r=this,i=e.Event(t+a.NAMESPACE);return o=o||r.$element,n?o.trigger(i,n):o.trigger(i),!i.isDefaultPrevented()||i.result===!1},showPreviewMsg:function(e){var t=this,n=t.$preview,o=t.getAlert(e,t.previewErrorTitle);n.html('<div class="md-preview-message">'+o+"</div>"),n.find(".md-preview-message").width(.5*n.width()),n.find(".md-alert").hide().fadeIn("slow")},disableButton:function(e,t){t?e.attr("disabled",!0):e.removeAttr("disabled")},hasInvalidConfig:function(e){var t=this,n=t[e+"Url"],o="export"===e?"exportUrlMethod":e+"Method",r=t[o],i=a.isEmpty(n),s=a.isEmpty(r),l=typeof r;return i&&s||!s&&"function"!==l&&"object"!==l},parseOutput:function(t){var n=this,o=n.postProcess;return o&&("function"==typeof o?t=o(t):"object"==typeof o&&e.each(o,function(e,n){e!==n&&(t=t.split(e).join(n))})),t},getPureHtml:function(e){var n=this;return n.purifyHtml&&t.DOMPurify?t.DOMPurify.sanitize(e):e},getHtml:function(e){var t=this,n=t.$element,r=t.parserMethod;return e===o&&(e=n.val()),a.isEmpty(t.parserUrl)?(e="function"==typeof r?r(e):new r(e),e=t.parseOutput(e),t.getPureHtml(e)):(t._ajaxSubmit(e),null)},generatePreview:function(e,t){var n=this,o=n.getHtml(e);return t?o:void n.$preview.html(o)},output:function(){var e,t=this,n=t.$element,o=t.$preview,i=n.val(),s=!0,l=0,d=r.successPreview,c=r.emptyPreview+" "+r.errorPreview;if(a.isEmpty(i)||t.hasInvalidConfig("parser"))return a.EMPTY;if(e=t.generatePreview(i,!0),a.isEmpty(t.parserUrl))return e;for(;s&&l<t.outputParseTimeout;)a.delay(function(){n.off(d).on(d,function(){s=!1,e=o.html()}).off(c).on(c,function(){s=!1,e=""}),l+=150},150);return e},toggleMode:function(e){var t,n=this,o=n.$element,r=o.val(),i=n.$container,s=n.currentMode||"modeEditor",l=i.find(".md-input-preview"),d=function(){"editor"===s&&(n.$preview.html(n.getProgress(n.loadingMsg)),setTimeout(function(){n.generatePreview(),n.$mode.focus()},50))};switch((a.isEmpty(r)||n.hasInvalidConfig("parser"))&&(t=a.isEmpty(r)?n.noDataMsg:n.noPreviewUrlMsg,n.showPopupAlert(n.getTitle("mode"),t,"errorToggleMode",[n.$modeInput.val()])),i.removeClass("md-only-preview"),l.removeClass("md-editor-mode md-preview-mode md-split-mode"),e){case"modeEditor":a.addCss(l,"md-editor-mode");break;case"modePreview":a.addCss(l,"md-preview-mode"),a.addCss(i,"md-only-preview"),d();break;case"modeSplit":a.addCss(l,"md-split-mode"),d()}},toggleFullScreen:function(){var e=this,t=e.$container,n=e.$element,o=e.$preview;t.hasClass("md-fullscreen-overlay")?e.raise("normalScreen")&&(t.removeClass("md-fullscreen-overlay"),n.height(e.defaultInputHeight),o.height(e.defaultInputHeight)):e.raise("fullScreen")&&(t.addClass("md-fullscreen-overlay"),e.resizeFullScreen()),o.is(":visible")?o.focus():n.focus()},escapeFullScreen:function(e){var t=this;t.enableEscKeyFullScreen&&t.$container.hasClass("md-fullscreen-overlay")&&27==e.keyCode&&t.toggleFullScreen()},resizeFullScreen:function(){var n=this,o=n.$container,a=n.$element,r=o.find(".md-header"),i=o.find(".md-footer"),s=e(t).height()-r.outerHeight(!0)-i.outerHeight(!0)-(a.outerHeight(!0)-a.height());a.height(s),n.$preview.height(s)},process:function(e){var t,n,r,i,s,l=this,d=l.$element,c=l.getSelected(),u=c.length,f=l.getConfig("buttonActions",e);return"mode"!==e&&"export"!==e.substring(0,6)&&d.focus(),"undo"===e||"redo"===e?"":f?"function"==typeof f?(t=f(c),"function"==typeof t?(l.showDialog(e,t,c),a.EMPTY):t):"object"!=typeof f||f.before===o&&f.after===o?a.EMPTY:(r=a.isEmpty(f.before)?a.EMPTY:f.before,i=a.isEmpty(f.after)?a.EMPTY:f.after,n=f["default"],s=f.skipSpaces,t=f.inline?a.getMarkUp(c,r,i,s):a.getBlockMarkUp(c,r,i,s),n?u>0?t:n:t):a.EMPTY},download:function(e,n){var o,r=this,i=r.getConfig("exportConfig",e),s=i.ext||"",l=i.uri||"";return a.isEmpty(r.exportUrl)?(l+=t.btoa(n),o=a.create("a",{href:l,download:r.getFileName(e)}).appendTo("body"),o[0].click(),void o.remove()):void r.submitExportForm(s,n)},getLabel:function(e){var t=this;return t.renderIcon(e)+" "+(t.getConfig("buttonLabels",e)||a.EMPTY)},getTitle:function(e){var t=this;return t.renderIcon(e)+" "+(t.getConfig("buttonTitles",e)||a.EMPTY)},getProgress:function(e){return'<div class="md-loading">'+e+"</div>"},getAlert:function(e,t,n){
        var o=this;return t=t?"<h4>"+(n?"":o.renderIcon("alertMsg"))+t+"</h4>":"",'<div class="'+o.alertMsgCss+' md-alert">'+t+e+"</div>"},showPopupAlert:function(e,t,n,o){var a=this,i=a.$dialog.find(".modal-body"),s=a.alertFadeDuration,l=r.modalShown,d=r.modalHidden;a.showAlerts&&(a.showPopup("",a.getAlert(t,e,!0)),a.$dialogHeader.hide(),a.$dialogFooter.hide(),a.$dialogClose.hide(),i.addClass("md-zero-pad"),a.$dialog.off(l).on(l,function(){s?setTimeout(function(){a.$dialog.modal("hide").off(l)},s):a.$dialog.modal("hide").off(l)}),a.$dialog.off(d).on(d,function(){i.removeClass("md-zero-pad"),a.$dialog.off(l).off(d),a.$element.focus()})),n&&(o=o||[],o.push(e),o.push(t),a.raise(n,o))},getHtmlContent:function(e){var t=this,n=t.exportPrependCssJs;return"<html>\n<head>\n"+t.getLayout("htmlMeta")+t.getLayout("exportCssJs").replace("{EXPORT_PREPEND_CSS_JS}",n)+"\n</head>\n<body>\n"+e+"\n</body>\n</html>"},exportData:function(e){var t,n,o,r=this,i=r.$element.val(),s=r.getTitle("exportText"),l=r.getTitle("exportHtml"),d=r.noDataMsg,c=r.noExportUrlMsg,u=r.today||new Date;return a.isEmpty(i)||!a.isEmpty(r.exportUrl)&&r.hasInvalidConfig("export")?(n="exportText"===e?s:l,o=a.isEmpty(i)?d:c,void r.showPopupAlert(n,o,"errorExport",[e])):(i=r.getLayout("exportHeader").replace("{TODAY}",u).replace("{CREDITS}",a.CREDITS_MD)+i,"exportHtml"!==e?void r.download("exportText",i):(t=a.parseHtml(r.generatePreview(i,!0)),void r.download("exportHtml",r.getHtmlContent(t))))},renderIcon:function(e){var t=this;return t.getConfig("icons",e)||a.EMPTY},render:function(){var t,n=this,o=n.$element,r=a.create("div").addClass("md-container"),i=n.getLayout("main"),s="md-editor-input-temporary",l=o.attr("id")+"-container";return i?(n.theme&&a.addCss(r,"theme-"+n.theme),t=i.replace("{INPUT}",'<div class="'+s+'"></div>').replace("{HEADER}",n.renderHeader()).replace("{FOOTER}",n.renderFooter()).replace("{PREVIEW}",n.getLayout("preview")).replace("{DIALOG}",n.getLayout("dialog")),r.attr("id",l).insertBefore(o).html(t),r.find("."+s).before(o).remove(),a.addCss(o,n.inputCss),n.$container=r,n.$editor=r.find(".md-editor"),n.$preview=r.find(".md-preview"),n.$btnPreview=r.find(".md-btn-preview"),n.$btnUndo=r.find(".md-btn-undo"),n.$btnRedo=r.find(".md-btn-redo"),n.$dialog=r.find(".md-dialog"),n.$dialogHeadTitle=n.$dialog.find(".md-dialog-head-title"),n.$dialogInput=n.$dialog.find(".md-dialog-input"),n.$dialogTitle=n.$dialog.find(".md-dialog-title"),n.$dialogContent=n.$dialog.find(".md-dialog-content"),n.$dialogCancel=n.$dialog.find(".md-dialog-cancel"),n.$dialogSubmit=n.$dialog.find(".md-dialog-submit"),n.$dialogClose=n.$dialog.find(".close"),n.$dialogMain=n.$dialog.find(".modal-dialog"),n.$dialogHeader=n.$dialog.find(".modal-header"),n.$dialogFooter=n.$dialog.find(".modal-footer"),n.$mode=r.find(".md-btn-mode"),n.$modeInput=n.$mode.find('input:radio[name="mdMode"]'),n.$inputPreview=r.find(".md-input-preview"),n.$inputCell=r.find(".md-input-cell"),n.$previewCell=r.find(".md-preview-cell"),n.previewModeTitle&&n.$editor.find(".md-toolbar-header-l").prepend('<div class="md-preview-mode-title">'+n.previewModeTitle+"</div>"),"preview"===n.defaultMode||n.enableSplitMode&&"split"===n.defaultMode||(n.defaultMode="editor"),n.currentMode=n.defaultMode,a.addCss(n.$inputPreview,"md-"+n.defaultMode+"-mode"),void e.each(n.dropUp,function(e,t){t&&r.find('button[data-key="'+e+'"]').parent().addClass("dropup")})):a.EMPTY},initToolbar:function(){var t=this,n=["toolbarHeaderL","toolbarHeaderR","toolbarFooterL","toolbarFooterR"];e.each(n,function(n,a){t[a]!==o&&e.isArray(t[a])||(t[a]=i.toolbar[a])})},getButtons:function(t){var n=this,o=[];return e.each(n[t],function(t,n){var a=e.isArray(n)?n:[n];e.merge(o,a)}),o},getValidButtons:function(){var t=this,n=t.getButtons("toolbarHeaderL");return e.merge(n,t.getButtons("toolbarHeaderR")),e.merge(n,t.getButtons("toolbarFooterL")),e.merge(n,t.getButtons("toolbarFooterR")),n},renderHint:function(){var t,n,o,r,i,s,l=this,d="{ACCESS_KEYS}";return t=l.getLayout("hint").replace("{LINK_CM}",a.LINK_CM).replace("{LINK_MI}",a.LINK_MI),-1===t.indexOf(d)?t:(n='<div class="md-hint-access-keys"><ul>',e.each(l.getValidButtons(),function(e,t){var a,d="emoji"===t&&!l.enableEmojies||l.hiddenActions.indexOf(t)>-1;if(!d)if(s=l.getConfig("buttonCss",t)||l.defaultButtonCss,"heading"===t)for(i=1;6>=i;i++)o=l.renderIcon("heading")+i,a=l.getConfig("buttonAccessKeys",t+i),r=l.getConfig("buttonTitles","heading")+" "+i,n+='<li title="'+r+'"><p><span class="'+s+'">'+o+"</span></p><p><kbd>ALT</kbd> &ndash; <kbd>"+a+"</kbd></p></li>";else"export"!==t.substring(0,6)&&"mode"!==t.substring(0,4)&&(a=l.getConfig("buttonAccessKeys",t),o=l.renderIcon(t),r=l.getConfig("buttonTitles",t),n+='<li title="'+r+'"><p><span class="'+s+'">'+o+"</span></p><p><kbd>ALT</kbd> &ndash; <kbd>"+a+"</kbd></p></li>")}),n+="</ul></div>",t.replace(d,n))},renderHeader:function(){var e=this,t=e.getLayout("header");return t=e.renderToolbar(t,"toolbarHeaderL"),t=e.renderToolbar(t,"toolbarHeaderR")},renderFooter:function(){var e=this,t=e.getLayout("footer");return t=e.renderToolbar(t,"toolbarFooterL"),t=e.renderToolbar(t,"toolbarFooterR")},renderToolbar:function(t,n){var o,a,r,i=this,s=n.toUpperCase(),l="",d="";return o="{"+s.substring(0,7)+"_"+s.substring(7,13)+"_"+s.substring(13,14)+"}",-1===t.indexOf(o)?t:(e.each(i[n],function(t,n){e.isArray(n)||(n=[n]),r="",e.each(n,function(e,t){a=i.getConfig("buttonGroupCss",t)||i.defaultButtonGroupCss,r+=i.renderButton(t)+"\n",i.isPreviewModeButton(t)&&(a+=" md-always-visible"),"mode"===t&&(a+=" btn-group-toggle md-btn-mode",d=' data-toggle="buttons"')}),l+='<div class="'+a+'" role="group"'+d+">\n"+r+"</div>\n"}),t.replace(o,l))},getFileName:function(e){var t=this,n=t.exportFileName,o=t.getConfig("exportConfig",e),a=o&&o.ext||"";return a?n+"."+a:n},renderMenuItem:function(e,t){var n,o,r,i=this,s=a.create("div"),l=e+t;return"export"===e?(o=i.getConfig("buttonTitles",l),r=i.getLabel(l)):(o=i.getConfig("buttonTitles",e),r=o+" "+t),n=a.create("a",{href:"#","class":"dropdown-item md-btn-"+e+" md-btn-"+l,title:o,accesskey:i.getConfig("buttonAccessKeys",l),"data-key":l}).html(r),r=s.append(n).html(),s.remove(),a.getBsProp("layoutMenuItem").replace("{CONTENT}",r)},getEmojies:function(){var n=this,o="";return!n.enableEmojies||a.isEmpty(t.mdEmojies)?"":(o='<li class="md-emoji-search"><span class="md-close">&times;</span><input type="text" class="form-control form-control-sm input-sm" placeholder="'+n.emojiSearchHint+'"></li>',e.each(t.mdEmojies,function(e,r){var i,s,l=":"+a.htmlEncode(e)+":",d=t.mdEmojiesShortcuts[e]||"";if(d)for(l+=" or ",i=0;i<d.length;i++)s=a.htmlEncode(d[i]),l+=0===i?s:" or "+s;o+='<li><a href="#" class="md-btn-emoji" title="'+l+'" data-key="'+e+'"><span class="md-emoji">'+(n.useTwemoji?t.twemoji.parse(r):r)+"</span></a></li>"}),o)},getModeButton:function(e){var t=this,n=t.getConfig("buttonCss",e)||t.defaultButtonCss||"",o="",r=e.substr(4).toLowerCase(),i=t.getConfig("buttonAccessKeys",e)||"",s=a.uniqueId()+e;return t.defaultMode===r&&(o=" checked"),a.getBsProp("layoutBtnRadioGroup").replaceAll("{ID}",s).replaceAll("{LABEL}",t.renderIcon(e)).replaceAll("{LABEL_TITLE}",t.getConfig("buttonTitles",e)).replaceAll("{LABEL_CSS}",n).replaceAll("{VALUE}",e).replaceAll("{KEY}",i).replaceAll("{CHECK}",o)},renderButton:function(e){var t,n,r,i,s,l,d,c,u,f,p=this,r=p.getConfig("icons",e),m="md-btn-"+e,h=p.getConfig("dropdownCss",e),g="mode"===e||r!==o||p.getConfig("buttonActions",e)!==o,b="emoji"===e&&!p.enableEmojies||p.hiddenActions.indexOf(e)>-1,v=a.isBs(3)||"emoji"===e?"ul":"div";if(!g||b||!p.enableUndoRedo&&("undo"===e||"redo"===e||"editor"===e))return a.EMPTY;switch(u=p.getConfig("buttonCss",e)||p.defaultButtonCss,n=a.create("div"),t=a.create("button",{type:"button","data-key":e}),p.disableButton(t,p.isDisabled&&!p.isPreviewModeButton(e)),r=p.renderIcon(e),i=p.getConfig("buttonTitles",e)||a.EMPTY,s=p.getConfig("buttonLabels",e)||a.EMPTY,i&&t.attr("title",i),"fullscreen"===e&&(r='<span class="md-max-icon">'+r+'</span><span class="md-min-icon">'+p.renderIcon("minscreen")+"</span>"),s=r&&s?r+" "+s:r+s,n.append(t),e){case"emoji":case"export":case"heading":if(t.html(s+" ").attr(a.getBsProp("dataPrefix")+"toggle","dropdown").append('<span class="caret"></span>').addClass(u+" dropdown-toggle"),f=h?"dropdown-menu "+h:"dropdown-menu",c="<"+v+' class="'+f+'">\n',"heading"===e)for(d=1;7>d;d++)l=i+" "+d,c+=p.renderMenuItem("heading",d);else c+="emoji"===e?p.getEmojies():p.renderMenuItem(e,"Html")+p.renderMenuItem(e,"Text");return c+="</"+v+">",n.append(c),n.html();case"mode":return p.getModeButton("modeEditor")+p.getModeButton("modePreview")+(p.enableSplitMode?p.getModeButton("modeSplit"):"");default:return t.attr("accesskey",p.getConfig("buttonAccessKeys",e)).html(s).addClass(u+" "+m+" md-btn"),n.html()}},_mergeAjaxCallback:function(e,t){var n=this,o=n._ajaxSettings,a=n.mergeAjaxCallbacks,r=o[e];a&&"function"==typeof r?"before"===a?o[e]=function(){r.apply(this,arguments),t.apply(this,arguments)}:o[e]=function(){t.apply(this,arguments),r.apply(this,arguments)}:o[e]=t},_ajaxSubmit:function(t){var n,o,a,r,i,s=this,l=s.ajaxParserErrorMsg,d=s.getTitle("exportHtml");n=function(e){s.raise("beforeExportHtm",[e])&&s.showPopup(d,s.getProgress(s.ajaxParserProgressMsg))},o=function(e,t,n){s.$dialog.modal("hide"),e?(i=s.getPureHtml(e),s.download("exportHtml",s.getHtmlContent(i)),s.raise("successExportHtm",[e,t,n])):s.showPopupAlert(d,l,"errorExportHtm",[e,t,n])},a=function(e,t,n){s.showPopupAlert(d,l,"exceptionExportHtm",[e,t,n])},s._ajaxSettings=e.extend(!0,{},s.ajaxSettings),s._mergeAjaxCallback("beforeSend",n),s._mergeAjaxCallback("success",o),s._mergeAjaxCallback("error",a),r=e.extend(!0,{},{type:"POST",url:s.parserUrl,data:{source:t}},s._ajaxSettings),e.ajax(r)}},e.fn.markdownEditor=function(t){var n=Array.apply(null,arguments),o=[];switch(n.shift(),this.each(function(){var r,i=e(this),s=i.data("markdownEditor"),l="object"==typeof t&&t,c=l.theme||i.data("theme"),u={},f={},p=l.language||i.data("language")||e.fn.markdownEditor.defaults.language||"en";s||(c&&(f=e.fn.markdownEditorThemes[c]||{}),"en"===p||a.isEmpty(e.fn.markdownEditorLocales[p])||(u=e.fn.markdownEditorLocales[p]||{}),r=e.extend(!0,{},e.fn.markdownEditor.defaults,f,e.fn.markdownEditorLocales.en,u,l,i.data()),s=new d(this,r),i.data("markdownEditor",s)),"string"==typeof t&&o.push(s[t].apply(s,n))}),o.length){case 0:return this;case 1:return o[0];default:return o}},e.fn.markdownEditor.defaults={language:"en",theme:null,defaultMode:"editor",enableUndoRedo:!0,enableSplitMode:!0,enableLivePreview:o,enableScrollSync:!0,startFullScreen:!1,enableEmojies:!0,useTwemoji:!1,purifyHtml:!0,showAlerts:!0,enableEscKeyFullScreen:!0,toolbarHeaderL:o,toolbarHeaderR:o,toolbarFooterL:o,toolbarFooterR:o,exportPrependCssJs:o,hiddenActions:[],dropUp:{"export":!0},parserUrl:a.EMPTY,parserMethod:o,ajaxSettings:{},ajaxMergeCallbacks:!0,markdownItOptions:{html:!1,xhtmlOut:!0,breaks:!0,linkify:!0,typographer:!0,highlight:function(e){return t.hljs?t.hljs.highlightAuto(e).value:e}},markdownItDisabledRules:[],markdownItPlugins:{markdownitDeflist:{},markdownitFootnote:{},markdownitAbbr:{},markdownitEmoji:{},markdownitSub:{},markdownitSup:{},markdownitMark:{},markdownitIns:{},markdownitSmartArrows:{},markdownitCheckbox:{divWrap:!0,divClass:"form-check checkbox",idPrefix:"cbx_"},markdownitCjkBreaks:{}},exportUrl:a.EMPTY,exportUrlMethod:"post",exportUrlAddlData:a.EMPTY,today:a.EMPTY,alertFadeDuration:2e3,outputParseTimeout:18e5,exportConfig:i.exportConfig,templates:{},inputCss:"md-input",alertMsgCss:"alert alert-danger",defaultButtonCss:"btn btn-default btn-outline-secondary",defaultButtonGroupCss:"btn-group md-btn-group",previewModeButtons:["hint","fullscreen","mode","export"],buttonCss:{},buttonGroupCss:{},buttonAccessKeys:{},dropdownCss:{},icons:{},postProcess:{"<table>":'<table class="table table-bordered table-striped">',"<pre>":'<pre class="md-codeblock">',"<blockquote>":'<blockquote class="blockquote md-blockquote">','<input type="checkbox"':'<input type="checkbox" class="form-check-input"','<label for="cbx':'<label class="form-check-label" for="cbx'}},e.fn.markdownEditorLocales.en={ajaxParserErrorMsg:"Error parsing markdown text. Please try again later.",ajaxParserProgressMsg:"Parsing markdown text ...",noDataMsg:"No valid source data found!",exportFileName:"export",buttonTitles:{},buttonLabels:{},buttonPrompts:{},buttonActions:{},templates:{},dialogCancelText:"Cancel",dialogSubmitText:"Submit",previewErrorTitle:"Preview Error",previewModeTitle:"Preview Mode",previewProgressMsg:"Generating preview ...",noPreviewUrlMsg:"Markdown preview processor unavailable. Please contact the system administrator.",noExportUrlMsg:"Export processor unavailable. Please contact the system administrator.",emojiSearchHint:"Search emojis ...",loadingMsg:"Loading ..."},e.fn.markdownEditor.Constructor=d,e(n).ready(function(){var t=e("textarea.markdown");t.length&&t.markdownEditor()})});