/*!
 * krajee-markdown-editor v1.0.0
 * http://plugins.krajee.com/krajee-markdown-editor
 *
 * Krajee Markdown Editor Font Awesome 4.x Theme
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2021, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD 3-Clause
 * https://github.com/kartik-v/krajee-markdown-editor/blob/master/LICENSE.md
 */
(function (factory) {
    'use strict';
    if (typeof define === 'function' && define.amd) {
        define(['jquery', 'window', 'document'], factory);
    } else if (typeof module === 'object' && typeof module.exports === 'object') {
        factory(require('jquery'), window, document);
    } else {
        factory(window.jQuery, window, document);
    }
}(function ($, window, document, undefined) {
    $.fn.markdownEditorThemes.fa4 = {
        icons: {
            undo: '<span class="fa fa-fw fa-undo"></span>',
            redo: '<span class="fa fa-fw fa-repeat"></span>',
            bold: '<span class="fa fa-fw fa-bold"></span>',
            italic: '<span class="fa fa-fw fa-italic"></span>',
            ins: '<span class="fa fa-fw fa-underline"></span>',
            del: '<span class="fa fa-fw fa-strikethrough"></span>',
            sup: '<span class="fa fa-fw fa-superscript"></span>',
            sub: '<span class="fa fa-fw fa-subscript"></span>',
            mark: '<span class="fa fa-fw fa-eraser"></span>',
            paragraph: '<span class="fa fa-fw fa-paragraph"></span>',
            newline: '<span class="fa fa-fw fa-text-height"></span>',
            heading: '<span class="fa fa-fw fa-header"></span>',
            link: '<span class="fa fa-fw fa-link"></span>',
            image: '<span class="fa fa-fw fa-picture-o"></span>',
            indent: '<span class="fa fa-fw fa-indent"></span>',
            outdent: '<span class="fa fa-fw fa-outdent"></span>',
            ul: '<span class="fa fa-fw fa-list-ul"></span>',
            ol: '<span class="fa fa-fw fa-list-ol"></span>',
            dl: '<span class="fa fa-fw fa-th-list"></span>',
            footnote: '<span class="fa fa-fw fa-sticky-note-o"></span>',
            blockquote: '<span class="fa fa-fw fa-quote-right"></span>',
            code: '<span class="fa fa-fw fa-code"></span>',
            codeblock: '<span class="fa fa-fw fa-file-code-o"></span>',
            hr: '<span class="fa fa-fw fa-minus"></span>',
            emoji: '<span class="fa fa-fw fa-smile-o"></span>',
            fullscreen: '<span class="fa fa-fw fa-arrows-alt"></span>',
            minscreen: '<span class="fa fa-fw fa-compress"></span>',
            hint: '<span class="fa fa-fw fa-lightbulb-o"></span>',
            modePreview: '<span class="fa fa-fw fa-search"></span>',
            modeEditor: '<span class="fa fa-fw fa-edit"></span>',
            modeSplit: '<span class="fa fa-fw fa-arrows-h"></span>',
            export: '<span class="fa fa-fw fa-download"></span>',
            exportHtml: '<span class="fa fa-fw fa-file-text"></span>',
            exportText: '<span class="fa fa-fw fa-file"></span>',
            alertMsg: '<span class="fa fa-fw fa-exclamation-circle"></span>',
            dialogCancel: '<span class="fa fa-fw fa-times"></span>',
            dialogSubmit: '<span class="fa fa-fw fa-check"></span>'
        }
    };
}));