/*!
 * krajee-markdown-editor v1.0.0
 * http://plugins.krajee.com/krajee-markdown-editor
 *
 * Krajee Markdown Editor Font Awesome 4.x Theme
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2021, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD 3-Clause
 * https://github.com/kartik-v/krajee-markdown-editor/blob/master/LICENSE.md
 */
(function (factory) {
    'use strict';
    if (typeof define === 'function' && define.amd) {
        define(['jquery', 'window', 'document'], factory);
    } else if (typeof module === 'object' && typeof module.exports === 'object') {
        factory(require('jquery'), window, document);
    } else {
        factory(window.jQuery, window, document);
    }
}(function ($, window, document, undefined) {
    $.fn.markdownEditorThemes.fa5 = {
        icons: {
            undo: '<span class="fas fa-fw fa-undo"></span>',
            redo: '<span class="fas fa-fw fa-redo"></span>',
            bold: '<span class="fas fa-fw fa-bold"></span>',
            italic: '<span class="fas fa-fw fa-italic"></span>',
            ins: '<span class="fas fa-fw fa-underline"></span>',
            del: '<span class="fas fa-fw fa-strikethrough"></span>',
            sup: '<span class="fas fa-fw fa-superscript"></span>',
            sub: '<span class="fas fa-fw fa-subscript"></span>',
            mark: '<span class="fas fa-fw fa-eraser"></span>',
            paragraph: '<span class="fas fa-fw fa-paragraph"></span>',
            newline: '<span class="fas fa-fw fa-text-height"></span>',
            heading: '<span class="fas fa-fw fa-heading"></span>',
            link: '<span class="fas fa-fw fa-link"></span>',
            image: '<span class="far fa-fw fa-image"></span>',
            indent: '<span class="fas fa-fw fa-indent"></span>',
            outdent: '<span class="fas fa-fw fa-outdent"></span>',
            ul: '<span class="fas fa-fw fa-list-ul"></span>',
            ol: '<span class="fas fa-fw fa-list-ol"></span>',
            dl: '<span class="fas fa-fw fa-th-list"></span>',
            footnote: '<span class="far fa-fw fa-sticky-note"></span>',
            blockquote: '<span class="fas fa-fw fa-quote-right"></span>',
            code: '<span class="fas fa-fw fa-code"></span>',
            codeblock: '<span class="far fa-fw fa-file-code"></span>',
            hr: '<span class="fas fa-fw fa-minus"></span>',
            emoji: '<span class="far fa-fw fa-smile"></span>',
            fullscreen: '<span class="fas fa-fw fa-arrows-alt"></span>',
            minscreen: '<span class="fas fa-fw fa-compress"></span>',
            hint: '<span class="fas fa-fw fa-lightbulb"></span>',
            modePreview: '<span class="fas fa-fw fa-search"></span>',
            modeEditor: '<span class="fas fa-fw fa-edit"></span>',
            modeSplit: '<span class="fas fa-fw fa-arrows-alt-h"></span>',
            export: '<span class="fas fa-fw fa-download"></span>',
            exportHtml: '<span class="fas fa-fw fa-file-alt"></span>',
            exportText: '<span class="fas fa-fw fa-file"></span>',
            alertMsg: '<span class="fas fa-fw fa-exclamation-circle"></span>',
            dialogCancel: '<span class="fas fa-fw fa-times"></span>',
            dialogSubmit: '<span class="fas fa-fw fa-check"></span>'
        }
    };
}));