// http://nightwatchjs.org/guide#settings-file
module.exports = {
  src_folders: ['test/e2e/test'],
  output_folder: 'test/e2e/report',
  custom_commands_path: ['node_modules/nightwatch-helpers/commands'],
  custom_assertions_path: ['node_modules/nightwatch-helpers/assertions'],

  selenium: {
    start_process: true,
    server_path: 'node_modules/selenium-server/lib/runner/selenium-server-standalone-3.141.59.jar',
    host: '127.0.0.1',
    port: 4444,
    cli_args: {
      'webdriver.chrome.driver': require('chromedriver').path
    }
  },

  test_settings: {
    default: {
      selenium_port: 4444,
      selenium_host: 'localhost',
      silent: true,
      screenshots: {
        enabled: true,
        on_failure: true,
        on_error: false,
        path: 'test/e2e/screenshots'
      }
    },

    chrome: {
      desiredCapabilities: {
        browserName: 'chrome',
        javascriptEnabled: true,
        acceptSslCerts: true,
        chromeOptions: {
          // Issue https://github.com/nightwatchjs/nightwatch/issues/2149
          w3c: false
        }
      }
    },

    firefox: {
      desiredCapabilities: {
        browserName: 'firefox',
        javascriptEnabled: true,
        acceptSslCerts: true
      }
    },

    headless: {
      desiredCapabilities: {
        browserName: 'chrome',
        chromeOptions : {
          args : ['headless'],
          w3c: false
        },
        javascriptEnabled: true,
        acceptSslCerts: true
      }
    }
  }
}
