# Формат сообщений локализации

## Именованный формат

Сообщения локализации:

```js
const messages = {
  en: {
    message: {
      hello: '{msg} world'
    }
  },
  ru: {
    message: {
      hello: '{msg} мир'
    }
  }
}
```

Шаблон:

```html
<p>{{ $t('message.hello', { msg: 'привет' }) }}</p>
```

Результат:

```html
<p>привет мир</p>
```

## Формат списков

Сообщения локализации:

```js
const messages = {
  en: {
    message: {
      hello: '{0} world'
    }
  },
  ru: {
    message: {
      hello: '{0} мир'
    }
  }
}
```

Шаблон:

```html
<p>{{ $t('message.hello', ['привееет']) }}</p>
```

Результат:

```html
<p>привееет мир</p>
```

Форматирование списков также принимает объекты, соответствующие по структуре массиву:

```html
<p>{{ $t('message.hello', {'0': 'привееет'}) }}</p>
```

Результат:

```html
<p>привееет мир</p>
```

## HTML формат

:::warning Обратите внимание
:warning: Динамическая локализация произвольного HTML на вебсайте очень опасна, потому что легко может привести к XSS-уязвимостям. Используйте HTML-интерполяцию только для доверенного контента и никогда для пользовательского.

Рекомендуем в таких случаях использовать возможности [интерполяции компонента](interpolation.md).
:::

:::warning Обратите внимание

> :new: Добавлено в версии 8.11+

Можно управлять использованием HTML форматирования. Для подробностей см. опцию конструктора `warnHtmlInMessage` и свойства API.
:::

Иногда требуется отобразить сообщение локализации HTML-кодом, а не статической строкой.

```js
const messages = {
  en: {
    message: {
      hello: 'hello <br> world'
    }
  },
  ru: {
    message: {
      hello: 'привет <br> мир'
    }
  }
}
```

Шаблон:

```html
<p v-html="$t('message.hello')"></p>
```

Результат (вместо отформатированного сообщения)

```html
<p>
  привет
  <!-- <br> существует, но отрисован как html, а не строкой -->
  мир
</p>
```

## Формат ruby on rails i18n

Сообщения локализации:

```js
const messages = {
  en: {
    message: {
      hello: '%{msg} world'
    }
  },
  ru: {
    message: {
      hello: '%{msg} мир'
    }
  }
}
```

Шаблон:

```html
<p>{{ $t('message.hello', { msg: 'привет' }) }}</p>
```

Результат:

```html
<p>привет мир</p>
```

## Пользовательский формат

Иногда может потребоваться реализовать локализацию для собственного формата сообщений (например, использовать [синтаксиса сообщений ICU](http://userguide.icu-project.org/formatparse/messages)).

Реализовать это можно с помощью специального пользовательского метода форматирования, который должен реализовать [интерфейс Formatter](https://github.com/kazupon/vue-i18n/blob/dev/decls/i18n.js#L145-L147).

Пример пользовательского метода форматирования с синтаксисом класса ES2015:

```js
// Реализация пользовательского Formatter
class CustomFormatter {
  constructor(options) {
    // ...
  }

  //
  // interpolate
  //
  // @param {string} message
  //   строка или список или именованный формат
  //   напр.
  //   - именованный формат: 'Hi {name}'
  //   - формат списка: 'Hi {0}'
  //
  // @param {Object | Array} values
  //   значения интерполяции `message`.
  //   переданные значения с `$t`, `$tc` и функциональным компонентом `i18n`.
  //   напр.
  //   - $t('hello', { name: 'Alex' }) -> переданные значения: Object `{ name: 'Alex' }`
  //   - $t('hello', ['Alex']) -> переданные значения: Array `['Alex']`
  //   - функциональный компонент `i18n` (интерполяция в компоненте)
  //     <i18n path="hello">
  //       <p>Alex</p>
  //       <p>how are you?</p>
  //     </i18n>
  //     -> переданные значения: Array (included VNode):
  //        `[VNode{ tag: 'p', text: 'Alex', ...}, VNode{ tag: 'p', text: 'how are you?', ...}]`
  //
  // @return {Array<any>}
  //   интерполированные значения. Они необходимы чтобы вернуть следующее:
  //   - массив строк, когда используется `$t` или `$tc`.
  //   - массив, включая объект VNode, когда используется функциональный компонент `i18n`.
  //
  interpolate(message, values) {
    // реализация логики интерполяции
    // ...

    // возвращаем интерполированный массив
    return ['resolved message string']
  }
}

// Регистрация через опцию `formatter`
const i18n = new VueI18n({
  locale: 'en-US',
  formatter: new CustomFormatter(/* опции конструктора */),
  messages: {
    'en-US': {
      // ...
    },
    'ru-RU': {
      // ...
    }
    // ...
  }
})

// Запускаем приложение!
new Vue({ i18n }).$mount('#app')
```

Также посмотрите [официальный пример пользовательского метода форматирования](https://github.com/kazupon/vue-i18n/tree/dev/examples/formatting/custom).
