# Переключение локализации

Обычно используют корневой экземпляр Vue в качестве точки истины, а все дочерние компоненты используют свойство `locale` от класса `VueI18n` передаваемого по ссылке.

Иногда может потребоваться динамически переключать локализацию. Для этого нужно изменить значение свойства `locale` экземпляра `VueI18n`.

```js
const i18n = new VueI18n({
  locale: 'ru', // устанавливаем локализацию по умолчанию
  ...
})

// Создаём корневой экземпляр Vue
new Vue({
  i18n,
  ...
}).$mount('#app')

// Переключаем на другую локализацию
i18n.locale = 'en'
```

Каждый компонент содержит экземпляр `VueI18n`, ссылающийся на свойство `$i18n`, которое также можно использовать для переключения локализации.

Пример:

```vue
<template>
  <div class="locale-changer">
    <select v-model="$i18n.locale">
      <option v-for="(lang, i) in langs" :key="`Lang${i}`" :value="lang">
        {{ lang }}
      </option>
    </select>
  </div>
</template>

<script>
  export default {
    name: 'locale-changer',
    data() {
      return { langs: ['ru', 'en'] }
    }
  }
</script>
```

:::warning Обратите внимание
:warning: Изменение локализации игнорируется компонентами с опцией `sync: false`.
:::

:::warning Компонент vs. корневая область видимости
:warning: Изменение `$i18n.locale` внутри компонента не приводит к изменению корневой локализации. Если вы полагаетесь на корневую локализацию, например, при использовании [корневой запасной локализации](./fallback.html), используйте `$root.$i18n.locale` вместо `$i18n.locale`.
:::
