const fs = require('fs')

const { blue } = require('./log.js')

function write (dest, code) {
  return new Promise(function (resolve, reject) {
    fs.writeFile(dest, code, function (err) {
      if (err) {
        return reject(err)
      }

      console.log(blue(dest) + ' ' + getSize(code))
      resolve(code)
    })
  })
}

function getSize (code) {
  return (code.length / 1024).toFixed(2) + 'kb'
}

module.exports = write
