/**
@license
Copyright 2018 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import {html} from '@polymer/lit-element/lit-element.js';

export const style = html`<style>.mdc-snackbar{display:flex;position:fixed;bottom:0;left:50%;align-items:center;justify-content:flex-start;box-sizing:border-box;padding-right:24px;padding-left:24px;transform:translate(-50%, 100%);transition:transform .25s 0ms cubic-bezier(0.4, 0, 1, 1);background-color:#323232;pointer-events:none;will-change:transform}@media (max-width: 599px){.mdc-snackbar{left:0;width:100%;transform:translate(0, 100%)}}@media (min-width: 600px){.mdc-snackbar{min-width:288px;max-width:568px;border-radius:2px}}@media (min-width: 600px){.mdc-snackbar--align-start{left:24px;right:initial;bottom:24px;transform:translate(0, 200%)}[dir="rtl"] .mdc-snackbar--align-start,.mdc-snackbar--align-start[dir="rtl"]{left:initial;right:24px}}@media (max-width: 599px){.mdc-snackbar--align-start{bottom:0;left:0;width:100%;transform:translate(0, 100%)}}.mdc-snackbar--active{transform:translate(0);transition:transform .25s 0ms cubic-bezier(0, 0, 0.2, 1);pointer-events:auto}.mdc-snackbar--active:not(.mdc-snackbar--align-start){transform:translate(-50%, 0)}@media (max-width: 599px){.mdc-snackbar--active:not(.mdc-snackbar--align-start){bottom:0;left:0;width:100%;transform:translate(0)}}.mdc-snackbar__action-wrapper{padding-left:24px;padding-right:0}[dir="rtl"] .mdc-snackbar__action-wrapper,.mdc-snackbar__action-wrapper[dir="rtl"]{padding-left:0;padding-right:24px}.mdc-snackbar--action-on-bottom{flex-direction:column}.mdc-snackbar__text{font-family:Roboto,sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;font-size:1rem;line-height:1.5rem;font-weight:400;letter-spacing:.03125em;text-decoration:inherit;text-transform:inherit;margin-left:0;margin-right:auto;display:flex;align-items:center;height:48px;transition:opacity .3s 0ms cubic-bezier(0.4, 0, 1, 1);opacity:0;color:#fff}.mdc-snackbar[dir="rtl"] .mdc-snackbar__text,[dir="rtl"] .mdc-snackbar .mdc-snackbar__text{margin-left:auto;margin-right:0}@media (min-width: 600px){.mdc-snackbar__text{padding-left:0;padding-right:24px}[dir="rtl"] .mdc-snackbar__text,.mdc-snackbar__text[dir="rtl"]{padding-left:24px;padding-right:0}}.mdc-snackbar--action-on-bottom .mdc-snackbar__text{margin-right:inherit}.mdc-snackbar--action-on-bottom .mdc-snackbar__action-wrapper{margin-left:auto;margin-right:0;flex-direction:column;justify-content:flex-start;margin-top:-12px;margin-bottom:8px}[dir="rtl"] .mdc-snackbar--action-on-bottom .mdc-snackbar__action-wrapper,.mdc-snackbar--action-on-bottom .mdc-snackbar__action-wrapper[dir="rtl"]{margin-left:0;margin-right:auto}.mdc-snackbar--multiline .mdc-snackbar__text{height:80px}.mdc-snackbar__action-button{font-family:Roboto,sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;font-size:.875rem;line-height:2.25rem;font-weight:500;letter-spacing:.08929em;text-decoration:none;text-transform:uppercase;color:#018786;color:var(--mdc-theme-secondary, #018786);padding:0;transition:opacity .3s 0ms cubic-bezier(0.4, 0, 1, 1);border:none;outline:none;background-color:transparent;opacity:0;user-select:none;-webkit-appearance:none;visibility:hidden}.mdc-snackbar__action-button::-moz-focus-inner{border:0}.mdc-snackbar__action-button:hover{cursor:pointer}.mdc-snackbar__action-button:not([aria-hidden]){visibility:inherit}.mdc-snackbar--active .mdc-snackbar__text,.mdc-snackbar--active .mdc-snackbar__action-button:not([aria-hidden]){transition:opacity .3s 0ms cubic-bezier(0.4, 0, 1, 1);opacity:1}.mdc-snackbar--multiline.mdc-snackbar--action-on-bottom .mdc-snackbar__text{margin:0}
</style>`;
