/**
@license
Copyright 2018 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import {html} from '@polymer/lit-element/lit-element.js';

export const style = html`<style>@keyframes mdc-ripple-fg-radius-in{from{animation-timing-function:cubic-bezier(0.4, 0, 0.2, 1);transform:translate(var(--mdc-ripple-fg-translate-start, 0)) scale(1)}to{transform:translate(var(--mdc-ripple-fg-translate-end, 0)) scale(var(--mdc-ripple-fg-scale, 1))}}@keyframes mdc-ripple-fg-opacity-in{from{animation-timing-function:linear;opacity:0}to{opacity:var(--mdc-ripple-fg-opacity, 0)}}@keyframes mdc-ripple-fg-opacity-out{from{animation-timing-function:linear;opacity:var(--mdc-ripple-fg-opacity, 0)}to{opacity:0}}.mdc-ripple-surface--test-edge-var-bug{--mdc-ripple-surface-test-edge-var: 1px solid #000;visibility:hidden}.mdc-ripple-surface--test-edge-var-bug::before{border:var(--mdc-ripple-surface-test-edge-var)}.mdc-tab{font-family:Roboto,sans-serif;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;font-size:.875rem;line-height:2.25rem;font-weight:500;letter-spacing:.08929em;text-decoration:none;text-transform:uppercase;color:rgba(0,0,0,0.54);color:var(--mdc-theme-text-secondary-on-background, rgba(0,0,0,0.54));--mdc-ripple-fg-size: 0;--mdc-ripple-left: 0;--mdc-ripple-top: 0;--mdc-ripple-fg-scale: 1;--mdc-ripple-fg-translate-end: 0;--mdc-ripple-fg-translate-start: 0;-webkit-tap-highlight-color:transparent;will-change:transform, opacity;display:table-cell;position:relative;box-sizing:border-box;min-width:160px;min-height:48px;padding:0 24px;text-align:center;text-decoration:none;white-space:nowrap;cursor:pointer;overflow:hidden;vertical-align:middle}.mdc-tab .mdc-tab__icon{color:rgba(0,0,0,0.54);color:var(--mdc-theme-text-secondary-on-background, rgba(0,0,0,0.54))}.mdc-tab::before,.mdc-tab::after{position:absolute;border-radius:50%;opacity:0;pointer-events:none;content:""}.mdc-tab::before{transition:opacity 15ms linear;z-index:1}.mdc-tab.mdc-ripple-upgraded::before{transform:scale(var(--mdc-ripple-fg-scale, 1))}.mdc-tab.mdc-ripple-upgraded::after{top:0;left:0;transform:scale(0);transform-origin:center center}.mdc-tab.mdc-ripple-upgraded--unbounded::after{top:var(--mdc-ripple-top, 0);left:var(--mdc-ripple-left, 0)}.mdc-tab.mdc-ripple-upgraded--foreground-activation::after{animation:225ms mdc-ripple-fg-radius-in forwards,75ms mdc-ripple-fg-opacity-in forwards}.mdc-tab.mdc-ripple-upgraded--foreground-deactivation::after{animation:150ms mdc-ripple-fg-opacity-out;transform:translate(var(--mdc-ripple-fg-translate-end, 0)) scale(var(--mdc-ripple-fg-scale, 1))}.mdc-tab::before,.mdc-tab::after{background-color:#000}.mdc-tab:hover::before{opacity:.04}.mdc-tab:not(.mdc-ripple-upgraded):focus::before,.mdc-tab.mdc-ripple-upgraded--background-focused::before{transition-duration:75ms;opacity:.12}.mdc-tab:not(.mdc-ripple-upgraded)::after{transition:opacity 150ms linear}.mdc-tab:not(.mdc-ripple-upgraded):active::after{transition-duration:75ms;opacity:.16}.mdc-tab.mdc-ripple-upgraded{--mdc-ripple-fg-opacity: .16}.mdc-tab::before,.mdc-tab::after{top:calc(50% - 100%);left:calc(50% - 100%);width:200%;height:200%}.mdc-tab.mdc-ripple-upgraded::after{width:var(--mdc-ripple-fg-size, 100%);height:var(--mdc-ripple-fg-size, 100%)}.mdc-tab:hover{color:rgba(0,0,0,0.87);color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab:hover .mdc-tab__icon{color:rgba(0,0,0,0.87);color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab:focus{outline:none}@media screen and (max-width: 600px){.mdc-tab{min-width:72px;padding:0 12px}}.mdc-tab__icon{display:block;margin:0 auto;width:24px;height:24px}.mdc-tab-bar--icons-with-text .mdc-tab__icon{margin-top:4px}.mdc-tab__icon-text{display:block;margin:0 auto}.mdc-tab__icon+.mdc-tab__icon-text{padding-top:6px}.mdc-tab--active{color:rgba(0,0,0,0.87);color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab--active .mdc-tab__icon{color:rgba(0,0,0,0.87);color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab--active::before{bottom:0}.mdc-tab__indicator{background-color:rgba(0,0,0,0.87);background-color:var(--mdc-theme-text-primary-on-light, rgba(0,0,0,0.87));position:absolute;bottom:0;height:2px;visibility:hidden;left:2px;width:calc(100% - 4px)}.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab--active .mdc-tab__indicator,.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab:hover .mdc-tab__indicator,.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab:active .mdc-tab__indicator{visibility:visible}.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab:not(.mdc-tab--active):hover .mdc-tab__indicator{opacity:.38}.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab--active,.mdc-tab-bar:not(.mdc-tab-bar-upgraded) .mdc-tab:not(.mdc-tab--active):active .mdc-tab__indicator{opacity:.87}.mdc-tab-bar__indicator,.mdc-tab__indicator{background-color:rgba(0,0,0,0.87);background-color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab-bar{display:table;position:relative;height:48px;margin:0 auto;text-transform:uppercase}.mdc-tab-bar__indicator{background-color:rgba(0,0,0,0.87);background-color:var(--mdc-theme-text-primary-on-light, rgba(0,0,0,0.87));position:absolute;bottom:0;height:2px;visibility:hidden;left:0;width:100%;transform-origin:left top;transition:transform 240ms 0ms cubic-bezier(0, 0, 0.2, 1);will-change:transform}.mdc-tab-bar--icons-with-text{height:72px}.mdc-tab-bar-scroller{display:flex;align-items:center;box-sizing:border-box;width:100%;background-color:inherit;overflow:hidden}.mdc-tab-bar-scroller__scroll-frame{display:flex;position:relative;flex:1;justify-content:flex-start;overflow:hidden}.mdc-tab-bar-scroller__scroll-frame__tabs{transition:transform 240ms 0ms cubic-bezier(0, 0, 0.2, 1);will-change:transform}.mdc-tab-bar-scroller__indicator{color:rgba(0,0,0,0.54);color:var(--mdc-theme-text-secondary-on-background, rgba(0,0,0,0.54));display:flex;align-items:center;justify-content:center;width:48px;cursor:pointer;visibility:hidden}.mdc-tab-bar-scroller__indicator:hover{color:rgba(0,0,0,0.87);color:var(--mdc-theme-text-primary-on-background, rgba(0,0,0,0.87))}.mdc-tab-bar-scroller__indicator__inner{color:inherit;text-decoration:inherit;cursor:inherit}.mdc-tab-bar-scroller__indicator__inner:focus{outline-color:inherit}.mdc-tab-bar-scroller[dir="rtl"] .mdc-tab-bar-scroller__indicator__inner,[dir="rtl"] .mdc-tab-bar-scroller .mdc-tab-bar-scroller__indicator__inner{transform:rotate(180deg)}.mdc-tab-bar-scroller__indicator__inner:hover{color:inherit}.mdc-tab-bar-scroller__indicator--enabled{visibility:visible}.material-icons{font-family:var(--mdc-icon-font, "Material Icons");font-weight:normal;font-style:normal;font-size:var(--mdc-icon-size, 24px);line-height:1;letter-spacing:normal;text-transform:none;display:inline-block;white-space:nowrap;word-wrap:normal;direction:ltr;-webkit-font-feature-settings:'liga';-webkit-font-smoothing:antialiased}
</style>`;
