<!--docs:
title: "MDC Web on other frameworks"
navTitle: "Framework Wrappers"
layout: landing
section: docs
path: /docs/framework-wrappers/
-->

# MDC Web on other frameworks

Material Components for the web are architected to be adaptable to various major web frameworks. The following wrapper libraries are available:

  - [Material Web Components](https://github.com/material-components/material-components-web-components): MDC Web integration for Web Components (using [vanilla components](./integrating-into-frameworks.md#the-simple-approach-wrapping-mdc-web-vanilla-components))
  - [Material Components for React](https://github.com/material-components/material-components-web-react): MDC Web integration for React (using [foundations/adapters](./integrating-into-frameworks.md#the-advanced-approach-using-foundations-and-adapters)). *Please note that this project is no longer under active development.*
  - Additional third-party integrations
    - [Preact Material Components](https://github.com/prateekbh/preact-material-components)
    - [RMWC: React Material Web Components](https://github.com/jamesmfriedman/rmwc) (using [foundations/adapters](./integrating-into-frameworks.md#the-advanced-approach-using-foundations-and-adapters).)
    - [Angular MDC](https://github.com/trimox/angular-mdc-web)
    - [Blox Material](https://blox.src.zone/material): Angular Integration Library.
    - [Vue MDC Adapter](https://github.com/pgbross/vue-material-adapter): MDC Web Integration for Vue.js (using [foundations/adapters](./integrating-into-frameworks.md#the-advanced-approach-using-foundations-and-adapters).)
    - [Material Components Vue](https://github.com/matsp/material-components-vue): MDC Web Integration for Vue.js (using [vanilla components](./integrating-into-frameworks.md#the-simple-approach-wrapping-mdc-web-vanilla-components))
    - [BalmUI](https://material.balmjs.com/): Next Generation Material UI for Vue.js
    - [Ember Material Components](https://github.com/onehilltech/ember-cli-mdc): MDC Web integration for Ember (using [vanilla components](./integrating-into-frameworks.md#the-simple-approach-wrapping-mdc-web-vanilla-components))
    - [MatBlazor](https://github.com/SamProf/MatBlazor): Material Design components for Blazor
    - [Svelte Material UI](https://github.com/hperrin/svelte-material-ui): A library of Svelte 3 Material UI components.

  - More coming soon! Feel free to submit a pull request adding your library to this list, so long as you meet our [criteria](integrating-into-frameworks.md).
