# Open Source Community

In addition to working within the Material Design team, MDC Web communicates
with its external developers. External developers are the people who depend on
MDC Web code in their web applications. Specifically, they depend on our Node
modules.

![MDC Web External Feedback Loops](feedback.jpg?raw=true)

## External Developers

External developers have two critical ways of communicating with us

* [Filing GitHub issues](https://github.com/material-components/material-components-web/issues)
* Talking on Discord (See Discord section)

We have several ways of pushing content to external developers:

* Node Modules: the code in an installable form (See Releases section)
* GitHub Documentation: Explain how to use the Node modules
* GitHub Milestones: Detail our priorities for fixing bugs and completing feature requests
* Catalog: Visualize our components (See Releases section)

GitHub is where we do most of our communication with external developers. The
GitHub documentation is critical to our external developers understanding how
to use our Node modules. GitHub is also where they can file bugs and feature
requests. External developers see these issues prioritized in our release milestones
on GitHub.

## Release Cop

MDC Web team members are expected to triage GitHub issues and release code to
NPM. Triage and release are only performed when the team member is
“release cop”, which is determined by a rotation calendar. Each team member is
release cop for two weeks.

* [Triage Process](triage.md)
* [Release Process](release-process.md)
* Idle in Discord

## External Contributors

There is a special kind of external developer: the kind that also contributes
code back to our repository. These external contributors fix GitHub issue we
mark as “help wanted” in our triage process. This prevents the GitHub issue from
becoming a bug in our icebox or milestones, which saves core contributors from
having to fix the bug.

> Our GitHub code must be readable by external contributors. And we must review
> code from external contributors.

## Releases

[NPM](https://www.npmjs.com/org/material)

Our code is released as Node modules. External developers install these modules.

[Catalog Server](https://material-components.github.io/material-components-web-catalog/)

Our catalog server is where we visually display the components to our external
developers.

## Discord

[Discord channel](https://discordapp.com/invite/material-components)

Our Discord channel is where we can talk with external developers in realtime.
