/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

const cssClasses = {
  LIST_ITEM_ACTIVATED_CLASS: 'mdc-list-item--activated',
  LIST_ITEM_CLASS: 'mdc-list-item',
  LIST_ITEM_DISABLED_CLASS: 'mdc-list-item--disabled',
  LIST_ITEM_SELECTED_CLASS: 'mdc-list-item--selected',
  LIST_ITEM_TEXT_CLASS: 'mdc-list-item__text',
  LIST_ITEM_PRIMARY_TEXT_CLASS: 'mdc-list-item__primary-text',
  ROOT: 'mdc-list',
};

const evolutionClassNameMap = {
  [`${cssClasses.LIST_ITEM_ACTIVATED_CLASS}`]: 'mdc-list-item--activated',
  [`${cssClasses.LIST_ITEM_CLASS}`]: 'mdc-list-item',
  [`${cssClasses.LIST_ITEM_DISABLED_CLASS}`]: 'mdc-list-item--disabled',
  [`${cssClasses.LIST_ITEM_SELECTED_CLASS}`]: 'mdc-list-item--selected',
  [`${cssClasses.LIST_ITEM_PRIMARY_TEXT_CLASS}`]: 'mdc-list-item__primary-text',
  [`${cssClasses.ROOT}`]: 'mdc-list',
};

const deprecatedClassNameMap = {
  [`${cssClasses.LIST_ITEM_ACTIVATED_CLASS}`]:
      'mdc-deprecated-list-item--activated',
  [`${cssClasses.LIST_ITEM_CLASS}`]: 'mdc-deprecated-list-item',
  [`${cssClasses.LIST_ITEM_DISABLED_CLASS}`]:
      'mdc-deprecated-list-item--disabled',
  [`${cssClasses.LIST_ITEM_SELECTED_CLASS}`]:
      'mdc-deprecated-list-item--selected',
  [`${cssClasses.LIST_ITEM_TEXT_CLASS}`]: 'mdc-deprecated-list-item__text',
  [`${cssClasses.LIST_ITEM_PRIMARY_TEXT_CLASS}`]:
      'mdc-deprecated-list-item__primary-text',
  [`${cssClasses.ROOT}`]: 'mdc-deprecated-list',
};

const strings = {
  ACTION_EVENT: 'MDCList:action',
  ARIA_CHECKED: 'aria-checked',
  ARIA_CHECKED_CHECKBOX_SELECTOR: '[role="checkbox"][aria-checked="true"]',
  ARIA_CHECKED_RADIO_SELECTOR: '[role="radio"][aria-checked="true"]',
  ARIA_CURRENT: 'aria-current',
  ARIA_DISABLED: 'aria-disabled',
  ARIA_ORIENTATION: 'aria-orientation',
  ARIA_ORIENTATION_HORIZONTAL: 'horizontal',
  ARIA_ROLE_CHECKBOX_SELECTOR: '[role="checkbox"]',
  ARIA_SELECTED: 'aria-selected',
  ARIA_INTERACTIVE_ROLES_SELECTOR: '[role="listbox"], [role="menu"]',
  ARIA_MULTI_SELECTABLE_SELECTOR: '[aria-multiselectable="true"]',
  CHECKBOX_RADIO_SELECTOR: 'input[type="checkbox"], input[type="radio"]',
  CHECKBOX_SELECTOR: 'input[type="checkbox"]',
  CHILD_ELEMENTS_TO_TOGGLE_TABINDEX: `
    .${cssClasses.LIST_ITEM_CLASS} button:not(:disabled),
    .${cssClasses.LIST_ITEM_CLASS} a,
    .${
      deprecatedClassNameMap[cssClasses.LIST_ITEM_CLASS]} button:not(:disabled),
    .${deprecatedClassNameMap[cssClasses.LIST_ITEM_CLASS]} a
  `,
  DEPRECATED_SELECTOR: '.mdc-deprecated-list',
  FOCUSABLE_CHILD_ELEMENTS: `
    .${cssClasses.LIST_ITEM_CLASS} button:not(:disabled),
    .${cssClasses.LIST_ITEM_CLASS} a,
    .${cssClasses.LIST_ITEM_CLASS} input[type="radio"]:not(:disabled),
    .${cssClasses.LIST_ITEM_CLASS} input[type="checkbox"]:not(:disabled),
    .${
      deprecatedClassNameMap[cssClasses.LIST_ITEM_CLASS]} button:not(:disabled),
    .${deprecatedClassNameMap[cssClasses.LIST_ITEM_CLASS]} a,
    .${
      deprecatedClassNameMap
          [cssClasses.LIST_ITEM_CLASS]} input[type="radio"]:not(:disabled),
    .${
      deprecatedClassNameMap
          [cssClasses.LIST_ITEM_CLASS]} input[type="checkbox"]:not(:disabled)
  `,
  RADIO_SELECTOR: 'input[type="radio"]',
  SELECTED_ITEM_SELECTOR: '[aria-selected="true"], [aria-current="true"]',
};

const numbers = {
  UNSET_INDEX: -1,
  TYPEAHEAD_BUFFER_CLEAR_TIMEOUT_MS: 300
};

const evolutionAttribute = 'evolution';

export {
  strings,
  cssClasses,
  numbers,
  deprecatedClassNameMap,
  evolutionAttribute,
  evolutionClassNameMap
};
