> **Warning**
>
> ## THIS IS AN AUTOGENERATED FILE. DO NOT EDIT.
>
> ## Please edit the corresponding file in [/packages/mermaid/src/docs/ecosystem/integrations.md](../../packages/mermaid/src/docs/ecosystem/integrations.md).

# Integrations

The following list is a compilation of different integrations and plugins that allow the rendering of mermaid definitions within other applications.

They also serve as proof of concept, for the variety of things that can be built with mermaid.

## Productivity

- [GitHub](https://github.com) (**Native support**)
  - [Using code blocks](https://github.blog/2022-02-14-include-diagrams-markdown-files-mermaid/) (**Native support**)
  - [GitHub action: Compile mermaid to image](https://github.com/neenjaw/compile-mermaid-markdown-action)
  - [svg-generator](https://github.com/SimonKenyonShepard/mermaidjs-github-svg-generator)
- [GitLab](https://docs.gitlab.com/ee/user/markdown.html#diagrams-and-flowcharts) (**Native support**)
- [Gitea](https://gitea.io) (**Native support**)
- [Azure Devops](https://docs.microsoft.com/en-us/azure/devops/project/wiki/wiki-markdown-guidance?view=azure-devops#add-mermaid-diagrams-to-a-wiki-page) (**Native support**)
- [Tuleap](https://docs.tuleap.org/user-guide/writing-in-tuleap.html#graphs) (**Native support**)
- [Mermaid Flow Visual Editor](https://www.mermaidflow.app) (**Native support**)
- [Deepdwn](https://billiam.itch.io/deepdwn) (**Native support**)
- [Joplin](https://joplinapp.org) (**Native support**)
- [Swimm](https://swimm.io) (**Native support**)
- [Notion](https://notion.so) (**Native support**)
- [Observable](https://observablehq.com/@observablehq/mermaid) (**Native support**)
- [Obsidian](https://help.obsidian.md/How+to/Format+your+notes#Diagram) (**Native support**)
- [GitBook](https://gitbook.com)
  - [Mermaid Plugin](https://github.com/JozoVilcek/gitbook-plugin-mermaid)
  - [Markdown with Mermaid CLI](https://github.com/miao1007/gitbook-plugin-mermaid-cli)
  - [Mermaid plugin for GitBook](https://github.com/wwformat/gitbook-plugin-mermaid-pdf)
- [LiveBook](https://livebook.dev) (**Native support**)
- [Atlassian Products](https://www.atlassian.com)
  - [Mermaid Plugin for Confluence](https://marketplace.atlassian.com/apps/1214124/mermaid-plugin-for-confluence?hosting=server&tab=overview)
  - [CloudScript.io Addon](https://marketplace.atlassian.com/apps/1219878/cloudscript-io-mermaid-addon?hosting=cloud&tab=overview)
  - [Auto convert diagrams in Jira](https://github.com/coddingtonbear/jirafs-mermaid)
- [Redmine](https://redmine.org)
  - [Mermaid Macro](https://www.redmine.org/plugins/redmine_mermaid_macro)
  - [redmine-mermaid](https://github.com/styz/redmine_mermaid)
  - [markdown-for-mermaid-plugin](https://github.com/jamieh-mongolian/markdown-for-mermaid-plugin)
- [JetBrains IDE eg Pycharm](https://www.jetbrains.com/go/guide/tips/mermaid-js-support-in-markdown/)
- [mermerd](https://github.com/KarnerTh/mermerd)
- Visual Studio Code [Polyglot Interactive Notebooks](https://github.com/dotnet/interactive#net-interactive)

## CRM/ERP/Similar

- [coreBOS](https://blog.corebos.org/blog/december2019)

## Blogs

- [Wordpress](https://wordpress.org)
  - [WordPress Markdown Editor](https://wordpress.org/plugins/wp-githuber-md)
  - [WP-ReliableMD](https://wordpress.org/plugins/wp-reliablemd/)
- [Hexo](https://hexo.io)
  - [hexo-filter-mermaid-diagrams](https://github.com/webappdevelp/hexo-filter-mermaid-diagrams)
  - [hexo-tag-mermaid](https://github.com/JameChou/hexo-tag-mermaid)
  - [hexo-mermaid-diagrams](https://github.com/mslxl/hexo-mermaid-diagrams)

## CMS

- [VitePress](https://vitepress.vuejs.org/)
  - [Plugin for Mermaid.js](https://emersonbottero.github.io/vitepress-plugin-mermaid/)
- [VuePress](https://vuepress.vuejs.org/)
  - [Plugin for Mermaid.js](https://github.com/eFrane/vuepress-plugin-mermaidjs)
- [Grav CMS](https://getgrav.org/)
  - [Mermaid Diagrams](https://github.com/DanielFlaum/grav-plugin-mermaid-diagrams)
  - [Gitlab Markdown Adapter](https://github.com/Goutte/grav-plugin-gitlab-markdown-adapter)

## Communication

- [Discourse](https://discourse.org)
  - [Mermaid Plugin](https://github.com/pnewell/discourse-mermaid), [And](https://github.com/unfoldingWord-dev/discourse-mermaid)
- [Mattermost](https://mattermost.com/)
  - [Mermaid Plugin](https://github.com/SpikeTings/Mermaid)
- [phpBB](https://phpbb.com)
  - [phpbb-ext-mermaid](https://github.com/AlfredoRamos/phpbb-ext-mermaid)
- [NodeBB](https://nodebb.org)
  - [Mermaid Plugin](https://www.npmjs.com/package/nodebb-plugin-mermaid)

## Wikis

- [MediaWiki](https://www.mediawiki.org)
  - [Mermaid Extension](https://www.mediawiki.org/wiki/Extension:Mermaid)
  - [Flex Diagrams Extension](https://www.mediawiki.org/wiki/Extension:Flex_Diagrams)
- [Semantic Media Wiki](https://semantic-mediawiki.org)
  - [Mermaid Plugin](https://github.com/SemanticMediaWiki/Mermaid)
- [FosWiki](https://foswiki.org)
  - [Mermaid Plugin](https://foswiki.org/Extensions/MermaidPlugin)
- [DokuWiki](https://dokuwiki.org)
  - [Mermaid Plugin](https://www.dokuwiki.org/plugin:mermaid)
  - [ComboStrap](https://combostrap.com/mermaid)
- [TiddlyWiki](https://tiddlywiki.com/)
  - [mermaid-tw5: full js library](https://github.com/efurlanm/mermaid-tw5)
  - [tw5-mermaid: wrapper for Mermaid Live](https://github.com/jasonmhoule/tw5-mermaid)

## Editor Plugins

- [VS Code](https://code.visualstudio.com/)
  - [Markdown Preview Mermaid Support](https://marketplace.visualstudio.com/items?itemName=bierner.markdown-mermaid)
  - [Mermaid Preview](https://marketplace.visualstudio.com/items?itemName=vstirbu.vscode-mermaid-preview)
  - [Markdown Preview Enhanced](https://marketplace.visualstudio.com/items?itemName=shd101wyy.markdown-preview-enhanced)
  - [Mermaid Markdown Syntax Highlighting](https://marketplace.visualstudio.com/items?itemName=bpruitt-goddard.mermaid-markdown-syntax-highlighting)
  - [Mermaid Editor](https://marketplace.visualstudio.com/items?itemName=tomoyukim.vscode-mermaid-editor)
  - [Mermaid Export](https://marketplace.visualstudio.com/items?itemName=Gruntfuggly.mermaid-export)
  - [Markdown PDF](https://marketplace.visualstudio.com/items?itemName=yzane.markdown-pdf)
  - [Preview](https://marketplace.visualstudio.com/items?itemName=searKing.preview-vscode)
  - [Preview Sequence Diagrams](https://marketplace.visualstudio.com/items?itemName=arichika.previewseqdiag-vscode)
- [Markdown-It](https://github.com/markdown-it/markdown-it)
  - [Textual UML Parser](https://github.com/manastalukdar/markdown-it-textual-uml)
  - [Mermaid Plugin](https://github.com/tylingsoft/markdown-it-mermaid)
  - [md-it-mermaid](https://github.com/iamcco/md-it-mermaid)
  - [markdown-it-mermaid-fence-new](https://github.com/Revomatico/markdown-it-mermaid-fence-new)
  - [markdown-it-mermaid-less](https://github.com/searKing/markdown-it-mermaid-less)
- Atom _(Atom has been [archived.](https://github.blog/2022-06-08-sunsetting-atom/))_
  - [Markdown Preview Enhanced](https://github.com/shd101wyy/markdown-preview-enhanced)
  - [Atom Mermaid](https://github.com/y-takey/atom-mermaid)
  - [Language Mermaid Syntax Highlighter](https://github.com/ytisf/language-mermaid)
- [Sublime Text 3](https://sublimetext.com)
  - [Mermaid Package](https://packagecontrol.io/packages/Mermaid)
- [Astah](https://astah.net)
  - [Export to Mermaid](https://github.com/Avens666/Astah_Jude_UML_export_to_Markdown-mermaid-Plantuml-)
- [Light Table](http://lighttable.com/)
  - [Mermaid Plugin](https://github.com/cldwalker/Mermaid)
- [Draw.io](https://draw.io) - [Plugin](https://github.com/nopeslide/drawio_mermaid_plugin)
- [Inkdrop](https://www.inkdrop.app) - [Plugin](https://github.com/inkdropapp/inkdrop-mermaid)
- [Vim](https://www.vim.org)
  - [Official Vim Syntax and ftplugin](https://github.com/craigmac/vim-mermaid)
  - [Vim Diagram Syntax](https://github.com/zhaozg/vim-diagram)
- [GNU Emacs](https://www.gnu.org/software/emacs/)
  - [Major mode for .mmd files](https://github.com/abrochard/mermaid-mode)
  - [Org-Mode integration](https://github.com/arnm/ob-mermaid)
- [Brackets](https://brackets.io/)
  - [Mermaid Preview](https://github.com/AlanHohn/mermaid-preview)
- [Iodide](https://github.com/iodide-project/iodide)
  - [iodide-mermaid-plugin](https://github.com/iodide-project/iodide-mermaid-plugin)
- [Google docs](https://docs.google.com/)
  - [Mermaid plugin for google docs](https://workspace.google.com/marketplace/app/mermaid/636321283856)
- [Podlite](https://github.com/zag/podlite-desktop)
  - [Named block =Diagram](https://github.com/zag/podlite/tree/main/packages/podlite-diagrams)
- [GNU Nano](https://www.nano-editor.org/)
  - [Nano Mermaid](https://github.com/Yash-Singh1/nano-mermaid)

## Document Generation

- [Sphinx](https://www.sphinx-doc.org/en/master/)
  - [sphinxcontrib-mermaid](https://github.com/mgaitan/sphinxcontrib-mermaid)
- [remark.js](https://remark.js.org/)
  - [remark-mermaid](https://github.com/temando/remark-mermaid)
- [jSDoc](https://jsdoc.app/)
  - [jsdoc-mermaid](https://github.com/Jellyvision/jsdoc-mermaid)
- [MkDocs](https://www.mkdocs.org)
  - [mkdocs-mermaid2-plugin](https://github.com/fralau/mkdocs-mermaid2-plugin)
  - [mkdocs-material](https://github.com/squidfunk/mkdocs-material), check the [docs](https://squidfunk.github.io/mkdocs-material/reference/diagrams/)
- [Type Doc](https://typedoc.org/)
  - [typedoc-plugin-mermaid](https://www.npmjs.com/package/typedoc-plugin-mermaid)
- [Docsy Hugo Theme](https://www.docsy.dev/docs/adding-content/lookandfeel/#diagrams-with-mermaid) (Native support in theme)
- [Codedoc](https://codedoc.cc/)
  - [codedoc-mermaid-plugin](https://www.npmjs.com/package/codedoc-mermaid-plugin)
- [mdbook](https://rust-lang.github.io/mdBook/index.html)
  - [mdbook-mermaid](https://github.com/badboy/mdbook-mermaid)

## Browser Extensions

| Name                     | Chrome Web Store                                                                                             | Firefox Add-ons                                                                | Opera                                                                          | Edge                                                                                                                         | Source/Repository                                                                                    |
| ------------------------ | ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------ | ------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------- |
| GitHub + Mermaid         | -                                                                                                            | [🦊🔗](https://addons.mozilla.org/firefox/addon/github-mermaid/)               | -                                                                              | -                                                                                                                            | [🐙🔗](https://github.com/BackMarket/github-mermaid-extension)                                       |
| Asciidoctor Live Preview | [🎡🔗](https://chrome.google.com/webstore/detail/asciidoctorjs-live-previe/iaalpfgpbocpdfblpnhhgllgbdbchmia) | -                                                                              | -                                                                              | [🌀🔗](https://microsoftedge.microsoft.com/addons/detail/asciidoctorjs-live-previ/pefkelkanablhjdekgdahplkccnbdggd?hl=en-US) | -                                                                                                    |
| Diagram Tab              | -                                                                                                            | -                                                                              | -                                                                              | -                                                                                                                            | [🐙🔗](https://github.com/khafast/diagramtab)                                                        |
| Markdown Diagrams        | [🎡🔗](https://chrome.google.com/webstore/detail/markdown-diagrams/pmoglnmodacnbbofbgcagndelmgaclel/)        | [🦊🔗](https://addons.mozilla.org/en-US/firefox/addon/markdown-diagrams/)      | [🔴🔗](https://addons.opera.com/en/extensions/details/markdown-diagrams/)      | [🌀🔗](https://microsoftedge.microsoft.com/addons/detail/markdown-diagrams/hceenoomhhdkjjijnmlclkpenkapfihe)                 | [🐙🔗](https://github.com/marcozaccari/markdown-diagrams-browser-extension/tree/master/doc/examples) |
| Markdown Viewer          | -                                                                                                            | [🦊🔗](https://addons.mozilla.org/en-US/firefox/addon/markdown-viewer-chrome/) | -                                                                              | -                                                                                                                            | [🐙🔗](https://github.com/simov/markdown-viewer)                                                     |
| Extensions for Mermaid   | -                                                                                                            | [🦊🔗](https://addons.mozilla.org/en-US/firefox/addon/markdown-viewer-chrome/) | [🔴🔗](https://addons.opera.com/en/extensions/details/extensions-for-mermaid/) | -                                                                                                                            | [🐙🔗](https://github.com/Stefan-S/mermaid-extension)                                                |
| Chrome Diagrammer        | [🎡🔗](https://chrome.google.com/webstore/detail/chrome-diagrammer/bkpbgjmkomfoakfklcjeoegkklgjnnpk)         | -                                                                              | -                                                                              | -                                                                                                                            | -                                                                                                    |
| Mermaid Diagrams         | [🎡🔗](https://chrome.google.com/webstore/detail/mermaid-diagrams/phfcghedmopjadpojhmmaffjmfiakfil)          | -                                                                              | -                                                                              | -                                                                                                                            | -                                                                                                    |
| Monkeys                  | [🎡🔗](https://chrome.google.com/webstore/detail/monkeys-mermaid-for-githu/cplfdpoajbclbgphaphphcldamfkjlgi) | -                                                                              | -                                                                              | -                                                                                                                            | -                                                                                                    |
| Mermaid Previewer        | [🎡🔗](https://chrome.google.com/webstore/detail/mermaid-previewer/oidjnlhbegipkcklbdfnbkikplpghfdl)         | -                                                                              | -                                                                              | -                                                                                                                            | -                                                                                                    |

## Other

- [Jekyll](https://jekyllrb.com/)
  - [jekyll-mermaid](https://rubygems.org/gems/jekyll-mermaid)
  - [jekyll-mermaid-diagrams](https://github.com/fuzhibo/jekyll-mermaid-diagrams)
- [Reveal.js](https://github.com/hakimel/reveal.js)
  - [reveal.js-mermaid-plugin](https://github.com/ludwick/reveal.js-mermaid-plugin)
- [Bisheng](https://www.npmjs.com/package/bisheng)
  - [bisheng-plugin-mermaid](https://github.com/yct21/bisheng-plugin-mermaid)
- [Reveal CK](https://github.com/jedcn/reveal-ck)
  - [reveal-ck-mermaid-plugin](https://github.com/tmtm/reveal-ck-mermaid-plugin)
- [mermaid-server: Generate diagrams using a HTTP request](https://github.com/TomWright/mermaid-server)
- [ExDoc](https://github.com/elixir-lang/ex_doc)
  - [Rendering Mermaid graphs](https://github.com/elixir-lang/ex_doc#rendering-mermaid-graphs)
- [NiceGUI: Let any browser be the frontend of your Python code](https://nicegui.io)
  - [ui.mermaid(...)](https://nicegui.io/reference#mermaid_diagrams)
  - [ui.markdown(..., extras=\['mermaid'\])](https://nicegui.io/reference#markdown_element)
