---
outline: 'deep' # shows all h3 headings in outline in Vitepress
---

# Integrations - create

## Recommendations

Below are recommendations for creating plugins and integrations with Mermaid.

### File Extension

Applications that support Mermaid files [SHOULD](https://datatracker.ietf.org/doc/html/rfc2119#section-3) use `.mermaid` or `.mmd` file extensions.

### MIME Type

The recommended [MIME type](https://www.iana.org/assignments/media-types/media-types.xhtml) for Mermaid media is `text/vnd.mermaid`.

Currently pending [IANA](https://www.iana.org/) recognition.

## Showcase

### Mermaid Slack workspace

We would love to see what you create with Mermaid. Please share your creations with us in our [Slack](https://join.slack.com/t/mermaid-talk/shared_invite/zt-22p2r8p9y-qiyP1H38GjFQ6S6jbBkOxQ) workspace [#community-showcase](https://mermaid-talk.slack.com/archives/C05NK37LT40) channel.

### Add to Mermaid Ecosystem

If you have a plugin or integration that you'd like to add to our [Community integrations](/ecosystem/integrations-community) list, please [open a pull request](https://github.com/mermaid-js/mermaid).
