## Usage

```js
var brackets = require('{%= name %}');

brackets('[![:lower:]]');
//=> '[^a-z]'
```

## .isMatch

Return true if the given string matches the bracket expression:

```js
brackets.isMatch('A', '[![:lower:]]');
//=> true

brackets.isMatch('a', '[![:lower:]]');
//=> false
```

## .makeRe

Make a regular expression from a bracket expression:

```js
brackets.makeRe('[![:lower:]]');
//=> /[^a-z]/
```

The following named POSIX bracket expressions are supported:

- `[:alnum:]`: Alphanumeric characters (`a-zA-Z0-9]`)
- `[:alpha:]`: Alphabetic characters (`a-zA-Z]`)
- `[:blank:]`: Space and tab (`[ t]`)
- `[:digit:]`: Digits (`[0-9]`)
- `[:lower:]`: Lowercase letters (`[a-z]`)
- `[:punct:]`: Punctuation and symbols. (`[!"#$%&'()*+, -./:;<=>?@ [\]^_``{|}~]`)
- `[:upper:]`: Uppercase letters (`[A-Z]`)
- `[:word:]`: Word characters (letters, numbers and underscores) (`[A-Za-z0-9_]`)
- `[:xdigit:]`: Hexadecimal digits (`[A-Fa-f0-9]`)

Collating sequences are not supported.
