Documentation is generated by [JSDoc](https://github.com/jsdoc3/jsdoc) and [jsdoc-to-markdown](https://github.com/jsdoc2md/jsdoc-to-markdown).

***

## Functions

<dl>
<dt><a href="#throwException">throwException(ex)</a></dt>
<dd><p>Returns a function that throws the passed exception, for use as argument for setTimeout</p>
</dd>
<dt><a href="#publish">publish(message, data)</a> ⇒ <code>Boolean</code></dt>
<dd><p>Publishes the message, passing the data to it&#39;s subscribers</p>
</dd>
<dt><a href="#publishSync">publishSync(message, data)</a> ⇒ <code>Boolean</code></dt>
<dd><p>Publishes the message synchronously, passing the data to it&#39;s subscribers</p>
</dd>
<dt><a href="#subscribe">subscribe(message, func)</a> ⇒ <code>String</code></dt>
<dd><p>Subscribes the passed function to the passed message. Every returned token is unique and should be stored if you need to unsubscribe</p>
</dd>
<dt><a href="#subscribeOnce">subscribeOnce(message, func)</a> ⇒ <code>PubSub</code></dt>
<dd><p>Subscribes the passed function to the passed message once</p>
</dd>
<dt><a href="#clearAllSubscriptions">clearAllSubscriptions()</a></dt>
<dd><p>Clears all subscriptions</p>
</dd>
<dt><a href="#clearAllSubscriptions">clearAllSubscriptions()</a> ⇒ <code>int</code></dt>
<dd><p>Clear subscriptions by the topic</p>
</dd>
<dt><a href="#countSubscriptions">countSubscriptions()</a> ⇒ <code>Array</code></dt>
<dd><p>Count subscriptions by the topic</p>
</dd>
<dt><a href="#getSubscriptions">getSubscriptions()</a></dt>
<dd><p>Gets subscriptions by the topic</p>
</dd>
<dt><a href="#subscribeOnce">subscribeOnce(value)</a></dt>
<dd><p>Removes subscriptions</p>
<ul>
<li><p>When passed a token, removes a specific subscription.</p>
</li>
<li><p>When passed a function, removes all subscriptions for that function</p>
</li>
<li><p>When passed a topic, removes all subscriptions for that topic (hierarchy)</p>
</li>
</ul>
</dd>
</dl>

<a name="throwException"></a>

## throwException(ex)
Returns a function that throws the passed exception, for use as argument for setTimeout

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| ex | <code>Object</code> | An Error object |

<a name="publish"></a>

## publish(message, data) ⇒ <code>Boolean</code>
Publishes the message, passing the data to it's subscribers

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| message | <code>String</code> | The message to publish |
| data |  | The data to pass to subscribers |

<a name="publishSync"></a>

## publishSync(message, data) ⇒ <code>Boolean</code>
Publishes the message synchronously, passing the data to it's subscribers

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| message | <code>String</code> | The message to publish |
| data |  | The data to pass to subscribers |

<a name="subscribe"></a>

## subscribe(message, func) ⇒ <code>String</code>
Subscribes the passed function to the passed message. Every returned token is unique and should be stored if you need to unsubscribe

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| message | <code>String</code> | The message to subscribe to |
| func | <code>function</code> | The function to call when a new message is published |

<a name="subscribeOnce"></a>

## subscribeOnce(message, func) ⇒ <code>PubSub</code>
Subscribes the passed function to the passed message once

**Kind**: global function  

| Param | Type | Description |
| --- | --- | --- |
| message | <code>String</code> | The message to subscribe to |
| func | <code>function</code> | The function to call when a new message is published |

<a name="clearAllSubscriptions"></a>

## clearAllSubscriptions()
Clears all subscriptions

**Kind**: global function  
**Access**: public  
<a name="clearAllSubscriptions"></a>

## clearAllSubscriptions() ⇒ <code>int</code>
Clear subscriptions by the topic

**Kind**: global function  
**Access**: public  
<a name="countSubscriptions"></a>

## countSubscriptions() ⇒ <code>Array</code>
Count subscriptions by the topic

**Kind**: global function  
**Access**: public  
<a name="getSubscriptions"></a>

## getSubscriptions()
Gets subscriptions by the topic

**Kind**: global function  
**Access**: public  
<a name="subscribeOnce"></a>

## subscribeOnce(value)
Removes subscriptions

- When passed a token, removes a specific subscription.

- When passed a function, removes all subscriptions for that function

- When passed a topic, removes all subscriptions for that topic (hierarchy)

**Kind**: global function  
**Access**: public  

| Param | Type | Description |
| --- | --- | --- |
| value | <code>String</code> \| <code>function</code> | A token, function or topic to unsubscribe from |

**Example**  
```js
// Unsubscribing with a token
var token = PubSub.subscribe('mytopic', myFunc);
PubSub.unsubscribe(token);
```
**Example**  
```js
// Unsubscribing with a function
PubSub.unsubscribe(myFunc);
```
**Example**  
```js
// Unsubscribing from a topic
PubSub.unsubscribe('mytopic');
```

 * * *

&copy; 2018 [Morgan Roderick](https://roderick.dk), [http://roderick.dk/](https://roderick.dk) <[morgan@roderick.dk](mailto:morgan@roderick.dk)>
