/*!
 * tui-chart
 * @fileoverview tui-chart
 * @author NHN. FE Development Lab <dl_javascript@nhn.com>
 * @version 3.10.0
 * @license MIT
 * @link https://github.com/nhn/tui.chart
 * bundle created at "Mon Feb 03 2020 11:09:18 GMT+0900 (Korean Standard Time)"
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("raphael"), require("tui-code-snippet"));
	else if(typeof define === 'function' && define.amd)
		define(["raphael", "tui-code-snippet"], factory);
	else if(typeof exports === 'object')
		exports["chart"] = factory(require("raphael"), require("tui-code-snippet"));
	else
		root["tui"] = root["tui"] || {}, root["tui"]["chart"] = factory(root["Raphael"], (root["tui"] && root["tui"]["util"]));
})(this, function(__WEBPACK_EXTERNAL_MODULE_4__, __WEBPACK_EXTERNAL_MODULE_7__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(2);


/***/ }),
/* 1 */,
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	var _pluginRaphael = __webpack_require__(3);
	
	var _chart = __webpack_require__(31);
	
	var _chart2 = _interopRequireDefault(_chart);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _colorutil = __webpack_require__(139);
	
	var _colorutil2 = _interopRequireDefault(_colorutil);
	
	__webpack_require__(148);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	_chart2['default'].registerPlugin('Raphael', _pluginRaphael.pluginRaphael, _pluginRaphael.callback);
	
	_chart2['default'].renderUtil = _renderUtil2['default'];
	_chart2['default'].arrayUtil = _arrayUtil2['default'];
	_chart2['default'].colorutil = _colorutil2['default'];
	
	/**
	 * NHN. Toast UI Chart.
	 * @namespace tui.chart
	 */
	module.exports = _chart2['default'];

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports.callback = exports.pluginRaphael = undefined;
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	var _raphaelBarChart = __webpack_require__(5);
	
	var _raphaelBarChart2 = _interopRequireDefault(_raphaelBarChart);
	
	var _raphaelBoxplotChart = __webpack_require__(12);
	
	var _raphaelBoxplotChart2 = _interopRequireDefault(_raphaelBoxplotChart);
	
	var _raphaelBulletChart = __webpack_require__(13);
	
	var _raphaelBulletChart2 = _interopRequireDefault(_raphaelBulletChart);
	
	var _raphaelLineChart = __webpack_require__(14);
	
	var _raphaelLineChart2 = _interopRequireDefault(_raphaelLineChart);
	
	var _raphaelAreaChart = __webpack_require__(17);
	
	var _raphaelAreaChart2 = _interopRequireDefault(_raphaelAreaChart);
	
	var _raphaelPieChart = __webpack_require__(19);
	
	var _raphaelPieChart2 = _interopRequireDefault(_raphaelPieChart);
	
	var _raphaelRadialLineSeries = __webpack_require__(20);
	
	var _raphaelRadialLineSeries2 = _interopRequireDefault(_raphaelRadialLineSeries);
	
	var _raphaelCoordinateTypeChart = __webpack_require__(21);
	
	var _raphaelCoordinateTypeChart2 = _interopRequireDefault(_raphaelCoordinateTypeChart);
	
	var _raphaelBoxTypeChart = __webpack_require__(22);
	
	var _raphaelBoxTypeChart2 = _interopRequireDefault(_raphaelBoxTypeChart);
	
	var _raphaelMapChart = __webpack_require__(23);
	
	var _raphaelMapChart2 = _interopRequireDefault(_raphaelMapChart);
	
	var _raphaelLegendComponent = __webpack_require__(24);
	
	var _raphaelLegendComponent2 = _interopRequireDefault(_raphaelLegendComponent);
	
	var _raphaelMapLegend = __webpack_require__(26);
	
	var _raphaelMapLegend2 = _interopRequireDefault(_raphaelMapLegend);
	
	var _raphaelCircleLegend = __webpack_require__(27);
	
	var _raphaelCircleLegend2 = _interopRequireDefault(_raphaelCircleLegend);
	
	var _raphaelTitleComponent = __webpack_require__(28);
	
	var _raphaelTitleComponent2 = _interopRequireDefault(_raphaelTitleComponent);
	
	var _raphaelAxisComponent = __webpack_require__(29);
	
	var _raphaelAxisComponent2 = _interopRequireDefault(_raphaelAxisComponent);
	
	var _raphaelRadialPlot = __webpack_require__(30);
	
	var _raphaelRadialPlot2 = _interopRequireDefault(_raphaelRadialPlot);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var pluginRaphael = exports.pluginRaphael = {
	  bar: _raphaelBarChart2['default'],
	  boxplot: _raphaelBoxplotChart2['default'],
	  bullet: _raphaelBulletChart2['default'],
	  column: _raphaelBarChart2['default'],
	  line: _raphaelLineChart2['default'],
	  area: _raphaelAreaChart2['default'],
	  pie: _raphaelPieChart2['default'],
	  bubble: _raphaelCoordinateTypeChart2['default'],
	  scatter: _raphaelCoordinateTypeChart2['default'],
	  heatmap: _raphaelBoxTypeChart2['default'],
	  treemap: _raphaelBoxTypeChart2['default'],
	  map: _raphaelMapChart2['default'],
	  radial: _raphaelRadialLineSeries2['default'],
	  legend: _raphaelLegendComponent2['default'],
	  mapLegend: _raphaelMapLegend2['default'],
	  circleLegend: _raphaelCircleLegend2['default'],
	  radialPlot: _raphaelRadialPlot2['default'],
	  title: _raphaelTitleComponent2['default'],
	  axis: _raphaelAxisComponent2['default']
	}; /**
	    * @fileoverview Raphael render plugin.
	    * @author NHN.
	    *         FE Development Lab <dl_javascript@nhn.com>
	    */
	
	var callback = exports.callback = function callback(container, dimension) {
	  var paper = (0, _raphael2['default'])(container, dimension.width, dimension.height);
	  var rect = paper.rect(0, 0, dimension.width, dimension.height);
	
	  if (paper.raphael.svg) {
	    appendGlowFilterToDefs(paper);
	    appendShadowFilterToDefs(paper);
	  }
	
	  paper.pushDownBackgroundToBottom = function () {
	    rect.toBack();
	  };
	
	  paper.changeChartBackgroundColor = function (color) {
	    rect.attr({
	      fill: color
	    });
	  };
	
	  paper.changeChartBackgroundOpacity = function (opacity) {
	    rect.attr({
	      'fill-opacity': opacity
	    });
	  };
	
	  paper.resizeBackground = function (width, height) {
	    rect.attr({
	      width: width,
	      height: height
	    });
	  };
	
	  rect.attr({
	    fill: '#fff',
	    'stroke-width': 0
	  });
	
	  return paper;
	};
	
	/**
	 * Append glow filter for series label
	 * @param {object} paper Raphael paper object
	 * @ignore
	 */
	function appendGlowFilterToDefs(paper) {
	  var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	  var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	  var feFlood = document.createElementNS('http://www.w3.org/2000/svg', 'feFlood');
	  var feComposite = document.createElementNS('http://www.w3.org/2000/svg', 'feComposite');
	  var feMorphology = document.createElementNS('http://www.w3.org/2000/svg', 'feMorphology');
	  var feMerge = document.createElementNS('http://www.w3.org/2000/svg', 'feMerge');
	  var feMergeNodeColoredBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feMergeNode');
	  var feMergeNodeSourceGraphic = document.createElementNS('http://www.w3.org/2000/svg', 'feMergeNode');
	
	  filter.id = 'glow';
	
	  feFlood.setAttribute('result', 'flood');
	  feFlood.setAttribute('flood-color', '#ffffff');
	  feFlood.setAttribute('flood-opacity', '0.5');
	
	  feComposite.setAttribute('in', 'flood');
	  feComposite.setAttribute('result', 'mask');
	  feComposite.setAttribute('in2', 'SourceGraphic');
	  feComposite.setAttribute('operator', 'in');
	
	  feMorphology.setAttribute('in', 'mask');
	  feMorphology.setAttribute('result', 'dilated');
	  feMorphology.setAttribute('operator', 'dilate');
	  feMorphology.setAttribute('radius', '2');
	
	  feGaussianBlur.setAttribute('in', 'dilated');
	  feGaussianBlur.setAttribute('result', 'blurred');
	  feGaussianBlur.setAttribute('stdDeviation', '1');
	
	  feMergeNodeColoredBlur.setAttribute('in', 'blurred');
	  feMergeNodeSourceGraphic.setAttribute('in', 'SourceGraphic');
	
	  filter.appendChild(feFlood);
	  filter.appendChild(feComposite);
	  filter.appendChild(feMorphology);
	  filter.appendChild(feGaussianBlur);
	
	  filter.appendChild(feMerge);
	
	  feMerge.appendChild(feMergeNodeColoredBlur);
	  feMerge.appendChild(feMergeNodeSourceGraphic);
	
	  paper.defs.appendChild(filter);
	}
	
	/**
	 * Append shadow filter for series label
	 * @param {object} paper Raphael paper object
	 * @ignore
	 */
	function appendShadowFilterToDefs(paper) {
	  var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	  var feOffset = document.createElementNS('http://www.w3.org/2000/svg', 'feOffset');
	  var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	  var feBlend = document.createElementNS('http://www.w3.org/2000/svg', 'feBlend');
	
	  filter.setAttributeNS(null, 'id', 'shadow');
	  filter.setAttributeNS(null, 'x', '-15%');
	  filter.setAttributeNS(null, 'y', '-15%');
	  filter.setAttributeNS(null, 'width', '180%');
	  filter.setAttributeNS(null, 'height', '180%');
	  feOffset.setAttributeNS(null, 'result', 'offOut');
	  feOffset.setAttributeNS(null, 'in', 'SourceAlpha');
	  feOffset.setAttributeNS(null, 'dx', '2');
	  feOffset.setAttributeNS(null, 'dy', '2');
	  feGaussianBlur.setAttributeNS(null, 'result', 'blurOut');
	  feGaussianBlur.setAttributeNS(null, 'in', 'offOut');
	  feGaussianBlur.setAttributeNS(null, 'stdDeviation', '2');
	  feBlend.setAttributeNS(null, 'in', 'SourceGraphic');
	  feBlend.setAttributeNS(null, 'in2', 'blurOut');
	  feBlend.setAttributeNS(null, 'mode', 'normal');
	  filter.appendChild(feOffset);
	  filter.appendChild(feGaussianBlur);
	  filter.appendChild(feBlend);
	  paper.defs.appendChild(filter);
	}

/***/ }),
/* 4 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_4__;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael bar chart renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var ANIMATION_DURATION = 700;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var BAR_HOVER_SPARE_SIZE = 8;
	var SERIES_EXTRA_VISUAL_AREA_FOR_ZERO = 2;
	var SERIES_EXTRA_VISUAL_OPACITY_FOR_ZERO = 0.4;
	
	/**
	 * @classdesc RaphaelBarChart is graph renderer for bar, column chart.
	 * @class RaphaelBarChart
	 * @private
	 */
	
	var RaphaelBarChart = function () {
	  function RaphaelBarChart() {
	    _classCallCheck(this, RaphaelBarChart);
	  }
	
	  /**
	   * Render function of bar chart
	   * @param {object} paper paper object
	   * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	   * @returns {Array.<object>} seriesSet
	   */
	  RaphaelBarChart.prototype.render = function render(paper, data) {
	    var groupBounds = data.groupBounds,
	        theme = data.theme,
	        seriesDataModel = data.seriesDataModel,
	        chartType = data.chartType,
	        options = data.options;
	
	
	    if (!groupBounds) {
	      return null;
	    }
	
	    this.paper = paper;
	
	    this.theme = theme;
	    this.seriesDataModel = seriesDataModel;
	    this.chartType = chartType;
	
	    this.paper.setStart();
	
	    this.options = options;
	    this.theme = theme;
	    this.groupBars = this._renderBars(groupBounds);
	    this.groupBorders = this._renderBarBorders(groupBounds);
	
	    this.overlay = this._renderOverlay();
	    this.groupBounds = groupBounds;
	
	    return this.paper.setFinish();
	  };
	
	  /**
	   * Render overlay.
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._renderOverlay = function _renderOverlay() {
	    var bound = {
	      width: 1,
	      height: 1,
	      left: 0,
	      top: 0
	    };
	    var attributes = {
	      'fill-opacity': 0
	    };
	    var overlay = this._renderBar(bound, '#fff', attributes);
	
	    overlay.node.setAttribute('class', 'auto-shape-rendering');
	
	    return overlay;
	  };
	
	  /**
	   * Render rect
	   * @param {{left: number, top: number, width: number, height: number}} bound bound
	   * @param {string} color series color
	   * @param {object} [attributes] - attributes
	   * @returns {object} bar rect
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._renderBar = function _renderBar(bound, color, attributes) {
	    if (bound.width < 0 || bound.height < 0) {
	      return null;
	    }
	
	    var rect = _raphaelRenderUtil2['default'].renderRect(this.paper, bound, Object.assign({
	      fill: color,
	      stroke: 'none'
	    }, attributes)).toFront();
	
	    rect.node.setAttribute('class', 'auto-shape-rendering');
	
	    return rect;
	  };
	
	  /**
	   * Render bars.
	   * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	   * @returns {Array.<Array.<object>>} bars
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._renderBars = function _renderBars(groupBounds) {
	    var _this = this;
	
	    var colors = this.theme.colors;
	    var _options = this.options,
	        colorByPoint = _options.colorByPoint,
	        animationDuration = _options.animationDuration;
	
	    var groupBars = groupBounds.map(function (bounds, groupIndex) {
	      return bounds.map(function (bound, index) {
	        if (!bound) {
	          return null;
	        }
	
	        var item = _this.seriesDataModel.getSeriesItem(groupIndex, index);
	        var color = colorByPoint ? colors[groupIndex] : colors[index];
	        var rect = _this._renderBar(animationDuration ? bound.start : bound.end, color);
	
	        return {
	          rect: rect,
	          color: color,
	          bound: bound.end,
	          item: item,
	          groupIndex: groupIndex,
	          index: index,
	          isRange: item.isRange
	        };
	      });
	    });
	
	    return groupBars;
	  };
	
	  /**
	   * Make rect points.
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @returns {{
	   *      leftTop: {left: number, top: number},
	   *      rightTop: {left: number, top: number},
	   *      rightBottom: {left: number, top: number},
	   *      leftBottom: {left: number, top: number}
	   * }} rect points
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeRectPoints = function _makeRectPoints(bound) {
	    return {
	      leftTop: {
	        left: Math.ceil(bound.left),
	        top: Math.ceil(bound.top)
	      },
	      rightTop: {
	        left: Math.ceil(bound.left + bound.width),
	        top: Math.ceil(bound.top)
	      },
	      rightBottom: {
	        left: Math.ceil(bound.left + bound.width),
	        top: Math.ceil(bound.top + bound.height)
	      },
	      leftBottom: {
	        left: Math.ceil(bound.left),
	        top: Math.ceil(bound.top + bound.height)
	      }
	    };
	  };
	
	  /**
	   * Make top line path.
	   * @param {object} points points
	   *      @param {{left: number, top: number}} points.leftTop left top
	   *      @param {{left: number, top: number}} points.rightTop right top
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {string} top line path
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeTopLinePath = function _makeTopLinePath(points, chartType, item) {
	    var value = item.value;
	
	    var linePath = null;
	
	    if (chartType === 'bar' || value >= 0 || item.isRange) {
	      var cloneLeftTop = _tuiCodeSnippet2['default'].extend({}, points.leftTop);
	      cloneLeftTop.left -= chartType === 'column' || value < 0 ? 1 : 0;
	      linePath = _raphaelRenderUtil2['default'].makeLinePath(cloneLeftTop, points.rightTop).join(' ');
	    }
	
	    return linePath;
	  };
	
	  /**
	   * Make right line path.
	   * @param {object} points points
	   *      @param {{left: number, top: number}} points.rightTop right top
	   *      @param {{left: number, top: number}} points.rightBottom right bottom
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {string} top line path
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeRightLinePath = function _makeRightLinePath(points, chartType, item) {
	    var linePath = null;
	
	    if (chartType === 'column' || item.value >= 0 || item.isRange) {
	      linePath = _raphaelRenderUtil2['default'].makeLinePath(points.rightTop, points.rightBottom).join(' ');
	    }
	
	    return linePath;
	  };
	
	  /**
	   * Make bottom line path.
	   * @param {object} points points
	   *      @param {{left: number, top: number}} points.lefBottom left bottom
	   *      @param {{left: number, top: number}} points.rightBottom right bottom
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {string} top line path
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeBottomLinePath = function _makeBottomLinePath(points, chartType, item) {
	    var linePath = null;
	
	    if (chartType === 'bar' || item.value < 0 || item.isRange) {
	      linePath = _raphaelRenderUtil2['default'].makeLinePath(points.leftBottom, points.rightBottom).join(' ');
	    }
	
	    return linePath;
	  };
	
	  /**
	   * Make left line path.
	   * @param {object} points points
	   *      @param {{left: number, top: number}} points.lefTop left top
	   *      @param {{left: number, top: number}} points.leftBottom left bottom
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {string} top line path
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeLeftLinePath = function _makeLeftLinePath(points, chartType, item) {
	    var linePath = null;
	
	    if (chartType === 'column' || item.value < 0 || item.isRange) {
	      linePath = _raphaelRenderUtil2['default'].makeLinePath(points.leftTop, points.leftBottom).join(' ');
	    }
	
	    return linePath;
	  };
	
	  /**
	   * Make border lines paths.
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {{top: string, right: string, bottom: string, left: string}} paths
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._makeBorderLinesPaths = function _makeBorderLinesPaths(bound, chartType, item) {
	    var points = this._makeRectPoints(bound);
	    var paths = {
	      top: this._makeTopLinePath(points, chartType, item),
	      right: this._makeRightLinePath(points, chartType, item),
	      bottom: this._makeBottomLinePath(points, chartType, item),
	      left: this._makeLeftLinePath(points, chartType, item)
	    };
	
	    return _tuiCodeSnippet2['default'].filter(paths, function (path) {
	      return path;
	    });
	  };
	
	  /**
	   * Render border lines;
	   * @param {{left: number, top:number, width: number, height: number}} bound bar bound
	   * @param {string} borderColor border color
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._renderBorderLines = function _renderBorderLines(bound, borderColor, chartType, item) {
	    var borderLinePaths = this._makeBorderLinesPaths(bound, chartType, item);
	    var lines = {};
	
	    Object.entries(borderLinePaths).forEach(function (_ref) {
	      var _ref2 = _slicedToArray(_ref, 2),
	          name = _ref2[0],
	          path = _ref2[1];
	
	      lines[name] = _raphaelRenderUtil2['default'].renderLine(self.paper, path, borderColor, 1);
	    });
	
	    return lines;
	  };
	
	  /**
	   * Render bar borders.
	   * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	   * @returns {Array.<Array.<object>>} borders
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._renderBarBorders = function _renderBarBorders(groupBounds) {
	    var _this2 = this;
	
	    var borderColor = this.theme.borderColor;
	
	
	    if (!borderColor) {
	      return null;
	    }
	
	    var groupBorders = _tuiCodeSnippet2['default'].map(groupBounds, function (bounds, groupIndex) {
	      return _tuiCodeSnippet2['default'].map(bounds, function (bound, index) {
	        if (!bound) {
	          return null;
	        }
	
	        var seriesItem = _this2.seriesDataModel.getSeriesItem(groupIndex, index);
	
	        return _this2._renderBorderLines(bound.start, borderColor, self.chartType, seriesItem);
	      });
	    });
	
	    return groupBorders;
	  };
	
	  /**
	   * Animate rect.
	   * @param {object} rect raphael object
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @param {number} animationDuration animation duration
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._animateRect = function _animateRect(rect, bound, animationDuration) {
	    rect.animate({
	      x: bound.width ? bound.left : bound.left - SERIES_EXTRA_VISUAL_AREA_FOR_ZERO / 2,
	      y: bound.height ? bound.top : bound.top - SERIES_EXTRA_VISUAL_AREA_FOR_ZERO / 2,
	      width: bound.width ? bound.width : SERIES_EXTRA_VISUAL_AREA_FOR_ZERO,
	      height: bound.height ? bound.height : SERIES_EXTRA_VISUAL_AREA_FOR_ZERO,
	      opacity: bound.height && bound.width ? 1 : SERIES_EXTRA_VISUAL_OPACITY_FOR_ZERO
	    }, animationDuration, '>');
	  };
	
	  /**
	   * Animate borders.
	   * @param {Array.<object>} lines raphael objects
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._animateBorders = function _animateBorders(lines, bound, chartType, item) {
	    var paths = this._makeBorderLinesPaths(bound, chartType, item);
	
	    _tuiCodeSnippet2['default'].forEach(lines, function (line, name) {
	      line.animate({
	        path: paths[name]
	      }, ANIMATION_DURATION, '>');
	    });
	  };
	
	  /**
	   * Animate.
	   * @param {function} onFinish finish callback function
	   */
	
	
	  RaphaelBarChart.prototype.animate = function animate(onFinish) {
	    var _this3 = this;
	
	    var groupBorders = this.groupBorders || [];
	    var animationDuration = this.options.animationDuration;
	
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupBars, function (bar, groupIndex, index) {
	      var lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	      if (!bar) {
	        return;
	      }
	
	      if (animationDuration) {
	        _this3._animateRect(bar.rect, bar.bound, animationDuration);
	      }
	
	      if (lines) {
	        _this3._animateBorders(lines, bar.bound, _this3.chartType, bar.item);
	      }
	    });
	
	    if (onFinish) {
	      this.callbackTimeout = setTimeout(function () {
	        onFinish();
	        delete _this3.callbackTimeout;
	      }, animationDuration);
	    }
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelBarChart.prototype.showAnimation = function showAnimation(data) {
	    var bar = this.groupBars[data.groupIndex][data.index];
	    var bound = bar.bound;
	
	
	    this.overlay.attr({
	      width: bound.width + BAR_HOVER_SPARE_SIZE,
	      height: bound.height + BAR_HOVER_SPARE_SIZE,
	      stroke: '#fff',
	      'stroke-width': '1',
	      x: bound.left - 4,
	      y: bound.top - 4,
	      'fill-opacity': 1
	    });
	
	    this.resortBarIndex(data.groupIndex);
	    this.overlay.toFront();
	    bar.rect.toFront();
	
	    if (this.labelSet) {
	      this.labelSet.toFront();
	    }
	    this.overlay.node.setAttribute('filter', 'url(#shadow)');
	  };
	
	  /**
	   * Hide animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelBarChart.prototype.hideAnimation = function hideAnimation(data) {
	    this.resortBarIndex(data.groupIndex);
	    this.overlay.attr({
	      width: 1,
	      height: 1,
	      x: 0,
	      y: 0,
	      'fill-opacity': 0
	    });
	
	    if (this.labelSet) {
	      this.labelSet.toFront();
	    }
	  };
	
	  /**
	   * reindexing bar in group
	   * @param {number} groupIndex - group index
	   */
	
	
	  RaphaelBarChart.prototype.resortBarIndex = function resortBarIndex(groupIndex) {
	    this.groupBars[groupIndex].forEach(function (barItem) {
	      barItem.rect.toFront();
	    });
	  };
	
	  /**
	   * Update rect bound
	   * @param {object} rect raphael object
	   * @param {{left: number, top: number, width: number, height: number}} bound bound
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._updateRectBound = function _updateRectBound(rect, bound) {
	    rect.attr({
	      x: bound.left,
	      y: bound.top,
	      width: bound.width,
	      height: bound.height
	    });
	  };
	
	  /**
	   * Resize graph of bar type chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{
	   *                  left:number, top:number, width: number, height: number
	   *              }>>} params.groupBounds group bounds
	   */
	
	
	  RaphaelBarChart.prototype.resize = function resize(params) {
	    var _this4 = this;
	
	    var groupBorders = this.groupBorders || [];
	    var dimension = params.dimension,
	        groupBounds = params.groupBounds;
	
	
	    this.groupBounds = groupBounds;
	    this.paper.setSize(dimension.width, dimension.height);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupBars, function (bar, groupIndex, index) {
	      if (!bar) {
	        return;
	      }
	
	      var lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	      var bound = groupBounds[groupIndex][index].end;
	
	      bar.bound = bound;
	      _raphaelRenderUtil2['default'].updateRectBound(bar.rect, bound);
	
	      if (lines) {
	        _this4._updateBordersPath(lines, bound, _this4.chartType, bar.item);
	      }
	    });
	  };
	
	  /**
	   * Change borders color.
	   * @param {Array.<object>} lines raphael objects
	   * @param {borderColor} borderColor border color
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._changeBordersColor = function _changeBordersColor(lines, borderColor) {
	    _tuiCodeSnippet2['default'].forEach(lines, function (line) {
	      line.attr({ stroke: borderColor });
	    });
	  };
	
	  /**
	   * Change bar color.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {string} color fill color
	   * @param {?string} borderColor stroke color
	   * @private
	   */
	
	
	  RaphaelBarChart.prototype._changeBarColor = function _changeBarColor(indexes, color, borderColor) {
	    var bar = this.groupBars[indexes.groupIndex][indexes.index];
	
	    bar.rect.attr({
	      fill: color
	    });
	
	    if (borderColor) {
	      var lines = this.groupBorders[indexes.groupIndex][indexes.index];
	      this._changeBordersColor(lines, borderColor);
	    }
	  };
	
	  /**
	   * Select series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelBarChart.prototype.selectSeries = function selectSeries(indexes) {
	    var bar = this.groupBars[indexes.groupIndex][indexes.index];
	    var objColor = _raphael2['default'].color(bar.color);
	    var selectionColorTheme = this.theme.selectionColor;
	    var color = selectionColorTheme || _raphaelRenderUtil2['default'].makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANC);
	    var borderColor = this.theme.borderColor;
	
	
	    if (borderColor) {
	      var objBorderColor = _raphael2['default'].color(borderColor);
	      borderColor = _raphaelRenderUtil2['default'].makeChangedLuminanceColor(objBorderColor.hex, DEFAULT_LUMINANC);
	    }
	
	    this._changeBarColor(indexes, color, borderColor);
	  };
	
	  /**
	   * Unselect series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelBarChart.prototype.unselectSeries = function unselectSeries(indexes) {
	    var bar = this.groupBars[indexes.groupIndex][indexes.index];
	    var borderColor = this.theme.borderColor;
	
	    this._changeBarColor(indexes, bar.color, borderColor);
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelBarChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var groupBorders = this.groupBorders || [];
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupBars, function (bar, groupIndex, index) {
	      if (!bar) {
	        return;
	      }
	
	      var lines = groupBorders[groupIndex] && groupBorders[groupIndex][index];
	      var opacity = noneSelected || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      bar.rect.attr({ 'fill-opacity': opacity });
	      if (lines) {
	        _tuiCodeSnippet2['default'].forEach(lines, function (line) {
	          line.attr({ 'stroke-opacity': opacity });
	        });
	      }
	    });
	  };
	
	  RaphaelBarChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, groupPositions, groupLabels, labelTheme, isStacked) {
	    var textAnchor = isStacked || this.chartType === 'column' ? 'middle' : 'start';
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      opacity: 0,
	      'text-anchor': textAnchor
	    };
	    var labelSet = this.labelSet = paper.set();
	
	    groupLabels.forEach(function (categoryLabel, categoryIndex) {
	      categoryLabel.forEach(function (label, seriesIndex) {
	        var position = groupPositions[categoryIndex][seriesIndex];
	        var endLabel = _raphaelRenderUtil2['default'].renderText(paper, position.end, label.end, attributes);
	        var enaLabelNodeStyle = endLabel.node.style;
	
	        enaLabelNodeStyle.userSelect = 'none';
	        enaLabelNodeStyle.cursor = 'default';
	
	        labelSet.push(endLabel);
	
	        if (position.start) {
	          var startLabel = _raphaelRenderUtil2['default'].renderText(paper, position.start, label.start, attributes);
	          startLabel.node.style.userSelect = 'none';
	          startLabel.node.style.cursor = 'default';
	
	          labelSet.push(startLabel);
	        }
	      });
	    });
	
	    return labelSet;
	  };
	
	  return RaphaelBarChart;
	}();
	
	exports['default'] = RaphaelBarChart;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var LINE_HEIGHT_FOR_CALCULATE = 1.11; /**
	                                       * @fileoverview Util for raphael rendering.
	                                       * @author NHN.
	                                       *         FE Development Lab <dl_javascript@nhn.com>
	                                       */
	
	var storeForGetTextDimension = {
	  cacheFontInfo: '',
	  elementForTextSize: null,
	  canvasElement: getCanvasForTextDimension()
	};
	
	/**
	 * Util for raphael rendering.
	 * @module raphaelRenderUtil
	 * @private
	 */
	exports['default'] = {
	  /**
	   * Make line path.
	   * @memberOf module:raphaelRenderUtil
	   * @param {{top: number, left: number}} fromPos from position
	   * @param {{top: number, left: number}} toPos to position
	   * @param {number} width width
	   * @returns {string} path
	   */
	  makeLinePath: function makeLinePath(fromPos, toPos) {
	    var width = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
	
	    var fromPoint = [fromPos.left, fromPos.top];
	    var toPoint = [toPos.left, toPos.top];
	    var additionalPoint = width % 2 / 2;
	
	    fromPoint.forEach(function (from, index) {
	      if (from === toPoint[index]) {
	        fromPoint[index] = toPoint[index] = Math.round(from) - additionalPoint;
	      }
	    });
	
	    return ['M'].concat(fromPoint, ['L'], toPoint);
	  },
	
	
	  /**
	   * Render line.
	   * @memberOf module:raphaelRenderUtil
	   * @param {object} paper raphael paper
	   * @param {string} path line path
	   * @param {string} color line color
	   * @param {number} strokeWidth stroke width
	   * @returns {object} raphael line
	   */
	  renderLine: function renderLine(paper, path, color, strokeWidth) {
	    var line = paper.path([path]);
	    var strokeStyle = {
	      stroke: color,
	      'stroke-width': _tuiCodeSnippet2['default'].isUndefined(strokeWidth) ? 2 : strokeWidth,
	      'stroke-linecap': 'butt'
	    };
	    if (color === 'transparent') {
	      strokeStyle.stroke = '#fff';
	      strokeStyle['stroke-opacity'] = 0;
	    }
	
	    line.attr(strokeStyle).node.setAttribute('class', 'auto-shape-rendering');
	
	    return line;
	  },
	
	
	  /**
	   * text ellipsis for fixed width
	   * @param {string} text - target text
	   * @param {number} fixedWidth - width for ellipsis
	   * @param {object} theme - label theme
	   * @returns {string}
	   */
	  getEllipsisText: function getEllipsisText(text, fixedWidth, theme) {
	    var textArray = String(text).split('');
	    var textLength = textArray.length;
	    var dotWidth = this.getRenderedTextSize('.', theme.fontSize, theme.fontFamily).width;
	    var newString = '';
	    var textWidth = dotWidth * 2;
	
	    for (var i = 0; i < textLength; i += 1) {
	      textWidth += this.getRenderedTextSize(textArray[i], theme.fontSize, theme.fontFamily).width;
	      if (textWidth >= fixedWidth) {
	        newString += '..';
	        break;
	      }
	      newString += textArray[i];
	    }
	
	    return newString;
	  },
	
	
	  /**
	   * Render text
	   * @param {object} paper - Raphael paper object
	   * @param {{left: number, top: number}} pos - text object position
	   * @param {string} text - text content
	   * @param {object} [attributes] - text object's attributes
	   * @returns {object}
	   */
	  renderText: function renderText(paper, pos, text, attributes) {
	    var textObj = paper.text(pos.left, pos.top, _tuiCodeSnippet2['default'].decodeHTMLEntity(String(text)));
	
	    if (attributes) {
	      if (attributes['dominant-baseline']) {
	        textObj.node.setAttribute('dominant-baseline', attributes['dominant-baseline']);
	      } else {
	        textObj.node.setAttribute('dominant-baseline', 'central');
	      }
	
	      textObj.attr(attributes);
	    }
	
	    return textObj;
	  },
	
	
	  /**
	   * Render area graph.
	   * @param {object} paper raphael paper
	   * @param {string} path path
	   * @param {object} fillStyle fill style
	   *      @param {string} fillStyle.fill fill color
	   *      @param {?number} fillStyle.opacity fill opacity
	   *      @param {string} fillStyle.stroke stroke color
	   *      @param {?number} fillStyle.stroke-opacity stroke opacity
	   * @returns {Array.<object>} raphael object
	   */
	  renderArea: function renderArea(paper, path, fillStyle) {
	    var area = paper.path(path);
	
	    fillStyle = Object.assign({
	      'stroke-opacity': 0
	    }, fillStyle);
	    area.attr(fillStyle);
	
	    return area;
	  },
	
	
	  /**
	   * Render circle.
	   * @param {object} paper - raphael object
	   * @param {{left: number, top: number}} position - position
	   * @param {number} radius - radius
	   * @param {object} attributes - attributes
	   * @returns {object}
	   */
	  renderCircle: function renderCircle(paper, position, radius, attributes) {
	    var circle = paper.circle(position.left, position.top, radius);
	
	    if (attributes) {
	      circle.attr(attributes);
	    }
	
	    return circle;
	  },
	
	
	  /**
	   * Render rect.
	   * @param {object} paper - raphael object
	   * @param {{left: number, top: number, width: number, height, number}} bound - bound
	   * @param {object} attributes - attributes
	   * @returns {*}
	   */
	  renderRect: function renderRect(paper, bound, attributes) {
	    var rect = paper.rect(bound.left, bound.top, bound.width, bound.height);
	
	    if (attributes) {
	      rect.attr(attributes);
	    }
	
	    return rect;
	  },
	
	
	  /**
	   * Update rect bound
	   * @param {object} rect raphael object
	   * @param {{left: number, top: number, width: number, height: number}} bound bound
	   */
	  updateRectBound: function updateRectBound(rect, bound) {
	    rect.attr({
	      x: bound.left,
	      y: bound.top,
	      width: bound.width,
	      height: bound.height
	    });
	  },
	
	
	  /**
	   * Render items of line type chart.
	   * @param {Array.<Array.<object>>} groupItems group items
	   * @param {function} funcRenderItem function
	   */
	  forEach2dArray: function forEach2dArray(groupItems, funcRenderItem) {
	    if (groupItems) {
	      groupItems.forEach(function (items, groupIndex) {
	        items.forEach(function (item, index) {
	          funcRenderItem(item, groupIndex, index);
	        });
	      });
	    }
	  },
	
	
	  /**
	   * Make changed luminance color.
	   * @param {string} hex hax color
	   * @param {number} lum luminance
	   * @returns {string} changed color
	   */
	  makeChangedLuminanceColor: function makeChangedLuminanceColor(hex, lum) {
	    hex = hex.replace('#', '');
	    lum = lum || 0;
	
	    var changedHex = _tuiCodeSnippet2['default'].range(3).map(function (index) {
	      var hd = parseInt(hex.substr(index * 2, 2), 16);
	      var newHd = hd + hd * lum;
	
	      newHd = Math.round(Math.min(Math.max(0, newHd), 255)).toString(16);
	
	      return _renderUtil2['default'].formatToZeroFill(newHd, 2);
	    }).join('');
	
	    return '#' + changedHex;
	  },
	
	
	  /**
	   * Get rendered text element size
	   * @param {string} text text content
	   * @param {number} fontSize font-size attribute
	   * @param {string} fontFamily font-family attribute
	   * @returns {{
	   *     width: number,
	   *     height: number
	   * }}
	   */
	  getRenderedTextSize: function getRenderedTextSize(text) {
	    var fontSize = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 11;
	    var fontFamily = arguments[2];
	    var canvasElement = storeForGetTextDimension.canvasElement;
	
	
	    if (canvasElement) {
	      return this._getTextDimensionWithCanvas(text, fontSize, fontFamily);
	    }
	
	    return this._getTextDimensionUseHtmlElement(text, fontSize, fontFamily);
	  },
	
	
	  /**
	   * Get rendered text element size (Use Canvas)
	   * @param {string} text text content
	   * @param {number} fontSize font-size attribute
	   * @param {string} fontFamily font-family attribute
	   * @returns {{
	   *     width: number,
	   *     height: number
	   * }}
	   * @private
	   */
	  _getTextDimensionWithCanvas: function _getTextDimensionWithCanvas(text, fontSize, fontFamily) {
	    var canvasElement = storeForGetTextDimension.canvasElement,
	        cacheFontInfo = storeForGetTextDimension.cacheFontInfo;
	
	    var ctx = canvasElement.getContext('2d');
	    var fontInfo = fontSize + 'px ' + fontFamily;
	
	    if (cacheFontInfo !== fontInfo) {
	      storeForGetTextDimension.cacheFontInfo = fontInfo;
	      ctx.font = fontInfo;
	    }
	
	    return {
	      width: ctx.measureText(text).width,
	      height: fontSize * LINE_HEIGHT_FOR_CALCULATE
	    };
	  },
	
	
	  /**
	   * Get rendered text element size (Use HTMLElement)
	   * @param {string} text text content
	   * @param {number} fontSize font-size attribute
	   * @param {string} fontFamily font-family attribute
	   * @returns {{
	   *     width: number,
	   *     height: number
	   * }}
	   * @private
	   */
	  _getTextDimensionUseHtmlElement: function _getTextDimensionUseHtmlElement(text, fontSize, fontFamily) {
	    var cacheFontInfo = storeForGetTextDimension.cacheFontInfo;
	    var elementForTextSize = storeForGetTextDimension.elementForTextSize;
	
	    if (!elementForTextSize) {
	      elementForTextSize = document.createElement('div');
	      var elementStyle = elementForTextSize.style;
	      this._setBasicHtmlElementStyleForGetTextSize(elementStyle);
	
	      document.body.appendChild(elementForTextSize);
	      storeForGetTextDimension.elementForTextSize = elementForTextSize;
	    }
	
	    var fontInfo = fontSize + 'px ' + fontFamily;
	
	    if (cacheFontInfo !== fontInfo) {
	      var _elementStyle = elementForTextSize.style;
	
	      _elementStyle.fontFamily = fontFamily;
	      _elementStyle.fontSize = fontSize + 'px';
	
	      storeForGetTextDimension.cacheFontInfo = fontInfo;
	    }
	
	    elementForTextSize.innerHTML = text;
	
	    return {
	      width: elementForTextSize.clientWidth,
	      height: elementForTextSize.clientHeight
	    };
	  },
	
	
	  /**
	   * Set basic style for get text dimension element
	   * @param {object} elementStyle style object for the element to get the text dimension
	   */
	  _setBasicHtmlElementStyleForGetTextSize: function _setBasicHtmlElementStyleForGetTextSize(elementStyle) {
	    elementStyle.visibility = 'hidden';
	    elementStyle.position = 'absolute';
	    elementStyle.margin = 0;
	    elementStyle.padding = 0;
	    elementStyle.lineHeight = LINE_HEIGHT_FOR_CALCULATE;
	    elementStyle.whiteSpace = 'nowrap';
	  },
	
	
	  /**
	   * Animate given element's opacity
	   * @param {object} element element
	   * @param {number} startOpacity endOpacity default is '0'
	   * @param {number} endOpacity endOpacity default is '1'
	   * @param {number} duration endOpacity default is '600'
	   */
	  animateOpacity: function animateOpacity(element, startOpacity, endOpacity, duration) {
	    var animationDuration = isNumber(duration) ? duration : 600;
	    var animationStartOpacity = isNumber(startOpacity) ? startOpacity : 0;
	    var animationEndOpacity = isNumber(endOpacity) ? endOpacity : 1;
	    var animation = _raphael2['default'].animation({
	      opacity: animationEndOpacity
	    }, animationDuration);
	
	    element.attr({
	      opacity: animationStartOpacity
	    });
	
	    element.animate(animation);
	  },
	
	  /**
	   * get default animation duration
	   * @param {string} chartType - chart type
	   * @returns {number} duration - default duration
	   * @private
	   */
	  getDefaultAnimationDuration: function getDefaultAnimationDuration(chartType) {
	    switch (chartType) {
	      case 'boxplot':
	      case 'combo':
	      case 'pie':
	      case 'scatter':
	      case 'bubble':
	      case 'area':
	      case 'line':
	      case 'column':
	      case 'bar':
	        return 700;
	      case 'heatmap':
	      case 'treemap':
	        return 600;
	      default:
	        return 0;
	    }
	  }
	};
	
	/**
	 * Return boolean value for given parameter is number or not
	 * @param {*} numberSuspect number suspect
	 * @returns {boolean}
	 */
	
	function isNumber(numberSuspect) {
	  return _tuiCodeSnippet2['default'].isExisty(numberSuspect) && typeof numberSuspect === 'number';
	}
	
	/**
	 * check supports canvas text
	 * @returns {?HTMLElement}
	 */
	function getCanvasForTextDimension() {
	  var isSupportCanvasContext = !!document.createElement('canvas').getContext;
	
	  if (!isSupportCanvasContext) {
	    return null;
	  }
	
	  var canvas = document.createElement('canvas');
	  var context = canvas.getContext('2d');
	
	  if (typeof context.fillText === 'function') {
	    return canvas;
	  }
	
	  return null;
	}

/***/ }),
/* 7 */
/***/ (function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_7__;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * @fileoverview Util for rendering.
	                                                                                                                                                                                                     * @author NHN.
	                                                                                                                                                                                                     *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                     */
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var _isOldBrowser = browser.msie && browser.version <= 8;
	var hasComputedStyle = window.getComputedStyle || false;
	var CLIP_RECT_ID = 'clipRectForAnimation';
	var lineBaseChartCount = 0;
	
	/**
	 * Util for rendering.
	 * @module renderUtil
	 * @private */
	var renderUtil = {
	  /**
	   * Concat string.
	   * @params {...string} target strings
	   * @returns {string} concat string
	   * @memberof module:renderUtil
	   */
	  concatStr: function concatStr() {
	    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }
	
	    return String.prototype.concat.apply('', args);
	  },
	
	
	  /**
	   * oneline trim tag for template literal
	   * @params {...string} target strings
	   * @returns {string} templating string
	   * @memberof module:renderUtil
	   */
	  oneLineTrim: function oneLineTrim() {
	    var normalTag = function normalTag(template) {
	      for (var _len2 = arguments.length, expressions = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	        expressions[_key2 - 1] = arguments[_key2];
	      }
	
	      return template.reduce(function (accumulator, part, i) {
	        return accumulator + expressions[i - 1] + part;
	      });
	    };
	
	    return normalTag.apply(undefined, arguments).replace(/\n\s*/g, '');
	  },
	
	
	  /**
	   * Make cssText for font.
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme font theme
	   * @returns {string} cssText
	   * @memberof module:renderUtil
	   */
	  makeFontCssText: function makeFontCssText() {
	    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	
	    var cssTexts = [];
	
	    if (theme.fontSize) {
	      cssTexts.push(this.concatStr('font-size:', theme.fontSize, 'px'));
	    }
	
	    if (theme.fontFamily) {
	      cssTexts.push(this.concatStr('font-family:', theme.fontFamily));
	    }
	
	    if (theme.color) {
	      cssTexts.push(this.concatStr('color:', theme.color));
	    }
	
	    if (theme.fontWeight) {
	      cssTexts.push(this.concatStr('font-weight:', theme.fontWeight));
	    }
	
	    return cssTexts.length ? cssTexts.join(';') : '';
	  },
	
	
	  /**
	   * Make caching key.
	   * @param {string} label labek
	   * @param {{fontSize: number, fontFamily: string}} theme theme
	   * @param {string} offsetType offset type (offsetWidth or offsetHeight)
	   * @returns {string} key
	   * @private
	   */
	  _makeCachingKey: function _makeCachingKey(label, theme, offsetType) {
	    var keys = [label, offsetType];
	
	    _tuiCodeSnippet2['default'].forEach(theme, function (key, value) {
	      keys.push(key + value);
	    });
	
	    return keys.join('-');
	  },
	
	
	  /**
	   * Add css style.
	   * @param {HTMLElement} div div element
	   * @param {{fontSize: number, fontFamily: string, cssText: string}} theme theme
	   * @private
	   */
	  _addCssStyle: function _addCssStyle(div) {
	    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
	        fontSize = _ref.fontSize,
	        fontFamily = _ref.fontFamily,
	        fontWeight = _ref.fontWeight,
	        cssText = _ref.cssText;
	
	    div.style.fontSize = (fontSize || _const2['default'].DEFAULT_LABEL_FONT_SIZE) + 'px';
	
	    if (fontFamily) {
	      div.style.fontFamily = fontFamily;
	    }
	
	    if (fontWeight) {
	      div.style.fontWeight = fontWeight;
	    }
	
	    if (cssText) {
	      div.style.cssText += cssText;
	    }
	  },
	
	
	  /**
	   * Size cache.
	   * @type {object}
	   * @private
	   */
	  sizeCache: {},
	
	  /**
	   * Get rendered label size (width or height).
	   * @memberOf module:renderUtil
	   * @param {string | number} label label
	   * @param {object} theme theme
	   * @param {string} offsetType offset type (offsetWidth or offsetHeight)
	   * @returns {number} size
	   * @private
	   */
	  _getRenderedLabelSize: function _getRenderedLabelSize() {
	    var label = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
	    var theme = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	    var offsetType = arguments[2];
	
	    label = String(label);
	
	    if (!label) {
	      return 0;
	    }
	
	    var key = this._makeCachingKey(label, theme, offsetType);
	    var labelSize = this.sizeCache[key];
	
	    if (!labelSize) {
	      var div = this._createSizeCheckEl();
	      var span = div.firstChild;
	      span.innerText = label;
	
	      this._addCssStyle(div, theme);
	
	      document.body.appendChild(div);
	      labelSize = span[offsetType];
	      document.body.removeChild(div);
	
	      this.sizeCache[key] = labelSize;
	    }
	
	    return labelSize;
	  },
	
	
	  checkEl: null,
	  /**
	   * Create element for size check.
	   * @memberof module:renderUtil
	   * @returns {HTMLElement} element
	   * @private
	   */
	  _createSizeCheckEl: function _createSizeCheckEl() {
	    if (!this.checkEl) {
	      var div = _domHandler2['default'].create('DIV', 'tui-chart-size-check-element');
	      var span = _domHandler2['default'].create('SPAN');
	      div.appendChild(span);
	      this.checkEl = div;
	    } else {
	      this.checkEl.style.cssText = '';
	    }
	
	    return this.checkEl;
	  },
	
	
	  /**
	   * Get rendered label width.
	   * @memberof module:renderUtil
	   * @param {string} label label
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	   * @returns {number} width
	   */
	  getRenderedLabelWidth: function getRenderedLabelWidth(label, theme) {
	    return this._getRenderedLabelSize(label, theme, 'offsetWidth');
	  },
	
	
	  /**
	   * Get rendered label height.
	   * @memberof module:renderUtil
	   * @param {string} label label
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	   * @returns {number} height
	   */
	  getRenderedLabelHeight: function getRenderedLabelHeight(label, theme) {
	    return this._getRenderedLabelSize(label, theme, 'offsetHeight');
	  },
	
	
	  /**
	   * Get Rendered Labels Max Size(width or height).
	   * @memberof module:renderUtil
	   * @param {string[]} labels labels
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	   * @param {function} iteratee iteratee
	   * @returns {number} max size (width or height)
	   * @private
	   */
	  _getRenderedLabelsMaxSize: function _getRenderedLabelsMaxSize(labels, theme, iteratee) {
	    var maxSize = 0;
	
	    if (labels && labels.length) {
	      var sizes = _tuiCodeSnippet2['default'].map(labels, function (label) {
	        return iteratee(label, theme);
	      });
	      maxSize = _arrayUtil2['default'].max(sizes);
	    }
	
	    return maxSize;
	  },
	
	
	  /**
	   * Get rendered labels max width.
	   * @memberof module:renderUtil
	   * @param {string[]} labels labels
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	   * @param {number} [maxWidth] - max width
	   * @returns {number} max width
	   * @private
	   */
	  getRenderedLabelsMaxWidth: function getRenderedLabelsMaxWidth(labels, theme, maxWidth) {
	    var iteratee = _tuiCodeSnippet2['default'].bind(this.getRenderedLabelWidth, this);
	    var labelMaxSize = this._getRenderedLabelsMaxSize(labels, theme, iteratee);
	
	    return maxWidth ? Math.min(maxWidth, labelMaxSize) : labelMaxSize;
	  },
	
	
	  /**
	   * Get rendered labels max height.
	   * @memberof module:renderUtil
	   * @param {string[]} labels labels
	   * @param {{fontSize: number, fontFamily: string, color: string}} theme label theme
	   * @returns {number} max height
	   */
	  getRenderedLabelsMaxHeight: function getRenderedLabelsMaxHeight(labels, theme) {
	    var iteratee = _tuiCodeSnippet2['default'].bind(this.getRenderedLabelHeight, this);
	
	    return this._getRenderedLabelsMaxSize(labels, theme, iteratee);
	  },
	
	
	  /**
	   * Render dimension.
	   * @memberof module:renderUtil
	   * @param {HTMLElement} el target element
	   * @param {{width: number, height: number}} dimension dimension
	   */
	  renderDimension: function renderDimension(el, _ref2) {
	    var _ref2$width = _ref2.width,
	        width = _ref2$width === undefined ? 0 : _ref2$width,
	        _ref2$height = _ref2.height,
	        height = _ref2$height === undefined ? 0 : _ref2$height;
	
	    el.style.cssText = [this.concatStr('width:', width, 'px'), this.concatStr('height:', height, 'px')].join(';');
	  },
	
	
	  /**
	   * Render position(top, right).
	   * @memberof module:renderUtil
	   * @param {HTMLElement} el target element
	   * @param {{top: number, left: number, right: number}} position position
	   */
	  renderPosition: function renderPosition(el, position) {
	    if (_tuiCodeSnippet2['default'].isUndefined(position)) {
	      return;
	    }
	
	    _tuiCodeSnippet2['default'].forEachArray(['top', 'bottom', 'left', 'right'], function (key) {
	      var value = position[key];
	
	      if (_tuiCodeSnippet2['default'].isNumber(value)) {
	        el.style[key] = value + 'px';
	      }
	    });
	  },
	
	
	  /**
	   * Render background.
	   * @memberof module:renderUtil
	   * @param {HTMLElement} el target element
	   * @param {string} background background option
	   */
	  renderBackground: function renderBackground(el, background) {
	    if (background) {
	      el.style.background = background;
	    }
	  },
	
	
	  /**
	   * Render font family.
	   * @memberof module:renderUtil
	   * @param {HTMLElement} el target element
	   * @param {string} fontFamily font family option
	   */
	  renderFontFamily: function renderFontFamily(el, fontFamily) {
	    if (!fontFamily) {
	      return;
	    }
	
	    el.style.fontFamily = fontFamily;
	  },
	
	
	  /**
	   * Render title.
	   * @memberof module:renderUtil
	   * @param {string} title title
	   * @param {{fontSize: number, color: string, background: string}} theme title theme
	   * @param {string} className css class name
	   * @returns {HTMLElement} title element
	   */
	  renderTitle: function renderTitle(title, theme, className) {
	    if (!title) {
	      return null;
	    }
	
	    var cssText = renderUtil.makeFontCssText(theme);
	    var elTitle = _domHandler2['default'].create('DIV', className);
	    elTitle.innerHTML = title;
	
	    if (theme.background) {
	      cssText += ';' + this.concatStr('background:', theme.background);
	    }
	
	    elTitle.style.cssText = cssText;
	
	    return elTitle;
	  },
	
	
	  /**
	   * Expand dimension.
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} bound series bound
	   * @returns {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} expended bound
	   * @memberof module:renderUtil
	   */
	  expandBound: function expandBound(_ref3) {
	    var dimension = _ref3.dimension,
	        position = _ref3.position;
	
	    return {
	      dimension: {
	        width: dimension.width + _const2['default'].SERIES_EXPAND_SIZE * 2,
	        height: dimension.height + _const2['default'].SERIES_EXPAND_SIZE * 2
	      },
	      position: {
	        left: position.left - _const2['default'].SERIES_EXPAND_SIZE,
	        top: position.top - _const2['default'].SERIES_EXPAND_SIZE
	      }
	    };
	  },
	
	
	  /**
	   * Proper case.
	   * @param {string} value - string value
	   * @returns {string}
	   */
	  _properCase: function _properCase(value) {
	    return value.substring(0, 1).toUpperCase() + value.substring(1);
	  },
	
	
	  /**
	   * Make mouse event detector name.
	   * @param {string} prefix prefix
	   * @param {string} value value
	   * @param {string} suffix suffix
	   * @returns {string} mouse event detector name
	   * @memberof module:renderUtil
	   */
	  makeMouseEventDetectorName: function makeMouseEventDetectorName(prefix, value, suffix) {
	    return prefix + this._properCase(value) + this._properCase(suffix);
	  },
	
	
	  /**
	   * Format value.
	   * @param {object} params - raw data
	   *     @param {number} params.value value
	   *     @param {Array.<function>} params.formatFunctions - functions for format
	   *     @param {string} params.chartType - type of chart
	   *     @param {string} params.areaType - type of area like yAxis, xAxis, series, circleLegend
	   *     @param {string} [params.valueType] - type of value
	   *     @param {string} [params.legendName] - legendName
	   * @returns {string} formatted value
	   * @memberof module:renderUtil
	   */
	  formatValue: function formatValue(params) {
	    var value = params.value,
	        formatFunctions = params.formatFunctions,
	        _params$valueType = params.valueType,
	        valueType = _params$valueType === undefined ? 'value' : _params$valueType,
	        areaType = params.areaType,
	        legendName = params.legendName,
	        chartType = params.chartType;
	
	    var fns = [String(value)].concat(_toConsumableArray(formatFunctions || []));
	
	    return _tuiCodeSnippet2['default'].reduce(fns, function (stored, fn) {
	      return fn(stored, chartType, areaType, valueType, legendName);
	    });
	  },
	
	  /**
	   * Format values.
	   * @param {Array.<number>} values values
	   * @param {Array.<function>} formatFunctions functions for format
	   * @param {object} typeInfos - type of chart
	   *     @param {string} typeInfos.chartType - type of chart
	   *     @param {string} typeInfos.areaType - type of area like yAxis, xAxis, series, circleLegend
	   *     @param {string} typeInfos.valueType - type of value
	   * @returns {Array.<string>}
	   * @memberof module:renderUtil
	   */
	  formatValues: function formatValues(values, formatFunctions) {
	    var typeInfos = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	    var chartType = typeInfos.chartType,
	        areaType = typeInfos.areaType,
	        valueType = typeInfos.valueType;
	
	
	    if (!formatFunctions || !formatFunctions.length) {
	      return values;
	    }
	
	    return _tuiCodeSnippet2['default'].map(values, function (value) {
	      return renderUtil.formatValue({
	        value: value,
	        formatFunctions: formatFunctions,
	        chartType: chartType,
	        areaType: areaType,
	        valueType: valueType
	      });
	    });
	  },
	
	
	  /**
	   * Format date.
	   * @param {string | number | date} value - value
	   * @param {string} format - date format
	   * @returns {string}
	   * @memberof module:renderUtil
	   */
	  formatDate: function formatDate(value) {
	    var format = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _const2['default'].DEFAULT_DATE_FORMAT;
	
	    var date = _tuiCodeSnippet2['default'].isDate(value) ? value : new Date(value);
	
	    return _tuiCodeSnippet2['default'].formatDate(format, date) || value;
	  },
	
	
	  /**
	   * Format dates.
	   * @param {Array.<string | number | date>} values - values
	   * @param {string} format - date format
	   * @returns {Array}
	   * @memberof module:renderUtil
	   */
	  formatDates: function formatDates(values) {
	    var _this = this;
	
	    var format = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _const2['default'].DEFAULT_DATE_FORMAT;
	
	    return _tuiCodeSnippet2['default'].map(values, function (value) {
	      return _this.formatDate(value, format);
	    });
	  },
	
	
	  /**
	   * Cancel animation
	   * @param {{id: number}} animation animaion object
	   * @memberof module:renderUtil
	   */
	  cancelAnimation: function cancelAnimation(animation) {
	    if (animation && animation.id) {
	      cancelAnimationFrame(animation.id);
	      delete animation.id;
	    }
	  },
	
	
	  /**
	   * Start animation.
	   * @param {number} animationTime - animation time
	   * @param {function} onAnimation - animation callback function
	   * @param {function} onCompleted - completed callback function
	   * @returns {{id: number}} requestAnimationFrame id
	   * @memberof module:renderUtil
	   */
	  startAnimation: function startAnimation(animationTime, onAnimation, onCompleted) {
	    var animation = {};
	    var startTime = new Date().getTime();
	
	    /**
	     * Animate.
	     */
	    function animate() {
	      var diffTime = new Date().getTime() - startTime;
	      var ratio = Math.min(diffTime / animationTime, 1);
	
	      onAnimation(ratio);
	
	      if (ratio === 1) {
	        delete animation.id;
	        if (onCompleted) {
	          onCompleted();
	        }
	      } else {
	        animation.id = requestAnimationFrame(animate);
	      }
	    }
	
	    animation.id = requestAnimationFrame(animate);
	
	    return animation;
	  },
	
	
	  /**
	   * Whether oldBrowser or not.
	   * @memberof module:renderUtil
	   * @returns {boolean} result boolean
	   */
	  isOldBrowser: function isOldBrowser() {
	    return _isOldBrowser;
	  },
	
	
	  /**
	   * Format to zero fill.
	   * @param {string} value target value
	   * @param {number} len length of result
	   * @returns {string} formatted value
	   * @private
	   */
	  formatToZeroFill: function formatToZeroFill(value, len) {
	    var zero = '0';
	
	    value = String(value);
	
	    if (value.length >= len) {
	      return value;
	    }
	
	    while (value.length < len) {
	      value = zero + value;
	    }
	
	    return value;
	  },
	
	
	  /**
	   * Format to Decimal.
	   * @param {string} value target value
	   * @param {number} len length of under decimal point
	   * @returns {string} formatted value
	   * @memberof module:renderUtil
	   */
	  formatToDecimal: function formatToDecimal(value, len) {
	    var DECIMAL = 10;
	    var pow = Math.pow(DECIMAL, len);
	
	    if (len === 0) {
	      return Math.round(value);
	    }
	
	    value = Math.round(value * pow) / pow;
	    value = parseFloat(value).toFixed(len);
	
	    return value;
	  },
	
	
	  /**
	   * Format to Comma.
	   * @param {string} value target value
	   * @returns {string} formatted value
	   * @private
	   */
	  formatToComma: function formatToComma(value) {
	    value = String(value);
	    var comma = ',';
	    var betweenLen = 3;
	    var orgValue = value;
	    var sign = value.indexOf('-') > -1 ? '-' : '';
	    var underPointValue = '';
	    var values = void 0;
	    var lastIndex = void 0;
	    var formattedValue = void 0;
	
	    if (value.indexOf('.') > -1) {
	      values = value.split('.');
	      value = String(Math.abs(values[0]));
	      underPointValue = '.' + values[1];
	    } else {
	      value = String(Math.abs(value));
	    }
	
	    if (value.length <= betweenLen) {
	      formattedValue = orgValue;
	    } else {
	      var _ref4;
	
	      values = value.split('').reverse();
	      lastIndex = values.length - 1;
	      values = _tuiCodeSnippet2['default'].map(values, function (char, index) {
	        var result = [char];
	        if (index < lastIndex && (index + 1) % betweenLen === 0) {
	          result.push(comma);
	        }
	
	        return result;
	      });
	      formattedValue = sign + (_ref4 = []).concat.apply(_ref4, _toConsumableArray(values)).reverse().join('') + underPointValue;
	    }
	
	    return formattedValue;
	  },
	
	
	  /**
	   * Make cssText from map.
	   * @param {object} cssMap - css map
	   * @returns {string}
	   * @memberof module:renderUtil
	   */
	  makeCssTextFromMap: function makeCssTextFromMap(cssMap) {
	    return _tuiCodeSnippet2['default'].map(cssMap, function (value, name) {
	      return renderUtil.concatStr(name, ':', value);
	    }).join(';');
	  },
	
	
	  /**
	   * Perse String.
	   * @param {string} value - string
	   * @returns {string}
	   */
	  _perseString: function _perseString(value) {
	    return typeof value === 'string' || typeof value === 'number' ? String(value) : '';
	  },
	
	
	  /**
	   * Add prefix or suffix to label.
	   * @param {array} labels - labels
	   * @param {string} prefix - string
	   * @param {string} suffix - string
	   * @returns {array}
	   * @memberof module:renderUtil
	   */
	  addPrefixSuffix: function addPrefixSuffix(labels) {
	    var _this2 = this;
	
	    var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	    var suffix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
	
	    prefix = this._perseString(prefix);
	    suffix = this._perseString(suffix);
	
	    if (!(prefix === '' && suffix === '')) {
	      return _tuiCodeSnippet2['default'].map(labels, function (label) {
	        return _this2.addPrefixSuffixItem(label, prefix, suffix);
	      });
	    }
	
	    return labels;
	  },
	
	
	  /**
	   * Add prefix or suffix for one item
	   * @param {string} label - labels
	   * @param {string} prefix - string
	   * @param {string} suffix - string
	   * @returns {string}
	   * @memberof module:renderUtil
	   */
	  addPrefixSuffixItem: function addPrefixSuffixItem(label) {
	    var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	    var suffix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
	
	    prefix = this._perseString(prefix);
	    suffix = this._perseString(suffix);
	
	    return prefix + label + suffix;
	  },
	
	
	  /**
	   * Returns element's style value defined at css file
	   * @param {HTMLElement} target - Current element
	   * @returns {Object} Style object of element
	   * @memberof module:renderUtil
	   */
	  getStyle: function getStyle(target) {
	    var computedObj = void 0;
	
	    if (hasComputedStyle) {
	      computedObj = window.getComputedStyle(target, '');
	    } else {
	      computedObj = target.currentStyle;
	    }
	
	    return computedObj;
	  },
	
	
	  /**
	   * Get clip rect id
	   * @returns {string} create unique id by line base chart count
	   */
	  generateClipRectId: function generateClipRectId() {
	    var id = CLIP_RECT_ID + lineBaseChartCount;
	    lineBaseChartCount += 1;
	
	    return id;
	  }
	};
	
	/**
	 * Set css opacity.
	 * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	 * @param {function} iteratee - iteratee
	 * @ignore
	 */
	function setOpacity(elements, iteratee) {
	  elements = _tuiCodeSnippet2['default'].isArray(elements) ? elements : [elements];
	  _tuiCodeSnippet2['default'].forEachArray(elements, iteratee);
	}
	
	/**
	 * Make filter opacity css string.
	 * @param {number} opacity - opacity
	 * @returns {string}
	 * @ignore
	 */
	function makeCssFilterOpacityString(opacity) {
	  return 'alpha(opacity=' + opacity * _const2['default'].OLD_BROWSER_OPACITY_100 + ')';
	}
	
	if (_isOldBrowser) {
	  /**
	   * Make opacity css text for old browser(IE7, IE8).
	   * @param {number} opacity - opacity
	   * @returns {string}
	   */
	  renderUtil.makeOpacityCssText = function (opacity) {
	    var cssText = '';
	
	    if (_tuiCodeSnippet2['default'].isExisty(opacity)) {
	      var cssOpacityString = makeCssFilterOpacityString(opacity);
	      cssText = ';filter:' + cssOpacityString;
	    }
	
	    return cssText;
	  };
	
	  /**
	   * Set css opacity for old browser(IE7, IE8).
	   * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	   * @param {number} opacity - opacity
	   */
	  renderUtil.setOpacity = function (elements, opacity) {
	    var filter = makeCssFilterOpacityString(opacity);
	    setOpacity(elements, function (element) {
	      element.style.filter = filter;
	    });
	  };
	} else {
	  /**
	   * Make opacity css text for browser supporting opacity property of CSS3.
	   * @param {number} opacity - opacity
	   * @returns {string}
	   */
	  renderUtil.makeOpacityCssText = function (opacity) {
	    var cssText = '';
	
	    if (_tuiCodeSnippet2['default'].isExisty(opacity)) {
	      cssText = ';opacity:' + opacity;
	    }
	
	    return cssText;
	  };
	
	  /**
	   * Set css opacity for browser supporting opacity property of CSS3.
	   * @param {HTMLElement | Array.<HTMLElement>} elements - elements
	   * @param {number} opacity - opacity
	   */
	  renderUtil.setOpacity = function (elements, opacity) {
	    setOpacity(elements, function (element) {
	      element.style.opacity = opacity;
	    });
	  };
	}
	
	exports['default'] = renderUtil;

/***/ }),
/* 9 */
/***/ (function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	/**
	 * @fileoverview Chart const
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	/**
	 * Chart const
	 * @readonly
	 * @enum {number|string}
	 * @private
	 */
	exports['default'] = {
	  /** tui class names
	   * @type {string}
	   */
	  CLASS_NAME_LEGEND_LABEL: 'tui-chart-legend-label',
	  /** @type {string} */
	  CLASS_NAME_LEGEND_CHECKBOX: 'tui-chart-legend-checkbox',
	  /** @type {string} */
	  CLASS_NAME_SERIES_LABEL: 'tui-chart-series-label',
	  /** @type {string} */
	  CLASS_NAME_SERIES_LEGEND: 'tui-chart-series-legend',
	  /** @type {string} */
	  CLASS_NAME_RESET_ZOOM_BTN: 'tui-chart-reset-zoom-btn',
	  /** @type {string} */
	  CLASS_NAME_ZOOM_OUT_BTN: 'tui-chart-zoom-out-btn',
	  /** @type {string} */
	  CLASS_NAME_CHART_EXPORT_MENU_AREA: 'tui-chart-chartExportMenu-area',
	  /** @type {string} */
	  CLASS_NAME_CHART_EXPORT_MENU_ITEM: 'tui-chart-chartExportMenu-item',
	  /** @type {string} */
	  CLASS_NAME_CHART_EXPORT_MENU_BUTTON: 'tui-chart-chartExportMenu-button',
	  /** @type {string} */
	  CLASS_NAME_CHART_EXPORT_MENU_HEAD: 'tui-chart-chartExportMenu-head',
	  CLASS_NAME_CHART_EXPORT_MENU_BODY: 'tui-chart-chartExportMenu-body',
	  CLASS_NAME_TOOLTIP_VALUE: 'tui-chart-tooltip-value',
	  /** @type {string} */
	  CLASS_NAME_TOOLTIP_HEAD: 'tui-chart-tooltip-head',
	  /** @type {string} */
	  CLASS_NAME_TOOLTIP_BODY: 'tui-chart-tooltip-body',
	  /** @type {string} */
	  CLASS_NAME_SVG_AUTOSHAPE: 'auto-shape-rendering',
	  /** chart type
	   * @type {string}
	   */
	  CHART_TYPE_BAR: 'bar',
	  /** @type {string} */
	  CHART_TYPE_COLUMN: 'column',
	  /** @type {string} */
	  CHART_TYPE_LINE: 'line',
	  /** @type {string} */
	  CHART_TYPE_AREA: 'area',
	  /** @type {string} */
	  CHART_TYPE_COMBO: 'combo',
	  /** @type {string} */
	  CHART_TYPE_COLUMN_LINE_COMBO: 'columnLineCombo',
	  /** @type {string} */
	  CHART_TYPE_LINE_SCATTER_COMBO: 'lineScatterCombo',
	  /** @type {string} */
	  CHART_TYPE_LINE_AREA_COMBO: 'lineAreaCombo',
	  /** @type {string} */
	  CHART_TYPE_PIE_DONUT_COMBO: 'pieDonutCombo',
	  /** @type {string} */
	  CHART_TYPE_PIE: 'pie',
	  /** @type {string} */
	  CHART_TYPE_BUBBLE: 'bubble',
	  /** @type {string} */
	  CHART_TYPE_SCATTER: 'scatter',
	  /** @type {string} */
	  CHART_TYPE_HEATMAP: 'heatmap',
	  /** @type {string} */
	  CHART_TYPE_TREEMAP: 'treemap',
	  /** @type {string} */
	  CHART_TYPE_MAP: 'map',
	  /** @type {string} */
	  CHART_TYPE_RADIAL: 'radial',
	  /** @type {string} */
	  CHART_TYPE_BOXPLOT: 'boxplot',
	  /** @type {string} */
	  CHART_TYPE_BULLET: 'bullet',
	  /** chart padding */
	  CHART_PADDING: 10,
	  /** chart default width */
	  CHART_DEFAULT_WIDTH: 500,
	  /** chart default height */
	  CHART_DEFAULT_HEIGHT: 400,
	  /** overlapping width of xAxis and yAxis */
	  OVERLAPPING_WIDTH: 1,
	  /** rendered text padding */
	  TEXT_PADDING: 2,
	  /** series expand size */
	  SERIES_EXPAND_SIZE: 10,
	  /** series area vertical padding */
	  SERIES_AREA_V_PADDING: 10,
	  /** series label padding */
	  SERIES_LABEL_PADDING: 5,
	  /** series event margins for the value zero */
	  SERIES_EXTRA_EVENT_AREA_FOR_ZERO: 2,
	  /** default font size of title */
	  DEFAULT_TITLE_FONT_SIZE: 14,
	  /** default font size of axis title */
	  DEFAULT_AXIS_TITLE_FONT_SIZE: 10,
	  /** default font size of label */
	  DEFAULT_LABEL_FONT_SIZE: 12,
	  /** default font size of series label */
	  DEFAULT_SERIES_LABEL_FONT_SIZE: 11,
	  /** default graph plugin
	   * @type {string}
	   */
	  DEFAULT_PLUGIN: 'Raphael',
	  /** default tick color
	   * @type {string}
	   */
	  DEFAULT_TICK_COLOR: 'black',
	  /** default theme name
	   * @type {string}
	   */
	  DEFAULT_THEME_NAME: 'default',
	  MAX_HEIGHT_WORD: 'A',
	  /** stack type
	   * @type {string}
	   */
	  NORMAL_STACK_TYPE: 'normal',
	  /** @type {string} */
	  PERCENT_STACK_TYPE: 'percent',
	  /** default stack
	   * @type {string}
	   */
	  DEFAULT_STACK: '___DEFAULT___STACK___',
	  /** dummy key
	   * @type {string}
	   */
	  DUMMY_KEY: '___DUMMY___KEY___',
	  /** root id of treemap
	   * @type {string}
	   */
	  TREEMAP_ROOT_ID: '___TUI_TREEMAP_ROOT___',
	  /** id prefix of treemap
	   * @type {string}
	   */
	  TREEMAP_ID_PREFIX: '___TUI_TREEMAP_ID___',
	  /** prefix for caching seriesItems
	   * @type {string}
	   */
	  TREEMAP_DEPTH_KEY_PREFIX: '___TUI_TREEMAP_DEPTH___',
	  /** @type {string} */
	  TREEMAP_PARENT_KEY_PREFIX: '___TUI_TREEMAP_PARENT___',
	  /** @type {string} */
	  TREEMAP_LEAF_KEY_PREFIX: '___TUI_TREEMAP_LEAF___',
	  /** @type {string} */
	  TREEMAP_LIMIT_DEPTH_KEY_PREFIX: '___TUI_TREEMAP_LIMIT_DEPTH___',
	  /** default border color for treemap chart
	   * @type {string}
	   */
	  TREEMAP_DEFAULT_BORDER: '#ffffff',
	  TREEMAP_DEFAULT_BORDER_WIDTH: 4,
	  /** empty axis label */
	  EMPTY_AXIS_LABEL: '',
	  /** angel */
	  ANGLE_85: 85,
	  ANGLE_90: 90,
	  ANGLE_360: 360,
	  /** radian */
	  RAD: Math.PI / 180,
	  RERENDER_TIME: 700,
	  ADDING_DATA_ANIMATION_DURATION: 300,
	  /** series label align outer
	   * @type {string}
	   */
	  LABEL_ALIGN_OUTER: 'outer',
	  /** @type {string} */
	  LEGEND_ALIGN_TOP: 'top',
	  /** @type {string} */
	  LEGEND_ALIGN_BOTTOM: 'bottom',
	  /** @type {string} */
	  LEGEND_ALIGN_LEFT: 'left',
	  /** @type {number} */
	  LEGEND_PAGINATION_BUTTON_WIDTH: 20,
	  /** @type {number} */
	  LEGEND_PAGINATION_BUTTON_PADDING_RIGHT: 6,
	  /** series outer label padding */
	  SERIES_OUTER_LABEL_PADDING: 20,
	  /** default ratio for pie graph */
	  PIE_GRAPH_DEFAULT_RATIO: 0.9,
	  /** small ratio for pie graph */
	  PIE_GRAPH_SMALL_RATIO: 0.75,
	  /** pie chart legend label size */
	  PIE_GRAPH_LEGEND_LABEL_SIZE: 16,
	  /** pie chart legend label size */
	  PIE_GRAPH_LEGEND_LABEL_INTERVAL: 20,
	  /** tick count for spectrum legend */
	  SPECTRUM_LEGEND_TICK_COUNT: 4,
	  /** legend & lable concat separator */
	  LABEL_SEPARATOR: '\n',
	  /** default position ratio of map chart label
	   * @type {object}
	   */
	  MAP_CHART_LABEL_DEFAULT_POSITION_RATIO: {
	    x: 0.5,
	    y: 0.5
	  },
	  /** map chart zoom area width */
	  MAP_CHART_ZOOM_AREA_WIDTH: 24,
	  /** map chart zoom area height */
	  MAP_CHART_ZOOM_AREA_HEIGHT: 58,
	  /** dot radius */
	  DOT_RADIUS: 4,
	  /** radius for circle of scatter chart*/
	  SCATTER_RADIUS: 7,
	  /**
	   * theme properties
	   * @type {{yAxis: Array.<string>, series: Array.<string>}}
	   */
	  THEME_PROPS_MAP: {
	    yAxis: ['tickColor', 'title', 'label'],
	    series: ['label', 'colors', 'borderColor', 'borderWidth', 'selectionColor', 'startColor', 'endColor', 'overColor', 'dot', 'ranges']
	  },
	  /** title area width padding */
	  TITLE_AREA_WIDTH_PADDING: 20,
	  /** chart export menu width, height */
	  CHART_EXPORT_MENU_SIZE: 24,
	  /** top margin of x axis label */
	  XAXIS_LABEL_TOP_MARGIN: 10,
	  /** right padding of vertical label */
	  V_LABEL_RIGHT_PADDING: 10,
	  /** tooltip prefix
	   * @type {string}
	   */
	  TOOLTIP_PREFIX: 'tui-chart-tooltip',
	  /** tooltip z-index **/
	  TOOLTIP_ZINDEX: 500,
	  /** tooltip animation time */
	  TOOLTIP_ANIMATION_TIME: 10,
	  /** tooltip animation time for pie chart */
	  TOOLTIP_PIE_ANIMATION_TIME: 50,
	  /** minimum pixel type step size */
	  MIN_PIXEL_TYPE_STEP_SIZE: 45,
	  /** maximum pixel type step size */
	  MAX_PIXEL_TYPE_STEP_SIZE: 65,
	  /** axis scale for percent stack option
	   * @type {object}
	   */
	  PERCENT_STACKED_AXIS_SCALE: {
	    limit: {
	      min: 0,
	      max: 100
	    },
	    step: 25,
	    labels: [0, 25, 50, 75, 100]
	  },
	  /** axis scale for minus percent stack option
	   * @type {object}
	   */
	  MINUS_PERCENT_STACKED_AXIS_SCALE: {
	    limit: {
	      min: -100,
	      max: 0
	    },
	    step: 25,
	    labels: [0, -25, -50, -75, -100]
	  },
	  /** axis scale of dual percent stack option
	   * @type {object}
	   */
	  DUAL_PERCENT_STACKED_AXIS_SCALE: {
	    limit: {
	      min: -100,
	      max: 100
	    },
	    step: 25,
	    labels: [-100, -75, -50, -25, 0, 25, 50, 75, 100]
	  },
	  /** axis scale of diverging percent stack option
	   * @type {object}
	   */
	  DIVERGING_PERCENT_STACKED_AXIS_SCALE: {
	    limit: {
	      min: -100,
	      max: 100
	    },
	    step: 25,
	    labels: [100, 75, 50, 25, 0, 25, 50, 75, 100]
	  },
	  /**
	   * datetime axis type
	   * @type {string}
	   */
	  AXIS_TYPE_DATETIME: 'datetime',
	  /**
	   * default dateFormat
	   * @type {string}
	   */
	  DEFAULT_DATE_FORMAT: 'YYYY.MM.DD hh:mm:dd',
	  /**
	   * date type
	   * @type {string}
	   */
	  DATE_TYPE_YEAR: 'year',
	  DATE_TYPE_MONTH: 'month',
	  DATE_TYPE_WEEK: 'week',
	  DATE_TYPE_DATE: 'date',
	  DATE_TYPE_HOUR: 'hour',
	  DATE_TYPE_MINUTE: 'minute',
	  DATE_TYPE_SECOND: 'second',
	  /** title add padding */
	  TITLE_PADDING: 20,
	  TITLE_ALIGN_CENTER: 'center',
	  TITLE_ALIGN_RIGHT: 'right',
	  TITLE_ALIGN_LEFT: 'left',
	  /** default header height */
	  DEFAULT_HEADER_HEIGHT: 10,
	  /** legend area horizontal padding */
	  LEGEND_AREA_H_PADDING: 15,
	  /** legend area vertical padding */
	  LEGEND_AREA_V_PADDING: 7,
	  /** legend checkbox width */
	  LEGEND_CHECKBOX_SIZE: 14,
	  LEGEND_ICON_WIDTH: 10,
	  LEGEND_ICON_HEIGHT: 10,
	  /** lgend label left padding */
	  LEGEND_LABEL_LEFT_PADDING: 8,
	  /** vertical legend right padding */
	  LEGEND_V_LABEL_RIGHT_PADDING: 20,
	  /** horizontal legend right padding */
	  LEGEND_H_LABEL_RIGHT_PADDING: 25,
	  /** lgend line icon svg path */
	  LEGEND_LINE_ICON_PATH: 'M1,9 L1,3 C1,1.8954305 1.8954305,1 3,1 L3,1 C4.1045695,1 5,1.8954305 5,3 L5,7 C5,8.1045695 5.8954305,9 7,9 L7,9 C8.1045695,9 9,8.1045695 9,7 L9,1',
	  MIN_LEGEND_WIDTH: 100,
	  /** map legend area padding */
	  MAP_LEGEND_AREA_PADDING_WIDE: 22,
	  /** vertical map legend area padding */
	  VERTICAL_MAP_LEGEND_AREA_TOP_PADDING: 26,
	  /** map legend padding before spectrum graph area */
	  MAP_LEGEND_AREA_PADDING_NARROW: 10,
	  /** map legend tooltip vertical padding */
	  MAP_LEGEND_TOOLTIP_VERTICAL_PADDING: 4,
	  /** map legend tooltip horizontal padding */
	  MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING: 6,
	  /** map legend wedge size */
	  MAP_LEGEND_WEDGE_SIZE: 4,
	  /** map legend padding between wedge and spectrum graph */
	  MAP_LEGEND_PADDING_BTW_GRAPH_AND_WEDGE: 4,
	  /** vertical map legend height */
	  VERTICAL_MAP_LEGEND_HEIGHT: 320,
	  /** horizontal map legend height */
	  HORIZONTAL_MAP_LEGEND_WIDTH: 400,
	  /** map legend graph size */
	  MAP_LEGEND_GRAPH_SIZE: 6,
	  /** map legend label padding */
	  MAP_LEGEND_LABEL_PADDING: 5,
	  CIRCLE_LEGEND_LABEL_FONT_SIZE: 9,
	  CIRCLE_LEGEND_PADDING: 10,
	  HALF_RATIO: 0.5,
	  AXIS_BACKGROUND_RIGHT_PADDING: 4,
	  /** X-AXIS LABEL PADDING */
	  X_AXIS_LABEL_PADDING: 7,
	  /** X-AXIS title padding */
	  X_AXIS_TITLE_PADDING: 5,
	  /** Y-AXIS LABEL PADDING */
	  Y_AXIS_LABEL_PADDING: 17,
	  Y_AXIS_TITLE_PADDING: 7,
	  /** rotations degree candidates */
	  DEGREE_CANDIDATES: [25, 45, 65, 85],
	  /**
	   * auto tick interval
	   * @type {string}
	   */
	  TICK_INTERVAL_AUTO: 'auto',
	  /** yAxis align option
	   * @type {string}
	   */
	  YAXIS_ALIGN_CENTER: 'center',
	  /** xAxis label gutter */
	  XAXIS_LABEL_GUTTER: 2,
	  /**
	   * Standard multiple nums of axis
	   * @type {Array}
	   */
	  AXIS_STANDARD_MULTIPLE_NUMS: [1, 2, 5, 10, 20, 50, 100],
	  /**
	   * Last standard multiple num of axis
	   */
	  AXIS_LAST_STANDARD_MULTIPLE_NUM: 100,
	  AXIS_EDGE_RATIO: 8,
	  /** label padding top */
	  LABEL_PADDING_TOP: 7,
	  /** line margin top */
	  LINE_MARGIN_TOP: 14,
	  /** tooltip gap */
	  TOOLTIP_GAP: 5,
	  /** tooltip direction
	   * @type {string}
	   */
	  TOOLTIP_DIRECTION_FORWARD: 'forword',
	  /** @type {string} */
	  TOOLTIP_DIRECTION_CENTER: 'center',
	  /** @type {string} */
	  TOOLTIP_DIRECTION_BACKWARD: 'backword',
	  /** tooltip align options
	   * @type {string}
	   */
	  TOOLTIP_DEFAULT_ALIGN_OPTION: 'center top',
	  /** @type {string} */
	  TOOLTIP_DEFAULT_HORIZONTAL_ALIGN_OPTION: 'right middle',
	  /** @type {string} */
	  TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION: 'right middle',
	  /** @type {string} */
	  TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION: 'center bottom',
	  /** hide delay */
	  HIDE_DELAY: 200,
	  OLD_BROWSER_OPACITY_100: 100,
	  SERIES_LABEL_OPACITY: 0.3,
	  WHEEL_TICK: 120,
	  MAX_ZOOM_MAGN: 5,
	  ZOOM_POSITION_TOP_EXIST_TITLE: 5,
	  ZOOM_POSITION_TOP_NONE_TITLE: 1,
	  FF_WHEELDELTA_ADJUSTING_VALUE: -40,
	  IE7_ROTATION_FILTER_STYLE_MAP: {
	    25: " style=\"filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod='auto expand'," + ' M11=0.9063077870366499, M12=0.42261826174069944, M21=-0.42261826174069944, M22=0.9063077870366499)"',
	    45: " style=\"filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod='auto expand'," + ' M11=0.7071067811865476, M12=0.7071067811865475, M21=-0.7071067811865475, M22=0.7071067811865476)"',
	    65: " style=\"filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod='auto expand'," + ' M11=0.42261826174069944, M12=0.9063077870366499, M21=-0.9063077870366499, M22=0.42261826174069944)"',
	    85: " style=\"filter: progid:DXImageTransform.Microsoft.Matrix(SizingMethod='auto expand'," + ' M11=0.08715574274765814, M12=0.9961946980917455, M21=-0.9961946980917455, M22=0.08715574274765814)"'
	  },
	  /** prefix for public event
	   * @type {string}
	   */
	  PUBLIC_EVENT_PREFIX: 'public_',
	  /** public event map
	   * @type {object}
	   */
	  PUBLIC_EVENT_MAP: {
	    load: true,
	    selectLegend: true,
	    selectSeries: true,
	    unselectSeries: true,
	    beforeShowTooltip: true,
	    afterShowTooltip: true,
	    beforeHideTooltip: true,
	    changeCheckedLegends: true,
	    zoom: true
	  },
	  /** for radial */
	  RADIAL_PLOT_PADDING: 15, // Prevent cross paper boundaries by line width
	  RADIAL_MARGIN_FOR_CATEGORY: 60,
	  RADIAL_CATEGORY_PADDING: 20,
	
	  COMPONENT_TYPE_DOM: 'DOM',
	  COMPONENT_TYPE_RAPHAEL: 'Raphael',
	
	  IMAGE_EXTENSIONS: ['png', 'jpeg'],
	  DATA_EXTENSIONS: ['xls', 'csv'],
	
	  GUIDE_AREACHART_AREAOPACITY_TYPE: 'areaOpacity should be a number between 0 and 1',
	
	  /** for bullet */
	  BULLET_TYPE_ACTUAL: 'Actual',
	  BULLET_TYPE_RANGE: 'Ranges',
	  BULLET_TYPE_MARKER: 'Markers',
	  BULLET_MARKER_STROKE_TICK: 3,
	  BULLET_MARKER_BUFFER_POSITION: 5,
	  BULLET_RANGES_HEIGHT_RATIO: 0.7,
	  BULLET_ACTUAL_HEIGHT_RATIO: 0.28,
	  BULLET_MARKERS_HEIGHT_RATIO: 0.55,
	  BULLET_MARKER_DETECT_PADDING: 3
	};

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * @fileoverview DOM Handler.
	                                                                                                                                                                                                     * @author NHN.
	                                                                                                                                                                                                     *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                     */
	
	/**
	 * DOM Handler.
	 * @module domHandler
	 * @private */
	exports['default'] = {
	  /**
	   * Create element.
	   * @memberOf module:domHandler
	   * @param {string} tag html tag
	   * @param {string} newClass class name
	   * @returns {HTMLElement} created element
	   */
	  create: function create(tag, newClass) {
	    var el = document.createElement(tag);
	
	    if (newClass) {
	      this.addClass(el, newClass);
	    }
	
	    return el;
	  },
	
	
	  /**
	   * Get class names.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} el target element
	   * @returns {Array} names
	   * @private
	   */
	  _getClassNames: function _getClassNames(el) {
	    var className = void 0;
	    var classNames = void 0;
	
	    if (el.classList) {
	      classNames = [].concat(_toConsumableArray(el.classList));
	    } else {
	      className = el.className || '';
	      classNames = className && _tuiCodeSnippet2['default'].isString(className) ? className.split(' ') : [];
	    }
	
	    return classNames;
	  },
	
	
	  /**
	   * Add css class to target element.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} el target element
	   * @param {string} newClass add class name
	   */
	  addClass: function addClass(el, newClass) {
	    if (!el || !newClass) {
	      return;
	    }
	
	    var classNames = this._getClassNames(el);
	    var index = _tuiCodeSnippet2['default'].inArray(newClass, classNames);
	
	    if (index > -1) {
	      return;
	    }
	
	    classNames.push(newClass);
	    el.className = classNames.join(' ');
	  },
	
	
	  /**
	   * Remove css class from target element.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} el target element
	   * @param {string} rmClass remove class name
	   */
	  removeClass: function removeClass(el, rmClass) {
	    var classNames = this._getClassNames(el);
	    var index = _tuiCodeSnippet2['default'].inArray(rmClass, classNames);
	
	    if (index === -1) {
	      return;
	    }
	
	    classNames.splice(index, 1);
	    el.className = classNames.join(' ');
	  },
	
	
	  /**
	   * Whether class exist or not.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} el target element
	   * @param {string} findClass target css class
	   * @returns {boolean} has class
	   */
	  hasClass: function hasClass(el, findClass) {
	    var classNames = this._getClassNames(el);
	    var index = _tuiCodeSnippet2['default'].inArray(findClass, classNames);
	
	    return index > -1;
	  },
	
	
	  /**
	   * Find parent by class name.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} el target element
	   * @param {string} className target css class
	   * @param {string} lastClass last css class
	   * @returns {HTMLElement} result element
	   */
	  findParentByClass: function findParentByClass(el, className, lastClass) {
	    var parent = el.parentNode;
	    var result = void 0;
	
	    if (!parent) {
	      result = null;
	    } else if (this.hasClass(parent, className)) {
	      result = parent;
	    } else if (parent.nodeName === 'BODY' || this.hasClass(parent, lastClass)) {
	      result = null;
	    } else {
	      result = this.findParentByClass(parent, className, lastClass);
	    }
	
	    return result;
	  },
	
	
	  /**
	   * Append child element.
	   * @memberOf module:domHandler
	   * @param {HTMLElement} container container element
	   * @param {HTMLElement} children child element
	   */
	  append: function append(container, children) {
	    if (!container || !children) {
	      return;
	    }
	    children = _tuiCodeSnippet2['default'].isArray(children) ? children : [children];
	
	    _tuiCodeSnippet2['default'].forEachArray(children, function (child) {
	      if (!child) {
	        return;
	      }
	      container.appendChild(child);
	    });
	  }
	};

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * @fileoverview Util for array.
	                                                                                                                                                                                                     * @author NHN.
	                                                                                                                                                                                                     *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                     */
	
	
	/**
	 * Pick minimum value from value array.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr value array
	 * @param {?function} condition condition function
	 * @param {?object} context target context
	 * @returns {*} minimum value
	 */
	function min(arr, condition, context) {
	  var result = void 0;
	
	  if (!condition) {
	    result = Math.min.apply(Math, _toConsumableArray(arr));
	  } else {
	    var _arr = _slicedToArray(arr, 1);
	
	    result = _arr[0];
	
	    var rest = arr.slice(1);
	    var minValue = condition.call(context, result, 0);
	
	    rest.forEach(function (item, index) {
	      var compareValue = condition.call(context, item, index + 1);
	      if (compareValue < minValue) {
	        minValue = compareValue;
	        result = item;
	      }
	    });
	  }
	
	  return result;
	}
	
	/**
	 * Pick maximum value from value array.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr value array
	 * @param {?function} [condition] condition function
	 * @param {?object} [context] target context
	 * @returns {*} maximum value
	 */
	function max(arr, condition, context) {
	  var result = void 0;
	
	  if (!condition) {
	    result = Math.max.apply(Math, _toConsumableArray(arr));
	  } else {
	    var _arr2 = _slicedToArray(arr, 1);
	
	    result = _arr2[0];
	
	    var rest = arr.slice(1);
	    var maxValue = condition.call(context, result, 0);
	    _tuiCodeSnippet2['default'].forEachArray(rest, function (item, index) {
	      var compareValue = condition.call(context, item, index + 1);
	      if (compareValue > maxValue) {
	        maxValue = compareValue;
	        result = item;
	      }
	    });
	  }
	
	  return result;
	}
	
	/**
	 * Whether one of them is true or not.
	 * @memberOf module:arrayUtil
	 * @param {Array} collection target collection
	 * @param {function} condition condition function
	 * @param {?object} context target context
	 * @returns {boolean} result boolean
	 */
	function any(collection, condition, context) {
	  var result = false;
	  _tuiCodeSnippet2['default'].forEach(collection, function (item, key) {
	    if (condition.call(context, item, key, collection)) {
	      result = true;
	    }
	
	    return !result;
	  });
	
	  return result;
	}
	
	/**
	 * All of them is true or not.
	 * @memberOf module:arrayUtil
	 * @param {Array} collection target collection
	 * @param {function} condition condition function
	 * @param {?object} context target context
	 * @returns {boolean} result boolean
	 */
	function all(collection, condition, context) {
	  var result = !!(collection || []).length;
	  _tuiCodeSnippet2['default'].forEach(collection, function (item, key) {
	    if (!condition.call(context, item, key, collection)) {
	      result = false;
	    }
	
	    return result !== false;
	  });
	
	  return result;
	}
	
	/**
	 * Make unique values.
	 * @memberOf module:arrayUtil
	 * @param {Array} arr target array
	 * @param {?boolean} sorted whether sorted or not.
	 * @param {?function} iteratee iteratee function
	 * @param {?object} context target context
	 * @returns {Array} unique values
	 */
	function unique(arr, sorted, iteratee, context) {
	  var result = [];
	
	  if (!_tuiCodeSnippet2['default'].isBoolean(sorted)) {
	    context = iteratee;
	    iteratee = sorted;
	    sorted = false;
	  }
	
	  iteratee = iteratee || function (value) {
	    return value;
	  };
	
	  if (sorted) {
	    var prevValue = void 0;
	    _tuiCodeSnippet2['default'].forEachArray(arr, function (value, index) {
	      value = iteratee.call(context, value, index, arr);
	      if (!index || prevValue !== value) {
	        result.push(value);
	      }
	      prevValue = value;
	    });
	  } else {
	    _tuiCodeSnippet2['default'].forEachArray(arr, function (value, index) {
	      value = iteratee.call(context, value, index, arr);
	      if (_tuiCodeSnippet2['default'].inArray(value, result) === -1) {
	        result.push(value);
	      }
	    });
	  }
	
	  return result;
	}
	
	/**
	 * Array pivot.
	 * @memberOf module:arrayUtil
	 * @param {Array.<Array>} arr2d target 2d array
	 * @returns {Array.<Array>} pivoted 2d array
	 */
	function pivot(arr2d) {
	  var result = [];
	  var len = max(arr2d.map(function (arr) {
	    return arr.length;
	  }));
	
	  arr2d.forEach(function (arr) {
	    for (var index = 0; index < len; index += 1) {
	      if (!result[index]) {
	        result[index] = [];
	      }
	      result[index].push(arr[index]);
	    }
	  });
	
	  return result;
	}
	
	/**
	 * find index from date type array
	 * @memberOf module:arrayUtil
	 * @param {Array} dateArray date type value array
	 * @param {Date} date target date
	 * @returns {number} index
	 */
	function findIndexFromDateTypeArray(dateArray, date) {
	  var dateValue = Number(date);
	  var foundIndex = -1;
	
	  var _iteratorNormalCompletion = true;
	  var _didIteratorError = false;
	  var _iteratorError = undefined;
	
	  try {
	    for (var _iterator = dateArray.entries()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
	      var _step$value = _slicedToArray(_step.value, 2),
	          idx = _step$value[0],
	          value = _step$value[1];
	
	      if (Number(value) === dateValue) {
	        foundIndex = idx;
	        break;
	      }
	    }
	  } catch (err) {
	    _didIteratorError = true;
	    _iteratorError = err;
	  } finally {
	    try {
	      if (!_iteratorNormalCompletion && _iterator['return']) {
	        _iterator['return']();
	      }
	    } finally {
	      if (_didIteratorError) {
	        throw _iteratorError;
	      }
	    }
	  }
	
	  return foundIndex;
	}
	
	exports['default'] = {
	  min: min,
	  max: max,
	  any: any,
	  all: all,
	  unique: unique,
	  pivot: pivot,
	  findIndexFromDateTypeArray: findIndexFromDateTypeArray
	};

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _templateObject = _taggedTemplateLiteral(['\n            M', ',', '\n            V', '\n        '], ['\n            M', ',', '\n            V', '\n        ']);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _taggedTemplateLiteral(strings, raw) { return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael boxplot chart renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var EDGE_LINE_WIDTH = 1;
	var MEDIAN_LINE_WIDTH = 1;
	var WHISKER_LINE_WIDTH = 1;
	
	/**
	 * @classdesc RaphaelBoxplotChart is graph renderer for bar, column chart.
	 * @class RaphaelBoxplotChart
	 * @private
	 */
	
	var RaphaelBoxplotChart = function () {
	  function RaphaelBoxplotChart() {
	    _classCallCheck(this, RaphaelBoxplotChart);
	  }
	
	  /**
	   * Render function of bar chart
	   * @param {object} paper paper object
	   * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	   * @returns {Array.<object>} seriesSet
	   */
	  RaphaelBoxplotChart.prototype.render = function render(paper, data) {
	    var groupBounds = data.groupBounds;
	
	
	    if (!groupBounds) {
	      return null;
	    }
	
	    this.paper = paper;
	
	    this.theme = data.theme;
	    this.options = data.options;
	    this.seriesDataModel = data.seriesDataModel;
	    this.chartType = data.chartType;
	    this.animationDuration = data.options.animationDuration;
	
	    this.paper.setStart();
	    this.groupWhiskers = [];
	    this.groupMedians = [];
	    this.groupBoxes = this._renderBoxplots(groupBounds);
	    this.groupBorders = this._renderBoxBorders(groupBounds);
	
	    this.circleOverlay = this._renderCircleOverlay();
	    this.groupBounds = groupBounds;
	
	    return this.paper.setFinish();
	  };
	
	  /**
	   * Render overlay.
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderCircleOverlay = function _renderCircleOverlay() {
	    var position = {
	      left: 0,
	      top: 0
	    };
	    var attributes = {
	      'fill-opacity': 0
	    };
	
	    return _raphaelRenderUtil2['default'].renderCircle(this.paper, position, 0, _tuiCodeSnippet2['default'].extend({
	      'stroke-width': 0
	    }, attributes));
	  };
	
	  /**
	   * Render rect
	   * @param {{left: number, top: number, width: number, height: number}} bound bound
	   * @param {string} color series color
	   * @param {object} [attributes] - attributes
	   * @returns {object} bar rect
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderBox = function _renderBox(bound, color, attributes) {
	    if (bound.width < 0 || bound.height < 0) {
	      return null;
	    }
	
	    var rect = _raphaelRenderUtil2['default'].renderRect(this.paper, bound, _tuiCodeSnippet2['default'].extend({
	      fill: color,
	      stroke: 'none'
	    }, attributes));
	
	    return rect;
	  };
	
	  /**
	   * Render boxes.
	   * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	   * @returns {Array.<Array.<object>>} bars
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderBoxes = function _renderBoxes(groupBounds) {
	    var _this = this;
	
	    var colors = this.theme.colors;
	    var colorByPoint = this.options.colorByPoint;
	
	
	    return groupBounds.map(function (bounds, groupIndex) {
	      return bounds.map(function (bound, index) {
	        if (!bound) {
	          return null;
	        }
	
	        var item = _this.seriesDataModel.getSeriesItem(groupIndex, index);
	        var color = colorByPoint ? colors[groupIndex] : colors[index];
	        var boundStart = _this.animationDuration ? bound.start : bound.end;
	        var rect = void 0;
	
	        if (boundStart) {
	          rect = _this._renderBox(boundStart, color);
	        }
	
	        return {
	          rect: rect,
	          color: color,
	          bound: bound.end,
	          item: item,
	          groupIndex: groupIndex,
	          index: index
	        };
	      });
	    });
	  };
	
	  /**
	   * Render boxplots.
	   * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	   * @returns {Array.<Array.<object>>} bars
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderBoxplots = function _renderBoxplots(groupBounds) {
	    var groupBoxes = this._renderBoxes(groupBounds);
	
	    this.groupWhiskers = this._renderWhiskers(groupBounds);
	    this.groupMedians = this._renderMedianLines(groupBounds);
	    this.groupOutliers = this._renderOutliers(groupBounds);
	
	    return groupBoxes;
	  };
	
	  RaphaelBoxplotChart.prototype._renderWhisker = function _renderWhisker(end, start, color) {
	    var paper = this.paper,
	        animationDuration = this.animationDuration;
	
	    var topDistance = start.top - end.top;
	    var whiskerDirection = topDistance > 0 ? 1 : -1;
	    var left = end.left,
	        width = end.width;
	
	    var quartileWidth = width / 4;
	    var edgePath = 'M' + (left + quartileWidth) + ',' + end.top + 'H' + (left + quartileWidth * 3);
	    var whiskerPath = _renderUtil2['default'].oneLineTrim(_templateObject, left + quartileWidth * 2, end.top, end.top + Math.abs(topDistance) * whiskerDirection);
	
	    var edge = _raphaelRenderUtil2['default'].renderLine(paper, edgePath, color, EDGE_LINE_WIDTH);
	    var whisker = _raphaelRenderUtil2['default'].renderLine(paper, whiskerPath, color, WHISKER_LINE_WIDTH);
	    var whiskers = [];
	
	    edge.attr({
	      opacity: animationDuration ? 0 : 1
	    });
	    whisker.attr({
	      opacity: animationDuration ? 0 : 1
	    });
	
	    whiskers.push(edge);
	    whiskers.push(whisker);
	
	    return whiskers;
	  };
	
	  RaphaelBoxplotChart.prototype._renderWhiskers = function _renderWhiskers(groupBounds) {
	    var _this2 = this;
	
	    var colors = this.theme.colors;
	    var colorByPoint = this.options.colorByPoint;
	
	    var groupWhiskers = [];
	
	    groupBounds.forEach(function (bounds, groupIndex) {
	      var whiskers = [];
	
	      bounds.forEach(function (bound, index) {
	        var color = colorByPoint ? colors[groupIndex] : colors[index];
	
	        if (!bound) {
	          return;
	        }
	
	        whiskers = whiskers.concat(_this2._renderWhisker(bound.min, bound.start, color));
	        whiskers = whiskers.concat(_this2._renderWhisker(bound.max, bound.end, color));
	      });
	
	      groupWhiskers.push(whiskers);
	    });
	
	    return groupWhiskers;
	  };
	
	  RaphaelBoxplotChart.prototype._renderMedianLine = function _renderMedianLine(bound) {
	    var width = bound.width;
	
	    var medianLinePath = 'M' + bound.left + ',' + bound.top + ',H' + (bound.left + width);
	    var median = _raphaelRenderUtil2['default'].renderLine(this.paper, medianLinePath, '#ffffff', MEDIAN_LINE_WIDTH);
	
	    median.attr({
	      opacity: this.animationDuration ? 0 : 1
	    });
	
	    return median;
	  };
	
	  RaphaelBoxplotChart.prototype._renderMedianLines = function _renderMedianLines(groupBounds) {
	    var _this3 = this;
	
	    var groupMedians = [];
	
	    groupBounds.forEach(function (bounds) {
	      var medians = [];
	
	      bounds.forEach(function (bound) {
	        if (!bound) {
	          return;
	        }
	
	        medians.push(_this3._renderMedianLine(bound.median));
	      });
	      groupMedians.push(medians);
	    });
	
	    return groupMedians;
	  };
	
	  RaphaelBoxplotChart.prototype._renderOutlier = function _renderOutlier(bound, color) {
	    var outlier = _raphaelRenderUtil2['default'].renderCircle(this.paper, {
	      left: bound.left,
	      top: bound.top
	    }, 3.5, {
	      stroke: color,
	      'stroke-width': 2
	    });
	
	    outlier.attr({
	      opacity: this.animationDuration ? 0 : 1
	    });
	
	    return outlier;
	  };
	
	  RaphaelBoxplotChart.prototype._renderOutliers = function _renderOutliers(groupBounds) {
	    var _this4 = this;
	
	    var colors = this.theme.colors;
	    var colorByPoint = this.options.colorByPoint;
	
	    var groupOutliers = [];
	
	    groupBounds.forEach(function (bounds, groupIndex) {
	      var outliers = [];
	      bounds.forEach(function (bound, index) {
	        var color = colorByPoint ? colors[groupIndex] : colors[index];
	        var seriesOutliers = [];
	
	        if (!bound) {
	          return;
	        }
	
	        if (bound.outliers.length) {
	          bound.outliers.forEach(function (outlier) {
	            seriesOutliers.push(_this4._renderOutlier(outlier, color));
	          });
	        }
	        outliers.push(seriesOutliers);
	      });
	      groupOutliers.push(outliers);
	    });
	
	    return groupOutliers;
	  };
	
	  /**
	   * Make rect points.
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @returns {{
	   *      leftTop: {left: number, top: number},
	   *      rightTop: {left: number, top: number},
	   *      rightBottom: {left: number, top: number},
	   *      leftBottom: {left: number, top: number}
	   * }} rect points
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._makeRectPoints = function _makeRectPoints(bound) {
	    return {
	      leftTop: {
	        left: Math.ceil(bound.left),
	        top: Math.ceil(bound.top)
	      },
	      rightTop: {
	        left: Math.ceil(bound.left + bound.width),
	        top: Math.ceil(bound.top)
	      },
	      rightBottom: {
	        left: Math.ceil(bound.left + bound.width),
	        top: Math.ceil(bound.top + bound.height)
	      },
	      leftBottom: {
	        left: Math.ceil(bound.left),
	        top: Math.ceil(bound.top + bound.height)
	      }
	    };
	  };
	
	  /**
	   * Render border lines;
	   * @param {{left: number, top:number, width: number, height: number}} bound bar bound
	   * @param {string} borderColor border color
	   * @param {string} chartType chart type
	   * @param {Item} item item
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderBorderLines = function _renderBorderLines(bound, borderColor, chartType, item) {
	    var _this5 = this;
	
	    var borderLinePaths = this._makeBorderLinesPaths(bound, chartType, item);
	    var lines = {};
	
	    Object.entries(borderLinePaths).forEach(function (_ref) {
	      var _ref2 = _slicedToArray(_ref, 2),
	          name = _ref2[0],
	          path = _ref2[1];
	
	      lines[name] = _raphaelRenderUtil2['default'].renderLine(_this5.paper, path, borderColor, 1);
	    });
	
	    return lines;
	  };
	
	  /**
	   * Render bar borders.
	   * @param {Array.<Array.<{left: number, top:number, width: number, height: number}>>} groupBounds bounds
	   * @returns {Array.<Array.<object>>} borders
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._renderBoxBorders = function _renderBoxBorders(groupBounds) {
	    var _this6 = this;
	
	    var borderColor = this.theme.borderColor;
	
	
	    if (!borderColor) {
	      return null;
	    }
	
	    var groupBorders = groupBounds.map(function (bounds, groupIndex) {
	      return bounds.map(function (bound, index) {
	        if (!bound) {
	          return null;
	        }
	        var seriesItem = _this6.seriesDataModel.getSeriesItem(groupIndex, index);
	
	        return _this6._renderBorderLines(bound.start, borderColor, _this6.chartType, seriesItem);
	      });
	    });
	
	    return groupBorders;
	  };
	
	  /**
	   * Animate rect.
	   * @param {object} rect raphael object
	   * @param {{left: number, top:number, width: number, height: number}} bound rect bound
	   * @param {number} duration animation duration
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._animateRect = function _animateRect(rect, bound, duration) {
	    rect.animate({
	      x: bound.left,
	      y: bound.top,
	      width: bound.width,
	      height: bound.height
	    }, duration, '>');
	  };
	
	  /**
	   * Animate.
	   * @param {function} onFinish finish callback function
	   */
	
	
	  RaphaelBoxplotChart.prototype.animate = function animate(onFinish) {
	    var _this7 = this;
	
	    if (this.animationDuration) {
	      var animation = _raphael2['default'].animation({
	        opacity: 1
	      }, this.animationDuration);
	
	      _raphaelRenderUtil2['default'].forEach2dArray(this.groupBoxes, function (box) {
	        if (!box) {
	          return;
	        }
	        _this7._animateRect(box.rect, box.bound, _this7.animationDuration);
	      });
	
	      _raphaelRenderUtil2['default'].forEach2dArray(this.groupWhiskers, function (whisker) {
	        whisker.animate(animation.delay(_this7.animationDuration));
	      });
	
	      _raphaelRenderUtil2['default'].forEach2dArray(this.groupMedians, function (median) {
	        median.animate(animation.delay(_this7.animationDuration));
	      });
	
	      _raphaelRenderUtil2['default'].forEach2dArray(this.groupOutliers, function (outliers) {
	        outliers.forEach(function (outlier) {
	          outlier.animate(animation.delay(_this7.animationDuration));
	        });
	      });
	
	      if (onFinish) {
	        this.callbackTimeout = setTimeout(function () {
	          onFinish();
	          delete _this7.callbackTimeout;
	        }, this.animationDuration);
	      }
	    }
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelBoxplotChart.prototype.showAnimation = function showAnimation(data) {
	    if (_tuiCodeSnippet2['default'].isNumber(data.outlierIndex)) {
	      this.showOutlierAnimation(data);
	    } else {
	      this.showRectAnimation(data);
	    }
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelBoxplotChart.prototype.showRectAnimation = function showRectAnimation(data) {
	    var bar = this.groupBoxes[data.groupIndex][data.index];
	    this.hoveredBar = bar.rect;
	
	    this.hoveredBar.attr({
	      stroke: '#ffffff',
	      'stroke-width': 4
	    });
	    this.hoveredBar.node.setAttribute('filter', 'url(#shadow)');
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelBoxplotChart.prototype.showOutlierAnimation = function showOutlierAnimation(data) {
	    var targetAttr = this.groupOutliers[data.groupIndex][data.index][data.outlierIndex].attr();
	
	    this.circleOverlay.attr({
	      r: targetAttr.r,
	      cx: targetAttr.cx,
	      cy: targetAttr.cy,
	      fill: targetAttr.stroke,
	      'fill-opacity': 1,
	      stroke: targetAttr.stroke,
	      'stroke-width': 4
	    });
	  };
	
	  /**
	   * Hide animation.
	   */
	
	
	  RaphaelBoxplotChart.prototype.hideAnimation = function hideAnimation() {
	    this.circleOverlay.attr({
	      width: 1,
	      height: 1,
	      x: 0,
	      y: 0,
	      'fill-opacity': 0,
	      'stroke-width': 2
	    });
	    this.hoveredBar.attr({
	      stroke: 'none'
	    });
	    this.hoveredBar.node.setAttribute('filter', 'none');
	  };
	
	  /**
	   * Update rect bound
	   * @param {object} rect raphael object
	   * @param {{left: number, top: number, width: number, height: number}} bound bound
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._updateRectBound = function _updateRectBound(rect, bound) {
	    rect.attr({
	      x: bound.left,
	      y: bound.top,
	      width: bound.width,
	      height: bound.height
	    });
	  };
	
	  /**
	   * Resize graph of bar type chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{
	   *                  left:number, top:number, width: number, height: number
	   *              }>>} params.groupBounds group bounds
	   */
	
	
	  RaphaelBoxplotChart.prototype.resize = function resize(params) {
	    var dimension = params.dimension,
	        groupBounds = params.groupBounds;
	
	
	    this.groupBounds = groupBounds;
	    this.paper.setSize(dimension.width, dimension.height);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupBoxes, function (bar, groupIndex, index) {
	      if (!bar) {
	        return;
	      }
	
	      var bound = groupBounds[groupIndex][index].end;
	      bar.bound = bound;
	      _raphaelRenderUtil2['default'].updateRectBound(bar.rect, bound);
	    });
	  };
	
	  /**
	   * Change borders color.
	   * @param {Array.<object>} lines raphael objects
	   * @param {borderColor} borderColor border color
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._changeBordersColor = function _changeBordersColor(lines, borderColor) {
	    lines.forEach(function (line) {
	      line.attr({ stroke: borderColor });
	    });
	  };
	
	  /**
	   * Change bar color.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {string} color fill color
	   * @param {?string} borderColor stroke color
	   * @private
	   */
	
	
	  RaphaelBoxplotChart.prototype._changeBoxColor = function _changeBoxColor(indexes, color, borderColor) {
	    var bar = this.groupBoxes[indexes.groupIndex][indexes.index];
	
	    bar.rect.attr({
	      stroke: color
	    });
	
	    if (borderColor) {
	      var lines = this.groupBorders[indexes.groupIndex][indexes.index];
	      this._changeBordersColor(lines, borderColor);
	    }
	  };
	
	  /**
	   * Select series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelBoxplotChart.prototype.selectSeries = function selectSeries(indexes) {
	    var bar = this.groupBoxes[indexes.groupIndex][indexes.index];
	    var objColor = _raphael2['default'].color(bar.color);
	    var selectionColorTheme = this.theme.selectionColor;
	    var makeColor = _raphaelRenderUtil2['default'].makeChangedLuminanceColor;
	    var color = selectionColorTheme || makeColor(objColor.hex, DEFAULT_LUMINANC);
	    var borderColor = this.theme.borderColor;
	
	
	    if (borderColor) {
	      var objBorderColor = _raphael2['default'].color(borderColor);
	      borderColor = _raphaelRenderUtil2['default'].makeChangedLuminanceColor(objBorderColor.hex, DEFAULT_LUMINANC);
	    }
	
	    this._changeBoxColor(indexes, color, borderColor);
	  };
	
	  /**
	   * Unselect series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelBoxplotChart.prototype.unselectSeries = function unselectSeries(indexes) {
	    var bar = this.groupBoxes[indexes.groupIndex][indexes.index];
	    var borderColor = this.theme.borderColor;
	
	    this._changeBoxColor(indexes, bar.color, borderColor);
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelBoxplotChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupBoxes, function (box, groupIndex, index) {
	      if (!box) {
	        return;
	      }
	
	      var opacity = noneSelected || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      box.rect.attr({ 'stroke-opacity': opacity });
	    });
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupWhiskers, function (whisker, groupIndex, index) {
	      var opacity = noneSelected || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      whisker.attr({ 'stroke-opacity': opacity });
	    });
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupMedians, function (median, groupIndex, index) {
	      var opacity = noneSelected || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      median.attr({ 'stroke-opacity': opacity });
	    });
	  };
	
	  RaphaelBoxplotChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, groupPositions, groupLabels, labelTheme, isStacked) {
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      opacity: 0,
	      'text-anchor': isStacked ? 'middle' : 'start'
	    };
	    var labelSet = paper.set();
	
	    groupLabels.forEach(function (categoryLabel, categoryIndex) {
	      categoryLabel.forEach(function (label, seriesIndex) {
	        var position = groupPositions[categoryIndex][seriesIndex];
	        var endLabel = _raphaelRenderUtil2['default'].renderText(paper, position.end, label.end, attributes);
	
	        endLabel.node.style.userSelect = 'none';
	        endLabel.node.style.cursor = 'default';
	        endLabel.node.setAttribute('filter', 'url(#glow)');
	
	        labelSet.push(endLabel);
	
	        if (position.start) {
	          var startLabel = _raphaelRenderUtil2['default'].renderText(paper, position.start, label.start, attributes);
	          startLabel.node.style.userSelect = 'none';
	          startLabel.node.style.cursor = 'default';
	          startLabel.node.setAttribute('filter', 'url(#glow)');
	
	          labelSet.push(startLabel);
	        }
	      });
	    });
	
	    return labelSet;
	  };
	
	  return RaphaelBoxplotChart;
	}();
	
	exports['default'] = RaphaelBoxplotChart;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael bullet chart renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var EVENT_DETECTOR_PADDING = 20;
	
	/**
	 * @classdesc RaphaelBulletChart is graph renderer for bullet chart.
	 * @class RaphaelBulletChart
	 * @private
	 */
	
	var RaphaelBulletChart = function () {
	  function RaphaelBulletChart() {
	    _classCallCheck(this, RaphaelBulletChart);
	  }
	
	  /**
	   * Render function of bar chart
	   * @param {object} paper paper object
	   * @param {{size: object, model: object, options: object, tooltipPosition: string}} data chart data
	   * @returns {Array.<object>} seriesSet
	   */
	  RaphaelBulletChart.prototype.render = function render(paper, data) {
	    var groupBounds = data.groupBounds,
	        seriesDataModel = data.seriesDataModel;
	
	
	    if (!groupBounds || !groupBounds.length) {
	      return null;
	    }
	
	    this.paper = paper;
	    this.theme = data.theme;
	    this.dimension = data.dimension;
	    this.position = data.position;
	    this.options = data.options;
	    this.chartType = data.chartType;
	    this.isVertical = data.isVertical;
	    this.animationDuration = data.options.animationDuration;
	
	    this.seriesDataModel = seriesDataModel;
	    this.maxRangeCount = seriesDataModel.maxRangeCount;
	    this.maxMarkerCount = seriesDataModel.maxMarkerCount;
	
	    this._graphColors = [];
	
	    this.rangeOpacities = {};
	
	    this.paper.setStart();
	
	    this._renderBounds(groupBounds);
	
	    return this.paper.setFinish();
	  };
	
	  /**
	   * Get range opacity by index
	   * If rangeOpacities[index] not exists, create and store. then use it next time
	   * @param {number} index - ranges index
	   * @returns {number} - opacity of ranges bar at index
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._getRangeOpacity = function _getRangeOpacity(index) {
	    var maxRangeCount = this.maxRangeCount;
	
	    if (this.prevMaxRangeCount !== maxRangeCount) {
	      this._updateOpacityStep(maxRangeCount);
	    }
	
	    if (index < maxRangeCount && !this.rangeOpacities[index]) {
	      this.rangeOpacities[index] = 1 - this.opacityStep * (index + 1);
	    }
	
	    return this.rangeOpacities[index];
	  };
	
	  /**
	   * Update opacity step using maxRangeCount
	   * @param {number} maxRangeCount - maximum count of ranges bar among series graphes
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._updateOpacityStep = function _updateOpacityStep(maxRangeCount) {
	    this.rangeOpacities = {};
	    this.opacityStep = Number(1 / (maxRangeCount + 1)).toFixed(2);
	    this.prevMaxRangeCount = maxRangeCount;
	  };
	
	  /**
	   * Render bullet graph using groupBounds model
	   * @param {Array.<object>} groupBounds - bounds data for rendering bullet graph
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderBounds = function _renderBounds(groupBounds) {
	    var _this = this;
	
	    var rangeThemes = this.theme.ranges;
	    var paper = this.paper;
	
	
	    this.groupBars = [];
	    this.groupLines = [];
	
	    groupBounds.forEach(function (bounds, groupIndex) {
	      var seriesColor = _this.theme.colors[groupIndex];
	      var rangeIndex = 0;
	      var barSet = paper.set();
	      var lineSet = paper.set();
	
	      bounds.forEach(function (bound) {
	        var type = bound.type;
	
	
	        if (type === _const2['default'].BULLET_TYPE_ACTUAL) {
	          barSet.push(_this._renderActual(bound, seriesColor));
	        } else if (type === _const2['default'].BULLET_TYPE_RANGE) {
	          barSet.push(_this._renderRange(bound, seriesColor, rangeIndex, rangeThemes[rangeIndex]));
	          rangeIndex += 1;
	        } else if (type === _const2['default'].BULLET_TYPE_MARKER) {
	          lineSet.push(_this._renderMarker(bound, seriesColor));
	        }
	      });
	
	      _this.groupBars.push(barSet);
	      _this.groupLines.push(lineSet);
	    }, this);
	  };
	
	  /**
	   * Render actual bar
	   * @param {object} bound - bound model on start point
	   * @param {string} seriesColor - series color for painting actual bar
	   * @returns {Element} - rendered actual bar
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderActual = function _renderActual(bound, seriesColor) {
	    if (!bound) {
	      return null;
	    }
	
	    return this._renderBar(bound, seriesColor);
	  };
	
	  /**
	   * Render range bar
	   * @param {object} bound - bound model on start point
	   * @param {string} seriesColor - series color for painting range bar
	   * @param {number} rangeIndex - ranges index
	   * @param {object} rangeTheme - range theme
	   * @returns {Element} - rendered range bar
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderRange = function _renderRange(bound, seriesColor, rangeIndex, rangeTheme) {
	    var opacity = this._getRangeOpacity(rangeIndex);
	    var attr = { opacity: opacity };
	    var color = seriesColor;
	
	    if (!bound) {
	      return null;
	    }
	
	    if (rangeTheme) {
	      color = rangeTheme.color || color;
	      attr.opacity = rangeTheme.opacity || opacity;
	    }
	
	    return this._renderBar(bound, color, attr);
	  };
	
	  /**
	   * Create bar type element using passing arguments
	   * @param {object} bound - bound data for render rect element
	   * @param {string} color - hex type color string
	   * @param {object} attributes - styling attributes
	   * @returns {Element} - svg rect element
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderBar = function _renderBar(bound, color, attributes) {
	    if (bound.width < 0 || bound.height < 0) {
	      return null;
	    }
	
	    return _raphaelRenderUtil2['default'].renderRect(this.paper, bound, _tuiCodeSnippet2['default'].extend({
	      fill: color,
	      stroke: 'none'
	    }, attributes));
	  };
	
	  /**
	   * Render marker
	   * @param {object} bound - bound model of marker
	   * @param {string} seriesColor - series color for painting marker
	   * @returns {Element} - rendered marker
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderMarker = function _renderMarker(bound, seriesColor) {
	    if (!bound) {
	      return null;
	    }
	
	    return this._renderLine(bound, seriesColor);
	  };
	
	  /**
	   * Create line element using passing arguments
	   * @param {object} bound - bound data for render path element
	   * @param {string} color - hex type color string
	   * @returns {Element} - svg rect element
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderLine = function _renderLine(bound, color) {
	    var top = bound.top,
	        left = bound.left,
	        length = bound.length;
	
	    var endPosition = this.isVertical ? 'L' + (left + length) + ',' + top : 'L' + left + ',' + (top + length);
	    var path = 'M' + left + ',' + (top + endPosition);
	
	    return _raphaelRenderUtil2['default'].renderLine(this.paper, path, color, _const2['default'].BULLET_MARKER_STROKE_TICK);
	  };
	
	  /**
	   * Animate.
	   * @param {function} onFinish finish callback function
	   * @param {Array.<object>} seriesSet series set
	   */
	
	
	  RaphaelBulletChart.prototype.animate = function animate(onFinish, seriesSet) {
	    var _this2 = this;
	
	    var paper = this.paper,
	        dimension = this.dimension,
	        position = this.position,
	        animationDuration = this.animationDuration;
	
	    var clipRectId = this._getClipRectId();
	    var clipRectWidth = dimension.width - EVENT_DETECTOR_PADDING;
	    var clipRectHeight = dimension.height - EVENT_DETECTOR_PADDING;
	    var startDimension = {};
	    var animateAttr = {};
	    var clipRect = this.clipRect;
	
	
	    if (this.isVertical) {
	      startDimension.width = clipRectWidth;
	      startDimension.height = animationDuration ? 0 : clipRectHeight;
	      animateAttr.height = clipRectHeight;
	    } else {
	      startDimension.width = animationDuration ? 0 : clipRectWidth;
	      startDimension.height = clipRectHeight;
	      animateAttr.width = clipRectWidth;
	    }
	
	    // Animation was implemented using <clipPath> SVG element
	    // As Browser compatibility of <clipPath> is IE9+,
	    // No Animation on IE8
	    if (!IS_LTE_IE8 && dimension) {
	      if (!clipRect) {
	        clipRect = createClipPathRectWithLayout(paper, position, startDimension, clipRectId);
	        this.clipRect = clipRect;
	      } else {
	        clipRect.attr({
	          x: position.left,
	          y: position.top
	        });
	        clipRect.attr(startDimension);
	      }
	
	      seriesSet.forEach(function (element) {
	        if (element.type === 'set') {
	          element.forEach(function (item) {
	            item.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	          });
	        } else {
	          element.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	        }
	      });
	
	      if (animationDuration) {
	        clipRect.animate(animateAttr, animationDuration, '>', onFinish);
	      }
	    }
	
	    if (onFinish) {
	      this.callbackTimeout = setTimeout(function () {
	        onFinish();
	        delete _this2.callbackTimeout;
	      }, animationDuration);
	    }
	  };
	
	  /**
	   * Resize bullet chart
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{
	   *                  left:number, top:number, width: number, height: number
	   *              }>>} params.groupBounds group bounds
	   */
	
	
	  RaphaelBulletChart.prototype.resize = function resize(params) {
	    var dimension = params.dimension,
	        groupBounds = params.groupBounds;
	    var width = dimension.width,
	        height = dimension.height;
	
	
	    this.dimension = params.dimension;
	    this.groupBounds = groupBounds;
	    this.resizeClipRect(width, height);
	    this.paper.setSize(width, height);
	  };
	
	  /**
	   * Resize clip rect size
	   * @param {number} width series width
	   * @param {number} height series height
	   */
	
	
	  RaphaelBulletChart.prototype.resizeClipRect = function resizeClipRect(width, height) {
	    var clipRect = this.paper.getById(this._getClipRectId() + '_rect');
	
	    // Animation was implemented using <clipPath> SVG element
	    // As Browser compatibility of <clipPath> is IE9+,
	    // No Animation on IE8
	    if (clipRect) {
	      clipRect.attr({
	        width: width,
	        height: height
	      });
	    }
	  };
	
	  /**
	   * Set clip rect id
	   * @returns {string} id - clip rect id
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._getClipRectId = function _getClipRectId() {
	    if (!this.clipRectId) {
	      this.clipRectId = _renderUtil2['default'].generateClipRectId();
	    }
	
	    return this.clipRectId;
	  };
	
	  /**
	   * Change borders color.
	   * @param {Array.<object>} lines raphael objects
	   * @param {borderColor} borderColor border color
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._changeBordersColor = function _changeBordersColor(lines, borderColor) {
	    lines.forEach(function (line) {
	      line.attr({ stroke: borderColor });
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelBulletChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var _this3 = this;
	
	    var allEmphasized = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    this.groupBars.forEach(function (bars, groupIndex) {
	      var opacity = allEmphasized || legendIndex === groupIndex ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      _this3.groupBars[groupIndex].attr({ 'fill-opacity': opacity });
	      _this3.groupLabels[groupIndex].attr({ opacity: opacity });
	
	      _this3.groupLabels[groupIndex].forEach(function (label) {
	        label.attr({ opacity: opacity });
	      });
	    });
	  };
	
	  /**
	   * @param {object} paper - raphael paper
	   * @param {Array.<object>} positionData - series label positions
	   * @param {Array.<string>} labelData - series labels
	   * @param {object} labelTheme - series text theme
	   * @returns {object} - rendered label set
	   */
	
	
	  RaphaelBulletChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, positionData, labelData, labelTheme) {
	    var _this4 = this;
	
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      opacity: 0,
	      'text-anchor': this.isVertical ? 'middle' : 'start'
	    };
	    var set = paper.set();
	
	    this.groupLabels = labelData.map(function (labels, groupIndex) {
	      var labelSet = paper.set();
	      labels.forEach(function (label, index) {
	        var labelElement = _this4._renderLabel(paper, positionData[groupIndex][index], attributes, label);
	        labelSet.push(labelElement);
	        set.push(labelElement);
	      });
	
	      return labelSet;
	    }, this);
	
	    return set;
	  };
	
	  /**
	   * @param {object} paper - raphael paper
	   * @param {Array.<object>} position - series label positions
	   * @param {Array.<string>} attributes - label text attributes
	   * @param {string} labelText - label text
	   * @returns {object} - rendered label object
	   * @private
	   */
	
	
	  RaphaelBulletChart.prototype._renderLabel = function _renderLabel(paper, position, attributes, labelText) {
	    var label = _raphaelRenderUtil2['default'].renderText(paper, position, labelText, attributes);
	    var node = label.node;
	    var style = node.style;
	
	    style.userSelect = 'none';
	    style.cursor = 'default';
	    node.setAttribute('filter', 'url(#glow)');
	
	    return label;
	  };
	
	  /**
	   * @param {number} index - series index
	   * @returns {Array.<object>} - color and opacity of series
	   */
	
	
	  RaphaelBulletChart.prototype.getGraphColors = function getGraphColors() {
	    var _this5 = this;
	
	    if (!this._graphColors.length) {
	      this._graphColors = this.groupBars.map(function (barSet, groupIndex) {
	        var barColors = [];
	        var markerCount = _this5.groupLines[groupIndex].length;
	
	        barSet.forEach(function (item) {
	          barColors.push(item.attrs.fill);
	        });
	
	        var legendColor = barColors[barColors.length - 1];
	
	        for (var i = 0; i <= markerCount; i += 1) {
	          barColors.push(legendColor);
	        }
	
	        return barColors;
	      });
	    }
	
	    return this._graphColors;
	  };
	
	  return RaphaelBulletChart;
	}();
	
	/**
	 * Create clip rect with layout
	 * @param {object} paper Raphael paper
	 * @param {object} position position
	 * @param {object} dimension dimension
	 * @param {string} id ID string
	 * @returns {object}
	 * @ignore
	 */
	
	
	function createClipPathRectWithLayout(paper, position, dimension, id) {
	  var clipPath = document.createElementNS('http://www.w3.org/2000/svg', 'clipPath');
	  var rect = paper.rect(position.left, position.top, dimension.width, dimension.height);
	
	  rect.id = id + '_rect';
	  clipPath.id = id;
	
	  clipPath.appendChild(rect.node);
	  paper.defs.appendChild(clipPath);
	
	  return rect;
	}
	
	exports['default'] = RaphaelBulletChart;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelLineTypeBase = __webpack_require__(15);
	
	var _raphaelLineTypeBase2 = _interopRequireDefault(_raphaelLineTypeBase);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Raphael line chart renderer.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	
	var RaphaelLineChart = function (_RaphaelLineBase) {
	  _inherits(RaphaelLineChart, _RaphaelLineBase);
	
	  /**
	   * RaphaelLineCharts is graph renderer for line chart.
	   * @constructs RaphaelLineChart
	   * @private
	   * @private
	   * @extends RaphaelLineTypeBase
	   */
	  function RaphaelLineChart() {
	    _classCallCheck(this, RaphaelLineChart);
	
	    /**
	     * selected legend index
	     * @type {?number}
	     */
	    var _this = _possibleConstructorReturn(this, _RaphaelLineBase.call(this));
	
	    _this.selectedLegendIndex = null;
	
	    /**
	     * type of chart
	     * @type {string}
	     */
	    _this.chartType = 'line';
	
	    /**
	     * Line width
	     * @type {number}
	     */
	    _this.lineWidth = 6;
	    return _this;
	  }
	
	  /**
	   * Render function of line chart.
	   * @param {object} [paper] - raphael paper
	   * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	   * @returns {object} paper raphael paper
	   */
	
	
	  RaphaelLineChart.prototype.render = function render(paper, data) {
	    var dimension = data.dimension,
	        groupPositions = data.groupPositions,
	        theme = data.theme,
	        options = data.options,
	        position = data.position;
	    var colors = theme.colors;
	
	    var opacity = options.showDot ? 1 : 0;
	    var isSpline = options.spline;
	    var lineWidth = this.lineWidth = _tuiCodeSnippet2['default'].isNumber(options.pointWidth) ? options.pointWidth : this.lineWidth;
	    var borderStyle = this.makeBorderStyle(theme.dot.strokeColor, opacity, theme.dot.strokeWidth);
	    var outDotStyle = this.makeOutDotStyle(opacity, borderStyle);
	    var groupPaths = void 0;
	
	    if (isSpline) {
	      groupPaths = this._getSplineLinesPath(groupPositions, options.connectNulls);
	    } else {
	      groupPaths = this._getLinesPath(groupPositions, options.connectNulls);
	    }
	
	    this.paper = paper;
	    this.theme = theme;
	    this.isSpline = isSpline;
	    this.dimension = dimension;
	    this.position = position;
	
	    paper.setStart();
	
	    this.groupLines = this._renderLines(paper, groupPaths, colors, lineWidth);
	    this.tooltipLine = this._renderTooltipLine(paper, dimension.height);
	    this.groupDots = this._renderDots(paper, groupPositions, colors, opacity);
	
	    if (options.allowSelect) {
	      this.selectionDot = this._makeSelectionDot(paper);
	      this.selectionColor = theme.selectionColor;
	    }
	    this.colors = colors;
	    this.borderStyle = borderStyle;
	    this.outDotStyle = outDotStyle;
	    this.groupPositions = groupPositions;
	    this.groupPaths = groupPaths;
	    this.dotOpacity = opacity;
	    this.animationDuration = options.animationDuration;
	
	    delete this.pivotGroupDots;
	
	    if (paper.raphael.svg) {
	      this.appendShadowFilterToDefs();
	    }
	
	    return paper.setFinish();
	  };
	
	  RaphaelLineChart.prototype.appendShadowFilterToDefs = function appendShadowFilterToDefs() {
	    var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	    var feOffset = document.createElementNS('http://www.w3.org/2000/svg', 'feOffset');
	    var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	    var feBlend = document.createElementNS('http://www.w3.org/2000/svg', 'feBlend');
	
	    filter.setAttributeNS(null, 'id', 'shadow');
	    filter.setAttributeNS(null, 'x', '-50%');
	    filter.setAttributeNS(null, 'y', '-50%');
	    filter.setAttributeNS(null, 'width', '180%');
	    filter.setAttributeNS(null, 'height', '180%');
	    feOffset.setAttributeNS(null, 'result', 'offOut');
	    feOffset.setAttributeNS(null, 'in', 'SourceAlpha');
	    feOffset.setAttributeNS(null, 'dx', '0');
	    feOffset.setAttributeNS(null, 'dy', '0');
	    feGaussianBlur.setAttributeNS(null, 'result', 'blurOut');
	    feGaussianBlur.setAttributeNS(null, 'in', 'offOut');
	    feGaussianBlur.setAttributeNS(null, 'stdDeviation', '2');
	    feBlend.setAttributeNS(null, 'in', 'SourceGraphic');
	    feBlend.setAttributeNS(null, 'in2', 'blurOut');
	    feBlend.setAttributeNS(null, 'mode', 'normal');
	    filter.appendChild(feOffset);
	    filter.appendChild(feGaussianBlur);
	    filter.appendChild(feBlend);
	    this.paper.defs.appendChild(filter);
	  };
	
	  /**
	   * Get lines path.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {Array.<Array.<string>>} path
	   * @private
	   */
	
	
	  RaphaelLineChart.prototype._getLinesPath = function _getLinesPath(groupPositions, connectNulls) {
	    var _this2 = this;
	
	    return groupPositions.map(function (positions) {
	      return _this2._makeLinesPath(positions, null, connectNulls);
	    });
	  };
	
	  /**
	   * Get spline lines path.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {Array} path
	   * @private
	   */
	
	
	  RaphaelLineChart.prototype._getSplineLinesPath = function _getSplineLinesPath(groupPositions, connectNulls) {
	    var _this3 = this;
	
	    return groupPositions.map(function (positions) {
	      return _this3._makeSplineLinesPath(positions, { connectNulls: connectNulls });
	    });
	  };
	
	  /**
	   * Render lines.
	   * @param {object} paper raphael paper
	   * @param {Array.<Array.<string>>} groupPaths paths
	   * @param {string[]} colors line colors
	   * @param {?number} strokeWidth stroke width
	   * @returns {Array.<Array.<object>>} lines
	   * @private
	   */
	
	
	  RaphaelLineChart.prototype._renderLines = function _renderLines(paper, groupPaths, colors, strokeWidth) {
	    return groupPaths.map(function (path, groupIndex) {
	      var color = colors[groupIndex] || 'transparent';
	      var line = _raphaelRenderUtil2['default'].renderLine(paper, path.join(' '), color, strokeWidth);
	      line.node.setAttribute('class', 'auto-shape-rendering');
	
	      return line;
	    });
	  };
	
	  /**
	   * Resize graph of line chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	   */
	
	
	  RaphaelLineChart.prototype.resize = function resize(params) {
	    var _this4 = this;
	
	    var dimension = params.dimension,
	        groupPositions = params.groupPositions;
	
	
	    this.resizeClipRect(dimension.width, dimension.height);
	
	    this.groupPositions = groupPositions;
	    this.groupPaths = this.isSpline ? this._getSplineLinesPath(groupPositions) : this._getLinesPath(groupPositions);
	    this.paper.setSize(dimension.width, dimension.height);
	    this.tooltipLine.attr({ top: dimension.height });
	
	    this.groupPaths.forEach(function (path, groupIndex) {
	      _this4.groupLines[groupIndex].attr({ path: path.join(' ') });
	
	      _this4.groupDots[groupIndex].forEach(function (item, index) {
	        if (item.endDot) {
	          _this4._moveDot(item.endDot.dot, groupPositions[groupIndex][index]);
	        }
	      });
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelLineChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var _this5 = this;
	
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    if (this.selectedLegendIndex && this.selectedLegendIndex !== -1) {
	      this.resetSeriesOrder(this.selectedLegendIndex);
	    }
	
	    this.selectedLegendIndex = legendIndex;
	
	    this.groupLines.forEach(function (line, groupIndex) {
	      var isSelectedLegend = legendIndex === groupIndex;
	      var opacity = noneSelected || isSelectedLegend ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	      var groupDots = _this5.groupDots[groupIndex];
	
	      line.attr({ 'stroke-opacity': opacity });
	
	      if (isSelectedLegend) {
	        _this5.moveSeriesToFront(line, groupDots);
	      }
	    });
	
	    if (noneSelected) {
	      this.groupLines.forEach(function (line, groupIndex) {
	        _this5.moveSeriesToFront(line, _this5.groupDots[groupIndex]);
	      });
	    }
	  };
	
	  /**
	   * Reset series order after selected to be same to when it is first rendered
	   * @param {number} legendIndex - legend index to reset series order
	   * @ignore
	   */
	
	
	  RaphaelLineChart.prototype.resetSeriesOrder = function resetSeriesOrder(legendIndex) {
	    var frontLine = legendIndex + 1 < this.groupLines.length ? this.groupLines[legendIndex + 1] : null;
	
	    if (frontLine) {
	      this.groupLines[legendIndex].insertBefore(frontLine);
	      this.groupDots[legendIndex].forEach(function (item) {
	        if (item && item.endDot) {
	          item.endDot.dot.insertBefore(frontLine);
	        }
	      });
	    }
	  };
	
	  /**
	   * @param {SVGElement} lineType - line or area graph
	   * @param {Array.<SVGElement>} dots - dot type element
	   * @ignore
	   * @override
	   */
	
	
	  RaphaelLineChart.prototype.moveSeriesToFront = function moveSeriesToFront(lineType, dots) {
	    lineType.toFront();
	
	    dots.forEach(function (item) {
	      item.endDot.dot.toFront();
	    });
	  };
	
	  /**
	   * Animate for adding data.
	   * @param {object} data - data for graph rendering
	   * @param {number} tickSize - tick size
	   * @param {Array.<Array.<object>>} groupPositions - group positions
	   * @param {boolean} [shiftingOption] - shifting option
	   */
	
	
	  RaphaelLineChart.prototype.animateForAddingData = function animateForAddingData(data, tickSize, groupPositions, shiftingOption) {
	    var _this6 = this;
	
	    var isSpline = data.options.spline;
	    var groupPaths = isSpline ? this._getSplineLinesPath(groupPositions) : this._getLinesPath(groupPositions);
	    var additionalIndex = 0;
	
	    if (!groupPositions.length) {
	      return;
	    }
	
	    if (shiftingOption) {
	      additionalIndex = 1;
	    }
	
	    this.groupLines.forEach(function (line, groupIndex) {
	      var dots = _this6.groupDots[groupIndex];
	      var groupPosition = groupPositions[groupIndex];
	
	      if (shiftingOption) {
	        _this6._removeFirstDot(dots);
	      }
	
	      dots.forEach(function (item, index) {
	        var position = groupPosition[index + additionalIndex];
	        _this6._animateByPosition(item.endDot.dot, position, tickSize);
	      });
	
	      _this6._animateByPath(line, groupPaths[groupIndex], tickSize);
	    });
	  };
	
	  RaphaelLineChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, groupPositions, groupLabels, labelTheme) {
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      'text-anchor': 'middle',
	      opacity: 0
	    };
	    var set = paper.set();
	
	    groupLabels.forEach(function (categoryLabel, categoryIndex) {
	      categoryLabel.forEach(function (label, seriesIndex) {
	        var position = groupPositions[categoryIndex][seriesIndex];
	        var endLabel = _raphaelRenderUtil2['default'].renderText(paper, position.end, label.end, attributes);
	
	        set.push(endLabel);
	
	        endLabel.node.style.userSelect = 'none';
	        endLabel.node.style.cursor = 'default';
	        endLabel.node.setAttribute('filter', 'url(#glow)');
	
	        if (position.start) {
	          var startLabel = _raphaelRenderUtil2['default'].renderText(paper, position.start, label.start, attributes);
	
	          startLabel.node.style.userSelect = 'none';
	          startLabel.node.style.cursor = 'default';
	          startLabel.node.setAttribute('filter', 'url(#glow)');
	
	          set.push(startLabel);
	        }
	      });
	    });
	
	    return set;
	  };
	
	  return RaphaelLineChart;
	}(_raphaelLineTypeBase2['default']);
	
	exports['default'] = RaphaelLineChart;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelLineTypeBase is base class for line type renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var DEFAULT_DOT_RADIUS = 6;
	var SELECTION_DOT_RADIUS = 7;
	var DE_EMPHASIS_OPACITY = 0.3;
	var MOVING_ANIMATION_DURATION = 300;
	var CHART_HOVER_STATUS_OVER = 'over';
	var CHART_HOVER_STATUS_OUT = 'out';
	
	/**
	 * @classdesc RaphaelLineTypeBase is base for line type renderer.
	 * @class RaphaelLineTypeBase
	 * @private
	 */
	
	var RaphaelLineTypeBase = function () {
	  function RaphaelLineTypeBase() {
	    _classCallCheck(this, RaphaelLineTypeBase);
	  }
	
	  /**
	   * Make lines path.
	   * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	   * @param {?string} [posTopType='top'] position top type
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {Array.<string | number>} paths
	   * @private
	   */
	  RaphaelLineTypeBase.prototype._makeLinesPath = function _makeLinesPath(positions, posTopType, connectNulls) {
	    var _ref;
	
	    var path = [];
	    var prevMissing = false;
	
	    posTopType = posTopType || 'top';
	    [].concat(positions).forEach(function (position) {
	      var pathCommand = prevMissing && !connectNulls ? 'M' : 'L';
	
	      if (position) {
	        path.push([pathCommand, position.left, position[posTopType]]);
	        if (prevMissing) {
	          prevMissing = false;
	        }
	      } else {
	        prevMissing = true;
	      }
	    });
	
	    path = (_ref = []).concat.apply(_ref, _toConsumableArray(path));
	
	    if (path.length > 0) {
	      path[0] = 'M';
	    }
	
	    return path;
	  };
	
	  /**
	   * Get anchor. (http://raphaeljs.com/analytics.js)
	   * @param {{left: number, top: number}} fromPos from position
	   * @param {{left: number, top: number}} pos position
	   * @param {{left: number, top: number}} nextPos next position
	   * @param {?boolean} [isReverseDirection] - True when the line is drawn from right to left
	   * @returns {{x1: number, y1: number, x2: number, y2: number}} anchor
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getAnchor = function _getAnchor(fromPos, pos, nextPos, isReverseDirection) {
	    var l1 = (pos.left - fromPos.left) / 2;
	    var l2 = (nextPos.left - pos.left) / 2;
	    var a = void 0,
	        b = void 0;
	
	    if (isReverseDirection) {
	      a = Math.atan((fromPos.left - pos.left) / Math.abs(fromPos.top - pos.top));
	      b = Math.atan((pos.left - nextPos.left) / Math.abs(nextPos.top - pos.top));
	    } else {
	      a = Math.atan((pos.left - fromPos.left) / Math.abs(pos.top - fromPos.top));
	      b = Math.atan((nextPos.left - pos.left) / Math.abs(pos.top - nextPos.top));
	    }
	
	    a = fromPos.top < pos.top ? Math.PI - a : a;
	    b = nextPos.top < pos.top ? Math.PI - b : b;
	    var alpha = Math.PI / 2 - (a + b) % (Math.PI * 2) / 2;
	    var dx1 = l1 * Math.sin(alpha + a);
	    var dy1 = l1 * Math.cos(alpha + a);
	    var dx2 = l2 * Math.sin(alpha + b);
	    var dy2 = l2 * Math.cos(alpha + b);
	    var result = {
	      x1: pos.left - dx1,
	      y1: pos.top + dy1,
	      x2: pos.left + dx2,
	      y2: pos.top + dy2
	    };
	
	    if (isReverseDirection) {
	      result.y1 = pos.top - dy1;
	      result.y2 = pos.top - dy2;
	    }
	
	    return result;
	  };
	
	  /**
	   * Get spline positions groups which is divided with null data value.
	   * If series has not divided positions, it returns only one positions group.
	   * @param {Array.<object>} positions positions array
	   * @param {boolean} connectNulls option of connect line of both null data's side
	   * @Returns {Array.<Array.<object>>}
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getSplinePositionsGroups = function _getSplinePositionsGroups(positions, connectNulls) {
	    var positionsGroups = [];
	    var positionsGroup = [];
	    positions.forEach(function (position, index) {
	      var isLastIndex = index === positions.length - 1;
	
	      if (position) {
	        positionsGroup.push(position);
	      }
	
	      if (!position && positionsGroup.length > 0 && !connectNulls || isLastIndex) {
	        positionsGroups.push(positionsGroup);
	        positionsGroup = [];
	      }
	    });
	
	    return positionsGroups;
	  };
	
	  /**
	   * Get spline partial paths
	   * @param {Array.<Array.<object>>} positionsGroups positions groups
	   * @param {?boolean} [isReverseDirection] - True when the line is drawn from right to left
	   * @returns {Array.<Array.<Array>>}
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getSplinePartialPaths = function _getSplinePartialPaths(positionsGroups, isReverseDirection) {
	    var _this = this;
	
	    var paths = [];
	    var lastPos = void 0,
	        positionsLen = void 0,
	        fromPos = void 0,
	        middlePositions = void 0,
	        path = void 0;
	
	    positionsGroups.forEach(function (dataPositions) {
	      var _dataPositions = _slicedToArray(dataPositions, 1),
	          prevPos = _dataPositions[0];
	
	      var firstPos = prevPos;
	      positionsLen = dataPositions.length;
	      fromPos = firstPos;
	      lastPos = dataPositions[positionsLen - 1];
	      middlePositions = dataPositions.slice(1).slice(0, positionsLen - 2);
	
	      path = middlePositions.map(function (position, index) {
	        var nextPos = dataPositions[index + 2];
	        var anchor = _this._getAnchor(fromPos, position, nextPos, isReverseDirection);
	
	        fromPos = position;
	
	        if (Math.abs(anchor.y1 - prevPos.top) > Math.abs(prevPos.top - position.top)) {
	          anchor.y1 = position.top;
	        }
	
	        if (Math.abs(anchor.y2 - nextPos.top) > Math.abs(nextPos.top - position.top)) {
	          anchor.y2 = position.top;
	        }
	
	        prevPos = position;
	
	        return [anchor.x1, anchor.y1, position.left, position.top, anchor.x2, anchor.y2];
	      });
	
	      path.push([lastPos.left, lastPos.top, lastPos.left, lastPos.top]);
	      path.unshift(['M', firstPos.left, firstPos.top, 'C', firstPos.left, firstPos.top]);
	      paths.push(path);
	    });
	
	    return paths;
	  };
	
	  /**
	   * Make spline lines path.
	   * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	   * @param {?object} [makeLineOptions] - options for make spline line
	   *   @param {?boolean} [makeLineOptions.connectNulls] - boolean value connect nulls or not
	   *   @param {?boolean} [makeLineOptions.isReverseDirection] - True when the line is drawn from right to left
	   *   @param {?boolean} [makeLineOptions.isBeConnected] - True when part of another line.
	   * @returns {Array.<string | number>} paths
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._makeSplineLinesPath = function _makeSplineLinesPath(positions) {
	    var makeLineOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	
	    var positionsGroups = this._getSplinePositionsGroups(positions, makeLineOptions.connectNulls);
	    var partialPaths = this._getSplinePartialPaths(positionsGroups, makeLineOptions.isReverseDirection);
	    var path = [];
	
	    partialPaths.forEach(function (partialPath) {
	      path = path.concat(partialPath);
	    });
	
	    if (makeLineOptions.isBeConnected) {
	      path[0] = path[0].slice(3);
	    }
	
	    return path;
	  };
	
	  /**
	   * Render tooltip line.
	   * @param {object} paper raphael paper
	   * @param {number} height height
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._renderTooltipLine = function _renderTooltipLine(paper, height) {
	    var linePath = _raphaelRenderUtil2['default'].makeLinePath({
	      left: 10,
	      top: height
	    }, {
	      left: 10,
	      top: 0
	    });
	
	    return _raphaelRenderUtil2['default'].renderLine(paper, linePath, 'transparent', 1);
	  };
	
	  RaphaelLineTypeBase.prototype.appendShadowFilterToDefs = function appendShadowFilterToDefs() {
	    var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	    var feOffset = document.createElementNS('http://www.w3.org/2000/svg', 'feOffset');
	    var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	    var feBlend = document.createElementNS('http://www.w3.org/2000/svg', 'feBlend');
	
	    filter.setAttributeNS(null, 'id', 'shadow');
	    filter.setAttributeNS(null, 'x', '-50%');
	    filter.setAttributeNS(null, 'y', '-50%');
	    filter.setAttributeNS(null, 'width', '180%');
	    filter.setAttributeNS(null, 'height', '180%');
	    feOffset.setAttributeNS(null, 'result', 'offOut');
	    feOffset.setAttributeNS(null, 'in', 'SourceAlpha');
	    feOffset.setAttributeNS(null, 'dx', '0');
	    feOffset.setAttributeNS(null, 'dy', '0');
	    feGaussianBlur.setAttributeNS(null, 'result', 'blurOut');
	    feGaussianBlur.setAttributeNS(null, 'in', 'offOut');
	    feGaussianBlur.setAttributeNS(null, 'stdDeviation', '2');
	    feBlend.setAttributeNS(null, 'in', 'SourceGraphic');
	    feBlend.setAttributeNS(null, 'in2', 'blurOut');
	    feBlend.setAttributeNS(null, 'mode', 'normal');
	    filter.appendChild(feOffset);
	    filter.appendChild(feGaussianBlur);
	    filter.appendChild(feBlend);
	    this.paper.defs.appendChild(filter);
	  };
	
	  /**
	   * Make border style.
	   * @param {string} borderColor border color
	   * @param {number} opacity opacity
	   * @param {number} borderWidth border width
	   * @returns {{stroke: string, stroke-width: number, strike-opacity: number}} border style
	   */
	
	
	  RaphaelLineTypeBase.prototype.makeBorderStyle = function makeBorderStyle(borderColor, opacity, borderWidth) {
	    var borderStyle = {
	      'stroke-width': borderWidth,
	      'stroke-opacity': opacity
	    };
	
	    if (borderColor) {
	      borderStyle.stroke = borderColor;
	    }
	
	    return borderStyle;
	  };
	
	  /**
	   * Make dot style for mouseout event.
	   * @param {number} opacity opacity
	   * @param {object} borderStyle border style
	   * @returns {{fill-opacity: number, stroke-opacity: number, r: number}} style
	   */
	
	
	  RaphaelLineTypeBase.prototype.makeOutDotStyle = function makeOutDotStyle(opacity, borderStyle) {
	    var outDotStyle = {
	      'fill-opacity': opacity,
	      'stroke-opacity': opacity,
	      r: DEFAULT_DOT_RADIUS
	    };
	
	    if (borderStyle) {
	      _tuiCodeSnippet2['default'].extend(outDotStyle, borderStyle);
	    }
	
	    return outDotStyle;
	  };
	
	  /**
	   * Render dot.
	   * @param {object} paper raphael papaer
	   * @param {{left: number, top: number}} position dot position
	   * @param {string} color dot color
	   * @param {number} opacity opacity
	   * @returns {object} raphael dot
	   */
	
	
	  RaphaelLineTypeBase.prototype.renderDot = function renderDot(paper, position, color, opacity) {
	    var dotTheme = this.theme && this.theme.dot || { dot: {} };
	    var raphaelDot = void 0;
	
	    if (position) {
	      var dot = paper.circle(position.left, position.top, !_tuiCodeSnippet2['default'].isUndefined(dotTheme.radius) ? dotTheme.radius : DEFAULT_DOT_RADIUS);
	      var dotStyle = {
	        fill: dotTheme.fillColor || color,
	        'fill-opacity': _tuiCodeSnippet2['default'].isNumber(opacity) ? opacity : dotTheme.fillOpacity,
	        stroke: dotTheme.strokeColor || color,
	        'stroke-opacity': _tuiCodeSnippet2['default'].isNumber(opacity) ? opacity : dotTheme.strokeOpacity,
	        'stroke-width': dotTheme.strokeWidth
	      };
	
	      dot.attr(dotStyle);
	
	      raphaelDot = {
	        dot: dot,
	        color: color
	      };
	    }
	
	    return raphaelDot;
	  };
	
	  /**
	   * Move dots to front.
	   * @param {Array.<{startDot: {dot: object}, endDot: {dot: object}}>} dots - dots
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._moveDotsToFront = function _moveDotsToFront(dots) {
	    _raphaelRenderUtil2['default'].forEach2dArray(dots, function (dotInfo) {
	      dotInfo.endDot.dot.toFront();
	      if (dotInfo.startDot) {
	        dotInfo.startDot.dot.toFront();
	      }
	    });
	  };
	
	  /**
	   * Render dots.
	   * @param {object} paper raphael paper
	   * @param {Array.<Array.<object>>} groupPositions positions
	   * @param {string[]} colors colors
	   * @param {number} opacity opacity
	   * @param {Array.<object>} [seriesSet] series set
	   * @returns {Array.<object>} dots
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._renderDots = function _renderDots(paper, groupPositions, colors, opacity, seriesSet) {
	    var _this2 = this;
	
	    var dots = groupPositions.map(function (positions, groupIndex) {
	      var color = colors[groupIndex];
	
	      return Object.values(positions).map(function (position) {
	        var dotMap = {
	          endDot: _this2.renderDot(paper, position, color, opacity)
	        };
	
	        if (_this2.hasRangeData) {
	          var startPosition = _tuiCodeSnippet2['default'].extend({}, position);
	          startPosition.top = startPosition.startTop;
	          dotMap.startDot = _this2.renderDot(paper, startPosition, color, opacity);
	        }
	
	        if (seriesSet) {
	          seriesSet.push(dotMap.endDot.dot);
	          if (dotMap.startDot) {
	            seriesSet.push(dotMap.startDot.dot);
	          }
	        }
	
	        return dotMap;
	      });
	    });
	
	    return dots;
	  };
	
	  /**
	   * Get center position
	   * @param {{left: number, top: number}} fromPos from position
	   * @param {{left: number, top: number}} toPos to position
	   * @returns {{left: number, top: number}} position
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getCenter = function _getCenter(fromPos, toPos) {
	    return {
	      left: (fromPos.left + toPos.left) / 2,
	      top: (fromPos.top + toPos.top) / 2
	    };
	  };
	
	  /**
	   * Show dot.
	   * @param {object} dotInformation raphael object
	   * @param {number} groupIndex seriesIndex
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._showDot = function _showDot(dotInformation, groupIndex) {
	    var hoverTheme = this.theme.dot.hover;
	    var attributes = {
	      'fill-opacity': hoverTheme.fillOpacity,
	      stroke: hoverTheme.strokeColor || dotInformation.color,
	      'stroke-opacity': hoverTheme.strokeOpacity,
	      'stroke-width': hoverTheme.strokeWidth,
	      r: hoverTheme.radius,
	      filter: 'url(#shadow)'
	    };
	
	    this._setPrevDotAttributes(groupIndex, dotInformation.dot);
	
	    if (hoverTheme.fillColor) {
	      attributes.fill = hoverTheme.fillColor;
	    }
	
	    dotInformation.dot.attr(attributes);
	    if (dotInformation.dot.node) {
	      dotInformation.dot.node.setAttribute('filter', 'url(#shadow)');
	    }
	    dotInformation.dot.toFront();
	  };
	
	  /**
	   * temp save dot style attribute
	   * @param {number} groupIndex seriesIndex
	   * @param {object} dot raphael circle object
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._setPrevDotAttributes = function _setPrevDotAttributes(groupIndex, dot) {
	    if (!this._prevDotAttributes) {
	      this._prevDotAttributes = {};
	    }
	    this._prevDotAttributes[groupIndex] = dot.attr();
	  };
	
	  /**
	   * Update line stroke width.
	   * @param {string} changeType over or out
	   * @param {object} line raphael object
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._updateLineStrokeOpacity = function _updateLineStrokeOpacity(changeType, line) {
	    var opacity = 1;
	    var isSelectedLegend = !_tuiCodeSnippet2['default'].isNull(this.selectedLegendIndex);
	    if (this.groupLines) {
	      if (changeType === CHART_HOVER_STATUS_OVER || isSelectedLegend) {
	        opacity = this.chartType === 'radial' && this.showArea ? 0 : DE_EMPHASIS_OPACITY;
	      }
	
	      if (changeType === CHART_HOVER_STATUS_OUT && isSelectedLegend) {
	        line = this.getLine(this.selectedLegendIndex);
	      }
	
	      this.groupLines.forEach(function (otherLine) {
	        otherLine.attr({
	          'stroke-opacity': opacity
	        });
	      });
	      line.attr({
	        'stroke-opacity': 1
	      });
	    }
	  };
	
	  /**
	   * Get the raphael line element with groupIndex
	   * @param {number} groupIndex  group index
	   * @returns {object} line raphael object
	   */
	
	
	  RaphaelLineTypeBase.prototype.getLine = function getLine(groupIndex) {
	    return this.groupLines ? this.groupLines[groupIndex] : this.groupAreas[groupIndex];
	  };
	
	  /**
	   * Update line stroke width.
	   * @param {string} changeType over or out
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._updateAreaOpacity = function _updateAreaOpacity(changeType) {
	    if (this.groupAreas) {
	      this.groupAreas.forEach(function (otherArea) {
	        otherArea.area.attr({
	          'fill-opacity': changeType === CHART_HOVER_STATUS_OVER ? DE_EMPHASIS_OPACITY : 1
	        });
	      });
	    }
	  };
	
	  /**
	   * Update line stroke width.
	   * @param {object} line raphael object
	   * @param {number} strokeWidth stroke width
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._updateLineStrokeWidth = function _updateLineStrokeWidth(line, strokeWidth) {
	    var changeAttr = {
	      'stroke-width': strokeWidth
	    };
	    if (line.attrs) {
	      changeAttr.stroke = line.attrs.stroke;
	    }
	    line.attr(changeAttr);
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} data show info
	   */
	
	
	  RaphaelLineTypeBase.prototype.showAnimation = function showAnimation(data) {
	    var groupIndex = data.index;
	    var groupDot = this.groupDots[groupIndex];
	    var item = this._findDotItem(groupDot, data.groupIndex);
	
	    var line = this.groupLines ? this.groupLines[groupIndex] : this.groupAreas[groupIndex];
	    var strokeWidth = void 0,
	        startLine = void 0;
	
	    if (!item) {
	      return;
	    }
	
	    if (this.chartType === 'area') {
	      var _line = line;
	      startLine = _line.startLine;
	      line = _line.line;
	
	      strokeWidth = 5;
	      this._updateAreaOpacity(CHART_HOVER_STATUS_OVER);
	    } else {
	      strokeWidth = this.lineWidth;
	    }
	
	    this._updateLineStrokeOpacity(CHART_HOVER_STATUS_OVER, line);
	    this._updateLineStrokeWidth(line, strokeWidth);
	    if (startLine) {
	      this._updateLineStrokeWidth(startLine, strokeWidth);
	    }
	
	    this._showDot(item.endDot, groupIndex);
	
	    if (item.startDot) {
	      this._showDot(item.startDot, groupIndex);
	    }
	  };
	
	  /**
	   * Find dot item
	   * @param {Array.<Object>} groupDot - groupDot info
	   * @param {number} index - dot index
	   * @returns {Object} - raphael object
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._findDotItem = function _findDotItem() {
	    var groupDot = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
	    var index = arguments[1];
	
	    var isRadialChart = _predicate2['default'].isRadialChart(this.chartType);
	
	    // For radial charts, the position path is one more than the length of the data.
	    if (isRadialChart && groupDot.length === index) {
	      index = 0;
	    }
	
	    return groupDot[index];
	  };
	
	  /**
	   * Get pivot group dots.
	   * @returns {Array.<Array>} dots
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getPivotGroupDots = function _getPivotGroupDots() {
	    if (!this.pivotGroupDots && this.groupDots) {
	      this.pivotGroupDots = _arrayUtil2['default'].pivot(this.groupDots);
	    }
	
	    return this.pivotGroupDots;
	  };
	
	  /**
	   * Show group dots.
	   * @param {number} index index
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._showGroupDots = function _showGroupDots(index) {
	    var _this3 = this;
	
	    var groupDots = this._getPivotGroupDots();
	
	    if (!groupDots || !groupDots[index]) {
	      return;
	    }
	
	    groupDots[index].forEach(function (item, groupIndex) {
	      if (item.endDot) {
	        _this3._showDot(item.endDot, groupIndex);
	      }
	
	      if (item.startDot) {
	        _this3._showDot(item.startDot, groupIndex);
	      }
	    });
	  };
	
	  /**
	   * Show line for group tooltip.
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} bound bound
	   * @param {object} layout layout
	   */
	
	
	  RaphaelLineTypeBase.prototype.showGroupTooltipLine = function showGroupTooltipLine(bound, layout) {
	    var left = Math.max(bound.position.left, 11);
	    var linePath = _raphaelRenderUtil2['default'].makeLinePath({
	      left: left,
	      top: layout.position.top + bound.dimension.height
	    }, {
	      left: left,
	      top: layout.position.top
	    });
	
	    if (this.tooltipLine) {
	      this.tooltipLine.attr({
	        path: linePath,
	        stroke: '#999',
	        'stroke-opacity': 1
	      });
	    }
	  };
	
	  /**
	   * Show group animation.
	   * @param {number} index index
	   */
	
	
	  RaphaelLineTypeBase.prototype.showGroupAnimation = function showGroupAnimation(index) {
	    this._showGroupDots(index);
	  };
	
	  /**
	   * Hide dot.
	   * @param {object} dot raphael object
	   * @param {number} groupIndex seriesIndex
	   * @param {?number} opacity opacity
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._hideDot = function _hideDot(dot, groupIndex, opacity) {
	    var prev = this._prevDotAttributes[groupIndex];
	    var outDotStyle = this.outDotStyle;
	
	    // if prev data exists, use prev.r
	    // there is dot disappearing issue, when hideDot
	
	    if (prev && !_tuiCodeSnippet2['default'].isUndefined(opacity)) {
	      outDotStyle = _tuiCodeSnippet2['default'].extend({
	        r: prev.r,
	        stroke: prev.stroke,
	        fill: prev.fill,
	        'stroke-opacity': prev['stroke-opacity'],
	        'stroke-width': prev['stroke-width'],
	        'fill-opacity': prev['fill-opacity']
	      });
	    }
	
	    dot.attr(outDotStyle);
	    if (dot.node) {
	      dot.node.setAttribute('filter', '');
	    }
	
	    this.resetSeriesOrder(groupIndex);
	  };
	
	  /**
	   * Hide animation.
	   * @param {{groupIndex: number, index:number}} data hide info
	   */
	
	
	  RaphaelLineTypeBase.prototype.hideAnimation = function hideAnimation(data) {
	    var index = data.groupIndex; // Line chart has pivot values.
	    var groupIndex = data.index;
	    var groupDot = this.groupDots[groupIndex];
	    var item = this._findDotItem(groupDot, index);
	
	    var line = void 0,
	        strokeWidth = void 0,
	        startLine = void 0;
	    var opacity = this.dotOpacity;
	
	    if (!item) {
	      return;
	    }
	
	    line = this.groupLines ? this.groupLines[groupIndex] : this.groupAreas[groupIndex];
	
	    if (this.chartType === 'area') {
	      strokeWidth = this.lineWidth;
	      var _line2 = line;
	      startLine = _line2.startLine;
	      line = _line2.line;
	
	      this._updateAreaOpacity(CHART_HOVER_STATUS_OUT);
	    } else {
	      strokeWidth = this.lineWidth;
	    }
	
	    if (opacity && !_tuiCodeSnippet2['default'].isNull(this.selectedLegendIndex) && this.selectedLegendIndex !== groupIndex) {
	      opacity = DE_EMPHASIS_OPACITY;
	    }
	
	    this._updateLineStrokeOpacity(CHART_HOVER_STATUS_OUT, line);
	    this._updateLineStrokeWidth(line, strokeWidth);
	
	    if (startLine) {
	      this._updateLineStrokeWidth(startLine, strokeWidth);
	    }
	
	    if (item) {
	      this._hideDot(item.endDot.dot, groupIndex, opacity);
	
	      if (item.startDot) {
	        this._hideDot(item.startDot.dot, groupIndex, opacity);
	      }
	    }
	  };
	
	  /**
	   * Hide group dots.
	   * @param {number} index index
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._hideGroupDots = function _hideGroupDots(index) {
	    var _this4 = this;
	
	    var hasSelectedIndex = !_tuiCodeSnippet2['default'].isNull(this.selectedLegendIndex);
	    var baseOpacity = this.dotOpacity;
	    var groupDots = this._getPivotGroupDots();
	
	    if (!groupDots || !groupDots[index]) {
	      return;
	    }
	
	    groupDots[index].forEach(function (item, groupIndex) {
	      var opacity = baseOpacity;
	
	      if (opacity && hasSelectedIndex && _this4.selectedLegendIndex !== groupIndex) {
	        opacity = DE_EMPHASIS_OPACITY;
	      }
	
	      if (item.endDot) {
	        _this4._hideDot(item.endDot.dot, groupIndex, opacity);
	      }
	
	      if (item.startDot) {
	        _this4._hideDot(item.startDot.dot, groupIndex, opacity);
	      }
	    });
	  };
	
	  /**
	   * Hide line for group tooltip.
	   */
	
	
	  RaphaelLineTypeBase.prototype.hideGroupTooltipLine = function hideGroupTooltipLine() {
	    this.tooltipLine.attr({
	      'stroke-opacity': 0
	    });
	  };
	
	  /**
	   * Hide group animation.
	   * @param {number} index index
	   */
	
	
	  RaphaelLineTypeBase.prototype.hideGroupAnimation = function hideGroupAnimation(index) {
	    this._hideGroupDots(index);
	  };
	
	  /**
	   * Move dot.
	   * @param {object} dot - raphael object
	   * @param {{left: number, top: number}} position - position
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._moveDot = function _moveDot(dot, position) {
	    var dotAttrs = {
	      cx: position.left,
	      cy: position.top
	    };
	
	    if (this.dotOpacity) {
	      dotAttrs = _tuiCodeSnippet2['default'].extend({ 'fill-opacity': this.dotOpacity }, dotAttrs, this.borderStyle);
	    }
	
	    dot.attr(dotAttrs);
	  };
	
	  /**
	   * Animate.
	   * @param {function} onFinish callback
	   * @param {Array.<object>} seriesSet series set
	   */
	
	
	  RaphaelLineTypeBase.prototype.animate = function animate(onFinish, seriesSet) {
	    var paper = this.paper,
	        dimension = this.dimension,
	        position = this.position,
	        animationDuration = this.animationDuration;
	
	    var clipRectId = this._getClipRectId();
	    var remakePosition = this._makeClipRectPosition(position);
	    var clipRect = this.clipRect;
	
	
	    if (!IS_LTE_IE8 && dimension) {
	      if (!clipRect) {
	        clipRect = createClipPathRectWithLayout(paper, remakePosition, dimension, clipRectId, !!animationDuration);
	        this.clipRect = clipRect;
	      } else {
	        this._makeClipRectPosition(position);
	        clipRect.attr({
	          width: animationDuration ? 0 : dimension.width,
	          height: dimension.height,
	          x: remakePosition.left,
	          y: remakePosition.top
	        });
	      }
	
	      seriesSet.forEach(function (seriesElement) {
	        seriesElement.node.setAttribute('clip-path', 'url(#' + clipRectId + ')');
	      });
	
	      if (animationDuration) {
	        clipRect.animate({
	          width: dimension.width
	        }, animationDuration, '>', onFinish);
	      }
	    }
	  };
	
	  /**
	   * Make selection dot.
	   * @param {object} position clip rect position
	   *   @param {number} left clip rect left position
	   *   @param {number} top clip rect top position
	   * @returns {{top: number, left: number}} remake clip rect position
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._makeClipRectPosition = function _makeClipRectPosition(position) {
	    return {
	      left: position.left - _const2['default'].SERIES_EXPAND_SIZE,
	      top: position.top - _const2['default'].SERIES_EXPAND_SIZE
	    };
	  };
	
	  /**
	   * Make selection dot.
	   * @param {object} paper raphael paper
	   * @returns {object} selection dot
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._makeSelectionDot = function _makeSelectionDot(paper) {
	    var selectionDot = paper.circle(0, 0, SELECTION_DOT_RADIUS);
	
	    selectionDot.attr({
	      fill: '#ffffff',
	      'fill-opacity': 0,
	      'stroke-opacity': 0,
	      'stroke-width': 2
	    });
	
	    return selectionDot;
	  };
	
	  /**
	   * Select series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelLineTypeBase.prototype.selectSeries = function selectSeries(indexes) {
	    var item = this.groupDots[indexes.index][indexes.groupIndex];
	    var position = this.groupPositions[indexes.index][indexes.groupIndex];
	
	    this.selectedItem = item;
	    this.selectionDot.attr({
	      cx: position.left,
	      cy: position.top,
	      'fill-opacity': 0.5,
	      'stroke-opacity': 1,
	      stroke: this.selectionColor || item.endDot.color
	    });
	
	    if (this.selectionStartDot) {
	      this.selectionStartDot.attr({
	        cx: position.left,
	        cy: position.startTop,
	        'fill-opacity': 0.5,
	        'stroke-opacity': 1,
	        stroke: this.selectionColor || item.startDot.color
	      });
	    }
	  };
	
	  /**
	   * Unselect series.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   */
	
	
	  RaphaelLineTypeBase.prototype.unselectSeries = function unselectSeries(indexes) {
	    var item = this.groupDots[indexes.index][indexes.groupIndex];
	
	    if (this.selectedItem === item) {
	      this.selectionDot.attr({
	        'fill-opacity': 0,
	        'stroke-opacity': 0
	      });
	    }
	
	    if (this.selectionStartDot) {
	      this.selectionStartDot.attr({
	        'fill-opacity': 0,
	        'stroke-opacity': 0
	      });
	    }
	  };
	
	  /**
	   * Set width or height of paper.
	   * @param {number} width - width
	   * @param {number} height - height
	   */
	
	
	  RaphaelLineTypeBase.prototype.setSize = function setSize(width, height) {
	    width = width || this.dimension.width;
	    height = height || this.dimension.height;
	    this.paper.setSize(width, height);
	  };
	
	  /**
	   * Animate by position.
	   * @param {object} raphaelObj - raphael object
	   * @param {{left: number, top: number}} position - position
	   * @param {number} tickSize tick size
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._animateByPosition = function _animateByPosition(raphaelObj, position, tickSize) {
	    var attr = {
	      cx: position.left,
	      cy: position.top
	    };
	
	    if (_tuiCodeSnippet2['default'].isExisty(tickSize)) {
	      attr.transform = 't-' + tickSize + ',0';
	    }
	
	    raphaelObj.animate(attr, MOVING_ANIMATION_DURATION);
	  };
	
	  /**
	   * Animate by path.
	   * @param {object} raphaelObj - raphael object
	   * @param {Array.<string | number>} paths - paths
	   * @param {number} tickSize tick size
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._animateByPath = function _animateByPath(raphaelObj, paths, tickSize) {
	    var attr = {
	      path: paths.join(' ')
	    };
	
	    if (_tuiCodeSnippet2['default'].isExisty(tickSize)) {
	      attr.transform = 't-' + tickSize + ',0';
	    }
	
	    raphaelObj.animate(attr, MOVING_ANIMATION_DURATION);
	  };
	
	  /**
	   * Remove first dot.
	   * @param {Array.<object>} dots - dots
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._removeFirstDot = function _removeFirstDot(dots) {
	    var firstDot = dots.shift();
	
	    firstDot.endDot.dot.remove();
	
	    if (firstDot.startDot) {
	      firstDot.startDot.dot.remove();
	    }
	  };
	
	  /**
	   * Clear paper.
	   */
	
	
	  RaphaelLineTypeBase.prototype.clear = function clear() {
	    delete this.paper.dots;
	    this.paper.clear();
	  };
	
	  /**
	   * Resize clip rect size
	   * @param {number} width series width
	   * @param {number} height series height
	   */
	
	
	  RaphaelLineTypeBase.prototype.resizeClipRect = function resizeClipRect(width, height) {
	    var clipRect = this.paper.getById(this._getClipRectId() + '_rect');
	
	    clipRect.attr({
	      width: width,
	      height: height
	    });
	  };
	
	  /**
	   * Set clip rect id
	   * @returns {string} id - clip rect id
	   * @private
	   */
	
	
	  RaphaelLineTypeBase.prototype._getClipRectId = function _getClipRectId() {
	    if (!this.clipRectId) {
	      this.clipRectId = _renderUtil2['default'].generateClipRectId();
	    }
	
	    return this.clipRectId;
	  };
	
	  /**
	   * Reset series order after selected to be same to when it is first rendered
	   * @param {number} legendIndex - legend index to reset series order
	   * @ignore
	   * @abstract
	   */
	
	
	  RaphaelLineTypeBase.prototype.resetSeriesOrder = function resetSeriesOrder() {};
	
	  /**
	   * @param {SVGElement | {area: {SVGElement}, line: {SVGElement}, startLine: {SVGElement}}} lineType - line or area graph
	   * @param {Array.<SVGElement>} dots - dot type element
	   * @abstract
	   */
	
	
	  RaphaelLineTypeBase.prototype.moveSeriesToFront = function moveSeriesToFront() {};
	
	  return RaphaelLineTypeBase;
	}();
	
	/**
	 * Create clip rect with layout
	 * @param {object} paper Raphael paper
	 * @param {object} position position
	 * @param {object} dimension dimension
	 * @param {string} id ID string
	 * @param {boolean} isAnimated animation
	 * @returns {object}
	 * @ignore
	 */
	
	
	function createClipPathRectWithLayout(paper, position, dimension, id, isAnimated) {
	  var clipPath = document.createElementNS('http://www.w3.org/2000/svg', 'clipPath');
	  var rect = paper.rect(position.left, position.top, isAnimated ? 0 : dimension.width, dimension.height);
	
	  rect.id = id + '_rect';
	  clipPath.id = id;
	
	  clipPath.appendChild(rect.node);
	  paper.defs.appendChild(clipPath);
	
	  return rect;
	}
	
	exports['default'] = RaphaelLineTypeBase;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * predicate.
	 * @module predicate
	 * @private */
	/**
	 * @fileoverview Predicate.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	var predicate = {
	  /**
	   * Whether bar chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isBarChart: function isBarChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_BAR;
	  },
	
	
	  /**
	   * Whether column chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isColumnChart: function isColumnChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_COLUMN;
	  },
	
	
	  /**
	   * Whether bar type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isBarTypeChart: function isBarTypeChart(chartType) {
	    return predicate.isBarChart(chartType) || predicate.isColumnChart(chartType);
	  },
	
	
	  /**
	   * Whether column type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} seriesTypes - type of series
	   * @returns {boolean}
	   */
	  isColumnTypeChart: function isColumnTypeChart(chartType, seriesTypes) {
	    return predicate.isHeatmapChart(chartType) || predicate.isColumnChart(chartType) || predicate.isBoxplotChart(chartType) || predicate.isLineColumnComboChart(chartType, seriesTypes);
	  },
	
	
	  /**
	   * Whether boxplot chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isBoxplotChart: function isBoxplotChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_BOXPLOT;
	  },
	
	
	  /**
	   * Whether bullet chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isBulletChart: function isBulletChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_BULLET;
	  },
	
	
	  /**
	   * Whether radial type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isRadialChart: function isRadialChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_RADIAL;
	  },
	
	
	  /**
	   * Whether diverging chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {boolean} diverging - whether has diverging or not
	   * @returns {*|boolean}
	   */
	  isDivergingChart: function isDivergingChart(chartType, diverging) {
	    return this.isBarTypeChart(chartType) && diverging;
	  },
	
	
	  /**
	   * Whether normal stack chart or not.
	   * @param {string} chartType - type of chart
	   * @param {string} stackType - type of stack
	   * @returns {boolean}
	   * @private
	   */
	  isNormalStackChart: function isNormalStackChart(chartType, stackType) {
	    var isAllowedStackOption = predicate.isAllowedStackOption(chartType);
	    var isNormalStack = predicate.isNormalStack(stackType);
	
	    return isAllowedStackOption && isNormalStack;
	  },
	
	
	  /**
	   * Whether percent stack chart or not.
	   * @param {string} chartType - type of chart
	   * @param {string} stackType - type of stack
	   * @returns {boolean}
	   * @private
	   */
	  isPercentStackChart: function isPercentStackChart(chartType, stackType) {
	    var isAllowedStackOption = predicate.isAllowedStackOption(chartType);
	    var isPercentStack = predicate.isPercentStack(stackType);
	
	    return isAllowedStackOption && isPercentStack;
	  },
	
	
	  /**
	   * Whether combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isComboChart: function isComboChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_COMBO;
	  },
	
	
	  /**
	   * Whether line and column combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} subChartTypes - types of chart
	   * @returns {boolean}
	   */
	  isLineColumnComboChart: function isLineColumnComboChart(chartType, subChartTypes) {
	    var isLineOrColumn = _arrayUtil2['default'].all(subChartTypes || [], function (subChartType) {
	      return predicate.isLineChart(subChartType) || predicate.isColumnChart(subChartType);
	    });
	
	    return predicate.isComboChart(chartType) && isLineOrColumn;
	  },
	
	
	  /**
	   * Whether pie and donut combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} subChartTypes - types of chart
	   * @returns {boolean}
	   */
	  isPieDonutComboChart: function isPieDonutComboChart(chartType, subChartTypes) {
	    var isAllPieType = _arrayUtil2['default'].all(subChartTypes, function (subChartType) {
	      return predicate.isPieChart(subChartType);
	    });
	
	    return predicate.isComboChart(chartType) && isAllPieType;
	  },
	
	
	  /**
	   * Whether line chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isLineChart: function isLineChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_LINE;
	  },
	
	
	  /**
	   * Whether area chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isAreaChart: function isAreaChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_AREA;
	  },
	
	
	  /**
	   * Whether line and area combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} subChartTypes - types of chart
	   * @returns {boolean}
	   */
	  isLineAreaComboChart: function isLineAreaComboChart(chartType, subChartTypes) {
	    var isAllLineType = _arrayUtil2['default'].all(subChartTypes || [], function (subChartType) {
	      return predicate.isLineChart(subChartType) || predicate.isAreaChart(subChartType);
	    });
	
	    return predicate.isComboChart(chartType) && isAllLineType;
	  },
	
	
	  /**
	   * Whether line and area combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} subChartTypes - types of chart
	   * @returns {boolean}
	   */
	  hasLineChart: function hasLineChart(chartType, subChartTypes) {
	    var hasLineType = _arrayUtil2['default'].any(subChartTypes || [], function (subChartType) {
	      return predicate.isLineChart(subChartType);
	    });
	
	    return predicate.isComboChart(chartType) && hasLineType;
	  },
	
	
	  /**
	   * Whether line and scatter combo chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} subChartTypes - types of chart
	   * @returns {boolean}
	   */
	  isLineScatterComboChart: function isLineScatterComboChart(chartType, subChartTypes) {
	    var isAllLineType = _arrayUtil2['default'].all(subChartTypes || [], function (subChartType) {
	      return predicate.isLineChart(subChartType) || predicate.isScatterChart(subChartType);
	    });
	
	    return predicate.isComboChart(chartType) && isAllLineType;
	  },
	
	
	  /**
	   * Whether line type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @param {Array.<string>} [subChartTypes] - types of chart
	   * @returns {boolean}
	   */
	  isLineTypeChart: function isLineTypeChart(chartType, subChartTypes) {
	    return predicate.isLineChart(chartType) || predicate.isAreaChart(chartType) || predicate.isLineAreaComboChart(chartType, subChartTypes);
	  },
	
	
	  /**
	   * Whether bubble chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isBubbleChart: function isBubbleChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_BUBBLE;
	  },
	
	
	  /**
	   * Whether scatter chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isScatterChart: function isScatterChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_SCATTER;
	  },
	
	
	  /**
	   * Whether heatmap chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isHeatmapChart: function isHeatmapChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_HEATMAP;
	  },
	
	
	  /**
	   * Whether treemap chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isTreemapChart: function isTreemapChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_TREEMAP;
	  },
	
	
	  /**
	   * Whether box type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isBoxTypeChart: function isBoxTypeChart(chartType) {
	    return predicate.isHeatmapChart(chartType) || predicate.isTreemapChart(chartType);
	  },
	
	
	  /**
	   * Whether map type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isMapTypeChart: function isMapTypeChart(chartType) {
	    return this.isMapChart(chartType) || this.isHeatmapChart(chartType) || this.isTreemapChart(chartType);
	  },
	
	
	  /**
	   * Whether pie chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isPieChart: function isPieChart(chartType) {
	    // change to indexOf for handling alias
	    return chartType && chartType.indexOf(_const2['default'].CHART_TYPE_PIE) !== -1;
	  },
	
	
	  /**
	   * Whether map chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isMapChart: function isMapChart(chartType) {
	    return chartType === _const2['default'].CHART_TYPE_MAP;
	  },
	
	
	  /**
	   * Whether coordinate type chart or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isCoordinateTypeChart: function isCoordinateTypeChart(chartType) {
	    return predicate.isBubbleChart(chartType) || predicate.isScatterChart(chartType);
	  },
	
	
	  /**
	   * Whether allow rendering for minus point in area of series.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  allowMinusPointRender: function allowMinusPointRender(chartType) {
	    return predicate.isLineTypeChart(chartType) || predicate.isCoordinateTypeChart(chartType) || predicate.isBoxTypeChart(chartType) || predicate.isBulletChart(chartType);
	  },
	
	
	  /**
	   * Whether chart to detect mouse events on series or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isChartToDetectMouseEventOnSeries: function isChartToDetectMouseEventOnSeries(chartType) {
	    return predicate.isPieChart(chartType) || predicate.isMapChart(chartType) || predicate.isCoordinateTypeChart(chartType);
	  },
	
	
	  /**
	   * Whether align of label is outer or not.
	   * @memberOf module:predicate
	   * @param {string} align - align of legend
	   * @returns {boolean}
	   */
	  isLabelAlignOuter: function isLabelAlignOuter(align) {
	    return align === _const2['default'].LABEL_ALIGN_OUTER;
	  },
	
	
	  /**
	   * Whether show label or not.
	   * @param {{showLabel: ?boolean, showLegend: ?boolean}} options - options
	   * @returns {boolean}
	   */
	  isShowLabel: function isShowLabel(options) {
	    return options.showLabel || options.showLegend;
	  },
	
	
	  /**
	   * Whether show outer label or not.
	   * @param {{showLabel: ?boolean, showLegend: ?boolean, labelAlign: string}} options - options
	   * @returns {*|boolean}
	   */
	  isShowOuterLabel: function isShowOuterLabel(options) {
	    return predicate.isShowLabel(options) && predicate.isLabelAlignOuter(options.labelAlign);
	  },
	
	
	  /**
	   * Whether align of legend is left or not.
	   * @memberOf module:predicate
	   * @param {string} align - align of legend
	   * @returns {boolean}
	   */
	  isLegendAlignLeft: function isLegendAlignLeft(align) {
	    return align === _const2['default'].LEGEND_ALIGN_LEFT;
	  },
	
	
	  /**
	   * Whether align of legend is top or not.
	   * @memberOf module:predicate
	   * @param {string} align - align of legend
	   * @returns {boolean}
	   */
	  isLegendAlignTop: function isLegendAlignTop(align) {
	    return align === _const2['default'].LEGEND_ALIGN_TOP;
	  },
	
	
	  /**
	   * Whether align of legend is bottom or not.
	   * @memberOf module:predicate
	   * @param {string} align - align of legend
	   * @returns {boolean}
	   */
	  isLegendAlignBottom: function isLegendAlignBottom(align) {
	    return align === _const2['default'].LEGEND_ALIGN_BOTTOM;
	  },
	
	
	  /**
	   * Whether horizontal legend or not.
	   * @memberOf module:predicate
	   * @param {string} align - align option for legend
	   * @returns {boolean}
	   */
	  isHorizontalLegend: function isHorizontalLegend(align) {
	    return predicate.isLegendAlignTop(align) || predicate.isLegendAlignBottom(align);
	  },
	
	
	  /**
	   * Whether vertical legend or not.
	   * @memberOf module:predicate
	   * @param {string} align - align option for legend
	   * @returns {boolean}
	   */
	  isVerticalLegend: function isVerticalLegend(align) {
	    return !predicate.isHorizontalLegend(align);
	  },
	
	
	  /**
	   * Whether allowed stackType option or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - type of chart
	   * @returns {boolean}
	   */
	  isAllowedStackOption: function isAllowedStackOption(chartType) {
	    return predicate.isBarChart(chartType) || predicate.isColumnChart(chartType) || predicate.isAreaChart(chartType);
	  },
	
	
	  /**
	   * Whether normal stack type or not.
	   * @memberOf module:predicate
	   * @param {boolean} stackType - stackType option
	   * @returns {boolean}
	   */
	  isNormalStack: function isNormalStack(stackType) {
	    return stackType === _const2['default'].NORMAL_STACK_TYPE;
	  },
	
	
	  /**
	   * Whether percent stack type or not.
	   * @memberOf module:predicate
	   * @param {boolean} stackType - stackType option
	   * @returns {boolean}
	   */
	  isPercentStack: function isPercentStack(stackType) {
	    return stackType === _const2['default'].PERCENT_STACK_TYPE;
	  },
	
	
	  /**
	   * Whether valid stackType option or not.
	   * @memberOf module:predicate
	   * @param {boolean} stackType - stackType option
	   * @returns {boolean}
	   */
	  isValidStackOption: function isValidStackOption(stackType) {
	    return stackType && (predicate.isNormalStack(stackType) || predicate.isPercentStack(stackType));
	  },
	
	
	  /**
	   * Whether allow range data or not.
	   * @memberOf module:predicate
	   * @param {string} chartType - chart type
	   * @returns {boolean}
	   */
	  isAllowRangeData: function isAllowRangeData(chartType) {
	    return predicate.isBarTypeChart(chartType) || predicate.isAreaChart(chartType);
	  },
	
	
	  /**
	   * Whether align of yAxis is center or not.
	   * @memberOf module:predicate
	   * @param {boolean} hasRightYAxis - whether has right yAxis.
	   * @param {string} alignOption - align option of yAxis.
	   * @returns {boolean} whether - align center or not.
	   */
	  isYAxisAlignCenter: function isYAxisAlignCenter(hasRightYAxis, alignOption) {
	    return !hasRightYAxis && alignOption === _const2['default'].YAXIS_ALIGN_CENTER;
	  },
	
	
	  /**
	   * Whether minus limit or not.
	   * @memberOf module:predicate
	   * @param {{min: number, max: number}} limit - limit
	   * @returns {boolean}
	   */
	  isMinusLimit: function isMinusLimit(limit) {
	    return limit.min <= 0 && limit.max <= 0;
	  },
	
	
	  /**
	   * Whether auto tick interval or not.
	   * @param {string} [tickInterval] - tick interval option
	   * @returns {boolean}
	   */
	  isAutoTickInterval: function isAutoTickInterval(tickInterval) {
	    return tickInterval === _const2['default'].TICK_INTERVAL_AUTO;
	  },
	
	
	  /**
	   * Whether valid label interval or not.
	   * @param {number} [labelInterval] - label interval option
	   * @param {string} [tickInterval] - tick interval option
	   * @returns {*|boolean}
	   */
	  isValidLabelInterval: function isValidLabelInterval(labelInterval, tickInterval) {
	    return labelInterval && labelInterval > 1 && !tickInterval;
	  },
	
	
	  /**
	   * Whether datetime type or not.
	   * @param {string} type - type
	   * @returns {boolean}
	   */
	  isDatetimeType: function isDatetimeType(type) {
	    return type === _const2['default'].AXIS_TYPE_DATETIME;
	  },
	
	
	  /**
	   * @param {string} chartType - type of chart
	   * @returns {boolean} - whether it support ChartBase#showTooltip API
	   */
	  isSupportPublicShowTooptipAPI: function isSupportPublicShowTooptipAPI(chartType) {
	    return this.isBarChart(chartType) || this.isColumnChart(chartType) || this.isLineChart(chartType) || this.isAreaChart(chartType) || this.isBoxplotChart(chartType);
	  },
	
	
	  /**
	   * @param {string} chartType - type of chart
	   * @returns {boolean} - whether it support ChartBase#hideTooltip API
	   */
	  isSupportPublicHideTooptipAPI: function isSupportPublicHideTooptipAPI(chartType) {
	    return this.isBarChart(chartType) || this.isColumnChart(chartType) || this.isLineChart(chartType) || this.isAreaChart(chartType) || this.isBoxplotChart(chartType);
	  }
	};
	
	exports['default'] = predicate;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelLineTypeBase = __webpack_require__(15);
	
	var _raphaelLineTypeBase2 = _interopRequireDefault(_raphaelLineTypeBase);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _consoleUtil = __webpack_require__(18);
	
	var _consoleUtil2 = _interopRequireDefault(_consoleUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Raphael area chart renderer.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var GUIDE_AREACHART_AREAOPACITY_TYPE = _const2['default'].GUIDE_AREACHART_AREAOPACITY_TYPE,
	    CLASS_NAME_SVG_AUTOSHAPE = _const2['default'].CLASS_NAME_SVG_AUTOSHAPE;
	
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	
	var RaphaelAreaChart = function (_RaphaelLineBase) {
	  _inherits(RaphaelAreaChart, _RaphaelLineBase);
	
	  /**
	   * RaphaelAreaChart is graph renderer for area chart.
	   * @constructs RaphaelAreaChart
	   * @private
	   * @private
	   * @extends RaphaelLineTypeBase
	   */
	  function RaphaelAreaChart() {
	    _classCallCheck(this, RaphaelAreaChart);
	
	    /**
	     * selected legend index
	     * @type {?number}
	     */
	    var _this = _possibleConstructorReturn(this, _RaphaelLineBase.call(this));
	
	    _this.selectedLegendIndex = null;
	
	    /**
	     * type of chart
	     * @type {string}
	     */
	    _this.chartType = 'area';
	
	    /**
	     * Line width
	     * @type {number}
	     */
	    _this.lineWidth = 0;
	    return _this;
	  }
	
	  /**
	   * Render function of area chart.
	   * @param {object} paper - raphael paper
	   * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	   * @returns {object}
	   */
	
	
	  RaphaelAreaChart.prototype.render = function render(paper, data) {
	    var dimension = data.dimension,
	        groupPositions = data.groupPositions,
	        _data$theme = data.theme,
	        theme = _data$theme === undefined ? {} : _data$theme,
	        position = data.position,
	        zeroTop = data.zeroTop,
	        hasRangeData = data.hasRangeData,
	        options = data.options;
	    var _theme$dot = theme.dot,
	        dotTheme = _theme$dot === undefined ? {} : _theme$dot,
	        colors = theme.colors;
	    var spline = options.spline,
	        allowSelect = options.allowSelect,
	        connectNulls = options.connectNulls,
	        pointWidth = options.pointWidth,
	        showDot = options.showDot,
	        areaOpacityOptions = options.areaOpacity;
	
	    var areaOpacity = this._isAreaOpacityNumber(areaOpacityOptions) ? areaOpacityOptions : 1;
	    var dotOpacity = showDot ? 1 : 0;
	    var borderStyle = this.makeBorderStyle(dotTheme.strokeColor, dotOpacity, dotTheme.strokeWidth);
	    var outDotStyle = this.makeOutDotStyle(dotOpacity, borderStyle);
	    var lineWidth = this.lineWidth = _tuiCodeSnippet2['default'].isNumber(pointWidth) ? pointWidth : this.lineWidth;
	
	    this.paper = paper;
	    this.theme = theme;
	    this.isSpline = spline;
	    this.dimension = dimension;
	    this.position = position;
	    this.zeroTop = zeroTop;
	    this.hasRangeData = hasRangeData;
	    this.animationDuration = data.options.animationDuration;
	
	    paper.setStart();
	
	    this.groupPaths = this._getAreaChartPath(groupPositions, null, connectNulls);
	    this.groupAreas = this._renderAreas(paper, this.groupPaths, colors, lineWidth, areaOpacity);
	
	    this.tooltipLine = this._renderTooltipLine(paper, dimension.height);
	    this.groupDots = this._renderDots(paper, groupPositions, colors, dotOpacity);
	
	    if (allowSelect) {
	      this.selectionDot = this._makeSelectionDot(paper);
	      this.selectionColor = theme.selectionColor;
	
	      if (this.hasRangeData) {
	        this.selectionStartDot = this._makeSelectionDot(paper);
	      }
	    }
	
	    this.outDotStyle = outDotStyle;
	    this.groupPositions = groupPositions;
	    this.dotOpacity = dotOpacity;
	    this.pivotGroupDots = null;
	
	    var seriesSet = paper.setFinish();
	    this._moveSeriesToFrontAll();
	    this.tooltipLine.toFront();
	
	    return seriesSet;
	  };
	
	  /**
	   * Rearrange all series sequences.
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._moveSeriesToFrontAll = function _moveSeriesToFrontAll() {
	    var len = this.groupPaths ? this.groupPaths.length : 0;
	    for (var i = 0; i < len; i += 1) {
	      this.moveSeriesToFront(this.groupAreas[i], this.groupDots[i]);
	    }
	  };
	
	  /**
	   * Get path for area chart.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions - positions
	   * @param {boolean} [hasExtraPath] - whether has extra path or not
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {*}
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._getAreaChartPath = function _getAreaChartPath(groupPositions, hasExtraPath, connectNulls) {
	    if (this.isSpline) {
	      return this._makeSplineAreaChartPath(groupPositions, hasExtraPath);
	    }
	
	    return this._makeAreaChartPath(groupPositions, hasExtraPath, connectNulls);
	  };
	
	  /**
	   * Render area graphs.
	   * @param {object} paper paper
	   * @param {Array.<object>} groupPaths group paths
	   * @param {Array.<string>} colors colors
	   * @param {number} lineWidth line width
	   * @param {number} opacity opacity
	   * @returns {Array} raphael objects
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._renderAreas = function _renderAreas(paper, groupPaths, colors, lineWidth, opacity) {
	    colors = colors.slice(0, groupPaths.length);
	    colors.reverse();
	    groupPaths.reverse();
	
	    var groupAreas = groupPaths.map(function (path, groupIndex) {
	      var polygons = {};
	      var areaColor = colors[groupIndex] || 'transparent';
	      var lineColor = areaColor;
	      var area = _raphaelRenderUtil2['default'].renderArea(paper, path.area.join(' '), {
	        fill: areaColor,
	        opacity: opacity,
	        stroke: areaColor
	      });
	      var line = _raphaelRenderUtil2['default'].renderLine(paper, path.line.join(' '), lineColor, lineWidth);
	
	      area.node.setAttribute('class', CLASS_NAME_SVG_AUTOSHAPE);
	      line.node.setAttribute('class', CLASS_NAME_SVG_AUTOSHAPE);
	
	      polygons.area = area;
	      polygons.line = line;
	
	      if (path.startLine) {
	        polygons.startLine = _raphaelRenderUtil2['default'].renderLine(paper, path.startLine.join(' '), lineColor, 0);
	      }
	
	      return polygons;
	    });
	
	    return groupAreas.reverse();
	  };
	
	  /**
	   * Make height.
	   * @param {number} top top
	   * @param {number} startTop start top
	   * @returns {number} height
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._makeHeight = function _makeHeight(top, startTop) {
	    return Math.abs(top - startTop);
	  };
	
	  /**
	   * Make areas path.
	   * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	   * @param {boolean} [hasExtraPath] - whether has extra path or not
	   * @returns {Array.<string | number>} path
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._makeAreasPath = function _makeAreasPath(positions, hasExtraPath) {
	    var _ref3;
	
	    var paths = [];
	    var positionLength = positions.length;
	    var path = [];
	    var latterPath = [];
	    var formerPath = [];
	    var prevNull = false;
	
	    Object.entries(positions).forEach(function (_ref) {
	      var _ref2 = _slicedToArray(_ref, 2),
	          index = _ref2[0],
	          position = _ref2[1];
	
	      var moveOrLine = void 0;
	      if (position) {
	        if (prevNull) {
	          moveOrLine = 'M';
	          prevNull = false;
	        } else {
	          moveOrLine = 'L';
	        }
	
	        formerPath.push([moveOrLine, position.left, position.top]);
	        latterPath.unshift(['L', position.left, position.startTop]);
	      } else {
	        prevNull = true;
	        latterPath.push(['z']);
	      }
	
	      if (!position || parseInt(index, 10) === positionLength - 1) {
	        paths.push(formerPath.concat(latterPath));
	        formerPath = [];
	        latterPath = [];
	      }
	    });
	
	    paths.forEach(function (partialPath) {
	      path = path.concat(partialPath);
	    });
	
	    if (hasExtraPath !== false) {
	      var targetIndex = positions.length - 1;
	      path.splice(targetIndex + 1, 0, path[targetIndex], path[targetIndex + 1]);
	    }
	
	    path = (_ref3 = []).concat.apply(_ref3, _toConsumableArray(path));
	    path[0] = 'M';
	
	    return path;
	  };
	
	  /**
	   * Make path for area chart.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @param {boolean} [hasExtraPath] - whether has extra path or not
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {Array.<{area: Array.<string | number>, line: Array.<string | number>}>} path
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._makeAreaChartPath = function _makeAreaChartPath(groupPositions, hasExtraPath, connectNulls) {
	    var _this2 = this;
	
	    return groupPositions.map(function (positions) {
	      var paths = {
	        area: _this2._makeAreasPath(positions, hasExtraPath),
	        line: _this2._makeLinesPath(positions, null, connectNulls)
	      };
	
	      if (_this2.hasRangeData) {
	        paths.startLine = _this2._makeLinesPath(positions, 'startTop');
	      }
	
	      return paths;
	    });
	  };
	
	  /**
	   * Make spline path for area chart.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @param {boolean} [hasExtraPath] - whether has extra path or not
	   * @returns {Array.<{area: Array.<string | number>, line: Array.<string | number>}>} path
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._makeSplineAreaChartPath = function _makeSplineAreaChartPath(groupPositions, hasExtraPath) {
	    var _this3 = this;
	
	    return groupPositions.map(function (positions) {
	      var reversePosition = positions.concat().reverse().map(function (position) {
	        return {
	          left: position.left,
	          top: position.startTop
	        };
	      });
	
	      var linesPath = _this3._makeSplineLinesPath(positions);
	      var reverseLinesPath = _this3._makeSplineLinesPath(reversePosition, {
	        isReverseDirection: true,
	        isBeConnected: true
	      });
	
	      var areaPath = JSON.parse(JSON.stringify(linesPath));
	      var reverseAreaPath = JSON.parse(JSON.stringify(reverseLinesPath));
	
	      if (hasExtraPath !== false) {
	        var lastPosition = positions[positions.length - 1];
	        var lastReversePosition = reversePosition[reversePosition.length - 1];
	
	        areaPath.push(['K', lastPosition.left, lastPosition.top]);
	        areaPath.push(['L', lastPosition.left, lastPosition.startTop]);
	
	        reverseAreaPath.push(['K', lastReversePosition.left, lastReversePosition.top]);
	        reverseAreaPath.push(['L', lastReversePosition.left, lastReversePosition.top]);
	      }
	
	      return {
	        area: areaPath.concat(reverseAreaPath),
	        line: linesPath
	      };
	    });
	  };
	
	  /**
	   * Resize graph of area chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	   */
	
	
	  RaphaelAreaChart.prototype.resize = function resize(_ref4) {
	    var _this4 = this;
	
	    var dimension = _ref4.dimension,
	        groupPositions = _ref4.groupPositions,
	        zeroTop = _ref4.zeroTop;
	
	    this.resizeClipRect(dimension.width, dimension.height);
	
	    this.zeroTop = zeroTop;
	    this.groupPositions = groupPositions;
	    this.groupPaths = this._getAreaChartPath(groupPositions);
	    this.paper.setSize(dimension.width, dimension.height);
	    this.tooltipLine.attr({ top: dimension.height });
	
	    this.groupPaths.forEach(function (path, groupIndex) {
	      var area = _this4.groupAreas[groupIndex];
	      area.area.attr({ path: path.area.join(' ') });
	      area.line.attr({ path: path.line.join(' ') });
	
	      if (area.startLine) {
	        area.startLine.attr({ path: path.startLine.join(' ') });
	      }
	
	      _this4.groupDots[groupIndex].forEach(function (item, index) {
	        var position = groupPositions[groupIndex][index];
	
	        if (item.endDot) {
	          _this4._moveDot(item.endDot.dot, position);
	        }
	        if (item.startDot) {
	          var startPositon = Object.assign({}, position);
	          startPositon.top = startPositon.startTop;
	          _this4._moveDot(item.startDot.dot, startPositon);
	        }
	      });
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelAreaChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var _this5 = this;
	
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    if (this.selectedLegendIndex && this.selectedLegendIndex !== -1) {
	      this.resetSeriesOrder(this.selectedLegendIndex);
	    }
	
	    this.selectedLegendIndex = legendIndex;
	
	    this.groupAreas.forEach(function (area, groupIndex) {
	      var isSelectedLegend = legendIndex === groupIndex;
	      var opacity = noneSelected || isSelectedLegend ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	      var groupDots = _this5.groupDots[groupIndex];
	
	      area.area.attr({ 'fill-opacity': opacity });
	      area.line.attr({ 'stroke-opacity': opacity });
	
	      if (area.startLine) {
	        area.startLine.attr({ 'stroke-opacity': opacity });
	      }
	
	      if (isSelectedLegend) {
	        _this5.moveSeriesToFront(area, groupDots);
	      }
	    });
	  };
	
	  /**
	   * Reset series order after selected to be same to when it is first rendered
	   * @param {number} legendIndex - legend index to reset series order
	   * @ignore
	   */
	
	
	  RaphaelAreaChart.prototype.resetSeriesOrder = function resetSeriesOrder(legendIndex) {
	    var frontSeries = legendIndex + 1 < this.groupAreas.length ? this.groupAreas[legendIndex + 1] : null;
	
	    if (frontSeries) {
	      var frontArea = frontSeries.area;
	      this.groupAreas[legendIndex].area.insertBefore(frontArea);
	      this.groupAreas[legendIndex].line.insertBefore(frontArea);
	      this.groupDots[legendIndex].forEach(function (item) {
	        if (item && item.endDot) {
	          item.endDot.dot.insertBefore(frontArea);
	        }
	      });
	    }
	  };
	
	  /**
	   * @param {{area: {SVGElement}, line: {SVGElement}, startLine: {SVGElement}}} areaSurface - line or plane to represent area chart
	   * @param {Array.<SVGElement>} dots - dot type element
	   * @ignore
	   * @override
	   */
	
	
	  RaphaelAreaChart.prototype.moveSeriesToFront = function moveSeriesToFront(areaSurface, dots) {
	    areaSurface.line.toFront();
	    areaSurface.area.toFront();
	
	    if (areaSurface.startLine) {
	      areaSurface.startLine.toFront();
	    }
	
	    dots.forEach(function (item) {
	      item.endDot.dot.toFront();
	      if (item.startDot) {
	        item.startDot.dot.toFront();
	      }
	    });
	  };
	
	  /**
	   * Animate for adding data.
	   * @param {object} data - data for graph rendering
	   * @param {number} tickSize - tick size
	   * @param {Array.<Array.<object>>} groupPositions - group positions
	   * @param {boolean} [shiftingOption] - shifting option
	   * @param {number} zeroTop - position top value for zero point
	   */
	
	
	  RaphaelAreaChart.prototype.animateForAddingData = function animateForAddingData(data, tickSize, groupPositions, shiftingOption, zeroTop) {
	    var _this6 = this;
	
	    var groupPaths = this._getAreaChartPath(groupPositions, false);
	    var additionalIndex = 0;
	
	    if (!groupPositions.length) {
	      return;
	    }
	
	    if (shiftingOption) {
	      additionalIndex = 1;
	    }
	
	    this.zeroTop = zeroTop;
	
	    this.groupAreas.forEach(function (area, groupIndex) {
	      var dots = _this6.groupDots[groupIndex];
	      var groupPosition = groupPositions[groupIndex];
	      var pathMap = groupPaths[groupIndex];
	
	      if (shiftingOption) {
	        _this6._removeFirstDot(dots);
	      }
	
	      dots.forEach(function (item, index) {
	        var position = groupPosition[index + additionalIndex];
	        _this6._animateByPosition(item.endDot.dot, position, tickSize);
	
	        if (item.startDot) {
	          _this6._animateByPosition(item.startDot.dot, {
	            left: position.left,
	            top: position.startTop
	          }, tickSize);
	        }
	      });
	
	      _this6._animateByPath(area.area, pathMap.area, tickSize);
	      _this6._animateByPath(area.line, pathMap.line, tickSize);
	
	      if (area.startLine) {
	        _this6._animateByPath(area.startLine, pathMap.startLine, tickSize);
	      }
	    });
	  };
	
	  RaphaelAreaChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, groupPositions, groupLabels, labelTheme) {
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      'text-anchor': 'middle',
	      opacity: 0
	    };
	    var set = paper.set();
	
	    groupLabels.forEach(function (categoryLabel, categoryIndex) {
	      categoryLabel.forEach(function (label, seriesIndex) {
	        var position = groupPositions[categoryIndex][seriesIndex];
	        var endLabel = _raphaelRenderUtil2['default'].renderText(paper, position.end, label.end, attributes);
	
	        set.push(endLabel);
	
	        endLabel.node.style.userSelect = 'none';
	        endLabel.node.style.cursor = 'default';
	        endLabel.node.setAttribute('filter', 'url(#glow)');
	
	        if (position.start) {
	          var startLabel = _raphaelRenderUtil2['default'].renderText(paper, position.start, label.start, attributes);
	
	          startLabel.node.style.userSelect = 'none';
	          startLabel.node.style.cursor = 'default';
	          startLabel.node.setAttribute('filter', 'url(#glow)');
	
	          set.push(startLabel);
	        }
	      });
	    });
	
	    return set;
	  };
	
	  /**
	   * Test areaOpacity is a number, and return the result.
	   * It is used to determine whether to set a default value, 0.5.
	   * If it is not a number, areaOpacity will be changed to the default value, 0.5.
	   * @param {*} areaOpacity - value of property `options.areaOpacity`
	   * @returns {boolean} - whether areaOpacity is a number.
	   * @private
	   */
	
	
	  RaphaelAreaChart.prototype._isAreaOpacityNumber = function _isAreaOpacityNumber(areaOpacity) {
	    var isNumber = _tuiCodeSnippet2['default'].isNumber(areaOpacity);
	
	    if (isNumber) {
	      if (areaOpacity < 0 || areaOpacity > 1) {
	        _consoleUtil2['default'].print(GUIDE_AREACHART_AREAOPACITY_TYPE, 'warn');
	      }
	    } else if (!_tuiCodeSnippet2['default'].isUndefined(areaOpacity)) {
	      _consoleUtil2['default'].print(GUIDE_AREACHART_AREAOPACITY_TYPE, 'error');
	    }
	
	    return isNumber;
	  };
	
	  return RaphaelAreaChart;
	}(_raphaelLineTypeBase2['default']);
	
	exports['default'] = RaphaelAreaChart;

/***/ }),
/* 18 */
/***/ (function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	/**
	 * @fileoverview util for console
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	exports['default'] = {
	  /**
	   * check if window.console exists
	   * @param {string} message - message
	   * @param {string} status - print function of window.console
	   */
	  print: function print(message) {
	    var status = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'log';
	
	    if (window.console) {
	      window.console[status](message);
	    }
	  }
	};

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelPieCharts is graph renderer for pie chart.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var DEGREE_180 = 180;
	var DEGREE_360 = 360;
	var MIN_DEGREE = 0.01;
	var RAD = Math.PI / DEGREE_180;
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANT_VALUE = 0.2;
	var OVERLAY_ID = 'overlay';
	var TOOLTIP_OFFSET_VALUE = 20;
	
	/**
	 * @classdesc RaphaelPieCharts is graph renderer for pie chart.
	 * @class RaphaelPieChart
	 * @private
	 */
	
	var RaphaelPieChart = function () {
	  function RaphaelPieChart() {
	    _classCallCheck(this, RaphaelPieChart);
	  }
	
	  /**
	   * Render function of pie chart.
	   * @param {object} paper Raphael paper
	   * @param {{
	   *      sectorData: Array.<object>,
	   *      circleBound: {cx: number, cy: number, r: number},
	   *      dimension: object, theme: object, options: object
	   * }} data render data
	   * @param {object} callbacks callbacks
	   *      @param {function} callbacks.showTooltip show tooltip function
	   *      @param {function} callbacks.hideTooltip hide tooltip function
	   * @returns {object} paper raphael paper
	   */
	  RaphaelPieChart.prototype.render = function render(paper, data, callbacks) {
	    var pieSeriesSet = paper.set();
	    /**
	     * series rendering animation duration
	     * @type {number | object}
	     */
	    this.animationDuration = data.options.animationDuration;
	
	    /**
	     * raphael object
	     * @type {object}
	     */
	    this.paper = paper;
	
	    /**
	     * ratio for hole
	     * @type {number}
	     */
	    // this.holeRatio = data.options.radiusRange[0];
	
	    /**
	     * base background
	     * @type {string}
	     */
	    var _data$options$radiusR = _slicedToArray(data.options.radiusRange, 1);
	
	    this.holeRatio = _data$options$radiusR[0];
	    this.chartBackground = data.chartBackground;
	
	    /**
	     * type of chart
	     * @type {string}
	     */
	    this.chartType = data.chartType;
	
	    /**
	     * functions for tooltip control
	     * @type {{showTooltip: Function, hideTooltip: Function}}
	     */
	    this.callbacks = callbacks;
	
	    /**
	     * color for selection
	     * @type {string}
	     */
	    this.selectionColor = data.theme.selectionColor;
	
	    /**
	     * bound for circle
	     * @type {{cx: number, cy: number, r: number}}
	     */
	    this.circleBound = data.circleBound;
	
	    /**
	     * sector attr's name for draw graph
	     * @type {string}
	     */
	    this.sectorName = 'sector_' + this.chartType;
	
	    this._setSectorAttr();
	
	    this.sectorInfos = this._renderPie(data.sectorData, data.theme.colors, data.additionalIndex, pieSeriesSet);
	
	    this.overlay = this._renderOverlay();
	
	    this.labelInfos = {
	      value: [],
	      legend: []
	    };
	
	    /**
	     * previous mouse position
	     * @type {{left: number, top: number}}
	     */
	    this.prevPosition = null;
	
	    /**
	     * previous hover sector
	     * @type {object}
	     */
	    this.prevHoverSector = null;
	
	    return pieSeriesSet;
	  };
	
	  /**
	   * Clear paper.
	   */
	
	
	  RaphaelPieChart.prototype.clear = function clear() {
	    this.paper.clear();
	  };
	
	  /**
	   * Make sector path.
	   * @param {number} cx center x
	   * @param {number} cy center y
	   * @param {number} r radius
	   * @param {number} startAngle start angle
	   * @param {number} endAngle end angel
	   * @returns {{path: Array}} sector path
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._makeSectorPath = function _makeSectorPath(cx, cy, r, startAngle, endAngle) {
	    var startRadian = startAngle * RAD;
	    var endRadian = endAngle * RAD;
	    var x1 = cx + r * Math.sin(startRadian); // x point of start radian
	    var y1 = cy - r * Math.cos(startRadian); // y point of start radian
	    var x2 = cx + r * Math.sin(endRadian); // x point of end radian
	    var y2 = cy - r * Math.cos(endRadian); // y point of end radian
	    var largeArcFlag = endAngle - startAngle > DEGREE_180 ? 1 : 0;
	    var path = ['M', cx, cy, 'L', x1, y1, 'A', r, r, 0, largeArcFlag, 1, x2, y2, 'Z'];
	
	    // see details about path
	    // http://www.w3schools.com/svg/svg_path.asp
	    // https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/d
	    return { path: path };
	  };
	
	  /**
	   * Make sector path for donut chart.
	   * @param {number} cx - center x
	   * @param {number} cy - center y
	   * @param {number} r - radius
	   * @param {number} startAngle - start angle
	   * @param {number} endAngle - end angel
	   * @param {number} [holeRadius] - hole radius
	   * @returns {{path: Array}} sector path
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._makeDonutSectorPath = function _makeDonutSectorPath(cx, cy, r, startAngle, endAngle, holeRadius) {
	    /* eslint max-params: [2, 6]*/
	    var startRadian = startAngle * RAD;
	    var endRadian = endAngle * RAD;
	    var r2 = holeRadius || r * this.holeRatio; // radius of donut hole
	    var x1 = cx + r * Math.sin(startRadian);
	    var y1 = cy - r * Math.cos(startRadian);
	    var x2 = cx + r2 * Math.sin(startRadian);
	    var y2 = cy - r2 * Math.cos(startRadian);
	    var x3 = cx + r * Math.sin(endRadian);
	    var y3 = cy - r * Math.cos(endRadian);
	    var x4 = cx + r2 * Math.sin(endRadian);
	    var y4 = cy - r2 * Math.cos(endRadian);
	    var largeArcFlag = endAngle - startAngle > DEGREE_180 ? 1 : 0;
	
	    // prettier-ignore
	    var path = ['M', x1, y1, 'A', r, r, 0, largeArcFlag, 1, x3, y3, 'L', x4, y4, 'A', r2, r2, 0, largeArcFlag, 0, x2, y2, 'Z'];
	
	    return { path: path };
	  };
	
	  /**
	   * Set sector attribute for raphael paper.
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._setSectorAttr = function _setSectorAttr() {
	    var makeSectorPath = void 0;
	
	    if (this.paper.customAttributes[this.sectorName]) {
	      return;
	    }
	
	    if (this.holeRatio) {
	      makeSectorPath = this._makeDonutSectorPath;
	    } else {
	      makeSectorPath = this._makeSectorPath;
	    }
	
	    this.paper.customAttributes[this.sectorName] = makeSectorPath.bind(this);
	  };
	
	  /**
	   * Render overlay.
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._renderOverlay = function _renderOverlay() {
	    var params = {
	      paper: this.paper,
	      circleBound: {
	        cx: 0,
	        cy: 0,
	        r: 0
	      },
	      angles: {
	        startAngle: 0,
	        endAngle: 0
	      },
	      attrs: {
	        fill: 'none',
	        opacity: 0,
	        stroke: this.chartBackground.color,
	        'stroke-width': 1
	      }
	    };
	    var inner = this._renderSector(params);
	
	    inner.node.setAttribute('class', 'auto-shape-rendering');
	
	    inner.data('id', OVERLAY_ID);
	    inner.data('chartType', this.chartType);
	
	    return inner;
	  };
	
	  /**
	   * Render sector
	   * @param {object} params parameters
	   *      @param {object} params.paper raphael paper
	   *      @param {{cx: number, cy: number, r:number}} params.circleBound circle bounds
	   *      @param {number} params.startAngle start angle
	   *      @param {number} params.endAngle end angle
	   *      @param {{object}} params.attrs attributes
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._renderSector = function _renderSector(params) {
	    var circleBound = params.circleBound,
	        angles = params.angles,
	        attrs = params.attrs;
	
	
	    attrs[this.sectorName] = [circleBound.cx, circleBound.cy, circleBound.r, angles.startAngle, angles.endAngle];
	
	    return params.paper.path().attr(attrs);
	  };
	
	  /**
	   * Render pie graph.
	   * @param {Array.<object>} sectorData - sectorData
	   * @param {Array.<string>} colors - sector colors
	   * @param {number} additionalIndex - additional index for accumulate past pie series's data indexes on pieDonutCombo
	   * @param {Array.<object>} pieSeriesSet - pie series set
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._renderPie = function _renderPie(sectorData, colors, additionalIndex, pieSeriesSet) {
	    var _this = this;
	
	    var circleBound = this.circleBound,
	        chartBackground = this.chartBackground,
	        animationDuration = this.animationDuration;
	
	    var sectorInfos = [];
	
	    sectorData.forEach(function (sectorDatum, index) {
	      var ratio = sectorDatum.ratio,
	          angles = sectorDatum.angles;
	
	      var color = colors[index];
	      var sector = _this._renderSector({
	        paper: _this.paper,
	        circleBound: circleBound,
	        angles: animationDuration ? angles.start : angles.end,
	        attrs: {
	          fill: animationDuration ? chartBackground.color : color,
	          stroke: chartBackground.color,
	          'stroke-width': 0
	        }
	      });
	
	      sector.node.setAttribute('class', 'auto-shape-rendering');
	
	      sector.data('index', index);
	      sector.data('legendIndex', index + additionalIndex);
	      sector.data('chartType', _this.chartType);
	
	      sectorInfos.push({
	        sector: sector,
	        color: color,
	        angles: angles.end,
	        ratio: ratio
	      });
	
	      pieSeriesSet.push(sector);
	    });
	
	    return sectorInfos;
	  };
	
	  /**
	   * Show overlay.
	   * @param {number} index - index
	   * @param {number} legendIndex - legend index
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._showOverlay = function _showOverlay(index, legendIndex) {
	    var overlay = this.overlay;
	
	    var sectorInfo = this.sectorInfos[index];
	    var sa = sectorInfo.angles.startAngle;
	    var ea = sectorInfo.angles.endAngle;
	    var cb = this.circleBound;
	    var innerAttrs = {
	      fill: '#fff',
	      opacity: 1,
	      'stroke-width': 7,
	      'stroke-color': '#fff',
	      'stroke-miterlimit': 15
	    };
	
	    innerAttrs[this.sectorName] = [cb.cx, cb.cy, cb.r, sa, ea, cb.r * this.holeRatio];
	    overlay.attr(innerAttrs);
	    overlay.data('index', index);
	    overlay.data('legendIndex', legendIndex);
	
	    overlay.node.setAttribute('filter', 'url(#shadow)');
	
	    this._indexingOverlapElement([overlay, sectorInfo.sector, this.labelInfos.legend[index], this.labelInfos.value[index]]);
	  };
	
	  /**
	   * Element indexing For overlay.
	   * @param {Array} elements - indexing elements
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._indexingOverlapElement = function _indexingOverlapElement(elements) {
	    elements.forEach(function (element) {
	      if (element) {
	        element.toFront();
	      }
	    });
	  };
	
	  /**
	   * Hide overlay.
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._hideOverlay = function _hideOverlay() {
	    var overlay = this.overlay;
	
	    var attrs = {
	      fill: 'none',
	      opacity: 0
	    };
	
	    overlay.attr(attrs);
	
	    this._indexingOverlapElement(this.labelInfos.legend);
	    this._indexingOverlapElement(this.labelInfos.value);
	  };
	
	  /**
	   * Animate.
	   * @param {function} callback callback
	   */
	
	
	  RaphaelPieChart.prototype.animate = function animate(callback) {
	    var sectorName = this.sectorName,
	        circleBound = this.circleBound,
	        animationDuration = this.animationDuration;
	
	    var sectorArgs = [circleBound.cx, circleBound.cy, circleBound.r];
	    var delayTime = 0;
	
	    this.sectorInfos.forEach(function (sectorInfo) {
	      var angles = sectorInfo.angles;
	
	      var attrMap = {
	        fill: sectorInfo.color
	      };
	      if (animationDuration) {
	        var animationTime = animationDuration * sectorInfo.ratio;
	
	        if (angles.startAngle === 0 && angles.endAngle === DEGREE_360) {
	          angles.endAngle = DEGREE_360 - MIN_DEGREE;
	        }
	        attrMap[sectorName] = sectorArgs.concat([angles.startAngle, angles.endAngle]);
	        var anim = _raphael2['default'].animation(attrMap, animationTime, '>');
	        sectorInfo.sector.animate(anim.delay(delayTime));
	        delayTime += animationTime;
	      }
	    });
	
	    if (callback) {
	      setTimeout(callback, delayTime);
	    }
	  };
	
	  /**
	   * Resize graph of pie chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {{cx:number, cy:number, r: number}} params.circleBound circle bound
	   */
	
	
	  RaphaelPieChart.prototype.resize = function resize(params) {
	    var dimension = params.dimension,
	        circleBound = params.circleBound;
	
	    this.circleBound = circleBound;
	    this.paper.setSize(dimension.width, dimension.height);
	  };
	
	  RaphaelPieChart.prototype.findSectorInfo = function findSectorInfo(position) {
	    var sector = this.paper && this.paper.getElementByPoint(position.left, position.top);
	    var info = null;
	
	    if (sector) {
	      info = {
	        legendIndex: _tuiCodeSnippet2['default'].isExisty(sector.data('legendIndex')) ? sector.data('legendIndex') : -1,
	        index: _tuiCodeSnippet2['default'].isExisty(sector.data('index')) ? sector.data('index') : -1,
	        chartType: sector.data('chartType')
	      };
	    }
	
	    return info;
	  };
	
	  /**
	   * Whether changed or not.
	   * @param {{left: number, top: number}} prevPosition previous position
	   * @param {{left: number, top: number}} position position
	   * @returns {boolean} result boolean
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._isChangedPosition = function _isChangedPosition(prevPosition, position) {
	    return !prevPosition || prevPosition.left !== position.left || prevPosition.top !== position.top;
	  };
	
	  /**
	   * Show tooltip.
	   * @param {object} sector - raphael object
	   * @param {{left: number, top: number}} position - mouse position
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._showTooltip = function _showTooltip(sector, position) {
	    var args = [{}, 0, sector.data('index'), {
	      left: position.left - TOOLTIP_OFFSET_VALUE,
	      top: position.top - TOOLTIP_OFFSET_VALUE
	    }];
	
	    this.callbacks.showTooltip.apply(null, args);
	  };
	
	  /**
	   * Whether valid sector or not.
	   * @param {object} sector - raphael object
	   * @returns {boolean}
	   * @private
	   */
	
	
	  RaphaelPieChart.prototype._isValidSector = function _isValidSector(sector) {
	    return sector && sector.data('chartType') === this.chartType;
	  };
	
	  /**
	   * Move mouse on series.
	   * @param {{left: number, top: number}} position mouse position
	   */
	
	
	  RaphaelPieChart.prototype.moveMouseOnSeries = function moveMouseOnSeries(position) {
	    var sector = this.paper && this.paper.getElementByPoint(position.left, position.top);
	
	    if (this._isValidSector(sector)) {
	      if (this.prevHoverSector !== sector) {
	        this._showOverlay(sector.data('index'), sector.data('legendIndex'));
	        this.prevHoverSector = sector;
	      }
	
	      if (this._isChangedPosition(this.prevPosition, position)) {
	        this._showTooltip(sector, position);
	      }
	    } else if (this.prevHoverSector) {
	      this._hideOverlay();
	      this.callbacks.hideTooltip();
	      this.prevHoverSector = null;
	    }
	
	    this.prevPosition = position;
	  };
	
	  /**
	   * Select series.
	   * @param {{index: number}} indexes - index map
	   */
	
	
	  RaphaelPieChart.prototype.selectSeries = function selectSeries(indexes) {
	    var sectorInfo = this.sectorInfos[indexes.index];
	
	    if (!sectorInfo) {
	      return;
	    }
	
	    var objColor = _raphael2['default'].color(sectorInfo.color);
	    var luminanceColor = _raphaelRenderUtil2['default'].makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANT_VALUE);
	    var color = this.selectionColor || luminanceColor;
	
	    sectorInfo.sector.attr({
	      fill: color
	    });
	  };
	
	  /**
	   * Unelect series.
	   * @param {{index: number}} indexes - index map
	   */
	
	
	  RaphaelPieChart.prototype.unselectSeries = function unselectSeries(indexes) {
	    var sectorInfo = this.sectorInfos[indexes.index];
	
	    if (!sectorInfo) {
	      return;
	    }
	
	    sectorInfo.sector.attr({
	      fill: sectorInfo.color
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelPieChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var isNull = _tuiCodeSnippet2['default'].isNull(legendIndex);
	    this.sectorInfos.forEach(function (sectorInfo, index) {
	      var opacity = isNull || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      sectorInfo.sector.attr({
	        'fill-opacity': opacity
	      });
	    });
	  };
	
	  /**
	   * Get rendered label width
	   * @param {string} text - text content
	   * @param {object} theme - label theme
	   * @returns {number}
	   */
	
	
	  RaphaelPieChart.prototype.getRenderedLabelWidth = function getRenderedLabelWidth(text, theme) {
	    return _raphaelRenderUtil2['default'].getRenderedTextSize(text, theme.fontSize, theme.fontFamily).width;
	  };
	
	  /**
	   * Get rendered label height
	   * @param {string} text - text content
	   * @param {object} theme - label theme
	   * @returns {number}
	   */
	
	
	  RaphaelPieChart.prototype.getRenderedLabelHeight = function getRenderedLabelHeight(text, theme) {
	    return _raphaelRenderUtil2['default'].getRenderedTextSize(text, theme.fontSize, theme.fontFamily).height;
	  };
	
	  /**
	   * Render labels and return label set
	   * @param {object} options label render options
	   *      @param {dataType} options.dataType dataType (legend or value)
	   *      @param {object} options.paper Raphael paper
	   *      @param {Array.<object>} options.labelSet lableset
	   *      @param {object} options.positions position left, top
	   *      @param {Array.<string>} options.labels series labels
	   *      @param {object} options.theme label theme
	   *      @param {Array} options.colors series theme colors
	   */
	
	
	  RaphaelPieChart.prototype.renderLabels = function renderLabels(options) {
	    var _this2 = this;
	
	    var theme = options.theme,
	        labelFilter = options.labelFilter,
	        dataType = options.dataType,
	        ratioValues = options.ratioValues,
	        seriesNames = options.seriesNames;
	
	    var attributes = {
	      'font-size': theme.fontSize,
	      'font-family': options.fontFamily ? options.fontFamily : options.theme.fontFamily,
	      'font-weight': theme.fontWeight,
	      'text-anchor': 'middle',
	      fill: theme.color || '#fff',
	      opacity: 0
	    };
	
	    options.positions.forEach(function (position, index) {
	      var ratio = ratioValues[index];
	      var isFiltered = labelFilter && !labelFilter({
	        value: options.labels[index],
	        labelType: dataType,
	        seriesName: seriesNames[index],
	        ratio: ratio
	      });
	      var label = void 0;
	
	      if (isFiltered) {
	        return;
	      }
	
	      if (options.colors) {
	        attributes.fill = options.colors[index];
	      }
	
	      if (position) {
	        label = _raphaelRenderUtil2['default'].renderText(options.paper, position, options.labels[index], attributes);
	        label.node.style.userSelect = 'none';
	        label.node.style.cursor = 'default';
	        label.node.setAttribute('class', 'auto-shape-rendering');
	      }
	
	      _this2.labelInfos[dataType].push(label);
	      options.labelSet.push(label);
	    }, this);
	
	    if (!this.labelSet) {
	      this.labelSet = options.labelSet;
	    }
	  };
	
	  return RaphaelPieChart;
	}();
	
	exports['default'] = RaphaelPieChart;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelLineTypeBase = __webpack_require__(15);
	
	var _raphaelLineTypeBase2 = _interopRequireDefault(_raphaelLineTypeBase);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Raphael radial line series renderer.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var EMPHASIS_OPACITY = 1;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LINE_WIDTH = 6;
	
	var RaphaelRadialLineSeries = function (_RaphaelLineTypeBase) {
	  _inherits(RaphaelRadialLineSeries, _RaphaelLineTypeBase);
	
	  /**
	   * RaphaelLineCharts is graph renderer for line chart.
	   * @constructs RaphaelRadialLineSeries
	   * @extends RaphaelLineTypeBase
	   * @ignore
	   */
	  function RaphaelRadialLineSeries() {
	    _classCallCheck(this, RaphaelRadialLineSeries);
	
	    /**
	     * selected legend index
	     * @type {?number}
	     */
	    var _this = _possibleConstructorReturn(this, _RaphaelLineTypeBase.call(this));
	
	    _this.selectedLegendIndex = null;
	
	    /**
	     * type of chart
	     * @type {string}
	     */
	    _this.chartType = 'radial';
	
	    /**
	     * Line width
	     * @type {number}
	     */
	    _this.lineWidth = DEFAULT_LINE_WIDTH;
	    return _this;
	  }
	
	  /**
	   * Render function of line chart.
	   * @param {object} paper - raphael paper
	   * @param {{groupPositions: Array.<Array>, dimension: object, theme: object, options: object}} data render data
	   * @returns {object} paper raphael paper
	   */
	
	
	  RaphaelRadialLineSeries.prototype.render = function render(paper, data) {
	    var dimension = data.dimension,
	        groupPositions = data.groupPositions,
	        theme = data.theme;
	    var colors = theme.colors;
	    var _data$options = data.options,
	        pointWidth = _data$options.pointWidth,
	        showDot = _data$options.showDot,
	        showArea = _data$options.showArea;
	
	    var dotOpacity = showDot ? 1 : 0;
	
	    var groupPaths = this._getLinesPath(groupPositions);
	    var borderStyle = this.makeBorderStyle(theme.strokeColor, dotOpacity, theme.strokeWidth);
	    var outDotStyle = this.makeOutDotStyle(dotOpacity, borderStyle);
	    var radialSeriesSet = paper.set();
	    var lineWidth = this.lineWidth = pointWidth ? pointWidth : this.lineWidth;
	    var dotPositions = groupPositions.map(function (positions) {
	      positions.pop();
	
	      return positions;
	    });
	
	    this.paper = paper;
	    this.theme = theme;
	    this.dimension = dimension;
	    this.position = data.position;
	
	    if (showArea) {
	      this.groupAreas = this._renderArea(paper, groupPaths, colors, radialSeriesSet);
	    }
	
	    this.groupLines = this._renderLines(paper, groupPaths, colors, lineWidth, radialSeriesSet);
	    this.groupDots = this._renderDots(paper, dotPositions, colors, dotOpacity, radialSeriesSet);
	
	    if (data.options.allowSelect) {
	      this.selectionDot = this._makeSelectionDot(paper);
	      this.selectionColor = theme.selectionColor;
	    }
	
	    this.colors = colors;
	    this.borderStyle = borderStyle;
	    this.outDotStyle = outDotStyle;
	    this.groupPositions = groupPositions;
	    this.groupPaths = groupPaths;
	    this.dotOpacity = dotOpacity;
	    this.showArea = showArea;
	
	    return radialSeriesSet;
	  };
	
	  /**
	   * Get lines path.
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @returns {Array.<Array.<string>>} path
	   * @private
	   */
	
	
	  RaphaelRadialLineSeries.prototype._getLinesPath = function _getLinesPath(groupPositions) {
	    var _this2 = this;
	
	    return groupPositions.map(function (positions) {
	      return _this2._makeLinesPath(positions);
	    });
	  };
	
	  /**
	   * Render lines.
	   * @param {object} paper raphael paper
	   * @param {Array.<Array.<string>>} groupPaths paths
	   * @param {string[]} colors line colors
	   * @param {?number} strokeWidth stroke width
	   * @param {Array.<object>} radialSeriesSet radial line series set
	   * @returns {Array.<Array.<object>>} lines
	   * @private
	   */
	
	
	  RaphaelRadialLineSeries.prototype._renderLines = function _renderLines(paper, groupPaths, colors, strokeWidth, radialSeriesSet) {
	    return groupPaths.map(function (path, groupIndex) {
	      var color = colors[groupIndex] || 'transparent';
	      var line = _raphaelRenderUtil2['default'].renderLine(paper, path.join(' '), color, strokeWidth);
	
	      radialSeriesSet.push(line);
	
	      return line;
	    });
	  };
	
	  /**
	   * Render area.
	   * @param {object} paper raphael paper
	   * @param {Array.<Array.<string>>} groupPaths paths
	   * @param {string[]} colors line colors
	   * @param {Array.<object>} radialSeriesSet radial line series set
	   * @returns {Array.<Array.<object>>} lines
	   * @private
	   */
	
	
	  RaphaelRadialLineSeries.prototype._renderArea = function _renderArea(paper, groupPaths, colors, radialSeriesSet) {
	    var _this3 = this;
	
	    return groupPaths.map(function (path, groupIndex) {
	      var color = colors[groupIndex] || 'transparent';
	      var area = _raphaelRenderUtil2['default'].renderArea(paper, path, {
	        fill: color,
	        opacity: 0.4,
	        'stroke-width': _this3.lineWidth,
	        stroke: color
	      });
	
	      radialSeriesSet.push(area);
	
	      return area;
	    }, this);
	  };
	
	  /**
	   * Resize graph of line chart.
	   * /todo copied at raphaelLineCharts#resize, should remove duplication
	   * tooltipLine code was deleted, as group tooltip not works on radial chart/
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension dimension
	   *      @param {Array.<Array.<{left:number, top:number}>>} params.groupPositions group positions
	   */
	
	
	  RaphaelRadialLineSeries.prototype.resize = function resize(params) {
	    var _this4 = this;
	
	    var dimension = params.dimension,
	        groupPositions = params.groupPositions;
	
	
	    this.groupPositions = groupPositions;
	    this.groupPaths = this._getLinesPath(groupPositions);
	    this.paper.setSize(dimension.width, dimension.height);
	
	    this.groupPaths.forEach(function (path, groupIndex) {
	      _this4.groupLines[groupIndex].attr({ path: path.join(' ') });
	      if (_this4.showArea) {
	        _this4.groupAreas[groupIndex].attr({ path: path.join(' ') });
	      }
	      _this4.groupDots[groupIndex].forEach(function (item, index) {
	        _this4._moveDot(item.endDot.dot, groupPositions[groupIndex][index]);
	      });
	    });
	  };
	
	  /**
	   * Select legend.
	   * /todo copied at raphaelLineCharts, should remove duplication
	   * @param {?number} legendIndex legend index
	   */
	
	
	  RaphaelRadialLineSeries.prototype.selectLegend = function selectLegend(legendIndex) {
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    this.selectedLegendIndex = legendIndex;
	
	    this.groupLines.forEach(function (line, groupIndex) {
	      var opacity = noneSelected || legendIndex === groupIndex ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      line.attr({ 'stroke-opacity': opacity });
	    });
	  };
	
	  return RaphaelRadialLineSeries;
	}(_raphaelLineTypeBase2['default']);
	
	exports['default'] = RaphaelRadialLineSeries;

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael bubble chart renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var CIRCLE_OPACITY = 0.8;
	var STROKE_OPACITY = 1;
	var EMPHASIS_OPACITY = 0.8;
	var DE_EMPHASIS_OPACITY = 0.3;
	var DEFAULT_LUMINANC = 0.2;
	var OVERLAY_BORDER_WIDTH = 2;
	var TOOLTIP_OFFSET_VALUE = 20;
	
	/**
	 * bound for circle
	 * @typedef {{left: number, top: number, radius: number}} bound
	 * @private
	 */
	
	/**
	 * Information for rendered circle
	 * @typedef {{circle: object, color: string, bound: bound}} circleInfo
	 * @private
	 */
	
	/**
	 * @classdesc RaphaelBubbleChart is graph renderer for bubble chart.
	 * @class RaphaelBubbleChart
	 * @private
	 */
	
	var RaphaelBubbleChart = function () {
	  function RaphaelBubbleChart() {
	    _classCallCheck(this, RaphaelBubbleChart);
	  }
	
	  /**
	   * Render function of bubble chart
	   * @param {object} paper - Raphael paper
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      seriesDataModel: SeriesDataModel,
	   *      groupBounds: Array.<Array.<bound>>,
	   *      theme: object
	   * }} data - data for rendering
	   * @param {{showTooltip: function, hideTooltip: function}} callbacks - callbacks for toggle of tooltip.
	   * @returns {object}
	   */
	  RaphaelBubbleChart.prototype.render = function render(paper, data, callbacks) {
	    var circleSet = paper.set();
	
	    this.paper = paper;
	    this.animationDuration = data.options.animationDuration;
	
	    /**
	     * theme
	     * @type {object}
	     */
	    this.theme = data.theme;
	
	    /**
	     * seriesDataModel
	     * @type {SeriesDataModel}
	     */
	    this.seriesDataModel = data.seriesDataModel;
	
	    /**
	     * group bounds
	     * @type {Array.<Array.<bound>>}
	     */
	    this.groupBounds = data.groupBounds;
	
	    /**
	     * callbacks for toggle of tooltip.
	     * @type {{showTooltip: Function, hideTooltip: Function}}
	     */
	    this.callbacks = callbacks;
	
	    /**
	     * overlay is circle object of raphael, that using for mouseover.
	     * @type {object}
	     */
	    this.overlay = this._renderOverlay();
	
	    /**
	     * two-dimensional array by circleInfo
	     * @type {Array.<Array.<circleInfo>>}
	     */
	    this.groupCircleInfos = this._renderCircles(circleSet);
	
	    /**
	     * previous selected circle
	     * @type {?object}
	     */
	    this.prevCircle = null;
	
	    /**
	     * previous over circle
	     * @type {?object}
	     */
	    this.prevOverCircle = null;
	
	    /**
	     * animation timeout id
	     * @type {?number}
	     */
	    this.animationTimeoutId = null;
	
	    /**
	     * selected legend
	     * @type {?number}
	     */
	    this.selectedLegend = null;
	
	    if (this.paper.raphael.svg) {
	      this.appendShadowFilterToDefs();
	    }
	
	    return circleSet;
	  };
	
	  /**
	   * Render overlay.
	   * @returns {object}
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._renderOverlay = function _renderOverlay() {
	    var position = {
	      left: 0,
	      top: 0
	    };
	    var attribute = {
	      fill: 'none',
	      stroke: '#fff',
	      'stroke-opacity': STROKE_OPACITY,
	      'stroke-width': 2
	    };
	    var circle = _raphaelRenderUtil2['default'].renderCircle(this.paper, position, 0, attribute);
	
	    return circle;
	  };
	
	  /**
	   * Render circles.
	   * @param {object} circleSet - circle set
	   * @returns {Array.<Array.<circleInfo>>}
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._renderCircles = function _renderCircles(circleSet) {
	    var _this = this;
	
	    var colors = this.theme.colors;
	
	
	    return this.groupBounds.map(function (bounds, groupIndex) {
	      return bounds.map(function (bound, index) {
	        var circleInfo = null;
	
	        if (bound) {
	          var color = colors[index];
	          var circle = _raphaelRenderUtil2['default'].renderCircle(_this.paper, bound, _this.animationDuration ? 0 : bound.radius, {
	            fill: color,
	            opacity: _this.animationDuration ? 0 : CIRCLE_OPACITY,
	            stroke: 'none'
	          });
	
	          circleSet.push(circle);
	
	          circle.data('groupIndex', groupIndex);
	          circle.data('index', index);
	          circleInfo = {
	            circle: circle,
	            color: color,
	            bound: bound
	          };
	        }
	
	        return circleInfo;
	      });
	    });
	  };
	
	  /**
	   * Animate circle
	   * @param {object} circle - raphael object
	   * @param {number} radius - radius of circle
	   * @param {number} animationDuration - animation duration
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._animateCircle = function _animateCircle(circle, radius, animationDuration) {
	    circle.animate({
	      r: radius,
	      opacity: CIRCLE_OPACITY
	    }, animationDuration, '>');
	  };
	
	  /**
	   * Animate.
	   */
	
	
	  RaphaelBubbleChart.prototype.animate = function animate() {
	    var _this2 = this;
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupCircleInfos, function (circleInfo) {
	      if (!circleInfo) {
	        return;
	      }
	      if (_this2.animationDuration) {
	        _this2._animateCircle(circleInfo.circle, circleInfo.bound.radius, _this2.animationDuration);
	      }
	    });
	  };
	
	  /**
	   * Update circle bound
	   * @param {object} circle - raphael object
	   * @param {{left: number, top: number}} bound - bound
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._updatePosition = function _updatePosition(circle, bound) {
	    circle.attr({
	      cx: bound.left,
	      cy: bound.top,
	      r: bound.radius
	    });
	  };
	
	  /**
	   * Resize graph of bubble type chart.
	   * @param {object} params parameters
	   *      @param {{width: number, height:number}} params.dimension - dimension
	   *      @param {Array.<Array.<bound>>} params.groupBounds - group bounds
	   */
	
	
	  RaphaelBubbleChart.prototype.resize = function resize(params) {
	    var _this3 = this;
	
	    var dimension = params.dimension,
	        groupBounds = params.groupBounds;
	
	
	    this.groupBounds = groupBounds;
	    this.paper.setSize(dimension.width, dimension.height);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupCircleInfos, function (circleInfo, groupIndex, index) {
	      var bound = groupBounds[groupIndex][index];
	      if (circleInfo) {
	        circleInfo.bound = bound;
	        _this3._updatePosition(circleInfo.circle, bound);
	      }
	    });
	  };
	
	  /**
	   * Find data indexes of rendered circle by position.
	   * @param {{left: number, top: number}} position - mouse position
	   * @returns {{index: number, groupIndex: number}}
	   */
	
	
	  RaphaelBubbleChart.prototype.findIndexes = function findIndexes(position) {
	    var circle = this.paper.getElementByPoint(position.left, position.top);
	    var foundIndexes = null;
	
	    if (circle) {
	      foundIndexes = {
	        index: circle.data('index'),
	        groupIndex: circle.data('groupIndex')
	      };
	    }
	
	    return foundIndexes;
	  };
	
	  RaphaelBubbleChart.prototype.appendShadowFilterToDefs = function appendShadowFilterToDefs() {
	    var filter = document.createElementNS('http://www.w3.org/2000/svg', 'filter');
	    var feOffset = document.createElementNS('http://www.w3.org/2000/svg', 'feOffset');
	    var feGaussianBlur = document.createElementNS('http://www.w3.org/2000/svg', 'feGaussianBlur');
	    var feBlend = document.createElementNS('http://www.w3.org/2000/svg', 'feBlend');
	
	    filter.setAttributeNS(null, 'id', 'shadow');
	    filter.setAttributeNS(null, 'x', '-50%');
	    filter.setAttributeNS(null, 'y', '-50%');
	    filter.setAttributeNS(null, 'width', '180%');
	    filter.setAttributeNS(null, 'height', '180%');
	    feOffset.setAttributeNS(null, 'result', 'offOut');
	    feOffset.setAttributeNS(null, 'in', 'SourceAlpha');
	    feOffset.setAttributeNS(null, 'dx', '0');
	    feOffset.setAttributeNS(null, 'dy', '0');
	    feGaussianBlur.setAttributeNS(null, 'result', 'blurOut');
	    feGaussianBlur.setAttributeNS(null, 'in', 'offOut');
	    feGaussianBlur.setAttributeNS(null, 'stdDeviation', '2');
	    feBlend.setAttributeNS(null, 'in', 'SourceGraphic');
	    feBlend.setAttributeNS(null, 'in2', 'blurOut');
	    feBlend.setAttributeNS(null, 'mode', 'normal');
	    filter.appendChild(feOffset);
	    filter.appendChild(feGaussianBlur);
	    filter.appendChild(feBlend);
	    this.paper.defs.appendChild(filter);
	  };
	
	  /**
	   * Whether changed or not.
	   * @param {{left: number, top: number}} prevPosition - previous position
	   * @param {{left: number, top: number}} position - position
	   * @returns {boolean} result boolean
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._isChangedPosition = function _isChangedPosition(prevPosition, position) {
	    return !prevPosition || prevPosition.left !== position.left || prevPosition.top !== position.top;
	  };
	
	  /**
	   * Show overlay with animation.
	   * @param {object} indexes - indexes
	   *      @param {number} indexes.groupIndex - index of circles group
	   *      @param {number} indexes.index - index of circles
	   */
	
	
	  RaphaelBubbleChart.prototype.showAnimation = function showAnimation(indexes) {
	    var circleInfo = this.groupCircleInfos[indexes.groupIndex][indexes.index];
	    var bound = circleInfo.bound;
	
	    this.circle = circleInfo.circle;
	
	    this.overlay.attr({
	      fill: circleInfo.color,
	      cx: bound.left,
	      cy: bound.top,
	      r: bound.radius + OVERLAY_BORDER_WIDTH,
	      stroke: '#fff',
	      opacity: 1
	    });
	
	    this.circle.attr({
	      opacity: 1
	    });
	
	    this.overlay.node.setAttribute('filter', 'url(#shadow)');
	    this.overlay.toFront();
	    this.circle.toFront();
	  };
	
	  /**
	   * Hide overlay with animation.
	   * @param {object} indexes - indexes
	   *      @param {number} indexes.groupIndex - index of circles group
	   *      @param {number} indexes.index - index of circles
	   */
	
	
	  RaphaelBubbleChart.prototype.hideAnimation = function hideAnimation(indexes) {
	    var changeOpacity = DE_EMPHASIS_OPACITY;
	    this.overlay.attr({
	      cx: 0,
	      cy: 0,
	      r: 0,
	      opacity: 0
	    });
	
	    if (_tuiCodeSnippet2['default'].isNull(this.selectedLegend) || indexes.index === this.selectedLegend) {
	      changeOpacity = EMPHASIS_OPACITY;
	    }
	
	    this.circle.attr({
	      opacity: changeOpacity
	    });
	  };
	
	  /**
	   * Find circle.
	   * @param {{left: number, top: number}} position - position
	   * @returns {?object}
	   * @private
	   */
	
	
	  RaphaelBubbleChart.prototype._findCircle = function _findCircle(position) {
	    var circles = [];
	    var paper = this.paper;
	
	    var foundCircle = void 0;
	
	    while (_tuiCodeSnippet2['default'].isUndefined(foundCircle)) {
	      var circle = paper.getElementByPoint(position.left, position.top);
	
	      if (circle) {
	        if (circle.attrs.opacity > DE_EMPHASIS_OPACITY) {
	          foundCircle = circle;
	        } else {
	          circles.push(circle);
	          circle.hide();
	        }
	      } else {
	        foundCircle = null;
	      }
	    }
	
	    if (!foundCircle) {
	      foundCircle = circles[0];
	    }
	
	    circles.forEach(function (_circle) {
	      _circle.show();
	    });
	
	    return foundCircle;
	  };
	
	  /**
	   * Move mouse on series.
	   * @param {{left: number, top: number}} position - mouse position
	   */
	
	
	  RaphaelBubbleChart.prototype.moveMouseOnSeries = function moveMouseOnSeries(position) {
	    var circle = this._findCircle(position);
	
	    if (circle && _tuiCodeSnippet2['default'].isExisty(circle.data('groupIndex'))) {
	      var groupIndex = circle.data('groupIndex');
	      var index = circle.data('index');
	      var args = [{}, groupIndex, index, {
	        left: position.left - TOOLTIP_OFFSET_VALUE,
	        top: position.top - TOOLTIP_OFFSET_VALUE
	      }];
	
	      if (this._isChangedPosition(this.prevPosition, position)) {
	        this.callbacks.showTooltip.apply(null, args);
	        this.prevOverCircle = circle;
	      }
	    } else if (this.prevOverCircle) {
	      this.callbacks.hideTooltip();
	      this.prevOverCircle = null;
	    }
	    this.prevPosition = position;
	  };
	
	  /**
	   * Select series.
	   * @param {{index: number, groupIndex: number}} indexes - index map
	   */
	
	
	  RaphaelBubbleChart.prototype.selectSeries = function selectSeries(indexes) {
	    var groupIndex = indexes.groupIndex,
	        index = indexes.index;
	
	    var circleInfo = this.groupCircleInfos[groupIndex][index];
	    var objColor = _raphael2['default'].color(circleInfo.color);
	    var themeColor = this.theme.selectionColor;
	    var color = themeColor || _raphaelRenderUtil2['default'].makeChangedLuminanceColor(objColor.hex, DEFAULT_LUMINANC);
	
	    circleInfo.circle.attr({
	      fill: color
	    });
	  };
	
	  /**
	   * Unselect series.
	   * @param {{index: number, groupIndex: number}} indexes - index map
	   */
	
	
	  RaphaelBubbleChart.prototype.unselectSeries = function unselectSeries(indexes) {
	    var groupIndex = indexes.groupIndex,
	        index = indexes.index;
	
	    var circleInfo = this.groupCircleInfos[groupIndex][index];
	
	    circleInfo.circle.attr({
	      fill: circleInfo.color
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {?number} legendIndex - index of legend
	   */
	
	
	  RaphaelBubbleChart.prototype.selectLegend = function selectLegend(legendIndex) {
	    var noneSelected = _tuiCodeSnippet2['default'].isNull(legendIndex);
	
	    this.selectedLegend = legendIndex;
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.groupCircleInfos, function (circleInfo, groupIndex, index) {
	      if (!circleInfo) {
	        return;
	      }
	
	      var opacity = noneSelected || legendIndex === index ? EMPHASIS_OPACITY : DE_EMPHASIS_OPACITY;
	
	      circleInfo.circle.attr({ opacity: opacity });
	    });
	  };
	
	  return RaphaelBubbleChart;
	}();
	
	exports['default'] = RaphaelBubbleChart;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelBoxTypeChart is graph renderer for box type chart(heatmap chart, treemap chart).
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var ANIMATION_DURATION = 100;
	var MIN_BORDER_WIDTH = 0;
	var MAX_BORDER_WIDTH = 4;
	
	/**
	 * @classdesc RaphaelBoxTypeChart is graph renderer for box type chart(heatmap chart, treemap chart).
	 * @class RaphaelBarChart
	 * @private
	 */
	
	var RaphaelBoxTypeChart = function () {
	  function RaphaelBoxTypeChart() {
	    _classCallCheck(this, RaphaelBoxTypeChart);
	  }
	
	  /**
	   * Render function of bar chart
	   * @param {object} paper Raphael paper
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      colorSpectrum: object,
	   *      seriesDataModel: SeriesDataModel,
	   *      groupBounds: (Array.<Array.<object>>|object.<string, object>),
	   *      theme: object
	   * }} seriesData - data for graph rendering
	   * @returns {object}
	   */
	  RaphaelBoxTypeChart.prototype.render = function render(paper, seriesData) {
	    var seriesSet = paper.set();
	
	    this.paper = paper;
	
	    this.chartType = seriesData.chartType;
	
	    /**
	     * theme
	     * @type {*|{}}
	     */
	    this.theme = seriesData.theme || {};
	
	    /**
	     * color spectrum
	     * @type {Object}
	     */
	    this.colorSpectrum = seriesData.colorSpectrum;
	
	    /**
	     * chart background
	     */
	    this.chartBackground = seriesData.chartBackground;
	
	    /**
	     * zoomable option
	     */
	    this.zoomable = seriesData.zoomable;
	
	    /**
	     * options useColorValue
	     */
	    this.useColorValue = seriesData.options.useColorValue;
	
	    /**
	     * border color for rendering box
	     * @type {string}
	     */
	    this.borderColor = this.theme.borderColor || 'none';
	
	    /**
	     * border width for rendering box
	     */
	    this.borderWidth = this.theme.borderWidth;
	
	    /**
	     * group bounds
	     * @type {Array.<Array.<object>>|object.<string, object>}
	     */
	    this.groupBounds = seriesData.groupBounds;
	
	    /**
	     * bound map
	     * @type {object.<string, {left: number, top: number, width: number, height: number}>}
	     */
	    this.boundMap = seriesData.boundMap;
	
	    this._bindGetBoundFunction();
	    this._bindGetColorFunction();
	
	    this.seriesDataModel = seriesData.seriesDataModel;
	
	    /**
	     * boxes set
	     * @type {Array.<Array.<{rect: Object, color: string}>>}
	     */
	    this.boxesSet = this._renderBoxes(seriesData.seriesDataModel, seriesData.startDepth, !!seriesData.isPivot, seriesSet);
	    this.rectOverlay = this._renderRectOverlay();
	
	    return seriesSet;
	  };
	
	  /**
	   * Render overlay.
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._renderRectOverlay = function _renderRectOverlay() {
	    var bound = {
	      width: 1,
	      height: 1,
	      left: 0,
	      top: 0
	    };
	    var attributes = {
	      'fill-opacity': 0
	    };
	
	    var rectOverlay = _raphaelRenderUtil2['default'].renderRect(this.paper, bound, Object.assign({
	      'stroke-width': 0
	    }, attributes));
	
	    rectOverlay.node.setAttribute('filter', 'url(#shadow)');
	
	    return rectOverlay;
	  };
	
	  /**
	   * Bind _getBound private function.
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._bindGetBoundFunction = function _bindGetBoundFunction() {
	    if (this.boundMap) {
	      this._getBound = this._getBoundFromBoundMap;
	    } else {
	      this._getBound = this._getBoundFromGroupBounds;
	    }
	  };
	
	  /**
	   * Bind _bindGetColorFunction private function.
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._bindGetColorFunction = function _bindGetColorFunction() {
	    if (this.colorSpectrum) {
	      this._getColor = this._getColorFromSpectrum;
	    } else {
	      this._getColor = this._getColorFromColors;
	    }
	  };
	
	  /**
	   * Get bound from groupBounds by indexes(groupIndex, index) of seriesItem.
	   * @param {SeriesItem} seriesItem - seriesItem
	   * @returns {{width: number, height: number, left: number, top: number}}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._getBoundFromGroupBounds = function _getBoundFromGroupBounds(seriesItem) {
	    return this.groupBounds[seriesItem.groupIndex][seriesItem.index].end;
	  };
	
	  /**
	   * Get bound from boundMap by id of seriesItem.
	   * @param {SeriesItem} seriesItem - seriesItem
	   * @returns {{width: number, height: number, left: number, top: number}}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._getBoundFromBoundMap = function _getBoundFromBoundMap(seriesItem) {
	    return this.boundMap[seriesItem.id];
	  };
	
	  /**
	   * Get color from colorSpectrum by ratio of seriesItem.
	   * @param {SeriesItem} seriesItem - seriesItem
	   * @param {number} startDepth - start depth
	   * @returns {string}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._getColorFromSpectrum = function _getColorFromSpectrum(seriesItem, startDepth) {
	    var color = void 0;
	
	    if (!seriesItem.hasChild || seriesItem.depth !== startDepth) {
	      color = this.colorSpectrum.getColor(seriesItem.colorRatio || seriesItem.ratio) || this.chartBackground;
	    } else {
	      color = 'none';
	    }
	
	    return color;
	  };
	
	  /**
	   * Get color from colors theme by group property of seriesItem.
	   * @param {SeriesItem} seriesItem - seriesItem
	   * @param {number} startDepth - start depth
	   * @returns {string}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._getColorFromColors = function _getColorFromColors(seriesItem, startDepth) {
	    return seriesItem.depth === startDepth ? this.theme.colors[seriesItem.group] : '#000';
	  };
	
	  /**
	   * Render rect.
	   * @param {{width: number, height: number, left: number, top: number}} bound - bound
	   * @param {string} color - color
	   * @param {number} strokeWidth - stroke width
	   * @param {number} [fillOpacity] - fill opacity
	   * @returns {object}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._renderRect = function _renderRect(bound, color, strokeWidth, fillOpacity) {
	    return _raphaelRenderUtil2['default'].renderRect(this.paper, bound, {
	      fill: color,
	      stroke: this.borderColor,
	      'stroke-width': strokeWidth,
	      'fill-opacity': fillOpacity
	    });
	  };
	
	  /**
	   * Get stroke width.
	   * @param {boolean} isFirstDepth - whether it is same to first depth or not
	   * @returns {number}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._getStrokeWidth = function _getStrokeWidth(isFirstDepth) {
	    var strokeWidth = void 0;
	
	    if (this.borderWidth) {
	      strokeWidth = this.borderWidth;
	    } else if (isFirstDepth) {
	      strokeWidth = MAX_BORDER_WIDTH;
	    } else {
	      strokeWidth = MIN_BORDER_WIDTH;
	    }
	
	    return strokeWidth;
	  };
	
	  /**
	   * Render boxes.
	   * @param {SeriesDataModel} seriesDataModel - seriesDataModel
	   * @param {number} startDepth - start depth
	   * @param {boolean} isPivot - whether pivot or not
	   * @param {Array.<object>} seriesSet - seriesSet
	   * @returns {Array.<Array.<{rect: object, color: string}>>}
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._renderBoxes = function _renderBoxes(seriesDataModel, startDepth, isPivot, seriesSet) {
	    var _this = this;
	
	    var isTreemap = _predicate2['default'].isTreemapChart(this.chartType);
	
	    return seriesDataModel.map(function (seriesGroup, groupIndex) {
	      if (isTreemap && !_this.colorSpectrum && seriesGroup.getSeriesItemCount()) {
	        var firstItem = seriesGroup.getSeriesItem(0);
	        _this._setTreeFillOpacity({
	          id: firstItem.parent
	        }, startDepth);
	      }
	
	      return seriesGroup.map(function (seriesItem, index) {
	        var result = null;
	        var depth = seriesItem.depth;
	
	        var strokeWidth = _this.colorSpectrum ? 0 : _this._getStrokeWidth(depth === startDepth);
	        var fillOpacity = _this.colorSpectrum ? 1 : seriesItem.fillOpacity;
	
	        seriesItem.groupIndex = groupIndex;
	        seriesItem.index = index;
	        var bound = _this._getBound(seriesItem);
	
	        if (bound) {
	          var color = _this._getColor(seriesItem, startDepth);
	          result = {
	            rect: _this._renderRect(bound, color, strokeWidth, fillOpacity),
	            seriesItem: seriesItem,
	            color: color
	          };
	
	          if (seriesSet) {
	            seriesSet.push(result.rect);
	          }
	        }
	
	        return result;
	      });
	    }, isPivot);
	  };
	
	  /**
	   * @param {{id: number, fillOpacity: number}} parentInfo - parent info
	   * @param {number} startDepth - start depth
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._setTreeFillOpacity = function _setTreeFillOpacity(parentInfo, startDepth) {
	    var _this2 = this;
	
	    var children = this.seriesDataModel.findSeriesItemsByParent(parentInfo.id);
	
	    children.forEach(function (datum, index) {
	      var depth = datum.depth;
	
	
	      if (depth === startDepth) {
	        datum.fillOpacity = 1;
	      } else if (depth === startDepth + 1) {
	        datum.fillOpacity = 0.05 * index;
	      } else if (depth < startDepth) {
	        datum.fillOpacity = 0;
	      } else {
	        datum.fillOpacity = parentInfo.fillOpacity + 0.05 * index;
	      }
	
	      if (datum.hasChild) {
	        _this2._setTreeFillOpacity({
	          id: datum.id,
	          fillOpacity: datum.fillOpacity
	        }, startDepth);
	      }
	    });
	  };
	
	  /**
	   * Animate changing color of box.
	   * @param {object} rect - raphael object
	   * @param {string} [color] - fill color
	   * @param {number} [opacity] - fill opacity
	   * @param {number} [strokeColor] - stroke color
	   * @param {number} [strokeWidth] - stroke width
	   * @private
	   */
	
	
	  RaphaelBoxTypeChart.prototype._animateChangingColor = function _animateChangingColor(rect, color, opacity, strokeColor, strokeWidth) {
	    var properties = {
	      'fill-opacity': _tuiCodeSnippet2['default'].isExisty(opacity) ? opacity : 1,
	      stroke: strokeColor,
	      'stroke-width': strokeWidth
	    };
	
	    if (color) {
	      properties.fill = color;
	    }
	
	    rect.animate(properties, ANIMATION_DURATION, '>');
	  };
	
	  /**
	   * Show animation.
	   * @param {{groupIndex: number, index:number}} indexes - index info
	   */
	
	
	  RaphaelBoxTypeChart.prototype.showAnimation = function showAnimation(indexes) {
	    var box = this.boxesSet[indexes.groupIndex][indexes.index];
	
	    if (!box) {
	      return;
	    }
	
	    var rect = box.rect.node;
	    var color = box.color;
	
	
	    if (this.chartType === 'treemap' && !this.zoomable && !this.useColorValue) {
	      color = this.theme.colors[indexes.index];
	    }
	
	    this.rectOverlay.attr({
	      x: rect.getAttribute('x'),
	      y: rect.getAttribute('y'),
	      width: rect.getAttribute('width'),
	      height: rect.getAttribute('height'),
	      fill: color,
	      'fill-opacity': 1,
	      stroke: '#ffffff',
	      'stroke-width': 4,
	      'stroke-opacity': 1
	    });
	
	    this.rectOverlay.toFront();
	
	    if (this.labelSet) {
	      this.labelSet.toFront();
	    }
	  };
	
	  /**
	   * Hide animation.
	   * @param {{groupIndex: number, index:number}} indexes - index info
	   */
	
	
	  RaphaelBoxTypeChart.prototype.hideAnimation = function hideAnimation(indexes) {
	    var box = this.boxesSet[indexes.groupIndex][indexes.index];
	
	    if (!box) {
	      return;
	    }
	
	    this.rectOverlay.attr({
	      width: 1,
	      height: 1,
	      x: 0,
	      y: 0,
	      'fill-opacity': 0,
	      'stroke-opacity': 0
	    });
	  };
	
	  /**
	   * Resize.
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      groupBounds: (Array.<Array.<object>>|object.<string, object>)
	   * }} seriesData - data for graph rendering
	   */
	
	
	  RaphaelBoxTypeChart.prototype.resize = function resize(seriesData) {
	    var _this3 = this;
	
	    var dimension = seriesData.dimension;
	
	
	    this.boundMap = seriesData.boundMap;
	    this.groupBounds = seriesData.groupBounds;
	    this.paper.setSize(dimension.width, dimension.height);
	
	    _raphaelRenderUtil2['default'].forEach2dArray(this.boxesSet, function (box, groupIndex, index) {
	      if (!box) {
	        return;
	      }
	
	      var bound = _this3._getBound(box.seriesItem, groupIndex, index);
	
	      if (bound) {
	        _raphaelRenderUtil2['default'].updateRectBound(box.rect, bound);
	      }
	    });
	  };
	
	  RaphaelBoxTypeChart.prototype.renderSeriesLabel = function renderSeriesLabel(paper, positionSet, labels, labelTheme) {
	    var labelSet = paper.set();
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: '#ffffff',
	      opacity: 0
	    };
	
	    labels.forEach(function (categoryLabel, categoryIndex) {
	      categoryLabel.forEach(function (label, seriesIndex) {
	        var seriesLabel = _raphaelRenderUtil2['default'].renderText(paper, positionSet[categoryIndex][seriesIndex].end, label, attributes);
	
	        seriesLabel.node.style.userSelect = 'none';
	        seriesLabel.node.style.cursor = 'default';
	
	        labelSet.push(seriesLabel);
	      });
	    });
	
	    this.labelSet = labelSet;
	
	    return labelSet;
	  };
	
	  RaphaelBoxTypeChart.prototype.renderSeriesLabelForTreemap = function renderSeriesLabelForTreemap(paper, positions, labels, labelTheme) {
	    var labelSet = paper.set();
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      opacity: 0
	    };
	
	    labels.forEach(function (label, index) {
	      if (positions[index]) {
	        var seriesLabel = _raphaelRenderUtil2['default'].renderText(paper, positions[index], label, attributes);
	
	        seriesLabel.node.style.userSelect = 'none';
	        seriesLabel.node.style.cursor = 'default';
	
	        labelSet.push(seriesLabel);
	      }
	    });
	
	    this.labelSet = labelSet;
	
	    return labelSet;
	  };
	
	  return RaphaelBoxTypeChart;
	}();
	
	exports['default'] = RaphaelBoxTypeChart;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _templateObject = _taggedTemplateLiteral(['\n                  s', ',', ',0,0\n                  t', ',', '\n                '], ['\n                  s', ',', ',0,0\n                  t', ',', '\n                ']),
	    _templateObject2 = _taggedTemplateLiteral(['\n                s', ',', ',0,0\n                t', ',', '\n            '], ['\n                s', ',', ',0,0\n                t', ',', '\n            ']);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _taggedTemplateLiteral(strings, raw) { return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelPieCharts is graph renderer for map chart.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var IS_LTE_IE8 = browser.msie && browser.version <= 8;
	var STROKE_COLOR = 'gray';
	var ANIMATION_DURATION = 100;
	var G_ID = 'tui-chart-series-group';
	var FILL_COLOR_OF_NO_DATA = '#eee';
	
	/**
	 * @classdesc RaphaelMapCharts is graph renderer for map chart.
	 * @class RaphaelMapChart
	 * @private
	 */
	
	var RaphaelMapChart = function () {
	  function RaphaelMapChart() {
	    _classCallCheck(this, RaphaelMapChart);
	  }
	
	  /**
	   * Render function of map chart.
	   * @param {object} paper paper object
	   * @param {object} data data
	   *      @param {{width: number, height: number}} data.dimension series dimension
	   *      @param {Array.<{code: string, path: string}>} data.map mapData
	   *      @param {ColorSpectrum} data.colorSpectrum color model
	   */
	  RaphaelMapChart.prototype.render = function render(paper, data) {
	    var mapDimension = data.mapModel.getMapDimension();
	
	    this.ratio = this._getDimensionRatio(data.layout.dimension, mapDimension);
	    this.dimension = data.layout.dimension;
	    this.position = data.layout.position;
	    this.paper = paper;
	    this.sectorSet = paper.set();
	    this.sectors = this._renderMap(data, this.ratio);
	
	    if (!IS_LTE_IE8) {
	      this.g = createGElement(paper, this.sectorSet, G_ID);
	    }
	
	    this.overColor = data.theme.overColor;
	  };
	
	  /**
	   * Get dimension ratio
	   * @param {object} dimension dimension
	   * @param {object} mapDimension map dimension
	   * @returns {number}
	   * @private
	   */
	
	
	  RaphaelMapChart.prototype._getDimensionRatio = function _getDimensionRatio(dimension, mapDimension) {
	    return Math.min(dimension.height / mapDimension.height, dimension.width / mapDimension.width);
	  };
	
	  /**
	   * Render map graph.
	   * @param {object} data data
	   *      @param {{width: number, height: number}} data.dimension series dimension
	   *      @param {Array.<{code: string, path: string}>} data.map mapData
	   *      @param {ColorSpectrum} data.colorSpectrum color model
	   * @param {number} dimensionRatio dimension ratio of rendering by map
	   * @returns {Array.<{sector: object, color: string, data: object}>} rendered map information
	   * @private
	   */
	
	
	  RaphaelMapChart.prototype._renderMap = function _renderMap(data, dimensionRatio) {
	    var sectorSet = this.sectorSet,
	        paper = this.paper;
	    var position = data.layout.position;
	    var colorSpectrum = data.colorSpectrum;
	
	
	    return data.mapModel.getMapData().map(function (datum, index) {
	      var ratio = datum.ratio,
	          path = datum.path;
	
	      var color = ratio ? colorSpectrum.getColor(ratio) : FILL_COLOR_OF_NO_DATA;
	      var sector = _raphaelRenderUtil2['default'].renderArea(paper, path, {
	        fill: color,
	        opacity: 1,
	        stroke: STROKE_COLOR,
	        'stroke-width': 0.2,
	        'stroke-opacity': 1,
	        transform: _renderUtil2['default'].oneLineTrim(_templateObject, dimensionRatio, dimensionRatio, position.left / dimensionRatio, position.top / dimensionRatio)
	      });
	
	      sector.data('index', index);
	
	      sectorSet.push(sector);
	
	      return {
	        sector: sector,
	        color: color,
	        ratio: ratio
	      };
	    });
	  };
	
	  /**
	   * Find sector index.
	   * @param {{left: number, top: number}} position position
	   * @returns {?number} found index
	   */
	
	
	  RaphaelMapChart.prototype.findSectorIndex = function findSectorIndex(position) {
	    var sector = this.paper.getElementByPoint(position.left, position.top);
	    var foundIndex = sector && sector.data('index');
	    var data = !_tuiCodeSnippet2['default'].isUndefined(foundIndex) && this.sectors[foundIndex];
	
	    return data && !_tuiCodeSnippet2['default'].isUndefined(data.ratio) ? foundIndex : null;
	  };
	
	  /**
	   * Change color.
	   * @param {number} index index
	   */
	
	
	  RaphaelMapChart.prototype.changeColor = function changeColor(index) {
	    var sector = this.sectors[index];
	    var attributes = {
	      stroke: '#ffffff',
	      'stroke-width': 4
	    };
	
	    if (this.overColor) {
	      attributes.fill = this.overColor;
	    }
	
	    sector.sector.animate(attributes, ANIMATION_DURATION, '>');
	    sector.sector.node.setAttribute('filter', 'url(#shadow)');
	    sector.sector.toFront();
	  };
	
	  /**
	   * Restore color.
	   * @param {number} index index
	   */
	
	
	  RaphaelMapChart.prototype.restoreColor = function restoreColor(index) {
	    var sector = this.sectors[index];
	
	    sector.sector.animate({
	      fill: sector.color,
	      stroke: STROKE_COLOR,
	      'stroke-width': 0.2
	    }, ANIMATION_DURATION, '>');
	    sector.sector.node.setAttribute('filter', 'none');
	  };
	
	  /**
	   * Scale map sector paths
	   * @param {number} changedRatio changed ratio of map
	   * @param {object} position position
	   * @param {number} mapRatio mapdimension ratio by dimansion
	   * @param {object} limitPosition limit position
	   * @param {object} mapDimension map dimension
	   */
	
	
	  RaphaelMapChart.prototype.scaleMapPaths = function scaleMapPaths(changedRatio, position, mapRatio, limitPosition, mapDimension) {
	    var transformList = this.g.transform.baseVal;
	    var zoom = this.paper.canvas.createSVGTransform();
	    var matrix = this.paper.canvas.createSVGMatrix();
	    var raphaelMatrix = this.paper.raphael.matrix();
	    var transformMatrix = transformList.numberOfItems ? transformList.getItem(0).matrix : {
	      a: 1,
	      b: 0,
	      c: 0,
	      d: 1,
	      e: 0,
	      f: 0
	    };
	    var maxRight = mapDimension.width - this.dimension.width;
	    var maxTop = mapDimension.height - this.dimension.height;
	    var previousTranslateX = transformMatrix.e / transformMatrix.a;
	    var previousTranslateY = transformMatrix.f / transformMatrix.d;
	    var currentLimitRight = -maxRight / transformMatrix.a;
	    var currentLimitTop = -maxTop / transformMatrix.d;
	
	    raphaelMatrix.scale(changedRatio, changedRatio, position.left * mapRatio - previousTranslateX * changedRatio, position.top * mapRatio - previousTranslateY * changedRatio);
	    var transformX = raphaelMatrix.e / raphaelMatrix.a + previousTranslateX;
	    var transformY = raphaelMatrix.f / raphaelMatrix.d + previousTranslateY;
	
	    if (transformX >= 0) {
	      raphaelMatrix.e = -previousTranslateX * raphaelMatrix.a;
	    } else if (transformX < currentLimitRight) {
	      raphaelMatrix.e = currentLimitRight - previousTranslateX;
	    }
	
	    if (transformY >= 0) {
	      raphaelMatrix.f = -previousTranslateY * raphaelMatrix.a;
	    } else if (transformY < currentLimitTop) {
	      raphaelMatrix.f = currentLimitTop - previousTranslateY;
	    }
	
	    matrix.a = raphaelMatrix.a;
	    matrix.b = raphaelMatrix.b;
	    matrix.c = raphaelMatrix.c;
	    matrix.d = raphaelMatrix.d;
	    matrix.e = raphaelMatrix.e;
	    matrix.f = raphaelMatrix.f;
	
	    zoom.setMatrix(matrix);
	    transformList.appendItem(zoom);
	    transformList.initialize(transformList.consolidate());
	  };
	
	  /**
	   * Scale map sector paths
	   * @param {object} distances drag distance for moving
	   * @param {object} mapDimension map dimension
	   */
	
	
	  RaphaelMapChart.prototype.moveMapPaths = function moveMapPaths(distances, mapDimension) {
	    var matrix = this.paper.canvas.createSVGMatrix();
	    var raphaelMatrix = this.paper.raphael.matrix();
	    var transformList = this.g.transform.baseVal;
	    var translate = this.paper.canvas.createSVGTransform();
	    var maxRight = mapDimension.width - this.dimension.width;
	    var maxTop = mapDimension.height - this.dimension.height;
	    var transformMatrix = transformList.numberOfItems ? transformList.getItem(0).matrix : {
	      a: 1,
	      b: 0,
	      c: 0,
	      d: 1,
	      e: 0,
	      f: 0
	    };
	
	    raphaelMatrix.translate(distances.x, distances.y);
	    this._translateXForRaphaelMatrix({
	      raphaelMatrix: raphaelMatrix,
	      transformMatrix: transformMatrix,
	      maxRight: maxRight
	    });
	    this._translateYForRaphaelMatrix({
	      raphaelMatrix: raphaelMatrix,
	      transformMatrix: transformMatrix,
	      maxTop: maxTop
	    });
	
	    matrix.a = raphaelMatrix.a;
	    matrix.b = raphaelMatrix.b;
	    matrix.c = raphaelMatrix.c;
	    matrix.d = raphaelMatrix.d;
	    matrix.e = raphaelMatrix.e;
	    matrix.f = raphaelMatrix.f;
	
	    translate.setMatrix(matrix);
	    transformList.appendItem(translate);
	    transformList.initialize(transformList.consolidate());
	  };
	
	  RaphaelMapChart.prototype._translateXForRaphaelMatrix = function _translateXForRaphaelMatrix(_ref) {
	    var raphaelMatrix = _ref.raphaelMatrix,
	        transformMatrix = _ref.transformMatrix,
	        maxRight = _ref.maxRight;
	
	    var currentTranslateX = raphaelMatrix.e / raphaelMatrix.a;
	    var translateX = currentTranslateX + transformMatrix.e / transformMatrix.a;
	
	    if (translateX >= 0 && currentTranslateX > 0) {
	      raphaelMatrix.e = 0;
	    } else if (translateX < 0 && translateX < -maxRight / transformMatrix.a && currentTranslateX < 0) {
	      raphaelMatrix.e = 0;
	    }
	  };
	
	  RaphaelMapChart.prototype._translateYForRaphaelMatrix = function _translateYForRaphaelMatrix(_ref2) {
	    var raphaelMatrix = _ref2.raphaelMatrix,
	        transformMatrix = _ref2.transformMatrix,
	        maxTop = _ref2.maxTop;
	
	    var currentTranslateY = raphaelMatrix.f / raphaelMatrix.d;
	    var translateY = currentTranslateY + transformMatrix.f / transformMatrix.d;
	
	    if (translateY >= 0 && currentTranslateY > 0) {
	      raphaelMatrix.f = 0;
	    } else if (translateY < 0 && translateY < -maxTop / transformMatrix.d && currentTranslateY < 0) {
	      raphaelMatrix.f = 0;
	    }
	  };
	
	  /**
	   * Render series labels
	   * @param {object} paper Raphael paper
	   * @param {Array.<object>} labelData label data
	   * @param {object} labelTheme label theme
	   * @returns {Array.<object>}
	   */
	
	
	  RaphaelMapChart.prototype.renderSeriesLabels = function renderSeriesLabels(paper, labelData, labelTheme) {
	    var attributes = {
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      fill: labelTheme.color,
	      'text-anchor': 'middle',
	      opacity: 0,
	      transform: _renderUtil2['default'].oneLineTrim(_templateObject2, this.ratio, this.ratio, this.position.left / this.ratio, this.position.top / this.ratio)
	    };
	    var set = paper.set();
	
	    labelData.forEach(function (labelDatum) {
	      var position = labelDatum.position;
	
	      var label = _raphaelRenderUtil2['default'].renderText(paper, position, labelDatum.name || labelDatum.code, attributes);
	
	      set.push(label);
	
	      label.node.style.userSelect = 'none';
	      label.node.style.cursor = 'default';
	      label.node.setAttribute('filter', 'url(#glow)');
	
	      if (!IS_LTE_IE8) {
	        self.g.appendChild(label.node);
	      }
	    });
	
	    return set;
	  };
	
	  return RaphaelMapChart;
	}();
	
	/**
	 * Create and append sector set
	 * @param {object} paper Raphael paper
	 * @param {Array.<object>} sectorSet sectorSet
	 * @param {string} id ID string
	 * @returns {object}
	 * @ignore
	 */
	
	
	function createGElement(paper, sectorSet, id) {
	  var g = document.createElementNS('http://www.w3.org/2000/svg', 'g');
	  g.id = id;
	
	  sectorSet.forEach(function (sector) {
	    _domHandler2['default'].append(g, sector.node);
	  });
	
	  paper.canvas.appendChild(g);
	
	  return g;
	}
	
	exports['default'] = RaphaelMapChart;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _templateObject = _taggedTemplateLiteral(['\n            M', '\n            ,', '\n            l', '\n            ,', '\n            l', '\n            ,-', '\n        '], ['\n            M', '\n            ,', '\n            l', '\n            ,', '\n            l', '\n            ,-', '\n        ']);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _taggedTemplateLiteral(strings, raw) { return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael title renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var UNSELECTED_LEGEND_LABEL_OPACITY = 0.5;
	var PAGINATION_POSITION_HEIGHT = 8;
	var PAGINATION_POSITION_WIDTH = 10;
	var PAGINATION_POSITION_HALF_WIDTH = PAGINATION_POSITION_WIDTH / 2;
	var PAGINATION_POSITION_PADDING = 3;
	
	/**
	 * Get sum of icon and left padding width
	 * @returns {number} - icon and left padding width
	 * @ignore
	 */
	function getIconWidth() {
	  return _const2['default'].LEGEND_ICON_WIDTH + _const2['default'].LEGEND_LABEL_LEFT_PADDING;
	}
	
	// const RaphaelLegendComponent = snippet.defineClass(/** @lends RaphaelLegendComponent.prototype */ {
	
	var RaphaelLegendComponent = function () {
	  /** @lends RaphaelLegendComponent.prototype */
	  function RaphaelLegendComponent() {
	    _classCallCheck(this, RaphaelLegendComponent);
	
	    /**
	     * @type {number}
	     * @private
	     */
	    this._checkBoxWidth = 0;
	    /**
	     * @type {number}
	     * @private
	     */
	    this._checkBoxHeight = 0;
	    /**
	     * @type {number}
	     * @private
	     */
	    this._legendItemHeight = 0;
	    /**
	     * @type {number}
	     * @private
	     */
	    this._currentPageCount = 1;
	    /**
	     * @type {boolean}
	     * @private
	     */
	    this._showCheckbox = true;
	  }
	
	  /**
	   * @param {Array.<object>} legendData Array of legend item data
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderLegendItems = function _renderLegendItems(legendData) {
	    var _this = this;
	
	    var labelPaddingLeft = _const2['default'].LEGEND_LABEL_LEFT_PADDING;
	    var position = Object.assign({}, this.basePosition);
	
	    legendData.forEach(function (legendDatum, index) {
	      var iconType = legendDatum.iconType,
	          legendIndex = legendDatum.index,
	          isUnselected = legendDatum.isUnselected,
	          labelHeight = legendDatum.labelHeight,
	          checkboxData = legendDatum.checkbox;
	
	      var legendColor = legendDatum.colorByPoint ? '#aaa' : legendDatum.theme.color;
	      var predicatedLegendWidth = position.left + _this._calculateSingleLegendWidth(legendIndex, iconType);
	      var isNeedBreakLine = predicatedLegendWidth >= _this.paper.width;
	
	      if (_this.isHorizontal && isNeedBreakLine) {
	        position.top += _this._legendItemHeight + _const2['default'].LABEL_PADDING_TOP;
	        position.left = _this.basePosition.left;
	      }
	
	      if (_this._showCheckbox) {
	        _this._renderCheckbox(position, {
	          isChecked: checkboxData.checked,
	          legendIndex: legendIndex,
	          legendSet: _this.legendSet
	        });
	
	        position.left += _this._checkBoxWidth + labelPaddingLeft;
	      }
	
	      _this._renderIcon(position, {
	        legendColor: legendColor,
	        iconType: iconType,
	        labelHeight: labelHeight,
	        isUnselected: isUnselected,
	        legendIndex: legendIndex,
	        legendSet: _this.legendSet
	      });
	
	      position.left += _const2['default'].LEGEND_ICON_WIDTH + labelPaddingLeft;
	
	      _this._renderLabel(position, {
	        labelText: legendDatum.label,
	        labelHeight: labelHeight,
	        isUnselected: isUnselected,
	        legendIndex: legendIndex,
	        legendSet: _this.legendSet
	      });
	
	      if (_this.isHorizontal) {
	        position.left += _this.labelWidths[index] + _const2['default'].LEGEND_H_LABEL_RIGHT_PADDING;
	      } else {
	        position.left = _this.basePosition.left;
	        position.top += _this._legendItemHeight + _const2['default'].LINE_MARGIN_TOP;
	      }
	    });
	  };
	
	  /**
	   * @param {Array.<object>} legendData Array of legend item data
	   * @param {number} sliceIndex slice index of
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._getLegendData = function _getLegendData(legendData, sliceIndex) {
	    var positionTop = this.basePosition.top;
	    var totalHeight = this.dimension.height;
	    var chartHeight = this.paper.height;
	    var resultLegendData = legendData;
	
	    if (!this.isHorizontal && totalHeight + positionTop * 2 > chartHeight) {
	      this._legendItemHeight = Math.max(legendData[0].labelHeight, _const2['default'].LEGEND_CHECKBOX_SIZE);
	      var pageHeight = chartHeight - positionTop * 2;
	      var singleItemHeight = this._legendItemHeight + _const2['default'].LINE_MARGIN_TOP;
	      var visibleItemCount = Math.floor(pageHeight / singleItemHeight);
	
	      resultLegendData = legendData.slice((sliceIndex - 1) * visibleItemCount, sliceIndex * visibleItemCount);
	    }
	
	    return resultLegendData;
	  };
	
	  /**
	   * Render legend
	   * @param {object} data rendering data
	   *     @param {HTMLElement} data.container legend container
	   *     @param {Array.<object>} data.legendData rendering legendData
	   *     @param {boolean} data.isHorizontal boolean value of horizontal or not
	   *     @param {{height:number, width:number}} data.dimension legend dimension
	   *     @param {object} data.labelTheme legend label theme object
	   *     @param {number} data.labelWidths label widths
	   *     @param {object} data.eventBus event bus
	   * @returns {object} paper
	   */
	
	
	  RaphaelLegendComponent.prototype.render = function render(data) {
	    this.eventBus = data.eventBus;
	    this.paper = data.paper;
	    this.dimension = data.dimension;
	    this.legendSet = this.paper.set();
	    this.labelWidths = data.labelWidths;
	    this.labelTheme = data.labelTheme;
	    this.basePosition = data.position;
	    this.isHorizontal = data.isHorizontal;
	    this.originalLegendData = data.legendData;
	
	    if (this.originalLegendData.length) {
	      this._showCheckbox = _tuiCodeSnippet2['default'].isExisty(data.legendData[0].checkbox);
	      this._setComponentDimensionsBaseOnLabelHeight(data.legendData[0].labelHeight);
	
	      var legendData = this._getLegendData(data.legendData, this._currentPageCount);
	
	      this._renderLegendItems(legendData);
	
	      if (!this.isHorizontal && legendData && legendData.length < data.legendData.length) {
	        var legendHeight = this.paper.height - this.basePosition.top * 2;
	
	        this.availablePageCount = Math.ceil(data.dimension.height / legendHeight);
	
	        this._renderPaginationArea(this.basePosition, {
	          width: data.dimension.width,
	          height: legendHeight
	        });
	      }
	    }
	
	    return this.legendSet;
	  };
	
	  /**
	   * @param {string} direction direction string of paginate 'next' or 'previous'
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._paginateLegendAreaTo = function _paginateLegendAreaTo(direction) {
	    var pageNumber = this._currentPageCount;
	
	    this._removeLegendItems();
	
	    if (direction === 'next') {
	      pageNumber += 1;
	    } else {
	      pageNumber -= 1;
	    }
	
	    this._renderLegendItems(this._getLegendData(this.originalLegendData, pageNumber));
	  };
	
	  RaphaelLegendComponent.prototype._removeLegendItems = function _removeLegendItems() {
	    this.legendSet.forEach(function (legendItem) {
	      var events = legendItem.events || [];
	      events.forEach(function (event) {
	        event.unbind();
	      });
	      legendItem.remove();
	    });
	  };
	
	  /**
	   * @param {{top: number, left: number}} position legend area position
	   * @param {{height: number, width: number}} dimension legend area dimension
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderPaginationArea = function _renderPaginationArea(position, dimension) {
	    var _this2 = this;
	
	    var LEGEND_PAGINATION_BUTTON_WIDTH = _const2['default'].LEGEND_PAGINATION_BUTTON_WIDTH,
	        LEGEND_PAGINATION_BUTTON_PADDING_RIGHT = _const2['default'].LEGEND_PAGINATION_BUTTON_PADDING_RIGHT,
	        LEGEND_AREA_V_PADDING = _const2['default'].LEGEND_AREA_V_PADDING,
	        LEGEND_AREA_H_PADDING = _const2['default'].LEGEND_AREA_H_PADDING;
	
	    var controllerPositionTop = position.top + dimension.height - LEGEND_AREA_V_PADDING;
	    var controllerPositionLeft = position.left - LEGEND_AREA_H_PADDING;
	    var leftButtonPositionLeft = controllerPositionLeft + LEGEND_AREA_H_PADDING;
	    var rightButtonPositionLeft = _calculator2['default'].sum([leftButtonPositionLeft, LEGEND_PAGINATION_BUTTON_PADDING_RIGHT, LEGEND_PAGINATION_BUTTON_WIDTH]);
	    var lowerArrowPath = ['M', rightButtonPositionLeft + 5, ',', controllerPositionTop + PAGINATION_POSITION_PADDING + 4, 'L', rightButtonPositionLeft + PAGINATION_POSITION_HALF_WIDTH + 5, ',', controllerPositionTop + PAGINATION_POSITION_HEIGHT + 4, 'L', rightButtonPositionLeft + PAGINATION_POSITION_WIDTH + 5, ',', controllerPositionTop + PAGINATION_POSITION_PADDING + 4].join('');
	    var upperArrowPath = ['M', leftButtonPositionLeft + 5, ',', controllerPositionTop + PAGINATION_POSITION_HEIGHT + 4, 'L', leftButtonPositionLeft + PAGINATION_POSITION_HALF_WIDTH + 5, ',', controllerPositionTop + PAGINATION_POSITION_PADDING + 4, 'L', leftButtonPositionLeft + PAGINATION_POSITION_WIDTH + 5, ',', controllerPositionTop + PAGINATION_POSITION_HEIGHT + 4].join('');
	
	    var prevRect = this._renderPaginationRect({
	      top: controllerPositionTop,
	      left: leftButtonPositionLeft
	    });
	    var prevArrow = _raphaelRenderUtil2['default'].renderLine(this.paper, upperArrowPath, '#555', 2);
	
	    var nextRect = this._renderPaginationRect({
	      top: controllerPositionTop,
	      left: rightButtonPositionLeft
	    });
	    var nextArrow = _raphaelRenderUtil2['default'].renderLine(this.paper, lowerArrowPath, '#555', 2);
	    var prevButtonSet = this.paper.set();
	    var nextButtonSet = this.paper.set();
	
	    prevRect.className = 'tui-chart-icon';
	    prevButtonSet.push(prevRect);
	    prevButtonSet.push(prevArrow);
	
	    nextRect.className = 'tui-chart-icon';
	    nextButtonSet.push(nextRect);
	    nextButtonSet.push(nextArrow);
	
	    prevButtonSet.click(function () {
	      if (_this2._currentPageCount > 1) {
	        _this2._paginateLegendAreaTo('previous');
	        _this2._currentPageCount -= 1;
	      }
	    });
	
	    nextButtonSet.click(function () {
	      if (_this2._currentPageCount < _this2.availablePageCount) {
	        _this2._paginateLegendAreaTo('next');
	        _this2._currentPageCount += 1;
	      }
	    });
	  };
	
	  /**
	   * @param {object} position - position top, left
	   * @returns {SVGElement} - svg element
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderPaginationRect = function _renderPaginationRect(position) {
	    var BUTTON_SIZE = _const2['default'].LEGEND_PAGINATION_BUTTON_WIDTH;
	    var bound = {
	      left: position.left,
	      top: position.top,
	      width: BUTTON_SIZE,
	      height: BUTTON_SIZE
	    };
	    var rect = _raphaelRenderUtil2['default'].renderRect(this.paper, bound, {
	      fill: '#f4f4f4',
	      rx: '1px',
	      ry: '1px',
	      stroke: 'none'
	    });
	
	    return rect;
	  };
	
	  /**
	   * Make labels width.
	   * @param {Array.<{chartType: ?string, label: string}>} legendData legend data
	   * @param {object} theme theme object
	   * @param {number} maxWidth user option legend max width size
	   * @returns {Array.<number>} label widths
	   */
	
	
	  RaphaelLegendComponent.prototype.makeLabelWidths = function makeLabelWidths(legendData, theme, maxWidth) {
	    return _tuiCodeSnippet2['default'].map(legendData, function (item) {
	      var labelWidth = _raphaelRenderUtil2['default'].getRenderedTextSize(item.label, theme.fontSize, theme.fontFamily).width;
	      if (maxWidth && labelWidth > maxWidth) {
	        labelWidth = maxWidth;
	      }
	
	      return labelWidth + _const2['default'].LEGEND_LABEL_LEFT_PADDING;
	    });
	  };
	
	  /**
	   * Get rendered label height
	   * @param {string} labelText label text
	   * @param {object} theme theme object
	   * @returns {number}
	   */
	
	
	  RaphaelLegendComponent.prototype.getRenderedLabelHeight = function getRenderedLabelHeight(labelText, theme) {
	    return _raphaelRenderUtil2['default'].getRenderedTextSize(labelText, theme.fontSize, theme.fontFamily).height;
	  };
	
	  /**
	   * Render label text and attach event
	   * @param {object} position left, top
	   * @param {object} data rendering data
	   *     @param {string} data.labelText label text
	   *     @param {number} data.labelHeight label height
	   *     @param {boolean} data.isUnselected boolean value for selected or not
	   *     @param {number} data.legendIndex legend index
	   *     @param {Array.<object>} data.legendSet legend set
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderLabel = function _renderLabel(position, data) {
	    var eventBus = this.eventBus,
	        labelTheme = this.labelTheme;
	
	    var pos = {
	      left: position.left,
	      top: position.top + this._legendItemHeight / 2
	    };
	    var attributes = {
	      fill: labelTheme.color,
	      'font-size': labelTheme.fontSize,
	      'font-family': labelTheme.fontFamily,
	      'font-weight': labelTheme.fontWeight,
	      opacity: data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1,
	      'text-anchor': 'start'
	    };
	    var label = _raphaelRenderUtil2['default'].renderText(this.paper, pos, data.labelText, attributes);
	
	    label.data('index', data.legendIndex);
	
	    label.node.style.userSelect = 'none';
	    label.node.style.cursor = 'pointer';
	
	    data.legendSet.push(label);
	
	    label.click(function () {
	      eventBus.fire('labelClicked', data.legendIndex);
	    });
	  };
	
	  /**
	   * Render checkbox
	   * @param {object} position left, top
	   * @param {object} data rendering data
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderCheckbox = function _renderCheckbox(position, data) {
	    var _this3 = this;
	
	    var left = position.left;
	
	    var top = position.top + (this._legendItemHeight - this._checkBoxHeight) / 2;
	    var checkboxPathSize = this._checkBoxWidth / 3;
	    var checkboxPathHalpSize = this._checkBoxWidth / 5.7;
	    var vPathString = _renderUtil2['default'].oneLineTrim(_templateObject, this._checkBoxWidth * 0.25 + left, this._checkBoxHeight * 0.5 + top, checkboxPathHalpSize, checkboxPathHalpSize, checkboxPathSize, checkboxPathSize);
	
	    var checkboxSet = this.paper.set();
	    var checkboxElement = this.paper.rect(left, top, this._checkBoxWidth, this._checkBoxHeight, 0).attr({
	      fill: '#fff',
	      stroke: '#aaa',
	      'stroke-width': 1
	    });
	    checkboxElement.node.setAttribute('class', 'auto-shape-rendering');
	
	    checkboxSet.push(checkboxElement);
	
	    if (data.isChecked) {
	      var checkElement = this.paper.path(vPathString).attr({
	        stroke: '#555',
	        'stroke-width': 2
	      });
	      checkElement.node.setAttribute('class', 'auto-shape-rendering');
	      checkboxSet.push(checkElement);
	    }
	
	    checkboxSet.data('index', data.legendIndex);
	    checkboxSet.click(function () {
	      _this3.eventBus.fire('checkboxClicked', data.legendIndex);
	    });
	
	    checkboxSet.forEach(function (checkbox) {
	      data.legendSet.push(checkbox);
	    });
	  };
	
	  /**
	   * Render legend icon and attach event
	   * @param {object} position left, top
	   * @param {object} data rendering data
	   *     @param {string} data.labelText label text
	   *     @param {number} data.labelHeight label height
	   *     @param {string} data.legendColor legend color hex
	   *     @param {boolean} data.isUnselected boolean value for selected or not
	   *     @param {number} data.legendIndex legend index
	   *     @param {Array.<object>} data.legendSet legend set
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._renderIcon = function _renderIcon(position, data) {
	    var _this4 = this;
	
	    var icon = void 0;
	    this.paper.setStart();
	
	    if ((data.iconType === 'line' || data.iconType === 'radial') && this.paper.canvas.transform) {
	      icon = this.paper.path(_const2['default'].LEGEND_LINE_ICON_PATH);
	
	      icon.attr({
	        stroke: data.legendColor,
	        'stroke-width': 2,
	        'stroke-opacity': data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1
	      });
	      icon.translate(position.left, position.top);
	    } else {
	      icon = _raphaelRenderUtil2['default'].renderRect(this.paper, {
	        left: position.left,
	        top: position.top + (_const2['default'].LEGEND_CHECKBOX_SIZE - _const2['default'].LEGEND_ICON_HEIGHT) / 2,
	        width: _const2['default'].LEGEND_ICON_WIDTH,
	        height: _const2['default'].LEGEND_ICON_HEIGHT
	      }, {
	        'stroke-width': 0,
	        fill: data.legendColor,
	        opacity: data.isUnselected ? UNSELECTED_LEGEND_LABEL_OPACITY : 1
	      });
	    }
	
	    icon.data('icon', data.iconType);
	    icon.data('index', data.legendIndex);
	    icon.click(function () {
	      _this4.eventBus.fire('labelClicked', data.legendIndex);
	    });
	
	    data.legendSet.push(icon);
	  };
	
	  RaphaelLegendComponent.prototype.selectLegend = function selectLegend(index, legendSet) {
	    legendSet.forEach(function (element) {
	      var indexData = element.data('index');
	      var attributeName = element.data('icon') === 'line' ? 'stroke-opacity' : 'opacity';
	
	      if (_tuiCodeSnippet2['default'].isNull(indexData) || _tuiCodeSnippet2['default'].isUndefined(indexData)) {
	        element.attr(attributeName, 1);
	      } else if (!_tuiCodeSnippet2['default'].isUndefined(indexData)) {
	        if (_tuiCodeSnippet2['default'].isNumber(index) && indexData !== index) {
	          element.attr(attributeName, UNSELECTED_LEGEND_LABEL_OPACITY);
	        } else {
	          element.attr(attributeName, 1);
	        }
	      }
	    });
	  };
	
	  /**
	   * get checkbox area's width depends on checkbox visibility
	   * @returns {number} - checkbox region's width
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._getCheckboxWidth = function _getCheckboxWidth() {
	    return this._showCheckbox ? this._checkBoxWidth + _const2['default'].LEGEND_LABEL_LEFT_PADDING : 0;
	  };
	
	  /**
	   * Get width of a label when parameter is given.
	   * Otherwise, returns maximum width of labels
	   * @param {number} [index] - legend index
	   * @returns {number} - maximum label width  label width
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._getLabelWidth = function _getLabelWidth(index) {
	    var labelWidth = void 0;
	    if (index) {
	      labelWidth = this.labelWidths[index] || 0;
	    } else {
	      labelWidth = _arrayUtil2['default'].max(this.labelWidths);
	    }
	
	    return labelWidth;
	  };
	
	  /**
	   * calulate a whole legend width before start rendering
	   * @returns {number} - calculate label
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._calculateLegendWidth = function _calculateLegendWidth() {
	    return this._calculateSingleLegendWidth();
	  };
	
	  /**
	   * calculate a single legend width of index `legendIndex`
	   * @param {number} legendIndex - index of legend label
	   * @returns {number} - calculate single legend width
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._calculateSingleLegendWidth = function _calculateSingleLegendWidth(legendIndex) {
	    return _const2['default'].LEGEND_AREA_H_PADDING + this._getCheckboxWidth() + getIconWidth() + this._getLabelWidth(legendIndex) + _const2['default'].LEGEND_AREA_H_PADDING;
	  };
	
	  /**
	   * set component dimension by comparaing label height and icon height
	   * @param {number} labelHeight - label height
	   * @private
	   */
	
	
	  RaphaelLegendComponent.prototype._setComponentDimensionsBaseOnLabelHeight = function _setComponentDimensionsBaseOnLabelHeight(labelHeight) {
	    this._legendItemHeight = Math.max(labelHeight, _const2['default'].LEGEND_CHECKBOX_SIZE);
	    this._checkBoxWidth = this._checkBoxHeight = _const2['default'].LEGEND_CHECKBOX_SIZE;
	  };
	
	  return RaphaelLegendComponent;
	}();
	
	exports['default'] = RaphaelLegendComponent;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * @fileoverview calculator.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	var PERCENT_DIVISOR = 100;
	
	/**
	 * Calculator.
	 * @module calculator
	 * @private */
	var calculator = {
	  /**
	   * Calculate limit from chart min, max data.
	   *  - http://peltiertech.com/how-excel-calculates-automatic-chart-axis-limits/
	   * @memberOf module:calculator
	   * @param {number} min min minimum value of user data
	   * @param {number} max max maximum value of user data
	   * @returns {{min: number, max: number}} limit axis limit
	   */
	  calculateLimit: function calculateLimit(min, max) {
	    var limit = {};
	    var saveMin = 0;
	
	    if (min < 0) {
	      saveMin = min;
	      max -= min;
	      min = 0;
	    }
	
	    var iodValue = (max - min) / 20;
	
	    limit.max = max + iodValue + saveMin;
	
	    if (max / 6 > min) {
	      limit.min = saveMin;
	    } else {
	      limit.min = min - iodValue + saveMin;
	    }
	
	    return limit;
	  },
	
	
	  /**
	   * Make tick positions of pixel type.
	   * @memberOf module:calculator
	   * @param {number} size area width or height
	   * @param {number} count tick count
	   * @param {?number} additionalPosition additional position
	   * @param {?number} remainLastBlockIntervalPosition remainLastBlockInterval position
	   * @returns {Array.<number>} positions
	   */
	  makeTickPixelPositions: function makeTickPixelPositions(size, count, additionalPosition, remainLastBlockIntervalPosition) {
	    var positions = [];
	
	    additionalPosition = additionalPosition || 0;
	
	    if (count > 0) {
	      positions = _tuiCodeSnippet2['default'].range(0, count).map(function (index) {
	        var ratio = index === 0 ? 0 : index / (count - 1);
	
	        return ratio * size + additionalPosition;
	      });
	      positions[positions.length - 1] -= 1;
	    }
	
	    if (remainLastBlockIntervalPosition) {
	      positions.push(remainLastBlockIntervalPosition);
	    }
	
	    return positions;
	  },
	
	
	  /**
	   * Make labels from limit.
	   * @memberOf module:calculator
	   * @param {{min: number, max: number}} limit axis limit
	   * @param {number} step step between max and min
	   * @returns {string[]} labels
	   * @private
	   */
	  makeLabelsFromLimit: function makeLabelsFromLimit(limit, step) {
	    var multipleNum = calculator.findMultipleNum(step);
	    var min = Math.round(limit.min * multipleNum);
	    var max = Math.round(limit.max * multipleNum);
	    var labels = _tuiCodeSnippet2['default'].range(min, max + 1, step * multipleNum);
	
	    return labels.map(function (label) {
	      return label / multipleNum;
	    });
	  },
	
	
	  /**
	   * Calculate step from limit.
	   * @memberOf module:calculator
	   * @param {{min: number, max: number}} limit axis limit
	   * @param {number} count value count
	   * @returns {number} step
	   */
	  calculateStepFromLimit: function calculateStepFromLimit(limit, count) {
	    return calculator.divide(calculator.subtract(limit.max, limit.min), count - 1);
	  },
	
	
	  /**
	   * Sum plus values.
	   * @param {Array.<number>} values values
	   * @returns {number} sum
	   */
	  sumPlusValues: function sumPlusValues(values) {
	    var plusValues = _tuiCodeSnippet2['default'].filter(values, function (value) {
	      return value > 0;
	    });
	
	    return calculator.sum(plusValues);
	  },
	
	
	  /**
	   * Sum minus values.
	   * @param {Array.<number>} values values
	   * @returns {number} sum
	   */
	  sumMinusValues: function sumMinusValues(values) {
	    var minusValues = _tuiCodeSnippet2['default'].filter(values, function (value) {
	      return value < 0;
	    });
	
	    return calculator.sum(minusValues);
	  },
	
	
	  /**
	   * Make percentage value.
	   * @param {number} value - value
	   * @param {number} totalValue - total value
	   * @returns {number}
	   */
	  makePercentageValue: function makePercentageValue(value, totalValue) {
	    return value / totalValue * PERCENT_DIVISOR;
	  },
	
	
	  /**
	   * Calculate ratio for making bound.
	   * @param {number} value - value
	   * @param {number} divNumber - number for division
	   * @param {number} subNumber - number for subtraction
	   * @param {number} baseRatio - base ratio
	   * @returns {number}
	   */
	  calculateRatio: function calculateRatio(value, divNumber, subNumber, baseRatio) {
	    return divNumber ? (value - subNumber) / divNumber * baseRatio : 0;
	  }
	};
	
	/**
	 * Get length after decimal point.
	 * @memberOf module:calculator
	 * @param {string | number} value target value
	 * @returns {number} result length
	 */
	var getDecimalLength = function getDecimalLength(value) {
	  var valueArr = String(value).split('.');
	
	  return valueArr.length === 2 ? valueArr[1].length : 0;
	};
	
	/**
	 * Find multiple num.
	 * @memberOf module:calculator
	 * @param {...Array} target values
	 * @returns {number} multiple num
	 */
	var findMultipleNum = function findMultipleNum() {
	  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	    args[_key] = arguments[_key];
	  }
	
	  var underPointLens = args.map(function (value) {
	    return calculator.getDecimalLength(value);
	  });
	  var underPointLen = _arrayUtil2['default'].max(underPointLens);
	
	  return Math.pow(10, underPointLen);
	};
	
	/**
	 * Modulo operation for floating point operation.
	 * @memberOf module:calculator
	 * @param {number} target target values
	 * @param {number} modNum mod num
	 * @returns {number} result mod
	 */
	var mod = function mod(target, modNum) {
	  var multipleNum = calculator.findMultipleNum(modNum);
	  var result = void 0;
	
	  if (multipleNum === 1) {
	    result = target % modNum;
	  } else {
	    result = target * multipleNum % (modNum * multipleNum) / multipleNum;
	  }
	
	  return result;
	};
	
	/**
	 * 'add' is function for add operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var add = function add(a, b) {
	  var multipleNum = calculator.findMultipleNum(a, b);
	
	  return (a * multipleNum + b * multipleNum) / multipleNum;
	};
	
	/**
	 * 'subtract' is function for subtract operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var subtract = function subtract(a, b) {
	  var multipleNum = calculator.findMultipleNum(a, b);
	
	  return (a * multipleNum - b * multipleNum) / multipleNum;
	};
	
	/**
	 * 'multiply' is function for multiply operation to floating point.
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var multiply = function multiply(a, b) {
	  var multipleNum = calculator.findMultipleNum(a, b);
	
	  return a * multipleNum * (b * multipleNum) / (multipleNum * multipleNum);
	};
	
	/**
	 * 'divide' is function for divide operation to floating point.
	 * @memberOf module:calculator
	 * @param {number} a target a
	 * @param {number} b target b
	 * @returns {number}
	 */
	var divide = function divide(a, b) {
	  var multipleNum = calculator.findMultipleNum(a, b);
	
	  return a * multipleNum / (b * multipleNum);
	};
	
	/**
	 * Sum.
	 * @memberOf module:calculator
	 * @param {Array.<number>} values target values
	 * @returns {number} result value
	 */
	var sum = function sum(values) {
	  var copyArr = values.slice();
	  copyArr.unshift(0);
	
	  return copyArr.reduce(function (base, value) {
	    return calculator.add(parseFloat(base), parseFloat(value));
	  });
	};
	
	/**
	 * Obtain the number of divisors.
	 * @memberOf module:calculator
	 * @param {Array.<number>} value target value
	 * @returns {number} result value
	 */
	var divisors = function divisors(value) {
	  var result = [];
	  for (var a = 2, b; a * a <= value; a += 1) {
	    if (value % a === 0) {
	      b = value / a;
	      result.push(a);
	      if (b !== a) {
	        result.push(b);
	      }
	    }
	  }
	  result.sort(function (prev, next) {
	    return prev - next;
	  });
	
	  return result;
	};
	
	calculator.getDecimalLength = getDecimalLength;
	calculator.findMultipleNum = findMultipleNum;
	calculator.mod = mod;
	calculator.add = add;
	calculator.subtract = subtract;
	calculator.multiply = multiply;
	calculator.divide = divide;
	calculator.divisors = divisors;
	calculator.sum = sum;
	
	exports['default'] = calculator;

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelMapLegend is graph renderer for map chart legend.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	// prettier-ignore
	var DEGREE_HORIZONTAL_BAR = 360;
	var DEGREE_VERTICAL_BAR = 270;
	var WEDGE_BASE_HALF = 2.5; // half of wedge base
	
	/**
	 * @classdesc RaphaelMapLegend is graph renderer for map chart legend.
	 * @class RaphaelMapLegend
	 * @private
	 */
	
	var RaphaelMapLegend = function () {
	  function RaphaelMapLegend() {
	    _classCallCheck(this, RaphaelMapLegend);
	
	    /**
	     * Vertical base path
	     * @type {Array}
	     */
	    // prettier-ignore
	    this.verticalRightBasePath = ['M', -4, 0, 'L', -8, 2.5, 'L', -8, 12.5, 'L', -28, 12.5, 'L', -28, -12.5, 'L', -8, -12.5, 'L', -8, -2.5];
	    // prettier-ignore
	    this.verticalLeftBasePath = ['M', 10, 0, 'L', 14, 2.5, 'L', 14, 12.5, 'L', 34, 12.5, 'L', 34, -12.5, 'L', 14, -12.5, 'L', 14, -2.5];
	
	    /**
	     * Horizontal base path
	     * @type {Array}
	     */
	    // prettier-ignore
	    this.horizontalTopBasePath = ['M', 0, 10, 'L', 2.5, 14, 'L', 12.5, 14, 'L', 12.5, 34, 'L', -12.5, 34, 'L', -12.5, 14, 'L', -2.5, 14];
	    // prettier-ignore
	    this.horizontalBottomBasePath = ['M', 0, -4, 'L', 2.5, -8, 'L', 12.5, -8, 'L', 12.5, -28, 'L', -12.5, -28, 'L', -12.5, -8, 'L', -2.5, -8];
	  }
	
	  /**
	   * Render function of map chart legend.
	   * @param {object} param - param to render spectrum legend
	   *  @param {object} param.paper raphael paper
	   *  @param {object} param.layout legend layout
	   *  @param {ColorSpectrum} param.colorSpectrum map chart color model
	   *  @param {boolean} param.isHorizontal whether horizontal legend or not
	   *  @param {Array.<object>} param.legendSet legend set
	   */
	
	
	  RaphaelMapLegend.prototype.render = function render(param) {
	    var layout = param.layout,
	        align = param.align,
	        legendSet = param.legendSet,
	        theme = param.theme,
	        labels = param.labels;
	
	    var isHorizontal = _predicate2['default'].isHorizontalLegend(align);
	
	    var _labels = _slicedToArray(labels, 1),
	        minLabel = _labels[0];
	
	    var maxLabel = labels[labels.length - 1];
	    var maxLabelWidth = _renderUtil2['default'].getRenderedLabelsMaxWidth([minLabel, maxLabel]);
	    var labelHeight = _renderUtil2['default'].getRenderedLabelHeight(minLabel, theme);
	    var isBoxTypeChart = _predicate2['default'].isBoxTypeChart(this.chartType);
	    var position = layout.position;
	
	
	    this.layout = layout;
	    this.isHorizontal = isHorizontal;
	    this.isLeftLegend = _predicate2['default'].isLegendAlignLeft(align);
	    this.isTopLegend = _predicate2['default'].isLegendAlignTop(align);
	    this.theme = theme;
	    this.paper = param.paper;
	    this.legendSet = param.legendSet;
	    this.colorSpectrum = param.colorSpectrum;
	
	    if (_predicate2['default'].isLegendAlignTop(align)) {
	      position.top += _const2['default'].MAP_LEGEND_AREA_PADDING_WIDE + labelHeight + _const2['default'].MAP_LEGEND_LABEL_PADDING * 2;
	    } else if (_predicate2['default'].isLegendAlignBottom(align)) {
	      position.top += this._calculateHorizontalLegendTooltipHeight(labels, theme) + _const2['default'].MAP_LEGEND_PADDING_BTW_GRAPH_AND_WEDGE;
	
	      if (isBoxTypeChart) {
	        position.top -= _const2['default'].MAP_LEGEND_TOOLTIP_VERTICAL_PADDING;
	      } else {
	        position.top += _const2['default'].MAP_LEGEND_AREA_PADDING_WIDE;
	      }
	    } else if (_predicate2['default'].isLegendAlignLeft(align)) {
	      position.left += maxLabelWidth + _const2['default'].MAP_LEGEND_LABEL_PADDING;
	    } else {
	      position.left = layout.position.right - maxLabelWidth - _const2['default'].MAP_LEGEND_LABEL_PADDING - _const2['default'].MAP_LEGEND_GRAPH_SIZE;
	    }
	
	    var gradientBar = this._renderGradientBar(this.paper, layout, this.colorSpectrum, isHorizontal);
	
	    legendSet.push(gradientBar);
	
	    this.wedge = this._renderWedge(this.paper, position);
	    this.wedgeText = this._renderWedgeText(this.paper, position, theme);
	    legendSet.push(this.wedge);
	
	    this.gradientBar = gradientBar;
	  };
	
	  /**
	   * Render tick label
	   * @param {object} paper Raphael paper
	   * @param {object} baseData base data for render ticks
	   * @param {Array.<string>} labels labels
	   * @param {string} align legend align option
	   * @param {Array.<object>} legendSet legend set
	   */
	
	
	  RaphaelMapLegend.prototype.renderTickLabels = function renderTickLabels(paper, baseData, labels, align, legendSet) {
	    var _this = this;
	
	    var theme = this.theme;
	
	    var attribute = {
	      'font-size': theme.fontSize,
	      'font-family': theme.fontFamily,
	      'font-weight': theme.fontWeight,
	      fill: '#000'
	    };
	
	    var _labels2 = _slicedToArray(labels, 1),
	        minLabel = _labels2[0];
	
	    var maxLabel = labels[labels.length - 1];
	    var maxLabelWidth = _renderUtil2['default'].getRenderedLabelsMaxWidth([minLabel, maxLabel]);
	    var labelHeight = _renderUtil2['default'].getRenderedLabelHeight(minLabel, theme);
	
	    labels.forEach(function (label, labelIndex) {
	      var offsetValue = baseData.step * labelIndex;
	      var pos = Object.assign({}, baseData.position);
	
	      if (_predicate2['default'].isHorizontalLegend(align)) {
	        pos.left += offsetValue;
	        if (_this.isTopLegend) {
	          pos.top -= labelHeight / 2;
	        } else {
	          pos.top += labelHeight / 2;
	        }
	      } else {
	        pos.top += offsetValue;
	        if (_this.isLeftLegend) {
	          attribute['text-anchor'] = 'end';
	          pos.left = _const2['default'].CHART_PADDING + maxLabelWidth;
	        } else {
	          attribute['text-anchor'] = 'start';
	        }
	      }
	
	      legendSet.push(_raphaelRenderUtil2['default'].renderText(paper, pos, label, attribute));
	    }, this);
	  };
	
	  /**
	   * Render gradient bar.
	   * @param {object} paper raphael object
	   * @param {object} layout legend layout
	   * @param {ColorSpectrum} colorSpectrum map chart color model
	   * @param {boolean} isHorizontal whether horizontal legend or not
	   * @returns {object}
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._renderGradientBar = function _renderGradientBar(paper, layout, colorSpectrum, isHorizontal) {
	    var width = void 0,
	        height = void 0,
	        degree = void 0;
	
	    if (isHorizontal) {
	      width = layout.dimension.width;
	
	      height = _const2['default'].MAP_LEGEND_GRAPH_SIZE;
	      degree = DEGREE_HORIZONTAL_BAR;
	      this._makeWedghPath = this._makeHorizontalWedgePath;
	    } else {
	      width = _const2['default'].MAP_LEGEND_GRAPH_SIZE;
	      height = layout.dimension.height;
	
	      degree = DEGREE_VERTICAL_BAR;
	      this._makeWedghPath = this._makeVerticalWedgePath;
	    }
	
	    var bound = {
	      left: layout.position.left,
	      top: layout.position.top,
	      width: width,
	      height: height
	    };
	
	    return _raphaelRenderUtil2['default'].renderRect(paper, bound, {
	      fill: degree + '-' + colorSpectrum.start + '-' + colorSpectrum.end,
	      stroke: 'none'
	    });
	  };
	
	  /**
	   * Render wedge text
	   * @param {object} paper - raphael paper
	   * @param {object} position - position
	   * @param {object} theme - legend label theme
	   * @returns {SVGTextElement} - wedge text
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._renderWedgeText = function _renderWedgeText(paper, position, theme) {
	    if (this.isLeftLegend) {
	      position.left += _const2['default'].MAP_LEGEND_WEDGE_SIZE + _const2['default'].MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING;
	    }
	
	    return _raphaelRenderUtil2['default'].renderText(paper, position, '', {
	      'font-size': theme.fontSize,
	      'font-family': theme.fontFamily,
	      'font-weight': theme.fontWeight,
	      fill: theme.color
	    });
	  };
	
	  /**
	   * Render wedge.
	   * @param {object} paper raphael object
	   * @param {{top: number, left: number}} position base position of legend
	   * @returns {object} raphael object
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._renderWedge = function _renderWedge(paper, position) {
	    return paper.path(this.verticalBasePath).attr({
	      fill: 'gray',
	      stroke: 'white',
	      'stroke-opacity': 0.2,
	      opacity: 0,
	      transform: 't' + position.left + ',' + position.top
	    });
	  };
	
	  /**
	   * Make vertical wedge path.
	   * @param {number} top top
	   * @param {object} labelDimension label width and height
	   * @returns {Array} path
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._makeVerticalWedgePath = function _makeVerticalWedgePath(top, labelDimension) {
	    var isLeftLegend = this.isLeftLegend;
	
	    var path = this.verticalBasePath = isLeftLegend ? this.verticalLeftBasePath : this.verticalRightBasePath;
	    var PADDING_H = _const2['default'].MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING,
	        PADDING_V = _const2['default'].MAP_LEGEND_TOOLTIP_VERTICAL_PADDING;
	    var labelWidth = labelDimension.width,
	        labelHeight = labelDimension.height;
	
	
	    path[2] = top;
	    path[5] = top + WEDGE_BASE_HALF;
	    path[8] = path[11] = top + labelHeight / 2 + PADDING_V;
	    path[14] = path[17] = top - labelHeight / 2 - PADDING_V;
	    path[20] = top - WEDGE_BASE_HALF;
	
	    if (isLeftLegend) {
	      path[10] = path[13] = path[4] + labelWidth + PADDING_H * 2;
	    } else {
	      path[10] = path[13] = path[4] - labelWidth - PADDING_H * 2;
	    }
	
	    return path;
	  };
	
	  /**
	   * Make horizontal wedge path.
	   * @param {number} left left
	   * @param {object} labelDimension label width and height
	   * @returns {Array} path
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._makeHorizontalWedgePath = function _makeHorizontalWedgePath(left, labelDimension) {
	    var path = this.horiziontalBaseBath = this.isTopLegend ? this.horizontalTopBasePath : this.horizontalBottomBasePath;
	    var PADDING_H = _const2['default'].MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING,
	        PADDING_V = _const2['default'].MAP_LEGEND_TOOLTIP_VERTICAL_PADDING;
	    var labelWidth = labelDimension.width,
	        labelHeight = labelDimension.height;
	
	
	    path[1] = left;
	    path[4] = left + WEDGE_BASE_HALF;
	    path[7] = path[10] = left + labelWidth / 2 + PADDING_H;
	    path[13] = path[16] = left - labelWidth / 2 - PADDING_H;
	    path[19] = left - WEDGE_BASE_HALF;
	
	    if (this.isTopLegend) {
	      path[11] = path[14] = path[5] + labelHeight + PADDING_V * 2;
	    } else {
	      path[11] = path[14] = path[5] - labelHeight - PADDING_V * 2;
	    }
	
	    return path;
	  };
	
	  /**
	   * Show wedge.
	   * @param {number} ratio value ratio beyond spectrum legend
	   * @param {string} label data value
	   */
	
	
	  RaphaelMapLegend.prototype.showWedge = function showWedge(ratio, label) {
	    var labelTheme = this.theme;
	    var labelSize = _raphaelRenderUtil2['default'].getRenderedTextSize(label, labelTheme.fontSize, labelTheme.fontFamily);
	    var legendSize = this.isHorizontal ? this.layout.dimension.width : this.layout.dimension.height;
	    var path = this._makeWedghPath(legendSize * ratio, labelSize);
	
	    this.wedge.attr({
	      path: path,
	      opacity: 1,
	      fill: this.colorSpectrum.getColor(ratio)
	    });
	
	    var wedgeBBox = this.wedge.getBBox();
	
	    var wedgeTextTop = _calculator2['default'].sum([wedgeBBox.y, _const2['default'].MAP_LEGEND_TOOLTIP_VERTICAL_PADDING, labelSize.height / 2]);
	
	    var wedgeTextLeft = _calculator2['default'].sum([wedgeBBox.x, _const2['default'].MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING, labelSize.width / 2]);
	
	    if (this.isLeftLegend) {
	      wedgeTextLeft += _const2['default'].MAP_LEGEND_WEDGE_SIZE;
	    }
	
	    if (this.isTopLegend) {
	      wedgeTextTop += _const2['default'].MAP_LEGEND_WEDGE_SIZE;
	    }
	
	    this.wedgeText.attr({
	      x: wedgeTextLeft,
	      y: wedgeTextTop,
	      text: label,
	      opacity: 1
	    });
	
	    this.wedge.toFront();
	    this.wedgeText.toFront();
	  };
	
	  /**
	   * Hide wedge
	   */
	
	
	  RaphaelMapLegend.prototype.hideWedge = function hideWedge() {
	    this.wedge.attr({
	      opacity: 0
	    });
	
	    this.wedgeText.attr({
	      opacity: 0
	    });
	  };
	
	  /**
	   * Remove location URL from fill attribute
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype.removeLocationURLFromFillAttribute = function removeLocationURLFromFillAttribute() {
	    var gradientBar = this.gradientBar;
	
	    var fillURL = gradientBar.node.getAttribute('fill');
	    var locationUrlRegExp = /url\('?([^#]+)#[^#]+'?\)/;
	
	    var _locationUrlRegExp$ex = locationUrlRegExp.exec(fillURL);
	
	    var _locationUrlRegExp$ex2 = _slicedToArray(_locationUrlRegExp$ex, 2);
	
	    this.locationURL = _locationUrlRegExp$ex2[1];
	
	
	    gradientBar.node.setAttribute('fill', fillURL.replace(this.locationURL, ''));
	  };
	
	  /**
	   * Restore location URL to fill attribute
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype.restoreLocationURLToFillAttribute = function restoreLocationURLToFillAttribute() {
	    var gradientBar = this.gradientBar;
	
	    var fillURL = gradientBar.node.getAttribute('fill');
	
	    gradientBar.node.setAttribute('fill', fillURL.replace('#', this.locationURL + '#'));
	  };
	
	  /**
	   * Calculate tooltip area height of horizontal legend
	   * @param {Array.<string>} labels - labels
	   * @param {object} theme - legend label theme
	   * @returns {number} - tooltip height
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._calculateHorizontalLegendTooltipHeight = function _calculateHorizontalLegendTooltipHeight(labels, theme) {
	    var label = labels.length ? labels[labels.length - 1] : '';
	    var labelHeight = _renderUtil2['default'].getRenderedLabelHeight(label, theme);
	
	    return _calculator2['default'].sum([_const2['default'].MAP_LEGEND_TOOLTIP_VERTICAL_PADDING * 2, labelHeight, _const2['default'].MAP_LEGEND_WEDGE_SIZE]);
	  };
	
	  /**
	   * Calculate tooltip area width of vertical legend
	   * @param {Array.<string>} labels - labels
	   * @param {object} theme - legend label theme
	   * @returns {number} - tooltip width
	   * @private
	   */
	
	
	  RaphaelMapLegend.prototype._calculateVerticalLegendTooltipWidth = function _calculateVerticalLegendTooltipWidth(labels, theme) {
	    var label = labels.length ? labels[labels.length - 1] : '';
	    var labelWidth = _renderUtil2['default'].getRenderedLabelWidth(label, theme);
	
	    return _calculator2['default'].sum([_const2['default'].MAP_LEGEND_TOOLTIP_HORIZONTAL_PADDING * 2, labelWidth, _const2['default'].MAP_LEGEND_WEDGE_SIZE]);
	  };
	
	  return RaphaelMapLegend;
	}();
	
	exports['default'] = RaphaelMapLegend;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelCircleLegend is graph renderer for circleLegend.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	/**
	 * @classdesc RaphaelCircleLegend is graph renderer for circleLegend.
	 * @class RaphaelCircleLegend
	 * @private
	 */
	var RaphaelCircleLegend = function () {
	  function RaphaelCircleLegend() {
	    _classCallCheck(this, RaphaelCircleLegend);
	  }
	
	  /**
	   * Render circle and label.
	   * @param {object} paper paper object
	   * @param {{width: number, height: number}} layout - layout of circle legend area
	   * @param {number} maxRadius - pixel type maximum radius
	   * @param {Array.<number>} radiusRatios - radius ratios
	   * @param {Array.<string>} labels - circle legend labels
	   * @returns {Array.<object>}
	   * @private
	   */
	  RaphaelCircleLegend.prototype.render = function render(paper, layout, maxRadius, radiusRatios, labels) {
	    var left = layout.position.left + layout.dimension.width / 2;
	    var circleLegendSet = paper.set();
	
	    radiusRatios.forEach(function (ratio, index) {
	      var radius = maxRadius * ratio;
	      var top = layout.position.top + layout.dimension.height - radius;
	      var circle = _raphaelRenderUtil2['default'].renderCircle(paper, {
	        left: left,
	        top: top
	      }, radius, {
	        fill: 'none',
	        opacity: 1,
	        stroke: '#888',
	        'stroke-width': 1
	      });
	
	      circleLegendSet.push(circle);
	
	      circleLegendSet.push(_raphaelRenderUtil2['default'].renderText(paper, {
	        left: left,
	        top: top - radius - 5
	      }, labels[index]));
	    });
	
	    return circleLegendSet;
	  };
	
	  return RaphaelCircleLegend;
	}();
	
	exports['default'] = RaphaelCircleLegend;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael title renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var RaphaelTitleComponent = function () {
	  function RaphaelTitleComponent() {
	    _classCallCheck(this, RaphaelTitleComponent);
	  }
	
	  /**
	   * Render title
	   * @param {object} renderInfo infos for render
	   *   @param {object} renderInfo.paper - paper
	   *   @param {string} renderInfo.titleText - title text
	   *   @param {{x: number, y: number}} renderInfo.offset - title offset x, y
	   *   @param {object} renderInfo.theme - theme object
	   *   @param {string} [renderInfo.align] - title align option
	   *   @param {number} renderInfo.chartTitleAreaWidth chart title area width
	   * @returns {Array.<object>} title set
	   */
	  RaphaelTitleComponent.prototype.render = function render(renderInfo) {
	    var paper = renderInfo.paper,
	        titleText = renderInfo.titleText,
	        offset = renderInfo.offset,
	        theme = renderInfo.theme,
	        _renderInfo$align = renderInfo.align,
	        align = _renderInfo$align === undefined ? _const2['default'].TITLE_ALIGN_LEFT : _renderInfo$align,
	        chartTitleAreaWidth = renderInfo.chartTitleAreaWidth;
	    var fontSize = theme.fontSize,
	        fontFamily = theme.fontFamily;
	
	    var titleSize = _raphaelRenderUtil2['default'].getRenderedTextSize(titleText, fontSize, fontFamily);
	    var titleSet = paper.set();
	    var pos = this.getTitlePosition(titleSize, align, chartTitleAreaWidth, offset);
	    var textAnchorAlign = {
	      left: 'start',
	      right: 'end',
	      center: 'middle'
	    };
	
	    titleSet.push(_raphaelRenderUtil2['default'].renderText(paper, pos, titleText, {
	      'font-family': theme.fontFamily,
	      'font-size': theme.fontSize,
	      'font-weight': theme.fontWeight,
	      fill: theme.color,
	      'text-anchor': textAnchorAlign[align]
	    }));
	
	    return titleSet;
	  };
	
	  /**
	   * calculate position of title
	   * @param {{width: number, height: number}} titleSize - size of title
	   * @param {string} [align] - title align option
	   * @param {number} chartWidth chart width
	   * @param {{x: number, y: number}} offset - title offset x, y
	   * @returns {{top: number, left: number}} position of title
	   */
	
	
	  RaphaelTitleComponent.prototype.getTitlePosition = function getTitlePosition(titleSize, align, chartWidth, offset) {
	    var left = void 0;
	
	    if (align === _const2['default'].TITLE_ALIGN_CENTER) {
	      left = chartWidth / 2;
	    } else if (align === _const2['default'].TITLE_ALIGN_RIGHT) {
	      left = chartWidth;
	    } else {
	      left = _const2['default'].CHART_PADDING;
	    }
	
	    var pos = {
	      left: left,
	      top: _const2['default'].CHART_PADDING + titleSize.height / 2 // for renderText's baseline
	    };
	
	    if (offset) {
	      if (offset.x) {
	        pos.left += offset.x;
	      } else if (offset.y) {
	        pos.top += offset.y;
	      }
	    }
	
	    return pos;
	  };
	
	  /**
	   * Resize title component
	   * @param {number} chartWidth chart width
	   * @param {Array.<object>} titleSet title set
	   */
	
	
	  RaphaelTitleComponent.prototype.resize = function resize(chartWidth, titleSet) {
	    titleSet.attr({
	      left: _const2['default'].CHART_PADDING
	    });
	  };
	
	  return RaphaelTitleComponent;
	}();
	
	exports['default'] = RaphaelTitleComponent;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Raphael title renderer.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var Y_AXIS_TITLE_PADDING = _const2['default'].Y_AXIS_TITLE_PADDING,
	    AXIS_BACKGROUND_RIGHT_PADDING = _const2['default'].AXIS_BACKGROUND_RIGHT_PADDING;
	
	var RaphaelAxisComponent = function () {
	  function RaphaelAxisComponent() {
	    _classCallCheck(this, RaphaelAxisComponent);
	
	    this.ticks = [];
	  }
	
	  /**
	   * Render background with plot background color
	   * @param {object} paper Raphael paper
	   * @param {object} position axis position
	   * @param {object} dimension axis dimension
	   * @param {object} theme chart theme
	   * @returns {Element} - raphael <rect> element
	   * @private
	   */
	
	
	  RaphaelAxisComponent.prototype.renderBackground = function renderBackground(paper, position, dimension, theme) {
	    var background = theme && theme.background || {};
	    var _background$color = background.color,
	        color = _background$color === undefined ? '#fff' : _background$color,
	        _background$opacity = background.opacity,
	        opacity = _background$opacity === undefined ? 1 : _background$opacity;
	
	
	    return _raphaelRenderUtil2['default'].renderRect(paper, {
	      left: 0,
	      top: position.top,
	      width: dimension.width + position.left - AXIS_BACKGROUND_RIGHT_PADDING,
	      height: dimension.height
	    }, {
	      fill: color,
	      opacity: opacity,
	      'stroke-width': 0
	    });
	  };
	
	  /**
	   * Render title
	   * @param {object} paper raphael paper
	   * @param {object} data rendering data
	   * @param {string} data.text text content
	   * @param {object} data.theme theme object
	   * @param {object} data.rotationInfo object
	   * @param {object} data.layout dimension and position
	   */
	
	
	  RaphaelAxisComponent.prototype.renderTitle = function renderTitle(paper, data) {
	    var theme = data.theme,
	        rotationInfo = data.rotationInfo;
	    var fontFamily = theme.fontFamily,
	        fontSize = theme.fontSize,
	        fontWeight = theme.fontWeight,
	        color = theme.color;
	
	    var textAnchor = this.getRenderTitleAnchor(rotationInfo);
	    var attributes = {
	      'dominant-baseline': 'auto',
	      'font-family': fontFamily,
	      'font-size': fontSize,
	      'font-weight': fontWeight,
	      fill: color,
	      transform: 'none',
	      'text-anchor': textAnchor
	    };
	    var position = this.calculatePosition(paper, data);
	    var title = _raphaelRenderUtil2['default'].renderText(paper, position, data.text, attributes);
	
	    title.node.style.userSelect = 'none';
	    title.node.style.cursor = 'default';
	
	    data.set.push(title);
	  };
	
	  /**
	   * Get title anchor
	   * @param {object} rotationInfo - isCenter, isVertical, isPositionRight
	   * @returns {string} textAnchor - middle or end or start
	   */
	
	
	  RaphaelAxisComponent.prototype.getRenderTitleAnchor = function getRenderTitleAnchor(rotationInfo) {
	    var textAnchor = 'middle';
	    if (rotationInfo.isPositionRight || !rotationInfo.isVertical && !rotationInfo.isXAxisTitleLeft) {
	      textAnchor = 'end';
	    } else if (rotationInfo.isVertical && !rotationInfo.isCenter || !rotationInfo.isVertical && rotationInfo.isXAxisTitleLeft) {
	      textAnchor = 'start';
	    }
	
	    return textAnchor;
	  };
	
	  /**
	   * Render Axis label
	   * @param {object} data data for render label
	   *       @param {{
	   *           left: number,
	   *           top: number
	   *       }} data.positionTopAndLeft left, top positions
	   *       @param {string} data.labelText label text
	   *       @param {number} data.labelSize label size
	   *       @param {object} data.paper raphael paper
	   *       @param {boolean} data.isVertical boolean value of axis is vertical
	   *       @param {boolean} data.isPositionRight boolean value of axis is right yAxis
	   *       @param {object} data.theme theme of label
	   */
	
	
	  RaphaelAxisComponent.prototype.renderLabel = function renderLabel(data) {
	    var positionTopAndLeft = data.positionTopAndLeft,
	        labelText = data.labelText,
	        paper = data.paper,
	        theme = data.theme,
	        isVertical = data.isVertical,
	        isCenter = data.isCenter;
	
	    var attributes = {
	      'dominant-baseline': 'central',
	      'font-family': theme.fontFamily,
	      'font-size': theme.fontSize,
	      'font-weight': theme.fontWeight,
	      fill: theme.color
	    };
	
	    if (data.isPositionRight) {
	      attributes['text-anchor'] = 'end';
	    } else if (isVertical && !isCenter) {
	      attributes['text-anchor'] = 'start';
	    } else {
	      attributes['text-anchor'] = 'middle';
	    }
	
	    var textObj = _raphaelRenderUtil2['default'].renderText(paper, positionTopAndLeft, labelText, attributes);
	
	    textObj.node.style.userSelect = 'none';
	    textObj.node.style.cursor = 'default';
	
	    data.set.push(textObj);
	    this.ticks.push(textObj);
	  };
	
	  /**
	   * Render rotated Axis label
	   * @param {object} data data for render rotated label
	   *       @param {{
	   *           left: number,
	   *           top: number
	   *       }} data.positionTopAndLeft left, top positions
	   *       @param {string} data.labelText label text
	   *       @param {object} data.paper raphael paper
	   *       @param {boolean} data.isVertical boolean value of axis is vertical
	   *       @param {object} data.theme theme of label
	   *       @param {number} data.degree rotation degree
	   */
	
	
	  RaphaelAxisComponent.prototype.renderRotatedLabel = function renderRotatedLabel(data) {
	    var positionTopAndLeft = data.positionTopAndLeft,
	        labelText = data.labelText,
	        paper = data.paper,
	        theme = data.theme;
	
	    var textObj = _raphaelRenderUtil2['default'].renderText(paper, positionTopAndLeft, labelText, {
	      'dominant-baseline': 'central',
	      'font-family': theme.fontFamily,
	      'font-size': theme.fontSize,
	      'font-weight': theme.fontWeight,
	      fill: theme.color,
	      'text-anchor': 'end',
	      transform: 'r' + -data.degree + ',' + positionTopAndLeft.left + ',' + positionTopAndLeft.top
	    });
	
	    textObj.node.style.userSelect = 'none';
	    textObj.node.style.cursor = 'arrow';
	
	    data.set.push(textObj);
	    this.ticks.push(textObj);
	  };
	
	  /**
	   * Render ticks on given paper
	   * @param {object} data data for rendering ticks
	   */
	
	
	  RaphaelAxisComponent.prototype.renderTicks = function renderTicks(data) {
	    var _this = this;
	
	    var paper = data.paper,
	        positions = data.positions,
	        additionalSize = data.additionalSize,
	        isVertical = data.isVertical,
	        isCenter = data.isCenter,
	        isDivided = data.isDivided,
	        isPositionRight = data.isPositionRight,
	        tickColor = data.tickColor,
	        layout = data.layout;
	
	
	    var rightEdgeOfAxis = layout.position.left + layout.dimension.width;
	    var baseTop = layout.position.top;
	    var baseLeft = layout.position.left;
	    var centerAxisWidth = isDivided ? data.otherSideDimension.width : 0;
	    var isContainDivensionArea = function isContainDivensionArea(position) {
	      var compareType = isVertical ? 'height' : 'width';
	
	      return position > layout.dimension[compareType] + centerAxisWidth;
	    };
	    var tick = void 0;
	
	    positions.forEach(function (position) {
	      var pathString = 'M';
	
	      position += additionalSize;
	
	      if (isContainDivensionArea(position)) {
	        return;
	      }
	
	      if (isVertical) {
	        if (isCenter) {
	          pathString += baseLeft + ',' + (baseTop + position);
	          pathString += 'H' + (baseLeft + 5);
	
	          pathString += 'M' + rightEdgeOfAxis + ',' + (baseTop + position);
	          pathString += 'H' + (rightEdgeOfAxis - 5);
	        } else if (isPositionRight) {
	          pathString += baseLeft + ',' + (baseTop + position);
	          pathString += 'H' + (baseLeft + 5);
	        } else {
	          pathString += rightEdgeOfAxis + ',' + (baseTop + position);
	          pathString += 'H' + (rightEdgeOfAxis - 5);
	        }
	      } else {
	        pathString += baseLeft + position + ',' + baseTop;
	        pathString += 'V' + (baseTop + 5);
	      }
	
	      if (!isNaN(position)) {
	        tick = paper.path(pathString).attr({
	          stroke: tickColor,
	          opacity: 0.5
	        });
	        data.set.push(tick);
	        _this.ticks.push(tick);
	      }
	    });
	  };
	
	  /**
	   * Render tick line  on given paper
	   * @param {number} data data for render tick line
	   * @param {number} data.areaSize area size width or height
	   * @param {object} data.paper raphael paper
	   * @param {boolean} data.isVertical boolean value of vertical axis or not
	   */
	
	
	  RaphaelAxisComponent.prototype.renderStandardLine = function renderStandardLine(data) {
	    var lineSize = data.areaSize,
	        _data$layout = data.layout,
	        position = _data$layout.position,
	        dimension = _data$layout.dimension,
	        paper = data.paper,
	        isVertical = data.isVertical;
	
	    var baseLeft = position.left;
	    var minAbs = Math.abs(data.axisLimit.min);
	    var maxAbs = Math.abs(data.axisLimit.max);
	    var standardRatio = 1 - maxAbs / (minAbs + maxAbs);
	    var pathString = 'M';
	    var baseTop = position.top;
	    var rightEdgeOfAxis = baseLeft + dimension.width;
	
	    if (isVertical) {
	      var lineStartYCoord = baseTop;
	      rightEdgeOfAxis += data.seriesDimension.width * standardRatio;
	      pathString += rightEdgeOfAxis + ',' + lineStartYCoord;
	      var lineEndYCoord = baseTop + lineSize;
	      pathString += 'V' + lineEndYCoord;
	    } else {
	      pathString += baseLeft;
	      baseTop -= data.seriesDimension.height * standardRatio;
	      pathString += ',' + baseTop + 'H';
	      var lineEndXCoord = baseLeft + lineSize;
	      pathString += lineEndXCoord;
	    }
	
	    data.set.push(paper.path(pathString).attr({
	      'stroke-width': 1,
	      opacity: 0.5
	    }));
	  };
	
	  /**
	   * Render tick line  on given paper
	   * @param {number} data data for render tick line
	   * @param {number} data.areaSize area size width or height
	   * @param {object} data.paper raphael paper
	   * @param {boolean} data.isNotDividedXAxis boolean value for XAxis divided or not
	   * @param {number} data.additionalSize additional size for position and line length
	   * @param {number} data.additionalWidth additional width of tick line paper
	   * @param {number} data.additionalHeight additional height of tick line paper
	   * @param {boolean} data.isPositionRight boolean value of right yAxis or not
	   * @param {boolean} data.isCenter boolean value of center yAxis or not
	   * @param {boolean} data.isVertical boolean value of vertical axis or not
	   */
	
	
	  RaphaelAxisComponent.prototype.renderTickLine = function renderTickLine(data) {
	    var areaSize = data.areaSize,
	        paper = data.paper,
	        _data$layout2 = data.layout,
	        _data$layout2$positio = _data$layout2.position,
	        baseTop = _data$layout2$positio.top,
	        baseLeft = _data$layout2$positio.left,
	        dimension = _data$layout2.dimension,
	        isNegativeStandard = data.isNegativeStandard,
	        isNotDividedXAxis = data.isNotDividedXAxis,
	        additionalSize = data.additionalSize,
	        isPositionRight = data.isPositionRight,
	        isCenter = data.isCenter,
	        isVertical = data.isVertical,
	        tickColor = data.tickColor,
	        seriesDimension = data.seriesDimension;
	
	    var lineSize = areaSize;
	    var verticalTickLineEndYCoord = dimension.height + baseTop;
	    var rightEdgeOfAxis = baseLeft + dimension.width;
	    var pathString = 'M';
	    var lineStartYCoord = void 0,
	        lineEndYCoord = void 0;
	
	    if (isPositionRight) {
	      pathString += baseLeft + ',' + baseTop;
	      pathString += 'V' + verticalTickLineEndYCoord;
	    } else if (isVertical) {
	      lineStartYCoord = baseTop;
	      if (isNegativeStandard) {
	        rightEdgeOfAxis += seriesDimension.width / 2;
	      }
	      pathString += rightEdgeOfAxis + ',' + lineStartYCoord;
	
	      if (isCenter) {
	        pathString += 'V' + verticalTickLineEndYCoord;
	        pathString += 'M' + baseLeft + ',' + lineStartYCoord;
	        pathString += 'V' + verticalTickLineEndYCoord;
	      } else {
	        lineEndYCoord = baseTop + lineSize;
	        pathString += 'V' + lineEndYCoord;
	      }
	    } else {
	      pathString = this._makeNormalTickPath(pathString, {
	        isNotDividedXAxis: isNotDividedXAxis,
	        baseTop: baseTop,
	        baseLeft: baseLeft,
	        additionalSize: additionalSize,
	        isNegativeStandard: isNegativeStandard,
	        seriesDimension: seriesDimension,
	        lineSize: lineSize
	      });
	    }
	
	    data.set.push(paper.path(pathString).attr({
	      'stroke-width': 1,
	      stroke: tickColor,
	      opacity: 0.5
	    }));
	  };
	
	  /**
	   * Render tick line  on given paper
	   * @param {string} pathString render path string
	   * @param {object} pathInfo render path infos
	   *   @param {boolean} pathInfo.isNotDividedXAxis boolean value for XAxis divided or not
	   *   @param {number} pathInfo.baseTop baseTop
	   *   @param {number} pathInfo.baseLeft baseLeft
	   *   @param {number} pathInfo.additionalSize additional size for position and line length
	   *   @param {boolean} bpathInfo.isNegativeStandard boolean value for XAxis divided or not
	   *   @param {object} pathInfo.seriesDimension seriesDemension
	   *   @param {number} pathInfo.lineSize tick line size
	   *   @returns {string} pathString
	   * @private
	   */
	
	
	  RaphaelAxisComponent.prototype._makeNormalTickPath = function _makeNormalTickPath(pathString, pathInfo) {
	    if (pathInfo.isNotDividedXAxis) {
	      pathString += pathInfo.baseLeft;
	    } else {
	      pathString += pathInfo.baseLeft + pathInfo.additionalSize;
	    }
	
	    if (pathInfo.isNegativeStandard) {
	      pathInfo.baseTop -= pathInfo.seriesDimension.height / 2;
	    }
	
	    pathString += ',' + pathInfo.baseTop + 'H';
	
	    var lineEndXCoord = pathInfo.baseLeft + pathInfo.lineSize;
	
	    if (!pathInfo.isNotDividedXAxis) {
	      lineEndXCoord += pathInfo.additionalSize;
	    }
	
	    pathString += lineEndXCoord;
	
	    return pathString;
	  };
	
	  /**
	   * Animate ticks for adding data
	   * @param {number} tickSize tick size of moving
	   */
	
	
	  RaphaelAxisComponent.prototype.animateForAddingData = function animateForAddingData(tickSize) {
	    this.ticks.forEach(function (tick) {
	      tick.animate({
	        transform: 't-' + tickSize + ',0'
	      }, 300);
	    });
	  };
	
	  /**
	   * Calculate axis title position, and transform
	   * @param {Raphael.paper} paper - paper
	   * @param {object} data - options for calculating title position
	   *  @param {object} data.rotationInfo - isCenter, isVertical, isPositionRight
	   *  @param {object} data.text - text
	   *  @param {object} data.theme - theme
	   *  @param {object} data.layout - layout
	   * @returns {object} position - top, left
	   */
	
	
	  RaphaelAxisComponent.prototype.calculatePosition = function calculatePosition(paper, data) {
	    var rotationInfo = data.rotationInfo,
	        text = data.text,
	        theme = data.theme,
	        additionalWidth = data.additionalWidth,
	        otherSideDimension = data.otherSideDimension,
	        areaSize = data.areaSize,
	        layout = data.layout;
	
	    var textHeight = getTextHeight(text, theme);
	    var textWidth = getTextWidth(text, theme);
	    var axisHeight = layout.dimension.height;
	    var axisWidth = layout.dimension.width;
	    var _layout$position = layout.position,
	        top = _layout$position.top,
	        left = _layout$position.left;
	
	    var leftPosition = left + additionalWidth;
	    var adjustLeftPosition = textWidth - otherSideDimension.width;
	    var position = {
	      top: top + axisHeight - textHeight / 2,
	      left: leftPosition + (adjustLeftPosition < 0 ? 0 : adjustLeftPosition)
	    };
	
	    if (rotationInfo.isVertical) {
	      if (rotationInfo.isCenter) {
	        position.top += textHeight / 2;
	        position.left = left + axisWidth / 2;
	      } else if (!rotationInfo.isDiverging) {
	        position.top = top - textHeight / 2 - Y_AXIS_TITLE_PADDING;
	      }
	    } else if (!rotationInfo.isVertical) {
	      if (rotationInfo.isDiverging && rotationInfo.isYAxisCenter) {
	        position.left = left + areaSize / 2;
	      } else if (rotationInfo.isDiverging && !rotationInfo.isYAxisCenter) {
	        position.left = left + axisWidth / 2;
	      } else if (rotationInfo.isXAxisTitleLeft) {
	        position.left = layout.position.left;
	      } else {
	        position.left = layout.position.left + axisWidth;
	      }
	    }
	
	    if (rotationInfo.isPositionRight) {
	      position.left += axisWidth;
	    }
	
	    if (!rotationInfo.isCenter) {
	      addOffset(position, data.offset);
	    }
	
	    return position;
	  };
	
	  return RaphaelAxisComponent;
	}();
	
	/**
	 * Get a text height by theme
	 * @param {string} text - text
	 * @param {object} theme - axis theme
	 * @returns {number} text height
	 * @ignore
	 */
	
	
	function getTextHeight(text, theme) {
	  var titleSize = _raphaelRenderUtil2['default'].getRenderedTextSize(text, theme.fontSize, theme.fontFamily);
	
	  return titleSize.height;
	}
	
	/**
	 * Get a text width by theme
	 * @param {string} text - text
	 * @param {object} theme - axis theme
	 * @returns {number} text width
	 * @ignore
	 */
	function getTextWidth(text, theme) {
	  var titleSize = _raphaelRenderUtil2['default'].getRenderedTextSize(text, theme.fontSize, theme.fontFamily);
	
	  return titleSize.width;
	}
	
	/**
	 * Add offset to position
	 * @param {object} position - top, left
	 * @param {object} offset - x, y
	 * @ignore
	 */
	function addOffset(position, offset) {
	  if (!offset) {
	    return;
	  }
	
	  if (offset.x) {
	    position.left += offset.x;
	  }
	  if (offset.y) {
	    position.top += offset.y;
	  }
	}
	
	exports['default'] = RaphaelAxisComponent;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview RaphaelRadialPlot is graph renderer for radial plot.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var STEP_TOP_ADJUSTMENT = 8;
	var STEP_LEFT_ADJUSTMENT = 3;
	
	/**
	 * @classdesc RaphaelRadialPlot is graph renderer for radial plot.
	 * @class RaphaelRadialPlot
	 * @private
	 */
	
	var RaphaelRadialPlot = function () {
	  function RaphaelRadialPlot() {
	    _classCallCheck(this, RaphaelRadialPlot);
	  }
	
	  /**
	   * Render function of map chart legend.
	   * @param {object} params parameters
	   * @param {HTMLElement} params.container container
	   * @param {{width: number, height: number}} params.dimension - dimension of circle legend area
	   * @param {Array<Array>} params.plotPositions plot positions
	   * @param {object} params.labelData label data
	   * @returns {object} paper raphael paper
	   */
	  RaphaelRadialPlot.prototype.render = function render(params) {
	    var plotSet = params.paper.set();
	
	    this.paper = params.paper;
	    this.layout = params.layout;
	    this.plotPositions = params.plotPositions;
	    this.theme = params.theme;
	    this.options = params.options;
	    this.labelData = params.labelData;
	
	    this._renderPlot(plotSet);
	    this._renderLabels(plotSet);
	
	    plotSet.toBack();
	    this.paper.pushDownBackgroundToBottom();
	
	    return plotSet;
	  };
	
	  /**
	   * Render plot component
	   * @param {Array.<object>} plotSet plot set
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderPlot = function _renderPlot(plotSet) {
	    if (this.options.type === 'circle') {
	      this._renderCirclePlot(plotSet);
	    } else {
	      this._renderSpiderwebPlot(plotSet);
	    }
	
	    this._renderCategoryDots(plotSet);
	  };
	
	  /**
	   * Render spider web plot
	   * @param {Array.<object>} plotSet plot set
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderSpiderwebPlot = function _renderSpiderwebPlot(plotSet) {
	    var groupPaths = this._getLinesPath(this.plotPositions);
	
	    this._renderLines(groupPaths, this.theme.lineColor, plotSet);
	  };
	
	  /**
	   * Render circle plot
	   * @param {Array.<object>} plotSet plot set
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderCirclePlot = function _renderCirclePlot(plotSet) {
	    var plotPositions = this.plotPositions;
	
	    var _plotPositions = _slicedToArray(plotPositions, 1),
	        _plotPositions$ = _slicedToArray(_plotPositions[0], 1),
	        centerPoint = _plotPositions$[0];
	
	    var strokeColor = this.theme.lineColor;
	
	    for (var i = 1; i < plotPositions.length; i += 1) {
	      var _plotPositions$i = _slicedToArray(plotPositions[i], 1),
	          pos = _plotPositions$i[0];
	
	      var radius = centerPoint.top - pos.top;
	
	      plotSet.push(_raphaelRenderUtil2['default'].renderCircle(this.paper, centerPoint, radius, {
	        stroke: strokeColor,
	        'stroke-opacity': 0.05
	      }));
	    }
	  };
	
	  /**
	   * Render category lines
	   * @param {Array.<object>} plotSet plot set
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderCategoryDots = function _renderCategoryDots(plotSet) {
	    var _this = this;
	
	    var bounds = this._makePlotDotBounds(_arrayUtil2['default'].pivot(this.plotPositions));
	    bounds.forEach(function (bound) {
	      var squareDot = _raphaelRenderUtil2['default'].renderRect(_this.paper, bound, {
	        fill: '#000000',
	        'fill-opacity': 0.5,
	        'stroke-width': 0
	      });
	      plotSet.push(squareDot);
	    }, this);
	  };
	
	  RaphaelRadialPlot.prototype._makePlotDotBounds = function _makePlotDotBounds(plotPositions) {
	    var bounds = plotPositions.map(function (positions) {
	      var outMostPlot = positions[positions.length - 1];
	      var bound = {
	        top: outMostPlot.top - 2,
	        left: outMostPlot.left - 2,
	        width: 4,
	        height: 4
	      };
	
	      return bound;
	    });
	    bounds.pop();
	
	    return bounds;
	  };
	
	  /**
	   * Render labels
	   * @param {Array.<object>} plotSet plot set
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderLabels = function _renderLabels(plotSet) {
	    var paper = this.paper,
	        theme = this.theme,
	        labelData = this.labelData;
	
	    var attributes = {
	      fill: theme.lineColor,
	      'font-size': theme.label.fontSize,
	      'font-family': theme.label.fontFamily,
	      'text-anchor': 'end',
	      'font-weight': '100',
	      'dominant-baseline': 'middle'
	    };
	
	    labelData.category.forEach(function (item) {
	      var categoryAttributes = Object.assign({}, attributes, {
	        'text-anchor': item.position.anchor,
	        fill: '#333333'
	      });
	      var label = _raphaelRenderUtil2['default'].renderText(paper, item.position, item.text, categoryAttributes);
	
	      label.node.style.userSelect = 'none';
	      label.node.style.cursor = 'default';
	
	      plotSet.push(label);
	    });
	
	    labelData.step.forEach(function (item) {
	      var stepLabel = _raphaelRenderUtil2['default'].renderText(paper, item.position, item.text, attributes);
	
	      item.position.top -= STEP_TOP_ADJUSTMENT;
	      item.position.left -= STEP_LEFT_ADJUSTMENT;
	
	      stepLabel.node.style.userSelect = 'none';
	      stepLabel.node.style.cursor = 'default';
	
	      plotSet.push(stepLabel);
	    });
	  };
	
	  /**
	   * Render lines.
	   * @param {Array.<Array.<string>>} groupPaths paths
	   * @param {string} lineColor line color
	   * @param {Array.<object>} plotSet plot set
	   * @returns {Array.<Array.<object>>} lines
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._renderLines = function _renderLines(groupPaths, lineColor, plotSet) {
	    var paper = this.paper;
	
	
	    return groupPaths.map(function (path) {
	      var line = _raphaelRenderUtil2['default'].renderLine(paper, path.join(' '), lineColor, 1);
	      line.node.setAttribute('stroke-opacity', 0.05);
	
	      plotSet.push(line);
	
	      return line;
	    });
	  };
	
	  /**
	   * Get lines path.
	   * /todo remove duplication, copied from raphaelLineTypeBase
	   * @param {Array.<Array.<{left: number, top: number, startTop: number}>>} groupPositions positions
	   * @returns {Array.<Array.<string>>} path
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._getLinesPath = function _getLinesPath(groupPositions) {
	    var _this2 = this;
	
	    return groupPositions.map(function (positions) {
	      return _this2._makeLinesPath(positions);
	    });
	  };
	
	  /**
	   * Make lines path.
	   * /todo remove duplication, copied from raphaelLineTypeBase
	   * @param {Array.<{left: number, top: number, startTop: number}>} positions positions
	   * @param {?string} [posTopType='top'] position top type
	   * @param {boolean} [connectNulls] - boolean value connect nulls or not
	   * @returns {Array.<string | number>} paths
	   * @private
	   */
	
	
	  RaphaelRadialPlot.prototype._makeLinesPath = function _makeLinesPath(positions, posTopType, connectNulls) {
	    var path = [];
	    var prevMissing = false;
	
	    posTopType = posTopType || 'top';
	
	    positions.forEach(function (position) {
	      var pathCommand = prevMissing && !connectNulls ? 'M' : 'L';
	
	      if (position) {
	        path.push([pathCommand, position.left, position[posTopType]]);
	        if (prevMissing) {
	          prevMissing = false;
	        }
	      } else {
	        prevMissing = true;
	      }
	    });
	
	    path = Array.prototype.concat.apply([], path);
	    path[0] = 'M';
	
	    return path;
	  };
	
	  return RaphaelRadialPlot;
	}();
	
	exports['default'] = RaphaelRadialPlot;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _chartFactory = __webpack_require__(32);
	
	var _chartFactory2 = _interopRequireDefault(_chartFactory);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _themeManager = __webpack_require__(35);
	
	var _themeManager2 = _interopRequireDefault(_themeManager);
	
	var _mapManager = __webpack_require__(37);
	
	var _mapManager2 = _interopRequireDefault(_mapManager);
	
	var _objectUtil = __webpack_require__(38);
	
	var _objectUtil2 = _interopRequireDefault(_objectUtil);
	
	var _seriesDataImporter = __webpack_require__(39);
	
	var _seriesDataImporter2 = _interopRequireDefault(_seriesDataImporter);
	
	var _drawingToolPicker = __webpack_require__(40);
	
	var _drawingToolPicker2 = _interopRequireDefault(_drawingToolPicker);
	
	__webpack_require__(41);
	
	__webpack_require__(42);
	
	__webpack_require__(147);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Raw series datum.
	 * @typedef {{name: ?string, data: Array.<number>, stack: ?string}} rawSeriesDatum
	 * @private
	 */
	
	/**
	 * Raw series data.
	 * @typedef {Array.<rawSeriesDatum>} rawSeriesData
	 * @private
	 */
	
	/**
	 * Raw data.
	 * @typedef {{
	 *      categories: ?Array.<string>,
	 *      series: (rawSeriesData|{line: ?rawSeriesData, column: ?rawSeriesData})
	 * }} rawData
	 * @private
	 */
	
	/**
	 * Create chart.
	 * @param {HTMLElement} container container
	 * @param {({
	 *        series: (object|Array),
	 *        categories: Array
	 *   }|{
	 *        table: ({
	 *          elementId: string
	 *        }|{
	 *          element: HTMLElement
	 *        })
	 *   })} rawData - raw data object or data container table element or table's id
	 * @param {{
	 *   chart: {
	 *     width: number,
	 *     height: number,
	 *     title: string,
	 *     format: string
	 *   },
	 *   yAxis: {
	 *     title: string,
	 *     min: number
	 *   },
	 *   xAxis: {
	 *     title: string,
	 *     min: number
	 *   },
	 *   tooltip: {
	 *     suffix: string,
	 *     template: function
	 *   },
	 *   theme: string
	 * }} options - chart options
	 * @param {string} chartType - chart type
	 * @returns {object} chart instance.
	 * @private
	 * @ignore
	 */
	function _createChart(container) {
	  var rawData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  var options = arguments[2];
	  var chartType = arguments[3];
	
	  if (rawData.table) {
	    rawData = _seriesDataImporter2['default'].makeDataWithTable(rawData.table);
	  }
	
	  if (!rawData.series) {
	    rawData.series = [];
	  }
	
	  rawData = _objectUtil2['default'].deepCopy(rawData);
	
	  if (chartType !== 'combo') {
	    var temp = rawData.series;
	    rawData.series = {};
	    rawData.series[chartType] = temp;
	  }
	
	  options = options ? _objectUtil2['default'].deepCopy(options) : {};
	  options.chartType = chartType;
	  options.theme = options.theme || _const2['default'].DEFAULT_THEME_NAME;
	
	  var isColorByPoint = options.series && options.series.colorByPoint;
	  var theme = _themeManager2['default'].get(options.theme, chartType, rawData.series, isColorByPoint);
	  var chart = _chartFactory2['default'].get(options.chartType, rawData, theme, options);
	
	  chart.render(container);
	  chart.animateChart();
	
	  return chart;
	}
	
	/**
	 * Bar chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {string} options.yAxis.align - align option for center y axis
	 *          @param {string} options.yAxis.type - type of axis
	 *          @param {string} options.yAxis.dateFormat - date format
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.min - minimum value for x axis
	 *          @param {number} options.xAxis.max - maximum value for x axis
	 *          @param {boolean} options.xAxis.pointOnColumn - Place the label between the ticks.
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {string} options.series.stackType - type of stack
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {number} options.series.barWidth - bar width
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.diverging - whether diverging or not
	 *          @param {boolean} options.series.colorByPoint - whether category Individual colors
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} bar chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Bar Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.barChart(container, rawData, options);
	 */
	/**
	 * @fileoverview chart.js is entry point of Toast UI Chart.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function barChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_BAR);
	}
	
	/**
	 * Column chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {string} options.series.stackType - type of stack
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {number} options.series.barWidth - bar width
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.diverging - whether diverging or not
	 *          @param {boolean} options.series.colorByPoint - whether category Individual colors
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} column chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Column Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.columnChart(container, rawData, options);
	 */
	function columnChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_COLUMN);
	}
	
	/**
	 * Line chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {?Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {string} options.xAxis.tickInterval - tick interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *              @param {boolean} options.plot.mergeOverlappingRanges - whether show overlapping ranges
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *          @param {Array.<{value: (string|number|date), color: ?string, opacity: ?string}>} options.plot.lines
	 *                  - plot lines
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} line chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Line Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       },
	 *       series: {
	 *         showDot: true
	 *       }
	 *     };
	 * chart.lineChart(container, rawData, options);
	 */
	function lineChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_LINE);
	}
	
	/**
	 * Area chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {?Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.tickInterval - tick interval for x axis
	 *          @param {string} options.xAxis.type - type of axis
	 *          @param {string} options.xAxis.dateFormat - date format
	 *          @param {boolean} options.xAxis.pointOnColumn - Place the label between the ticks.
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *              @param {boolean} options.plot.mergeOverlappingRanges - whether show overlapping ranges
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} area chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [20, 30, 50]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [40, 40, 60]
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: [60, 50, 10]
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: [80, 10, 70]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Area Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.areaChart(container, rawData, options);
	 */
	function areaChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_AREA);
	}
	
	/**
	 * Bubble chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {number} options.xAxis.min - minimum value for y axis
	 *          @param {number} options.xAxis.max - maximum value for y axis
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.circleLegend - options for circleLegend
	 *          @param {boolean} options.circleLegend.visible - whether visible or not (default: true)
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} bubble chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [{
	 *              x: 10,
	 *              y: 20,
	 *              r: 15,
	 *              label: 'Lable1'
	 *           }, {
	 *              x: 20,
	 *              y: 40,
	 *              r: 10,
	 *              label: 'Lable2'
	 *           }]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [{
	 *              x: 40,
	 *              y: 10,
	 *              r: 5,
	 *              label: 'Lable3'
	 *           }, {
	 *              x: 30,
	 *              y: 40,
	 *              r: 8,
	 *              label: 'Lable4'
	 *           }]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Bubble Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.bubbleChart(container, rawData, options);
	 */
	function bubbleChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_BUBBLE);
	}
	
	/**
	 * Scatter chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {number} options.yAxis.maxWidth - max Width for y axis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.min - minimum value for x axis
	 *          @param {number} options.xAxis.max - maximum value for x axis
	 *          @param {number} options.xAxis.maxWidth - max Width for x axis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} scatter chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: [{
	 *              x: 10,
	 *              y: 20
	 *           }, {
	 *              x: 20,
	 *              y: 40
	 *           }]
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: [{
	 *              x: 40,
	 *              y: 10
	 *           }, {
	 *              x: 30,
	 *              y: 40
	 *           }]
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Scatter Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.scatterChart(container, rawData, options);
	 */
	function scatterChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_SCATTER);
	}
	
	/**
	 * Heatmap chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {{x: Array.<string | number>, y: Array.<string | number>}} rawData.categories - categories
	 *      @param {Array.<Array.<number>>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} heatmap chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: {
	 *           x: [10, 20, 30, 40, 50],
	 *           y: [1, 2, 3, 4, 5, 6]
	 *       },
	 *       series: [
	 *           [10, 20, 30, 40, 50],
	 *           [1, 4, 6, 7, 8],
	 *           [20, 4, 5, 70, 8],
	 *           [100, 40, 30, 80, 30],
	 *           [20, 10, 60, 90, 20],
	 *           [50, 40, 30, 20, 10]
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Heatmap Chart'
	 *       },
	 *       yAxis: {
	 *         title: 'Y Axis'
	 *       },
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       }
	 *     };
	 * chart.heatmapChart(container, rawData, options);
	 */
	function heatmapChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_HEATMAP);
	}
	
	/**
	 * Treemap chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array.<object>>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.useColorValue - whether use colorValue or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.useLeafLabel - whether use leaf label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} treemap chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *          {
	 *              label: 'label1',
	 *              value: 6
	 *          },
	 *          {
	 *              label: 'label2',
	 *              value: 6
	 *          },
	 *          {
	 *              label: 'label3',
	 *              value: 4
	 *          },
	 *          {
	 *              label: 'label4',
	 *              value: 3
	 *          },
	 *          {
	 *              label: 'label5',
	 *              value: 2
	 *          },
	 *          {
	 *              label: 'label6',
	 *              value: 2
	 *          },
	 *          {
	 *              label: 'label7',
	 *              value: 1
	 *          }
	 *     ],
	 *     options = {
	 *       chart: {
	 *         title: 'Treemap Chart'
	 *       }
	 *     };
	 * chart.treemapChart(container, rawData, options);
	 */
	function treemapChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_TREEMAP);
	}
	
	/**
	 * Combo chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<string>} rawData.categories - categories
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {string | object} options.yAxis.title - title text or title object
	 *              @param {string} options.yAxis.title.text - title text
	 *              @param {number} options.yAxis.title.offsetX - title offset x
	 *              @param {number} options.yAxis.title.offsetY - title offset y
	 *          @param {number} options.yAxis.labelMargin - label margin for y axis
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *          @param {string} options.yAxis.prefix - prefix for yAxis
	 *          @param {string} options.yAxis.suffix - suffix for yAxis
	 *          @param {string} options.yAxis.chartType - chart type for combo chart
	 *          @param {number} options.yAxis.maxWidth - max Width for yAxis
	 *      @param {object} options.xAxis - options for x axis component
	 *          @param {string | object} options.xAxis.title - title text or title object
	 *              @param {string} options.xAxis.title.text - title text
	 *              @param {number} options.xAxis.title.offsetX - title offset x
	 *              @param {number} options.xAxis.title.offsetY - title offset y
	 *              @param {number} options.xAxis.title.align - title align (left|right) (default: right)
	 *          @param {number} options.xAxis.labelMargin - label margin for x axis
	 *          @param {number} options.xAxis.labelInterval - label interval for x axis
	 *          @param {boolean} options.xAxis.rotateLabel - whether rotate label or not (default: true)
	 *          @param {string} options.xAxis.prefix - prefix for xAxis
	 *          @param {string} options.xAxis.suffix - suffix for xAxis
	 *          @param {number} options.xAxis.maxWidth - max Width for xAxis
	 *          @param {boolean} options.xAxis.pointOnColumn - Place the label between the ticks.
	 *      @param {object} options.series - options for series component
	 *          @param {?object} options.series.column - options for column series component
	 *              @param {string} options.series.column.stackType - type of stack
	 *              @param {boolean} options.series.column.showLabel - whether show label or not
	 *              @param {number} options.series.column.barWidth - bar width
	 *          @param {?object} options.series.line - options for line series component
	 *              @param {boolean} options.series.line.showDot - whether show dot or not
	 *              @param {boolean} options.series.line.showLabel - whether show label or not
	 *              @param {boolean} options.series.line.spline - whether spline or not
	 *          @param {?object} options.series.area - options for line series component
	 *              @param {boolean} options.series.area.showDot - whether show dot or not
	 *              @param {boolean} options.series.area.showLabel - whether show label or not
	 *              @param {boolean} options.series.area.spline - whether spline or not
	 *          @param {?object} options.series.pie - options for pie series component
	 *              @param {boolean} options.series.pie.showLabel - whether show label or not
	 *              @param {number} options.series.pie.radiusRatio - ratio of radius for pie graph
	 *              @param {number} options.series.pie.startAngle - start angle
	 *              @param {number} options.series.pie.endAngle - end angle
	 *          @param {boolean} options.series.showDot - whether show dot or not
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.spline - whether spline or not
	 *          @param {boolean} options.series.zoomable - whether zoomable or not
	 *          @param {boolean} options.series.shifting - whether shifting or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {object} options.tooltip.column - options for column tooltip
	 *              @param {string} options.tooltip.column.suffix - suffix for tooltip
	 *              @param {function} [options.tooltip.column.template] template of tooltip
	 *              @param {string} options.tooltip.column.align - align option for tooltip
	 *              @param {number} options.tooltip.column.offsetX - tooltip offset x
	 *              @param {number} options.tooltip.column.offsetY - tooltip offset y
	 *          @param {boolean} options.tooltip.grouped - whether group tooltip or not
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.showLine - whether show line or not (default: true)
	 *          @param {Array} options.plot.bands - plot bands for line & area combo chart
	 *              @param {Array.<string|number|date>} options.plot.bands.range - value range for matching
	 *              @param {string} options.plot.bands.color - band color
	 *              @param {number} options.plot.bands.opacity - band opacity
	 *              @param {boolean} options.plot.mergeOverlappingRanges - whether show overlapping ranges
	 *          @param {Array} options.plot.lines - plot lines
	 *              @param {(string|number|date)} options.plot.lines.value - value for matching
	 *              @param {string} options.plot.lines.color - band color
	 *              @param {number} options.plot.lines.opacity - band opacity
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} combo chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       categories: ['cate1', 'cate2', 'cate3'],
	 *       series: {
	 *         column: [
	 *           {
	 *             name: 'Legend1',
	 *             data: [20, 30, 50]]
	 *           },
	 *           {
	 *             name: 'Legend2',
	 *             data: [40, 40, 60]
	 *           },
	 *           {
	 *             name: 'Legend3',
	 *             data: [60, 50, 10]
	 *           },
	 *           {
	 *             name: 'Legend4',
	 *             data: [80, 10, 70]
	 *           }
	 *         },
	 *         line: [
	 *           {
	 *             name: 'Legend5',
	 *             data: [1, 2, 3]
	 *           }
	 *         ]
	 *       }
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Combo Chart'
	 *       },
	 *       yAxis:[
	 *         {
	 *           title: 'Y Axis',
	 *           chartType: 'line'
	 *         },
	 *         {
	 *           title: 'Y Right Axis'
	 *         }
	 *       ],
	 *       xAxis: {
	 *         title: 'X Axis'
	 *       },
	 *       series: {
	 *         showDot: true
	 *       }
	 *     };
	 * chart.comboChart(container, rawData, options);
	 */
	function comboChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_COMBO);
	}
	
	/**
	 * Pie chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *          @param {boolean} options.series.showLegend - whether show legend label or not
	 *          @param {function} options.series.labelFilter - filter for series label display
	 *          @param {number} options.series.radiusRatio - ratio of radius for pie graph
	 *          @param {boolean} options.series.allowSelect - whether allow select or not
	 *          @param {boolean} options.series.startAngle - start angle
	 *          @param {boolean} options.series.endAngle - end angle
	 *          @param {string} options.series.labelAlign - label align
	 *          @param {Array<string>} options.series.radiusRange: radius range
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} pie chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           name: 'Legend1',
	 *           data: 20
	 *         },
	 *         {
	 *           name: 'Legend2',
	 *           data: 40
	 *         },
	 *         {
	 *           name: 'Legend3',
	 *           data: 60
	 *         },
	 *         {
	 *           name: 'Legend4',
	 *           data: 80
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Pie Chart'
	 *       }
	 *     };
	 * chart.pieChart(container, rawData, options);
	 */
	function pieChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_PIE);
	}
	
	/**
	 * Map chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showLabel - whether show label or not
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {object} options.tooltip.offset - tooltip offset
	 *              @param {number} options.tooltip.offset.x - offset x
	 *              @param {number} options.tooltip.offset.y - offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.map map type
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} map chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 *     rawData = {
	 *       series: [
	 *         {
	 *           code: 'KR',
	 *           data: 100,
	 *           labelCoordinate: {
	 *             x: 0.6,
	 *             y: 0.7
	 *           }
	 *         },
	 *         {
	 *           code: 'JP',
	 *           data: 50
	 *         }
	 *       ]
	 *     },
	 *     options = {
	 *       chart: {
	 *         title: 'Map Chart'
	 *       },
	 *       map: 'world'
	 *     };
	 * chart.mapChart(container, rawData, options);
	 */
	function mapChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_MAP);
	}
	
	/**
	 * radial chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData - raw data
	 *      @param {Array.<Array>} rawData.series - series data
	 * @param {object} options - chart options
	 *      @param {object} options.chart - base options for chart
	 *          @param {number} options.chart.width - chart width
	 *          @param {number} options.chart.height - chart height
	 *          @param {string | object} options.chart.title - title text or title object
	 *              @param {string} options.chart.title.text - title text
	 *              @param {string} options.chart.title.align - align option for chart title (left|center|right)
	 *              @param {number} options.chart.title.offsetX - title offset x
	 *              @param {number} options.chart.title.offsetY - title offset y
	 *          @param {string | function} options.chart.format - formatter for value
	 *      @param {object} options.series - options for series component
	 *          @param {boolean} options.series.showDot - show dot or not (default: false)
	 *          @param {boolean} options.series.showArea - show area or not (default: false)
	 *      @param {object} options.plot - options for plot component
	 *          @param {boolean} options.plot.type - "spiderweb" or "circle" (default: "spiderweb")
	 *      @param {object|Array} options.yAxis - options for y axis component
	 *          @param {number} options.yAxis.min - minimum value for y axis
	 *          @param {number} options.yAxis.max - maximum value for y axis
	 *      @param {object} options.tooltip - options for tooltip component
	 *          @param {string} options.tooltip.suffix - suffix for tooltip
	 *          @param {function} [options.tooltip.template] - template for tooltip
	 *          @param {string} options.tooltip.align - align option for tooltip
	 *          @param {number} options.tooltip.offsetX - tooltip offset x
	 *          @param {number} options.tooltip.offsetY - tooltip offset y
	 *      @param {object} options.legend - options for legend component
	 *          @param {string} options.legend.align - align option for legend (top|bottom|left|center|outer)
	 *          @param {boolean} options.legend.showCheckbox - whether show checkbox or not (default: true)
	 *          @param {boolean} options.legend.visible - whether visible or not (default: true)
	 *          @param {number} options.legend.maxWidth - legend name display max width
	 *      @param {string} options.theme - theme name
	 *      @param {string} options.libType - type of graph library
	 *      @param {object} options.chartExportMenu - options for exporting
	 *          @param {string} options.chartExportMenu.filename - export file name
	 *          @param {string} options.chartExportMenu.visible - whether visible or not (default: true)
	 *      @param {boolean} options.usageStatistics - send hostname to google analytics
	 * @returns {object} radial chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('chart-area'),
	 *     rawData = {
	 *         categories: ["June", "July", "Aug", "Sep", "Oct", "Nov"],
	 *         series: [
	 *             {
	 *                 name: 'Budget',
	 *                 data: [5000, 3000, 5000, 7000, 6000, 4000]
	 *             },
	 *             {
	 *                 name: 'Income',
	 *                 data: [8000, 8000, 7000, 2000, 5000, 3000]
	 *             },
	 *             {
	 *                 name: 'Expenses',
	 *                 data: [4000, 4000, 6000, 3000, 4000, 5000]
	 *             },
	 *             {
	 *                 name: 'Debt',
	 *                 data: [6000, 3000, 3000, 1000, 2000, 4000]
	 *             }
	 *         ]
	 *     },
	 *     options = {
	 *         chart: {
	 *             width: 600,
	 *             height: 400
	 *         },
	 *         series: {
	 *             showDot: true,
	 *             showArea: true
	 *         },
	 *         plot: {
	 *             type: 'circle'
	 *         },
	 *         yAxis: {
	 *             min: 0,
	 *             max: 9000
	 *         }
	 *     };
	 * chart.radialChart(container, rawData, options);
	 *
	 */
	function radialChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_RADIAL);
	}
	
	/**
	 * Boxplot chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 * @param {object} options - chart options
	 * @returns {object} box plot chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('container-id'),
	 * var rawData = {
	 *  categories: ['Budget', 'Income', 'Expenses', 'Debt'],
	 *  series: [{
	 *      name: '2015',
	 *      data: [
	 *          [1000, 2500, 3714, 5500, 7000],
	 *          [1000, 2250, 3142, 4750, 6000]
	 *      ],
	 *      outliers: [
	 *          [0, 14000]
	 *      ]
	 *  }, {
	 *      name: '2016',
	 *      data: [
	 *          [2000, 4500, 6714, 11500, 13000],
	 *          [7000, 9250, 10142, 11750, 12000]
	 *      ],
	 *      outliers: [
	 *          [1, 14000]
	 *      ]
	 *  }];
	 * };
	 * var options = {
	 *      chart: {
	 *          width: 600,
	 *          height: 400
	 *      },
	 *      series: {
	 *          showDot: true,
	 *          showArea: true
	 *      },
	 *      plot: {
	 *          type: 'circle'
	 *      },
	 *      yAxis: {
	 *          min: 0,
	 *          max: 9000
	 *      }
	 *  };
	 * chart.boxplotChart(container, rawData, options);
	 */
	function boxplotChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_BOXPLOT);
	}
	
	/**
	 * Bullet chart creator.
	 * @memberof module:chart
	 * @memberof tui.chart
	 * @param {HTMLElement} container - chart container
	 * @param {rawData} rawData chart data
	 * @param {object} options - chart options
	 * @returns {object} bullet chart
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var container = document.getElementById('chart-area');
	 * var data = {
	 *   categories: ['July', 'August'],
	 *   series: [{
	 *       name: 'Budget',
	 *       data: 25,
	 *      markers: [28, 2, 15],
	 *       ranges: [[-1, 10], [10, 20], [20, 30]]
	 *   },{
	 *       name: 'Hello',
	 *       data: 11,
	 *       markers: [20],
	 *       ranges: [[0, 8], [8, 15]]
	 *   }]
	 * };
	 * var options = {
	 *    chart: {
	 *       width: 700,
	 *       height: 300,
	 *       title: 'Monthly Revenue'
	 *   },
	 *   series: {
	 *       showLabel: true,
	 *       vertical: false
	 *   }
	 * };
	 * chart.bulletChart(container, data, options);
	 */
	function bulletChart(container, rawData, options) {
	  return _createChart(container, rawData, options, _const2['default'].CHART_TYPE_BULLET);
	}
	
	/**
	 * Register theme.
	 * @memberof tui.chart
	 * @param {string} themeName - theme name
	 * @param {object} theme - application chart theme
	 *      @param {object} theme.chart - chart theme
	 *          @param {string} theme.chart.fontFamily - font family for chart
	 *          @param {string} theme.chart.background - background for chart
	 *      @param {object} theme.title - chart title theme
	 *          @param {number} theme.title.fontSize - font size
	 *          @param {string} theme.title.fontFamily - font family
	 *          @param {string} theme.title.fontWeight - font weight
	 *          @param {string} theme.title.color - font color
	 *          @param {string} theme.title.background - background
	 *      @param {object} theme.yAxis - y axis theme
	 *          @param {object} theme.yAxis.title - theme for y axis title
	 *              @param {number} theme.yAxis.title.fontSize - font size
	 *              @param {string} theme.yAxis.title.fontFamily - font family
	 *              @param {string} theme.yAxis.title.fontWeight - font weight
	 *              @param {string} theme.yAxis.title.color - font color
	 *          @param {object} theme.yAxis.label - theme for y axis label
	 *              @param {number} theme.yAxis.label.fontSize - font size
	 *              @param {string} theme.yAxis.label.fontFamily - font family
	 *              @param {string} theme.yAxis.label.fontWeight - font weight
	 *              @param {string} theme.yAxis.label.color - font color
	 *          @param {string} theme.yAxis.tickColor - color for y axis tick
	 *      @param {object} theme.xAxis - theme for x axis
	 *          @param {object} theme.xAxis.title - theme for x axis title
	 *              @param {number} theme.xAxis.title.fontSize - font size
	 *              @param {string} theme.xAxis.title.fontFamily - font family
	 *              @param {string} theme.xAxis.title.fontWeight - font weight
	 *              @param {string} theme.xAxis.title.color - font color
	 *          @param {object} theme.xAxis.label - theme for x axis label
	 *              @param {number} theme.xAxis.label.fontSize - font size
	 *              @param {string} theme.xAxis.label.fontFamily - font family
	 *              @param {string} theme.xAxis.label.fontWeight - font weight
	 *              @param {string} theme.xAxis.label.color - font color
	 *          @param {string} theme.xAxis.tickColor - color for x axis tick
	 *      @param {object} theme.plot - theme for plot
	 *          @param {string} theme.plot.lineColor - line color
	 *          @param {string} theme.plot.background - background
	 *      @param {object} theme.series theme for series
	 *          @param {Array.<string>} theme.series.colors - colors
	 *          @param {string} theme.series.borderColor - border color
	 *          @param {string} theme.series.selectionColor - selection color
	 *          @param {string} theme.series.startColor - start color
	 *          @param {string} theme.series.endColor - end color
	 *          @param {string} theme.series.overColor - over color
	 *      @param {object} theme.legend - theme for legend
	 *          @param {object} theme.legend.label - theme for legend label
	 *              @param {number} theme.legend.label.fontSize - font size
	 *              @param {string} theme.legend.label.fontFamily - font family
	 *              @param {string} theme.legend.label.fontWeight - font family
	 *              @param {string} theme.legend.label.color - font color
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var theme = {
	 *   yAxis: {
	 *     tickColor: '#ccbd9a',
	 *       title: {
	 *         color: '#333333'
	 *       },
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     },
	 *     xAxis: {
	 *       tickColor: '#ccbd9a',
	 *       title: {
	 *         color: '#333333'
	 *       },
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     },
	 *     plot: {
	 *       lineColor: '#e5dbc4',
	 *       background: '#f6f1e5'
	 *     },
	 *     series: {
	 *       colors: ['#40abb4', '#e78a31', '#c1c452', '#795224', '#f5f5f5'],
	 *       borderColor: '#8e6535',
	 *       selectionColor: '#cccccc',
	 *       startColor: '#efefef',
	 *       endColor: 'blue',
	 *       overColor: 'yellow'
	 *     },
	 *     legend: {
	 *       label: {
	 *         color: '#6f491d'
	 *       }
	 *     }
	 *   };
	 * chart.registerTheme('newTheme', theme);
	 */
	function registerTheme(themeName, theme) {
	  _themeManager2['default'].register(themeName, theme);
	}
	
	/**
	 * Register map.
	 * @memberof tui.chart
	 * @param {string} mapName map name
	 * @param {Array.<{code: string, name: string, path: string}>} data map data
	 * @api
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var data = [
	 *   {
	 *     code: 'KR',
	 *     name: 'South Korea',
	 *     path: 'M835.13,346.53L837.55,350.71...',
	 *     labelCoordinate: {
	 *       x: 0.6,
	 *       y: 0.7
	 *     }
	 *   },
	 *   //...
	 * ];
	 * chart.registerMap('newMap', data);
	 */
	function registerMap(mapName, data) {
	  _mapManager2['default'].register(mapName, data);
	}
	
	/**
	 * Register graph plugin.
	 * @memberof tui.chart
	 * @param {string} libType type of graph library
	 * @param {object} plugin plugin to control library
	 * @param {function} getPaperCallback callback function for getting paper
	 * @example
	 * var chart = tui.chart; // or require('tui-chart');
	 * var pluginRaphael = {
	 *   bar: function() {} // Render class
	 * };
	 * tui.chart.registerPlugin('raphael', pluginRaphael);
	 */
	function registerPlugin(libType, plugin, getPaperCallback) {
	  _pluginFactory2['default'].register(libType, plugin);
	  _drawingToolPicker2['default'].addRendererType(libType, getPaperCallback);
	}
	
	module.exports = {
	  barChart: barChart,
	  columnChart: columnChart,
	  lineChart: lineChart,
	  areaChart: areaChart,
	  bubbleChart: bubbleChart,
	  scatterChart: scatterChart,
	  heatmapChart: heatmapChart,
	  treemapChart: treemapChart,
	  comboChart: comboChart,
	  pieChart: pieChart,
	  mapChart: mapChart,
	  radialChart: radialChart,
	  boxplotChart: boxplotChart,
	  bulletChart: bulletChart,
	  registerTheme: registerTheme,
	  registerMap: registerMap,
	  registerPlugin: registerPlugin
	};

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _rawDataHandler = __webpack_require__(33);
	
	var _rawDataHandler2 = _interopRequireDefault(_rawDataHandler);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var charts = {}; /**
	                  * @fileoverview  Chart factory play role register chart.
	                  *                Also, you can get chart from this factory.
	                  * @author NHN.
	                  *         FE Development Lab <dl_javascript@nhn.com>
	                  */
	
	exports['default'] = {
	  /**
	   * Find key for getting chart.
	   * @param {string} chartType - type of chart
	   * @param {{seriesAlias: ?object, series: object.<string, Array>}} rawData - raw data
	   * @returns {string}
	   * @private
	   */
	  _findKey: function _findKey(chartType, rawData) {
	    var key = null;
	    if (_predicate2['default'].isComboChart(chartType)) {
	      var chartTypeMap = _rawDataHandler2['default'].getChartTypeMap(rawData);
	
	      if (chartTypeMap[_const2['default'].CHART_TYPE_COLUMN] && chartTypeMap[_const2['default'].CHART_TYPE_LINE]) {
	        key = _const2['default'].CHART_TYPE_COLUMN_LINE_COMBO;
	      } else if (chartTypeMap[_const2['default'].CHART_TYPE_LINE] && chartTypeMap[_const2['default'].CHART_TYPE_SCATTER]) {
	        key = _const2['default'].CHART_TYPE_LINE_SCATTER_COMBO;
	      } else if (chartTypeMap[_const2['default'].CHART_TYPE_AREA] && chartTypeMap[_const2['default'].CHART_TYPE_LINE]) {
	        key = _const2['default'].CHART_TYPE_LINE_AREA_COMBO;
	      } else if (chartTypeMap[_const2['default'].CHART_TYPE_PIE]) {
	        key = _const2['default'].CHART_TYPE_PIE_DONUT_COMBO;
	      }
	    } else {
	      key = chartType;
	    }
	
	    return key;
	  },
	
	
	  /**
	   * Get chart instance.
	   * @param {string} chartType chart type
	   * @param {object} rawData chart data
	   * @param {object} theme chart options
	   * @param {object} options chart options
	   * @returns {object} chart instance;
	   */
	  get: function get(chartType, rawData, theme, options) {
	    var key = this._findKey(chartType, rawData);
	    var Chart = charts[key];
	
	    if (!Chart) {
	      throw new Error('Not exist ' + chartType + ' chart.');
	    }
	
	    return new Chart(rawData, theme, options);
	  },
	
	
	  /**
	   * Register chart.
	   * @param {string} chartType char type
	   * @param {class} ChartClass chart class
	   */
	  register: function register(chartType, ChartClass) {
	    charts[chartType] = ChartClass;
	  }
	};

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @fileoverview Raw data handler.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */
	
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Raw data Handler.
	 * @module rawDataHandler
	 * @private */
	exports['default'] = {
	  /**
	   * Pick stacks.
	   * @param {Array.<{stack: string}>} seriesData - raw series data
	   * @param {boolean} [divergingOption] - diverging option
	   * @returns {Array.<string>} stacks
	   */
	  pickStacks: function pickStacks(seriesData, divergingOption) {
	    var stacks = seriesData.map(function (seriesDatum) {
	      return seriesDatum.stack;
	    });
	
	    var uniqStacks = _arrayUtil2['default'].unique(stacks);
	
	    if (divergingOption) {
	      uniqStacks = uniqStacks.slice(0, 2);
	    }
	
	    var filteredStack = uniqStacks.filter(function (stack) {
	      return !!stack;
	    });
	
	    if (filteredStack.length < uniqStacks.length) {
	      filteredStack.push(_const2['default'].DEFAULT_STACK);
	    }
	
	    return filteredStack;
	  },
	
	
	  /**
	   * Sort series data from stacks.
	   * @param {Array.<{stack: ?string}>} seriesData series data
	   * @param {Array.<string>} stacks stacks
	   * @returns {Array}
	   * @private
	   */
	  _sortSeriesData: function _sortSeriesData(seriesData, stacks) {
	    var newSeriesData = [];
	
	    if (!stacks) {
	      stacks = this.pickStacks(seriesData);
	    }
	
	    stacks.forEach(function (stack) {
	      var filtered = seriesData.filter(function (datum) {
	        return (datum.stack || _const2['default'].DEFAULT_STACK) === stack;
	      });
	      newSeriesData = newSeriesData.concat(filtered);
	    });
	
	    return newSeriesData;
	  },
	
	
	  /**
	   * Remove stack of series data.
	   * @param {Array.<{stack: ?string}>} seriesData series data
	   */
	  removeSeriesStack: function removeSeriesStack(seriesData) {
	    Object.values(seriesData).forEach(function (datum) {
	      delete datum.stack;
	    });
	  },
	
	
	  /**
	   * Find char type from chart name.
	   * @param {object.<string, string>} seriesAlias - alias map
	   * @param {string} seriesType - series name
	   * @returns {*}
	   */
	  findChartType: function findChartType(seriesAlias, seriesType) {
	    var chartType = void 0;
	
	    if (seriesAlias) {
	      chartType = seriesAlias[seriesType];
	    }
	
	    return chartType || seriesType;
	  },
	
	
	  /**
	   * Get chart type map.
	   * @param {{series: (Array | object)}} rawData - raw data
	   * @returns {object.<string, string>}
	   */
	  getChartTypeMap: function getChartTypeMap(rawData) {
	    var _this = this;
	
	    var chartTypeMap = {};
	
	    if (_tuiCodeSnippet2['default'].isObject(rawData.series)) {
	      _tuiCodeSnippet2['default'].forEach(rawData.series, function (data, seriesType) {
	        chartTypeMap[_this.findChartType(rawData.seriesAlias, seriesType)] = true;
	      });
	    }
	
	    return chartTypeMap;
	  },
	
	
	  /**
	   * Create minus values.
	   * @param {Array.<number>} data number data
	   * @returns {Array} minus values
	   * @private
	   */
	  _createMinusValues: function _createMinusValues(data) {
	    return data.map(function (value) {
	      return value < 0 ? 0 : -value;
	    });
	  },
	
	
	  /**
	   * Create plus values.
	   * @param {Array.<number>} data number data
	   * @returns {Array} plus values
	   * @private
	   */
	  _createPlusValues: function _createPlusValues(data) {
	    return data.map(function (value) {
	      return value < 0 ? 0 : value;
	    });
	  },
	
	
	  /**
	   * Make normal diverging raw series data.
	   * @param {{data: Array.<number>}} rawSeriesData raw series data
	   * @returns {{data: Array.<number>}} changed raw series data
	   * @private
	   */
	  _makeNormalDivergingRawSeriesData: function _makeNormalDivergingRawSeriesData(rawSeriesData) {
	    rawSeriesData.length = Math.min(rawSeriesData.length, 2);
	
	    rawSeriesData[0].data = this._createMinusValues(rawSeriesData[0].data);
	
	    if (rawSeriesData[1]) {
	      rawSeriesData[1].data = this._createPlusValues(rawSeriesData[1].data);
	    }
	
	    return rawSeriesData;
	  },
	
	
	  /**
	   * Make raw series data for stacked diverging option.
	   * @param {{data: Array.<number>, stack: string}} rawSeriesData raw series data
	   * @returns {{data: Array.<number>}} changed raw series data
	   * @private
	   */
	  _makeRawSeriesDataForStackedDiverging: function _makeRawSeriesDataForStackedDiverging(rawSeriesData) {
	    var _this2 = this;
	
	    var stacks = this.pickStacks(rawSeriesData, true);
	    var result = [];
	
	    var _stacks = _slicedToArray(stacks, 2),
	        leftStack = _stacks[0],
	        rightStack = _stacks[1];
	
	    rawSeriesData = this._sortSeriesData(rawSeriesData, stacks);
	
	    rawSeriesData.forEach(function (seriesDatum) {
	      var stack = seriesDatum.stack || _const2['default'].DEFAULT_STACK;
	      if (stack === leftStack) {
	        seriesDatum.data = _this2._createMinusValues(seriesDatum.data);
	        result.push(seriesDatum);
	      } else if (stack === rightStack) {
	        seriesDatum.data = _this2._createPlusValues(seriesDatum.data);
	        result.push(seriesDatum);
	      }
	    });
	
	    return result;
	  },
	
	
	  /**
	   * Make raw series data for diverging.
	   * @param {{data: Array.<number>, stack: string}} rawSeriesData raw series data
	   * @param {?string} stackTypeOption stackType option
	   * @returns {{data: Array.<number>}} changed raw series data
	   * @private
	   */
	  _makeRawSeriesDataForDiverging: function _makeRawSeriesDataForDiverging(rawSeriesData, stackTypeOption) {
	    if (_predicate2['default'].isValidStackOption(stackTypeOption)) {
	      rawSeriesData = this._makeRawSeriesDataForStackedDiverging(rawSeriesData);
	    } else {
	      rawSeriesData = this._makeNormalDivergingRawSeriesData(rawSeriesData);
	    }
	
	    return rawSeriesData;
	  },
	
	
	  /**
	   * Update raw series data by options.
	   * @param {object} rawData - raw data
	   * @param {{stackType: ?string, diverging: ?boolean}} seriesOptions - series options
	   */
	  updateRawSeriesDataByOptions: function updateRawSeriesDataByOptions(rawData) {
	    var _this3 = this;
	
	    var seriesOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	
	    if (_predicate2['default'].isValidStackOption(seriesOptions.stackType)) {
	      Object.keys(rawData.series).forEach(function (seriesType) {
	        rawData.series[seriesType] = _this3._sortSeriesData(rawData.series[seriesType]);
	      });
	    }
	
	    if (seriesOptions.diverging) {
	      Object.entries(rawData.series).forEach(function (_ref) {
	        var _ref2 = _slicedToArray(_ref, 2),
	            seriesType = _ref2[0],
	            seriesDatum = _ref2[1];
	
	        rawData.series[seriesType] = _this3._makeRawSeriesDataForDiverging(seriesDatum, seriesOptions.stackType);
	      });
	    }
	  },
	
	
	  /**
	   * Append outlier value to boxplot series data end
	   * @param {object} rawData - raw data
	   */
	  appendOutliersToSeriesData: function appendOutliersToSeriesData(rawData) {
	    var boxplot = rawData.series.boxplot;
	
	    boxplot.forEach(function (seriesItem) {
	      var outliers = seriesItem.outliers;
	
	      if (outliers && outliers.length) {
	        outliers.forEach(function (outlier) {
	          seriesItem.data[outlier[0]].push(outlier[1]);
	        });
	      }
	    });
	  },
	
	
	  /**
	   * Filter raw data belong to checked legend.
	   * @param {object} rawData raw data
	   * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	   * @returns {object} rawData
	   */
	  filterCheckedRawData: function filterCheckedRawData(rawData, checkedLegends) {
	    var cloneData = JSON.parse(JSON.stringify(rawData));
	
	    if (checkedLegends) {
	      Object.entries(cloneData.series).forEach(function (_ref3) {
	        var _ref4 = _slicedToArray(_ref3, 2),
	            chartType = _ref4[0],
	            serieses = _ref4[1];
	
	        if (!checkedLegends[chartType]) {
	          cloneData.series[chartType] = [];
	        } else if (checkedLegends[chartType].length) {
	          cloneData.series[chartType] = serieses.filter(function (series, index) {
	            return checkedLegends[chartType][index];
	          });
	        }
	      });
	    }
	
	    if (cloneData.series.bullet) {
	      var filteredCategories = [];
	      checkedLegends.bullet.forEach(function (isChecked, index) {
	        if (isChecked) {
	          filteredCategories.push(rawData.categories[index]);
	        }
	      });
	      cloneData.categories = filteredCategories;
	    }
	
	    return cloneData;
	  },
	
	
	  /**
	   * Modify rawData to fit chart format
	   * @param {object} rawData - raw data
	   * @private
	   */
	  _makeRawSeriesDataForBulletChart: function _makeRawSeriesDataForBulletChart(rawData) {
	    var _rawData$series$bulle = rawData.series.bullet,
	        bullet = _rawData$series$bulle === undefined ? [] : _rawData$series$bulle;
	
	
	    rawData.categories = rawData.categories || [];
	    rawData.categories = bullet.map(function (seriesData) {
	      return seriesData.name || '';
	    });
	  }
	};

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var plugins = {}; /**
	                   * @fileoverview  Plugin factory play role register rendering plugin.
	                   *                Also, you can get plugin from this factory.
	                   * @author NHN.
	                   *         FE Development Lab <dl_javascript@nhn.com>
	                   */
	exports['default'] = {
	  /**
	   * Get graph renderer.
	   * @param {string} libType type of graph library
	   * @param {string} chartType chart type
	   * @returns {object} renderer instance
	   */
	  get: function get(libType, chartType) {
	    var plugin = plugins[libType || _const2['default'].DEFAULT_PLUGIN];
	
	    if (!plugin) {
	      throw new Error('Not exist ' + libType + ' plugin.');
	    }
	
	    var Renderer = plugin[chartType];
	    if (!Renderer) {
	      throw new Error('Not exist ' + chartType + ' chart renderer.');
	    }
	
	    var renderer = new Renderer();
	
	    return renderer;
	  },
	
	  /**
	   * Plugin register.
	   * @param {string} libType type of graph library
	   * @param {object} plugin plugin to control library
	   */
	  register: function register(libType, plugin) {
	    plugins[libType] = plugin;
	  }
	};

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @Fileoverview  Theme manager.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _defaultTheme = __webpack_require__(36);
	
	var _defaultTheme2 = _interopRequireDefault(_defaultTheme);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var themes = {};
	
	exports['default'] = {
	  /**
	   * Theme register.
	   * @param {string} themeName theme name
	   * @param {object} theme theme
	   */
	  register: function register(themeName, theme) {
	    theme = JSON.parse(JSON.stringify(theme));
	    themes[themeName] = theme;
	  },
	
	
	  /**
	   * Pick series types from raw series data.
	   * @param {string} chartType - chart type
	   * @param {object} rawSeriesData - raw series data
	   * @returns {Array}
	   * @private
	   */
	  _pickSeriesNames: function _pickSeriesNames(chartType, rawSeriesData) {
	    var seriesTypes = [];
	    if (_predicate2['default'].isComboChart(chartType)) {
	      Object.keys(rawSeriesData).forEach(function (seriesType) {
	        seriesTypes.push(seriesType);
	      });
	    } else {
	      seriesTypes.push(chartType);
	    }
	
	    return seriesTypes;
	  },
	
	
	  /**
	   * Overwrite theme
	   * @param {object} fromTheme - from theme
	   * @param {object} toTheme - to theme
	   * @private
	   */
	  _overwriteTheme: function _overwriteTheme(fromTheme, toTheme) {
	    var _this = this;
	
	    Object.entries(toTheme).forEach(function (_ref) {
	      var _ref2 = _slicedToArray(_ref, 2),
	          key = _ref2[0],
	          item = _ref2[1];
	
	      var fromItem = fromTheme[key];
	      if (!fromItem && fromItem !== 0) {
	        return;
	      }
	
	      if (_tuiCodeSnippet2['default'].isArray(fromItem)) {
	        toTheme[key] = fromItem.slice();
	      } else if (_tuiCodeSnippet2['default'].isObject(fromItem)) {
	        _this._overwriteTheme(fromItem, item);
	      } else {
	        toTheme[key] = fromItem;
	      }
	    });
	  },
	
	
	  /**
	   * Pick valid theme properties.
	   * @param {object} theme - theme
	   * @param {string} componentType - component type (series or yAxis)
	   * @returns {object}
	   * @private
	   */
	  _pickValidTheme: function _pickValidTheme(theme, componentType) {
	    var validTheme = {};
	
	    _const2['default'].THEME_PROPS_MAP[componentType].forEach(function (propName) {
	      if (_tuiCodeSnippet2['default'].isExisty(theme[propName])) {
	        validTheme[propName] = theme[propName];
	      }
	    });
	
	    return validTheme;
	  },
	
	
	  /**
	   * Create component theme with series name
	   * @param {Array.<string>} seriesTypes - series types
	   * @param {object} fromTheme - from theme
	   * @param {object} toTheme - to theme
	   * @param {string} componentType - component type
	   * @returns {object}
	   * @private
	   */
	  _createComponentThemeWithSeriesName: function _createComponentThemeWithSeriesName(seriesTypes, fromTheme, toTheme, componentType) {
	    var _this2 = this;
	
	    var newTheme = {};
	
	    fromTheme = fromTheme || {};
	
	    seriesTypes.forEach(function (seriesType) {
	      var theme = fromTheme[seriesType] || _this2._pickValidTheme(fromTheme, componentType);
	
	      if (_tuiCodeSnippet2['default'].keys(theme).length) {
	        newTheme[seriesType] = JSON.parse(JSON.stringify(_defaultTheme2['default'][componentType]));
	        _this2._overwriteTheme(theme, newTheme[seriesType]);
	      } else {
	        newTheme[seriesType] = JSON.parse(JSON.stringify(toTheme));
	      }
	    });
	
	    return newTheme;
	  },
	
	
	  /**
	   * Make each series's color
	   * @param {Array.<string>} themeColors Theme colors to use
	   * @param {number} seriesCount Series count
	   * @param {number} startColorIndex Start color index
	   * @returns {Array.<string>} colors
	   */
	  _makeEachSeriesColors: function _makeEachSeriesColors(themeColors, seriesCount, startColorIndex) {
	    var colors = [];
	    var themeColorsLen = themeColors.length;
	    var colorIndex = startColorIndex || 0;
	
	    for (var i = 0; i < seriesCount; i += 1) {
	      colors.push(themeColors[colorIndex]);
	
	      colorIndex += 1;
	
	      if (colorIndex >= themeColorsLen) {
	        colorIndex = 0;
	      }
	    }
	
	    return colors;
	  },
	
	
	  /**
	   * Set series colors theme.
	   * @param {Array.<string>} seriesTypes - series type
	   * @param {object} seriesThemes - series theme map
	   * @param {object} rawSeriesThemes - raw series theme map
	   * @param {object} rawSeriesData - raw series data
	   * @param {boolean} isColorByPoint - check colorByPoint option
	   * @private
	   */
	  _setSeriesColors: function _setSeriesColors(seriesTypes, seriesThemes, rawSeriesThemes, rawSeriesData, isColorByPoint) {
	    var _this3 = this;
	
	    var seriesColors = void 0,
	        seriesCount = void 0,
	        hasOwnColors = void 0;
	    var colorIndex = 0;
	
	    rawSeriesThemes = rawSeriesThemes || {}; // to simplify if/else statement
	
	    seriesTypes.forEach(function (seriesType) {
	      if (rawSeriesThemes[seriesType]) {
	        seriesColors = rawSeriesThemes[seriesType].colors;
	        hasOwnColors = true;
	      } else {
	        seriesColors = rawSeriesThemes.colors || _defaultTheme2['default'].series.colors;
	        hasOwnColors = false;
	      }
	
	      seriesCount = _this3._getSeriesThemeColorCount(rawSeriesData[seriesType], isColorByPoint);
	
	      seriesThemes[seriesType].colors = _this3._makeEachSeriesColors(seriesColors, seriesCount, !hasOwnColors && colorIndex);
	
	      // To distinct between series that use default theme, we make the colors different
	      if (!hasOwnColors) {
	        colorIndex = (seriesCount + colorIndex) % seriesColors.length;
	      }
	    });
	  },
	
	
	  /**
	   * Get number of series theme color from seriesData
	   * @param {object} rawSeriesDatum - raw series data contains series information
	   * @param {boolean} isColorByPoint - check colorByPoint option
	   * @returns {number} number of series theme color
	   * @private
	   */
	  _getSeriesThemeColorCount: function _getSeriesThemeColorCount(rawSeriesDatum, isColorByPoint) {
	    var seriesCount = 0;
	
	    if (rawSeriesDatum && rawSeriesDatum.length) {
	      var existFirstSeriesDataLength = rawSeriesDatum[0] && rawSeriesDatum[0].data && rawSeriesDatum[0].data.length;
	
	      if (isColorByPoint && existFirstSeriesDataLength) {
	        seriesCount = Math.max(rawSeriesDatum.length, rawSeriesDatum[0].data.length);
	      } else {
	        seriesCount = rawSeriesDatum.length;
	      }
	    }
	
	    return seriesCount;
	  },
	  _initTheme: function _initTheme(themeName, rawTheme, seriesTypes, rawSeriesData, isColorByPoint) {
	    var theme = void 0;
	
	    if (themeName !== _const2['default'].DEFAULT_THEME_NAME) {
	      // customized theme that overrides default theme
	      theme = JSON.parse(JSON.stringify(_defaultTheme2['default']));
	      this._overwriteTheme(rawTheme, theme);
	    } else {
	      // default theme
	      theme = JSON.parse(JSON.stringify(rawTheme));
	    }
	
	    // make each component theme have theme by series name. theme.yAxis.theme -> theme.yAxis.line.theme
	    theme.yAxis = this._createComponentThemeWithSeriesName(seriesTypes, rawTheme.yAxis, theme.yAxis, 'yAxis');
	    theme.series = this._createComponentThemeWithSeriesName(seriesTypes, rawTheme.series, theme.series, 'series');
	
	    this._setSeriesColors(seriesTypes, theme.series, rawTheme.series, rawSeriesData, isColorByPoint);
	
	    return theme;
	  },
	
	
	  /**
	   * Create target themes for font inherit.
	   * @param {object} theme - theme
	   * @returns {Array.<object>}
	   * @private
	   */
	  _createTargetThemesForFontInherit: function _createTargetThemesForFontInherit(theme) {
	    var items = [theme.title, theme.xAxis.title, theme.xAxis.label, theme.legend.label, theme.plot.label];
	
	    _tuiCodeSnippet2['default'].forEach(theme.yAxis, function (_theme) {
	      items.push(_theme.title, _theme.label);
	    });
	
	    _tuiCodeSnippet2['default'].forEach(theme.series, function (_theme) {
	      items.push(_theme.label);
	    });
	
	    return items;
	  },
	
	
	  /**
	   * Inherit theme font.
	   * @param {object} theme theme
	   * @private
	   */
	  _inheritThemeFont: function _inheritThemeFont(theme) {
	    var targetThemes = this._createTargetThemesForFontInherit(theme);
	    var baseFont = theme.chart.fontFamily;
	
	    targetThemes.forEach(function (item) {
	      if (!item.fontFamily) {
	        item.fontFamily = baseFont;
	      }
	    });
	  },
	
	
	  /**
	   * Copy color theme to otherTheme from seriesTheme.
	   * @param {object} seriesTheme - series theme
	   * @param {object} otherTheme - other theme
	   * @param {object} seriesType - series name
	   * @private
	   */
	  _copySeriesColorTheme: function _copySeriesColorTheme(seriesTheme, otherTheme, seriesType) {
	    otherTheme[seriesType] = {
	      colors: seriesTheme.colors,
	      borderColor: seriesTheme.borderColor,
	      selectionColor: seriesTheme.selectionColor
	    };
	  },
	
	
	  /**
	   * Copy series color theme to other components.
	   * @param {object} theme theme
	   * @private
	   * @ignore
	   */
	  _copySeriesColorThemeToOther: function _copySeriesColorThemeToOther(theme) {
	    var _this4 = this;
	
	    _tuiCodeSnippet2['default'].forEach(theme.series, function (seriesTheme, seriesType) {
	      _this4._copySeriesColorTheme(seriesTheme, theme.legend, seriesType);
	      _this4._copySeriesColorTheme(seriesTheme, theme.tooltip, seriesType);
	    });
	  },
	
	
	  /**
	   * Get theme.
	   * @param {string} themeName - theme name
	   * @param {string} chartType - chart type
	   * @param {object} rawSeriesData - raw series data
	   * @param {boolean} isColorByPoint - check colorByPoint option
	   * @returns {object}
	   */
	  get: function get(themeName, chartType, rawSeriesData, isColorByPoint) {
	    var rawTheme = themes[themeName];
	
	    if (!rawTheme) {
	      throw new Error('Not exist ' + themeName + ' theme.');
	    }
	
	    var seriesTypes = this._pickSeriesNames(chartType, rawSeriesData);
	
	    var theme = this._initTheme(themeName, rawTheme, seriesTypes, rawSeriesData, isColorByPoint);
	
	    this._inheritThemeFont(theme, seriesTypes);
	    this._copySeriesColorThemeToOther(theme);
	
	    return theme;
	  }
	};

/***/ }),
/* 36 */
/***/ (function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	var DEFAULT_COLOR = '#000000';
	var DEFAULT_BACKGROUND = '#ffffff';
	var DEFAULT_FONTWEIGHT = 'lighter';
	var DEFAULT_FONTFAMILY = 'Arial';
	var EMPTY = '';
	var DEFAULT_AXIS = {
	  tickColor: DEFAULT_COLOR,
	  title: {
	    fontSize: 11,
	    fontFamily: DEFAULT_FONTFAMILY,
	    color: '#bbbbbb',
	    fontWeight: 'bold'
	  },
	  label: {
	    fontSize: 11,
	    fontFamily: DEFAULT_FONTFAMILY,
	    color: '#333',
	    fontWeight: 'normal'
	  }
	};
	
	exports['default'] = {
	  chart: {
	    background: {
	      color: DEFAULT_BACKGROUND,
	      opacity: 1
	    },
	    fontFamily: DEFAULT_FONTFAMILY
	  },
	  title: {
	    fontSize: 18,
	    fontFamily: DEFAULT_FONTFAMILY,
	    color: DEFAULT_COLOR,
	    fontWeight: DEFAULT_FONTWEIGHT
	  },
	  yAxis: DEFAULT_AXIS,
	  xAxis: DEFAULT_AXIS,
	  plot: {
	    lineColor: '#000000',
	    background: '#ffffff',
	    label: {
	      fontSize: 11,
	      fontFamily: DEFAULT_FONTFAMILY,
	      color: '#888'
	    }
	  },
	  series: {
	    label: {
	      fontSize: 11,
	      fontFamily: DEFAULT_FONTFAMILY,
	      color: DEFAULT_COLOR,
	      fontWeight: DEFAULT_FONTWEIGHT
	    },
	    colors: ['#00a9ff', '#ffb840', '#ff5a46', '#00bd9f', '#785fff', '#f28b8c', '#989486', '#516f7d', '#29dbe3', '#dddddd'],
	    borderColor: EMPTY,
	    borderWidth: EMPTY,
	    selectionColor: EMPTY,
	    startColor: '#FFE98A',
	    endColor: '#D74177',
	    overColor: EMPTY,
	    dot: {
	      fillColor: EMPTY,
	      fillOpacity: 1,
	      strokeColor: EMPTY,
	      strokeOpacity: EMPTY,
	      strokeWidth: 0,
	      radius: 6,
	      hover: {
	        fillColor: EMPTY,
	        fillOpacity: 1,
	        strokeColor: '#fff',
	        strokeOpacity: 1,
	        strokeWidth: 4,
	        radius: 6
	      }
	    },
	    ranges: []
	  },
	  legend: {
	    label: {
	      fontSize: 11,
	      fontFamily: DEFAULT_FONTFAMILY,
	      color: '#333',
	      fontWeight: DEFAULT_FONTWEIGHT
	    }
	  },
	  tooltip: {},
	  chartExportMenu: {
	    backgroundColor: '#fff',
	    borderRadius: 0,
	    borderWidth: 1,
	    color: '#000'
	  }
	};

/***/ }),
/* 37 */
/***/ (function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	/**
	 * @fileoverview  Map Manager.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	var maps = {};
	
	exports["default"] = {
	  /**
	   * Get map data.
	   * @param {string} mapName map name
	   * @returns {Array} map data
	   */
	  get: function get(mapName) {
	    var data = maps[mapName];
	
	    if (!data) {
	      throw new Error("Not exist " + mapName + " map.");
	    }
	
	    return data;
	  },
	
	
	  /**
	   * Register Map.
	   * @param {string} mapName map name
	   * @param {Array} data map data
	   */
	  register: function register(mapName, data) {
	    maps[mapName] = data;
	  }
	};

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @fileoverview util for object
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */
	
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Deep copy.
	 * @memberOf module:objectUtil
	 * @param {object|Array|*} origin - original data
	 * @returns {*}
	 */
	var deepCopy = function deepCopy(origin) {
	  var clone = void 0;
	
	  if (_tuiCodeSnippet2['default'].isArray(origin)) {
	    clone = [];
	    origin.forEach(function (value, index) {
	      clone[index] = deepCopy(value);
	    });
	  } else if (_tuiCodeSnippet2['default'].isFunction(origin) || _tuiCodeSnippet2['default'].isDate(origin)) {
	    clone = origin;
	  } else if (_tuiCodeSnippet2['default'].isObject(origin)) {
	    clone = {};
	
	    Object.entries(origin).forEach(function (_ref) {
	      var _ref2 = _slicedToArray(_ref, 2),
	          key = _ref2[0],
	          value = _ref2[1];
	
	      clone[key] = deepCopy(value);
	    });
	  } else {
	    clone = origin;
	  }
	
	  return clone;
	};
	
	/**
	 * util for object
	 * @module objectUtil
	 * @private */
	exports['default'] = {
	  deepCopy: deepCopy
	};

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Get series data from 2D array
	 * @param {Array.<Array>} table2DArray - extracted 2DArray from table element
	 * @returns {{
	 *     series: Array.<object>,
	 *     categories: Array.<string>
	 *         }}
	 * @private
	 */
	/**
	 * @fileOverview Series data importer
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function getChartDataFrom2DArray(table2DArray) {
	  var chartData = void 0;
	
	  if (table2DArray.length > 0) {
	    chartData = {};
	    chartData.categories = [];
	    chartData.series = [];
	    chartData.categories = table2DArray.shift().slice(1);
	
	    table2DArray.forEach(function (tr) {
	      var seriesDatum = {
	        name: tr[0],
	        data: tr.slice(1)
	      };
	      chartData.series.push(seriesDatum);
	    });
	  }
	
	  return chartData;
	}
	
	/**
	 * Get pivoted second dimension array from table to use element.innerText
	 * @param {HTMLElement} tableElement - table element for extract chart's raw data
	 * @returns {Array.<Array>}
	 * @private
	 */
	function get2DArray(tableElement) {
	  var resultArray = [];
	
	  if (tableElement) {
	    var secondDimensionArray = [];
	    var trs = _tuiCodeSnippet2['default'].toArray(tableElement.getElementsByTagName('TR'));
	
	    _tuiCodeSnippet2['default'].forEach(trs, function (tr, index) {
	      var tagName = index === 0 ? 'TH' : 'TD';
	      var cells = _tuiCodeSnippet2['default'].toArray(tr.getElementsByTagName(tagName));
	      var rows = _tuiCodeSnippet2['default'].pluck(cells, 'innerText');
	
	      secondDimensionArray.push(rows);
	    });
	
	    if (secondDimensionArray[0].length < secondDimensionArray[1].length) {
	      secondDimensionArray[0].unshift('');
	    }
	
	    resultArray = _arrayUtil2['default'].pivot(secondDimensionArray);
	  }
	
	  return resultArray;
	}
	
	/**
	 * Make chart data with table element
	 * @param {({
	 *     elementId:string
	 * }|{
	 *     element:HTMLElement
	 * })} table - object for table data import
	 * @returns {rawData}
	 * @ignore
	 * @api
	 */
	function makeDataWithTable(table) {
	  var element = void 0;
	
	  if (table.element && table.element.tagName === 'TABLE') {
	    element = table.element;
	  } else if (table.elementId) {
	    element = document.getElementById(table.elementId);
	  }
	
	  var chartData = getChartDataFrom2DArray(get2DArray(element));
	
	  return chartData;
	}
	
	exports['default'] = {
	  makeDataWithTable: makeDataWithTable
	};

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	/**
	 * Get raphael paper
	 * @param {HTMLElement} container container element
	 * @param {{width:number, height:number}} dimension dimension
	 * @returns {object}
	 * @private
	 */
	
	/**
	 * Renderers
	 * @type {object}
	 * @ignore
	 */
	var renderers = {
	  DOM: function DOM(container) {
	    var paper = _domHandler2['default'].create('DIV');
	    _domHandler2['default'].append(container, paper);
	
	    return paper;
	  }
	};
	
	var DrawingToolPicker = function () {
	  function DrawingToolPicker() {
	    _classCallCheck(this, DrawingToolPicker);
	  }
	
	  /**
	   * DrawingToolPicker initializer
	   * @param {{width:number, height:number}} dimension dimension
	   * @ignore
	   */
	  DrawingToolPicker.prototype.initDimension = function initDimension(dimension) {
	    this.dimension = dimension;
	  };
	
	  /**
	   * Get drawing tool paper
	   * @param {HTMLElement} container container element
	   * @param {string} rendererType component renderer type
	   * @returns {HTMLElement|object}
	   * @ignore
	   */
	
	
	  DrawingToolPicker.prototype.getPaper = function getPaper(container, rendererType) {
	    var paper = this[rendererType + 'Paper'];
	    var isNeedCreateNewPaper = _tuiCodeSnippet2['default'].isExisty(container) && paper && _domHandler2['default'].findParentByClass(paper.canvas, 'tui-chart') !== container;
	
	    if (!paper || isNeedCreateNewPaper) {
	      paper = renderers[rendererType].call(this, container, this.dimension);
	
	      if (rendererType !== 'DOM') {
	        this[rendererType + 'Paper'] = paper;
	      }
	    }
	
	    return paper;
	  };
	
	  /**
	   * Add renderer type
	   * @param {string} componentType component renderer type
	   * @param {function} callback callback function for get renderer's paper
	   */
	
	
	  DrawingToolPicker.addRendererType = function addRendererType(componentType, callback) {
	    renderers[componentType] = callback;
	  };
	
	  return DrawingToolPicker;
	}();
	
	exports['default'] = DrawingToolPicker;

/***/ }),
/* 41 */
/***/ (function(module, exports) {

	'use strict';
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };
	
	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON
	// Any copyright is dedicated to the Public Domain. http://creativecommons.org/publicdomain/zero/1.0/
	if (!window.JSON) {
	  window.JSON = {
	    parse: function parse(sJSON) {
	      return eval('(' + sJSON + ')');
	    },
	    stringify: function () {
	      var toString = Object.prototype.toString;
	      var isArray = Array.isArray || function (a) {
	        return toString.call(a) === '[object Array]';
	      };
	      var escMap = {
	        '"': '\\"',
	        '\\': '\\\\',
	        '\b': '\\b',
	        '\f': '\\f',
	        '\n': '\\n',
	        '\r': '\\r',
	        '\t': '\\t'
	      };
	      var escFunc = function escFunc(m) {
	        return escMap[m] || '\\u' + (m.charCodeAt(0) + 0x10000).toString(16).substr(1);
	      };
	      var escRE = /[\\"\u0000-\u001F\u2028\u2029]/g;
	      return function stringify(value) {
	        if (value == null) {
	          return 'null';
	        } else if (typeof value === 'number') {
	          return isFinite(value) ? value.toString() : 'null';
	        } else if (typeof value === 'boolean') {
	          return value.toString();
	        } else if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
	          if (typeof value.toJSON === 'function') {
	            return stringify(value.toJSON());
	          } else if (isArray(value)) {
	            var res = '[';
	            for (var i = 0; i < value.length; i++) {
	              res += (i ? ', ' : '') + stringify(value[i]);
	            }return res + ']';
	          } else if (toString.call(value) === '[object Object]') {
	            var tmp = [];
	            for (var k in value) {
	              if (value.hasOwnProperty(k)) tmp.push(stringify(k) + ': ' + stringify(value[k]));
	            }
	            return '{' + tmp.join(', ') + '}';
	          }
	        }
	        return '"' + value.toString().replace(escRE, escFunc) + '"';
	      };
	    }()
	  };
	}
	
	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/create
	// Any copyright is dedicated to the Public Domain. http://creativecommons.org/publicdomain/zero/1.0/
	if (typeof Object.create != 'function') {
	  Object.create = function (undefined) {
	    var Temp = function Temp() {};
	    return function (prototype, propertiesObject) {
	      if (prototype !== Object(prototype) && prototype !== null) {
	        throw TypeError('Argument must be an object, or null');
	      }
	      Temp.prototype = prototype || {};
	      if (propertiesObject !== undefined) {
	        Object.defineProperties(Temp.prototype, propertiesObject);
	      }
	      var result = new Temp();
	      Temp.prototype = null;
	      // to imitate the case of Object.create(null)
	      if (prototype === null) {
	        result.__proto__ = null;
	      }
	      return result;
	    };
	  }();
	}
	
	// https://developer.mozilla.org/ko/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray
	// Any copyright is dedicated to the Public Domain. http://creativecommons.org/publicdomain/zero/1.0/
	if (!Array.isArray) {
	  Array.isArray = function (arg) {
	    return Object.prototype.toString.call(arg) === '[object Array]';
	  };
	}
	
	// http://paulirish.com/2011/requestanimationframe-for-smart-animating/
	// http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating
	// requestAnimationFrame polyfill by Erik Möller. fixes from Paul Irish and Tino Zijdel
	// MIT license
	
	(function () {
	  var lastTime = 0;
	  var vendors = ['ms', 'moz', 'webkit', 'o'];
	  for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
	    window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];
	    window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] || window[vendors[x] + 'CancelRequestAnimationFrame'];
	  }
	
	  if (!window.requestAnimationFrame) {
	    window.requestAnimationFrame = function (callback) {
	      var currTime = new Date().getTime();
	      var timeToCall = Math.max(0, 16 - (currTime - lastTime));
	      var id = window.setTimeout(function () {
	        callback(currTime + timeToCall);
	      }, timeToCall);
	      lastTime = currTime + timeToCall;
	      return id;
	    };
	  }
	
	  if (!window.cancelAnimationFrame) {
	    window.cancelAnimationFrame = function (id) {
	      clearTimeout(id);
	    };
	  }
	})();

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _chartFactory = __webpack_require__(32);
	
	var _chartFactory2 = _interopRequireDefault(_chartFactory);
	
	var _barChart = __webpack_require__(43);
	
	var _barChart2 = _interopRequireDefault(_barChart);
	
	var _columnChart = __webpack_require__(125);
	
	var _columnChart2 = _interopRequireDefault(_columnChart);
	
	var _lineChart = __webpack_require__(126);
	
	var _lineChart2 = _interopRequireDefault(_lineChart);
	
	var _areaChart = __webpack_require__(128);
	
	var _areaChart2 = _interopRequireDefault(_areaChart);
	
	var _columnLineComboChart = __webpack_require__(129);
	
	var _columnLineComboChart2 = _interopRequireDefault(_columnLineComboChart);
	
	var _lineScatterComboChart = __webpack_require__(131);
	
	var _lineScatterComboChart2 = _interopRequireDefault(_lineScatterComboChart);
	
	var _lineAreaComboChart = __webpack_require__(132);
	
	var _lineAreaComboChart2 = _interopRequireDefault(_lineAreaComboChart);
	
	var _pieDonutComboChart = __webpack_require__(133);
	
	var _pieDonutComboChart2 = _interopRequireDefault(_pieDonutComboChart);
	
	var _pieChart = __webpack_require__(134);
	
	var _pieChart2 = _interopRequireDefault(_pieChart);
	
	var _bubbleChart = __webpack_require__(135);
	
	var _bubbleChart2 = _interopRequireDefault(_bubbleChart);
	
	var _scatterChart = __webpack_require__(136);
	
	var _scatterChart2 = _interopRequireDefault(_scatterChart);
	
	var _heatmapChart = __webpack_require__(137);
	
	var _heatmapChart2 = _interopRequireDefault(_heatmapChart);
	
	var _treemapChart = __webpack_require__(140);
	
	var _treemapChart2 = _interopRequireDefault(_treemapChart);
	
	var _mapChart = __webpack_require__(141);
	
	var _mapChart2 = _interopRequireDefault(_mapChart);
	
	var _radialChart = __webpack_require__(144);
	
	var _radialChart2 = _interopRequireDefault(_radialChart);
	
	var _boxplotChart = __webpack_require__(145);
	
	var _boxplotChart2 = _interopRequireDefault(_boxplotChart);
	
	var _bulletChart = __webpack_require__(146);
	
	var _bulletChart2 = _interopRequireDefault(_bulletChart);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_BAR, _barChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_COLUMN, _columnChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_LINE, _lineChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_AREA, _areaChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_COLUMN_LINE_COMBO, _columnLineComboChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_LINE_SCATTER_COMBO, _lineScatterComboChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_LINE_AREA_COMBO, _lineAreaComboChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_PIE_DONUT_COMBO, _pieDonutComboChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_PIE, _pieChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_BUBBLE, _bubbleChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_SCATTER, _scatterChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_HEATMAP, _heatmapChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_TREEMAP, _treemapChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_MAP, _mapChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_RADIAL, _radialChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_BOXPLOT, _boxplotChart2['default']);
	_chartFactory2['default'].register(_const2['default'].CHART_TYPE_BULLET, _bulletChart2['default']);

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _chartBase = __webpack_require__(44);
	
	var _chartBase2 = _interopRequireDefault(_chartBase);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _rawDataHandler = __webpack_require__(33);
	
	var _rawDataHandler2 = _interopRequireDefault(_rawDataHandler);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Bar chart.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	/** Class representing a point. */
	var BarChart = function (_ChartBase) {
	  _inherits(BarChart, _ChartBase);
	
	  /**
	   * Bar chart.
	   * @constructs BarChart
	   * @extends ChartBase
	   * @mixes axisTypeMixer
	   * @param {Array.<Array>} rawData raw data
	   * @param {object} theme chart theme
	   * @param {object} options chart options
	   */
	  function BarChart(rawData, theme, options) {
	    _classCallCheck(this, BarChart);
	
	    _rawDataHandler2['default'].updateRawSeriesDataByOptions(rawData, options.series);
	
	    /**
	     * className
	     * @type {string}
	     */
	    var _this = _possibleConstructorReturn(this, _ChartBase.call(this, {
	      rawData: rawData,
	      theme: theme,
	      options: options,
	      hasAxes: true
	    }));
	
	    _this.className = 'tui-bar-chart';
	
	    _this._updateOptionsRelatedDiverging();
	    return _this;
	  }
	
	  /**
	   * Update options related diverging option.
	   * @private
	   */
	
	
	  BarChart.prototype._updateOptionsRelatedDiverging = function _updateOptionsRelatedDiverging() {
	    var options = this.options; // eslint-disable-line
	
	    options.series = options.series || {};
	    if (options.series.diverging) {
	      options.yAxis = options.yAxis || {};
	      options.xAxis = options.xAxis || {};
	      options.plot = options.plot || {};
	
	      options.series.stackType = options.series.stackType || _const2['default'].NORMAL_STACK_TYPE;
	
	      var isCenter = _predicate2['default'].isYAxisAlignCenter(this.hasRightYAxis, options.yAxis.align);
	
	      options.yAxis.isCenter = isCenter;
	      options.xAxis.divided = isCenter;
	      options.series.divided = isCenter;
	      options.plot.divided = isCenter;
	    }
	  };
	
	  /**
	   * Add components
	   * @override
	   */
	
	
	  BarChart.prototype.addComponents = function addComponents() {
	    this.componentManager.register('title', 'title');
	    this.componentManager.register('plot', 'plot');
	    this.componentManager.register('legend', 'legend');
	
	    this.componentManager.register('barSeries', 'barSeries');
	
	    this.componentManager.register('yAxis', 'axis');
	    this.componentManager.register('xAxis', 'axis');
	
	    if (this.hasRightYAxis) {
	      this.componentManager.register('rightYAxis', 'axis');
	    }
	
	    this.componentManager.register('chartExportMenu', 'chartExportMenu');
	    this.componentManager.register('tooltip', 'tooltip');
	    this.componentManager.register('mouseEventDetector', 'mouseEventDetector');
	  };
	
	  /**
	   * Get scale option.
	   * @returns {{xAxis: boolean}}
	   * @override
	   */
	
	
	  BarChart.prototype.getScaleOption = function getScaleOption() {
	    return {
	      xAxis: true
	    };
	  };
	
	  /**
	   * On change selected legend.
	   * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	   * @ignore
	   */
	
	
	  BarChart.prototype.onChangeCheckedLegends = function onChangeCheckedLegends(checkedLegends) {
	    var boundParams = void 0;
	
	    if (this.hasRightYAxis) {
	      boundParams = {
	        optionChartTypes: ['bar', 'bar']
	      };
	    }
	    _chartBase2['default'].prototype.onChangeCheckedLegends.call(this, checkedLegends, null, boundParams);
	  };
	
	  /**
	   * Add data ratios.
	   * modified from axisTypeMixer
	   * @override
	   */
	
	
	  BarChart.prototype.addDataRatios = function addDataRatios(limitMap) {
	    var _options$series = this.options.series,
	        seriesOption = _options$series === undefined ? {} : _options$series,
	        chartType = this.chartType;
	
	    var _ref = seriesOption[chartType] || seriesOption,
	        stackType = _ref.stackType;
	
	    this.dataProcessor.addDataRatios(limitMap[chartType], stackType, chartType);
	  };
	
	  return BarChart;
	}(_chartBase2['default']);
	
	exports['default'] = BarChart;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _componentManager = __webpack_require__(45);
	
	var _componentManager2 = _interopRequireDefault(_componentManager);
	
	var _dataProcessor = __webpack_require__(102);
	
	var _dataProcessor2 = _interopRequireDefault(_dataProcessor);
	
	var _rawDataHandler = __webpack_require__(33);
	
	var _rawDataHandler2 = _interopRequireDefault(_rawDataHandler);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _objectUtil = __webpack_require__(38);
	
	var _objectUtil2 = _interopRequireDefault(_objectUtil);
	
	var _boundsAndScaleBuilder = __webpack_require__(113);
	
	var _boundsAndScaleBuilder2 = _interopRequireDefault(_boundsAndScaleBuilder);
	
	var _themeManager = __webpack_require__(35);
	
	var _themeManager2 = _interopRequireDefault(_themeManager);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview ChartBase
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var GA_TRACKING_ID = 'UA-129983528-1';
	
	/** Class representing a point. */
	
	var ChartBase = function () {
	  /**
	   * Chart base.
	   * @constructs ChartBase
	   * @param {object} params parameters
	   *      @param {object} params.rawData raw data
	   *      @param {object} params.theme chart theme
	   *      @param {object} params.options chart options
	   *      @param {boolean} params.hasAxes whether has axes or not
	   *      @param {boolean} params.isVertical whether vertical or not
	   *      @param {DataProcessor} params.DataProcessor DataProcessor
	   */
	  function ChartBase(params) {
	    _classCallCheck(this, ChartBase);
	
	    /**
	     * theme
	     * @type {object}
	     * @ignore
	     */
	    this.theme = params.theme;
	
	    if (params.seriesTypes) {
	      this.seriesTypes = params.seriesTypes;
	    }
	
	    if (params.chartTypes) {
	      this.chartTypes = params.chartTypes;
	    }
	
	    /**
	     * chart original options
	     * @type {string}
	     * @ignore
	     */
	    this.originalOptions = _objectUtil2['default'].deepCopy(params.options);
	
	    this._initializeOptions(params.options);
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = this.options.chartType;
	
	    /**
	     * whether chart has axes or not
	     * @type {boolean}
	     * @ignore
	     */
	    this.hasAxes = params.hasAxes;
	
	    /**
	     * whether vertical or not
	     * @type {boolean}
	     * @ignore
	     */
	    this.isVertical = !!params.isVertical;
	
	    /**
	     * data processor
	     * @type {DataProcessor}
	     * @ignore
	     */
	    this.dataProcessor = this._createDataProcessor(params);
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     * @ignore
	     */
	    this.eventBus = new _tuiCodeSnippet2['default'].CustomEvents();
	
	    /**
	     * previous xAxis data
	     * @type {null|object}
	     * @ignore
	     */
	    this.prevXAxisData = null;
	
	    /**
	     * component manager
	     * @type {ComponentManager}
	     * @ignore
	     */
	    this.componentManager = this._createComponentManager();
	
	    /**
	     * Whether has right y axis or not.
	     * @type {boolean}
	     * @ignore
	     */
	    this.hasRightYAxis = _tuiCodeSnippet2['default'].isArray(this.options.yAxis) && this.options.yAxis.length > 1;
	
	    this.addComponents();
	
	    this._attachToEventBus();
	
	    this.componentManager.presetAnimationConfig(this.options.series.animation);
	
	    if (this.options.usageStatistics) {
	      _tuiCodeSnippet2['default'].sendHostname('chart', GA_TRACKING_ID);
	    }
	  }
	
	  /**
	   * Destroys the instance.
	   * @api
	   * @example
	   * chart.destroy();
	   */
	
	
	  ChartBase.prototype.destroy = function destroy() {
	    var _this = this;
	
	    this.eventBus.off();
	    this.chartContainer.outerHTML = '';
	    _tuiCodeSnippet2['default'].forEach(this, function (value, key) {
	      _this[key] = null;
	    });
	  };
	
	  /**
	   * get on select series function
	   * @param {{legendIndex: number, index: number}} indexInfo - selected indexes
	   * @param {?boolean} shouldSelect - whether should select or not
	   * @api
	   * @example
	   * chart.selectSeries({legendIndex: 0, index: 0}, true);
	   */
	
	
	  ChartBase.prototype.selectSeries = function selectSeries(_ref) {
	    var index = _ref.legendIndex,
	        groupIndex = _ref.index;
	    var shouldSelect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	
	    this.componentManager.get('mouseEventDetector').selectSeries({
	      chartType: this.chartType,
	      indexes: {
	        groupIndex: groupIndex,
	        index: index
	      }
	    }, shouldSelect);
	  };
	
	  /**
	   * get on deselect series function
	   * @api
	   * @example
	   * chart.unselectSeries();
	   */
	
	
	  ChartBase.prototype.unselectSeries = function unselectSeries() {
	    this.componentManager.get('mouseEventDetector').unselectSeries();
	  };
	
	  /**
	   * Attach to event bus.
	   * @private
	   */
	
	
	  ChartBase.prototype._attachToEventBus = function _attachToEventBus() {
	    this.eventBus.on('changeCheckedLegends', this.onChangeCheckedLegends, this);
	
	    if (this.onZoom) {
	      this.eventBus.on({
	        zoom: this.onZoom,
	        resetZoom: this.onResetZoom
	      }, this);
	    }
	  };
	
	  /**
	   * Set offset property
	   * @param {{offset: object}} options - options
	   * @param {string} fromProperty - from property name
	   * @param {string} toProperty - to property name
	   * @private
	   */
	
	
	  ChartBase.prototype._setOffsetProperty = function _setOffsetProperty(options, fromProperty, toProperty) {
	    if (!_tuiCodeSnippet2['default'].isExisty(options[fromProperty])) {
	      return;
	    }
	
	    options.offset = options.offset || {};
	    options.offset[toProperty] = options[fromProperty];
	    delete options[fromProperty];
	  };
	
	  /**
	   * Initialize offset.
	   * @param {{offsetX: ?number, offsetY: ?number}} options - offset options
	   * @private
	   */
	
	
	  ChartBase.prototype._initializeOffset = function _initializeOffset(options) {
	    if (!options) {
	      return;
	    }
	
	    this._setOffsetProperty(options, 'offsetX', 'x');
	    this._setOffsetProperty(options, 'offsetY', 'y');
	  };
	
	  /**
	   * Initialize title options.
	   * @param {
	   *      Array.<{title: (string | {text: string, offsetX: number, offsetY: number})}> |
	   *      {title: (string | {text: string, offsetX: number, offsetY: number})}
	   * } targetOptions - target options
	   * @private
	   */
	
	
	  ChartBase.prototype._initializeTitleOptions = function _initializeTitleOptions(targetOptions) {
	    var _this2 = this;
	
	    if (!targetOptions) {
	      return;
	    }
	
	    var optionsSet = _tuiCodeSnippet2['default'].isArray(targetOptions) ? targetOptions : [targetOptions];
	    optionsSet.forEach(function (options) {
	      var title = options.title;
	
	
	      if (_tuiCodeSnippet2['default'].isString(title)) {
	        options.title = {
	          text: title
	        };
	      }
	
	      _this2._initializeOffset(options.title);
	    });
	  };
	
	  /**
	   * Initialize tooltip options.
	   * @param {{grouped: ?boolean, offsetX: ?number, offsetY: ?number}} options - tooltip options
	   * @private
	   */
	
	
	  ChartBase.prototype._initializeTooltipOptions = function _initializeTooltipOptions(options) {
	    options.grouped = !!options.grouped;
	    this._initializeOffset(options);
	
	    delete options.position;
	  };
	
	  /**
	   * Initialize options.
	   * @param {object} options - options for chart
	   * @private
	   */
	
	
	  ChartBase.prototype._initializeOptions = function _initializeOptions(options) {
	    var originalOptions = _objectUtil2['default'].deepCopy(options);
	    var defaultOption = {
	      chartTypes: this.chartTypes,
	      xAxis: {},
	      series: {},
	      tooltip: {},
	      usageStatistics: true,
	      chartExportMenu: Object.assign({
	        visible: true
	      }, originalOptions.chartExportMenu),
	      legend: Object.assign({
	        visible: true
	      }, originalOptions.legend)
	    };
	    delete originalOptions.chartExportMenu;
	    delete originalOptions.legend;
	
	    Object.assign(options, defaultOption, originalOptions);
	
	    this._initializeTitleOptions(options.chart);
	    this._initializeTitleOptions(options.xAxis);
	    this._initializeTitleOptions(options.yAxis);
	    this._initializeTooltipOptions(options.tooltip);
	    this.options = options;
	  };
	
	  /**
	   * Create dataProcessor for processing raw data.
	   * @param {object} params parameters
	   *      @param {object} params.rawData - raw data
	   *      @param {DataProcessor} params.DataProcessor - DataProcessor class
	   *      @param {{chart: object, chartType: string}} params.options - chart options
	   *      @param {Array} params.seriesTypes series - chart types for rendering series
	   * @returns {object} data processor
	   * @private
	   */
	
	
	  ChartBase.prototype._createDataProcessor = function _createDataProcessor(params) {
	    var DataProcessor = params.DataProcessor || _dataProcessor2['default'];
	    var dataProcessor = new DataProcessor(params.rawData, this.chartType, params.options, this.seriesTypes);
	
	    return dataProcessor;
	  };
	
	  /**
	   * Create ComponentManager.
	   * @returns {ComponentManager}
	   * @private
	   */
	
	
	  ChartBase.prototype._createComponentManager = function _createComponentManager() {
	    return new _componentManager2['default']({
	      options: this.options,
	      theme: this.theme,
	      dataProcessor: this.dataProcessor,
	      hasAxes: this.hasAxes,
	      eventBus: this.eventBus,
	      isVertical: this.isVertical,
	      seriesTypes: this.seriesTypes || [this.chartType]
	    });
	  };
	
	  /**
	   * Add components.
	   * @abstract
	   * @ignore
	   */
	
	
	  ChartBase.prototype.addComponents = function addComponents() {};
	
	  /**
	   * Get scale option.
	   * @abstract
	   * @ignore
	   */
	
	
	  ChartBase.prototype.getScaleOption = function getScaleOption() {};
	
	  /**
	   * Build bounds and scale data.
	   * @param {object} prevXAxisData - previous xAxis data
	   * @param {boolean} addingDataMode - whether adding data mode or not
	   * @returns {{
	   *      layoutBounds: {
	   *          dimensionMap: {
	   *              xAxis: {width: number, height: number},
	   *              yAxis: {width: number, height: number},
	   *              rightYAxis: {width: number, height: number},
	   *              series: {width: number, height: number},
	   *              extendedSeries: {width: number, height: number},
	   *              mouseEventDetector: {width: number, height: number},
	   *              legend: {width: number, height: number},
	   *              tooltip: {width: number, height: number}
	   *          },
	   *          positionMap: {
	   *              xAxis: {left: number, top: number},
	   *              yAxis: {left: number, top: number},
	   *              rightYAxis: {left: number, top: number},
	   *              series: {left: number, top: number},
	   *              extendedSeries: {left: number, top: number},
	   *              mouseEventDetector: {left: number, top: number},
	   *              legend: {left: number, top: number},
	   *              tooltip: {left: number, top: number}
	   *          }
	   *      },
	   *      limitMap: {
	   *          xAxis: {min: number, max: number},
	   *          yAxis: {min: number, max: number}
	   *      },
	   *      axisDataMap: {
	   *          xAxis: object,
	   *          yAxis: object,
	   *          yRightAxis: object
	   *      },
	   *      maxRadius: ?number
	   * }}
	   * @private
	   */
	
	
	  ChartBase.prototype._buildBoundsAndScaleData = function _buildBoundsAndScaleData(prevXAxisData, addingDataMode) {
	    return _boundsAndScaleBuilder2['default'].build(this.dataProcessor, this.componentManager, {
	      chartType: this.chartType,
	      seriesTypes: this.seriesTypes,
	      options: this.options,
	      theme: this.theme,
	      hasAxes: this.hasAxes,
	      scaleOption: this.getScaleOption(),
	      isVertical: this.isVertical,
	      hasRightYAxis: this.hasRightYAxis,
	      addedDataCount: this._dynamicDataHelper ? this._dynamicDataHelper.addedDataCount : null,
	      prevXAxisData: prevXAxisData,
	      addingDataMode: addingDataMode
	    });
	  };
	
	  /**
	   * Add data ratios.
	   * @abstract
	   * @ignore
	   */
	
	
	  ChartBase.prototype.addDataRatios = function addDataRatios() {};
	
	  /**
	   * Make chart ready for render, it should be invoked before render, rerender, resize and zoom.
	   * @param {?boolean} addingDataMode - whether adding data mode or not
	   * @returns {object} Bounds and scale data
	   * @ignore
	   */
	
	
	  ChartBase.prototype.readyForRender = function readyForRender(addingDataMode) {
	    var boundsAndScale = this._buildBoundsAndScaleData(this.prevXAxisData, addingDataMode);
	
	    if (boundsAndScale.axisDataMap.xAxis) {
	      this.prevXAxisData = boundsAndScale.axisDataMap.xAxis;
	    }
	
	    this.addDataRatios(boundsAndScale.limitMap);
	
	    return boundsAndScale;
	  };
	
	  /**
	   * Render chart.
	   * @param {HTMLElement} wrapper chart wrapper element
	   * @ignore
	   */
	
	
	  ChartBase.prototype.render = function render(wrapper) {
	    var container = _domHandler2['default'].create('DIV', 'tui-chart ' + this.className);
	    var componentManager = this.componentManager,
	        dataProcessor = this.dataProcessor;
	
	    var seriesVisibilityMap = dataProcessor.getLegendVisibility();
	    var rawData = _rawDataHandler2['default'].filterCheckedRawData(dataProcessor.rawData, seriesVisibilityMap);
	    var raphaelPaper = componentManager.drawingToolPicker.getPaper(container, _const2['default'].COMPONENT_TYPE_RAPHAEL);
	
	    this.dataProcessor.initData(rawData);
	
	    raphaelPaper.changeChartBackgroundColor(this.theme.chart.background.color);
	    raphaelPaper.changeChartBackgroundOpacity(this.theme.chart.background.opacity);
	    _renderUtil2['default'].renderFontFamily(container, this.theme.chart.fontFamily);
	
	    _domHandler2['default'].append(wrapper, container);
	
	    var boundsAndScale = this.readyForRender();
	
	    _renderUtil2['default'].renderDimension(container, boundsAndScale.dimensionMap.chart);
	    componentManager.render('render', boundsAndScale, {
	      checkedLegends: seriesVisibilityMap
	    }, container);
	    this.chartContainer = container;
	    this.paper = raphaelPaper;
	  };
	
	  /**
	   * protectedRerender
	   * @param {{line: Array.<boolean>, column: Array.<boolean>}} checkedLegends checked legends
	   * @param {?object} rawData rawData
	   * @ignore
	   */
	
	
	  ChartBase.prototype.protectedRerender = function protectedRerender(checkedLegends, rawData) {
	    var dataProcessor = this.dataProcessor;
	
	
	    if (!rawData) {
	      rawData = _rawDataHandler2['default'].filterCheckedRawData(dataProcessor.getCurrentData(), checkedLegends);
	    }
	
	    this.dataProcessor.initData(rawData);
	
	    var boundsAndScale = this.readyForRender();
	
	    this.componentManager.render('rerender', boundsAndScale, { checkedLegends: checkedLegends }, this.chartContainer);
	  };
	
	  /**
	   * rerender
	   * @param {{column: Array.<string>, line: Array.<string>}} checkedLegends data that whether series has checked or not
	   * @param {object} rawData rawData
	   * @api
	   * @deprecated
	   */
	
	
	  ChartBase.prototype.rerender = function rerender(checkedLegends, rawData) {
	    checkedLegends = checkedLegends || this.getCheckedLegend();
	    rawData = rawData || this.dataProcessor.getOriginalRawData();
	
	    var seriesData = rawData.series;
	
	    rawData.series = Object.keys(seriesData).reduce(function (result, item) {
	      var series = seriesData[item];
	      var checkedInfo = checkedLegends[item];
	
	      result[item] = series.map(function (seriesItem, index) {
	        seriesItem.visible = checkedInfo[index];
	
	        return seriesItem;
	      });
	
	      return result;
	    }, {});
	
	    this.setData(rawData);
	  };
	
	  /**
	   * setData
	   * @param {object} rawData rawData
	   * @param {boolean | object} animation whether animate or not, duration
	   * @api
	   */
	
	
	  ChartBase.prototype.setData = function setData() {
	    var rawData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
	    var animation = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	
	    var data = this._initializeRawData(rawData);
	    var dataProcessor = this.dataProcessor;
	    var _options = this.options,
	        chartType = _options.chartType,
	        themeOptions = _options.theme;
	
	
	    dataProcessor.initData(data, true);
	
	    var theme = _themeManager2['default'].get(themeOptions, chartType, data.series);
	
	    this.theme = theme;
	    this.componentManager.presetBeforeRerender();
	    this.componentManager.presetForChangeData(theme);
	    this.componentManager.presetAnimationConfig(animation);
	    this.protectedRerender(dataProcessor.getLegendVisibility());
	  };
	
	  /**
	   * Get checked indexes.
	   * @returns {{column: ?Array.<string>, line: ?Array.<string>}} object data that whether series has checked or not
	   * @api
	   */
	
	
	  ChartBase.prototype.getCheckedLegend = function getCheckedLegend() {
	    var componentManager = this.componentManager,
	        dataProcessor = this.dataProcessor;
	
	    var hasLegendComponent = componentManager.has('legend');
	
	    return hasLegendComponent ? componentManager.get('legend').getCheckedIndexes() : dataProcessor.getLegendVisibility();
	  };
	
	  /**
	   * initialize rawData
	   * @param {object} rawData rawData
	   * @returns {object} - remaked rawData
	   * @private
	   */
	
	
	  ChartBase.prototype._initializeRawData = function _initializeRawData(rawData) {
	    var data = _objectUtil2['default'].deepCopy(rawData);
	    var _originalOptions = this.originalOptions,
	        chartType = _originalOptions.chartType,
	        seriesOption = _originalOptions.series;
	
	
	    if (chartType !== 'combo' && _tuiCodeSnippet2['default'].isArray(data.series)) {
	      var clonedSeries = data.series;
	      data.series = {};
	      data.series[chartType] = clonedSeries;
	    }
	
	    _rawDataHandler2['default'].updateRawSeriesDataByOptions(data, seriesOption);
	
	    if (chartType === 'boxplot') {
	      _rawDataHandler2['default'].appendOutliersToSeriesData(data);
	    }
	
	    return data;
	  };
	
	  /**
	   * On change checked legend.
	   * @param {Array.<?boolean> | {line: ?Array.<boolean>, column: ?Array.<boolean>}} checkedLegends checked legends
	   * @param {?object} rawData rawData
	   * @param {?object} boundsParams addition params for calculating bounds
	   * @ignore
	   */
	
	
	  ChartBase.prototype.onChangeCheckedLegends = function onChangeCheckedLegends(checkedLegends, rawData, boundsParams) {
	    this.protectedRerender(checkedLegends, rawData, boundsParams);
	  };
	
	  /**
	   * Animate chart.
	   * @ignore
	   */
	
	
	  ChartBase.prototype.animateChart = function animateChart() {
	    this.componentManager.execute('animateComponent');
	  };
	
	  /**
	   * Register of user event.
	   * @param {string} eventName event name
	   * @param {function} func event callback
	   * @api
	   */
	
	
	  ChartBase.prototype.on = function on(eventName, func) {
	    /**
	     * Select legend event
	     * @event ChartBase#selectLegend
	     * @param {object} info selected legend info
	     *   @param {string} legend legend name
	     *   @param {string} chartType chart type
	     *   @param {number} index selected legend index
	     * @api
	     * @example
	     * chart.on('selectLegend', function(info) {
	     *     console.log(info);
	     * });
	     */
	
	    /**
	     * Select series event
	     * @event ChartBase#selectSeries
	     * @param {object} info selected series info
	     *   @param {string} legend legend name
	     *   @param {string} chartType chart type
	     *   @param {number} legendIndex selected legend index
	     *   @param {number} index selected category index
	     * @api
	     * @example
	     * chart.on('selectSeries', function(info) {
	     *     console.log(info);
	     * });
	     */
	
	    /**
	     * unselect series event
	     * @event ChartBase#unselectSeries
	     * @param {object} info unselected series info
	     *   @param {string} legend legend name
	     *   @param {string} chartType chart type
	     *   @param {number} legendIndex selected legend index
	     *   @param {number} index selected category index
	     * @api
	     * @example
	     * chart.on('unselectSeries', function(info) {
	     *     console.log(info);
	     * });
	     */
	
	    /**
	     * before show tooltip event
	     * @event ChartBase#beforeShowTooltip
	     * @param {object} info target series info
	     *   @param {string} legend legend name
	     *   @param {string} chartType chart type
	     *   @param {number} legendIndex target legend index
	     *   @param {number} index target category index
	     * @api
	     * @example
	     * chart.on('beforeShowTooltip', function(info) {
	     * });
	     */
	
	    /**
	     * after show tooltip event
	     * @event ChartBase#afterShowTooltip
	     * @param {object} info target series info
	     *   @param {string} legend legend name
	     *   @param {string} chartType chart type
	     *   @param {number} legendIndex target legend index
	     *   @param {number} index target category index
	     *   @param {HTMLElement} element tooltip element
	     *   @param {object} position tooltip position
	     *     @param {number} left tooltip left position
	     *     @param {number} top tooltip left position
	     * @api
	     * @example
	     * chart.on('afterShowTooltip', function(info) {
	     *    console.log(info);
	     * });
	     */
	
	    /**
	     * before hide tooltip event
	     * @event ChartBase#beforeHideTooltip
	     * @api
	     * @example
	     * chart.on('beforeHideTooltip', function() {
	     *     // Create a task at the time of the event.
	     * });
	     */
	
	    /**
	     * change checked legend event
	     * @event ChartBase#changeCheckedLegends
	     * @param {object.<string, array>} info `checked` information that matches the chart type.
	     * @api
	     * @example
	     * chart.on('changeCheckedLegends', function(info) {
	     *    console.log(info);
	     * });
	     */
	
	    /**
	     * Register of user event.
	     * @event MapChart#zoom
	     * @param {string} magnification zoom ratio
	     * @api
	     * @example
	     * chart.on('zoom', function(magnification) {
	     *    console.log(magnification);
	     * });
	     */
	
	    if (_const2['default'].PUBLIC_EVENT_MAP[eventName]) {
	      this.eventBus.on(_const2['default'].PUBLIC_EVENT_PREFIX + eventName, func);
	    }
	  };
	
	  /**
	   * Remove user event.
	   * @param {string} eventName event name
	   * @param {function} func event callback
	   * @ignore
	   */
	
	
	  ChartBase.prototype.off = function off(eventName, func) {
	    if (_const2['default'].PUBLIC_EVENT_MAP[eventName]) {
	      this.eventBus.off(_const2['default'].PUBLIC_EVENT_PREFIX + eventName, func);
	    }
	  };
	
	  /**
	   * Update dimension of chart.
	   * @param {{width: number, height: number}} dimension dimension
	   * @returns {boolean} whether updated or not
	   * @private
	   */
	
	
	  ChartBase.prototype._updateChartDimension = function _updateChartDimension(dimension) {
	    var updated = false;
	    var options = this.options;
	
	
	    options.chart = options.chart || {};
	
	    if (dimension.width && dimension.width > 0 && options.chart.width !== dimension.width) {
	      options.chart.width = dimension.width;
	      updated = true;
	    }
	
	    if (dimension.height && dimension.height > 0 && options.chart.height !== dimension.height) {
	      options.chart.height = dimension.height;
	      updated = true;
	    }
	
	    return updated;
	  };
	
	  /**
	   * Public API for resizable.
	   * @param {object} dimension dimension
	   *      @param {number} dimension.width width
	   *      @param {number} dimension.height height
	   * @api
	   */
	
	
	  ChartBase.prototype.resize = function resize(dimension) {
	    var dataProcessor = this.dataProcessor;
	
	    var seriesVisibilityMap = dataProcessor.getLegendVisibility();
	
	    if (!dimension) {
	      return;
	    }
	
	    var updated = this._updateChartDimension(dimension);
	
	    if (!updated) {
	      return;
	    }
	
	    var boundsAndScale = this.readyForRender();
	    var chartDimension = boundsAndScale.dimensionMap.chart;
	
	    _renderUtil2['default'].renderDimension(this.chartContainer, chartDimension);
	    this.paper.resizeBackground(chartDimension.width, chartDimension.height);
	    this.paper.setSize(chartDimension.width, chartDimension.height);
	
	    this.componentManager.render('resize', boundsAndScale, {
	      checkedLegends: seriesVisibilityMap
	    });
	  };
	
	  /**
	   * Set tooltip align option.
	   * @param {string} align align (left|center|right, top|middle|bottom)
	   * @api
	   */
	
	
	  ChartBase.prototype.setTooltipAlign = function setTooltipAlign(align) {
	    this.componentManager.get('tooltip').setAlign(align);
	  };
	
	  /**
	   * Set tooltip offset option.
	   * @param {object} offset - tooltip offset
	   *      @param {number} offset.x - offset x
	   *      @param {number} offset.y - offset y
	   * @api
	   */
	
	
	  ChartBase.prototype.setTooltipOffset = function setTooltipOffset(offset) {
	    this.componentManager.get('tooltip').setOffset(offset);
	  };
	
	  /**
	   * Set position option.
	   * @param {object} position moving position
	   *      @param {number} position.left left
	   *      @param {number} position.top top
	   * @api
	   * @deprecated
	   */
	
	
	  ChartBase.prototype.setTooltipPosition = function setTooltipPosition(position) {
	    this.componentManager.get('tooltip').setPosition(position);
	  };
	
	  /**
	   * Reset tooltip align option.
	   * @api
	   */
	
	
	  ChartBase.prototype.resetTooltipAlign = function resetTooltipAlign() {
	    this.componentManager.get('tooltip').resetAlign();
	  };
	
	  /**
	   * Reset tooltip position.
	   * @api
	   */
	
	
	  ChartBase.prototype.resetTooltipOffset = function resetTooltipOffset() {
	    this.componentManager.get('tooltip').resetOffset();
	  };
	
	  /**
	   * Reset tooltip position.
	   * @api
	   * @deprecated
	   */
	
	
	  ChartBase.prototype.resetTooltipPosition = function resetTooltipPosition() {
	    this.resetTooltipOffset();
	  };
	
	  /**
	   * Show series label.
	   * @api
	   */
	
	
	  ChartBase.prototype.showSeriesLabel = function showSeriesLabel() {
	    var seriesSet = this.componentManager.where({ componentType: 'series' });
	
	    seriesSet.forEach(function (series) {
	      series.showLabel();
	    });
	  };
	
	  /**
	   * Hide series label.
	   * @api
	   */
	
	
	  ChartBase.prototype.hideSeriesLabel = function hideSeriesLabel() {
	    var seriesSet = this.componentManager.where({ componentType: 'series' });
	
	    seriesSet.forEach(function (series) {
	      series.hideLabel();
	    });
	  };
	
	  /**
	   * Add data.
	   * @abstract
	   */
	
	
	  ChartBase.prototype.addData = function addData() {};
	
	  /**
	   * Add plot line.
	   * @abstract
	   */
	
	
	  ChartBase.prototype.addPlotLine = function addPlotLine() {};
	
	  /**
	   * Add plot band.
	   * @abstract
	   */
	
	
	  ChartBase.prototype.addPlotBand = function addPlotBand() {};
	
	  /**
	   * Remove plot line.
	   * @abstract
	   */
	
	
	  ChartBase.prototype.removePlotLine = function removePlotLine() {};
	
	  /**
	   * Remove plot band.
	   * @abstract
	   */
	
	
	  ChartBase.prototype.removePlotBand = function removePlotBand() {};
	
	  /**
	   * Get series item bound by indexes
	   * @param {number} index - tooltip data's category index
	   * @param {number} seriesIndex - tooltip data's series index
	   * @param {number} [outlierIndex] - outlier index of tooltip, exists only hovered on boxplot chart's outlier point
	   *
	   * @returns {?object} - series item bound
	   * @private
	   */
	
	
	  ChartBase.prototype._getSeriesData = function _getSeriesData(index, seriesIndex, outlierIndex) {
	    var indexes = {
	      index: index,
	      seriesIndex: seriesIndex,
	      outlierIndex: outlierIndex
	    };
	
	    if (seriesIndex < 0) {
	      return null;
	    }
	
	    return this.componentManager.get('mouseEventDetector').findDataByIndexes(indexes);
	  };
	
	  /**
	   * find series index by legend label
	   * @param {string} chartType - chart tyoe
	   * @param {string} legendLabel - legend label
	   * @returns {number} - if not found return -1, else return found series index
	   * @private
	   */
	
	
	  ChartBase.prototype._findSeriesIndexByLabel = function _findSeriesIndexByLabel(chartType, legendLabel) {
	    var labels = this.dataProcessor.getLegendLabels(chartType);
	    var len = labels ? labels.length : 0;
	    var seriesIndex = -1;
	
	    for (var i = 0; i < len; i += 1) {
	      if (labels[i] === legendLabel) {
	        seriesIndex = i;
	        break;
	      }
	    }
	
	    return seriesIndex;
	  };
	
	  /**
	   * @param {number} index - category index
	   * @param {number} seriesIndex - series index
	   * @returns {object}
	   * @private
	   */
	
	
	  ChartBase.prototype._findDataByIndexes = function _findDataByIndexes(index, seriesIndex) {
	    return this.componentManager.get('mouseEventDetector').findDataByIndexes(index, seriesIndex);
	  };
	
	  /**
	   * show tooltip by index of series item
	   * @param {object} params - data needed for making a tooltip
	   * @ignore
	   */
	
	
	  ChartBase.prototype.showTooltip = function showTooltip(params) {
	    var foundSeriesIndex = void 0,
	        foundData = void 0;
	
	    if (!_predicate2['default'].isSupportPublicShowTooptipAPI(this.chartType)) {
	      return;
	    }
	
	    var isGroupTooltip = this.options.tooltip && this.options.tooltip.grouped;
	    var mouseEventDetector = this.componentManager.get('mouseEventDetector');
	
	    if (isGroupTooltip) {
	      foundData = { indexes: { groupIndex: params.index } };
	    } else {
	      foundSeriesIndex = this._findSeriesIndexByLabel(params.chartType, params.legend);
	      foundData = this._getSeriesData(params.index, foundSeriesIndex, params.outlierIndex);
	    }
	
	    if (foundData) {
	      foundData.silent = true;
	      mouseEventDetector._showTooltip(foundData);
	    } else {
	      this.hideTooltip();
	    }
	  };
	
	  /**
	   * hide tooltip
	   * @ignore
	   */
	
	
	  ChartBase.prototype.hideTooltip = function hideTooltip() {
	    if (!_predicate2['default'].isSupportPublicShowTooptipAPI(this.chartType)) {
	      return;
	    }
	
	    var isGroupTooltip = this.options.tooltip && this.options.tooltip.grouped;
	    var mouseEventDetector = this.componentManager.get('mouseEventDetector');
	
	    if (isGroupTooltip && mouseEventDetector.prevIndex >= 0 || !isGroupTooltip && mouseEventDetector.prevFoundData) {
	      mouseEventDetector._hideTooltip({ silent: true });
	    }
	  };
	
	  return ChartBase;
	}();
	
	exports['default'] = ChartBase;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _axis = __webpack_require__(46);
	
	var _axis2 = _interopRequireDefault(_axis);
	
	var _plot = __webpack_require__(47);
	
	var _plot2 = _interopRequireDefault(_plot);
	
	var _title = __webpack_require__(48);
	
	var _title2 = _interopRequireDefault(_title);
	
	var _radialPlot = __webpack_require__(49);
	
	var _radialPlot2 = _interopRequireDefault(_radialPlot);
	
	var _chartExportMenu = __webpack_require__(51);
	
	var _chartExportMenu2 = _interopRequireDefault(_chartExportMenu);
	
	var _drawingToolPicker = __webpack_require__(40);
	
	var _drawingToolPicker2 = _interopRequireDefault(_drawingToolPicker);
	
	var _legend = __webpack_require__(57);
	
	var _legend2 = _interopRequireDefault(_legend);
	
	var _spectrumLegend = __webpack_require__(59);
	
	var _spectrumLegend2 = _interopRequireDefault(_spectrumLegend);
	
	var _circleLegend = __webpack_require__(60);
	
	var _circleLegend2 = _interopRequireDefault(_circleLegend);
	
	var _tooltip = __webpack_require__(61);
	
	var _tooltip2 = _interopRequireDefault(_tooltip);
	
	var _groupTooltip = __webpack_require__(67);
	
	var _groupTooltip2 = _interopRequireDefault(_groupTooltip);
	
	var _mapChartTooltip = __webpack_require__(69);
	
	var _mapChartTooltip2 = _interopRequireDefault(_mapChartTooltip);
	
	var _mapChartEventDetector = __webpack_require__(70);
	
	var _mapChartEventDetector2 = _interopRequireDefault(_mapChartEventDetector);
	
	var _mouseEventDetector = __webpack_require__(74);
	
	var _mouseEventDetector2 = _interopRequireDefault(_mouseEventDetector);
	
	var _barChartSeries = __webpack_require__(81);
	
	var _barChartSeries2 = _interopRequireDefault(_barChartSeries);
	
	var _columnChartSeries = __webpack_require__(85);
	
	var _columnChartSeries2 = _interopRequireDefault(_columnChartSeries);
	
	var _lineChartSeries = __webpack_require__(86);
	
	var _lineChartSeries2 = _interopRequireDefault(_lineChartSeries);
	
	var _radialSeries = __webpack_require__(88);
	
	var _radialSeries2 = _interopRequireDefault(_radialSeries);
	
	var _areaChartSeries = __webpack_require__(89);
	
	var _areaChartSeries2 = _interopRequireDefault(_areaChartSeries);
	
	var _bubbleChartSeries = __webpack_require__(90);
	
	var _bubbleChartSeries2 = _interopRequireDefault(_bubbleChartSeries);
	
	var _scatterChartSeries = __webpack_require__(92);
	
	var _scatterChartSeries2 = _interopRequireDefault(_scatterChartSeries);
	
	var _mapChartSeries = __webpack_require__(93);
	
	var _mapChartSeries2 = _interopRequireDefault(_mapChartSeries);
	
	var _pieChartSeries = __webpack_require__(94);
	
	var _pieChartSeries2 = _interopRequireDefault(_pieChartSeries);
	
	var _heatmapChartSeries = __webpack_require__(95);
	
	var _heatmapChartSeries2 = _interopRequireDefault(_heatmapChartSeries);
	
	var _treemapChartSeries = __webpack_require__(96);
	
	var _treemapChartSeries2 = _interopRequireDefault(_treemapChartSeries);
	
	var _boxPlotChartSeries = __webpack_require__(98);
	
	var _boxPlotChartSeries2 = _interopRequireDefault(_boxPlotChartSeries);
	
	var _bulletChartSeries = __webpack_require__(99);
	
	var _bulletChartSeries2 = _interopRequireDefault(_bulletChartSeries);
	
	var _zoom = __webpack_require__(100);
	
	var _zoom2 = _interopRequireDefault(_zoom);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview ComponentManager manages components of chart.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	// legends
	
	
	// tooltips
	
	
	// mouse event detectors
	
	
	// series
	
	
	var COMPONENT_FACTORY_MAP = {
	  axis: _axis2['default'],
	  plot: _plot2['default'],
	  radialPlot: _radialPlot2['default'],
	  legend: _legend2['default'],
	  spectrumLegend: _spectrumLegend2['default'],
	  circleLegend: _circleLegend2['default'],
	  tooltip: _tooltip2['default'],
	  groupTooltip: _groupTooltip2['default'],
	  mapChartTooltip: _mapChartTooltip2['default'],
	  mapChartEventDetector: _mapChartEventDetector2['default'],
	  mouseEventDetector: _mouseEventDetector2['default'],
	  barSeries: _barChartSeries2['default'],
	  columnSeries: _columnChartSeries2['default'],
	  lineSeries: _lineChartSeries2['default'],
	  radialSeries: _radialSeries2['default'],
	  areaSeries: _areaChartSeries2['default'],
	  bubbleSeries: _bubbleChartSeries2['default'],
	  scatterSeries: _scatterChartSeries2['default'],
	  mapSeries: _mapChartSeries2['default'],
	  pieSeries: _pieChartSeries2['default'],
	  heatmapSeries: _heatmapChartSeries2['default'],
	  treemapSeries: _treemapChartSeries2['default'],
	  boxplotSeries: _boxPlotChartSeries2['default'],
	  bulletSeries: _bulletChartSeries2['default'],
	  zoom: _zoom2['default'],
	  chartExportMenu: _chartExportMenu2['default'],
	  title: _title2['default']
	};
	
	var ComponentManager = function () {
	  /**
	   * ComponentManager manages components of chart.
	   * @param {object} params parameters
	   *      @param {object} params.theme - theme
	   *      @param {object} params.options - options
	   *      @param {DataProcessor} params.dataProcessor - data processor
	   *      @param {boolean} params.hasAxes - whether has axes or not
	   * @constructs ComponentManager
	   * @private
	   */
	  function ComponentManager(params) {
	    _classCallCheck(this, ComponentManager);
	
	    var chartOption = params.options.chart;
	    var width = _tuiCodeSnippet2['default'].pick(chartOption, 'width') || _const2['default'].CHART_DEFAULT_WIDTH;
	    var height = _tuiCodeSnippet2['default'].pick(chartOption, 'height') || _const2['default'].CHART_DEFAULT_HEIGHT;
	
	    /**
	     * Components
	     * @type {Array.<object>}
	     */
	    this.components = [];
	
	    /**
	     * componentFactory map.
	     * @type {object}
	     */
	    this.componentMap = {};
	
	    /**
	     * theme
	     * @type {object}
	     */
	    this.theme = params.theme || {};
	
	    /**
	     * options
	     * @type {object}
	     */
	    this.options = params.options || {};
	
	    /**
	     * data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * whether chart has axes or not
	     * @type {boolean}
	     */
	    this.hasAxes = params.hasAxes;
	
	    /**
	     * whether chart is vertical or not
	     * @type {boolean}
	     */
	    this.isVertical = params.isVertical;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = params.eventBus;
	
	    /**
	     * Drawing tool picker
	     * @type {object}
	     */
	    this.drawingToolPicker = new _drawingToolPicker2['default']();
	
	    this.drawingToolPicker.initDimension({
	      width: width,
	      height: height
	    });
	
	    /**
	     * seriesTypes of chart
	     * @type {Array.<string>}
	     */
	    this.seriesTypes = params.seriesTypes;
	  }
	
	  /**
	   * Make component options.
	   * @param {object} options options
	   * @param {string} optionKey component option key
	   * @param {string} componentName component name
	   * @param {number} index component index
	   * @returns {object} options
	   * @private
	   */
	
	
	  ComponentManager.prototype._makeComponentOptions = function _makeComponentOptions(options, optionKey, componentName, index) {
	    options = options || this.options[optionKey];
	    options = _tuiCodeSnippet2['default'].isArray(options) ? options[index] : options || {};
	
	    return options;
	  };
	
	  /**
	   * Register component.
	   * The component refers to a component of the chart.
	   * The component types are axis, legend, plot, series and mouseEventDetector.
	   * Chart Component Description : https://i-msdn.sec.s-msft.com/dynimg/IC267997.gif
	   * @param {string} name component name
	   * @param {string} classType component factory name
	   * @param {object} [params={}] optional params that for alternative charts
	   * @ignore
	   */
	
	
	  ComponentManager.prototype.register = function register(name, classType) {
	    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	
	    var index = params.index || 0;
	    var componentFactory = COMPONENT_FACTORY_MAP[classType];
	    var componentType = componentFactory.componentType;
	
	
	    params.name = name;
	    params.chartTheme = this.theme;
	    params.chartOptions = this.options;
	    params.seriesTypes = this.seriesTypes;
	
	    var optionKey = this._getOptionKey(componentType, name);
	
	    params.theme = this._makeTheme(optionKey, name);
	    params.options = this._makeOptions(optionKey, name, index);
	
	    params.dataProcessor = this.dataProcessor;
	    params.hasAxes = this.hasAxes;
	    params.isVertical = this.isVertical;
	    params.eventBus = this.eventBus;
	
	    // alternative scale models for charts that do not use common scale models like maps
	    params.alternativeModel = this.alternativeModel;
	
	    var component = componentFactory(params);
	
	    // component creation can be refused by factory, according to option data
	    if (component) {
	      component.componentName = name;
	      component.componentType = componentType;
	
	      this.components.push(component);
	      this.componentMap[name] = component;
	    }
	  };
	
	  /**
	   * Preset before rerender
	   * This method is eliminating zoom buttons and tooltips, so only works with zoom supported charts.
	   */
	
	
	  ComponentManager.prototype.presetBeforeRerender = function presetBeforeRerender() {
	    if (this.componentMap.mouseEventDetector.zoomable) {
	      this.componentMap.mouseEventDetector.presetBeforeRerender();
	    }
	  };
	
	  /**
	   * Preset components for setData
	   * @param {object} theme theme object
	   * @ignore
	   */
	
	
	  ComponentManager.prototype.presetForChangeData = function presetForChangeData(theme) {
	    var _this = this;
	
	    this.theme = theme;
	    this.components.forEach(function (component) {
	      if (component.presetForChangeData) {
	        var componentType = component.componentType,
	            componentName = component.componentName;
	
	        var optionKey = _this._getOptionKey(componentType, componentName);
	
	        component.presetForChangeData(_this._makeTheme(optionKey, componentName));
	      }
	    });
	  };
	
	  /**
	   * apply animation config before setData
	   * @param {boolean | object} animation whether animate or not, duration
	   * @ignore
	   */
	
	
	  ComponentManager.prototype.presetAnimationConfig = function presetAnimationConfig(animation) {
	    var _this2 = this;
	
	    this.seriesTypes.forEach(function (seriesType) {
	      if (_tuiCodeSnippet2['default'].isObject(_this2.options.series[seriesType])) {
	        // For combo chart, options are set for each chart
	        _this2.options.series[seriesType].animationDuration = _this2._getAnimationDuration(animation);
	      } else {
	        _this2.options.series.animationDuration = _this2._getAnimationDuration(animation);
	      }
	    });
	  };
	
	  /**
	   * get default animation duration
	   * @param {object | boolean} [animation] - animation options
	   * @returns {number} duration - series rendering animation duration
	   * @private
	   */
	
	
	  ComponentManager.prototype._getAnimationDuration = function _getAnimationDuration(animation) {
	    if (_tuiCodeSnippet2['default'].isBoolean(animation) && !animation) {
	      return 0;
	    }
	
	    if (_tuiCodeSnippet2['default'].isObject(animation) && _tuiCodeSnippet2['default'].isNumber(animation.duration)) {
	      return animation.duration;
	    }
	
	    return _raphaelRenderUtil2['default'].getDefaultAnimationDuration(this.options.chartType);
	  };
	
	  /**
	   * Make option
	   * @param {string} optionKey Key on which to create the option.
	   * @param {string} name name of component
	   * @param {number} index index of chart for series option
	   * @returns {object} option
	   * @private
	   */
	
	
	  ComponentManager.prototype._makeOptions = function _makeOptions(optionKey, name, index) {
	    var options = this.options[optionKey];
	
	    if (!options && optionKey === 'rightYAxis') {
	      options = this.options.yAxis;
	    }
	
	    if (optionKey === 'series') {
	      this.seriesTypes.forEach(function (seriesType) {
	        if (name.indexOf(seriesType) === 0) {
	          options = options[seriesType] || options; // For combo chart, options are set for each chart
	
	          if (_tuiCodeSnippet2['default'].isArray(options)) {
	            options = options[index] || {};
	          }
	
	          return false;
	        }
	
	        return true;
	      });
	    }
	
	    return options;
	  };
	
	  /**
	   * Make option key
	   * @param {string} type type of component
	   * @param {name} name name of component
	   * @returns {string} optionKey Key on which to create the option.
	   * @private
	   */
	
	
	  ComponentManager.prototype._getOptionKey = function _getOptionKey(type, name) {
	    return type === 'axis' ? name : type;
	  };
	
	  /**
	   * Make theme
	   * @param {string} optionKey Key on which to create the option.
	   * @param {string} name name of component
	   * @returns {object} theme
	   * @private
	   */
	
	
	  ComponentManager.prototype._makeTheme = function _makeTheme(optionKey, name) {
	    var theme = this.theme[optionKey];
	
	    if (!theme && optionKey === 'rightYAxis') {
	      theme = this.theme.yAxis;
	    }
	
	    if (optionKey === 'series') {
	      this.seriesTypes.forEach(function (seriesType) {
	        if (name.indexOf(seriesType) === 0) {
	          theme = theme[seriesType]; // For combo, single chart, themes are set for each chart
	
	          return false;
	        }
	
	        return true;
	      });
	    }
	
	    return theme;
	  };
	
	  /**
	   * Make data for rendering.
	   * @param {string} name - component name
	   * @param {string} type - component type
	   * @param {object} paper - raphael object
	   * @param {{
	   *      layoutBounds: {
	   *          dimensionMap: object,
	   *          positionMap: object
	   *      },
	   *      limitMap: object,
	   *      axisDataMap: object,
	   *      maxRadius: ?number
	   * }} boundsAndScale - bounds and scale data
	   * @param {?object} additionalData - additional data
	   * @returns {object}
	   * @private
	   */
	
	
	  ComponentManager.prototype._makeDataForRendering = function _makeDataForRendering(name, type, paper, boundsAndScale, additionalData) {
	    var data = Object.assign({ paper: paper }, additionalData);
	
	    if (boundsAndScale) {
	      Object.assign(data, boundsAndScale);
	
	      data.layout = {
	        dimension: data.dimensionMap[name] || data.dimensionMap[type],
	        position: data.positionMap[name] || data.positionMap[type]
	      };
	    }
	
	    return data;
	  };
	
	  /**
	   * Render components.
	   * @param {string} funcName - function name for executing
	   * @param {{
	   *      layoutBounds: {
	   *          dimensionMap: object,
	   *          positionMap: object
	   *      },
	   *      limitMap: object,
	   *      axisDataMap: object,
	   *      maxRadius: ?number
	   * }} boundsAndScale - bounds and scale data
	   * @param {?object} additionalData - additional data
	   * @param {?HTMLElement} container - container
	   */
	
	
	  ComponentManager.prototype.render = function render(funcName, boundsAndScale, additionalData, container) {
	    var _this3 = this;
	
	    var elements = this.components.map(function (component) {
	      var element = null;
	
	      if (component[funcName]) {
	        var name = component.componentName;
	        var type = component.componentType;
	        var paper = _this3.drawingToolPicker.getPaper(container, component.drawingType);
	        var data = _this3._makeDataForRendering(name, type, paper, boundsAndScale, additionalData);
	
	        var result = component[funcName](data);
	
	        if (result && !result.paper) {
	          element = result;
	        }
	      }
	
	      return element;
	    });
	
	    if (container) {
	      _domHandler2['default'].append(container, elements);
	    }
	  };
	
	  /**
	   * Find components to conditionMap.
	   * @param {object} conditionMap condition map
	   * @returns {Array.<object>} filtered components
	   */
	
	
	  ComponentManager.prototype.where = function where(conditionMap) {
	    return this.components.filter(function (component) {
	      var contained = true;
	
	      Object.entries(conditionMap).forEach(function (_ref) {
	        var _ref2 = _slicedToArray(_ref, 2),
	            key = _ref2[0],
	            value = _ref2[1];
	
	        if (component[key] !== value) {
	          contained = false;
	        }
	
	        return contained;
	      });
	
	      return contained;
	    });
	  };
	
	  /**
	   * Execute components.
	   * @param {string} funcName - function name
	   */
	
	
	  ComponentManager.prototype.execute = function execute(funcName) {
	    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      args[_key - 1] = arguments[_key];
	    }
	
	    this.components.forEach(function (component) {
	      if (component[funcName]) {
	        component[funcName].apply(component, args);
	      }
	    });
	  };
	
	  /**
	   * Get component.
	   * @param {string} name component name
	   * @returns {object} component instance
	   */
	
	
	  ComponentManager.prototype.get = function get(name) {
	    return this.componentMap[name];
	  };
	
	  /**
	   * Whether has component or not.
	   * @param {string} name - comopnent name
	   * @returns {boolean}
	   */
	
	
	  ComponentManager.prototype.has = function has(name) {
	    return !!this.get(name);
	  };
	
	  return ComponentManager;
	}();
	
	exports['default'] = ComponentManager;

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = axisFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                          
	                                                                                                                                                           * @fileoverview  Axis component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var AXIS_EDGE_RATIO = _const2['default'].AXIS_EDGE_RATIO,
	    X_AXIS_LABEL_PADDING = _const2['default'].X_AXIS_LABEL_PADDING,
	    COMPONENT_TYPE_RAPHAEL = _const2['default'].COMPONENT_TYPE_RAPHAEL;
	
	var Axis = function () {
	  /**
	   * Axis component.
	   * @constructs Axis
	   * @private
	   * @param {object} params parameters
	   *      @param {object} params.bound axis bound
	   *      @param {object} params.theme axis theme
	   *      @param {object} params.options axis options
	   *      @param {object} params.dataProcessor data processor of chart
	   *      @param {object} params.seriesType series type
	   *      @param {boolean} params.isYAxis boolean value for axis is vertical or not
	   */
	  function Axis(params) {
	    _classCallCheck(this, Axis);
	
	    /**
	     * Axis view className
	     * @type {string}
	     */
	    this.className = 'tui-chart-axis-area';
	
	    /**
	     * Data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * Options
	     * @type {object}
	     */
	    this.options = params.options || {};
	
	    /**
	     * Axis Theme
	     * Use chart background theme object for render yAxis background on dynamicDataShifting chart
	     * @type {object}
	     */
	    this.theme = _tuiCodeSnippet2['default'].extend({}, params.theme, {
	      background: params.chartTheme.chart.background
	    });
	
	    /**
	     * Whether label type axis or not.
	     * @type {boolean}
	     */
	    this.isLabelAxis = false;
	
	    /**
	     * Whether vertical type or not.
	     * @type {boolean}
	     */
	    this.isYAxis = params.isYAxis;
	
	    /**
	     * Whether data dynamic shifting or not.
	     * @type {boolean}
	     */
	    this.shifting = params.shifting;
	
	    /**
	     * cached axis data
	     * @type {object}
	     */
	    this.data = {};
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number, ?right:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * dimension map for layout of chart
	     * @type {null|object}
	     */
	    this.dimensionMap = null;
	
	    /**
	     * axis data map
	     * @type {null|object}
	     */
	    this.axisDataMap = null;
	
	    /**
	     * Renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(COMPONENT_TYPE_RAPHAEL, 'axis');
	
	    /**
	     * Drawing type
	     * @type {string}
	     */
	    this.drawingType = COMPONENT_TYPE_RAPHAEL;
	
	    /**
	     * Paper additional width
	     * @type {number}
	     */
	    this.paperAdditionalWidth = 0;
	
	    /** * Paper additional height
	     * @type {number}
	     */
	    this.paperAdditionalHeight = 0;
	
	    /**
	     * Raphael Element for axis background
	     * We should caching this for prevent making background multiply
	     * @type {Raphael.Element}
	     */
	    this._elBg = null;
	
	    this.isRightYAxis = params.name === 'rightYAxis';
	  }
	
	  /**
	   * Render vertical axis background
	   * @private
	   */
	
	
	  Axis.prototype._renderBackground = function _renderBackground() {
	    var dimension = Object.assign({}, this.layout.dimension);
	    var position = Object.assign({}, this.layout.position);
	
	    if (this._elBg) {
	      this._elBg.remove();
	    }
	
	    this._elBg = this.graphRenderer.renderBackground(this.paper, position, dimension, this.theme.background);
	  };
	
	  /**
	   * Render child containers like title area, label area and tick area.
	   * @param {number} size xAxis width or yAxis height
	   * @param {number} tickCount tick count
	   * @param {Array.<number|string>} categories categories
	   * @param {number} additionalWidth additional width
	   * @private
	   */
	
	
	  Axis.prototype._renderChildContainers = function _renderChildContainers(size, tickCount, categories) {
	    var additionalWidth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
	
	    var isYAxisLineType = this.isYAxis && this.data.aligned;
	    var axisLimit = this.limitMap[this.dataProcessor.chartType];
	    var isNegativeLimitChart = !this.data.limit && axisLimit && axisLimit.min < 0;
	    var isBarChart = _predicate2['default'].isBarTypeChart(this.dataProcessor.chartType);
	    var seriesOption = this.dataProcessor.getOption('series') || {};
	    var isDivergingOption = seriesOption.diverging;
	
	    if (this.isYAxis && !this.data.isPositionRight && !this.options.isCenter && this.shifting) {
	      this._renderBackground();
	    }
	
	    this._renderTitleArea(size, additionalWidth);
	
	    if (this.options.showLabel !== false) {
	      this._renderLabelArea(size, tickCount, categories, additionalWidth);
	    }
	
	    if (!isYAxisLineType) {
	      this._renderTickArea(size, tickCount, additionalWidth);
	    }
	    if (isNegativeLimitChart && isBarChart && !isDivergingOption) {
	      this._renderNegativeStandardsLine(size, additionalWidth, this.dimensionMap.series, axisLimit);
	    }
	  };
	
	  /**
	   * Render divided xAxis if yAxis rendered in the center.
	   * @param {{width: number, height:number}} dimension axis area width and height
	   * @private
	   */
	
	
	  Axis.prototype._renderDividedAxis = function _renderDividedAxis(_ref) {
	    var width = _ref.width;
	    var _data = this.data,
	        tickCount = _data.tickCount,
	        categories = _data.labels;
	
	    var lSideWidth = Math.round(width / 2);
	    var rSideWidth = width - lSideWidth - 1;
	    var halfTickCount = parseInt(tickCount / 2, 10) + 1;
	    var lCategories = categories.slice(0, halfTickCount);
	    var rCategories = categories.slice(halfTickCount - 1, tickCount);
	    var tickInterval = lSideWidth / halfTickCount;
	    var secondXAxisAdditionalPosition = lSideWidth + this.dimensionMap.yAxis.width - 1;
	
	    this.paperAdditionalWidth = tickInterval;
	
	    this._renderChildContainers(lSideWidth, halfTickCount, lCategories, 0);
	    this._renderChildContainers(rSideWidth + 1, halfTickCount, rCategories, secondXAxisAdditionalPosition);
	  };
	
	  /**
	   * Render single axis if not divided.
	   * @param {{width: number, height: number}} dimension axis area dimension
	   * @private
	   */
	
	
	  Axis.prototype._renderNotDividedAxis = function _renderNotDividedAxis(_ref2) {
	    var width = _ref2.width,
	        height = _ref2.height;
	    var _data2 = this.data,
	        positionRatio = _data2.positionRatio,
	        tickCount = _data2.tickCount,
	        labels = _data2.labels;
	    var isYAxis = this.isYAxis;
	
	    var size = isYAxis ? height : width;
	    var additionalSize = 0;
	
	    if (positionRatio) {
	      additionalSize = size * positionRatio;
	    }
	
	    this._renderChildContainers(size, tickCount, labels, additionalSize);
	  };
	
	  /**
	   * Render axis area.
	   * @private
	   */
	
	
	  Axis.prototype._renderAxisArea = function _renderAxisArea() {
	    var dimension = this.layout.dimension;
	    var isLabelAxis = this.data.isLabelAxis;
	    var _options = this.options,
	        divided = _options.divided,
	        isCenter = _options.isCenter;
	    var width = dimension.width;
	
	
	    this.isLabelAxis = isLabelAxis;
	
	    if (divided) {
	      this.containerWidth = width + this.dimensionMap.yAxis.width;
	      this._renderDividedAxis(dimension);
	      width = this.containerWidth;
	    } else {
	      width += isCenter ? 1 : 0;
	      this._renderNotDividedAxis(dimension);
	    }
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      options: ?object,
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      },
	   *      dimensionMap: object,
	   *      axisDataMap: object
	   * }} data - bounds and scale data
	   * @private
	   */
	
	
	  Axis.prototype._setDataForRendering = function _setDataForRendering(_ref3) {
	    var layout = _ref3.layout,
	        dimensionMap = _ref3.dimensionMap,
	        limitMap = _ref3.limitMap,
	        axisDataMap = _ref3.axisDataMap;
	
	    this.layout = layout;
	    this.dimensionMap = dimensionMap;
	    this.limitMap = limitMap;
	
	    this.data = axisDataMap[this.componentName];
	    this.options = this.data.options;
	  };
	
	  /**
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Axis.prototype.render = function render(data) {
	    var paper = data.paper;
	
	    this.paper = paper;
	    this.axisSet = paper.set();
	
	    this._setDataForRendering(data);
	    this._renderAxisArea();
	  };
	
	  /**
	   * Rerender axis component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Axis.prototype.rerender = function rerender(data) {
	    this.axisSet.remove();
	
	    this.render(data);
	  };
	
	  /**
	   * Resize axis component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Axis.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * Zoom.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Axis.prototype.zoom = function zoom(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * get other side axis dimension
	   * @returns {object}
	   * @private
	   */
	
	
	  Axis.prototype._getOtherSideDimension = function _getOtherSideDimension() {
	    return this.dimensionMap[this.isYAxis ? 'xAxis' : 'yAxis'];
	  };
	
	  /**
	   * Title area renderer
	   * @param {number} size - area size
	   * @param {number} additionalWidth - right side xAxis position
	   * @private
	   */
	
	
	  Axis.prototype._renderTitleArea = function _renderTitleArea(size, additionalWidth) {
	    var _options$title = this.options.title,
	        title = _options$title === undefined ? {} : _options$title;
	
	    var xAxisOption = this.dataProcessor.getOption('xAxis');
	    var yAxisOption = this.dataProcessor.getOption('yAxis');
	    var seriesOption = this.dataProcessor.getOption('series') || {};
	
	    if (title.text) {
	      this.graphRenderer.renderTitle(this.paper, {
	        text: title.text,
	        offset: title.offset,
	        theme: this.theme.title,
	        rotationInfo: {
	          isVertical: this.isYAxis,
	          isPositionRight: this.data.isPositionRight,
	          isCenter: this.options.isCenter,
	          isColumnType: _predicate2['default'].isColumnTypeChart(this.dataProcessor.chartType, this.dataProcessor.seriesTypes),
	          isDiverging: seriesOption.diverging,
	          isYAxisCenter: yAxisOption && yAxisOption.align === 'center',
	          isXAxisTitleLeft: xAxisOption && xAxisOption.title && xAxisOption.title.align === 'left'
	        },
	        layout: this.layout,
	        areaSize: size,
	        additionalWidth: additionalWidth,
	        otherSideDimension: this._getOtherSideDimension(),
	        tickCount: this.data.tickCount,
	        set: this.axisSet
	      });
	    }
	  };
	
	  /**
	   * Render tick line.
	   * @param {number} areaSize - width or height
	   * @param {boolean} isNotDividedXAxis - whether is not divided x axis or not.
	   * @param {number} additionalSize - additional size
	   * @private
	   */
	
	
	  Axis.prototype._renderTickLine = function _renderTickLine(areaSize, isNotDividedXAxis, additionalSize) {
	    this.graphRenderer.renderTickLine({
	      areaSize: areaSize,
	      additionalSize: additionalSize,
	      additionalWidth: this.paperAdditionalWidth,
	      additionalHeight: this.paperAdditionalHeight,
	      isPositionRight: this.data.isPositionRight,
	      isCenter: this.data.options.isCenter,
	      isNotDividedXAxis: isNotDividedXAxis,
	      isVertical: this.isYAxis,
	      tickColor: this.theme.tickColor,
	      layout: this.layout,
	      paper: this.paper,
	      set: this.axisSet
	    });
	  };
	
	  /**
	   * Render ticks.
	   * @param {number} size - width or height
	   * @param {number} tickCount - tick count
	   * @param {boolean} isNotDividedXAxis - whether is not divided x axis or not.
	   * @param {number} [additionalSize] - additional size
	   * @private
	   */
	
	
	  Axis.prototype._renderTicks = function _renderTicks(size, tickCount, isNotDividedXAxis, additionalSize) {
	    var tickColor = this.theme.tickColor;
	    var _data3 = this.data,
	        remainLastBlockInterval = _data3.remainLastBlockInterval,
	        _data3$sizeRatio = _data3.sizeRatio,
	        sizeRatio = _data3$sizeRatio === undefined ? 1 : _data3$sizeRatio,
	        dataTickCount = _data3.tickCount,
	        isPositionRight = _data3.isPositionRight;
	
	    var remainLastBlockIntervalPosition = remainLastBlockInterval ? size : 0;
	    var isYAxis = this.isYAxis;
	    var _data$options = this.data.options,
	        isCenter = _data$options.isCenter,
	        isDivided = _data$options.divided;
	
	    var positions = _calculator2['default'].makeTickPixelPositions(size * sizeRatio, tickCount, 0, remainLastBlockIntervalPosition);
	    var additionalHeight = this.paperAdditionalHeight + 1;
	    var additionalWidth = this.paperAdditionalWidth;
	    var positionLength = remainLastBlockIntervalPosition ? dataTickCount + 1 : dataTickCount;
	
	    positions.length = positionLength;
	
	    this.graphRenderer.renderTicks({
	      paper: this.paper,
	      layout: this.layout,
	      positions: positions,
	      isVertical: isYAxis,
	      isCenter: isCenter,
	      isDivided: isDivided,
	      additionalSize: additionalSize,
	      additionalWidth: additionalWidth,
	      additionalHeight: additionalHeight,
	      otherSideDimension: this._getOtherSideDimension(),
	      isPositionRight: isPositionRight,
	      tickColor: tickColor,
	      set: this.axisSet
	    });
	  };
	
	  Axis.prototype._renderNegativeStandardsLine = function _renderNegativeStandardsLine(size, additionalSize, seriesDimension, axisLimit) {
	    this.graphRenderer.renderStandardLine({
	      areaSize: size,
	      isVertical: this.isYAxis,
	      layout: this.layout,
	      paper: this.paper,
	      set: this.axisSet,
	      seriesDimension: seriesDimension,
	      axisLimit: axisLimit
	    });
	  };
	
	  /**
	   * Render tick area.
	   * @param {number} size - width or height
	   * @param {number} tickCount - tick count
	   * @param {number} [additionalSize] - additional size (width or height)
	   * @private
	   */
	
	
	  Axis.prototype._renderTickArea = function _renderTickArea(size, tickCount, additionalSize) {
	    var isNotDividedXAxis = !this.isYAxis && !this.options.divided;
	
	    this._renderTickLine(size, isNotDividedXAxis, additionalSize || 0);
	    this._renderTicks(size, tickCount, isNotDividedXAxis, additionalSize || 0);
	  };
	
	  /**
	   * Render label area.
	   * @param {number} size label area size
	   * @param {number} tickCount tick count
	   * @param {Array.<string>} categories categories
	   * @param {number} [additionalSize] additional size (width or height)
	   * @private
	   */
	
	
	  Axis.prototype._renderLabelArea = function _renderLabelArea(size, tickCount, categories, additionalSize) {
	    var _data4 = this.data,
	        _data4$sizeRatio = _data4.sizeRatio,
	        sizeRatio = _data4$sizeRatio === undefined ? 1 : _data4$sizeRatio,
	        remainLastBlockInterval = _data4.remainLastBlockInterval;
	
	    var remainLastBlockIntervalPosition = remainLastBlockInterval ? size : 0;
	    var tickPixelPositions = _calculator2['default'].makeTickPixelPositions(size * sizeRatio, tickCount, 0, remainLastBlockIntervalPosition);
	    var labelDistance = tickPixelPositions[1] - tickPixelPositions[0];
	
	    this._renderLabels(tickPixelPositions, categories, labelDistance, additionalSize || 0);
	  };
	
	  /**
	   * Make html of rotation labels.
	   * @param {Array.<object>} positions label position array
	   * @param {string[]} categories categories
	   * @param {number} labelSize label size
	   * @param {number} additionalSize additional size
	   * @private
	   */
	
	
	  Axis.prototype._renderRotationLabels = function _renderRotationLabels(positions, categories, labelSize, additionalSize) {
	    var _this = this;
	
	    var renderer = this.graphRenderer;
	    var isYAxis = this.isYAxis;
	
	    var theme = this.theme.label;
	    var degree = this.data.degree;
	
	    var halfWidth = labelSize / 2;
	    var edgeAlignWidth = labelSize / AXIS_EDGE_RATIO;
	    var _layout$position = this.layout.position,
	        top = _layout$position.top,
	        left = _layout$position.left;
	
	    var horizontalTop = top + X_AXIS_LABEL_PADDING;
	    var baseLeft = left;
	    var labelMargin = this.options.labelMargin || 0;
	
	    positions.forEach(function (position, index) {
	      var labelPosition = position + (additionalSize || 0);
	      var positionTopAndLeft = {};
	
	      if (isYAxis) {
	        positionTopAndLeft.top = labelPosition + halfWidth;
	        positionTopAndLeft.left = labelSize + labelMargin;
	      } else {
	        positionTopAndLeft.top = horizontalTop + labelMargin;
	        positionTopAndLeft.left = baseLeft + labelPosition + edgeAlignWidth;
	      }
	
	      renderer.renderRotatedLabel({
	        degree: degree,
	        labelText: categories[index],
	        paper: _this.paper,
	        positionTopAndLeft: positionTopAndLeft,
	        set: _this.axisSet,
	        theme: theme
	      });
	    }, this);
	  };
	
	  /**
	   * Make html of normal labels.
	   * @param {Array.<object>} positions label position array
	   * @param {string[]} categories categories
	   * @param {number} labelSize label size
	   * @param {number} additionalSize additional size
	   * @private
	   */
	
	
	  Axis.prototype._renderNormalLabels = function _renderNormalLabels(positions, categories, labelSize, additionalSize) {
	    var _this2 = this;
	
	    var renderer = this.graphRenderer;
	    var isYAxis = this.isYAxis,
	        isCategoryLabel = this.isLabelAxis,
	        dataProcessor = this.dataProcessor,
	        layout = this.layout;
	    var isPositionRight = this.data.isPositionRight;
	
	    var theme = this.theme.label;
	    var _options2 = this.options,
	        _options2$labelMargin = _options2.labelMargin,
	        labelMargin = _options2$labelMargin === undefined ? 0 : _options2$labelMargin,
	        pointOnColumn = _options2.pointOnColumn,
	        isCenter = _options2.isCenter,
	        maxWidth = _options2.maxWidth;
	
	    var isLineTypeChart = _predicate2['default'].isLineTypeChart(dataProcessor.chartType, dataProcessor.seriesTypes);
	    var isPointOnColumn = isLineTypeChart && pointOnColumn;
	    var isAutoTickInterval = _predicate2['default'].isAutoTickInterval(this.options.tickInterval);
	
	    positions.forEach(function (position, index) {
	      var labelPosition = position + additionalSize;
	      var halfLabelDistance = labelSize / 2;
	      var isOverLapXAxisLabel = _this2._isOverLapXAxisLabel(categories[index], position, positions[index + 1]);
	      var positionTopAndLeft = {};
	
	      /*
	       * to prevent printing `undefined` text, when category label is not set
	       */
	      if (labelPosition < 0 || !isYAxis && isAutoTickInterval && isOverLapXAxisLabel) {
	        return;
	      }
	
	      if (isYAxis) {
	        positionTopAndLeft = _this2._getYAxisLabelPosition(layout, {
	          labelPosition: labelPosition,
	          isCategoryLabel: isCategoryLabel,
	          halfLabelDistance: halfLabelDistance,
	          isPositionRight: isPositionRight
	        });
	      } else {
	        positionTopAndLeft = _this2._getXAxisLabelPosition(layout, {
	          labelMargin: labelMargin,
	          labelHeight: _renderUtil2['default'].getRenderedLabelsMaxHeight(categories, theme),
	          labelPosition: labelPosition,
	          isCategoryLabel: isCategoryLabel,
	          isLineTypeChart: isLineTypeChart,
	          isPointOnColumn: isPointOnColumn,
	          halfLabelDistance: halfLabelDistance
	        });
	      }
	
	      positionTopAndLeft.top = Math.round(positionTopAndLeft.top);
	      positionTopAndLeft.left = Math.round(positionTopAndLeft.left);
	
	      var labelText = categories[index];
	      if (maxWidth) {
	        labelText = _raphaelRenderUtil2['default'].getEllipsisText(categories[index], maxWidth, theme);
	      }
	
	      renderer.renderLabel({
	        isPositionRight: isPositionRight,
	        isVertical: isYAxis,
	        isCenter: isCenter,
	        labelSize: labelSize,
	        labelText: labelText,
	        paper: _this2.paper,
	        positionTopAndLeft: positionTopAndLeft,
	        set: _this2.axisSet,
	        theme: theme
	      });
	    }, this);
	  };
	
	  /**
	   * @param {string} labelText - axis label text
	   * @param {number} position - current left position
	   * @param {number} nextPosition - next  left position
	   * @returns {boolean}
	   */
	
	
	  Axis.prototype._isOverLapXAxisLabel = function _isOverLapXAxisLabel(labelText, position, nextPosition) {
	    var labelWidth = _renderUtil2['default'].getRenderedLabelWidth(labelText);
	
	    return !_tuiCodeSnippet2['default'].isUndefined(nextPosition) && nextPosition - position < labelWidth;
	  };
	
	  /**
	   * @param {object} layout - axis dimension, position
	   * @param {object} params - optional data needed to render axis labels
	   * @returns {object} top, left positon of y axis
	   */
	
	
	  Axis.prototype._getYAxisLabelPosition = function _getYAxisLabelPosition(layout, params) {
	    var labelLeftPosition = void 0;
	    var labelTopPosition = params.labelPosition;
	
	    if (params.isCategoryLabel) {
	      labelTopPosition += params.halfLabelDistance + layout.position.top;
	    } else {
	      labelTopPosition = layout.dimension.height + layout.position.top - labelTopPosition;
	    }
	
	    if (params.isPositionRight) {
	      labelLeftPosition = layout.position.left + layout.dimension.width;
	    } else if (this.options.isCenter) {
	      labelLeftPosition = layout.position.left + layout.dimension.width / 2;
	    } else {
	      labelLeftPosition = layout.position.left;
	    }
	
	    return {
	      top: labelTopPosition,
	      left: labelLeftPosition
	    };
	  };
	
	  /**
	   * @param {object} layout - axis dimension, position
	   * @param {object} params - optional data needed to render axis labels
	   * @returns {object} top, left positon of y axis
	   */
	
	
	  Axis.prototype._getXAxisLabelPosition = function _getXAxisLabelPosition(layout, params) {
	    var labelTopPosition = _calculator2['default'].sum([layout.position.top, X_AXIS_LABEL_PADDING, params.labelMargin, params.labelHeight / 2]);
	    var labelLeftPosition = params.labelPosition + layout.position.left;
	
	    if (params.isCategoryLabel) {
	      if (!params.isLineTypeChart || params.isPointOnColumn) {
	        labelLeftPosition += params.halfLabelDistance;
	      }
	    }
	
	    return {
	      top: labelTopPosition,
	      left: labelLeftPosition
	    };
	  };
	
	  /**
	   * Make labels html.
	   * @param {Array.<object>} positions - positions for labels
	   * @param {Array.<string>} categories - categories
	   * @param {number} labelSize label size
	   * @param {number} additionalSize additional size
	   * @private
	   */
	
	
	  Axis.prototype._renderLabels = function _renderLabels(positions, categories, labelSize, additionalSize) {
	    var _options3 = this.options,
	        rotateLabel = _options3.rotateLabel,
	        prefix = _options3.prefix,
	        suffix = _options3.suffix;
	    var _data5 = this.data,
	        degree = _data5.degree,
	        multilineLabels = _data5.multilineLabels;
	
	    var isRotationlessXAxis = !this.isYAxis && this.isLabelAxis && rotateLabel === false;
	    var hasRotatedXAxisLabel = this.componentName === 'xAxis' && degree;
	    var axisLabels = void 0;
	
	    if (isRotationlessXAxis) {
	      axisLabels = multilineLabels;
	    } else {
	      axisLabels = categories;
	    }
	
	    if (axisLabels.length) {
	      positions.length = axisLabels.length;
	    }
	
	    axisLabels = _renderUtil2['default'].addPrefixSuffix(axisLabels, prefix, suffix);
	
	    if (hasRotatedXAxisLabel) {
	      this._renderRotationLabels(positions, axisLabels, labelSize, additionalSize);
	    } else {
	      this._renderNormalLabels(positions, axisLabels, labelSize, additionalSize);
	    }
	  };
	
	  /**
	   * Animate axis for adding data
	   * @param {object} data rendering data
	   */
	
	
	  Axis.prototype.animateForAddingData = function animateForAddingData(data) {
	    if (!this.isYAxis) {
	      this.graphRenderer.animateForAddingData(data.tickSize);
	    }
	  };
	
	  return Axis;
	}();
	
	/**
	 * Factory for Axis
	 * @param {object} axisParam parameter
	 * @returns {object}
	 * @ignore
	 */
	
	
	function axisFactory(axisParam) {
	  var chartOptions = axisParam.chartOptions,
	      name = axisParam.name,
	      theme = axisParam.theme,
	      seriesTypes = axisParam.seriesTypes;
	  var chartType = chartOptions.chartType,
	      series = chartOptions.series;
	
	
	  axisParam.isYAxis = name === 'yAxis' || name === 'rightYAxis';
	  axisParam.shifting = series.shifting;
	
	  // In combo chart, the theme is divided into series name considering two YAxis(yAxis and rightYAxis)
	  // @todo change theme structure so that access theme by axis type, not considering chart type
	  //     like theme.xAxis, theme.yAxis, theme.rightYAxis
	  if (chartType === 'combo') {
	    if (axisParam.isYAxis) {
	      axisParam.theme = theme[seriesTypes[0]];
	    } else if (name === 'rightYAxis') {
	      axisParam.componentType = 'yAxis';
	      axisParam.theme = theme[seriesTypes[1]];
	      axisParam.index = 1;
	    }
	    // @todo I do not know why the single type chart with yAxis branches once again as the chart name inside it. I feel inconsistent
	  } else if (axisParam.isYAxis) {
	    axisParam.theme = theme[chartType];
	    // single chart, xAxis
	  } else {
	    axisParam.theme = theme;
	  }
	
	  return new Axis(axisParam);
	}
	
	axisFactory.componentType = 'axis';
	axisFactory.Axis = Axis;

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	exports['default'] = plotFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Plot component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var Plot = function () {
	  /**
	   * Plot component.
	   * @constructs Plot
	   * @private
	   * @param {object} params parameters
	   *      @param {number} params.vTickCount vertical tick count
	   *      @param {number} params.hTickCount horizontal tick count
	   *      @param {object} params.theme axis theme
	   * @ignore
	   */
	  function Plot(params) {
	    _classCallCheck(this, Plot);
	
	    /**
	     * Plot view className
	     * @type {string}
	     */
	    this.className = 'tui-chart-plot-area';
	
	    /**
	     * Data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * Options
	     * @type {object}
	     */
	    this.options = params.options || {};
	    this.options.showLine = _tuiCodeSnippet2['default'].isUndefined(this.options.showLine) ? true : this.options.showLine;
	    this.options.lines = this.options.lines || [];
	    this.options.bands = this.options.bands || [];
	
	    /**
	     * x axis type option
	     * @type {?string}
	     */
	    this.xAxisTypeOption = params.xAxisTypeOption;
	
	    /**
	     * Theme
	     * @type {object}
	     */
	    this.theme = params.theme || {};
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * sub charts type
	     * @type {Array.<string>}
	     */
	    this.chartTypes = params.chartTypes;
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * axis data map
	     * @type {null|object}
	     */
	    this.axisDataMap = null;
	
	    this.drawingType = _const2['default'].COMPONENT_TYPE_RAPHAEL;
	  }
	
	  /**
	   * Preset components for setData
	   * @param {object} theme theme object
	   * @ignore
	   */
	
	
	  Plot.prototype.presetForChangeData = function presetForChangeData() {
	    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.theme;
	
	    this.theme = theme;
	  };
	
	  /**
	   * Render plot area.
	   * @param {object} paper paper object
	   * @private
	   */
	
	
	  Plot.prototype._renderPlotArea = function _renderPlotArea(paper) {
	    var dimension = this.layout.dimension;
	
	
	    if (_predicate2['default'].isLineTypeChart(this.chartType, this.chartTypes)) {
	      this._renderOptionalLines(paper, dimension);
	    }
	
	    if (this.options.showLine) {
	      this._renderPlotLines(paper, dimension);
	    }
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      },
	   *      axisDataMap: object
	   * }} data - bounds and scale data
	   * @private
	   */
	
	
	  Plot.prototype._setDataForRendering = function _setDataForRendering(data) {
	    if (data) {
	      this.layout = data.layout;
	      this.dimensionMap = data.dimensionMap;
	      this.axisDataMap = data.axisDataMap;
	      this.paper = data.paper;
	    }
	  };
	
	  /**
	   * Render plot component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Plot.prototype.render = function render(data) {
	    var paper = data && data.paper || this.paper;
	    this.plotSet = paper.set();
	    this.additionalPlotSet = paper.set();
	
	    this._setDataForRendering(data);
	    this._renderPlotArea(this.paper);
	
	    this.additionalPlotSet.toBack();
	    this.plotSet.toBack();
	    paper.pushDownBackgroundToBottom();
	  };
	
	  /**
	   * Rerender.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Plot.prototype.rerender = function rerender(data) {
	    this.additionalPlotSet.remove();
	    this.plotSet.remove();
	    this.render(data);
	  };
	
	  /**
	   * Resize plot component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Plot.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * Zoom.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  Plot.prototype.zoom = function zoom(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * Make template params for vertical line.
	   * @param {object} additionalParams - additional params
	   * @returns {object}
	   * @private
	   */
	
	
	  Plot.prototype._makeVerticalLineTemplateParams = function _makeVerticalLineTemplateParams(additionalParams) {
	    return _tuiCodeSnippet2['default'].extend({
	      className: 'vertical',
	      positionType: 'left',
	      width: '1px'
	    }, additionalParams);
	  };
	
	  /**
	   * Make template params for horizontal line.
	   * @param {object} additionalParams - additional params
	   * @returns {object}
	   * @private
	   */
	
	
	  Plot.prototype._makeHorizontalLineTemplateParams = function _makeHorizontalLineTemplateParams(additionalParams) {
	    return _tuiCodeSnippet2['default'].extend({
	      className: 'horizontal',
	      positionType: 'bottom',
	      height: '1px'
	    }, additionalParams);
	  };
	
	  /**
	   * Render line
	   * @param {number} offsetPosition - start percentage offsetPosition
	   * @param {object} attributes - line attributes
	   * @returns {object} path
	   * @private
	   */
	
	
	  Plot.prototype._renderLine = function _renderLine(offsetPosition, attributes) {
	    var _layout = this.layout,
	        top = _layout.position.top,
	        height = _layout.dimension.height;
	
	    var pathString = 'M' + offsetPosition + ',' + top + 'V' + (top + height);
	    var path = this.paper.path(pathString);
	
	    path.attr({
	      opacity: attributes.opacity || 1,
	      stroke: attributes.color
	    });
	
	    this.additionalPlotSet.push(path);
	
	    return path;
	  };
	
	  /**
	   * Render band
	   * @param {number} offsetPosition - start percentage offsetPosition
	   * @param {number} plotWidth - plotWidth
	   * @param {object} attributes - band attributes
	   * @returns {object} band
	   * @private
	   */
	
	
	  Plot.prototype._renderBand = function _renderBand(offsetPosition, plotWidth, attributes) {
	    var _layout2 = this.layout,
	        position = _layout2.position,
	        dimension = _layout2.dimension;
	
	    var remainingWidth = dimension.width - offsetPosition + position.left;
	    var bandWidth = plotWidth < 0 ? remainingWidth : plotWidth;
	    var rect = this.paper.rect(offsetPosition, position.top, bandWidth, dimension.height);
	
	    rect.attr({
	      fill: attributes.color,
	      opacity: attributes.opacity || 1,
	      stroke: attributes.color
	    });
	
	    this.additionalPlotSet.push(rect);
	
	    return rect;
	  };
	
	  /**
	   * Create value range for optional line.
	   * @param {{range: ?Array.<number>, value: ?number}} optionalLineData - optional line data
	   * @returns {Array.<number>}
	   * @private
	   */
	
	
	  Plot.prototype._createOptionalLineValueRange = function _createOptionalLineValueRange(optionalLineData) {
	    var range = optionalLineData.range || [optionalLineData.value];
	
	    if (_predicate2['default'].isDatetimeType(this.xAxisTypeOption)) {
	      range = range.map(function (value) {
	        var date = new Date(value);
	
	        return date.getTime() || value;
	      });
	    }
	
	    return range;
	  };
	
	  /**
	   * Create position for optional line, when value axis.
	   * @param {{dataMin: number, distance: number}} xAxisData - x axis data
	   * @param {number} width - width
	   * @param {number} value - value
	   * @returns {number|null}
	   * @private
	   */
	
	
	  Plot.prototype._createOptionalLinePosition = function _createOptionalLinePosition(_ref, width, value) {
	    var dataMin = _ref.dataMin,
	        distance = _ref.distance;
	
	    var ratio = (value - dataMin) / distance;
	    var position = ratio * width;
	
	    if (ratio === 1) {
	      position -= 1;
	    }
	
	    if (position < 0) {
	      position = null;
	    }
	
	    return position;
	  };
	
	  /**
	   * Calculate xAxis labelDistance
	   * @param {number} width - width of xAxis
	   * @param {object} xAxisData - x axis data
	   * @returns {number}
	   * @private
	   */
	
	
	  Plot.prototype._calculateXAxisLabelDistance = function _calculateXAxisLabelDistance(width, xAxisData) {
	    var _xAxisData$sizeRatio = xAxisData.sizeRatio,
	        sizeRatio = _xAxisData$sizeRatio === undefined ? 1 : _xAxisData$sizeRatio,
	        tickCount = xAxisData.tickCount,
	        remainLastBlockInterval = xAxisData.remainLastBlockInterval;
	
	    var remainLastBlockIntervalPosition = remainLastBlockInterval ? width : 0;
	    var tickPixelPositions = _calculator2['default'].makeTickPixelPositions(width * sizeRatio, tickCount, 0, remainLastBlockIntervalPosition);
	
	    return tickPixelPositions[1] - tickPixelPositions[0];
	  };
	
	  /**
	   * Create position for optional line, when label axis.
	   * @param {number} width - width
	   * @param {object} xAxisData - x axis data
	   * @param {number} value - value
	   * @returns {number|null}
	   * @private
	   */
	
	
	  Plot.prototype._createOptionalLinePositionWhenLabelAxis = function _createOptionalLinePositionWhenLabelAxis(width, xAxisData, value) {
	    var dataProcessor = this.dataProcessor;
	
	    var isLineTypeChart = _predicate2['default'].isLineTypeChart(dataProcessor.chartType, dataProcessor.seriesTypes);
	    var isPointOnColumn = isLineTypeChart && xAxisData.options.pointOnColumn;
	    var index = dataProcessor.findCategoryIndex(value);
	    var halfLabelDistance = this._calculateXAxisLabelDistance(width, xAxisData) / 2;
	
	    var position = null;
	    var ratio = void 0;
	
	    if (!_tuiCodeSnippet2['default'].isNull(index)) {
	      var categoryCount = dataProcessor.getCategoryCount();
	      var divCount = isPointOnColumn ? categoryCount : categoryCount - 1;
	
	      ratio = index === 0 ? 0 : index / divCount;
	
	      position = ratio * width;
	      if (isPointOnColumn) {
	        position += halfLabelDistance;
	      }
	    }
	
	    if (ratio === 1) {
	      position -= 1;
	    }
	
	    return position;
	  };
	
	  /**
	   * Create position map for optional line.
	   * @param {{range: ?Array.<number>, value: ?number}} optionalLineData - optional line data
	   * @param {{isLabelAxis: boolean, dataMin: number, distance: number}} xAxisData - x axis data
	   * @param {number} width - width
	   * @returns {{start: number, end: number}}
	   * @private
	   */
	
	
	  Plot.prototype._createOptionalLinePositionMap = function _createOptionalLinePositionMap(optionalLineData, xAxisData, width) {
	    var categories = this.dataProcessor.getCategories();
	    var categoriesLen = categories.length;
	    var xAxisValues = this.dataProcessor.valuesMap.linex;
	
	    var range = this._createOptionalLineValueRange(optionalLineData);
	    var startPosition = void 0,
	        endPosition = void 0;
	
	    if (xAxisData.isLabelAxis) {
	      startPosition = this._createOptionalLinePositionWhenLabelAxis(width, xAxisData, range[0]);
	      endPosition = this._createOptionalLinePositionWhenLabelAxis(width, xAxisData, range[1]);
	    } else {
	      startPosition = this._createOptionalLinePosition(xAxisData, width, range[0]);
	      endPosition = range[1] && this._createOptionalLinePosition(xAxisData, width, range[1]);
	    }
	
	    if (_tuiCodeSnippet2['default'].isNull(startPosition)) {
	      var startValue = categoriesLen ? categories[0] : xAxisValues[0];
	      startPosition = this._isBeforeVisibleValue(range[0], startValue) ? 0 : -1;
	    }
	
	    if (_tuiCodeSnippet2['default'].isNull(endPosition) || endPosition > width) {
	      var endValue = categoriesLen ? categories[categoriesLen - 1] : xAxisValues[xAxisValues.length - 1];
	      endPosition = this._isAfterVisibleValue(range[1], endValue) ? width : -1;
	    }
	
	    return {
	      start: startPosition,
	      end: endPosition
	    };
	  };
	
	  /**
	   * @param {string} value - value of starting point
	   * @param {string} firstValue - first visible value data
	   * @returns {boolean} - whether starting point value is at before first visible data or not
	   * @private
	   */
	
	
	  Plot.prototype._isBeforeVisibleValue = function _isBeforeVisibleValue(value, firstValue) {
	    var dataProcessor = this.dataProcessor;
	
	
	    if (!_tuiCodeSnippet2['default'].isExisty(value)) {
	      return false;
	    }
	
	    if (_predicate2['default'].isDatetimeType(this.xAxisTypeOption)) {
	      return value < firstValue;
	    }
	
	    var valueIndex = dataProcessor.findAbsoluteCategoryIndex(value);
	    var firstValueIndex = dataProcessor.findAbsoluteCategoryIndex(firstValue);
	
	    return valueIndex >= 0 && valueIndex < firstValueIndex;
	  };
	
	  /**
	   * @param {string} value - value of end point
	   * @param {string} lastValue - last visible value data
	   * @returns {boolean} - whether end point value is at after last visible value data or not
	   * @private
	   */
	
	
	  Plot.prototype._isAfterVisibleValue = function _isAfterVisibleValue(value, lastValue) {
	    var dataProcessor = this.dataProcessor;
	
	
	    if (!_tuiCodeSnippet2['default'].isExisty(value)) {
	      return false;
	    }
	
	    if (_predicate2['default'].isDatetimeType(this.xAxisTypeOption)) {
	      return value > lastValue;
	    }
	
	    var valueIndex = dataProcessor.findAbsoluteCategoryIndex(value);
	    var lastValueIndex = dataProcessor.findAbsoluteCategoryIndex(lastValue);
	
	    return valueIndex >= 0 && valueIndex > lastValueIndex;
	  };
	
	  /**
	   * Render optional line.
	   * @param {Array.<number>} xAxisData - positions
	   * @param {number} width - standard width
	   * @param {object} attributes - template parameters
	   * @param {object} optionalLineData - optional line information
	   * @returns {object}
	   * @private
	   */
	
	
	  Plot.prototype._renderOptionalLine = function _renderOptionalLine(xAxisData, width, attributes, optionalLineData) {
	    var positionMap = this._createOptionalLinePositionMap(optionalLineData, xAxisData, width);
	    var line = void 0;
	
	    if (positionMap.start >= 0 && positionMap.start <= width) {
	      attributes.width = 1;
	
	      attributes.color = optionalLineData.color || 'transparent';
	      attributes.opacity = optionalLineData.opacity;
	
	      line = this._renderLine(positionMap.start + this.layout.position.left, attributes);
	    }
	
	    return line;
	  };
	
	  /**
	   * Render optional band.
	   * @param {Array.<number>} xAxisData - positions
	   * @param {number} width - standard width
	   * @param {object} attributes - template parameters
	   * @param {object} optionalLineData - optional line information
	   * @returns {object}
	   * @private
	   */
	
	
	  Plot.prototype._makeOptionalBand = function _makeOptionalBand(xAxisData, width, attributes, optionalLineData) {
	    var _this = this;
	
	    var range = optionalLineData.range;
	
	
	    if (range && range.length) {
	      this._makeRangeTo2DArray(optionalLineData);
	    }
	
	    var positionMaps = optionalLineData.range.map(function (rangeItem) {
	      return _this._createOptionalLinePositionMap({ range: rangeItem }, xAxisData, width);
	    });
	
	    if (optionalLineData.mergeOverlappingRanges) {
	      positionMaps.sort(compareByStartPosition);
	      positionMaps = this._mergeOverlappingPositionMaps(positionMaps);
	    }
	
	    return positionMaps.map(function (positionMap) {
	      var isStartPositionInsidePlotArea = positionMap.start >= 0 && positionMap.start <= width;
	      var band = void 0;
	
	      if (isStartPositionInsidePlotArea && positionMap.end >= 0) {
	        attributes.color = optionalLineData.color || 'transparent';
	        attributes.opacity = optionalLineData.opacity;
	
	        var bandWidth = positionMap.end - positionMap.start;
	        band = _this._renderBand(positionMap.start + _this.layout.position.left, bandWidth, attributes);
	      }
	
	      return band;
	    }, this);
	  };
	
	  /**
	   * Make optional lines html.
	   * @param {Array.<object>} lines - optional lines
	   * @param {{width: number, height: number}} dimension - dimension
	   * @returns {string}
	   * @private
	   */
	
	
	  Plot.prototype._makeOptionalLines = function _makeOptionalLines(lines, _ref2) {
	    var width = _ref2.width,
	        height = _ref2.height;
	
	    var xAxisData = this.axisDataMap.xAxis;
	    var templateParams = this._makeVerticalLineTemplateParams({
	      height: height + 'px'
	    });
	    var makeOptionalLineHtml = this._renderOptionalLine.bind(this, xAxisData, width, templateParams);
	
	    return lines.map(makeOptionalLineHtml);
	  };
	
	  /**
	   * Make optional lines html.
	   * @param {Array.<object>} lines - optional lines
	   * @param {{width: number, height: number}} dimension - dimension
	   * @returns {string}
	   * @private
	   */
	
	
	  Plot.prototype._makeOptionalBands = function _makeOptionalBands(lines, _ref3) {
	    var width = _ref3.width,
	        height = _ref3.height;
	
	    var xAxisData = this.axisDataMap.xAxis;
	    var templateParams = this._makeVerticalLineTemplateParams({
	      height: height + 'px'
	    });
	    var makeOptionalLineHtml = this._makeOptionalBand.bind(this, xAxisData, width, templateParams);
	
	    return lines.map(makeOptionalLineHtml);
	  };
	
	  /**
	   * Render optional lines and bands.
	   * @param {object} paper - paper
	   * @param {{width: number, height: number}} dimension - dimension
	   * @private
	   */
	
	
	  Plot.prototype._renderOptionalLines = function _renderOptionalLines(paper, dimension) {
	    this.optionalBands = this._makeOptionalBands(this.options.bands, dimension);
	    this.optionalLines = this._makeOptionalLines(this.options.lines, dimension);
	  };
	
	  /**
	   * Maker html for vertical lines
	   * @param {{width: number, height: number}} dimension - dimension
	   * @private
	   */
	
	
	  Plot.prototype._renderVerticalLines = function _renderVerticalLines(_ref4) {
	    var _this2 = this;
	
	    var width = _ref4.width;
	
	    var positions = this._makeHorizontalPositions(width);
	    var layout = this.layout,
	        lineColor = this.theme.lineColor;
	    var _layout$position = layout.position,
	        top = _layout$position.top,
	        left = _layout$position.left;
	
	
	    positions.forEach(function (position) {
	      var pathString = 'M' + (position + left) + ',' + top + 'V' + (top + layout.dimension.height);
	      var path = _this2.paper.path(pathString);
	
	      path.attr({
	        stroke: lineColor,
	        'stroke-width': 1,
	        'stroke-opacity': 0.05
	      });
	
	      _this2.plotSet.push(path);
	    });
	  };
	
	  /**
	   * Maker html for horizontal lines.
	   * @param {{width: number, height: number}} dimension - dimension
	   * @private
	   */
	
	
	  Plot.prototype._renderHorizontalLines = function _renderHorizontalLines(_ref5) {
	    var _this3 = this;
	
	    var height = _ref5.height;
	
	    var positions = this._makeVerticalPositions(height);
	    var layout = this.layout,
	        lineColor = this.theme.lineColor;
	    var _layout$position2 = layout.position,
	        left = _layout$position2.left,
	        top = _layout$position2.top;
	
	    var distance = positions.length > 1 ? positions[1] - positions[0] : 0;
	
	    positions.forEach(function (position, index) {
	      var pathString = 'M' + left + ',' + (distance * index + top) + 'H' + (left + layout.dimension.width);
	      var path = _this3.paper.path(pathString);
	
	      path.attr({
	        stroke: lineColor,
	        'stroke-width': 1,
	        'stroke-opacity': 0.05
	      });
	
	      _this3.plotSet.push(path);
	    });
	  };
	
	  /**
	   * Render plot lines.
	   * @param {HTMLElement} container - container element
	   * @param {{width: number, height: number}} dimension plot area dimension
	   * @private
	   */
	
	
	  Plot.prototype._renderPlotLines = function _renderPlotLines(container, dimension) {
	    if (!this.options.hideLine) {
	      this._renderVerticalLines(dimension);
	      this._renderHorizontalLines(dimension);
	    }
	  };
	
	  /**
	   * Make positions for vertical line.
	   * @param {number} height plot height
	   * @returns {Array.<number>} positions
	   * @private
	   */
	
	
	  Plot.prototype._makeVerticalPositions = function _makeVerticalPositions(height) {
	    var axisDataMap = this.axisDataMap;
	
	    var yAxis = axisDataMap.yAxis || axisDataMap.rightYAxis;
	    var positions = _calculator2['default'].makeTickPixelPositions(height, yAxis.validTickCount);
	
	    positions.shift();
	
	    return positions;
	  };
	
	  /**
	   * Make divided positions of plot.
	   * @param {number} width - plot width
	   * @param {number} tickCount - tick count
	   * @returns {Array.<number>}
	   * @private
	   */
	
	
	  Plot.prototype._makeDividedPlotPositions = function _makeDividedPlotPositions(width, tickCount) {
	    var yAxisWidth = this.dimensionMap.yAxis.width;
	
	    tickCount = parseInt(tickCount / 2, 10) + 1;
	    width -= yAxisWidth;
	
	    var leftWidth = Math.round(width / 2);
	    var rightWidth = width - leftWidth;
	    var leftPositions = _calculator2['default'].makeTickPixelPositions(leftWidth, tickCount);
	    var rightPositions = _calculator2['default'].makeTickPixelPositions(rightWidth, tickCount, leftWidth + yAxisWidth);
	
	    leftPositions.pop();
	    rightPositions.shift();
	
	    return leftPositions.concat(rightPositions);
	  };
	
	  /**
	   * Make positions for horizontal line.
	   * @param {number} width plot width
	   * @returns {Array.<number>} positions
	   * @private
	   */
	
	
	  Plot.prototype._makeHorizontalPositions = function _makeHorizontalPositions(width) {
	    var tickCount = this.axisDataMap.xAxis.validTickCount;
	    var positions = void 0;
	
	    if (this.options.divided) {
	      positions = this._makeDividedPlotPositions(width, tickCount);
	    } else {
	      positions = _calculator2['default'].makeTickPixelPositions(width, tickCount);
	      positions.shift();
	    }
	
	    return positions;
	  };
	
	  /**
	   * Add plot line.
	   * @param {{index: number, color: string, id: string}} data - data
	   */
	
	
	  Plot.prototype.addPlotLine = function addPlotLine(data) {
	    this.options.lines.push(data);
	    this.rerender();
	  };
	
	  /**
	   * Add plot band.
	   * @param {{range: Array.<number>, color: string, id: string}} data - data
	   */
	
	
	  Plot.prototype.addPlotBand = function addPlotBand(data) {
	    this.options.bands.push(data);
	    this.rerender();
	  };
	
	  /**
	   * Remove plot line.
	   * @param {string} id - line id
	   */
	
	
	  Plot.prototype.removePlotLine = function removePlotLine(id) {
	    this.options.lines = this.options.lines.filter(function (line) {
	      return line.id !== id;
	    });
	    this.rerender();
	  };
	
	  /**
	   * Remove plot band.
	   * @param {string} id - band id
	   */
	
	
	  Plot.prototype.removePlotBand = function removePlotBand(id) {
	    this.options.bands = this.options.bands.filter(function (band) {
	      return band.id !== id;
	    });
	    this.rerender();
	  };
	
	  /**
	   * Animate for adding data.
	   * @param {{tickSize: number, shifting: boolean}} data - data for animation
	   */
	
	
	  Plot.prototype.animateForAddingData = function animateForAddingData(data) {
	    var _this4 = this;
	
	    var optionLines = this.options.lines;
	    var optionBands = this.options.bands;
	
	    if (!this.dataProcessor.isCoordinateType()) {
	      if (data.shifting) {
	        this._animateItemForAddingData(this.optionalLines, data, function (itemIdx) {
	          optionLines.splice(itemIdx, 1);
	        });
	
	        this.optionalBands.forEach(function (bandRanges, bandIdx) {
	          _this4._animateItemForAddingData(bandRanges, data, function (itemIdx) {
	            optionBands[bandIdx].range.splice(itemIdx, 1);
	          });
	        });
	      }
	    }
	  };
	
	  /**
	   * Animate Item for adding data.
	   * @private
	   * @param {Array.<object>} optionalItems - svg rect elements for animate
	   * @param {{tickSize: number, shifting: boolean}} data - data for animation
	   * @param {function} removePlotItem - function for optional plot delete
	   */
	
	
	  Plot.prototype._animateItemForAddingData = function _animateItemForAddingData(optionalItems, data, removePlotItem) {
	    var _this5 = this;
	
	    optionalItems.forEach(function (item, lineIdx) {
	      var bbox = item.getBBox();
	
	      if (bbox.x - data.tickSize < _this5.layout.position.left) {
	        item.animate({
	          transform: 'T-' + data.tickSize + ',0',
	          opacity: 0
	        }, 300, 'linear', function () {
	          removePlotItem(lineIdx);
	          item.remove();
	        });
	      } else {
	        item.animate({
	          transform: 'T-' + data.tickSize + ',0'
	        }, 300);
	      }
	    });
	  };
	
	  /**
	   * Check if  optionalLineData has range property and range property is 2D array
	   * @param {{range: ?Array.<number>}} optionalLineData - optional line data
	   * @private
	   */
	
	
	  Plot.prototype._makeRangeTo2DArray = function _makeRangeTo2DArray(optionalLineData) {
	    var range = optionalLineData.range;
	
	    var isOneDimensionArray = range && _tuiCodeSnippet2['default'].isArray(range) && (range.length === 0 || !_tuiCodeSnippet2['default'].isArray(range[0]));
	
	    if (isOneDimensionArray) {
	      optionalLineData.range = [range];
	    }
	  };
	
	  /**
	   * check if some areas are overlapped, and then merge overlapping area
	   * @param {Array.<{start: number, end: number}>} positionMaps - original positionMaps
	   * @returns {Array.<{start: number, end: number}>} - inspected positionMaps
	   * @private
	   */
	
	
	  Plot.prototype._mergeOverlappingPositionMaps = function _mergeOverlappingPositionMaps(positionMaps) {
	    var len = positionMaps.length;
	    var processedMap = void 0,
	        previous = void 0;
	
	    if (len) {
	      processedMap = [positionMaps[0]];
	      var _processedMap = processedMap;
	
	      var _processedMap2 = _slicedToArray(_processedMap, 1);
	
	      previous = _processedMap2[0];
	    }
	
	    for (var i = 1; i < len; i += 1) {
	      var current = positionMaps[i];
	
	      if (current.start <= previous.end) {
	        previous.end = Math.max(current.end, previous.end);
	      } else {
	        processedMap.push(current);
	        previous = current;
	      }
	    }
	
	    return processedMap;
	  };
	
	  return Plot;
	}();
	
	/**
	 * Compare positionMap by it's start value
	 * @param {{start: number, end: number}} previous - previouse plot band positionMap
	 * @param {{start: number, end: number}} current - current plot band positionMap
	 * @returns {number} - comparison of whether a is greater than b
	 * @ignore
	 */
	
	
	function compareByStartPosition(previous, current) {
	  return previous.start - current.start;
	}
	
	/**
	 * Factory for Plot
	 * @param {object} param parameter
	 * @returns {object}
	 * @ignore
	 */
	function plotFactory(param) {
	  var seriesTypes = param.seriesTypes,
	      _param$chartOptions = param.chartOptions,
	      chartType = _param$chartOptions.chartType,
	      xAxisType = _param$chartOptions.xAxis.type;
	
	  // same among bar, chart, line, area charts
	
	  param.chartType = chartType;
	  param.chartTypes = seriesTypes;
	  param.xAxisTypeOption = xAxisType;
	
	  return new Plot(param);
	}
	
	plotFactory.componentType = 'plot';
	plotFactory.Plot = Plot;

/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = titleFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview  Title component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var Title = function () {
	  /**
	   * Title component.
	   * @constructs Title
	   * @param {object} params parameters
	   *      @param {object} params.bound title bound
	   *      @param {object} params.theme title theme
	   *      @param {object} params.options title options
	   *      @param {object} params.text title text content
	   * @ignore
	   */
	  function Title(params) {
	    _classCallCheck(this, Title);
	
	    /**
	     * Theme
	     * @type {object}
	     */
	    this.theme = params.theme || {};
	
	    /**
	     * Title text content
	     * @type {string}
	     */
	    this.titleText = params.text;
	
	    /**
	     * Relative offset position
	     * @type {object}
	     */
	    this.offset = params.offset;
	
	    /**
	     * title align option
	     * @type {object}
	     */
	    this.align = params.align;
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(_const2['default'].COMPONENT_TYPE_RAPHAEL, 'title');
	
	    /**
	     * Drawing type
	     * @type {string}
	     */
	    this.drawingType = _const2['default'].COMPONENT_TYPE_RAPHAEL;
	  }
	
	  /**
	   * Render title component
	   * @param {object} data data for render title
	   */
	
	
	  Title.prototype.render = function render(data) {
	    this.titleSet = this._renderTitleArea(data);
	  };
	
	  /**
	   * Render title component
	   * @param {object} data data for render title
	   */
	
	
	  Title.prototype.resize = function resize(data) {
	    var dimensionMap = data.dimensionMap;
	
	    var legendWidth = dimensionMap.legend ? dimensionMap.legend.width : 0;
	    var width = dimensionMap.series.width + legendWidth;
	
	    this.graphRenderer.resize(width, this.titleSet);
	  };
	
	  /**
	   * Render title component
	   * @param {object} data data for render title
	   */
	
	
	  Title.prototype.rerender = function rerender(data) {
	    this.titleSet.remove();
	
	    this.render(data);
	  };
	
	  /**
	   * Render title on given paper
	   * @param {object} data data for render title
	   * @returns {object} raphael paper
	   * @private
	   */
	
	
	  Title.prototype._renderTitleArea = function _renderTitleArea(data) {
	    var paper = data.paper,
	        dimensionMap = data.dimensionMap;
	
	    var chartTitleAreaWidth = this._calculateForTitleAreaWidth(dimensionMap);
	
	    return this.graphRenderer.render({
	      paper: paper,
	      titleText: this.titleText,
	      offset: this.offset,
	      theme: this.theme,
	      align: this.align,
	      chartTitleAreaWidth: chartTitleAreaWidth
	    });
	  };
	
	  /**
	   * Calculate title area width
	   * @param {object} dimensionMap dimensionMap
	   *     @param {object} dimensionMap.chartExportMenu dimension of chartExportMenu
	   *     @param {object} dimensionMap.chart chart of chartExportMenu
	   * @returns {number} title area width
	   * @private
	   */
	
	
	  Title.prototype._calculateForTitleAreaWidth = function _calculateForTitleAreaWidth(_ref) {
	    var chartExportMenu = _ref.chartExportMenu,
	        chart = _ref.chart;
	
	    var exportMenuWidth = chartExportMenu ? chartExportMenu.width * 2 : 0;
	
	    return chart.width - exportMenuWidth;
	  };
	
	  return Title;
	}();
	
	/**
	 * Factory for Title
	 * @param {object} param parameter
	 * @returns {object|null}
	 * @ignore
	 */
	
	
	function titleFactory(param) {
	  var options = param.chartOptions.chart || { title: {} };
	  var title = null;
	
	  if (options.title && options.title.text) {
	    param.text = options.title.text;
	    param.offset = options.title.offset;
	    param.align = options.title.align;
	
	    title = new Title(param);
	  }
	
	  return title;
	}
	
	titleFactory.componentType = 'title';
	titleFactory.Title = Title;

/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = RadialPlotFactory;
	
	var _geometric = __webpack_require__(50);
	
	var _geometric2 = _interopRequireDefault(_geometric);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Radial plot component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var COMPONENT_TYPE_RAPHAEL = _const2['default'].COMPONENT_TYPE_RAPHAEL,
	    RADIAL_PLOT_PADDING = _const2['default'].RADIAL_PLOT_PADDING,
	    RADIAL_MARGIN_FOR_CATEGORY = _const2['default'].RADIAL_MARGIN_FOR_CATEGORY,
	    RADIAL_CATEGORY_PADDING = _const2['default'].RADIAL_CATEGORY_PADDING;
	
	var RadialPlot = function () {
	  /**
	   * Plot component.
	   * @constructs Plot
	   * @param {object} params parameters
	   *      @param {number} params.vTickCount vertical tick count
	   *      @param {number} params.hTickCount horizontal tick count
	   *      @param {object} params.theme axis theme
	   * @ignore
	   */
	  function RadialPlot(params) {
	    _classCallCheck(this, RadialPlot);
	
	    /**
	     * plot component className
	     * @type {string}
	     */
	    this.className = 'tui-chart-plot-area';
	
	    /**
	     * Options
	     * @type {object}
	     */
	    this.options = _tuiCodeSnippet2['default'].extend({
	      type: 'spiderweb'
	    }, params.options);
	
	    /**
	     * Theme
	     * @type {object}
	     */
	    this.theme = params.theme || {};
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(COMPONENT_TYPE_RAPHAEL, 'radialPlot');
	
	    this.drawingType = COMPONENT_TYPE_RAPHAEL;
	  }
	
	  /**
	   * Render plot area
	   * @param {object} paper paper object
	   * @param {object} layout layout
	   * @param {Array.<Array>} plotPositions plot positions
	   * @param {object} labelData label data
	   * @returns {Array.<object>} plotSet
	   */
	
	
	  RadialPlot.prototype._renderPlotArea = function _renderPlotArea(paper, layout, plotPositions, labelData) {
	    var renderParams = {
	      paper: paper,
	      layout: layout,
	      plotPositions: plotPositions,
	      labelData: labelData,
	      theme: this.theme,
	      options: this.options
	    };
	
	    return this.graphRenderer.render(renderParams);
	  };
	
	  /**
	   * Make plot positions for render
	   * @param {object} axisDataMap axisDataMap
	   * @param {object} layout layout
	   * @returns {Array.<Array>} plot positions
	   */
	
	
	  RadialPlot.prototype._makePositions = function _makePositions(axisDataMap, layout) {
	    var dimension = layout.dimension,
	        _layout$position = layout.position,
	        left = _layout$position.left,
	        top = _layout$position.top;
	    var width = dimension.width,
	        height = dimension.height;
	
	
	    width = width - RADIAL_PLOT_PADDING - RADIAL_MARGIN_FOR_CATEGORY;
	    height = height - RADIAL_PLOT_PADDING - RADIAL_MARGIN_FOR_CATEGORY;
	
	    var centerX = _calculator2['default'].sum([width / 2, RADIAL_PLOT_PADDING / 2, RADIAL_MARGIN_FOR_CATEGORY / 2, left]);
	
	    var centerY = height / 2 - RADIAL_PLOT_PADDING / 2 - RADIAL_MARGIN_FOR_CATEGORY / 2 - top;
	    var stepCount = axisDataMap.yAxis.tickCount;
	    var angleStepCount = axisDataMap.xAxis.labels.length;
	
	    return makeSpiderWebPositions({
	      width: width,
	      height: height,
	      centerX: centerX,
	      centerY: centerY,
	      angleStepCount: angleStepCount,
	      stepCount: stepCount
	    });
	  };
	
	  /**
	   * Make category positions
	   * @param {object} axisDataMap axisDataMap
	   * @param {object} layout layout
	   * @returns {Array.<object>} category positions
	   */
	
	
	  RadialPlot.prototype._makeCategoryPositions = function _makeCategoryPositions(axisDataMap, layout) {
	    var dimension = layout.dimension,
	        _layout$position2 = layout.position,
	        left = _layout$position2.left,
	        top = _layout$position2.top;
	    var width = dimension.width,
	        height = dimension.height;
	
	
	    width = width - RADIAL_PLOT_PADDING - RADIAL_CATEGORY_PADDING;
	    height = height - RADIAL_PLOT_PADDING - RADIAL_CATEGORY_PADDING;
	
	    var centerX = _calculator2['default'].sum([width / 2, RADIAL_PLOT_PADDING / 2, RADIAL_CATEGORY_PADDING / 2, left]);
	    var centerY = height / 2 - RADIAL_PLOT_PADDING / 2 - RADIAL_CATEGORY_PADDING / 2 - top;
	    var angleStepCount = axisDataMap.xAxis.labels.length;
	
	    return makeRadialCategoryPositions({
	      width: width,
	      height: height,
	      centerX: centerX,
	      centerY: centerY,
	      angleStepCount: angleStepCount
	    });
	  };
	
	  /**
	   * Make label data
	   * @param {object} axisDataMap axisDataMap
	   * @param {object} dimension dimension
	   * @param {Array.<Array>} plotPositions plot positions
	   * @returns {object}
	   */
	
	
	  RadialPlot.prototype._makeLabelData = function _makeLabelData(axisDataMap, dimension, plotPositions) {
	    var categories = axisDataMap.xAxis.labels;
	    var stepLabels = axisDataMap.yAxis.labels;
	
	    var categoryPositions = this._makeCategoryPositions(axisDataMap, dimension);
	    var categoryLabelData = [];
	    var stepLabelData = [];
	
	    for (var i = 0; i < categories.length; i += 1) {
	      categoryLabelData.push({
	        text: categories[i],
	        position: categoryPositions[i]
	      });
	    }
	
	    // skip last step label. it could overlapped by category label
	    for (var j = 0; j < stepLabels.length - 1; j += 1) {
	      stepLabelData.push({
	        text: stepLabels[j],
	        position: plotPositions[j][0]
	      });
	    }
	
	    return {
	      category: categoryLabelData,
	      step: stepLabelData
	    };
	  };
	
	  /**
	   * Render plot component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  RadialPlot.prototype.render = function render(_ref) {
	    var axisDataMap = _ref.axisDataMap,
	        layout = _ref.layout,
	        paper = _ref.paper;
	
	    var plotPositions = this._makePositions(axisDataMap, layout);
	    var labelData = this._makeLabelData(axisDataMap, layout, plotPositions);
	
	    this.plotSet = this._renderPlotArea(paper, layout, plotPositions, labelData);
	  };
	
	  /**
	   * Re render plot component
	   * @param {object} data - bounds and scale data
	   */
	
	
	  RadialPlot.prototype.rerender = function rerender(data) {
	    this.plotSet.remove();
	
	    this.render(data);
	  };
	
	  /**
	   * Resize plot component.
	   * @param {object} data - bounds and scale data
	   */
	
	
	  RadialPlot.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  return RadialPlot;
	}();
	
	/**
	 * Make Spider web positions
	 * @param {object} params parameters
	 *     @param {number} params.width width
	 *     @param {number} params.height height
	 *     @param {number} params.centerX center x coordinate
	 *     @param {number} params.centerY center y coordinate
	 *     @param {number} params.angleStepCount angle step count
	 *     @param {number} params.stepCount step count
	 * @returns {Array<Array>} positions
	 * @private
	 */
	
	
	function makeSpiderWebPositions(params) {
	  var width = params.width,
	      height = params.height,
	      centerX = params.centerX,
	      centerY = params.centerY,
	      angleStepCount = params.angleStepCount,
	      stepCount = params.stepCount;
	
	  var radius = Math.min(width, height) / 2;
	  var angleStep = 360 / angleStepCount;
	  var points = [];
	  var stepPixel = radius / (stepCount - 1); // As there is not size in step 0, one step is removed
	
	  for (var i = 0; i < stepCount; i += 1) {
	    var stepPoints = [];
	    // point Y of first pixel to rotate
	    var pointY = centerY + stepPixel * i;
	
	    for (var j = 0; j < angleStepCount; j += 1) {
	      var point = _geometric2['default'].rotatePointAroundOrigin(centerX, centerY, centerX, pointY, angleStep * j);
	
	      stepPoints.push({
	        left: point.x,
	        top: height - point.y // convert y to top
	      });
	    }
	
	    stepPoints.push(stepPoints[0]);
	    points[i] = stepPoints;
	  }
	
	  return points;
	}
	
	/**
	 * Make radial category positions
	 * @param {object} params parameters
	 *     @param {number} params.width width
	 *     @param {number} params.height height
	 *     @param {number} params.centerX center x coordinate
	 *     @param {number} params.centerY center y coordinate
	 *     @param {number} params.angleStepCount angle step count
	 * @returns {Array<object>} category positions
	 * @private
	 */
	function makeRadialCategoryPositions(params) {
	  var width = params.width,
	      height = params.height,
	      centerX = params.centerX,
	      centerY = params.centerY,
	      angleStepCount = params.angleStepCount;
	
	  var radius = Math.min(height, width) / 2;
	  var angleStep = 360 / angleStepCount;
	  var points = [];
	  var pointY = centerY + radius;
	
	  for (var i = 0; i < angleStepCount; i += 1) {
	    var reversedAngle = 360 - angleStep * i;
	    var point = _geometric2['default'].rotatePointAroundOrigin(centerX, centerY, centerX, pointY, reversedAngle);
	    var anchor = void 0;
	
	    if (reversedAngle > 0 && reversedAngle < 180) {
	      anchor = 'end';
	    } else if (reversedAngle > 180 && reversedAngle < 360) {
	      anchor = 'start';
	    } else {
	      anchor = 'middle';
	    }
	
	    points.push({
	      left: point.x,
	      top: height - point.y, // convert y to top
	      anchor: anchor
	    });
	  }
	
	  return points;
	}
	
	/**
	 * RadialPlotFactory
	 * @param {object} param chart options
	 * @returns {object} radial plot instance
	 * @ignore
	 */
	function RadialPlotFactory(param) {
	  return new RadialPlot(param);
	}
	
	RadialPlotFactory.componentType = 'plot';
	RadialPlotFactory.RadialPlot = RadialPlot;

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Rotate a point around the origin with an angle.
	 * @param {number} centerX center point x
	 * @param {number} centerY center point y
	 * @param {number} pointX point x to rotate
	 * @param {number} pointY point y to rotate
	 * @param {number} angle angle
	 * @returns {object} x, y
	 * @ignore
	 */
	function rotatePointAroundOrigin(centerX, centerY, pointX, pointY, angle) {
	  var rad = angle * (Math.PI / 180);
	  var newX = (pointX - centerX) * Math.cos(rad) - (pointY - centerY) * Math.sin(rad);
	  var newY = (pointX - centerX) * Math.sin(rad) + (pointY - centerY) * Math.cos(rad);
	
	  newX += centerX;
	  newY += centerY;
	
	  return {
	    x: newX,
	    y: newY
	  };
	}
	/**
	 * Calculate adjacent.
	 * @param {number} degree degree
	 * @param {number} hypotenuse hypotenuse
	 * @returns {number} adjacent
	 * @ignore
	 *
	 *   H : Hypotenuse
	 *   A : Adjacent
	 *   O : Opposite
	 *   D : Degree
	 *
	 *        /|
	 *       / |
	 *    H /  | O
	 *     /   |
	 *    /\ D |
	 *    -----
	 *       A
	 */
	/**
	 * @fileoverview module for geometric operation
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function calculateAdjacent(degree, hypotenuse) {
	  return Math.cos(degree * _const2['default'].RAD) * hypotenuse;
	}
	
	/**
	 * Calculate opposite.
	 * @param {number} degree degree
	 * @param {number} hypotenuse hypotenuse
	 * @returns {number} opposite
	 * @ignore
	 */
	function calculateOpposite(degree, hypotenuse) {
	  return Math.sin(degree * _const2['default'].RAD) * hypotenuse;
	}
	
	/**
	 * Calculate rotated width.
	 * @param {number} degree - degree
	 * @param {number} width - width
	 * @param {number} height - height
	 * @returns {number}
	 * @ignore
	 */
	function calculateRotatedWidth(degree, width, height) {
	  var centerHalf = calculateAdjacent(degree, width / 2);
	  var sideHalf = calculateAdjacent(_const2['default'].ANGLE_90 - degree, height / 2);
	
	  return (centerHalf + sideHalf) * 2;
	}
	
	/**
	 * Calculate rotated height
	 * @param {number} degree - degree
	 * @param {number} width - width
	 * @param {number} height - height
	 * @returns {number}
	 * @ignore
	 */
	function calculateRotatedHeight(degree, width, height) {
	  var centerHalf = calculateOpposite(degree, width / 2);
	  var sideHalf = calculateOpposite(_const2['default'].ANGLE_90 - degree, height / 2);
	
	  return (centerHalf + sideHalf) * 2;
	}
	
	exports['default'] = {
	  rotatePointAroundOrigin: rotatePointAroundOrigin,
	  calculateAdjacent: calculateAdjacent,
	  calculateRotatedHeight: calculateRotatedHeight,
	  calculateRotatedWidth: calculateRotatedWidth,
	  calculateOpposite: calculateOpposite
	};

/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = chartExportMenuFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _chartExporter = __webpack_require__(52);
	
	var _chartExporter2 = _interopRequireDefault(_chartExporter);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _eventListener = __webpack_require__(56);
	
	var _eventListener2 = _interopRequireDefault(_eventListener);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview chartExportMenu component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var CHART_EXPORT_MENU_ITEMS = ['xls', 'csv', 'png', 'jpeg'];
	var CLASS_NAME_CHART_EXPORT_MENU_OPENED = 'menu-opened';
	var CLASS_NAME_CHART_EXPORT_MENU_BUTTON = _const2['default'].CLASS_NAME_CHART_EXPORT_MENU_BUTTON,
	    CLASS_NAME_CHART_EXPORT_MENU = _const2['default'].CLASS_NAME_CHART_EXPORT_MENU,
	    CLASS_NAME_CHART_EXPORT_MENU_HEAD = _const2['default'].CLASS_NAME_CHART_EXPORT_MENU_HEAD,
	    CLASS_NAME_CHART_EXPORT_MENU_BODY = _const2['default'].CLASS_NAME_CHART_EXPORT_MENU_BODY,
	    CLASS_NAME_CHART_EXPORT_MENU_ITEM = _const2['default'].CLASS_NAME_CHART_EXPORT_MENU_ITEM,
	    COMPONENT_TYPE_DOM = _const2['default'].COMPONENT_TYPE_DOM;
	
	var ChartExportMenu = function () {
	  /**
	   * ChartExportMenu component.
	   * @constructs ChartExportMenu
	   * @private
	   * @param {object} params parameters
	   */
	  function ChartExportMenu(params) {
	    _classCallCheck(this, ChartExportMenu);
	
	    /**
	     * ChartExportMenu view className
	     * @type {string}
	     */
	    this.className = 'tui-chart-chartExportMenu-area';
	
	    /**
	     * Data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * chart title
	     * @type {string}
	     */
	    this.chartTitle = params.chartTitle || 'tui-chart';
	
	    /**
	     * export filename
	     * @type {string}
	     */
	    this.exportFilename = params.exportFilename || this.chartTitle;
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{right:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * chartExportMenu container
	     * @type {HTMLElement}
	     */
	    this.chartExportMenuContainer = null;
	
	    /**
	     * chartExportMenu element
	     * @type {HTMLElement}
	     */
	    this.chartExportMenu = null;
	
	    /**
	     * chartExportMenu options
	     */
	    this.options = params.options;
	
	    /**
	     * Event bus
	     * @type {EventBus}
	     */
	    this.eventBus = params.eventBus;
	    this.drawingType = COMPONENT_TYPE_DOM;
	
	    this.theme = params.theme || null;
	  }
	
	  /**
	   * Create chartExportMenuButton
	   * @returns {HTMLElement}
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._createChartExportMenuButton = function _createChartExportMenuButton() {
	    var menuButton = _domHandler2['default'].create('div', CLASS_NAME_CHART_EXPORT_MENU_BUTTON);
	
	    if (this.options.buttonClass) {
	      _domHandler2['default'].addClass(menuButton, this.options.buttonClass);
	    }
	
	    return menuButton;
	  };
	
	  /**
	   * Render chartExportMenu area.
	   * @param {HTMLElement} chartExportMenuContainer chartExportMenu area element
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._renderChartExportMenuArea = function _renderChartExportMenuArea(chartExportMenuContainer) {
	    var menuButton = this._createChartExportMenuButton();
	    var dimension = this.layout.dimension;
	
	
	    chartExportMenuContainer.appendChild(menuButton);
	
	    _renderUtil2['default'].renderDimension(chartExportMenuContainer, dimension);
	    _renderUtil2['default'].renderPosition(chartExportMenuContainer, this.layout.position);
	  };
	
	  /**
	   * Render chartExportMenu area.
	   * @param {HTMLElement} chartExportMenuContainer chartExportMenu area element
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._renderChartExportMenu = function _renderChartExportMenu(chartExportMenuContainer) {
	    var seriesDataModelMap = this.dataProcessor.seriesDataModelMap;
	
	    var isDataDownloadAvailable = this.isDataDownloadAvailable(seriesDataModelMap);
	    var isDownloadSupported = _chartExporter2['default'].isDownloadSupported,
	        isImageExtension = _chartExporter2['default'].isImageExtension,
	        isImageDownloadAvailable = _chartExporter2['default'].isImageDownloadAvailable;
	
	    var menuElement = _domHandler2['default'].create('ul', CLASS_NAME_CHART_EXPORT_MENU);
	    var menuHead = _domHandler2['default'].create('li', CLASS_NAME_CHART_EXPORT_MENU_HEAD);
	    var menuBody = _domHandler2['default'].create('li', CLASS_NAME_CHART_EXPORT_MENU_BODY);
	    var menuStyle = menuElement.style;
	    var _theme = this.theme,
	        borderWidth = _theme.borderWidth,
	        borderRadius = _theme.borderRadius,
	        backgroundColor = _theme.backgroundColor,
	        color = _theme.color;
	
	    var menuItems = [];
	
	    if (isDownloadSupported && (isDataDownloadAvailable || isImageDownloadAvailable)) {
	      menuItems = CHART_EXPORT_MENU_ITEMS.map(function (exportItemType) {
	        var itemElement = void 0;
	
	        if (!isImageExtension(exportItemType) && isDataDownloadAvailable || isImageExtension(exportItemType) && isImageDownloadAvailable) {
	          itemElement = _domHandler2['default'].create('li', CLASS_NAME_CHART_EXPORT_MENU_ITEM);
	          itemElement.id = exportItemType;
	          itemElement.innerHTML = exportItemType;
	        }
	
	        return itemElement;
	      });
	    } else {
	      menuStyle.width = '200px';
	      menuItems[0] = _domHandler2['default'].create('li', CLASS_NAME_CHART_EXPORT_MENU_ITEM);
	      menuItems[0].innerHTML = 'Browser does not support client-side download.';
	    }
	
	    if (this.theme) {
	      if (borderWidth) {
	        menuStyle.borderWidth = borderWidth;
	      }
	
	      if (borderRadius) {
	        menuStyle.borderRadius = borderRadius;
	      }
	
	      if (backgroundColor) {
	        menuStyle.backgroundColor = backgroundColor;
	      }
	
	      if (color) {
	        menuStyle.color = color;
	      }
	    }
	
	    if (this.options.menuClass) {
	      _domHandler2['default'].addClass(menuElement, this.options.menuClass);
	    }
	
	    menuHead.innerHTML = 'Export to';
	
	    _domHandler2['default'].append(menuBody, menuItems);
	    _domHandler2['default'].append(menuElement, menuHead);
	    _domHandler2['default'].append(menuElement, menuBody);
	
	    this.chartExportMenu = menuElement;
	
	    _domHandler2['default'].append(chartExportMenuContainer, menuElement);
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      },
	   *      axisDataMap: object
	   * }} data - bounds and scale data
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._setDataForRendering = function _setDataForRendering(data) {
	    if (data) {
	      this.layout = data.layout;
	      this.dimensionMap = data.dimensionMap;
	      this.axisDataMap = data.axisDataMap;
	    }
	  };
	
	  /**
	   * Render chartExportMenu component.
	   * @param {object} data - bounds and scale data
	   * @returns {HTMLElement} chartExportMenu element
	   */
	
	
	  ChartExportMenu.prototype.render = function render(data) {
	    var container = null;
	
	    if (_chartExporter2['default'].isDownloadSupported) {
	      container = this.container = data.paper;
	
	      _domHandler2['default'].addClass(container, this.className);
	
	      this._setDataForRendering(data);
	      this._renderChartExportMenuArea(container);
	      this._renderChartExportMenu(container);
	      this.chartExportMenuContainer = container;
	      this._attachEvent();
	    }
	
	    return container;
	  };
	
	  /**
	   * Rerender.
	   */
	
	
	  ChartExportMenu.prototype.rerender = function rerender() {
	    this._hideChartExportMenu();
	  };
	
	  /**
	   * Resize.
	   */
	
	
	  ChartExportMenu.prototype.resize = function resize() {};
	
	  /**
	   * Show chart export menu
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._showChartExportMenu = function _showChartExportMenu() {
	    _domHandler2['default'].addClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED);
	    this.chartExportMenu.style.display = 'block';
	  };
	
	  /**
	   * Hide chart export menu
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._hideChartExportMenu = function _hideChartExportMenu() {
	    if (this.chartExportMenuContainer) {
	      _domHandler2['default'].removeClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED);
	      this.chartExportMenu.style.display = 'none';
	    }
	  };
	
	  /**
	   * onclick event handler
	   * @param {MouseEvent} e mouse event
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._onClick = function _onClick(e) {
	    var elTarget = e.target || e.srcElement;
	
	    if (_domHandler2['default'].hasClass(elTarget, CLASS_NAME_CHART_EXPORT_MENU_ITEM)) {
	      if (elTarget.id) {
	        var svgElement = this._getMainSvgElemenmt(this.container.parentNode);
	
	        this.eventBus.fire('beforeImageDownload');
	
	        _chartExporter2['default'].exportChart(this.exportFilename, elTarget.id, this.dataProcessor.rawData, svgElement, this.options);
	
	        this.eventBus.fire('afterImageDownload');
	      }
	
	      this._hideChartExportMenu();
	    } else if (_domHandler2['default'].hasClass(elTarget, CLASS_NAME_CHART_EXPORT_MENU_BUTTON) && this.chartExportMenuContainer === elTarget.parentNode && !_domHandler2['default'].hasClass(this.chartExportMenuContainer, CLASS_NAME_CHART_EXPORT_MENU_OPENED)) {
	      this._showChartExportMenu();
	    } else {
	      this._hideChartExportMenu();
	    }
	  };
	
	  /**
	   * Return chart svg
	   * @param {HTMLElement} mainContainer - chart container element
	   * @returns {HTMLElement} - chart main svg element
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._getMainSvgElemenmt = function _getMainSvgElemenmt(mainContainer) {
	    var svgElements = Array.from(mainContainer.getElementsByTagName('svg'));
	    var svgElement = void 0;
	
	    svgElements.forEach(function (svg) {
	      if (mainContainer === svg.parentNode) {
	        svgElement = svg;
	      }
	    });
	
	    return svgElement;
	  };
	
	  /**
	   * Return boolean value for chart data is able to export
	   * @param {object} seriesDataModels series data model
	   * @returns {boolean}
	   */
	
	
	  ChartExportMenu.prototype.isDataDownloadAvailable = function isDataDownloadAvailable(seriesDataModels) {
	    var result = true;
	
	    if (_predicate2['default'].isTreemapChart(this.chartType)) {
	      result = false;
	    } else {
	      Object.values(seriesDataModels).forEach(function (seriesDataModel) {
	        if (seriesDataModel.isCoordinateType) {
	          result = false;
	        }
	
	        return false;
	      });
	    }
	
	    return result;
	  };
	
	  /**
	   * Attach browser event.
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._attachEvent = function _attachEvent() {
	    _eventListener2['default'].on(this.chartExportMenuContainer.parentNode, 'click', this._onClick, this);
	  };
	
	  /**
	   * Detach browser event.
	   * @private
	   */
	
	
	  ChartExportMenu.prototype._detachEvent = function _detachEvent() {
	    _eventListener2['default'].off(this.chartExportMenuContainer.parentNode, 'click', this._onClick);
	  };
	
	  return ChartExportMenu;
	}();
	
	/**
	 * Factory for ChartExportMenu
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	
	
	function chartExportMenuFactory(params) {
	  var isVisible = params.options.visible;
	  var _params$chartOptions$ = params.chartOptions.chart,
	      chartOption = _params$chartOptions$ === undefined ? {} : _params$chartOptions$;
	
	  var exportingOption = params.chartOptions.chartExportMenu;
	  var chartExportMenu = null;
	
	  if (chartOption.title) {
	    params.chartTitle = chartOption.title.text;
	  }
	
	  if (exportingOption && exportingOption.filename) {
	    params.exportFilename = exportingOption.filename;
	  }
	
	  if (isVisible) {
	    chartExportMenu = new ChartExportMenu(params);
	  }
	
	  return chartExportMenu;
	}
	
	chartExportMenuFactory.componentType = 'chartExportMenu';

/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _dataExporter = __webpack_require__(53);
	
	var _dataExporter2 = _interopRequireDefault(_dataExporter);
	
	var _imageExporter = __webpack_require__(55);
	
	var _imageExporter2 = _interopRequireDefault(_imageExporter);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * @fileOverview Chart exporter
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	var browser = _tuiCodeSnippet2['default'].browser,
	    isExisty = _tuiCodeSnippet2['default'].isExisty,
	    isString = _tuiCodeSnippet2['default'].isString;
	
	
	var isIE10OrIE11 = browser.msie && (browser.version === 10 || browser.version === 11);
	var isImageDownloadAvailable = !isIE10OrIE11 || isIE10OrIE11 && document.createElement('canvas').getContext('2d').drawSvg;
	var isDownloadAttributeSupported = isExisty(document.createElement('a').download);
	var isMsSaveOrOpenBlobSupported = window.Blob && window.navigator.msSaveOrOpenBlob;
	
	/**
	 * Return given extension type is image format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isImageExtension(extension) {
	  return _arrayUtil2['default'].any(_imageExporter2['default'].getExtensions(), function (imageExtension) {
	    return extension === imageExtension;
	  });
	}
	/**
	 * Return given extension type is data format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isDataExtension(extension) {
	  return _arrayUtil2['default'].any(_dataExporter2['default'].getExtensions(), function (dataExtension) {
	    return extension === dataExtension;
	  });
	}
	
	/**
	 * Download chart data with given export type
	 * @param {string} fileName - file name = chart title
	 * @param {string} extension - file extension
	 * @param {object} rawData - chart raw data
	 * @param {HTMLElement} svgElement - svg element
	 * @param {object} [downloadOptions] download option
	 * @ignore
	 */
	function exportChart(fileName, extension, rawData, svgElement, downloadOptions) {
	  var downloadOption = downloadOptions && downloadOptions[extension] ? downloadOptions[extension] : {};
	
	  if (isImageExtension(extension)) {
	    _imageExporter2['default'].downloadImage(fileName, extension, svgElement);
	  } else if (isDataExtension(extension)) {
	    _dataExporter2['default'].downloadData(fileName, extension, rawData, downloadOption);
	  }
	}
	
	exports['default'] = {
	  exportChart: exportChart,
	  isDownloadSupported: isDownloadAttributeSupported || isMsSaveOrOpenBlobSupported,
	  isImageDownloadAvailable: isImageDownloadAvailable,
	  isImageExtension: isImageExtension,
	
	  /**
	   * Add file extension to dataExtension
	   * @param {string} type file extension type
	   * @param {string} extension file extension
	   */
	  addExtension: function addExtension(type, extension) {
	    var isValidExtension = extension && isString(extension);
	    var exporter = void 0;
	    var extensions = void 0;
	
	    if (type === 'data') {
	      exporter = _dataExporter2['default'];
	    } else if (type === 'image') {
	      exporter = _imageExporter2['default'];
	    }
	
	    if (exporter && isValidExtension) {
	      extensions = exporter.getExtensions();
	      extensions.push(extension);
	    }
	  }
	};

/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _templateObject = _taggedTemplateLiteral(['<html xmlns:o="urn:schemas-microsoft-com:office:office" \n        xmlns:x="urn:schemas-microsoft-com:office:excel" \n        xmlns="http://www.w3.org/TR/REC-html40">\n        <head>\n            <!--[if gte mso 9]>\n                <xml>\n                    <x:ExcelWorkbook>\n                        <x:ExcelWorksheets>\n                            <x:ExcelWorksheet>\n                                <x:Name>Ark1</x:Name>\n                                <x:WorksheetOptions>\n                                    <x:DisplayGridlines/>\n                                </x:WorksheetOptions>\n                            </x:ExcelWorksheet>\n                        </x:ExcelWorksheets>\n                        </x:ExcelWorkbook>\n                </xml>\n            <![endif]-->\n            <meta name=ProgId content=Excel.Sheet>\n            <meta charset=UTF-8>\n        </head>\n        <body>\n            ', '\n        </body>\n        </html>'], ['<html xmlns:o="urn:schemas-microsoft-com:office:office" \n        xmlns:x="urn:schemas-microsoft-com:office:excel" \n        xmlns="http://www.w3.org/TR/REC-html40">\n        <head>\n            <!--[if gte mso 9]>\n                <xml>\n                    <x:ExcelWorkbook>\n                        <x:ExcelWorksheets>\n                            <x:ExcelWorksheet>\n                                <x:Name>Ark1</x:Name>\n                                <x:WorksheetOptions>\n                                    <x:DisplayGridlines/>\n                                </x:WorksheetOptions>\n                            </x:ExcelWorksheet>\n                        </x:ExcelWorksheets>\n                        </x:ExcelWorkbook>\n                </xml>\n            <![endif]-->\n            <meta name=ProgId content=Excel.Sheet>\n            <meta charset=UTF-8>\n        </head>\n        <body>\n            ', '\n        </body>\n        </html>']);
	
	var _downloader = __webpack_require__(54);
	
	var _downloader2 = _interopRequireDefault(_downloader);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _taggedTemplateLiteral(strings, raw) { return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * @fileOverview Chart data exporter
	                                                                                                                                                                                                     * @author NHN.
	                                                                                                                                                                                                     *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                     */
	
	var DATA_URI_HEADERS = {
	  xls: 'data:application/vnd.ms-excel;base64,',
	  csv: 'data:text/csv;charset=utf-8,%EF%BB%BF' /* BOM for utf-8 */
	};
	var DATA_URI_BODY_MAKERS = {
	  xls: _makeXlsBodyWithRawData,
	  csv: _makeCsvBodyWithRawData
	};
	var dataExtensions = [].concat(_toConsumableArray(_const2['default'].DATA_EXTENSIONS));
	
	var dataExporter = {
	  /**
	   * Download chart data
	   * @param {string} fileName file name
	   * @param {string} extension file extension
	   * @param {object} rawData raw data of chart
	   * @param {object} [downloadOption] download option
	   */
	  downloadData: function downloadData(fileName, extension, rawData, downloadOption) {
	    var chartData2DArray = _get2DArrayFromRawData(rawData);
	    var contentType = DATA_URI_HEADERS[extension].replace(/(data:|;base64,|,%EF%BB%BF)/g, '');
	    var content = DATA_URI_BODY_MAKERS[extension](chartData2DArray, downloadOption);
	
	    if (this._isNeedDataEncodeing()) {
	      if (extension !== 'csv') {
	        // base64 encoding for data URI scheme.
	        content = window.btoa(unescape(encodeURIComponent(content)));
	      }
	      content = DATA_URI_HEADERS[extension] + content;
	    }
	
	    _downloader2['default'].execDownload(fileName, extension, content, contentType);
	  },
	
	
	  /**
	   * Whether need encode type or not
	   * @returns {boolean}
	   * @private
	   */
	  _isNeedDataEncodeing: function _isNeedDataEncodeing() {
	    var isDownloadAttributeSupported = _tuiCodeSnippet2['default'].isExisty(document.createElement('a').download);
	    var isMsSaveOrOpenBlobSupported = window.Blob && window.navigator.msSaveOrOpenBlob;
	
	    if (!isMsSaveOrOpenBlobSupported && isDownloadAttributeSupported) {
	      return true;
	    }
	
	    return false;
	  },
	
	
	  /**
	   * Returns data extensions
	   * @returns {Array.<string>}
	   */
	  getExtensions: function getExtensions() {
	    return dataExtensions;
	  }
	};
	
	/**
	 * Get pivoted second dimension array from table to use element.innerText
	 * @param {rawData} rawData - chart's raw data
	 * @returns {Array.<Array>}
	 * @private
	 */
	function _get2DArrayFromRawData(rawData) {
	  var resultArray = [];
	  var isHeatMap = rawData.categories && _tuiCodeSnippet2['default'].isExisty(rawData.categories.x);
	  var isBullet = rawData.series && _tuiCodeSnippet2['default'].isExisty(rawData.series.bullet);
	  var return2DArrayData = false;
	
	  if (rawData) {
	    var categories = void 0;
	
	    if (isHeatMap) {
	      return2DArrayData = _get2DArrayFromHeatmapRawData(rawData);
	    } else if (isBullet) {
	      return2DArrayData = _get2DArrayFromBulletRawData(rawData);
	    } else if (rawData.categories) {
	      categories = rawData.categories;
	    }
	    if (return2DArrayData) {
	      return return2DArrayData;
	    }
	
	    resultArray.push([''].concat(categories));
	
	    Object.values(rawData.series || {}).forEach(function (seriesDatum) {
	      seriesDatum.forEach(function (seriesItem) {
	        var data = _tuiCodeSnippet2['default'].isArray(seriesItem.data) ? seriesItem.data : [seriesItem.data];
	
	        resultArray.push([seriesItem.name].concat(_toConsumableArray(data)));
	      });
	    });
	  }
	
	  return resultArray;
	}
	
	/**
	 * Make table head data for Excel
	 * @param {number} maxRangeCount - max range count
	 * @param {number} maxMarkerCount - max marker count
	 * @returns {Array.<string>} - table head data
	 * @private
	 */
	function _makeTHeadForBullet(maxRangeCount, maxMarkerCount) {
	  var tableHead = ['', _const2['default'].BULLET_TYPE_ACTUAL];
	
	  for (var i = 0; i < maxRangeCount; i += 1) {
	    tableHead.push(_const2['default'].BULLET_TYPE_RANGE + i);
	  }
	
	  for (var _i = 0; _i < maxMarkerCount; _i += 1) {
	    tableHead.push(_const2['default'].BULLET_TYPE_MARKER + _i);
	  }
	
	  return tableHead;
	}
	
	/**
	 * Make table cells from bullet ranges
	 * @param {Array.<Array.<number>>} ranges - series item's ranges data
	 * @param {number} maxRangeCount - max range count
	 * @returns {Array.<number>} - cells containing range data
	 * @private
	 */
	function _makeTCellsFromBulletRanges(ranges, maxRangeCount) {
	  var cells = [];
	
	  for (var i = 0; i < maxRangeCount; i += 1) {
	    var dataText = '';
	
	    if (ranges && ranges[i]) {
	      var rangeStart = ranges[i].length > 0 ? ranges[i][0] : '';
	      var rangeEnd = ranges[i].length > 1 ? ranges[i][1] : '';
	
	      dataText = rangeStart + '~' + rangeEnd;
	    }
	    cells.push(dataText);
	  }
	
	  return cells;
	}
	
	/**
	 * Make table cells from bullet markers
	 * @param {Array.<Array.<number>>} markers - series item's markers data
	 * @param {number} maxMarkerCount - max marker count
	 * @returns {Array.<number>} - cells containing marker data
	 * @private
	 */
	function _makeTCellsFromBulletMarkers(markers, maxMarkerCount) {
	  var cells = [];
	
	  for (var i = 0; i < maxMarkerCount; i += 1) {
	    var dataText = markers && markers[i] ? markers[i] : '';
	    cells.push(dataText);
	  }
	
	  return cells;
	}
	
	/**
	 * Make table data for importing in excel, by using bullet chart raw data
	 * @param {object} rawData - raw data
	 * @param {object} [options] download option
	 * @returns {Array.<Array.<string>>} - table data for importing in excel
	 * @private
	 */
	function _get2DArrayFromBulletRawData(rawData) {
	  var resultArray = [];
	  var maxCounts = _calculateMaxCounts(rawData.series.bullet);
	  var maxRangeCount = maxCounts.maxRangeCount,
	      maxMarkerCount = maxCounts.maxMarkerCount;
	
	
	  resultArray.push(_makeTHeadForBullet(maxRangeCount, maxMarkerCount));
	
	  _tuiCodeSnippet2['default'].forEach(rawData.series.bullet, function (seriesItem) {
	    var rangeArray = _makeTCellsFromBulletRanges(seriesItem.ranges, maxRangeCount);
	    var markerArray = _makeTCellsFromBulletMarkers(seriesItem.markers, maxMarkerCount);
	    var row = [seriesItem.name, seriesItem.data].concat(_toConsumableArray(rangeArray), _toConsumableArray(markerArray));
	    resultArray.push(row);
	  });
	
	  return resultArray;
	}
	
	/**
	 * Calculate maxinum count of range and marker property
	 * @param {object} bulletSeries - raw series data of bullet chart
	 * @returns {object} - maximum count of range and marker property
	 * @private
	 */
	function _calculateMaxCounts(bulletSeries) {
	  var maxRangeCount = 0;
	  var maxMarkerCount = 0;
	
	  _tuiCodeSnippet2['default'].forEach(bulletSeries, function (series) {
	    maxRangeCount = Math.max(maxRangeCount, series.ranges.length);
	    maxMarkerCount = Math.max(maxMarkerCount, series.markers.length);
	  });
	
	  return {
	    maxRangeCount: maxRangeCount,
	    maxMarkerCount: maxMarkerCount
	  };
	}
	
	/**
	 * Make table data for importing in excel, by using heatmap chart raw data
	 * @param {object} rawData - raw data
	 * @returns {Array.<Array.<string>>} - table data for importing in excel
	 * @private
	 */
	function _get2DArrayFromHeatmapRawData(rawData) {
	  var resultArray = [];
	
	  resultArray.push([''].concat(_toConsumableArray(rawData.categories.x)));
	
	  _tuiCodeSnippet2['default'].forEach(rawData.series, function (seriesDatum) {
	    _tuiCodeSnippet2['default'].forEach(seriesDatum, function (seriesItem, index) {
	      var row = [rawData.categories.y[index]].concat(_toConsumableArray(seriesItem));
	      resultArray.push(row);
	    });
	  });
	
	  return resultArray;
	}
	
	/**
	 * Get table element from chart data 2D array for xls content
	 * @param {Array.<Array<*>>} chartData2DArray - chart data 2D array
	 * @returns {string}
	 * @private
	 */
	function _getTableElementStringForXls(chartData2DArray) {
	  var tableElementString = '<table>';
	  _tuiCodeSnippet2['default'].forEach(chartData2DArray, function (row, rowIndex) {
	    var cellTagName = rowIndex === 0 ? 'th' : 'td';
	
	    tableElementString += '<tr>';
	
	    _tuiCodeSnippet2['default'].forEach(row, function (cell, cellIndex) {
	      var cellNumberClass = rowIndex !== 0 || cellIndex === 0 ? ' class="number"' : '';
	      var cellString = '<' + cellTagName + cellNumberClass + '>' + cell + '</' + cellTagName + '>';
	
	      tableElementString += cellString;
	    });
	
	    tableElementString += '</tr>';
	  });
	
	  tableElementString += '</table>';
	
	  return tableElementString;
	}
	
	/**
	 * Make xls file with chart series data
	 * @param {Array.<Array.<object>>} chartData2DArray - chart chartData2DArray
	 * @returns {string} base64 xls file content
	 * @private
	 */
	function _makeXlsBodyWithRawData(chartData2DArray) {
	  var xlsString = _renderUtil2['default'].oneLineTrim(_templateObject, _getTableElementStringForXls(chartData2DArray));
	
	  return xlsString;
	}
	
	/**
	 * Make csv text with chart series data
	 * @param {Array.<Array.<object>>} chartData2DArray - chart chartData2DArray
	 * @param {object} [option] - download option
	 * @param {object} [option.itemDelimiter = ','] - item delimiter
	 * @param {object} [option.lineDelimiter = '\n'] - line delimiter
	 * @returns {string} URI encoded csv text
	 * @private
	 */
	function _makeCsvBodyWithRawData(chartData2DArray) {
	  var option = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  var _option$lineDelimiter = option.lineDelimiter,
	      lineDelimiter = _option$lineDelimiter === undefined ? '\n' : _option$lineDelimiter,
	      _option$itemDelimiter = option.itemDelimiter,
	      itemDelimiter = _option$itemDelimiter === undefined ? ',' : _option$itemDelimiter;
	
	  var lastRowIndex = chartData2DArray.length - 1;
	  var csvText = '';
	
	  _tuiCodeSnippet2['default'].forEachArray(chartData2DArray, function (row, rowIndex) {
	    var lastCellIndex = row.length - 1;
	
	    _tuiCodeSnippet2['default'].forEachArray(row, function (cell, cellIndex) {
	      var cellContent = _tuiCodeSnippet2['default'].isNumber(cell) ? cell : '"' + cell + '"';
	
	      csvText += cellContent;
	
	      if (cellIndex < lastCellIndex) {
	        csvText += itemDelimiter;
	      }
	    });
	
	    if (rowIndex < lastRowIndex) {
	      csvText += lineDelimiter;
	    }
	  });
	
	  return csvText;
	}
	
	// export private methods for Test
	Object.assign(dataExporter, {
	  _makeCsvBodyWithRawData: _makeCsvBodyWithRawData,
	  _makeXlsBodyWithRawData: _makeXlsBodyWithRawData,
	  _get2DArrayFromRawData: _get2DArrayFromRawData,
	  _get2DArrayFromBulletRawData: _get2DArrayFromBulletRawData,
	  _get2DArrayFromHeatmapRawData: _get2DArrayFromHeatmapRawData,
	  _makeTCellsFromBulletRanges: _makeTCellsFromBulletRanges,
	  _makeTCellsFromBulletMarkers: _makeTCellsFromBulletMarkers,
	  _makeTHeadForBullet: _makeTHeadForBullet
	});
	
	exports['default'] = dataExporter;

/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var DOWNLOAD_HANDLERS = {
	  downloadAttribute: downloadWithAnchorElementDownloadAttribute,
	  msSaveOrOpenBlob: downloadWithMsSaveOrOpenBlob
	};
	
	/**
	 * Return download method name of current browser supports
	 * @returns {string}
	 * @ignore
	 */
	/**
	 * @fileOverview File downloader for client-side download
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function getDownloadMethod() {
	  var isDownloadAttributeSupported = _tuiCodeSnippet2['default'].isExisty(document.createElement('a').download);
	  var isMsSaveOrOpenBlobSupported = window.Blob && window.navigator.msSaveOrOpenBlob;
	  var method = void 0;
	
	  if (isMsSaveOrOpenBlobSupported) {
	    method = 'msSaveOrOpenBlob';
	  } else if (isDownloadAttributeSupported) {
	    method = 'downloadAttribute';
	  }
	
	  return method;
	}
	
	/**
	 * Base64 string to blob
	 * original source ref: https://github.com/miguelmota/base64toblob/blob/master/base64toblob.js
	 * Licence: MIT Licence
	 * @param {string} base64String - base64 string
	 * @returns {Blob}
	 * @ignore
	 */
	function base64toBlob(base64String) {
	  var contentType = base64String.substr(0, base64String.indexOf(';base64,')).substr(base64String.indexOf(':') + 1);
	  var sliceSize = 1024;
	  var byteCharacters = atob(base64String.substr(base64String.indexOf(',') + 1));
	  var byteArrays = [];
	
	  for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
	    var slice = byteCharacters.slice(offset, offset + sliceSize);
	    var byteNumbers = new Array(slice.length);
	
	    for (var i = 0; i < slice.length; i += 1) {
	      byteNumbers[i] = slice.charCodeAt(i);
	    }
	
	    var byteArray = new window.Uint8Array(byteNumbers);
	
	    byteArrays.push(byteArray);
	  }
	
	  var resultBlob = new Blob(byteArrays, { type: contentType });
	
	  return resultBlob;
	}
	
	/**
	 * Return given extension type is image format
	 * @param {string} extension extension
	 * @returns {boolean}
	 * @ignore
	 */
	function isImageExtension(extension) {
	  return _arrayUtil2['default'].any(_const2['default'].IMAGE_EXTENSIONS, function (imageExtension) {
	    return extension === imageExtension;
	  });
	}
	
	/**
	 * Download content to file with msSaveOrOpenBlob
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @param {string} contentType - file content type
	 * @ignore
	 */
	function downloadWithMsSaveOrOpenBlob(fileName, extension, content, contentType) {
	  var blobObject = isImageExtension(extension) ? base64toBlob(content) : new Blob([content], { type: contentType });
	  window.navigator.msSaveOrOpenBlob(blobObject, fileName + '.' + extension);
	}
	
	/**
	 * Download content to file with anchor element's download attribute
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @ignore
	 */
	function downloadWithAnchorElementDownloadAttribute(fileName, extension, content) {
	  if (content) {
	    var anchorElement = document.createElement('a');
	
	    anchorElement.href = content;
	    anchorElement.target = '_blank';
	    anchorElement.download = fileName + '.' + extension;
	
	    document.body.appendChild(anchorElement);
	
	    anchorElement.click();
	    anchorElement.remove();
	  }
	}
	
	/**
	 * Download content to file with given filename and extension
	 * @param {string} fileName - file name
	 * @param {string} extension - file extension
	 * @param {string} content - file content
	 * @param {string} contentType - file content type
	 * @ignore
	 */
	function execDownload(fileName, extension, content, contentType) {
	  var downloadMethod = getDownloadMethod();
	
	  if (downloadMethod && _tuiCodeSnippet2['default'].isString(content)) {
	    DOWNLOAD_HANDLERS[downloadMethod](fileName, extension, content, contentType);
	  }
	}
	
	exports['default'] = {
	  execDownload: execDownload
	};

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _downloader = __webpack_require__(54);
	
	var _downloader2 = _interopRequireDefault(_downloader);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * @fileOverview Chart image exporter
	                                                                                                                                                                                                     * @author NHN.
	                                                                                                                                                                                                     *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                     */
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var isIE10OrIE11 = browser.msie && (browser.version === 10 || browser.version === 11);
	var DOMURL = window.URL || window.webkitURL || window;
	var imageExtensions = [].concat(_toConsumableArray(_const2['default'].IMAGE_EXTENSIONS));
	
	/**
	 * Return svg outerHTML string
	 * @param {HTMLElement} svgElement svg element
	 * @returns {string}
	 * @ignore
	 */
	function getSvgString(svgElement) {
	  var svgParent = svgElement.parentNode;
	  var tempWrapper = document.createElement('DIV');
	
	  tempWrapper.appendChild(svgElement);
	
	  var svgString = tempWrapper.innerHTML;
	
	  svgParent.appendChild(svgElement);
	
	  tempWrapper = null;
	  svgParent = null;
	
	  return svgString;
	}
	
	/**
	 * Download with SVG string and canvg
	 * @param {HTMLElement} canvas canvas element
	 * @param {string} svgString svg HTML string
	 * @param {string} fileName file name
	 * @param {string} extension file extension
	 * @ignore
	 */
	function downloadSvgWithCanvg(canvas, svgString, fileName, extension) {
	  var ctx = canvas.getContext('2d');
	
	  // remove name space for IE
	  if (isIE10OrIE11) {
	    svgString = svgString.replace(/xmlns:NS1=""/, '');
	    svgString = svgString.replace(/NS1:xmlns:xlink="http:\/\/www\.w3\.org\/1999\/xlink"/, '');
	    svgString = svgString.replace(/xmlns="http:\/\/www\.w3\.org\/2000\/svg"/, '');
	    svgString = svgString.replace(/xmlns:xlink="http:\/\/www\.w3\.org\/1999\/xlink"/, '');
	  }
	
	  ctx.drawSvg(svgString, 0, 0);
	
	  _downloader2['default'].execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));
	}
	
	/**
	 * Download with SVG string and blob URL
	 * @param {HTMLElement} canvas canvas element
	 * @param {string} svgString svg HTML string
	 * @param {string} fileName file name
	 * @param {string} extension file extension
	 * @ignore
	 */
	function downloadSvgWithBlobURL(canvas, svgString, fileName, extension) {
	  var ctx = canvas.getContext('2d');
	  var blob = new Blob([svgString], { type: 'image/svg+xml' });
	  var url = DOMURL.createObjectURL(blob);
	  var img = new Image();
	
	  img.onload = function () {
	    ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
	
	    _downloader2['default'].execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));
	
	    DOMURL.revokeObjectURL(url);
	  };
	
	  img.src = url;
	}
	
	exports['default'] = {
	  /**
	   * Download image with png format
	   * @param {string} fileName - file name to save
	   * @param {string} extension - extension type
	   * @param {HTMLElement} imageSourceElement - image source element
	   */
	  downloadImage: function downloadImage(fileName, extension, imageSourceElement) {
	    var canvas = void 0;
	
	    if (imageSourceElement.tagName === 'svg') {
	      var parentNode = imageSourceElement.parentNode;
	
	      var svgString = getSvgString(imageSourceElement);
	
	      canvas = document.createElement('canvas');
	
	      canvas.width = parentNode.offsetWidth;
	      canvas.height = parentNode.offsetHeight;
	
	      if (isIE10OrIE11) {
	        downloadSvgWithCanvg(canvas, svgString, fileName, extension);
	      } else {
	        downloadSvgWithBlobURL(canvas, svgString, fileName, extension);
	      }
	    } else if (imageSourceElement.tagName === 'canvas') {
	      canvas = imageSourceElement;
	
	      _downloader2['default'].execDownload(fileName, extension, canvas.toDataURL('image/' + extension, 1));
	    }
	  },
	
	
	  /**
	   * Returns data extensions
	   * @returns {Array.<string>}
	   */
	  getExtensions: function getExtensions() {
	    return imageExtensions;
	  }
	};

/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var bindHandlerMap = {};
	
	/**
	 * Event listener.
	 * @module eventListener
	 * @private */
	/**
	 * @fileoverview Event listener.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	var eventListener = {
	  /**
	   * Add event listener for IE.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target target element
	   * @param {string} type event type
	   * @param {function} handler callback function
	   * @param {?object} context context for callback
	   * @private
	   */
	  _attachEvent: function _attachEvent(target, type, handler, context) {
	    var bindHandler = void 0;
	
	    if (context) {
	      bindHandler = handler.bind(context);
	    } else {
	      bindHandler = handler;
	    }
	
	    bindHandlerMap[type + handler] = bindHandler;
	    target.attachEvent('on' + type, bindHandler);
	  },
	
	
	  /**
	   * Add event listener for other browsers.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string} type - event type
	   * @param {function} handler - handler
	   * @param {object} [context] - context for handler
	   * @private
	   */
	  _addEventListener: function _addEventListener(target, type, handler, context) {
	    var bindHandler = void 0;
	
	    if (context) {
	      bindHandler = _tuiCodeSnippet2['default'].bind(handler, context);
	    } else {
	      bindHandler = handler;
	    }
	
	    bindHandlerMap[type + handler] = bindHandler;
	    target.addEventListener(type, bindHandler);
	  },
	
	
	  /**
	   * Bind DOM event.
	   * @memberOf module:eventListener
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target target element
	   * @param {string} type event type
	   * @param {function} handler handler function
	   * @param {object} [context] - context for handler
	   * @private
	   */
	  _bindEvent: function _bindEvent(target, type, handler, context) {
	    var bindEvent = void 0;
	
	    if ('addEventListener' in target) {
	      bindEvent = this._addEventListener;
	    } else if ('attachEvent' in target) {
	      bindEvent = this._attachEvent;
	    }
	    eventListener._bindEvent = bindEvent;
	
	    bindEvent(target, type, handler, context);
	  },
	
	
	  /**
	   * Bind DOM events.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string | object} types - type or map of type and handler
	   * @param {function | object} [handler] - handler or context
	   * @param {object} [context] - context
	   */
	  on: function on(target, types, handler, context) {
	    var handlerMap = {};
	    if (_tuiCodeSnippet2['default'].isString(types)) {
	      handlerMap[types] = handler;
	    } else {
	      handlerMap = types;
	      context = handler;
	    }
	
	    _tuiCodeSnippet2['default'].forEach(handlerMap, function (_handler, type) {
	      eventListener._bindEvent(target, type, _handler, context);
	    });
	  },
	
	
	  /**
	   * Remove event listener for IE.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string} type - event type
	   * @param {function} handler - handler
	   * @private
	   */
	  _detachEvent: function _detachEvent(target, type, handler) {
	    if (bindHandlerMap[type + handler]) {
	      target.detachEvent('on' + type, bindHandlerMap[type + handler]);
	      delete bindHandlerMap[type + handler];
	    }
	  },
	
	
	  /**
	   * Add event listener for other browsers.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string} type - event type
	   * @param {function} handler - handler
	   * @private
	   */
	  _removeEventListener: function _removeEventListener(target, type, handler) {
	    target.removeEventListener(type, bindHandlerMap[type + handler]);
	    delete bindHandlerMap[type + handler];
	  },
	
	
	  /**
	   * Unbind DOM event.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string} type - event type
	   * @param {function} handler - handler
	   * @private
	   */
	  _unbindEvent: function _unbindEvent(target, type, handler) {
	    var unbindEvent = void 0;
	    if ('removeEventListener' in target) {
	      unbindEvent = eventListener._removeEventListener;
	    } else if ('detachEvent' in target) {
	      unbindEvent = eventListener._detachEvent;
	    }
	    eventListener._unbindEvent = unbindEvent;
	
	    unbindEvent(target, type, handler);
	  },
	
	
	  /**
	   * Unbind DOM events.
	   * @memberOf module:eventListener
	   * @param {HTMLElement} target - target element
	   * @param {string | object} types - type or map of type and handler
	   * @param {function} [handler] - handler
	   */
	  off: function off(target, types, handler) {
	    var handlerMap = {};
	    if (_tuiCodeSnippet2['default'].isString(types)) {
	      handlerMap[types] = handler;
	    } else {
	      handlerMap = types;
	    }
	
	    _tuiCodeSnippet2['default'].forEach(handlerMap, function (_handler, type) {
	      eventListener._unbindEvent(target, type, _handler);
	    });
	  }
	};
	
	exports['default'] = eventListener;

/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = legendFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _legendModel = __webpack_require__(58);
	
	var _legendModel2 = _interopRequireDefault(_legendModel);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview  Legend component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var LEGEND_ICON_HEIGHT = _const2['default'].LEGEND_ICON_HEIGHT,
	    LINE_MARGIN_TOP = _const2['default'].LINE_MARGIN_TOP,
	    LEGEND_AREA_H_PADDING = _const2['default'].LEGEND_AREA_H_PADDING,
	    PUBLIC_EVENT_PREFIX = _const2['default'].PUBLIC_EVENT_PREFIX;
	
	var Legend = function () {
	  /**
	   * Legend component.
	   * @constructs Legend
	   * @private
	   * @param {object} params parameters
	   *      @param {object} params.theme - axis theme
	   *      @param {?Array.<string>} params.seriesTypes - series types
	   *      @param {string} params.chart - chart type
	   *      @param {object} params.dataProcessor - data processor
	   *      @param {object} params.eventBus - chart event bus
	   */
	  function Legend(params) {
	    _classCallCheck(this, Legend);
	
	    /**
	     * legend theme
	     * @type {object}
	     */
	    this.theme = params.theme;
	
	    /**
	     * options
	     * @type {Object}
	     */
	    this.options = params.options || {};
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * series types
	     * @type {?Array.<string>}
	     */
	    this.seriesTypes = params.seriesTypes || [this.chartType];
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = params.eventBus;
	
	    /**
	     * Legend view className
	     */
	    this.className = 'tui-chart-legend-area';
	
	    /**
	     * DataProcessor instance
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * legend model
	     */
	    this.legendModel = new _legendModel2['default']({
	      theme: this.theme,
	      labels: params.dataProcessor.getLegendLabels(),
	      legendData: params.dataProcessor.getLegendData(),
	      seriesTypes: this.seriesTypes,
	      chartType: this.chartType
	    });
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(_const2['default'].COMPONENT_TYPE_RAPHAEL, 'legend');
	
	    /**
	     * Paper for rendering legend
	     * @type {object}
	     */
	    this.paper = null;
	
	    this.drawingType = _const2['default'].COMPONENT_TYPE_RAPHAEL;
	  }
	
	  /**
	   * Preset components for setData
	   * @param {object} theme theme object
	   * @ignore
	   */
	
	
	  Legend.prototype.presetForChangeData = function presetForChangeData() {
	    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.theme;
	
	    this.theme = theme;
	
	    this.legendModel = new _legendModel2['default']({
	      theme: this.theme,
	      labels: this.dataProcessor.getLegendLabels(),
	      legendData: this.dataProcessor.getLegendData(),
	      seriesTypes: this.seriesTypes,
	      chartType: this.chartType
	    });
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      }
	   * }} data - bounds data
	   * @private
	   */
	
	
	  Legend.prototype._setDataForRendering = function _setDataForRendering(data) {
	    if (data) {
	      this.layout = data.layout;
	      this.paper = data.paper;
	    }
	  };
	
	  /**
	   * Render legend component.
	   * @param {object} data - bounds data
	   */
	
	
	  Legend.prototype._render = function _render(data) {
	    this._setDataForRendering(data);
	    this.legendSet = this._renderLegendArea(data.paper);
	  };
	
	  /**
	   * Render legend component and listen legend event.
	   * @param {object} data - bounds data
	   */
	
	
	  Legend.prototype.render = function render(data) {
	    this._render(data);
	    this._listenEvents();
	  };
	
	  /**
	   * Rerender.
	   * @param {object} data - bounds data
	   */
	
	
	  Legend.prototype.rerender = function rerender(data) {
	    this.legendSet.remove();
	
	    this._render(data);
	  };
	
	  /**
	   * Rerender, when resizing chart.
	   * @param {object} data - bounds data
	   */
	
	
	  Legend.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * Get legend rendering data
	   * @param {Array} legendData legned data
	   * @param {number} labelHeight lebel height
	   * @param {Array.<number>} labelWidths label widths
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  Legend.prototype._getLegendRenderingData = function _getLegendRenderingData(legendData, labelHeight, labelWidths) {
	    var _this = this;
	
	    var maxWidth = this.options.maxWidth;
	
	    var colorByPoint = (_predicate2['default'].isBarTypeChart(this.chartType) || _predicate2['default'].isBoxplotChart(this.chartType)) && this.dataProcessor.options.series.colorByPoint;
	
	    return legendData.map(function (legendDatum, index) {
	      var checkbox = _this.options.showCheckbox === false ? null : {
	        checked: _this.legendModel.isCheckedIndex(index)
	      };
	      var legendLabel = legendDatum.label;
	
	      if (maxWidth) {
	        legendLabel = _raphaelRenderUtil2['default'].getEllipsisText(legendLabel, maxWidth, _this.theme.label);
	      }
	
	      return {
	        checkbox: checkbox,
	        iconType: legendDatum.chartType || 'rect',
	        colorByPoint: colorByPoint,
	        index: index,
	        theme: legendDatum.theme,
	        label: legendLabel,
	        labelHeight: labelHeight,
	        labelWidth: labelWidths[index],
	        isUnselected: _this.legendModel.isUnselectedIndex(index)
	      };
	    });
	  };
	
	  /**
	   * Render legend area.
	   * @param {object} paper paper object
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  Legend.prototype._renderLegendArea = function _renderLegendArea(paper) {
	    var legendData = this.legendModel.getData();
	    var graphRenderer = this.graphRenderer;
	
	    var isHorizontal = _predicate2['default'].isHorizontalLegend(this.options.align);
	    var basePosition = this.layout.position;
	    var labelWidths = graphRenderer.makeLabelWidths(legendData, this.theme.label, this.options.maxWidth);
	    var labelTheme = legendData[0] ? legendData[0].theme : {};
	    var labelHeight = graphRenderer.getRenderedLabelHeight('DEFAULT_TEXT', labelTheme) - 1;
	    var labelCount = labelWidths.length;
	    var legendItemHeight = Math.max(LEGEND_ICON_HEIGHT, labelHeight);
	    var dimensionHeight = (LINE_MARGIN_TOP + legendItemHeight) * (isHorizontal ? 1 : labelCount);
	    var top = basePosition.top;
	    var left = basePosition.left;
	
	
	    if (!_predicate2['default'].isLegendAlignLeft(this.options.align)) {
	      left += LEGEND_AREA_H_PADDING;
	    }
	
	    return graphRenderer.render({
	      paper: paper,
	      legendData: this._getLegendRenderingData(legendData, labelHeight, labelWidths),
	      isHorizontal: isHorizontal,
	      position: {
	        left: left,
	        top: top
	      },
	      dimension: {
	        height: dimensionHeight,
	        width: this.layout.dimension.width
	      },
	      labelTheme: this.theme.label,
	      labelWidths: labelWidths,
	      eventBus: this.eventBus
	    });
	  };
	
	  /**
	   * Fire onChangeCheckedLegends event.
	   * @private
	   */
	
	
	  Legend.prototype._fireChangeCheckedLegendsEvent = function _fireChangeCheckedLegendsEvent() {
	    this.eventBus.fire('changeCheckedLegends', this.legendModel.getCheckedIndexes());
	  };
	
	  /**
	   * Fire changeCheckedLegends public event.
	   * @private
	   */
	
	
	  Legend.prototype._fireChangeCheckedLegendsPublicEvent = function _fireChangeCheckedLegendsPublicEvent() {
	    this.eventBus.fire(PUBLIC_EVENT_PREFIX + 'changeCheckedLegends', this.legendModel.getCheckedIndexes());
	  };
	
	  /**
	   * Fire selectLegend event.
	   * @param {{chartType: string, index: number}} data data
	   * @private
	   */
	
	
	  Legend.prototype._fireSelectLegendEvent = function _fireSelectLegendEvent(data) {
	    var index = this.legendModel.getSelectedIndex();
	    var legendIndex = !_tuiCodeSnippet2['default'].isNull(index) ? data.seriesIndex : index;
	
	    this.eventBus.fire('selectLegend', data.chartType, legendIndex);
	  };
	
	  /**
	   * Fire selectLegend public event.
	   * @param {{label: string, chartType: string, index: number}} data data
	   * @private
	   */
	
	
	  Legend.prototype._fireSelectLegendPublicEvent = function _fireSelectLegendPublicEvent(_ref) {
	    var label = _ref.label,
	        index = _ref.index,
	        chartType = _ref.chartType;
	
	    this.eventBus.fire(PUBLIC_EVENT_PREFIX + 'selectLegend', {
	      legend: label,
	      chartType: chartType,
	      index: index
	    });
	  };
	
	  /**
	   * Select legend.
	   * @param {number} index index
	   * @private
	   */
	
	
	  Legend.prototype._selectLegend = function _selectLegend(index) {
	    var data = this.legendModel.getDatum(index);
	
	    this.legendModel.toggleSelectedIndex(index);
	
	    if (!_tuiCodeSnippet2['default'].isNull(this.legendModel.getSelectedIndex()) && !this.legendModel.isCheckedSelectedIndex()) {
	      this.legendModel.checkSelectedIndex();
	      this._fireChangeCheckedLegendsEvent();
	    }
	
	    this.dataProcessor.selectLegendIndex = this.legendModel.getSelectedIndex();
	    this.graphRenderer.selectLegend(this.dataProcessor.selectLegendIndex, this.legendSet);
	
	    this._fireSelectLegendEvent(data);
	    this._fireSelectLegendPublicEvent(data);
	  };
	
	  /**
	   * Get checked indexes.
	   * @returns {Array} checked indexes
	   * @private
	   */
	
	
	  Legend.prototype._getCheckedIndexes = function _getCheckedIndexes() {
	    var checkedIndexes = [];
	
	    this.legendModel.checkedWholeIndexes.forEach(function (checkbox, index) {
	      if (checkbox) {
	        checkedIndexes.push(index);
	      }
	    });
	
	    return checkedIndexes;
	  };
	
	  /**
	   * Get checked indexes.
	   * @returns {{column: ?Array.<string>, line: ?Array.<string>}} object data that whether series has checked or not
	   * @ignore
	   */
	
	
	  Legend.prototype.getCheckedIndexes = function getCheckedIndexes() {
	    return this.legendModel.getCheckedIndexes();
	  };
	
	  /**
	   * Check legend.
	   * @private
	   */
	
	
	  Legend.prototype._checkLegend = function _checkLegend() {
	    var selectedData = this.legendModel.getSelectedDatum();
	
	    if (!this.legendModel.isCheckedSelectedIndex()) {
	      this.legendModel.updateSelectedIndex(null);
	    }
	
	    this._fireChangeCheckedLegendsEvent();
	    this._fireChangeCheckedLegendsPublicEvent();
	
	    if (selectedData) {
	      this._fireSelectLegendEvent(selectedData);
	    }
	  };
	
	  /**
	   * On click event handler.
	   * @param {number} index checkbox index
	   * @private
	   */
	
	
	  Legend.prototype._checkboxClick = function _checkboxClick(index) {
	    this.legendModel.toggleCheckedIndex(index);
	
	    var checkedIndexes = this._getCheckedIndexes();
	
	    if (checkedIndexes.length > 0) {
	      this.legendModel.updateCheckedLegendsWith(checkedIndexes);
	      this._checkLegend();
	    } else {
	      this.legendModel.toggleCheckedIndex(index);
	    }
	  };
	
	  /**
	   * On click event handler.
	   * @param {number} index selected index
	   * @private
	   */
	
	
	  Legend.prototype._labelClick = function _labelClick(index) {
	    this._selectLegend(index);
	  };
	
	  /**
	   * Listen legend events
	   * @private
	   */
	
	
	  Legend.prototype._listenEvents = function _listenEvents() {
	    this.eventBus.on('checkboxClicked', this._checkboxClick, this);
	    this.eventBus.on('labelClicked', this._labelClick, this);
	  };
	
	  return Legend;
	}();
	
	_tuiCodeSnippet2['default'].CustomEvents.mixin(Legend);
	
	/**
	 * Factory for Legend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	function legendFactory(params) {
	  var options = params.options,
	      seriesTypes = params.dataProcessor.seriesTypes,
	      chartType = params.chartOptions.chartType;
	
	  var isLegendVisible = _tuiCodeSnippet2['default'].isUndefined(options.visible) ? true : options.visible;
	  var legend = null;
	
	  if (isLegendVisible) {
	    params.seriesTypes = seriesTypes;
	    params.chartType = chartType;
	
	    // @todo should extends additionalParams added when addComponents(), should grasp the omitted
	    legend = new Legend(params);
	  }
	
	  return legend;
	}
	
	legendFactory.componentType = 'legend';
	legendFactory.Legend = Legend;

/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview LegendModel is a model for legend area(checkbox, icon, label text)
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var LegendModel = function () {
	  /**
	   * LegendModel is legend model.
	   * @constructs LegendModel
	   * @private
	   * @param {object} params parameters
	   *      @param {number} params.labels legend labels
	   *      @param {object} params.bound axis bound
	   *      @param {object} params.theme axis theme
	   */
	  function LegendModel(params) {
	    _classCallCheck(this, LegendModel);
	
	    /**
	     * legend theme
	     * @type {Object}
	     */
	    this.theme = params.theme;
	
	    /**
	     * legend labels
	     * @type {Array.<string> | {column: ?Array.<string>, line: ?Array.<string>}}
	     */
	    this.labels = params.labels;
	
	    /**
	     * label infos
	     * @type {Array.<{chartType: string, label: string, index: number}>}
	     */
	    this.legendData = params.legendData;
	
	    /**
	     * chart types
	     * @type {?Array.<string>}
	     */
	    this.seriesTypes = params.seriesTypes || [];
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * Legend data
	     * @type {?Array}
	     */
	    this.data = null;
	
	    /**
	     * Selected legend index.
	     * @type {?number}
	     */
	    this.selectedIndex = null;
	
	    /**
	     * sending data to series
	     * @type {object}
	     */
	    this.checkedIndexesMap = {};
	
	    /**
	     * checked indexes
	     * @type {Array}
	     */
	    this.checkedWholeIndexes = [];
	
	    this._setData();
	    this._initCheckedIndexes();
	  }
	
	  /**
	   * Initialize checked data.
	   * @private
	   */
	
	
	  LegendModel.prototype._initCheckedIndexes = function _initCheckedIndexes() {
	    var _this = this;
	
	    var checkedIndexes = [];
	    this.legendData.forEach(function (_ref, index) {
	      var visible = _ref.visible;
	
	      if (visible) {
	        checkedIndexes.push(index);
	      }
	      _this.checkedWholeIndexes[index] = visible;
	    });
	
	    this.updateCheckedLegendsWith(checkedIndexes);
	  };
	
	  /**
	   * Set theme to legend data.
	   * @param {Array.<object>} legendData - legend data
	   * @param {{
	   *     colors: Array.<string>,
	   *     borderColor: ?string
	   *     }} colorTheme - legend theme
	   * @param {Array.<boolean>} [checkedIndexes] - checked indexes
	   * @private
	   */
	
	
	  LegendModel.prototype._setThemeToLegendData = function _setThemeToLegendData(legendData, _ref2, checkedIndexes) {
	    var colors = _ref2.colors,
	        borderColor = _ref2.borderColor;
	
	    var seriesIndex = 0;
	
	    legendData.forEach(function (datum, index) {
	      var itemTheme = {
	        color: colors[index]
	      };
	
	      if (borderColor) {
	        itemTheme.borderColor = borderColor;
	      }
	
	      datum.theme = itemTheme;
	      datum.index = index;
	
	      if (!checkedIndexes || !_tuiCodeSnippet2['default'].isUndefined(checkedIndexes[index])) {
	        datum.seriesIndex = seriesIndex;
	        seriesIndex += 1;
	      } else {
	        datum.seriesIndex = -1;
	      }
	    });
	  };
	
	  /**
	   * Set legend data.
	   * @private
	   */
	
	
	  LegendModel.prototype._setData = function _setData() {
	    var _this2 = this;
	
	    var theme = this.theme,
	        chartType = this.chartType,
	        seriesTypes = this.seriesTypes,
	        legendData = this.legendData,
	        checkedIndexesMap = this.checkedIndexesMap;
	
	    var data = void 0;
	
	    if (!seriesTypes || seriesTypes.length < 2) {
	      this._setThemeToLegendData(legendData, theme[chartType], checkedIndexesMap[chartType]);
	      data = legendData;
	    } else {
	      var _ref3;
	
	      var startIndex = 0;
	      var dataItems = seriesTypes.map(function (seriesType) {
	        var labelLen = _this2.labels[seriesType].length;
	        var endIndex = startIndex + labelLen;
	        var slicedLegendData = legendData.slice(startIndex, endIndex);
	        var checkedIndexes = checkedIndexesMap[seriesType];
	
	        startIndex = endIndex;
	        _this2._setThemeToLegendData(slicedLegendData, theme[seriesType], checkedIndexes);
	
	        return slicedLegendData;
	      });
	      data = (_ref3 = []).concat.apply(_ref3, _toConsumableArray(dataItems));
	    }
	
	    this.data = data;
	  };
	
	  /**
	   * Get legend data.
	   * @returns {Array.<{chartType: string, label: string, theme: object}>} legend data
	   */
	
	
	  LegendModel.prototype.getData = function getData() {
	    return this.data;
	  };
	
	  /**
	   * Get legend datum by index.
	   * @param {number} index legend index
	   * @returns {{chartType: string, label: string, theme: object}} legend datum
	   */
	
	
	  LegendModel.prototype.getDatum = function getDatum(index) {
	    return this.data[index];
	  };
	
	  /**
	   * Get legend datum by label
	   * @param {string} label - legend label
	   * @returns {{chartType: string, label: string, theme: object}} legend datum
	   */
	
	
	  LegendModel.prototype.getDatumByLabel = function getDatumByLabel(label) {
	    var foundDatum = null;
	    this.data.forEach(function (datum) {
	      if (datum.label === label) {
	        foundDatum = datum;
	      }
	
	      return !foundDatum;
	    });
	
	    return foundDatum;
	  };
	
	  /**
	   * Get selected datum.
	   * @returns {{chartType: string, label: string, theme: Object}} legend datum
	   */
	
	
	  LegendModel.prototype.getSelectedDatum = function getSelectedDatum() {
	    return this.getDatum(this.selectedIndex);
	  };
	
	  /**
	   * Update selected index.
	   * @param {?number} value value
	   */
	
	
	  LegendModel.prototype.updateSelectedIndex = function updateSelectedIndex(value) {
	    this.selectedIndex = value;
	  };
	
	  /**
	   * Toggle selected index.
	   * @param {number} index legend index
	   */
	
	
	  LegendModel.prototype.toggleSelectedIndex = function toggleSelectedIndex(index) {
	    var selectedIndex = void 0;
	
	    if (this.selectedIndex === index) {
	      selectedIndex = null;
	    } else {
	      selectedIndex = index;
	    }
	
	    this.updateSelectedIndex(selectedIndex);
	  };
	
	  /**
	   * Get selected index.
	   * @returns {number} selected index
	   */
	
	
	  LegendModel.prototype.getSelectedIndex = function getSelectedIndex() {
	    return this.selectedIndex;
	  };
	
	  /**
	   * Whether unselected index or not.
	   * @param {number} index legend index
	   * @returns {boolean} true if selected
	   */
	
	
	  LegendModel.prototype.isUnselectedIndex = function isUnselectedIndex(index) {
	    return !_tuiCodeSnippet2['default'].isNull(this.selectedIndex) && this.selectedIndex !== index;
	  };
	
	  /**
	   * Whether checked selected index or not.
	   * @returns {boolean} true if checked
	   */
	
	
	  LegendModel.prototype.isCheckedSelectedIndex = function isCheckedSelectedIndex() {
	    return this.isCheckedIndex(this.selectedIndex);
	  };
	
	  /**
	   * Toggle checked index.
	   * @param {number} index legend index
	   */
	
	
	  LegendModel.prototype.toggleCheckedIndex = function toggleCheckedIndex(index) {
	    this.checkedWholeIndexes[index] = !this.checkedWholeIndexes[index];
	  };
	
	  /**
	   * Update checked index.
	   * @param {number} index legend index
	   * @private
	   */
	
	
	  LegendModel.prototype._updateCheckedIndex = function _updateCheckedIndex(index) {
	    this.checkedWholeIndexes[index] = true;
	  };
	
	  /**
	   * Whether checked index.
	   * @param {number} index legend index
	   * @returns {boolean} true if checked
	   */
	
	
	  LegendModel.prototype.isCheckedIndex = function isCheckedIndex(index) {
	    return !!this.checkedWholeIndexes[index];
	  };
	
	  /**
	   * Add sending datum.
	   * @param {number} index legend index
	   * @private
	   */
	
	
	  LegendModel.prototype._addSendingDatum = function _addSendingDatum(index) {
	    var legendDatum = this.getDatum(index);
	    var chartType = legendDatum.chartType,
	        chartIndex = legendDatum.index;
	
	
	    if (!this.checkedIndexesMap[chartType]) {
	      this.checkedIndexesMap[chartType] = new Array(this.labels[chartType].length).fill(false);
	    }
	    this.checkedIndexesMap[chartType][chartIndex] = true;
	  };
	
	  /**
	   * Check selected index;
	   */
	
	
	  LegendModel.prototype.checkSelectedIndex = function checkSelectedIndex() {
	    this._updateCheckedIndex(this.selectedIndex);
	    this._addSendingDatum(this.selectedIndex);
	    this._setData();
	  };
	
	  /**
	   * Get checked indexes.
	   * @returns {object} object data that whether series has checked or not
	   */
	
	
	  LegendModel.prototype.getCheckedIndexes = function getCheckedIndexes() {
	    var _this3 = this;
	
	    return Object.keys(this.checkedIndexesMap).reduce(function (booleanizeObject, chartType) {
	      booleanizeObject[chartType] = Array.from(_this3.checkedIndexesMap[chartType], function (checked) {
	        return !!checked;
	      });
	
	      return booleanizeObject;
	    }, {});
	  };
	
	  /**
	   * Reset checked data.
	   * @private
	   */
	
	
	  LegendModel.prototype._resetCheckedData = function _resetCheckedData() {
	    this.checkedWholeIndexes = [];
	    this.checkedIndexesMap = {};
	  };
	
	  /**
	   * Update checked legend's indexes
	   * @param {Array.<number>} indexes indexes
	   */
	
	
	  LegendModel.prototype.updateCheckedLegendsWith = function updateCheckedLegendsWith(indexes) {
	    var _this4 = this;
	
	    this._resetCheckedData();
	    indexes.forEach(function (index) {
	      _this4._updateCheckedIndex(index);
	      _this4._addSendingDatum(index);
	    });
	    this._setData();
	  };
	
	  return LegendModel;
	}();
	
	exports['default'] = LegendModel;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = spectrumLegendFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview  Spectrum Legend component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var COMPONENT_TYPE_RAPHAEL = _const2['default'].COMPONENT_TYPE_RAPHAEL,
	    MAP_LEGEND_LABEL_PADDING = _const2['default'].MAP_LEGEND_LABEL_PADDING,
	    MAP_LEGEND_GRAPH_SIZE = _const2['default'].MAP_LEGEND_GRAPH_SIZE,
	    CHART_PADDING = _const2['default'].CHART_PADDING;
	
	var SpectrumLegend = function () {
	  /**
	   * Spectrum Legend component.
	   * @constructs SpectrumLegend
	   * @private
	   * @param {object} params parameters
	   *      @param {object} params.theme axis theme
	   *      @param {?Array.<string>} params.options legend options
	   *      @param {MapChartDataProcessor} params.dataProcessor data processor
	   */
	  function SpectrumLegend(params) {
	    _classCallCheck(this, SpectrumLegend);
	
	    var libType = params.libType,
	        chartType = params.chartType,
	        theme = params.theme,
	        _params$options = params.options,
	        options = _params$options === undefined ? {} : _params$options,
	        dataProcessor = params.dataProcessor,
	        colorSpectrum = params.colorSpectrum,
	        eventBus = params.eventBus;
	
	    /**
	     * chart type
	     * @type {string}
	     */
	
	    this.chartType = chartType;
	
	    /**
	     * legend theme
	     * @type {Object}
	     */
	    this.theme = theme;
	
	    if (!_predicate2['default'].isTreemapChart(this.chartType)) {
	      this.theme.label.color = '#fff';
	    }
	
	    /**
	     * options
	     * @type {object}
	     */
	    this.options = options;
	
	    /**
	     * data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = dataProcessor;
	
	    /**
	     * color spectrum
	     * @type {ColorSpectrum}
	     */
	    this.colorSpectrum = colorSpectrum;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = eventBus;
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(libType, 'mapLegend');
	
	    /**
	     * Whether horizontal legend or not.
	     * @type {boolean}
	     */
	    this.isHorizontal = _predicate2['default'].isHorizontalLegend(this.options.align);
	
	    /**
	     * scale data for legend
	     * @type {null|object}
	     */
	    this.scaleData = null;
	
	    this.drawingType = COMPONENT_TYPE_RAPHAEL;
	
	    this._attachToEventBus();
	  }
	
	  /**
	   * Attach to event bus.
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._attachToEventBus = function _attachToEventBus() {
	    this.eventBus.on({
	      showWedge: this.onShowWedge,
	      hideTooltip: this.onHideWedge
	    }, this);
	    this.eventBus.on('beforeImageDownload', _tuiCodeSnippet2['default'].bind(this._removeLocationURLFromFillAttribute, this));
	    this.eventBus.on('afterImageDownload', _tuiCodeSnippet2['default'].bind(this._restoreLocationURLToFillAttribute, this));
	  };
	
	  /**
	   * Remove location URL from fill attribute
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._removeLocationURLFromFillAttribute = function _removeLocationURLFromFillAttribute() {
	    this.graphRenderer.removeLocationURLFromFillAttribute();
	  };
	
	  /**
	   * Restore location URL to fill attribute
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._restoreLocationURLToFillAttribute = function _restoreLocationURLToFillAttribute() {
	    this.graphRenderer.restoreLocationURLToFillAttribute();
	  };
	
	  /**
	   * Make base data to make tick html.
	   * @returns {{startPositionValue: number, step: number, positionType: string, labelSize: ?number}} base data
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._makeBaseDataToMakeTickArea = function _makeBaseDataToMakeTickArea() {
	    var dimension = this.layout.dimension;
	    var scaleData = this.scaleData,
	        align = this.options.align;
	
	    var stepCount = scaleData.stepCount || scaleData.tickCount - 1;
	    var baseData = {};
	
	    baseData.position = this.layout.position;
	
	    if (this.isHorizontal) {
	      baseData.step = dimension.width / stepCount;
	
	      if (_predicate2['default'].isLegendAlignTop(align)) {
	        baseData.position.top -= MAP_LEGEND_LABEL_PADDING;
	      } else {
	        baseData.position.top += MAP_LEGEND_GRAPH_SIZE + MAP_LEGEND_LABEL_PADDING;
	      }
	    } else {
	      baseData.step = dimension.height / stepCount;
	
	      if (_predicate2['default'].isLegendAlignLeft(align)) {
	        baseData.position.left = CHART_PADDING;
	      } else {
	        baseData.position.left += MAP_LEGEND_GRAPH_SIZE + MAP_LEGEND_LABEL_PADDING;
	      }
	    }
	
	    return baseData;
	  };
	
	  /**
	   * Render tick area.
	   * @param {Array.<object>} legendSet legend set
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._renderTickArea = function _renderTickArea(legendSet) {
	    if (this.options.reversed) {
	      this.scaleData.labels.sort(function (prev, next) {
	        return next - prev;
	      });
	    }
	
	    this.graphRenderer.renderTickLabels(this.paper, this._makeBaseDataToMakeTickArea(), this.scaleData.labels, this.options.align, legendSet);
	  };
	
	  /**
	   * Make graph dimension of vertical legend
	   * @returns {{width: number, height: number}} dimension
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._makeVerticalGraphDimension = function _makeVerticalGraphDimension() {
	    return {
	      width: MAP_LEGEND_GRAPH_SIZE,
	      height: this.layout.dimension.height
	    };
	  };
	
	  /**
	   * Make graph dimension of horizontal legend
	   * @returns {{width: number, height: number}} dimension
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._makeHorizontalGraphDimension = function _makeHorizontalGraphDimension() {
	    return {
	      width: this.layout.dimension.width,
	      height: MAP_LEGEND_GRAPH_SIZE
	    };
	  };
	
	  /**
	   * Render graph.
	   * @param {Array.<object>} legendSet legend set
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._renderGraph = function _renderGraph(legendSet) {
	    var position = this.layout.position;
	
	    var dimension = void 0;
	
	    if (this.isHorizontal) {
	      dimension = this._makeHorizontalGraphDimension();
	    } else {
	      dimension = this._makeVerticalGraphDimension();
	    }
	
	    if (this.options.reversed) {
	      var startForSwap = this.colorSpectrum.start;
	      this.colorSpectrum.start = this.colorSpectrum.end;
	      this.colorSpectrum.end = startForSwap;
	    }
	
	    this.graphRenderer.render({
	      paper: this.paper,
	      layout: {
	        dimension: dimension,
	        position: position
	      },
	      colorSpectrum: this.colorSpectrum,
	      align: this.options.align,
	      legendSet: legendSet,
	      theme: this.theme.label,
	      labels: this.scaleData.labels
	    });
	  };
	
	  /**
	   * Render legend area.
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._renderLegendArea = function _renderLegendArea() {
	    var legendSet = this.paper.set();
	
	    this._renderGraph(legendSet);
	    this._renderTickArea(legendSet);
	
	    return legendSet;
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: object,
	   *      legendScaleData: object
	   * }} data - scale data
	   * @private
	   */
	
	
	  SpectrumLegend.prototype._setDataForRendering = function _setDataForRendering(_ref) {
	    var layout = _ref.layout,
	        paper = _ref.paper,
	        legendScaleData = _ref.legendScaleData;
	
	    this.layout = layout;
	    this.paper = paper;
	    this.scaleData = legendScaleData;
	  };
	
	  /**
	   * Render legend component.
	   * @param {object} data - scale data
	   */
	
	
	  SpectrumLegend.prototype.render = function render(data) {
	    this._setDataForRendering(data);
	    this.legendSet = this._renderLegendArea();
	  };
	
	  /**
	   * Rerender legend component.
	   * @param {object} data - scale data
	   */
	
	
	  SpectrumLegend.prototype.rerender = function rerender(data) {
	    this.legendSet.remove();
	    this.render(data);
	  };
	
	  /**
	   * Resize legend component.
	   * @param {object} data - scale data
	   */
	
	
	  SpectrumLegend.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  /**
	   * On show wedge.
	   * @param {number} ratio ratio
	   * @param {string} label label
	   */
	
	
	  SpectrumLegend.prototype.onShowWedge = function onShowWedge(ratio, label) {
	    ratio = this.options.reversed ? 1 - ratio : ratio;
	    this.graphRenderer.showWedge(ratio, label);
	  };
	
	  /**
	   * On hide wedge.
	   */
	
	
	  SpectrumLegend.prototype.onHideWedge = function onHideWedge() {
	    this.graphRenderer.hideWedge();
	  };
	
	  return SpectrumLegend;
	}();
	
	/**
	 * Factory for SpectrumLegend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	
	
	function spectrumLegendFactory(params) {
	  var isLegendVisible = _tuiCodeSnippet2['default'].isUndefined(params.options.visible) ? true : params.options.visible;
	  var chartType = params.chartOptions.chartType;
	
	  var spectrumLegend = null;
	
	  if (isLegendVisible) {
	    params.chartType = chartType;
	
	    spectrumLegend = new SpectrumLegend(params);
	  }
	
	  return spectrumLegend;
	}
	
	spectrumLegendFactory.componentType = 'legend';
	spectrumLegendFactory.SpectrumLegend = SpectrumLegend;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = circleLegendFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _calculator = __webpack_require__(25);
	
	var _calculator2 = _interopRequireDefault(_calculator);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview  Circle legend component render a legend in the form of overlapping circles
	                                                                                                                                                           *                  by representative radius values.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var CircleLegend = function () {
	  /**
	   * Circle legend component render a legend in the form of overlapping circles by representative radius values.
	   * @constructs CircleLegend
	   * @private
	   * @param {object} params parameters
	   *      @param {?string} params.libType - library type for graph rendering
	   *      @param {string} params.chartType - chart type
	   *      @param {DataProcessor} params.dataProcessor - DataProcessor
	   *      @param {string} params.baseFontFamily - base fontFamily of chart
	   */
	  function CircleLegend(_ref) {
	    var libType = _ref.libType,
	        chartType = _ref.chartType,
	        dataProcessor = _ref.dataProcessor,
	        baseFontFamily = _ref.baseFontFamily;
	
	    _classCallCheck(this, CircleLegend);
	
	    /**
	     * ratios for rendering circle
	     * @type {Array.<number>}
	     */
	    this.circleRatios = [1, 0.5, 0.25];
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    this.chartType = chartType;
	
	    /**
	     * data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = dataProcessor;
	
	    /**
	     * theme for label of circle legend area
	     * @type {{fontSize: number, fontFamily: *}}
	     */
	    this.labelTheme = {
	      fontSize: _const2['default'].CIRCLE_LEGEND_LABEL_FONT_SIZE,
	      fontFamily: baseFontFamily
	    };
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(libType, 'circleLegend');
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * max radius for rendering circle legend
	     * @type {null|number}
	     */
	    this.maxRadius = null;
	
	    this.drawingType = _const2['default'].COMPONENT_TYPE_RAPHAEL;
	  }
	
	  /**
	   * Format label.
	   * @param {number} label - label
	   * @param {number} decimalLength - decimal length
	   * @returns {string}
	   * @private
	   */
	
	
	  CircleLegend.prototype._formatLabel = function _formatLabel(label, decimalLength) {
	    var formatFunctions = this.dataProcessor.getFormatFunctions();
	    var formattedLabel = void 0;
	
	    if (decimalLength === 0) {
	      formattedLabel = String(parseInt(label, 10));
	    } else {
	      formattedLabel = _renderUtil2['default'].formatToDecimal(String(label), decimalLength);
	    }
	
	    return _renderUtil2['default'].formatValue({
	      value: formattedLabel,
	      formatFunctions: formatFunctions,
	      chartType: this.chartType,
	      areaType: 'circleLegend',
	      valueType: 'r'
	    });
	  };
	
	  /**
	   * Make label html.
	   * @returns {Array.<string>}
	   * @private
	   */
	
	
	  CircleLegend.prototype._makeLabels = function _makeLabels() {
	    var _this = this;
	
	    var maxValueRadius = this.dataProcessor.getMaxValue(this.chartType, 'r');
	    var decimalLength = _calculator2['default'].getDecimalLength(maxValueRadius);
	
	    return this.circleRatios.map(function (ratio) {
	      return _this._formatLabel(maxValueRadius * ratio, decimalLength);
	    });
	  };
	
	  /**
	   * Render for circle legend area.
	   * @param {object} paper paper object
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  CircleLegend.prototype._render = function _render(paper) {
	    return this.graphRenderer.render(paper, this.layout, this.maxRadius, this.circleRatios, this._makeLabels());
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      },
	   *      maxRadius: number
	   * }} data - bounds data
	   * @private
	   */
	
	
	  CircleLegend.prototype._setDataForRendering = function _setDataForRendering(data) {
	    this.layout = data.layout;
	    this.maxRadius = data.maxRadius;
	  };
	
	  /**
	   * Render.
	   * @param {object} data - bounds data
	   */
	
	
	  CircleLegend.prototype.render = function render(data) {
	    this._setDataForRendering(data);
	    this.circleLegendSet = this._render(data.paper);
	  };
	
	  /**
	   * Rerender.
	   * @param {object} data - bounds data
	   */
	
	
	  CircleLegend.prototype.rerender = function rerender(data) {
	    this.circleLegendSet.remove();
	
	    this._setDataForRendering(data);
	    this.circleLegendSet = this._render(data.paper);
	  };
	
	  /**
	   * Resize.
	   * @param {object} data - bounds data
	   */
	
	
	  CircleLegend.prototype.resize = function resize(data) {
	    this.rerender(data);
	  };
	
	  return CircleLegend;
	}();
	
	/**
	 * Factory for CircleLegend
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	
	
	function circleLegendFactory(params) {
	  var chartTheme = params.chartTheme,
	      chartType = params.chartOptions.chartType;
	
	  var visibleOption = _tuiCodeSnippet2['default'].pick(params.chartOptions, 'circleLegend', 'visible');
	  var circleLegend = null;
	  var isLegendVisible = void 0;
	
	  if (_tuiCodeSnippet2['default'].isUndefined(visibleOption)) {
	    isLegendVisible = true;
	  } else {
	    isLegendVisible = visibleOption;
	  }
	
	  if (isLegendVisible) {
	    params.chartType = chartType;
	    params.baseFontFamily = chartTheme.chart.fontFamily;
	
	    circleLegend = new CircleLegend(params);
	  }
	
	  return circleLegend;
	}
	
	circleLegendFactory.componentType = 'legend';
	circleLegendFactory.CircleLegend = CircleLegend;

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = tooltipFactory;
	
	var _normalTooltip = __webpack_require__(62);
	
	var _normalTooltip2 = _interopRequireDefault(_normalTooltip);
	
	var _groupTooltip = __webpack_require__(67);
	
	var _groupTooltip2 = _interopRequireDefault(_groupTooltip);
	
	var _mapChartTooltip = __webpack_require__(69);
	
	var _mapChartTooltip2 = _interopRequireDefault(_mapChartTooltip);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Label formatter function for pie chart
	 * @param {object} seriesItem series item
	 * @param {object} tooltipDatum tooltip datum object
	 * @param {string} labelPrefix label prefix
	 * @returns {object}
	 * @ignore
	 */
	function pieTooltipLabelFormatter(seriesItem, tooltipDatum, labelPrefix) {
	  var percentageString = (seriesItem.ratio * 100).toFixed(4);
	  var percent = parseFloat(percentageString);
	  var needSlice = percent < 0.0009 || percentageString.length > 5;
	
	  percentageString = needSlice ? percentageString.substr(0, 4) : String(percent);
	  var ratioLabel = percentageString + '&nbsp;%&nbsp;' || '';
	
	  tooltipDatum.ratioLabel = labelPrefix + ratioLabel;
	  tooltipDatum.label = seriesItem.tooltipLabel || (seriesItem.label ? seriesItem.label : '');
	
	  return tooltipDatum;
	}
	
	/**
	 * Factory for Tooltip
	 * @param {object} params parameter
	 * @returns {object|null}
	 * @ignore
	 */
	/**
	 * @fileoverview NormalTooltip component.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function tooltipFactory(params) {
	  var chartType = params.chartOptions.chartType,
	      seriesTypes = params.seriesTypes;
	
	  var xAxisOptions = params.chartOptions.xAxis;
	  var colors = [];
	  var factory = void 0;
	
	  var legendTheme = Object.values(params.chartTheme.legend).filter(function (item) {
	    return _tuiCodeSnippet2['default'].isArray(item.colors);
	  });
	
	  legendTheme.forEach(function (series) {
	    colors = colors.concat(series.colors);
	  });
	
	  if (chartType === 'map') {
	    factory = _mapChartTooltip2['default'];
	  } else if (params.options.grouped) {
	    factory = _groupTooltip2['default'];
	  } else {
	    factory = _normalTooltip2['default'];
	  }
	
	  if (chartType === 'pie' || _predicate2['default'].isPieDonutComboChart(chartType, seriesTypes)) {
	    params.labelFormatter = pieTooltipLabelFormatter;
	  }
	
	  params.chartType = chartType;
	  params.chartTypes = seriesTypes;
	  params.xAxisType = xAxisOptions.type;
	  params.dateFormat = xAxisOptions.dateFormat;
	  params.colors = colors;
	
	  return factory(params);
	}
	
	tooltipFactory.componentType = 'tooltip';

/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = normalTooltipFactory;
	
	var _tooltipBase = __webpack_require__(63);
	
	var _tooltipBase2 = _interopRequireDefault(_tooltipBase);
	
	var _singleTooltipMixer = __webpack_require__(64);
	
	var _singleTooltipMixer2 = _interopRequireDefault(_singleTooltipMixer);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _tooltipTemplate = __webpack_require__(65);
	
	var _tooltipTemplate2 = _interopRequireDefault(_tooltipTemplate);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview NormalTooltip component.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	
	var DEFAULT_TOOLTIP_COLOR = '#aaa';
	
	/**
	 * @classdesc NormalTooltip component.
	 * @class NormalTooltip
	 * @private
	 */
	
	var NormalTooltip = function (_TooltipBase) {
	  _inherits(NormalTooltip, _TooltipBase);
	
	  /**
	   * NormalTooltip component.
	   * @constructs NormalTooltip
	   * @private
	   * @override
	   */
	  function NormalTooltip(params) {
	    _classCallCheck(this, NormalTooltip);
	
	    /**
	     * Color spectrum
	     * @type {ColorSpectrum}
	     */
	    var _this = _possibleConstructorReturn(this, _TooltipBase.call(this, params));
	
	    _this.colorSpectrum = params.colorSpectrum;
	    return _this;
	  }
	
	  /**
	   * Make tooltip html.
	   * @param {string} category category
	   * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  NormalTooltip.prototype._makeTooltipHtml = function _makeTooltipHtml(category, item) {
	    var template = this._getTooltipTemplate(item);
	
	    return template(_tuiCodeSnippet2['default'].extend({
	      categoryVisible: category ? 'show' : 'hide',
	      category: category
	    }, item));
	  };
	
	  /**
	   * get tooltip template from a templates collection
	   * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	   * @returns {string} tooltip template
	   * @private
	   */
	
	
	  NormalTooltip.prototype._getTooltipTemplate = function _getTooltipTemplate(item) {
	    var template = _tooltipTemplate2['default'].tplDefault;
	
	    if (_predicate2['default'].isBoxplotChart(this.chartType)) {
	      template = this._getBoxplotTooltipTemplate(item);
	    } else if (_predicate2['default'].isPieChart(this.chartType) || _predicate2['default'].isPieDonutComboChart(this.chartType, this.chartTypes)) {
	      template = _tooltipTemplate2['default'].tplPieChart;
	    } else if (this.dataProcessor.coordinateType) {
	      template = _tooltipTemplate2['default'].tplCoordinatetypeChart;
	    } else if (_predicate2['default'].isBulletChart(this.chartType)) {
	      template = _tooltipTemplate2['default'].tplBulletChartDefault;
	    } else if (_predicate2['default'].isHeatmapChart(this.chartType)) {
	      template = _tooltipTemplate2['default'].tplHeatmapChart;
	    }
	
	    return template;
	  };
	
	  /**
	   * Get tooltip template of box plot chart
	   * If item has outlierIndex, return outlier template
	   * Otherwise, return box plot default template
	   * @param {{value: string, legend: string, chartType: string, suffix: ?string}} item item data
	   * @returns {string} tooltip template
	   * @private
	   */
	
	
	  NormalTooltip.prototype._getBoxplotTooltipTemplate = function _getBoxplotTooltipTemplate(item) {
	    var template = _tooltipTemplate2['default'].tplBoxplotChartDefault;
	
	    if (_tuiCodeSnippet2['default'].isNumber(item.outlierIndex)) {
	      template = _tooltipTemplate2['default'].tplBoxplotChartOutlier;
	      item.label = item.outliers[item.outlierIndex].label;
	    }
	
	    return template;
	  };
	
	  /**
	   * Make html for value types like x, y, r
	   * @param {{x: ?number, y: ?number, r: ?number}} data - data
	   * @param {Array.<string>} valueTypes - types of value
	   * @returns {string}
	   * @private
	   */
	
	
	  NormalTooltip.prototype._makeHtmlForValueTypes = function _makeHtmlForValueTypes(data, valueTypes) {
	    return valueTypes.map(function (type) {
	      if (data[type]) {
	        return '<tr><td>' + type + '</td><td class="' + _const2['default'].CLASS_NAME_TOOLTIP_VALUE + '">' + data[type] + '</td></tr>';
	      }
	
	      return '';
	    }).join('');
	  };
	
	  /**
	   * Make single tooltip html.
	   * @param {string} chartType chart type
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  NormalTooltip.prototype._makeSingleTooltipHtml = function _makeSingleTooltipHtml(chartType, indexes) {
	    var groupIndex = indexes.groupIndex;
	
	    var data = this._findTooltipData(chartType, indexes);
	    var color = this._findTooltipColor(chartType, indexes, data);
	
	    if (_predicate2['default'].isBoxplotChart(this.chartType) && _tuiCodeSnippet2['default'].isNumber(indexes.outlierIndex)) {
	      data.outlierIndex = indexes.outlierIndex;
	    }
	    if (this.colorSpectrum) {
	      color = this.colorSpectrum.getColor(data.colorRatio || data.ratio);
	    }
	
	    data.chartType = this.chartType;
	    data.cssText = 'background-color: ' + color;
	    data = Object.assign({
	      suffix: this.suffix
	    }, data);
	    data.valueTypes = this._makeHtmlForValueTypes(data, ['x', 'y', 'r']);
	
	    return this.templateFunc(data.category, data, this.getRawCategory(groupIndex));
	  };
	
	  /**
	   * Find data for tooltip
	   * @param {string} chartType chart type
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @returns {string} data for tooltip
	   * @private
	   */
	
	
	  NormalTooltip.prototype._findTooltipData = function _findTooltipData(chartType, indexes) {
	    var chartData = this.data[chartType];
	    var selectIndex = indexes.groupIndex;
	
	    if (_predicate2['default'].isRadialChart(chartType) && chartData.length === selectIndex) {
	      selectIndex = 0;
	    }
	
	    return Object.assign({}, _tuiCodeSnippet2['default'].pick(chartData, selectIndex, indexes.index));
	  };
	
	  /**
	   * Find data for tooltip
	   * @param {string} hoveredChartType - chart type
	   * @param {{groupIndex: number, index: number}} indexes - indexes
	   * @param {Object} data - data for tooltip render
	   * @returns {string} color hex string
	   * @private
	   */
	
	
	  NormalTooltip.prototype._findTooltipColor = function _findTooltipColor(hoveredChartType, indexes, data) {
	    var isBar = _predicate2['default'].isBarTypeChart(this.chartType);
	    var isBoxplot = _predicate2['default'].isBoxplotChart(this.chartType);
	    var colorByPoint = (isBar || isBoxplot) && this.dataProcessor.options.series.colorByPoint;
	
	    var groupIndex = indexes.groupIndex;
	    var seriesIndex = indexes.index;
	
	
	    if (_predicate2['default'].isBulletChart(this.chartType)) {
	      seriesIndex = groupIndex;
	    } else if (_predicate2['default'].isTreemapChart(this.chartType)) {
	      seriesIndex = data.tooltipColorIndex;
	    }
	
	    return colorByPoint ? DEFAULT_TOOLTIP_COLOR : this.tooltipColors[hoveredChartType][seriesIndex];
	  };
	
	  /**
	   * Set default align option of tooltip.
	   * @private
	   * @override
	   */
	
	
	  NormalTooltip.prototype._setDefaultTooltipPositionOption = function _setDefaultTooltipPositionOption() {
	    if (this.options.align) {
	      return;
	    }
	
	    if (this.isVertical) {
	      this.options.align = _const2['default'].TOOLTIP_DEFAULT_ALIGN_OPTION;
	    } else {
	      this.options.align = _const2['default'].TOOLTIP_DEFAULT_HORIZONTAL_ALIGN_OPTION;
	    }
	  };
	
	  /**
	   * Make parameters for show tooltip user event.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {object} additionParams addition parameters
	   * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} parameters for show tooltip
	   * @private
	   */
	
	
	  NormalTooltip.prototype._makeShowTooltipParams = function _makeShowTooltipParams(indexes, additionParams) {
	    var legendIndex = indexes.index;
	    var legendData = this.dataProcessor.getLegendItem(legendIndex);
	
	    if (!legendData) {
	      return null;
	    }
	
	    var chartType = legendData.chartType,
	        label = legendData.label;
	
	    var params = _tuiCodeSnippet2['default'].extend({
	      chartType: chartType,
	      legend: label,
	      legendIndex: legendIndex,
	      index: indexes.groupIndex
	    }, additionParams);
	
	    if (_predicate2['default'].isBoxplotChart(chartType) && _tuiCodeSnippet2['default'].isNumber(indexes.outlierIndex)) {
	      params.outlierIndex = indexes.outlierIndex;
	    }
	
	    return params;
	  };
	
	  /**
	   * Make tooltip datum.
	   * @param {string} legendLabel - legend label
	   * @param {string} category - category
	   * @param {SeriesItem} seriesItem - SeriesItem
	   * @returns {Object}
	   * @private
	   */
	
	
	  NormalTooltip.prototype._makeTooltipDatum = function _makeTooltipDatum() {
	    var legendLabel = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
	    var category = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
	    var seriesItem = arguments[2];
	    var tooltipLabel = seriesItem.tooltipLabel;
	    var labelFormatter = this.labelFormatter;
	
	    var tooltipDatum = {
	      legend: legendLabel,
	      label: tooltipLabel || (seriesItem.label ? seriesItem.label : ''),
	      category: category
	    };
	
	    if (labelFormatter) {
	      tooltipDatum = labelFormatter(seriesItem, tooltipDatum, '');
	    }
	
	    tooltipDatum.category = category;
	
	    return _tuiCodeSnippet2['default'].extend(tooltipDatum, seriesItem.pickValueMapForTooltip());
	  };
	
	  /**
	   * Make tooltip data.
	   * @returns {Array.<object>} tooltip data
	   * @override
	   */
	
	
	  NormalTooltip.prototype.makeTooltipData = function makeTooltipData() {
	    var _this2 = this;
	
	    var orgLegendLabels = this.dataProcessor.getLegendLabels();
	    var isPivot = _predicate2['default'].isTreemapChart(this.chartType);
	    var legendLabels = {};
	    var tooltipData = {};
	
	    if (_tuiCodeSnippet2['default'].isArray(orgLegendLabels)) {
	      legendLabels[this.chartType] = orgLegendLabels;
	    } else {
	      legendLabels = orgLegendLabels;
	    }
	
	    this.dataProcessor.eachBySeriesGroup(function (seriesGroup, groupIndex, chartType) {
	      chartType = chartType || _this2.chartType;
	      var isBulletChart = _predicate2['default'].isBulletChart(chartType);
	
	      var data = seriesGroup.map(function (seriesItem, index) {
	        var category = _this2.dataProcessor.makeTooltipCategory(groupIndex, index, _this2.isVertical);
	        var legendIndex = isBulletChart ? groupIndex : index;
	
	        if (!seriesItem) {
	          return null;
	        }
	
	        return _this2._makeTooltipDatum(legendLabels[chartType][legendIndex], category, seriesItem);
	      });
	
	      if (!tooltipData[chartType]) {
	        tooltipData[chartType] = [];
	      }
	
	      tooltipData[chartType].push(data);
	    }, isPivot);
	
	    return tooltipData;
	  };
	
	  return NormalTooltip;
	}(_tooltipBase2['default']);
	
	_singleTooltipMixer2['default'].mixin(NormalTooltip);
	
	/**
	 * normalTooltipFactory
	 * @param {object} params chart options
	 * @returns {object} normal tooltip instance
	 * @ignore
	 */
	function normalTooltipFactory(params) {
	  return new NormalTooltip(params);
	}
	
	normalTooltipFactory.componentType = 'tooltip';
	normalTooltipFactory.NormalTooltip = NormalTooltip;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _raphael = __webpack_require__(4);
	
	var _raphael2 = _interopRequireDefault(_raphael);
	
	var _objectUtil = __webpack_require__(38);
	
	var _objectUtil2 = _interopRequireDefault(_objectUtil);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview TooltipBase is base class of tooltip components.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var TooltipBase = function () {
	  /**
	   * TooltipBase is base class of tooltip components.
	   * @constructs TooltipBase
	   * @private
	   * @param {object} params - parameters
	   *      @param {string} params.chartType - chart type
	   *      @param {Array.<string>} params.chartTypes - chart types
	   *      @param {DataProcessor} params.dataProcessor - DataProcessor instance
	   *      @param {object} params.options - tooltip options
	   *      @param {object} params.theme - tooltip theme
	   *      @param {boolean} params.isVertical - whether vertical or not
	   *      @param {object} params.eventBus - snippet.CustomEvents instance
	   *      @param {object} params.labelTheme - theme for label
	   *      @param {string} params.xAxisType - xAxis type
	   *      @param {string} params.dateFormat - date format
	   *      @param {object} params.labelFormatter - label formatter function
	   */
	  function TooltipBase(params) {
	    _classCallCheck(this, TooltipBase);
	
	    var isPieChart = _predicate2['default'].isPieChart(params.chartType);
	
	    /**
	     * Chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * Chart types
	     * @type {Array.<string>}
	     */
	    this.chartTypes = params.chartTypes;
	
	    /**
	     * Data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * Options
	     * @type {object}
	     */
	    this.options = params.options;
	    this.colors = params.colors;
	
	    /**
	     * Theme
	     * @type {object}
	     */
	    this.theme = params.theme;
	
	    /**
	     * Original Theme
	     * @type {object}
	     */
	    this.originalTheme = _objectUtil2['default'].deepCopy(params.theme);
	
	    /**
	     * whether vertical or not
	     * @type {boolean}
	     */
	    this.isVertical = params.isVertical;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = params.eventBus;
	
	    /**
	     * label theme
	     * @type {object}
	     */
	    this.labelTheme = params.labelTheme;
	
	    /**
	     * x axis type
	     * @type {?string}
	     */
	    this.xAxisType = params.xAxisType;
	
	    /**
	     * dateFormat option for xAxis
	     * @type {?string}
	     */
	    this.dateFormat = params.dateFormat;
	
	    /**
	     * tooltip options for each chart
	     * @type {?function}
	     */
	    this.labelFormatter = params.labelFormatter;
	
	    /**
	     * className
	     * @type {string}
	     */
	    this.className = 'tui-chart-tooltip-area';
	
	    /**
	     * Tooltip container.
	     * @type {HTMLElement}
	     */
	    this.tooltipContainer = null;
	
	    /**
	     * Tooltip suffix.
	     * @type {string}
	     */
	    this.suffix = this.options.suffix ? '&nbsp;' + this.options.suffix : '';
	
	    /**
	     * Tooltip template function.
	     * @type {function}
	     */
	    this.templateFunc = this.options.template || _tuiCodeSnippet2['default'].bind(this._makeTooltipHtml, this);
	
	    /**
	     * Tooltip animation time.
	     * @type {number}
	     */
	    this.animationTime = isPieChart ? _const2['default'].TOOLTIP_PIE_ANIMATION_TIME : _const2['default'].TOOLTIP_ANIMATION_TIME;
	
	    /**
	     * TooltipBase base data.
	     * @type {Array.<Array.<object>>}
	     */
	    this.data = [];
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * dimension map for layout of chart
	     * @type {null|object}
	     */
	    this.dimensionMap = null;
	
	    /**
	     * position map for layout of chart
	     * @type {null|object}
	     */
	    this.positionMap = null;
	
	    /**
	     * Drawing type
	     * @type {string}
	     */
	    this.drawingType = _const2['default'].COMPONENT_TYPE_DOM;
	
	    this._setDefaultTooltipPositionOption();
	    this._saveOriginalPositionOptions();
	
	    this._attachToEventBus();
	  }
	
	  /**
	   * Preset components for setData
	   * @param {object} theme theme object
	   * @ignore
	   */
	
	
	  TooltipBase.prototype.presetForChangeData = function presetForChangeData() {
	    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.theme;
	
	    this.theme = theme;
	    this.originalTheme = _objectUtil2['default'].deepCopy(theme);
	  };
	
	  /**
	   * Attach to event bus.
	   * @private
	   */
	
	
	  TooltipBase.prototype._attachToEventBus = function _attachToEventBus() {
	    this.eventBus.on({
	      showTooltip: this.onShowTooltip,
	      hideTooltip: this.onHideTooltip
	    }, this);
	
	    if (this.onShowTooltipContainer) {
	      this.eventBus.on({
	        showTooltipContainer: this.onShowTooltipContainer,
	        hideTooltipContainer: this.onHideTooltipContainer
	      }, this);
	    }
	  };
	
	  /**
	   * Make tooltip html.
	   * @private
	   * @abstract
	   */
	
	
	  TooltipBase.prototype._makeTooltipHtml = function _makeTooltipHtml() {};
	
	  /**
	   * Set default align option of tooltip.
	   * @private
	   * @abstract
	   */
	
	
	  TooltipBase.prototype._setDefaultTooltipPositionOption = function _setDefaultTooltipPositionOption() {};
	
	  /**
	   * Save position options.
	   * @private
	   */
	
	
	  TooltipBase.prototype._saveOriginalPositionOptions = function _saveOriginalPositionOptions() {
	    this.orgPositionOptions = {
	      align: this.options.align,
	      offset: this.options.offset
	    };
	  };
	
	  /**
	   * Render tooltip component.
	   * @param {HTMLElement} iconElement - icon element
	   */
	
	
	  TooltipBase.prototype.makeLineLegendIcon = function makeLineLegendIcon(iconElement) {
	    var iconElementLength = iconElement.length;
	
	    for (var i = 0; i < iconElementLength; i += 1) {
	      var icon = iconElement[i];
	      var strokeColor = icon.style['background-color'];
	      var paper = (0, _raphael2['default'])(icon, 10, 10);
	      var line = paper.path(_const2['default'].LEGEND_LINE_ICON_PATH);
	      icon.style['background-color'] = '';
	      line.attr({
	        stroke: strokeColor,
	        'stroke-width': 2,
	        'stroke-opacity': 1
	      });
	    }
	  };
	
	  /**
	   * Make tooltip data.
	   * @private
	   * @abstract
	   */
	
	
	  TooltipBase.prototype.makeTooltipData = function makeTooltipData() {};
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      },
	   *      dimensionMap: object
	   * }} data - bounds data
	   * @private
	   */
	
	
	  TooltipBase.prototype._setDataForRendering = function _setDataForRendering(data) {
	    this.layout = data.layout;
	    this.dimensionMap = data.dimensionMap;
	    this.positionMap = data.positionMap;
	  };
	
	  /**
	   * Render tooltip component.
	   * @param {object} data - bounds data
	   * @returns {HTMLElement} tooltip element
	   */
	
	
	  TooltipBase.prototype.render = function render(data) {
	    var el = data.paper;
	
	    _domHandler2['default'].addClass(el, this.className);
	
	    this._setDataForRendering(data);
	    this.data = this.makeTooltipData();
	    this.tooltipColors = this.makeTooltipLegendColor(data.checkedLegends);
	    _renderUtil2['default'].renderPosition(el, this.layout.position);
	
	    this.tooltipContainer = el;
	
	    return el;
	  };
	
	  /**
	   * Rerender.
	   * @param {object} data - bounds data
	   */
	
	
	  TooltipBase.prototype.rerender = function rerender(data) {
	    this.resize(data);
	    this.data = this.makeTooltipData();
	    this.tooltipColors = this.makeTooltipLegendColor(data.checkedLegends);
	  };
	
	  /**
	   * make legend color
	   * @param {object | Array.<boolean>}checkedLegends checked legends
	   * @returns {{colors: Array.<string>}} legend colors
	   * @private
	   */
	
	
	  TooltipBase.prototype.makeTooltipLegendColor = function makeTooltipLegendColor(checkedLegends) {
	    var _this = this;
	
	    var colors = {};
	
	    if (checkedLegends) {
	      Object.keys(this.theme).forEach(function (themeKey) {
	        if (!colors[themeKey]) {
	          colors[themeKey] = [];
	        }
	        (checkedLegends[themeKey] || []).forEach(function (checked, index) {
	          if (checked) {
	            colors[themeKey].push(_this.theme[themeKey].colors[index]);
	          }
	        });
	      });
	    }
	
	    return colors;
	  };
	
	  /**
	   * Resize tooltip component.
	   * @param {object} data - bounds data
	   * @override
	   */
	
	
	  TooltipBase.prototype.resize = function resize(data) {
	    this._setDataForRendering(data);
	
	    _renderUtil2['default'].renderPosition(this.tooltipContainer, this.layout.position);
	    if (this.positionModel) {
	      this.positionModel.updateBound(this.layout);
	    }
	  };
	
	  /**
	   * Zoom.
	   */
	
	
	  TooltipBase.prototype.zoom = function zoom() {
	    this.data = this.makeTooltipData();
	  };
	
	  /**
	   * Get tooltip element.
	   * @returns {HTMLElement} tooltip element
	   * @private
	   */
	
	
	  TooltipBase.prototype._getTooltipElement = function _getTooltipElement() {
	    if (!this.tooltipElement) {
	      var tooltipElement = this.tooltipElement = _domHandler2['default'].create('DIV', 'tui-chart-tooltip');
	      _domHandler2['default'].append(this.tooltipContainer, tooltipElement);
	    }
	
	    return this.tooltipElement;
	  };
	
	  /**
	   * onShowTooltip is callback of mouse event detector showTooltip for SeriesView.
	   * @param {object} params coordinate event parameters
	   */
	
	
	  TooltipBase.prototype.onShowTooltip = function onShowTooltip(params) {
	    var tooltipElement = this._getTooltipElement();
	    var isScatterCombo = _predicate2['default'].isComboChart(this.chartType) && _predicate2['default'].isScatterChart(params.chartType);
	    var prevPosition = void 0;
	
	    if ((!_predicate2['default'].isChartToDetectMouseEventOnSeries(params.chartType) || isScatterCombo) && tooltipElement.offsetWidth) {
	      prevPosition = {
	        left: tooltipElement.offsetLeft,
	        top: tooltipElement.offsetTop
	      };
	    }
	    this._showTooltip(tooltipElement, params, prevPosition);
	  };
	
	  /**
	   * Get tooltip dimension
	   * @param {HTMLElement} tooltipElement tooltip element
	   * @returns {{width: number, height: number}} rendered tooltip dimension
	   */
	
	
	  TooltipBase.prototype.getTooltipDimension = function getTooltipDimension(_ref) {
	    var offsetWidth = _ref.offsetWidth,
	        offsetHeight = _ref.offsetHeight;
	
	    return {
	      width: offsetWidth,
	      height: offsetHeight
	    };
	  };
	
	  /**
	   * Move to Position.
	   * @param {HTMLElement} tooltipElement tooltip element
	   * @param {{left: number, top: number}} position position
	   * @param {{left: number, top: number}} prevPosition prev position
	   * @private
	   */
	
	
	  TooltipBase.prototype._moveToPosition = function _moveToPosition(tooltipElement, position, prevPosition) {
	    if (prevPosition) {
	      this._slideTooltip(tooltipElement, prevPosition, position);
	    } else {
	      _renderUtil2['default'].renderPosition(tooltipElement, position);
	    }
	  };
	
	  /**
	   * Slide tooltip
	   * @param {HTMLElement} tooltipElement tooltip element
	   * @param {{left: number, top: number}} prevPosition prev position
	   * @param {{left: number, top: number}} position position
	   * @private
	   */
	
	
	  TooltipBase.prototype._slideTooltip = function _slideTooltip(tooltipElement, prevPosition, position) {
	    var moveTop = position.top - prevPosition.top;
	    var moveLeft = position.left - prevPosition.left;
	
	    _renderUtil2['default'].cancelAnimation(this.slidingAnimation);
	
	    this.slidingAnimation = _renderUtil2['default'].startAnimation(this.animationTime, function (ratio) {
	      var left = moveLeft * ratio;
	      var top = moveTop * ratio;
	      tooltipElement.style.left = prevPosition.left + left + 'px';
	      tooltipElement.style.top = prevPosition.top + top + 'px';
	    });
	  };
	
	  /**
	   * onHideTooltip is callback of mouse event detector hideTooltip for SeriesView
	   * @param {number|object} prevFound - showing tooltip object in case single tooltip,
	   *                                  - showing tooltip index in case group tooltip
	   * @param {{silent: {boolean}}} [options] - hide tooltip options
	   */
	
	
	  TooltipBase.prototype.onHideTooltip = function onHideTooltip(prevFound, options) {
	    var tooltipElement = this._getTooltipElement();
	
	    this._hideTooltip(tooltipElement, prevFound, options);
	  };
	
	  /**
	   * Set align option.
	   * @param {string} align align
	   */
	
	
	  TooltipBase.prototype.setAlign = function setAlign(align) {
	    this.options.align = align;
	    if (this.positionModel) {
	      this.positionModel.updateOptions(this.options);
	    }
	  };
	
	  /**
	   * Update offset option.
	   * @param {{x: number, y: number}} offset - offset
	   * @private
	   */
	
	
	  TooltipBase.prototype._updateOffsetOption = function _updateOffsetOption(offset) {
	    this.options.offset = offset;
	
	    if (this.positionModel) {
	      this.positionModel.updateOptions(this.options);
	    }
	  };
	
	  /**
	   * Set offset.
	   * @param {{x: number, y: number}} offset - offset
	   */
	
	
	  TooltipBase.prototype.setOffset = function setOffset(offset) {
	    var offsetOption = Object.assign({}, this.options.offset);
	
	    if (_tuiCodeSnippet2['default'].isExisty(offset.x)) {
	      offsetOption.x = offset.x;
	    }
	
	    if (_tuiCodeSnippet2['default'].isExisty(offset.y)) {
	      offsetOption.y = offset.y;
	    }
	
	    this._updateOffsetOption(_tuiCodeSnippet2['default'].extend({}, this.options.offset, offsetOption));
	  };
	
	  /**
	   * Set position option.
	   * @param {{left: number, top: number}} position moving position
	   * @deprecated
	   */
	
	
	  TooltipBase.prototype.setPosition = function setPosition(position) {
	    var offsetOption = Object.assign({}, this.options.offset);
	
	    if (_tuiCodeSnippet2['default'].isExisty(position.left)) {
	      offsetOption.x = position.left;
	    }
	
	    if (_tuiCodeSnippet2['default'].isExisty(position.top)) {
	      offsetOption.y = position.y;
	    }
	
	    this._updateOffsetOption(offsetOption);
	  };
	
	  /**
	   * Reset align option.
	   */
	
	
	  TooltipBase.prototype.resetAlign = function resetAlign() {
	    var align = this.orgPositionOptions.align;
	
	
	    this.options.align = align;
	
	    if (this.positionModel) {
	      this.positionModel.updateOptions(this.options);
	    }
	  };
	
	  /**
	   * Reset offset option.
	   */
	
	
	  TooltipBase.prototype.resetOffset = function resetOffset() {
	    this.options.offset = this.orgPositionOptions.offset;
	    this._updateOffsetOption(this.options.offset);
	  };
	
	  /**
	   * Get category's raw data
	   * @param {number} index - index of categories
	   * @param {string} format - date format
	   * @returns {string} - category's raw data
	   */
	
	
	  TooltipBase.prototype.getRawCategory = function getRawCategory(index, format) {
	    var axis = this.isVertical ? 'x' : 'y';
	    var categories = this.dataProcessor.categoriesMap ? this.dataProcessor.categoriesMap[axis] : null;
	    var rawCategory = '';
	
	    if (categories) {
	      rawCategory = categories[index];
	    }
	
	    if (format) {
	      rawCategory = _renderUtil2['default'].formatDate(rawCategory, format);
	    }
	
	    return rawCategory;
	  };
	
	  return TooltipBase;
	}();
	
	exports['default'] = TooltipBase;

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * singleTooltipMixer is single tooltip mixer of map chart.
	 * @mixin
	 * @private */
	exports['default'] = {
	  /**
	   * Set data indexes.
	   * @param {HTMLElement} elTooltip tooltip element
	   * @param {{groupIndex: number, index:number}} indexes indexes
	   * @private
	   */
	  _setIndexesCustomAttribute: function _setIndexesCustomAttribute(elTooltip, indexes) {
	    elTooltip.setAttribute('data-groupIndex', indexes.groupIndex);
	    elTooltip.setAttribute('data-index', indexes.index);
	  },
	
	
	  /**
	   * Get data indexes
	   * @param {HTMLElement} elTooltip tooltip element
	   * @returns {{groupIndex: number, index: number}} indexes
	   * @private
	   */
	  _getIndexesCustomAttribute: function _getIndexesCustomAttribute(elTooltip) {
	    var groupIndex = elTooltip.getAttribute('data-groupIndex');
	    var index = elTooltip.getAttribute('data-index');
	    var indexes = null;
	
	    if (!_tuiCodeSnippet2['default'].isNull(groupIndex) && !_tuiCodeSnippet2['default'].isNull(index)) {
	      indexes = {
	        groupIndex: parseInt(groupIndex, 10),
	        index: parseInt(index, 10)
	      };
	    }
	
	    return indexes;
	  },
	
	
	  /**
	   * Set showed custom attribute.
	   * @param {HTMLElement} elTooltip tooltip element
	   * @param {boolean} status whether showed or not
	   * @private
	   */
	  _setShowedCustomAttribute: function _setShowedCustomAttribute(elTooltip, status) {
	    elTooltip.setAttribute('data-showed', status);
	  },
	
	
	  /**
	   * Whether showed tooltip or not.
	   * @param {HTMLElement} elTooltip tooltip element
	   * @returns {boolean} whether showed tooltip or not
	   * @private
	   */
	  _isShowedTooltip: function _isShowedTooltip(elTooltip) {
	    var isShowed = elTooltip.getAttribute('data-showed');
	
	    return isShowed === 'true' || isShowed === true; // true in ie7
	  },
	
	
	  /**
	   * Make tooltip position for bullet chart
	   * @param {object} params - mouse position
	   * @returns {object} - position of single tooltip
	   * @private
	   */
	  _makeTooltipPositionForBulletChart: function _makeTooltipPositionForBulletChart(_ref) {
	    var mousePosition = _ref.mousePosition;
	
	    var tooltipAreaPosition = this.layout.position;
	
	    return {
	      left: mousePosition.left - tooltipAreaPosition.left,
	      top: mousePosition.top - tooltipAreaPosition.top
	    };
	  },
	
	
	  /**
	   * Make left position of not bar chart.
	   * @param {number} baseLeft base left
	   * @param {string} alignOption align option
	   * @param {number} minusWidth minus width
	   * @param {number} lineGap line gap
	   * @returns {number} left position value
	   * @private
	   */
	  _makeLeftPositionOfNotBarChart: function _makeLeftPositionOfNotBarChart(baseLeft, alignOption, minusWidth, lineGap) {
	    var left = baseLeft;
	    var offsetNegative = minusWidth || 0;
	    var lineGapOffset = lineGap || _const2['default'].TOOLTIP_GAP;
	
	    if (alignOption.indexOf('left') > -1) {
	      left -= offsetNegative + lineGapOffset;
	    } else if (alignOption.indexOf('center') > -1 && offsetNegative) {
	      left -= offsetNegative / 2;
	    } else {
	      left += lineGapOffset;
	    }
	
	    return left;
	  },
	
	
	  /**
	   * Make top position of not bar chart.
	   * @param {number} baseTop base top
	   * @param {string} alignOption align option
	   * @param {number} tooltipHeight tooltip height
	   * @param {number} lineGap line gap
	   * @returns {number} top position value
	   * @private
	   */
	  _makeTopPositionOfNotBarChart: function _makeTopPositionOfNotBarChart(baseTop, alignOption, tooltipHeight, lineGap) {
	    var top = baseTop;
	    var offsetNegative = tooltipHeight || 0;
	
	    if (alignOption.indexOf('bottom') > -1) {
	      top += offsetNegative + lineGap;
	    } else if (alignOption.indexOf('middle') > -1 && offsetNegative) {
	      top += offsetNegative / 2;
	    } else {
	      top -= offsetNegative + _const2['default'].TOOLTIP_GAP;
	    }
	
	    return top;
	  },
	
	
	  /**
	   * Make tooltip position for not bar chart.
	   * @param {object} params parameters
	   *      @param {{bound: object}} params.data graph information
	   *      @param {{width: number, height: number}} params.dimension tooltip dimension
	   *      @param {string} params.alignOption position option (ex: 'left top')
	   * @returns {{top: number, left: number}} position
	   * @private
	   */
	  _makeTooltipPositionForNotBarChart: function _makeTooltipPositionForNotBarChart(params) {
	    var bound = params.bound,
	        positionOption = params.positionOption,
	        dimension = params.dimension,
	        _params$alignOption = params.alignOption,
	        alignOption = _params$alignOption === undefined ? '' : _params$alignOption;
	
	    var minusWidth = dimension.width - (bound.width || 0);
	    var lineGap = bound.width ? 0 : _const2['default'].TOOLTIP_GAP;
	    var tooltipHeight = dimension.height;
	    var baseLeft = bound.left - this.layout.position.left + positionOption.left;
	    var baseTop = bound.top - this.layout.position.top + positionOption.top - _const2['default'].TOOLTIP_GAP;
	
	    return {
	      left: this._makeLeftPositionOfNotBarChart(baseLeft, alignOption, minusWidth, lineGap),
	      top: this._makeTopPositionOfNotBarChart(baseTop, alignOption, tooltipHeight, lineGap)
	    };
	  },
	
	
	  /**
	   * Make tooltip position to event position.
	   * @param {object} params parameters
	   *      @param {{left: number, top: number}} params.bound bound
	   *      @param {{left: number, top: number}} params.mousePosition mouse position
	   * @returns {{top: number, left: number}} position
	   * @private
	   */
	  _makeTooltipPositionToMousePosition: function _makeTooltipPositionToMousePosition(params) {
	    if (!params.bound) {
	      params.bound = params.bound || {};
	      _tuiCodeSnippet2['default'].extend(params.bound, params.mousePosition);
	    }
	
	    return this._makeTooltipPositionForNotBarChart(params);
	  },
	
	
	  /**
	   * Make left position for bar chart.
	   * @param {number} baseLeft base left
	   * @param {string} alignOption align option
	   * @param {number} tooltipWidth tooltip width
	   * @returns {number} left position value
	   * @private
	   */
	  _makeLeftPositionForBarChart: function _makeLeftPositionForBarChart(baseLeft, alignOption, tooltipWidth) {
	    var left = baseLeft;
	
	    if (alignOption.indexOf('left') > -1) {
	      left -= tooltipWidth;
	    } else if (alignOption.indexOf('center') > -1) {
	      left -= tooltipWidth / 2;
	    } else {
	      left += _const2['default'].TOOLTIP_GAP;
	    }
	
	    return left;
	  },
	
	
	  /**
	   * Make top position for bar chart.
	   * @param {number} baseTop base top
	   * @param {string} alignOption align option
	   * @param {number} minusHeight minus width
	   * @returns {number} top position value
	   * @private
	   */
	  _makeTopPositionForBarChart: function _makeTopPositionForBarChart(baseTop, alignOption, minusHeight) {
	    var top = baseTop;
	
	    if (alignOption.indexOf('top') > -1) {
	      top -= minusHeight;
	    } else if (alignOption.indexOf('middle') > -1) {
	      top -= minusHeight / 2;
	    }
	
	    return top;
	  },
	
	
	  /**
	   * Make tooltip position for bar chart.
	   * @param {object} params parameters
	   *      @param {{bound: object}} params.data graph information
	   *      @param {{width: number, height: number}} params.dimension tooltip dimension
	   *      @param {string} params.alignOption position option (ex: 'left top')
	   * @returns {{top: number, left: number}} position
	   * @private
	   */
	  _makeTooltipPositionForBarChart: function _makeTooltipPositionForBarChart(params) {
	    var position = this.layout.position;
	    var bound = params.bound,
	        positionOption = params.positionOption,
	        dimension = params.dimension,
	        _params$alignOption2 = params.alignOption,
	        alignOption = _params$alignOption2 === undefined ? '' : _params$alignOption2;
	
	    var minusHeight = dimension.height - (bound.height || 0);
	    var tooltipWidth = dimension.width;
	    var baseLeft = bound.left + bound.width + positionOption.left - position.left;
	    var baseTop = bound.top + positionOption.top - position.top;
	
	    return {
	      left: this._makeLeftPositionForBarChart(baseLeft, alignOption, tooltipWidth),
	      top: this._makeTopPositionForBarChart(baseTop, alignOption, minusHeight)
	    };
	  },
	
	
	  /**
	   * Make tooltip position for treemap chart.
	   * @param {object} params parameters
	   *      @param {{bound: object}} params.data - graph information
	   *      @param {{width: number, height: number}} params.dimension - tooltip dimension
	   * @returns {{left: number, top: number}}
	   * @private
	   */
	  _makeTooltipPositionForTreemapChart: function _makeTooltipPositionForTreemapChart(params) {
	    var position = this.layout.position;
	    var bound = params.bound,
	        positionOption = params.positionOption,
	        dimension = params.dimension;
	
	    var labelHeight = _renderUtil2['default'].getRenderedLabelHeight(_const2['default'].MAX_HEIGHT_WORD, this.labelTheme);
	
	    return {
	      left: bound.left + (bound.width - dimension.width) / 2 + positionOption.left - position.left,
	      top: bound.top + bound.height / 2 - labelHeight + positionOption.top - position.top
	    };
	  },
	
	
	  /**
	   * Adjust position.
	   * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	   * @param {{left: number, top: number}} position position
	   * @returns {{left: number, top: number}} adjusted position
	   * @private
	   */
	  _adjustPosition: function _adjustPosition(tooltipDimension, position) {
	    var chartDimension = this.dimensionMap.chart;
	    var areaPosition = this.layout.position;
	
	    position.left = Math.max(position.left, -areaPosition.left);
	    position.left = Math.min(position.left, chartDimension.width - areaPosition.left - tooltipDimension.width);
	    position.top = Math.max(position.top, -areaPosition.top);
	    position.top = Math.min(position.top, chartDimension.height - areaPosition.top - tooltipDimension.height);
	
	    return position;
	  },
	
	
	  /**
	   * Make tooltip position.
	   * @param {object} params parameters
	   *      @param {{left: number, top: number, width: number, height: number}} params.bound graph bound
	   *      @param {string} params.chartType chart type
	   *      @param {boolean} params.allowNegativeTooltip whether allow negative tooltip or not
	   *      @param {{width: number, height: number}} params.dimension tooltip dimension
	   *      @param {string} params.alignOption position option (ex: 'left top')
	   * @returns {{top: number, left: number}} position
	   * @private
	   */
	  _makeTooltipPosition: function _makeTooltipPosition(params) {
	    var position = {};
	
	    if (params.mousePosition) {
	      position = this._makeTooltipPositionToMousePosition(params);
	    } else {
	      var sizeType = void 0,
	          positionType = void 0,
	          addPadding = void 0;
	      if (_predicate2['default'].isBarChart(params.chartType)) {
	        position = this._makeTooltipPositionForBarChart(params);
	        sizeType = 'width';
	        positionType = 'left';
	        addPadding = 1;
	      } else if (_predicate2['default'].isTreemapChart(params.chartType)) {
	        position = this._makeTooltipPositionForTreemapChart(params);
	      } else {
	        position = this._makeTooltipPositionForNotBarChart(params);
	        sizeType = 'height';
	        positionType = 'top';
	        addPadding = -1;
	      }
	
	      if (params.allowNegativeTooltip) {
	        position = this._moveToSymmetry(position, {
	          bound: params.bound,
	          indexes: params.indexes,
	          dimension: params.dimension,
	          chartType: params.chartType,
	          sizeType: sizeType,
	          positionType: positionType,
	          addPadding: addPadding
	        });
	      }
	
	      position = this._adjustPosition(params.dimension, position);
	    }
	
	    return position;
	  },
	
	
	  /**
	   * Move to symmetry.
	   * @param {{left: number, top: number}} position tooltip position
	   * @param {object} params parameters
	   *      @param {{left: number, top: number, width: number, height: number}} params.bound graph bound
	   *      @param {string} params.id tooltip id
	   *      @param {{width: number, height: number}} params.dimension tooltip dimension
	   *      @param {string} params.sizeType size type (width or height)
	   *      @param {string} params.positionType position type (left or top)
	   *      @param {number} params.addPadding add padding
	   * @returns {{left: number, top: number}} moved position
	   * @private
	   */
	  _moveToSymmetry: function _moveToSymmetry(position, params) {
	    var bound = params.bound,
	        sizeType = params.sizeType,
	        positionType = params.positionType,
	        indexes = params.indexes;
	
	    var seriesType = params.seriesType || params.chartType;
	    var value = this.dataProcessor.getValue(indexes.groupIndex, indexes.index, seriesType);
	    var direction = _predicate2['default'].isBarChart(this.chartType) ? -1 : 1;
	
	    if (value < 0) {
	      var tooltipSize = params.dimension[sizeType];
	      var barSize = bound[sizeType];
	      var movedPositionValue = position[positionType] + (barSize + tooltipSize) * direction;
	      position[positionType] = movedPositionValue;
	    }
	
	    return position;
	  },
	
	
	  /**
	   * Whether changed indexes or not.
	   * @param {{groupIndex: number, index: number}} prevIndexes prev indexes
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @returns {boolean} whether changed or not
	   * @private
	   */
	  _isChangedIndexes: function _isChangedIndexes(prevIndexes, indexes) {
	    return !!prevIndexes && (prevIndexes.groupIndex !== indexes.groupIndex || prevIndexes.index !== indexes.index);
	  },
	
	
	  /**
	   * Show tooltip.
	   * @param {HTMLElement} elTooltip tooltip element
	   * @param {{indexes: {groupIndex: number, index: number}, bound: object}} params tooltip data
	   * @param {{left: number, top: number}} prevPosition prev position
	   * @private
	   */
	  _showTooltip: function _showTooltip(elTooltip, params, prevPosition) {
	    var boundingClientRect = this.tooltipContainer.parentNode.getBoundingClientRect();
	    var indexes = params.indexes;
	
	    var prevIndexes = this._getIndexesCustomAttribute(elTooltip);
	    var offset = this.options.offset || {};
	    var positionOption = {};
	    var prevChartType = elTooltip && elTooltip.getAttribute('data-chart-type');
	
	    if (!params.bound && params.mousePosition) {
	      params.bound = {
	        left: params.mousePosition.left - boundingClientRect.left + _const2['default'].CHART_PADDING,
	        top: params.mousePosition.top - boundingClientRect.top + _const2['default'].CHART_PADDING
	      };
	    }
	
	    if (this._isChangedIndexes(prevIndexes, indexes) || prevChartType !== params.chartType) {
	      this.eventBus.fire('hoverOffSeries', prevIndexes, prevChartType);
	    }
	
	    elTooltip.innerHTML = this._makeSingleTooltipHtml(params.seriesType || params.chartType, indexes);
	
	    if (params.chartType === 'line') {
	      this.makeLineLegendIcon(elTooltip.querySelectorAll('.tui-chart-legend-rect.line'));
	    }
	
	    elTooltip.setAttribute('data-chart-type', params.chartType);
	    this._setIndexesCustomAttribute(elTooltip, indexes);
	    this._setShowedCustomAttribute(elTooltip, true);
	
	    this._fireBeforeShowTooltipPublicEvent(indexes, params.silent);
	
	    _domHandler2['default'].addClass(elTooltip, 'show');
	
	    positionOption.left = offset.x || 0;
	    positionOption.top = offset.y || 0;
	
	    var position = this._makeTooltipPosition(_tuiCodeSnippet2['default'].extend({
	      dimension: this.getTooltipDimension(elTooltip),
	      positionOption: positionOption,
	      alignOption: this.options.align || ''
	    }, params));
	
	    this._moveToPosition(elTooltip, position, prevPosition);
	    this.eventBus.fire('hoverSeries', indexes, params.chartType);
	    this._fireAfterShowTooltipPublicEvent(indexes, {
	      element: elTooltip,
	      position: position
	    }, params.silent);
	    delete params.silent;
	  },
	
	
	  /**
	   * To call beforeShowTooltip callback of public event.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	   * @private
	   */
	  _fireBeforeShowTooltipPublicEvent: function _fireBeforeShowTooltipPublicEvent(indexes, silent) {
	    if (silent) {
	      return;
	    }
	
	    var params = this._makeShowTooltipParams(indexes);
	    this.eventBus.fire(_const2['default'].PUBLIC_EVENT_PREFIX + 'beforeShowTooltip', params);
	  },
	
	
	  /**
	   * To call afterShowTooltip callback of public event.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {object} additionParams addition parameters
	   * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	   * @private
	   */
	  _fireAfterShowTooltipPublicEvent: function _fireAfterShowTooltipPublicEvent(indexes, additionParams, silent) {
	    if (silent) {
	      return;
	    }
	
	    var params = this._makeShowTooltipParams(indexes, additionParams);
	    this.eventBus.fire(_const2['default'].PUBLIC_EVENT_PREFIX + 'afterShowTooltip', params);
	  },
	
	
	  /**
	   * Execute hiding tooltip.
	   * @param {HTMLElement} tooltipElement tooltip element
	   * @private
	   */
	  _executeHidingTooltip: function _executeHidingTooltip(tooltipElement) {
	    _domHandler2['default'].removeClass(tooltipElement, 'show');
	    tooltipElement.removeAttribute('data-groupIndex');
	    tooltipElement.removeAttribute('data-index');
	    tooltipElement.style.cssText = '';
	  },
	
	
	  /**
	   * Hide tooltip.
	   * @param {HTMLElement} tooltipElement - tooltip element
	   * @param {object} prevFoundData - data represented by tooltip elements
	   * @param {{silent: {boolean}}} [options] - options for hiding a tooltip element
	   * @private
	   */
	  _hideTooltip: function _hideTooltip(tooltipElement, prevFoundData, options) {
	    var _this = this;
	
	    var indexes = this._getIndexesCustomAttribute(tooltipElement);
	    var chartType = tooltipElement.getAttribute('data-chart-type');
	    var silent = !!(options && options.silent);
	
	    if (_predicate2['default'].isChartToDetectMouseEventOnSeries(chartType)) {
	      this.eventBus.fire('hoverOffSeries', indexes, chartType);
	      this._fireBeforeHideTooltipPublicEvent(indexes, silent);
	      this._executeHidingTooltip(tooltipElement);
	    } else if (chartType) {
	      this._setShowedCustomAttribute(tooltipElement, false);
	      this.eventBus.fire('hoverOffSeries', indexes, chartType);
	
	      if (this._isChangedIndexes(this.prevIndexes, indexes)) {
	        delete this.prevIndexes;
	      }
	
	      setTimeout(function () {
	        if (_this._isShowedTooltip(tooltipElement)) {
	          return;
	        }
	        _this._fireBeforeHideTooltipPublicEvent(indexes, silent);
	        _this._executeHidingTooltip(tooltipElement);
	      }, _const2['default'].HIDE_DELAY);
	    }
	  },
	
	
	  /**
	   * To call afterShowTooltip callback of public event.
	   * @param {{groupIndex: number, index: number}} indexes indexes=
	   * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	   * @private
	   */
	  _fireBeforeHideTooltipPublicEvent: function _fireBeforeHideTooltipPublicEvent(indexes, silent) {
	    var params = void 0;
	    if (silent) {
	      return;
	    }
	
	    this.eventBus.fire(_const2['default'].PUBLIC_EVENT_PREFIX + 'beforeHideTooltip', params);
	  },
	
	
	  /**
	   * On show tooltip container.
	   */
	  onShowTooltipContainer: function onShowTooltipContainer() {
	    this.tooltipContainer.style.zIndex = _const2['default'].TOOLTIP_ZINDEX;
	  },
	
	
	  /**
	   * On hide tooltip container.
	   */
	  onHideTooltipContainer: function onHideTooltipContainer() {
	    this.tooltipContainer.style.zIndex = 0;
	  },
	
	
	  /**
	   * Mix in.
	   * @param {function} func target function
	   * @ignore
	   */
	  mixin: function mixin(func) {
	    _tuiCodeSnippet2['default'].extend(func.prototype, this);
	  }
	}; /**
	    * @fileoverview singleTooltipMixer is single tooltip mixer of map chart.
	    * @author NHN.
	    *         FE Development Lab <dl_javascript@nhn.com>
	    */

/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _templateMaker = __webpack_require__(66);
	
	var _templateMaker2 = _interopRequireDefault(_templateMaker);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	var htmls = {
	  HTML_DEFAULT_TEMPLATE: '<div class="tui-chart-default-tooltip">\n      <div class="tui-chart-tooltip-head {{ categoryVisible }}">{{ category }}</div>\n      <div class="tui-chart-tooltip-body">\n        <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n        <span>{{ legend }}</span>\n        <span class="tui-chart-tooltip-value">{{ label }}{{ suffix }}</span>\n      </div>\n    </div>',
	
	  HTML_PIE_TEMPLATE: '<div class="tui-chart-default-tooltip">\n      <div class="tui-chart-tooltip-head {{ categoryVisible }}">{{ category }}</div>\n      <div class="tui-chart-tooltip-body">\n        <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n        <span>{{ legend }}</span>\n        <span class="tui-chart-tooltip-value">{{ ratioLabel }} ( {{ label }} {{ suffix }})</span>\n      </div>\n    </div>',
	
	  HTML_COORDINATE_TYPE_CHART_TEMPLATE: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-head {{ categoryVisible }}">\n      <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n      {{ category }}\n    </div>\n    <div class="tui-chart-tooltip-body">\n      <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n      <span>{{ legend }}</span>\n      <span class="tui-chart-tooltip-value">{{ label }}</span>\n    </div>\n    <table class="tui-chart-tooltip-body">{{ valueTypes }}</table>\n  </div>',
	
	  HTML_GROUP: '<div class="tui-chart-default-tooltip tui-chart-group-tooltip">\n    <div class="tui-chart-tooltip-head">{{ category }}</div>\n    <table class="tui-chart-tooltip-body">\n      {{ items }}\n    </table>\n  </div>',
	
	  HTML_GROUP_TYPE: '\n  <tr>\n    <td colspan="3" class="tui-chart-tooltip-type">{{ type }}</div>\n  </tr>',
	
	  HTML_GROUP_ITEM: '<tr>\n    <td><div class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></div></td>\n    <td>{{ legend }}</td>\n    <td class="tui-chart-tooltip-value">{{ value }} {{ suffix }}</td>\n  </tr>',
	
	  GROUP_CSS_TEXT: 'background-color:{{ color }}',
	  HTML_MAP_CHART_DEFAULT_TEMPLATE: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-body">\n      <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n      <span>{{ name }}</span>\n      <span class="tui-chart-tooltip-value">{{ value }}{{ suffix }}</span>\n    </div>\n  </div>',
	  HTML_HEATMAP_TEMPLATE: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-head {{ categoryVisible }}">{{ category }}</div>\n    <div class="tui-chart-tooltip-body">\n      <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n      <span>{{ label }}{{ suffix }}</span>\n    </div>\n  </div>',
	  HTML_BOXPLOT_TEMPLATE: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-head {{ categoryVisible }}">{{ category }}</div>\n    <table class="tui-chart-tooltip-body">\n      <tr>\n        <td colspan="2">\n          <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n          {{ legend }}\n        </td>\n      </tr>\n      <tr>\n        <td>Maximum: </td>\n        <td class="tui-chart-tooltip-value">{{ maxLabel }} {{ suffix }}</td>\n      </tr>\n      <tr>\n        <td>Upper Quartile: </td>\n        <td class="tui-chart-tooltip-value">{{ uqLabel }} {{ suffix }}</td>\n      </tr>\n      <tr>\n        <td>Median: </td>\n        <td class="tui-chart-tooltip-value">{{ medianLabel }} {{ suffix }}</td>\n      </tr>\n      <tr>\n        <td>Lower Quartile: </td>\n        <td class="tui-chart-tooltip-value">{{ lqLabel }} {{ suffix }}</td>\n      </tr>\n      <tr>\n        <td>Minimum: </td>\n        <td class="tui-chart-tooltip-value">{{ minLabel }} {{ suffix }}</td>\n      </tr>\n    </table>\n  </div>',
	  HTML_BOXPLOT_OUTLIER: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-head {{ categoryVisible }}">{{ category }}</div>\n      <div class="tui-chart-tooltip-body">\n        <span>{{ legend }}</span>\n      </div>\n      <div class="tui-chart-tooltip-body">\n        <span>Outlier: </span>\n        <span class="tui-chart-tooltip-value">{{ label }} {{ suffix }}</span>\n      </div>\n  </div>',
	  HTML_BULLET_TEMPLATE: '<div class="tui-chart-default-tooltip">\n    <div class="tui-chart-tooltip-body {{ categoryVisible }}">\n      <span class="tui-chart-legend-rect {{ chartType }}" style="{{ cssText }}"></span>\n      <span>{{ category }}</span>\n      <span class="tui-chart-tooltip-value">{{ label }} {{ suffix }}</span>\n    </div>\n  </div>'
	}; /**
	    * @fileoverview This is templates of tooltip.
	    * @author NHN.
	    *         FE Development Lab <dl_javascript@nhn.com>
	    */
	
	exports['default'] = {
	  tplDefault: _templateMaker2['default'].template(htmls.HTML_DEFAULT_TEMPLATE),
	  tplPieChart: _templateMaker2['default'].template(htmls.HTML_PIE_TEMPLATE),
	  tplCoordinatetypeChart: _templateMaker2['default'].template(htmls.HTML_COORDINATE_TYPE_CHART_TEMPLATE),
	  tplGroup: _templateMaker2['default'].template(htmls.HTML_GROUP),
	  tplGroupType: _templateMaker2['default'].template(htmls.HTML_GROUP_TYPE),
	  tplGroupItem: _templateMaker2['default'].template(htmls.HTML_GROUP_ITEM),
	  tplGroupCssText: _templateMaker2['default'].template(htmls.GROUP_CSS_TEXT),
	  tplMapChartDefault: _templateMaker2['default'].template(htmls.HTML_MAP_CHART_DEFAULT_TEMPLATE),
	  tplHeatmapChart: _templateMaker2['default'].template(htmls.HTML_HEATMAP_TEMPLATE),
	  tplBoxplotChartDefault: _templateMaker2['default'].template(htmls.HTML_BOXPLOT_TEMPLATE),
	  tplBoxplotChartOutlier: _templateMaker2['default'].template(htmls.HTML_BOXPLOT_OUTLIER),
	  tplBulletChartDefault: _templateMaker2['default'].template(htmls.HTML_BULLET_TEMPLATE)
	};

/***/ }),
/* 66 */
/***/ (function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	/**
	 * @fileoverview This is template maker.
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	exports['default'] = {
	  /**
	   * This is template maker.
	   * @param {string} html html
	   * @returns {function} template function
	   * @eaxmple
	   *
	   *   var template = templateMaker.template('<span>{{ name }}</span>'),
	   *       result = template({name: 'John');
	   *   console.log(result); // <span>John</span>
	   *
	   */
	  template: function template(html) {
	    return function (data) {
	      var result = html;
	
	      Object.entries(data).forEach(function (_ref) {
	        var _ref2 = _slicedToArray(_ref, 2),
	            key = _ref2[0],
	            value = _ref2[1];
	
	        var regExp = new RegExp('{{\\s*' + key + '\\s*}}', 'g');
	        result = result.replace(regExp, String(value).replace('$', '＄'));
	      });
	
	      return result;
	    };
	  }
	};

/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = groupTooltipFactory;
	
	var _tooltipBase = __webpack_require__(63);
	
	var _tooltipBase2 = _interopRequireDefault(_tooltipBase);
	
	var _groupTooltipPositionModel = __webpack_require__(68);
	
	var _groupTooltipPositionModel2 = _interopRequireDefault(_groupTooltipPositionModel);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _defaultTheme = __webpack_require__(36);
	
	var _defaultTheme2 = _interopRequireDefault(_defaultTheme);
	
	var _tooltipTemplate = __webpack_require__(65);
	
	var _tooltipTemplate2 = _interopRequireDefault(_tooltipTemplate);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Group tooltip component.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION = _const2['default'].TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION,
	    TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION = _const2['default'].TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION,
	    SERIES_EXPAND_SIZE = _const2['default'].SERIES_EXPAND_SIZE,
	    PUBLIC_EVENT_PREFIX = _const2['default'].PUBLIC_EVENT_PREFIX;
	
	/**
	 * @classdesc GroupTooltip component.
	 * @class GroupTooltip
	 * @private
	 */
	
	var GroupTooltip = function (_TooltipBase) {
	  _inherits(GroupTooltip, _TooltipBase);
	
	  /**
	   * Group tooltip component.
	   * @constructs GroupTooltip
	   * @private
	   * @override
	   */
	  function GroupTooltip(params) {
	    _classCallCheck(this, GroupTooltip);
	
	    var _this = _possibleConstructorReturn(this, _TooltipBase.call(this, params));
	
	    _this.prevIndex = null;
	    _this.isBullet = _predicate2['default'].isBulletChart(params.chartType);
	    return _this;
	  }
	
	  /**
	   * Make tooltip html.
	   * @param {string} category category
	   * @param {Array.<{value: string, legend: string, chartType: string, suffix: ?string}>} items items data
	   * @param {string} rawCategory raw category
	   * @param {number} groupIndex group index
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeTooltipHtml = function _makeTooltipHtml(category, items, rawCategory, groupIndex) {
	    var template = _tooltipTemplate2['default'].tplGroupItem;
	    var cssTextTemplate = _tooltipTemplate2['default'].tplGroupCssText;
	    var isBar = _predicate2['default'].isBarTypeChart(this.chartType);
	    var isBoxplot = _predicate2['default'].isBoxplotChart(this.chartType);
	    var colorByPoint = (isBar || isBoxplot) && this.dataProcessor.options.series.colorByPoint;
	    var colors = this._makeColors(this.theme, groupIndex);
	    var prevType = void 0;
	
	    var itemsHtml = items.map(function (item, index) {
	      var type = item.type;
	
	      var typeVisible = type !== 'data' && prevType !== type;
	      var itemHtml = '';
	
	      prevType = type;
	
	      if (!item.value) {
	        return null;
	      }
	
	      if (typeVisible) {
	        itemHtml = _tooltipTemplate2['default'].tplGroupType({
	          type: type
	        });
	      }
	
	      itemHtml += template(_tuiCodeSnippet2['default'].extend({
	        cssText: cssTextTemplate({ color: colorByPoint ? '#aaa' : colors[index] })
	      }, item));
	
	      return itemHtml;
	    }).join('');
	
	    return _tooltipTemplate2['default'].tplGroup({
	      category: category,
	      items: itemsHtml
	    });
	  };
	
	  /**
	   * Set default align option of tooltip.
	   * @private
	   * @override
	   */
	
	
	  GroupTooltip.prototype._setDefaultTooltipPositionOption = function _setDefaultTooltipPositionOption() {
	    if (this.options.align) {
	      return;
	    }
	
	    if (this.isVertical) {
	      this.options.align = TOOLTIP_DEFAULT_GROUP_ALIGN_OPTION;
	    } else {
	      this.options.align = TOOLTIP_DEFAULT_GROUP_HORIZONTAL_ALIGN_OPTION;
	    }
	  };
	
	  /**
	   * Render tooltip component.
	   * @returns {HTMLElement}
	   * @override
	   */
	
	
	  GroupTooltip.prototype.render = function render(data) {
	    var container = _tooltipBase2['default'].prototype.render.call(this, data);
	    var chartDimension = this.dimensionMap.chart;
	    var bound = this.layout;
	
	    if (data.checkedLegends) {
	      this.theme = this._updateLegendTheme(data.checkedLegends);
	    }
	
	    this.positionModel = new _groupTooltipPositionModel2['default'](chartDimension, bound, this.isVertical, this.options);
	
	    return container;
	  };
	
	  /**
	   * Rerender.
	   * @param {{checkedLegends: Array.<boolean>}} data rendering data
	   * @override
	   */
	
	
	  GroupTooltip.prototype.rerender = function rerender(data) {
	    _tooltipBase2['default'].prototype.rerender.call(this, data);
	    this.prevIndex = null;
	
	    if (data.checkedLegends) {
	      this.theme = this._updateLegendTheme(data.checkedLegends);
	    }
	  };
	
	  /**
	   * Zoom.
	   */
	
	
	  GroupTooltip.prototype.zoom = function zoom() {
	    this.prevIndex = null;
	    _tooltipBase2['default'].prototype.zoom.call(this);
	  };
	
	  /**
	   * Update legend theme.
	   * @param {object | Array.<boolean>}checkedLegends checked legends
	   * @returns {{colors: Array.<string>}} legend theme
	   * @private
	   */
	
	
	  GroupTooltip.prototype._updateLegendTheme = function _updateLegendTheme(checkedLegends) {
	    var _this2 = this;
	
	    var colors = [];
	    var chartTypes = Object.keys(this.originalTheme);
	
	    chartTypes.forEach(function (chartType) {
	      var chartColors = _this2.originalTheme[chartType].colors;
	      chartColors.forEach(function (color, index) {
	        var _checkedLegends = checkedLegends[chartType] || checkedLegends;
	        if (_checkedLegends[index]) {
	          colors.push(color);
	        }
	      });
	    });
	
	    return {
	      colors: colors
	    };
	  };
	
	  /**
	   * Make tooltip data.
	   * @returns {Array.<object>} tooltip data
	   * @override
	   */
	
	
	  GroupTooltip.prototype.makeTooltipData = function makeTooltipData() {
	    var _this3 = this;
	
	    var length = this.dataProcessor.getCategoryCount(this.isVertical);
	
	    return this.dataProcessor.getSeriesGroups().map(function (seriesGroup, index) {
	      var values = seriesGroup.map(function (item) {
	        return {
	          type: item.type || 'data',
	          label: item.tooltipLabel || item.label
	        };
	      });
	
	      return {
	        category: _this3.dataProcessor.makeTooltipCategory(index, length - index, _this3.isVertical),
	        values: values
	      };
	    });
	  };
	
	  /**
	   * Make colors.
	   * @param {object} theme tooltip theme
	   * @param {number} [groupIndex] groupIndex
	   * @returns {Array.<string>} colors
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeColors = function _makeColors(theme, groupIndex) {
	    var colorIndex = 0;
	    var legendLabels = this.dataProcessor.getLegendData();
	    var colors = void 0,
	        prevChartType = void 0;
	
	    if (this.isBullet) {
	      return this.dataProcessor.getGraphColors()[groupIndex];
	    }
	
	    if (theme.colors) {
	      return theme.colors;
	    }
	
	    var defaultColors = _defaultTheme2['default'].series.colors.slice(0, legendLabels.length);
	
	    return _tuiCodeSnippet2['default'].pluck(legendLabels, 'chartType').map(function (chartType) {
	      if (prevChartType !== chartType) {
	        colors = theme[chartType] ? theme[chartType].colors : defaultColors;
	        colorIndex = 0;
	      }
	
	      prevChartType = chartType;
	      var color = colors[colorIndex];
	      colorIndex += 1;
	
	      return color;
	    });
	  };
	
	  /**
	   * Make rendering data about legend item.
	   * @param {Array.<string>} values values
	   * @param {number} groupIndex groupIndex
	   * @returns {Array.<{value: string, legend: string, chartType: string, suffix: ?string}>} legend item data.
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeItemRenderingData = function _makeItemRenderingData(values, groupIndex) {
	    var _this4 = this;
	
	    var dataProcessor = this.dataProcessor,
	        suffix = this.suffix;
	
	
	    return values.map(function (data, index) {
	      var item = {
	        value: data.label,
	        type: data.type,
	        suffix: suffix,
	        legend: ''
	      };
	      var legendLabel = void 0;
	
	      if (_this4.isBullet) {
	        legendLabel = dataProcessor.getLegendItem(groupIndex);
	      } else {
	        legendLabel = dataProcessor.getLegendItem(index);
	        item.legend = legendLabel.label;
	      }
	
	      item.chartType = legendLabel.chartType;
	
	      return item;
	    });
	  };
	
	  /**
	   * Make tooltip.
	   * @param {number} groupIndex group index
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeGroupTooltipHtml = function _makeGroupTooltipHtml(groupIndex) {
	    var data = this.data[groupIndex];
	    var htmlString = '';
	
	    if (data) {
	      var items = this._makeItemRenderingData(data.values, groupIndex);
	      htmlString = this.templateFunc(data.category, items, this.getRawCategory(groupIndex), groupIndex);
	    }
	
	    return htmlString;
	  };
	
	  /**
	   * Get tooltip sector element.
	   * @returns {HTMLElement} sector element
	   * @private
	   */
	
	
	  GroupTooltip.prototype._getTooltipSectorElement = function _getTooltipSectorElement() {
	    if (!this.groupTooltipSector) {
	      var groupTooltipSector = this.groupTooltipSector = _domHandler2['default'].create('DIV', 'tui-chart-group-tooltip-sector');
	      _domHandler2['default'].append(this.tooltipContainer, groupTooltipSector);
	    }
	
	    return this.groupTooltipSector;
	  };
	
	  /**
	   * Make bound about tooltip sector of vertical type chart.
	   * @param {number} height height
	   * @param {{start: number, end: number}} range range
	   * @param {boolean} isLine whether line or not
	   * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeVerticalTooltipSectorBound = function _makeVerticalTooltipSectorBound(height, range, isLine) {
	    var width = void 0;
	
	    if (isLine) {
	      width = 1;
	    } else {
	      width = range.end - range.start;
	    }
	
	    return {
	      dimension: {
	        width: width,
	        height: height
	      },
	      position: {
	        left: range.start,
	        top: SERIES_EXPAND_SIZE
	      }
	    };
	  };
	
	  /**
	   * Make bound about tooltip sector of horizontal type chart.
	   * @param {number} width width
	   * @param {{start: number, end:number}} range range
	   * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeHorizontalTooltipSectorBound = function _makeHorizontalTooltipSectorBound(width, range) {
	    return {
	      dimension: {
	        width: width,
	        height: range.end - range.start
	      },
	      position: {
	        left: SERIES_EXPAND_SIZE,
	        top: range.start
	      }
	    };
	  };
	
	  /**
	   * Make bound about tooltip sector.
	   * @param {number} size width or height
	   * @param {{start: number, end:number}} range range
	   * @param {boolean} isVertical whether vertical or not
	   * @param {boolean} isLine whether line type or not
	   * @returns {{dimension: {width: number, height: number}, position: {left: number, top: number}}} bound
	   * @private
	   */
	
	
	  GroupTooltip.prototype._makeTooltipSectorBound = function _makeTooltipSectorBound(size, range, isVertical, isLine) {
	    if (isVertical) {
	      return this._makeVerticalTooltipSectorBound(size, range, isLine);
	    }
	
	    return this._makeHorizontalTooltipSectorBound(size, range);
	  };
	
	  /**
	   * Show tooltip sector.
	   * @param {number} size width or height
	   * @param {{start: number, end:number}} range range
	   * @param {boolean} isVertical whether vertical or not
	   * @param {number} index index
	   * @param {boolean} [isMoving] whether moving or not
	   * @private
	   */
	
	
	  GroupTooltip.prototype._showTooltipSector = function _showTooltipSector(size, range, isVertical, index, isMoving) {
	    var groupTooltipSector = this._getTooltipSectorElement();
	    var isLine = range.start === range.end;
	    var bound = this._makeTooltipSectorBound(size, range, isVertical, isLine);
	
	    if (isLine) {
	      this.eventBus.fire('showGroupTooltipLine', bound);
	    } else {
	      _renderUtil2['default'].renderDimension(groupTooltipSector, bound.dimension);
	      _renderUtil2['default'].renderPosition(groupTooltipSector, bound.position);
	      _domHandler2['default'].addClass(groupTooltipSector, 'show');
	    }
	
	    if (isMoving) {
	      index -= 1;
	    }
	
	    this.eventBus.fire('showGroupAnimation', index);
	  };
	
	  /**
	   * Hide tooltip sector.
	   * @param {number} index index
	   * @private
	   */
	
	
	  GroupTooltip.prototype._hideTooltipSector = function _hideTooltipSector(index) {
	    var groupTooltipSector = this._getTooltipSectorElement();
	
	    if (!_domHandler2['default'].hasClass(groupTooltipSector, 'show')) {
	      this.eventBus.fire('hideGroupTooltipLine');
	    } else {
	      _domHandler2['default'].removeClass(groupTooltipSector, 'show');
	    }
	    this.eventBus.fire('hideGroupAnimation', index);
	    this.eventBus.fire('hideGroupTooltipLine');
	  };
	
	  /**
	   * Show tooltip.
	   * @param {HTMLElement} elTooltip tooltip element
	   * @param {{index: number, range: {start: number, end: number},
	   *          size: number, direction: string, isVertical: boolean
	   *        }} params coordinate event parameters
	   * @param {{left: number, top: number}} prevPosition prev position
	   * @private
	   */
	
	
	  GroupTooltip.prototype._showTooltip = function _showTooltip(elTooltip, params, prevPosition) {
	    if (!_tuiCodeSnippet2['default'].isNull(this.prevIndex)) {
	      this.eventBus.fire('hideGroupAnimation', this.prevIndex);
	    }
	
	    elTooltip.innerHTML = this._makeGroupTooltipHtml(params.index);
	
	    this._fireBeforeShowTooltipPublicEvent(params.index, params.range, params.silent);
	
	    if (document.getElementsByClassName) {
	      this.makeLineLegendIcon(elTooltip.querySelectorAll('.tui-chart-legend-rect.line'));
	    }
	
	    _domHandler2['default'].addClass(elTooltip, 'show');
	
	    this._showTooltipSector(params.size, params.range, params.isVertical, params.index, params.isMoving);
	
	    var dimension = this.getTooltipDimension(elTooltip);
	    var position = this.positionModel.calculatePosition(dimension, params.range);
	
	    this._moveToPosition(elTooltip, position, prevPosition);
	
	    this._fireAfterShowTooltipPublicEvent(params.index, params.range, {
	      element: elTooltip,
	      position: position
	    }, params.silent);
	
	    this.prevIndex = params.index;
	  };
	
	  /**
	   * To call beforeShowTooltip callback of public event.
	   * @param {number} index index
	   * @param {{start: number, end: number}} range range
	   * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	   * @private
	   */
	
	
	  GroupTooltip.prototype._fireBeforeShowTooltipPublicEvent = function _fireBeforeShowTooltipPublicEvent(index, range, silent) {
	    if (silent) {
	      return;
	    }
	
	    this.eventBus.fire(PUBLIC_EVENT_PREFIX + 'beforeShowTooltip', {
	      chartType: this.chartType,
	      index: index,
	      range: range
	    });
	  };
	
	  /**
	   * To call afterShowTooltip callback of public event.
	   * @param {number} index index
	   * @param {{start: number, end: number}} range range
	   * @param {object} additionParams addition parameters
	   * @param {boolean} [silent] - whether invoke a public beforeHideTooltip event or not
	   * @private
	   */
	
	
	  GroupTooltip.prototype._fireAfterShowTooltipPublicEvent = function _fireAfterShowTooltipPublicEvent(index, range, additionParams, silent) {
	    if (silent) {
	      return;
	    }
	    this.eventBus.fire(PUBLIC_EVENT_PREFIX + 'afterShowTooltip', Object.assign({
	      chartType: this.chartType,
	      index: index,
	      range: range
	    }, additionParams));
	  };
	
	  /**
	   * Hide tooltip.
	   * @param {HTMLElement} tooltipElement tooltip element
	   * @param {number} prevFoundIndex - showing tooltip index
	   * @param {object} [options] - options for hiding tooltip
	   * @private
	   */
	
	
	  GroupTooltip.prototype._hideTooltip = function _hideTooltip(tooltipElement, prevFoundIndex, options) {
	    var silent = !!(options && options.silent);
	    this.prevIndex = null;
	    this._fireBeforeHideTooltipPublicEvent(prevFoundIndex, silent);
	    this._hideTooltipSector(prevFoundIndex);
	    _domHandler2['default'].removeClass(tooltipElement, 'show');
	    tooltipElement.style.cssText = '';
	  };
	
	  /**
	   * To call beforeHideTooltip callback of public event.
	   * @param {number} index index
	   * @param {boolean} [silent] - options for hiding tooltip
	   * @private
	   */
	
	
	  GroupTooltip.prototype._fireBeforeHideTooltipPublicEvent = function _fireBeforeHideTooltipPublicEvent(index, silent) {
	    if (silent) {
	      return;
	    }
	
	    this.eventBus.fire(PUBLIC_EVENT_PREFIX + 'beforeHideTooltip', {
	      chartType: this.chartType,
	      index: index
	    });
	  };
	
	  return GroupTooltip;
	}(_tooltipBase2['default']);
	
	/**
	 * groupTooltipFactory
	 * @param {object} params chart options
	 * @returns {object} group tooltip instance
	 * @ignore
	 */
	
	
	function groupTooltipFactory(params) {
	  return new GroupTooltip(params);
	}
	
	groupTooltipFactory.componentType = 'tooltip';
	groupTooltipFactory.GroupTooltip = GroupTooltip;

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview GroupTooltipPositionModel is position model for group tooltip..
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var GroupTooltipPositionModel = function () {
	  /**
	   * GroupTooltipPositionModel is position model for group tooltip.
	   * @constructs GroupTooltipPositionModel
	   * @private
	   * @param {{width: number, height: number}} chartDimension chart dimension
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} areaBound tooltip area bound
	   * @param {boolean} isVertical whether vertical or not
	   * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	   */
	  function GroupTooltipPositionModel(chartDimension, areaBound, isVertical, options) {
	    _classCallCheck(this, GroupTooltipPositionModel);
	
	    /**
	     * chart dimension
	     * @type {{width: number, height: number}}
	     */
	    this.chartDimension = chartDimension;
	
	    /**
	     * tooltip area bound
	     * @type {{dimension: {width: number, height: number}, position: {left: number, top: number}}}
	     */
	    this.areaBound = areaBound;
	
	    /**
	     * Whether vertical or not
	     * @type {boolean}
	     */
	    this.isVertical = isVertical;
	
	    /**
	     * tooltip options
	     * @type {{align: ?string, position: {left: number, top: number}}}
	     */
	    this.options = options;
	
	    /**
	     * For caching
	     * @type {object}
	     */
	    this.positions = {};
	
	    this._setData(chartDimension, areaBound, isVertical, options);
	  }
	
	  /**
	   * Get horizontal direction.
	   * @param {?string} alignOption align option
	   * @returns {string} direction
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._getHorizontalDirection = function _getHorizontalDirection() {
	    var alignOption = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
	
	    var direction = void 0;
	
	    if (alignOption.indexOf('left') > -1) {
	      direction = _const2['default'].TOOLTIP_DIRECTION_BACKWARD;
	    } else if (alignOption.indexOf('center') > -1) {
	      direction = _const2['default'].TOOLTIP_DIRECTION_CENTER;
	    } else {
	      direction = _const2['default'].TOOLTIP_DIRECTION_FORWARD;
	    }
	
	    return direction;
	  };
	
	  /**
	   * Make vertical data.
	   * @param {{width: number, height: number}} chartDimension chart dimension
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} areaBound tooltip area bound
	   * @param {?string} alignOption align option
	   * @returns {{
	   *      positionType: string, sizeType: string, direction: (string),
	   *      areaPosition: number, areaSize: number, chartSize: number,
	   *      basePosition: (number)
	   * }} vertical data
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makeVerticalData = function _makeVerticalData(chartDimension, areaBound, alignOption) {
	    var hDirection = this._getHorizontalDirection(alignOption);
	
	    return {
	      positionType: 'left',
	      sizeType: 'width',
	      direction: hDirection,
	      areaPosition: areaBound.position.left,
	      areaSize: areaBound.dimension.width,
	      chartSize: chartDimension.width,
	      basePosition: _const2['default'].SERIES_EXPAND_SIZE
	    };
	  };
	
	  /**
	   * Get vertical direction.
	   * @param {?string} alignOption align option
	   * @returns {string} direction
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._getVerticalDirection = function _getVerticalDirection(alignOption) {
	    var direction = void 0;
	
	    alignOption = alignOption || '';
	
	    if (alignOption.indexOf('top') > -1) {
	      direction = _const2['default'].TOOLTIP_DIRECTION_BACKWARD;
	    } else if (alignOption.indexOf('bottom') > -1) {
	      direction = _const2['default'].TOOLTIP_DIRECTION_FORWARD;
	    } else {
	      direction = _const2['default'].TOOLTIP_DIRECTION_CENTER;
	    }
	
	    return direction;
	  };
	
	  /**
	   * Make horizontal data.
	   * @param {{width: number, height: number}} chartDimension chart dimension
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} areaBound tooltip area bound
	   * @param {?string} alignOption align option
	   * @returns {{
	   *      positionType: string, sizeType: string, direction: (string),
	   *      areaPosition: number, areaSize: number, chartSize: number,
	   *      basePosition: (number)
	   * }} horizontal data
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makeHorizontalData = function _makeHorizontalData(chartDimension, areaBound, alignOption) {
	    var vDirection = this._getVerticalDirection(alignOption);
	
	    return {
	      positionType: 'top',
	      sizeType: 'height',
	      direction: vDirection,
	      areaPosition: areaBound.position.top,
	      areaSize: areaBound.dimension.height,
	      chartSize: chartDimension.height,
	      basePosition: _const2['default'].SERIES_EXPAND_SIZE
	    };
	  };
	
	  /**
	   * Set data.
	   * @param {{width: number, height: number}} chartDimension chart dimension
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} areaBound tooltip area bound
	   * @param {boolean} isVertical whether vertical or not
	   * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._setData = function _setData(chartDimension, areaBound, isVertical, options) {
	    var verticalData = this._makeVerticalData(chartDimension, areaBound, options.align);
	    var horizontalData = this._makeHorizontalData(chartDimension, areaBound, options.align);
	    var offset = options.offset || {};
	
	    if (isVertical) {
	      this.mainData = verticalData;
	      this.subData = horizontalData;
	    } else {
	      this.mainData = horizontalData;
	      this.subData = verticalData;
	    }
	
	    this.positionOption = {};
	    this.positionOption.left = offset.x || 0;
	    this.positionOption.top = offset.y || 0;
	
	    this.positions = {};
	  };
	
	  /**
	   * Calculate main position value.
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {{start: number, end: number}} range range
	   * @param {object} data data
	   *      @param {string} data.direction direction
	   *      @param {number} data.basePosition basePosition
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._calculateMainPositionValue = function _calculateMainPositionValue(tooltipSize, range, data) {
	    var isLine = range.start === range.end;
	    var lineTypePadding = 9;
	    var otherTypePadding = 5;
	    var padding = isLine ? lineTypePadding : otherTypePadding;
	    var value = data.basePosition;
	
	    if (data.direction === _const2['default'].TOOLTIP_DIRECTION_FORWARD) {
	      value += range.end + padding;
	    } else if (data.direction === _const2['default'].TOOLTIP_DIRECTION_BACKWARD) {
	      value += range.start - tooltipSize - padding;
	    } else if (isLine) {
	      value += range.start - tooltipSize / 2;
	    } else {
	      value += range.start + (range.end - range.start - tooltipSize) / 2;
	    }
	
	    return value;
	  };
	
	  /**
	   * Calculate sub position value.
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.areaSize tooltip area size (width or height)
	   *      @param {string} data.direction direction
	   *      @param {number} data.basePosition basePosition
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._calculateSubPositionValue = function _calculateSubPositionValue(tooltipSize, data) {
	    var middle = data.areaSize / 2;
	    var value = void 0;
	
	    if (data.direction === _const2['default'].TOOLTIP_DIRECTION_FORWARD) {
	      value = middle + data.basePosition;
	    } else if (data.direction === _const2['default'].TOOLTIP_DIRECTION_BACKWARD) {
	      value = middle - tooltipSize + data.basePosition;
	    } else {
	      value = middle - tooltipSize / 2 + data.basePosition;
	    }
	
	    return value;
	  };
	
	  /**
	   * Make position value diff.
	   * @param {number} value positoin value
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.chartSize chart size (width or height)
	   *      @param {number} data.areaPosition tooltip area position (left or top)
	   * @returns {number} diff
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makePositionValueDiff = function _makePositionValueDiff(value, tooltipSize, data) {
	    return value + data.areaPosition + tooltipSize - data.chartSize;
	  };
	
	  /**
	   * Adjust backward position value.
	   * @param {number} value position value
	   * @param {{start: number, end: number}} range range
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.chartSize chart size (width or height)
	   *      @param {number} data.areaPosition tooltip area position (left or top)
	   *      @param {number} data.basePosition basePosition
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._adjustBackwardPositionValue = function _adjustBackwardPositionValue(value, range, tooltipSize, data) {
	    var changedValue = void 0;
	
	    if (value < -data.areaPosition) {
	      changedValue = this._calculateMainPositionValue(tooltipSize, range, {
	        direction: _const2['default'].TOOLTIP_DIRECTION_FORWARD,
	        basePosition: data.basePosition
	      });
	      if (this._makePositionValueDiff(changedValue, tooltipSize, data) > 0) {
	        value = -data.areaPosition;
	      } else {
	        value = changedValue;
	      }
	    }
	
	    return value;
	  };
	
	  /**
	   * Adjust forward position value.
	   * @param {number} value position value
	   * @param {{start: number, end: number}} range range
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.chartSize chart size (width or height)
	   *      @param {number} data.areaPosition tooltip area position (left or top)
	   *      @param {number} data.basePosition basePosition
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._adjustForwardPositionValue = function _adjustForwardPositionValue(value, range, tooltipSize, data) {
	    var diff = this._makePositionValueDiff(value, tooltipSize, data);
	
	    if (diff > 0) {
	      var changedValue = this._calculateMainPositionValue(tooltipSize, range, {
	        direction: _const2['default'].TOOLTIP_DIRECTION_BACKWARD,
	        basePosition: data.basePosition
	      });
	      if (changedValue < -data.areaPosition) {
	        value -= diff;
	      } else {
	        value = changedValue;
	      }
	    }
	
	    return value;
	  };
	
	  /**
	   * Adjust main position value
	   * @param {number} value position value
	   * @param {{start: number, end: number}} range range
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.chartSize chart size (width or height)
	   *      @param {number} data.areaPosition tooltip area position (left or top)
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._adjustMainPositionValue = function _adjustMainPositionValue(value, range, tooltipSize, data) {
	    if (data.direction === _const2['default'].TOOLTIP_DIRECTION_BACKWARD) {
	      value = this._adjustBackwardPositionValue(value, range, tooltipSize, data);
	    } else if (data.direction === _const2['default'].TOOLTIP_DIRECTION_FORWARD) {
	      value = this._adjustForwardPositionValue(value, range, tooltipSize, data);
	    } else {
	      value = Math.max(value, -data.areaPosition);
	      value = Math.min(value, data.chartSize - data.areaPosition - tooltipSize);
	    }
	
	    return value;
	  };
	
	  /**
	   * Adjust sub position value.
	   * @param {number} value position value
	   * @param {number} tooltipSize tooltip size (width or height)
	   * @param {object} data data
	   *      @param {number} data.chartSize chart size (width or height)
	   *      @param {number} data.areaPosition tooltip area position (left or top)
	   *      @param {number} data.basePosition basePosition
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._adjustSubPositionValue = function _adjustSubPositionValue(value, tooltipSize, data) {
	    if (data.direction === _const2['default'].TOOLTIP_DIRECTION_FORWARD) {
	      value = Math.min(value, data.chartSize - data.areaPosition - tooltipSize);
	    } else {
	      value = Math.max(value, -data.areaPosition);
	    }
	
	    return value;
	  };
	
	  /**
	   * Make caching key.
	   * @param {{start: number, end: number}} range range
	   * @returns {string} key
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makeCachingKey = function _makeCachingKey(_ref) {
	    var start = _ref.start,
	        end = _ref.end;
	
	    return start + '-' + end;
	  };
	
	  /**
	   * Add position option.
	   * @param {number} position position
	   * @param {string} positionType position type (left or top)
	   * @returns {number} position
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._addPositionOptionValue = function _addPositionOptionValue(position, positionType) {
	    return position + this.positionOption[positionType];
	  };
	
	  /**
	   * Make main position value.
	   * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	   * @param {{start: number, end: number}} range tooltip sector range
	   * @param {{
	   *      positionType: string, sizeType: string, direction: (string),
	   *      areaPosition: number, areaSize: number, chartSize: number,
	   *      basePosition: (number)
	   * }} main main data
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makeMainPositionValue = function _makeMainPositionValue(tooltipDimension, range, main) {
	    var value = this._calculateMainPositionValue(tooltipDimension[main.sizeType], range, main);
	    value = this._addPositionOptionValue(value, main.positionType);
	    value = this._adjustMainPositionValue(value, range, tooltipDimension[main.sizeType], main);
	
	    return value;
	  };
	
	  /**
	   * Make sub position value.
	   * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	   * @param {{
	   *      positionType: string, sizeType: string, direction: (string),
	   *      areaPosition: number, areaSize: number, chartSize: number,
	   *      basePosition: (number)
	   * }} sub sub data
	   * @returns {number} position value
	   * @private
	   */
	
	
	  GroupTooltipPositionModel.prototype._makeSubPositionValue = function _makeSubPositionValue(tooltipDimension, sub) {
	    var value = this._calculateSubPositionValue(tooltipDimension[sub.sizeType], sub);
	    value = this._addPositionOptionValue(value, sub.positionType);
	    value = this._adjustSubPositionValue(value, tooltipDimension[sub.sizeType], sub);
	
	    return value;
	  };
	
	  /**
	   * Calculate group tooltip position.
	   * @param {{width: number, height: number}} tooltipDimension tooltip dimension
	   * @param {{start: number, end: number}} range tooltip sector range
	   * @returns {{left: number, top: number}} group tooltip position
	   */
	
	
	  GroupTooltipPositionModel.prototype.calculatePosition = function calculatePosition(tooltipDimension, range) {
	    var key = this._makeCachingKey(range);
	    var main = this.mainData;
	    var sub = this.subData;
	    var position = this.positions[key];
	
	    if (!position) {
	      position = {};
	      position[main.positionType] = this._makeMainPositionValue(tooltipDimension, range, main);
	      position[sub.positionType] = this._makeSubPositionValue(tooltipDimension, sub);
	      this.positions[key] = position;
	    }
	
	    return position;
	  };
	
	  /**
	   * Update tooltip options for position calculation.
	   * @param {{align: ?string, position: {left: number, top: number}}} options tooltip options
	   */
	
	
	  GroupTooltipPositionModel.prototype.updateOptions = function updateOptions(options) {
	    this.options = options;
	    this._setData(this.chartDimension, this.areaBound, this.isVertical, options);
	  };
	
	  /**
	   * Update tooltip bound for position calculation.
	   * @param {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }} bound tooltip area bound
	   */
	
	
	  GroupTooltipPositionModel.prototype.updateBound = function updateBound(bound) {
	    this.areaBound = bound;
	    this._setData(this.chartDimension, bound, this.isVertical, this.options);
	  };
	
	  return GroupTooltipPositionModel;
	}();
	
	exports['default'] = GroupTooltipPositionModel;

/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = mapChartTooltipFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _tooltipBase = __webpack_require__(63);
	
	var _tooltipBase2 = _interopRequireDefault(_tooltipBase);
	
	var _singleTooltipMixer = __webpack_require__(64);
	
	var _singleTooltipMixer2 = _interopRequireDefault(_singleTooltipMixer);
	
	var _tooltipTemplate = __webpack_require__(65);
	
	var _tooltipTemplate2 = _interopRequireDefault(_tooltipTemplate);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Tooltip component for map chart.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	/**
	 * @classdesc MapChartTooltip component.
	 * @class MapChartTooltip
	 * @private
	 */
	var MapChartTooltip = function (_TooltipBase) {
	  _inherits(MapChartTooltip, _TooltipBase);
	
	  /**
	   * Map chart tooltip component.
	   * @constructs MapChartTooltip
	   * @private
	   * @override
	   */
	  function MapChartTooltip(params) {
	    _classCallCheck(this, MapChartTooltip);
	
	    /**
	     * Map model
	     * @type {MapChartMapModel}
	     */
	    var _this = _possibleConstructorReturn(this, _TooltipBase.call(this, params));
	
	    _this.mapModel = params.mapModel;
	
	    /**
	     * Color spectrum
	     * @type {ColorSpectrum}
	     */
	    _this.colorSpectrum = params.colorSpectrum;
	    return _this;
	  }
	
	  /**
	   * Make tooltip html.
	   * @param {{name: string, value: number}} datum tooltip datum
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  MapChartTooltip.prototype._makeTooltipHtml = function _makeTooltipHtml(datum) {
	    return _tooltipTemplate2['default'].tplMapChartDefault(datum);
	  };
	
	  /**
	   * Make single tooltip html.
	   * @param {string} chartType chart type
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @returns {string} tooltip html
	   * @private
	   */
	
	
	  MapChartTooltip.prototype._makeSingleTooltipHtml = function _makeSingleTooltipHtml(chartType, indexes) {
	    var datum = this.mapModel.getDatum(indexes.index);
	    var suffix = this.options.suffix ? ' ' + this.options.suffix : '';
	
	    return this.templateFunc({
	      name: datum.name || datum.code,
	      value: datum.label,
	      suffix: suffix,
	      cssText: 'background-color: ' + this.colorSpectrum.getColor(datum.ratio)
	    });
	  };
	
	  /**
	   * Make parameters for show tooltip user event.
	   * @param {{groupIndex: number, index: number}} indexes indexes
	   * @param {object} additionParams addition parameters
	   * @returns {{chartType: string, legend: string, legendIndex: number, index: number}} parameters for show tooltip
	   * @private
	   */
	
	
	  MapChartTooltip.prototype._makeShowTooltipParams = function _makeShowTooltipParams(indexes, additionParams) {
	    var datum = this.mapModel.getDatum(indexes.index);
	    var params = _tuiCodeSnippet2['default'].extend({
	      chartType: this.chartType,
	      code: datum.code,
	      name: datum.name,
	      value: datum.label,
	      index: indexes.index
	    }, additionParams);
	
	    return params;
	  };
	
	  /**
	   * Set default align option of tooltip.
	   * @private
	   * @override
	   */
	
	
	  MapChartTooltip.prototype._setDefaultTooltipPositionOption = function _setDefaultTooltipPositionOption() {
	    if (!this.options.align) {
	      this.options.align = _const2['default'].TOOLTIP_DEFAULT_ALIGN_OPTION;
	    }
	  };
	
	  return MapChartTooltip;
	}(_tooltipBase2['default']);
	
	_singleTooltipMixer2['default'].mixin(MapChartTooltip);
	
	/**
	 * mapChartTooltipFactory
	 * @param {object} params chart options
	 * @returns {object} mapChart tooptip instance
	 * @ignore
	 */
	function mapChartTooltipFactory(params) {
	  return new MapChartTooltip(params);
	}
	
	mapChartTooltipFactory.componentType = 'tooltip';

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = mapChartEventDetectorFactory;
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _eventListener = __webpack_require__(56);
	
	var _eventListener2 = _interopRequireDefault(_eventListener);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview MapChartEventDetector is mouse event detector for map chart.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var MapChartEventDetector = function (_MouseEventDetectorBa) {
	  _inherits(MapChartEventDetector, _MouseEventDetectorBa);
	
	  /**
	   * MapChartEventDetector is mouse event detector for map chart.
	   * @param {object} params parameters
	   *      @param {string} params.chartType - chart type
	   * @constructs MapChartEventDetector
	   * @private
	   * @extends MouseEventDetectorBase
	   */
	  function MapChartEventDetector(params) {
	    _classCallCheck(this, MapChartEventDetector);
	
	    /**
	     * chart type
	     * {string}
	     *
	     */
	    var _this = _possibleConstructorReturn(this, _MouseEventDetectorBa.call(this));
	
	    _this.chartType = params.chartType;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    _this.eventBus = params.eventBus;
	
	    /**
	     * whether mouse down or not
	     * @type {boolean}
	     */
	    _this.isDown = false;
	
	    _this.drawingType = _const2['default'].COMPONENT_TYPE_DOM;
	    return _this;
	  }
	
	  /**
	   * Render event handle layer area
	   * @param {HTMLElement} mouseEventDetectorContainer mouse event detector container element
	   * @private
	   */
	
	
	  MapChartEventDetector.prototype._renderMouseEventDetectorArea = function _renderMouseEventDetectorArea(mouseEventDetectorContainer) {
	    _renderUtil2['default'].renderDimension(mouseEventDetectorContainer, this.layout.dimension);
	    _renderUtil2['default'].renderPosition(mouseEventDetectorContainer, this.layout.position);
	  };
	
	  /**
	   * On click.
	   * @private
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype._onClick = function _onClick() {};
	
	  /**
	   * Call 'dragStartMapSeries' event, when occur mouse down event.
	   * @param {mouseevent} e mouse event
	   * @private
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype._onMousedown = function _onMousedown(e) {
	    this.isDown = true;
	    this.eventBus.fire('dragStartMapSeries', {
	      left: e.clientX,
	      top: e.clientY
	    });
	  };
	
	  /**
	   * Drag end.
	   * @private
	   */
	
	
	  MapChartEventDetector.prototype._dragEnd = function _dragEnd() {
	    this.isDrag = false;
	    _domHandler2['default'].removeClass(this.mouseEventDetectorContainer, 'drag');
	    this.eventBus.fire('dragEndMapSeries');
	  };
	
	  /**
	   * If drag, call dragEnd function.
	   * But if not drag, occur click event.
	   * @param {mouseevent} e mouse event
	   * @private
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype._onMouseup = function _onMouseup(e) {
	    this.isDown = false;
	
	    if (this.isDrag) {
	      this._dragEnd();
	    } else {
	      this._onMouseEvent('click', e);
	    }
	
	    this.isMove = false;
	  };
	
	  /**
	   * If mouse downed, set drag mode.
	   * But if not downed, set move mode.
	   * @param {mouseevent} e mouse event
	   * @private
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype._onMousemove = function _onMousemove(e) {
	    if (this.isDown) {
	      if (!this.isDrag) {
	        _domHandler2['default'].addClass(this.mouseEventDetectorContainer, 'drag');
	      }
	      this.isDrag = true;
	      this.eventBus.fire('dragMapSeries', {
	        left: e.clientX,
	        top: e.clientY
	      });
	    } else {
	      this.isMove = true;
	      this._onMouseEvent('move', e);
	    }
	  };
	
	  /**
	   * If drag mode, call dragEnd.
	   * But if not drag mode, occur move event.
	   * @private
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype._onMouseout = function _onMouseout(e) {
	    if (this.isDrag) {
	      this._dragEnd();
	    } else {
	      this._onMouseEvent('move', e);
	    }
	    this.isDown = false;
	  };
	
	  /**
	   * On mouse wheel.
	   * @param {mouseevent} e mouse event
	   * @returns {?boolean}
	   * @private
	   */
	
	
	  MapChartEventDetector.prototype._onMousewheel = function _onMousewheel(e) {
	    var wheelDelta = e.wheelDelta || e.detail * _const2['default'].FF_WHEELDELTA_ADJUSTING_VALUE;
	
	    this.eventBus.fire('wheel', wheelDelta, {
	      left: e.clientX,
	      top: e.clientY
	    });
	
	    if (e.preventDefault) {
	      e.preventDefault();
	    }
	
	    return false;
	  };
	
	  /**
	   * Attach event.
	   * @param {HTMLElement} target target element
	   * @override
	   */
	
	
	  MapChartEventDetector.prototype.attachEvent = function attachEvent(target) {
	    _mouseEventDetectorBase2['default'].prototype.attachEvent.call(this, target);
	
	    if (_tuiCodeSnippet2['default'].browser.firefox) {
	      _eventListener2['default'].on(target, 'DOMMouseScroll', this._onMousewheel, this);
	    } else {
	      _eventListener2['default'].on(target, 'mousewheel', this._onMousewheel, this);
	    }
	  };
	
	  return MapChartEventDetector;
	}(_mouseEventDetectorBase2['default']);
	
	/**
	 * mapChartEventDetectorFactory
	 * @param {object} params chart options
	 * @returns {object} map chart event detector instance
	 * @ignore
	 */
	
	
	function mapChartEventDetectorFactory(params) {
	  return new MapChartEventDetector(params);
	}
	
	mapChartEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tickBaseCoordinateModel = __webpack_require__(72);
	
	var _tickBaseCoordinateModel2 = _interopRequireDefault(_tickBaseCoordinateModel);
	
	var _boundsBaseCoordinateModel = __webpack_require__(73);
	
	var _boundsBaseCoordinateModel2 = _interopRequireDefault(_boundsBaseCoordinateModel);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _eventListener = __webpack_require__(56);
	
	var _eventListener2 = _interopRequireDefault(_eventListener);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview MouseEventDetectorBase is base class for mouse event detector components.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var MouseEventDetectorBase = function () {
	  /**
	   * MouseEventDetectorBase is base class for mouse event detector components.
	   * @constructs MouseEventDetectorBase
	   * @private
	   * @param {object} params parameters
	   *      @param {string} params.chartType - chart type
	   *      @param {Array.<string>} params.chartTypes - chart types
	   *      @param {boolean} params.isVertical - whether vertical or not
	   *      @param {DataProcessor} params.dataProcessor - DataProcessor instance
	   *      @param {boolean} params.allowSelect - whether has allowSelect option or not
	   */
	  function MouseEventDetectorBase(params) {
	    _classCallCheck(this, MouseEventDetectorBase);
	
	    if (!params) {
	      return;
	    }
	
	    /**
	     * type of chart
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * chartTypes is available in combo chart
	     * @type {Array.<string>}
	     */
	    this.chartTypes = params.chartTypes;
	
	    /**
	     * whether vertical or not
	     * @type {boolean}
	     */
	    this.isVertical = params.isVertical;
	
	    /**
	     * data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * whether allow select series or not
	     * @type {boolean}
	     */
	    this.allowSelect = params.allowSelect;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = params.eventBus;
	
	    /**
	     * layout bounds information for this components
	     * @type {null|{dimension:{width:number, height:number}, position:{left:number, top:number}}}
	     */
	    this.layout = null;
	
	    /**
	     * selected series item.
	     * @type {null | object}
	     */
	    this.selectedData = null;
	
	    var isLineTypeChart = _predicate2['default'].isLineTypeChart(this.chartType, this.chartTypes);
	    /**
	     * expand size
	     * @type {number}
	     */
	    this.expandSize = isLineTypeChart ? _const2['default'].SERIES_EXPAND_SIZE : 0;
	
	    /**
	     * series item bounds data
	     * @type {Array}
	     */
	    this.seriesItemBoundsData = [];
	
	    /**
	     * series count
	     * @type {number}
	     */
	    this.seriesCount = _predicate2['default'].isComboChart(this.chartType) ? 2 : 1;
	
	    this._attachToEventBus();
	
	    this.drawingType = _const2['default'].COMPONENT_TYPE_DOM;
	  }
	
	  /**
	   * Attach to event bus.
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._attachToEventBus = function _attachToEventBus() {
	    this.eventBus.on('receiveSeriesData', this.onReceiveSeriesData, this);
	  };
	
	  /**
	   * Get bound for rendering.
	   * @returns {{
	   *      dimension: {width: number, height: number},
	   *      position: {left: number, top: number}
	   * }}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._getRenderingBound = function _getRenderingBound() {
	    var renderingBound = _renderUtil2['default'].expandBound(this.layout);
	
	    return renderingBound;
	  };
	
	  /**
	   * Render event handle layer area.
	   * @param {HTMLElement} mouseEventDetectorContainer - container element for mouse event detector
	   * @param {number} tickCount - tick count
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._renderMouseEventDetectorArea = function _renderMouseEventDetectorArea(mouseEventDetectorContainer, tickCount) {
	    this.dimension = this.layout.dimension;
	
	
	    var tbcm = new _tickBaseCoordinateModel2['default'](this.layout, tickCount, this.chartType, this.isVertical, this.chartTypes);
	    this.tickBaseCoordinateModel = tbcm;
	
	    var _getRenderingBound2 = this._getRenderingBound(),
	        dimension = _getRenderingBound2.dimension,
	        position = _getRenderingBound2.position;
	
	    _renderUtil2['default'].renderDimension(mouseEventDetectorContainer, dimension);
	    _renderUtil2['default'].renderPosition(mouseEventDetectorContainer, position);
	  };
	
	  /**
	   * Set data for rendering.
	   * @param {{
	   *      layout: {
	   *          dimension: {width: number, height: number},
	   *          position: {left: number, top: number}
	   *      }
	   * }} data - bounds data
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._setDataForRendering = function _setDataForRendering(data) {
	    this.layout = data.layout;
	  };
	
	  /**
	   * Pick tick count.
	   * @param {{xAxis: object, yAxis: object}} axisDataMap - axis data map
	   * @returns {number}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._pickTickCount = function _pickTickCount(axisDataMap) {
	    if (this.isVertical) {
	      return axisDataMap.xAxis.eventTickCount || axisDataMap.xAxis.tickCount;
	    }
	
	    return axisDataMap.yAxis.tickCount;
	  };
	
	  /**
	   * Render for mouseEventDetector component.
	   * @param {object} data - bounds data and tick count
	   * @returns {HTMLElement} container for mouse event detector
	   */
	
	
	  MouseEventDetectorBase.prototype.render = function render(data) {
	    this.positionMap = data.positionMap;
	    var container = data.paper;
	    var tickCount = void 0;
	
	    _domHandler2['default'].addClass(container, 'tui-chart-series-custom-event-area');
	    container.style.backgroundColor = 'aliceblue';
	
	    if (data.axisDataMap.xAxis) {
	      tickCount = this._pickTickCount(data.axisDataMap);
	    }
	
	    this._setDataForRendering(data);
	    this._renderMouseEventDetectorArea(container, tickCount);
	    this.attachEvent(container);
	    this.mouseEventDetectorContainer = container;
	
	    this.transparentChild = this._createTransparentChild();
	    _domHandler2['default'].append(container, this.transparentChild);
	
	    return container;
	  };
	
	  /**
	   * Create a transparent element
	   * @param {string} height - value of css heigth property
	   * @returns {HTMLElement} transparent element
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._createTransparentChild = function _createTransparentChild() {
	    var child = document.createElement('DIV');
	    var style = child.style;
	
	
	    style.backgroundColor = '#fff';
	    style.height = _renderUtil2['default'].getStyle(this.mouseEventDetectorContainer).height;
	    _renderUtil2['default'].setOpacity(child, 0);
	
	    return child;
	  };
	
	  /**
	   * Calculate layer position by client position.
	   * @param {number} clientX - clientX
	   * @param {number} [clientY] - clientY
	   * @param {boolean} [checkLimit] - whether check limit or not
	   * @returns {{x: number, y: ?number}}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._calculateLayerPosition = function _calculateLayerPosition(clientX, clientY, checkLimit) {
	    var _mouseEventDetectorCo = this.mouseEventDetectorContainer.getBoundingClientRect(),
	        left = _mouseEventDetectorCo.left,
	        right = _mouseEventDetectorCo.right,
	        top = _mouseEventDetectorCo.top;
	
	    var seriesPosition = this.positionMap.series;
	    var expandSize = this.expandSize;
	
	    var layerPosition = {};
	
	    checkLimit = _tuiCodeSnippet2['default'].isUndefined(checkLimit) ? true : checkLimit;
	
	    if (checkLimit) {
	      var maxLeft = right - expandSize;
	      var minLeft = left + expandSize;
	      clientX = Math.min(Math.max(clientX, minLeft), maxLeft);
	    }
	
	    layerPosition.x = clientX - left + seriesPosition.left - _const2['default'].CHART_PADDING;
	
	    if (!_tuiCodeSnippet2['default'].isUndefined(clientY)) {
	      layerPosition.y = clientY - top + seriesPosition.top - _const2['default'].CHART_PADDING;
	    }
	
	    return layerPosition;
	  };
	
	  /**
	   * Create BoundsBaseCoordinateModel from seriesItemBoundsData for mouse event detector.
	   * @param {{chartType: string, data: object}} seriesItemBoundsDatum - series item bounds datum
	   */
	
	
	  MouseEventDetectorBase.prototype.onReceiveSeriesData = function onReceiveSeriesData(seriesItemBoundsDatum) {
	    var seriesCount = this.seriesCount;
	    var seriesItemBoundsData = this.seriesItemBoundsData;
	
	
	    if (seriesItemBoundsData.length === seriesCount) {
	      seriesItemBoundsData = [];
	    }
	
	    seriesItemBoundsData.push(seriesItemBoundsDatum);
	
	    if (seriesItemBoundsData.length === seriesCount) {
	      this.boundsBaseCoordinateModel = new _boundsBaseCoordinateModel2['default'](seriesItemBoundsData);
	    }
	  };
	
	  /**
	   * Rerender mouse event detector component.
	   * @param {object} data - bounds data and tick count
	   */
	
	
	  MouseEventDetectorBase.prototype.rerender = function rerender(data) {
	    var tickCount = void 0;
	
	    this.positionMap = data.positionMap;
	
	    if (data.axisDataMap.xAxis) {
	      tickCount = this._pickTickCount(data.axisDataMap);
	    }
	
	    this.selectedData = null;
	    this._setDataForRendering(data);
	    this._renderMouseEventDetectorArea(this.mouseEventDetectorContainer, tickCount);
	
	    this.transparentChild.style.height = _renderUtil2['default'].getStyle(this.mouseEventDetectorContainer).height;
	  };
	
	  /**
	   * Rerender, when resizing chart.
	   * @param {object} data - bounds data and tick count
	   */
	
	
	  MouseEventDetectorBase.prototype.resize = function resize(data) {
	    this.containerBound = null;
	    this.rerender(data);
	  };
	
	  /**
	   * Whether changed select data or not.
	   * @param {object} prev - previous data
	   * @param {object} cur - current data
	   * @returns {boolean}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._isChangedSelectData = function _isChangedSelectData(prev, cur) {
	    return !prev || !cur || prev.chartType !== cur.chartType || prev.indexes.groupIndex !== cur.indexes.groupIndex || prev.indexes.index !== cur.indexes.index;
	  };
	
	  /**
	   * Find coordinate data from boundsCoordinateModel.
	   * @param {{x: number, y: number}} layerPosition - layer position
	   * @returns {object}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._findDataFromBoundsCoordinateModel = function _findDataFromBoundsCoordinateModel(layerPosition) {
	    var layerX = layerPosition.x;
	    var layerY = layerPosition.y;
	    var groupIndex = void 0;
	
	    if (_predicate2['default'].isTreemapChart(this.chartType)) {
	      groupIndex = 0;
	    } else {
	      groupIndex = this.tickBaseCoordinateModel.findIndex(this.isVertical ? layerX : layerY);
	    }
	
	    return this.boundsBaseCoordinateModel.findData(groupIndex, layerX, layerY);
	  };
	
	  /**
	   * Find data.
	   * @param {number} clientX - clientX
	   * @param {number} clientY - clientY
	   * @returns {object}
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._findData = function _findData(clientX, clientY) {
	    var layerPosition = this._calculateLayerPosition(clientX, clientY);
	
	    return this._findDataFromBoundsCoordinateModel(layerPosition);
	  };
	
	  /**
	   * Show tooltip
	   * @private
	   * @abstract
	   */
	
	
	  MouseEventDetectorBase.prototype._showTooltip = function _showTooltip() {};
	
	  /**
	   * hide tooltip
	   * @private
	   * @abstract
	   */
	
	
	  MouseEventDetectorBase.prototype._hideTooltip = function _hideTooltip() {};
	
	  /**
	   * When mouse event happens,
	   * hide MouseEventDetector container so that detect event of series elements
	   * and send mouse position data to series component
	   * @param {string} eventType - mouse event detector type
	   * @param {MouseEvent} e - mouse event
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._onMouseEvent = function _onMouseEvent(eventType, e) {
	    _domHandler2['default'].addClass(this.mouseEventDetectorContainer, 'hide');
	    this.eventBus.fire(eventType + 'Series', {
	      left: e.clientX,
	      top: e.clientY
	    });
	    _domHandler2['default'].removeClass(this.mouseEventDetectorContainer, 'hide');
	  };
	
	  /**
	   * deselect selected data.
	   * @ignore
	   */
	
	
	  MouseEventDetectorBase.prototype.unselectSeries = function unselectSeries() {
	    if (this.selectedData) {
	      this.eventBus.fire('unselectSeries', this.selectedData);
	      this.selectedData = null;
	    }
	  };
	
	  /**
	   * Call 'selectSeries' event, when changed found position data.
	   * And call 'unselectSeries' event, when not changed found position data.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._onClick = function _onClick(e) {
	    var foundData = this._findData(e.clientX, e.clientY);
	    this.selectSeries(foundData);
	  };
	
	  /**
	   * To call selectSeries callback of public event.
	   * @TODO: Need to change the selectedData location (Not used for mouse events only)
	   * @param {object} seriesData - series data
	   * @param {?boolean} shouldSelect - whether should select or not
	   */
	
	
	  MouseEventDetectorBase.prototype.selectSeries = function selectSeries(seriesData) {
	    var shouldSelect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
	
	    if (!this._isChangedSelectData(this.selectedData, seriesData)) {
	      this.unselectSeries();
	    } else if (seriesData) {
	      if (this.selectedData) {
	        this.unselectSeries();
	      }
	
	      this.eventBus.fire('selectSeries', seriesData, shouldSelect);
	      if (this.allowSelect) {
	        this.selectedData = seriesData;
	      }
	    }
	  };
	
	  /**
	   * On mouse down
	   * @private
	   * @abstract
	   */
	
	
	  MouseEventDetectorBase.prototype._onMousedown = function _onMousedown() {};
	
	  /**
	   * On mouse up
	   * @private
	   * @abstract
	   */
	
	
	  MouseEventDetectorBase.prototype._onMouseup = function _onMouseup() {};
	
	  /**
	   * Store client position, when occur mouse move event.
	   * @param {MouseEvent} e - mouse event
	   * @abstract
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._onMousemove = function _onMousemove() {};
	
	  /**
	   * Abstract mouseout handler
	   * @abstract
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._onMouseout = function _onMouseout() {};
	
	  /**
	   * Attach mouse event.
	   * @param {HTMLElement} target - target element
	   */
	
	
	  MouseEventDetectorBase.prototype.attachEvent = function attachEvent(target) {
	    _eventListener2['default'].on(target, {
	      click: this._onClick,
	      mousedown: this._onMousedown,
	      mouseup: this._onMouseup,
	      mousemove: this._onMousemove,
	      mouseout: this._onMouseout
	    }, this);
	  };
	
	  /**
	   * find data by indexes
	   * @abstract
	   */
	
	
	  MouseEventDetectorBase.prototype.findDataByIndexes = function findDataByIndexes() {};
	
	  /**
	   * Set prevClientPosition by MouseEvent
	   * @param {?MouseEvent} event - mouse event
	   * @private
	   */
	
	
	  MouseEventDetectorBase.prototype._setPrevClientPosition = function _setPrevClientPosition(event) {
	    if (!event) {
	      this.prevClientPosition = null;
	    } else {
	      this.prevClientPosition = {
	        x: event.clientX,
	        y: event.clientY
	      };
	    }
	  };
	
	  return MouseEventDetectorBase;
	}();
	
	_tuiCodeSnippet2['default'].CustomEvents.mixin(MouseEventDetectorBase);
	
	exports['default'] = MouseEventDetectorBase;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview TickBaseDataModel is tick base data model.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var TickBaseDataModel = function () {
	  /**
	   * TickBaseDataModel is tick base data model.
	   * @param {{
	   *     dimension: {
	   *         width: number,
	   *         height: number
	   *     }, position: {
	   *         left: number,
	   *         top: number
	   *     }
	   * }} layout layout
	   * @param {number} tickCount tick count
	   * @param {string} chartType chart type
	   * @param {boolean} isVertical whether vertical or not
	   * @param {Array.<string>} [chartTypes] - chart types of combo chart
	   * @constructs TickBaseDataModel
	   * @private
	   */
	  function TickBaseDataModel(layout, tickCount, chartType, isVertical, chartTypes) {
	    _classCallCheck(this, TickBaseDataModel);
	
	    /**
	     * whether line type or not
	     * @type {boolean}
	     */
	    this.isLineType = _predicate2['default'].isLineTypeChart(chartType, chartTypes);
	
	    this.data = this._makeData(layout, tickCount, isVertical);
	  }
	
	  /**
	   * Get each tick ranges
	   * @param {number} tickCount tick count
	   * @param {number} firstPosition first position value
	   * @param {number} tickInterval tick distance
	   * @returns {Array.<object>}
	   * @private
	   */
	
	
	  TickBaseDataModel.prototype._getRanges = function _getRanges(tickCount, firstPosition, tickInterval) {
	    var prev = firstPosition;
	    var halfInterval = tickInterval / 2;
	
	    return _tuiCodeSnippet2['default'].range(0, tickCount).map(function () {
	      var limit = {
	        min: prev - halfInterval,
	        max: prev + halfInterval
	      };
	
	      prev += tickInterval;
	
	      return limit;
	    });
	  };
	
	  /**
	   * Make tick base data about line type chart.
	   * @param {number} width width
	   * @param {number} tickCount tick count
	   * @param {number} firstPosition firstPosition of group
	   * @returns {Array} tick base data
	   * @private
	   */
	
	
	  TickBaseDataModel.prototype._makeLineTypeData = function _makeLineTypeData(width, tickCount, firstPosition) {
	    var tickInterval = (width + 1) / (tickCount - 1);
	    var ranges = this._getRanges(tickCount, firstPosition || 0, tickInterval);
	
	    ranges[tickCount - 1].max -= 1;
	
	    return ranges;
	  };
	
	  /**
	   * Make tick base data about non line type chart.
	   * @param {number} size width or height
	   * @param {number} tickCount tick count
	   * @param {number} firstPosition firstPosition of group
	   * @returns {Array} tick base data
	   * @private
	   */
	
	
	  TickBaseDataModel.prototype._makeNormalData = function _makeNormalData(size, tickCount, firstPosition) {
	    var len = tickCount - 1;
	    var tickInterval = size / len;
	    var prev = firstPosition || 0;
	
	    return _tuiCodeSnippet2['default'].range(0, len).map(function () {
	      var max = _arrayUtil2['default'].min([size + prev, tickInterval + prev]);
	      var limit = {
	        min: prev,
	        max: max
	      };
	      prev = max;
	
	      return limit;
	    });
	  };
	
	  /**
	   * Make tick base data for mouse event detector.
	   * @param {{dimension: object, position: object}} layout layout
	   * @param {number} tickCount tick count
	   * @param {boolean} isVertical whether vertical or not
	   * @returns {Array.<object>} tick base data
	   * @private
	   */
	
	
	  TickBaseDataModel.prototype._makeData = function _makeData(layout, tickCount, isVertical) {
	    var sizeType = isVertical ? 'width' : 'height';
	    var positionType = isVertical ? 'left' : 'top';
	
	    if (this.isLineType) {
	      return this._makeLineTypeData(layout.dimension[sizeType], tickCount, layout.position[positionType]);
	    }
	
	    return this._makeNormalData(layout.dimension[sizeType], tickCount, layout.position[positionType]);
	  };
	
	  /**
	   * Find index.
	   * @param {number} pointValue mouse position point value
	   * @returns {number} group index
	   */
	
	
	  TickBaseDataModel.prototype.findIndex = function findIndex(pointValue) {
	    var foundIndex = -1;
	
	    this.data.forEach(function (limit, index) {
	      if (limit.min < pointValue && limit.max >= pointValue) {
	        foundIndex = index;
	
	        return false;
	      }
	
	      return true;
	    });
	
	    return foundIndex;
	  };
	
	  /**
	   * Get last index.
	   * @returns {number}
	   */
	
	
	  TickBaseDataModel.prototype.getLastIndex = function getLastIndex() {
	    return this.data.length - 1;
	  };
	
	  /**
	   * Make range of tooltip position.
	   * @param {number} index index
	   * @param {number} positionValue positionValue
	   * @returns {{start: number, end: number}} range type value
	   * @private
	   */
	
	
	  TickBaseDataModel.prototype.makeRange = function makeRange(index, positionValue) {
	    var limit = this.data[index];
	    var range = void 0,
	        center = void 0;
	
	    if (this.isLineType) {
	      center = parseInt(limit.max - (limit.max - limit.min) / 2, 10);
	      range = {
	        start: center,
	        end: center
	      };
	    } else {
	      range = {
	        start: limit.min - (positionValue || 0),
	        end: limit.max - (positionValue || 0)
	      };
	    }
	
	    return range;
	  };
	
	  return TickBaseDataModel;
	}();
	
	exports['default'] = TickBaseDataModel;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview BoundsBaseCoordinateModel is data model for mouse event detector of bounds type.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	/**
	 * position
	 * @typedef {{left: number, top: number}} position
	 * @private
	 */
	
	/**
	 * bound
	 * @typedef {{
	 *      dimension: {width: number, height: number},
	 *      position: position
	 *}} bound
	 * @private
	 */
	
	/**
	 * group bound
	 *  @typedef {Array.<Array.<bound>>} groupBound
	 * @private
	 */
	
	/**
	 * group position
	 *  @typedef {Array.<Array.<position>>} groupPosition
	 * @private
	 */
	
	/**
	 * series info
	 * @typedef {{
	 *      chartType: {string},
	 *      data: {
	 *          groupBounds: ?groupBound,
	 *          groupValues: ?Array.<Array.<number>>,
	 *          groupPositions: ?groupPosition
	 *      }
	 *}} seriesInfo
	 * @private
	 */
	
	var BoundsBaseCoordinateModel = function () {
	  /**
	   * BoundsBaseCoordinateModel is data mode for mouse event detector of bounds type.
	   * @constructs BoundsBaseCoordinateModel
	   * @private
	   * @param {Array} seriesItemBoundsData - series item bounds data
	   */
	  function BoundsBaseCoordinateModel(seriesItemBoundsData) {
	    _classCallCheck(this, BoundsBaseCoordinateModel);
	
	    this.data = this._makeData(seriesItemBoundsData);
	  }
	
	  /**
	   * @param {string} chartType - chart type
	   * @param {object} indexes - index of SeriesDataModel
	   * @param {boolean} allowNegativeTooltip - whether allow negative tooltip or not
	   * @param {object} bound - coordinate data for rendering graph
	   * @returns {object} - `sendData`: tooltip contents, `bound`: for detecting hovered or not
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._makeTooltipData = function _makeTooltipData(chartType, indexes, allowNegativeTooltip, bound) {
	    return {
	      sendData: {
	        chartType: chartType,
	        indexes: indexes,
	        allowNegativeTooltip: allowNegativeTooltip,
	        bound: bound
	      },
	      bound: {
	        left: bound.left,
	        top: bound.top,
	        right: bound.left + bound.width,
	        bottom: bound.top + bound.height
	      }
	    };
	  };
	
	  /**
	   * Make position data for rect type graph
	   * @param {groupBound} groupBounds group bounds
	   * @param {string} chartType chart type
	   * @returns {Array}
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._makeRectTypePositionData = function _makeRectTypePositionData(groupBounds, chartType) {
	    var _this = this;
	
	    var allowNegativeTooltip = !_predicate2['default'].isBoxTypeChart(chartType);
	
	    return groupBounds.map(function (bounds, groupIndex) {
	      return bounds.map(function (bound, index) {
	        if (!bound) {
	          return null;
	        }
	
	        return _this._makeTooltipData(chartType, {
	          groupIndex: groupIndex,
	          index: index
	        }, allowNegativeTooltip, bound.end || bound);
	      });
	    });
	  };
	
	  /**
	   * Make position data for rect type graph
	   * @param {groupBound} groupBounds group bounds
	   * @param {string} chartType chart type
	   * @param {object} resultData resultData
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._makeOutliersPositionDataForBoxplot = function _makeOutliersPositionDataForBoxplot(groupBounds, chartType, resultData) {
	    var _this2 = this;
	
	    var allowNegativeTooltip = !_predicate2['default'].isBoxTypeChart(chartType);
	    var _groupBounds = [].concat(_toConsumableArray(groupBounds));
	
	    _groupBounds.forEach(function (bounds, groupIndex) {
	      bounds.forEach(function (bound, index) {
	        var outliers = void 0;
	
	        if (bound.outliers && bound.outliers.length) {
	          outliers = bound.outliers.map(function (outlier, outlierIndex) {
	            var outlierBound = {
	              top: outlier.top - 3,
	              left: outlier.left - 3,
	              width: 6,
	              height: 6
	            };
	
	            return _this2._makeTooltipData(chartType, {
	              groupIndex: groupIndex,
	              index: index,
	              outlierIndex: outlierIndex
	            }, allowNegativeTooltip, outlierBound);
	          });
	
	          resultData[groupIndex] = resultData[groupIndex].concat(outliers);
	        }
	      });
	    });
	  };
	
	  /**
	   * Make position data for dot type graph
	   * @param {groupPositions} groupPositions group positions
	   * @param {string} chartType chart type
	   * @returns {Array.<Array.<object>>}
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._makeDotTypePositionData = function _makeDotTypePositionData(groupPositions, chartType) {
	    if (!groupPositions) {
	      return [];
	    }
	
	    return _arrayUtil2['default'].pivot(groupPositions).map(function (positions, groupIndex) {
	      return positions.map(function (position, index) {
	        if (!position) {
	          return null;
	        }
	
	        return {
	          sendData: {
	            chartType: chartType,
	            indexes: {
	              groupIndex: groupIndex,
	              index: index
	            },
	            bound: position
	          },
	          bound: {
	            left: position.left - _const2['default'].DOT_RADIUS,
	            top: position.top - _const2['default'].DOT_RADIUS,
	            right: position.left + _const2['default'].DOT_RADIUS,
	            bottom: position.top + _const2['default'].DOT_RADIUS
	          }
	        };
	      });
	    });
	  };
	
	  /**
	   * Join data.
	   * @param {Array.<Array.<Array.<object>>>} dataGroupSet data group set
	   * @returns {Array.<Array.<object>>} joined data
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._joinData = function _joinData(dataGroupSet) {
	    var results = [];
	    dataGroupSet.forEach(function (dataGroup) {
	      dataGroup.forEach(function (data, index) {
	        var additionalIndex = void 0;
	
	        if (!results[index]) {
	          results[index] = data;
	        } else {
	          additionalIndex = results[index].length;
	          data.forEach(function (datum) {
	            if (datum) {
	              datum.sendData.indexes.legendIndex = datum.sendData.indexes.index + additionalIndex;
	            }
	          });
	          results[index] = results[index].concat(data);
	        }
	      });
	    });
	
	    return results;
	  };
	
	  /**
	   * Make data for detecting mouse event.
	   * @param {Array} seriesItemBoundsData - series item bounds data
	   * @returns {Array.<Array.<object>>} coordinate data
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._makeData = function _makeData(seriesItemBoundsData) {
	    var _this3 = this;
	
	    var data = seriesItemBoundsData.map(function (info) {
	      var result = void 0;
	
	      if (_predicate2['default'].isLineTypeChart(info.chartType)) {
	        result = _this3._makeDotTypePositionData(info.data.groupPositions, info.chartType);
	      } else {
	        result = _this3._makeRectTypePositionData(info.data.groupBounds, info.chartType);
	      }
	
	      if (_predicate2['default'].isBoxplotChart(info.chartType)) {
	        _this3._makeOutliersPositionDataForBoxplot(info.data.groupBounds, info.chartType, result);
	      }
	
	      return result;
	    });
	
	    return this._joinData(data);
	  };
	
	  /**
	   * Find candidates.
	   * @param {{bound: {left: number, top: number, right: number, bottom: number}}} data data *
	   * @param {number} layerX layerX
	   * @param {number} layerY layerY
	   * @returns {Array.<{sendData: object}>} candidates
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._findCandidates = function _findCandidates(data, layerX, layerY) {
	    var _this4 = this;
	
	    return data.filter(function (datum) {
	      var bound = datum && datum.bound;
	
	      if (bound) {
	        if (bound.top === bound.bottom) {
	          bound.top -= _const2['default'].SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	          bound.bottom += _const2['default'].SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	        }
	        if (bound.left === bound.right) {
	          bound.left -= _const2['default'].SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	          bound.right += _const2['default'].SERIES_EXTRA_EVENT_AREA_FOR_ZERO;
	        }
	
	        return _this4._isCandidateTarget(bound, {
	          layerX: layerX,
	          layerY: layerY
	        });
	      }
	
	      return false;
	    });
	  };
	
	  /**
	   * Whether candidate target.
	   * @param {{left: number, top: number, right: number, bottom: number}} bound bound info
	   * @param {object} layout layout position
	   *   @param {number} layout.layerX layerX
	   *   @param {number} layout.layerY layerY
	   * @returns {boolean} is target
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._isCandidateTarget = function _isCandidateTarget(bound, _ref) {
	    var layerX = _ref.layerX,
	        layerY = _ref.layerY;
	
	    var includedX = bound.left <= layerX && bound.right >= layerX;
	    var includedY = bound.top <= layerY && bound.bottom >= layerY;
	
	    return includedX && includedY;
	  };
	
	  /**
	   * Find data.
	   * @param {number} groupIndex group index
	   * @param {number} layerX mouse position x
	   * @param {number} layerY mouse position y
	   * @returns {object} tooltip data
	   */
	
	
	  BoundsBaseCoordinateModel.prototype.findData = function findData(groupIndex, layerX, layerY) {
	    var min = 10000;
	    var result = null;
	
	    if (groupIndex > -1 && this.data[groupIndex]) {
	      // extract data containing layerX, layerY
	      var candidates = this._findCandidates(this.data[groupIndex], layerX, layerY);
	
	      // find nearest data to top position among extracted data
	      candidates.forEach(function (data) {
	        var diff = Math.abs(layerY - data.bound.top);
	
	        if (min > diff) {
	          min = diff;
	          result = data.sendData;
	        }
	      });
	    }
	
	    return result;
	  };
	
	  /**
	   * Find data by indexes.
	   * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	   * @param {number} [indexes.outlierIndex] - index of outlier of boxplot series, it only exists in boxplot chart
	   * @returns {object} tooltip data
	   */
	
	
	  BoundsBaseCoordinateModel.prototype.findDataByIndexes = function findDataByIndexes(indexes) {
	    var foundData = this.data[indexes.index][indexes.seriesIndex].sendData;
	
	    if (_tuiCodeSnippet2['default'].isNumber(indexes.outlierIndex)) {
	      return this._findOutlierDataByIndexes(indexes);
	    }
	
	    return foundData;
	  };
	
	  /**
	   * find plot chart data by indexes
	   * @param {{
	   *  index: {number},
	   *  seriesIndex: {number},
	   *  outlierIndex: {number}
	   * }} indexes - indexe of series item displaying a tooltip
	   * @returns {object} - outlier tooltip data
	   * @private
	   */
	
	
	  BoundsBaseCoordinateModel.prototype._findOutlierDataByIndexes = function _findOutlierDataByIndexes(indexes) {
	    var foundData = null;
	
	    this.data[indexes.index].forEach(function (datum) {
	      var datumIndexes = datum.sendData.indexes;
	      var found = datumIndexes.index === indexes.seriesIndex && datumIndexes.outlierIndex === indexes.outlierIndex;
	
	      if (found) {
	        foundData = datum.sendData;
	      }
	
	      return !found;
	    });
	
	    return foundData;
	  };
	
	  return BoundsBaseCoordinateModel;
	}();
	
	exports['default'] = BoundsBaseCoordinateModel;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = mouseEventDetectorFactory;
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _areaTypeEventDetector = __webpack_require__(75);
	
	var _areaTypeEventDetector2 = _interopRequireDefault(_areaTypeEventDetector);
	
	var _simpleEventDetector = __webpack_require__(78);
	
	var _simpleEventDetector2 = _interopRequireDefault(_simpleEventDetector);
	
	var _groupTypeEventDetector = __webpack_require__(79);
	
	var _groupTypeEventDetector2 = _interopRequireDefault(_groupTypeEventDetector);
	
	var _boundsTypeEventDetector = __webpack_require__(80);
	
	var _boundsTypeEventDetector2 = _interopRequireDefault(_boundsTypeEventDetector);
	
	var _mapChartEventDetector = __webpack_require__(70);
	
	var _mapChartEventDetector2 = _interopRequireDefault(_mapChartEventDetector);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Factory for MouseEventDetector
	 * @param {object} params parameter
	 * @returns {object}
	 * @ignore
	 */
	/**
	 * @author NHN.
	 *         FE Development Lab <dl_javascript@nhn.com>
	 */
	
	function mouseEventDetectorFactory(params) {
	  var chartOptions = params.chartOptions,
	      seriesTypes = params.seriesTypes;
	  var chartType = chartOptions.chartType,
	      _chartOptions$series = chartOptions.series,
	      zoomable = _chartOptions$series.zoomable,
	      seriesAllowSelect = _chartOptions$series.allowSelect;
	
	  var factory = void 0;
	
	  if (params.chartOptions.tooltip.grouped) {
	    factory = _groupTypeEventDetector2['default'];
	  } else if (_predicate2['default'].isMapChart(chartType)) {
	    factory = _mapChartEventDetector2['default'];
	  } else if (_predicate2['default'].isBarTypeChart(chartType) || _predicate2['default'].isBoxplotChart(chartType) || _predicate2['default'].isHeatmapChart(chartType) || _predicate2['default'].isTreemapChart(chartType) || _predicate2['default'].isBulletChart(chartType)) {
	    factory = _boundsTypeEventDetector2['default'];
	  } else if (_predicate2['default'].isCoordinateTypeChart(chartType) || _predicate2['default'].isPieChart(chartType) || _predicate2['default'].isPieDonutComboChart(chartType, seriesTypes)) {
	    factory = _simpleEventDetector2['default'];
	  } else {
	    factory = _areaTypeEventDetector2['default'];
	  }
	
	  params.chartType = chartType;
	  // @todo replace chartType, chartTypes to seriesTypes, problem of the whole component
	  params.chartTypes = seriesTypes;
	  params.zoomable = zoomable;
	  params.allowSelect = seriesAllowSelect;
	
	  return factory(params);
	}
	
	mouseEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = areaTypeEventDetectorFactory;
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _zoomMixer = __webpack_require__(76);
	
	var _zoomMixer2 = _interopRequireDefault(_zoomMixer);
	
	var _areaTypeDataModel = __webpack_require__(77);
	
	var _areaTypeDataModel2 = _interopRequireDefault(_areaTypeDataModel);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview AreaTypeEventDetector is mouse event detector for line type chart.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	
	var AreaTypeEventDetector = function (_MouseEventDetectorBa) {
	  _inherits(AreaTypeEventDetector, _MouseEventDetectorBa);
	
	  /**
	   * AreaTypeEventDetector is mouse event detector for line type chart.
	   * @param {object} params parameters
	   * @constructs AreaTypeEventDetector
	   * @private
	   * @extends MouseEventDetectorBase
	   */
	  function AreaTypeEventDetector(params) {
	    _classCallCheck(this, AreaTypeEventDetector);
	
	    /**
	     * previous found data
	     * @type {null | object}
	     */
	    var _this = _possibleConstructorReturn(this, _MouseEventDetectorBa.call(this, params));
	
	    _this.prevFoundData = null;
	
	    /**
	     * previous client position of mouse event (clientX, clientY)
	     * @type {null | object}
	     */
	    _this.prevClientPosition = null;
	
	    /**
	     * whether zoomable or not
	     * @type {boolean}
	     */
	    _this.zoomable = params.zoomable;
	
	    if (_this.zoomable) {
	      _tuiCodeSnippet2['default'].extend(_this, _zoomMixer2['default']);
	      _this._initForZoom(params.zoomable);
	    }
	    return _this;
	  }
	
	  /**
	   * Animate for adding data.
	   */
	
	
	  AreaTypeEventDetector.prototype.animateForAddingData = function animateForAddingData() {
	    if (!this.prevClientPosition) {
	      return;
	    }
	
	    var foundData = this._findData(this.prevClientPosition.x, this.prevClientPosition.y);
	
	    if (foundData) {
	      var isMatchedIndex = this.prevFoundData.indexes.groupIndex === foundData.indexes.groupIndex;
	      var isMoving = this.prevFoundData && isMatchedIndex;
	      this._showTooltip(foundData, isMoving);
	    }
	
	    this.prevFoundData = foundData;
	  };
	
	  /**
	   * Create areaTypeDataModel from seriesItemBoundsData for mouse event detector.
	   * @param {Array.<object>} seriesItemBoundsDatum - series item bounds datum
	   * @override
	   */
	
	
	  AreaTypeEventDetector.prototype.onReceiveSeriesData = function onReceiveSeriesData(seriesItemBoundsDatum) {
	    var seriesCount = this.seriesCount;
	    var seriesItemBoundsData = this.seriesItemBoundsData;
	
	
	    if (seriesItemBoundsData.length === seriesCount) {
	      seriesItemBoundsData = [];
	    }
	
	    seriesItemBoundsData.push(seriesItemBoundsDatum);
	
	    if (seriesItemBoundsData.length === seriesCount) {
	      this.dataModel = new _areaTypeDataModel2['default'](seriesItemBoundsData);
	    }
	
	    if (this.zoomable) {
	      this._showTooltipAfterZoom();
	    }
	  };
	
	  /**
	   * Find data by client position.
	   * @param {number} clientX - clientX
	   * @param {number} clientY - clientY
	   * @returns {object}
	   * @private
	   * @override
	   */
	
	
	  AreaTypeEventDetector.prototype._findData = function _findData(clientX, clientY) {
	    var layerPosition = this._calculateLayerPosition(clientX, clientY);
	    var selectLegendIndex = this.dataProcessor.selectLegendIndex;
	
	    var isCoordinateTypeChart = this.dataProcessor.isCoordinateType();
	
	    return this.dataModel.findData(layerPosition, selectLegendIndex, {
	      distanceLimit: this.dataModel.leftStepLength,
	      isCoordinateTypeChart: isCoordinateTypeChart
	    });
	  };
	
	  /**
	   * Find data by client position for zoomable
	   * @param {number} clientX - clientX
	   * @param {number} clientY - clientY
	   * @returns {object}
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._findDataForZoomable = function _findDataForZoomable(clientX, clientY) {
	    var layerPosition = this._calculateLayerPosition(clientX, clientY);
	
	    return this.dataModel.findData(layerPosition);
	  };
	
	  /**
	   * Get first model data.
	   * @param {number} index - index
	   * @returns {object}
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._getFirstData = function _getFirstData(index) {
	    return this.dataModel.getFirstData(index);
	  };
	
	  /**
	   * Get last model data.
	   * @param {number} index - index
	   * @returns {object}
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._getLastData = function _getLastData(index) {
	    return this.dataModel.getLastData(index);
	  };
	
	  /**
	   * Show tooltip.
	   * @param {object} foundData - model data
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._showTooltip = function _showTooltip(foundData) {
	    this.eventBus.fire('showTooltip', foundData);
	    this.prevFoundData = foundData;
	  };
	
	  /**
	   * Hide tooltip.
	   * @param {{silent: {boolean}}} [options] - options for hiding tooltip
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._hideTooltip = function _hideTooltip(options) {
	    this.eventBus.fire('hideTooltip', this.prevFoundData, options);
	    this.prevFoundData = null;
	  };
	
	  /**
	   * On mousemove.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  AreaTypeEventDetector.prototype._onMousemove = function _onMousemove(e) {
	    var dragMouseupResult = void 0;
	
	    this._setPrevClientPosition(e);
	    var foundData = this._findData(e.clientX, e.clientY);
	
	    if (this.zoomable) {
	      dragMouseupResult = this._isAfterDragMouseup();
	    }
	
	    if (dragMouseupResult || !this._isChangedSelectData(this.prevFoundData, foundData)) {
	      return;
	    }
	
	    if (foundData) {
	      this._showTooltip(foundData);
	    } else if (this.prevFoundData) {
	      this._hideTooltip();
	    }
	
	    this.prevFoundData = foundData;
	  };
	
	  /**
	   * On mouseout.
	   * @private
	   * @override
	   */
	
	
	  AreaTypeEventDetector.prototype._onMouseout = function _onMouseout() {
	    if (this.prevFoundData) {
	      this._hideTooltip();
	    }
	
	    this.prevClientPosition = null;
	    this.prevFoundData = null;
	  };
	
	  /**
	   * find data by indexes
	   * @param {{index: {number}, seriesIndex: {number}}} indexes - index of series item displaying a tooltip
	   * @returns {object} - series item data
	   */
	
	
	  AreaTypeEventDetector.prototype.findDataByIndexes = function findDataByIndexes(indexes) {
	    return this.dataModel.findDataByIndexes(indexes);
	  };
	
	  /**
	   * Set prevClientPosition by MouseEvent
	   * @param {?MouseEvent} event - mouse event
	   * @private
	   */
	
	
	  AreaTypeEventDetector.prototype._setPrevClientPosition = function _setPrevClientPosition(event) {
	    if (!event) {
	      this.prevClientPosition = null;
	    } else {
	      this.prevClientPosition = {
	        x: event.clientX,
	        y: event.clientY
	      };
	    }
	  };
	
	  return AreaTypeEventDetector;
	}(_mouseEventDetectorBase2['default']);
	
	/**
	 * areaTypeEventDetectorFactory
	 * @param {object} params chart options
	 * @returns {object} area type event detector instance
	 * @ignore
	 */
	
	
	function areaTypeEventDetectorFactory(params) {
	  return new AreaTypeEventDetector(params);
	}
	
	areaTypeEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @fileoverview  Mixer for zoom event of area type mouse event detector.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */
	
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _eventListener = __webpack_require__(56);
	
	var _eventListener2 = _interopRequireDefault(_eventListener);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	/**
	 * Mixer for zoom event of area type mouse event detector.
	 * @mixin
	 * @private */
	exports['default'] = {
	  /**
	   * Initialize for zoom.
	   * @param {boolean} zoomable - whether zoomable or not
	   * @private
	   */
	  _initForZoom: function _initForZoom(zoomable) {
	    /**
	     * whether zoomable or not
	     * @type {boolean}
	     */
	    this.zoomable = zoomable;
	
	    /**
	     * drag start index.
	     * @type {null | object}
	     */
	    this.dragStartIndexes = null;
	
	    /**
	     * start client position(clientX, clientY) of mouse event.
	     * @type {null | {x: number, y: number}}
	     */
	    this.startClientPosition = null;
	
	    /**
	     * start layerX position
	     * @type {null | number}
	     */
	    this.startLayerX = null;
	
	    /**
	     * drag selection element
	     * @type {null | HTMLElement}
	     */
	    this.dragSelectionElement = null;
	
	    /**
	     * container bound
	     * @type {null | {left: number, right: number, top: number}}
	     */
	    this.containerBound = null;
	
	    /**
	     * whether show tooltip after zoom or not.
	     * @type {boolean}
	     */
	    this.isShowTooltipAfterZoom = false;
	
	    /**
	     * whether after mouseup or not.
	     * @type {boolean}
	     */
	    this.afterMouseup = false;
	
	    /**
	     * previouse distance of range
	     * @type {null | number}
	     */
	    this.prevDistanceOfRange = null;
	
	    /**
	     * whether reverse move or not.
	     * @type {null | number}
	     */
	    this.reverseMove = null;
	
	    /**
	     * reset zoom button element.
	     * @type {null | HTMLElement}
	     */
	    this.resetZoomBtn = null;
	  },
	
	
	  /**
	   * preset zoom data before rerender.
	   */
	  presetBeforeRerender: function presetBeforeRerender() {
	    if (this.resetZoomBtn) {
	      this.mouseEventDetectorContainer.removeChild(this.resetZoomBtn);
	      this.resetZoomBtn = null;
	    }
	    this._hideTooltip();
	    this.prevDistanceOfRange = null;
	  },
	
	
	  /**
	   * Show tooltip after zoom.
	   * @private
	   */
	  _showTooltipAfterZoom: function _showTooltipAfterZoom() {
	    var isShowTooltipAfterZoom = this.isShowTooltipAfterZoom;
	
	    var lastDataBeforeZoom = void 0;
	
	    this.isShowTooltipAfterZoom = false;
	
	    if (!isShowTooltipAfterZoom || !this.dragStartIndexes) {
	      return;
	    }
	
	    if (this.reverseMove) {
	      lastDataBeforeZoom = this._getFirstData(this.dragStartIndexes.index);
	    } else {
	      lastDataBeforeZoom = this._getLastData(this.dragEndIndexes.index);
	    }
	
	    if (lastDataBeforeZoom) {
	      this._showTooltip(lastDataBeforeZoom);
	    }
	  },
	
	
	  /**
	   * Update dimension for drag selection element.
	   * @param {HTMLElement} selectionElement - drag selection element
	   * @private
	   */
	  _updateDimensionForDragSelection: function _updateDimensionForDragSelection(selectionElement) {
	    _renderUtil2['default'].renderDimension(selectionElement, {
	      height: this.layout.dimension.height
	    });
	  },
	
	
	  /**
	   * Render drag selection.
	   * @returns {HTMLElement}
	   * @private
	   */
	  _renderDragSelection: function _renderDragSelection() {
	    var selectionElement = _domHandler2['default'].create('DIV', 'tui-chart-drag-selection');
	
	    this._updateDimensionForDragSelection(selectionElement);
	
	    return selectionElement;
	  },
	
	
	  /**
	   * Render.
	   * @param {object} data - data for rendering
	   * @returns {HTMLElement}
	   * @override
	   */
	  render: function render(data) {
	    var container = _mouseEventDetectorBase2['default'].prototype.render.call(this, data);
	    var selectionElement = this._renderDragSelection();
	
	    _domHandler2['default'].append(container, selectionElement);
	    this.dragSelectionElement = selectionElement;
	
	    return container;
	  },
	
	
	  /**
	   * Resize.
	   * @param {{tickCount: number}} data - data for resizing
	   * @override
	   */
	  resize: function resize(data) {
	    this.containerBound = null;
	    _mouseEventDetectorBase2['default'].prototype.resize.call(this, data);
	    this._updateDimensionForDragSelection(this.dragSelectionElement);
	  },
	
	
	  /**
	   * On click
	   * @private
	   * @override
	   */
	  _onClick: function _onClick() {},
	
	
	  /**
	   * Whether after drag mouseup or not.
	   * @returns {boolean}
	   * @private
	   */
	  _isAfterDragMouseup: function _isAfterDragMouseup() {
	    var afterMouseup = this.afterMouseup;
	
	
	    if (afterMouseup) {
	      this.afterMouseup = false;
	    }
	
	    return afterMouseup;
	  },
	
	
	  /**
	   * Bind drag event for zoom.
	   * @param {HTMLElement} target - target element
	   * @private
	   */
	  _bindDragEvent: function _bindDragEvent(target) {
	    if (target.setCapture) {
	      target.setCapture();
	    }
	
	    _eventListener2['default'].on(document, 'mousemove', this._onDrag, this);
	    _eventListener2['default'].off(this.mouseEventDetectorContainer, 'mouseup', this._onMouseup, this);
	    _eventListener2['default'].on(document, 'mouseup', this._onMouseupAfterDrag, this);
	  },
	
	
	  /**
	   * Unbind drag event for zoom.
	   * @private
	   */
	  _unbindDragEvent: function _unbindDragEvent() {
	    if (this.downTarget && this.downTarget.releaseCapture) {
	      this.downTarget.releaseCapture();
	    }
	
	    _eventListener2['default'].off(document, 'mousemove', this._onDrag, this);
	    _eventListener2['default'].off(document, 'mouseup', this._onMouseupAfterDrag, this);
	    _eventListener2['default'].on(this.mouseEventDetectorContainer, 'mouseup', this._onMouseup, this);
	  },
	
	
	  /**
	   * On mouse down.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	  _onMousedown: function _onMousedown(e) {
	    if (!this.zoomable) {
	      return;
	    }
	
	    var target = e.target || e.srcElement;
	
	    this.startClientPosition = {
	      x: e.clientX,
	      y: e.clientY
	    };
	
	    this.startLayerX = this._calculateLayerPosition(e.clientX).x;
	    this.downTarget = target;
	
	    this._bindDragEvent(target);
	  },
	
	
	  /**
	   * Show drag selection.
	   * @param {number} clientX - clientX
	   * @private
	   */
	  _showDragSelection: function _showDragSelection(clientX) {
	    var _mouseEventDetectorCo = this.mouseEventDetectorContainer.getBoundingClientRect(),
	        eventContainerLeft = _mouseEventDetectorCo.left;
	
	    var layerX = this._calculateLayerPosition(clientX).x;
	    var clientPos = this.startClientPosition;
	    var diffArea = eventContainerLeft - (clientPos.x - this.startLayerX);
	    var left = Math.min(layerX, this.startLayerX) - diffArea;
	    var width = Math.abs(layerX - this.startLayerX);
	    var element = this.dragSelectionElement;
	
	    element.style.left = left + 'px';
	    element.style.width = width + 'px';
	
	    _domHandler2['default'].addClass(element, 'show');
	  },
	
	
	  /**
	   * Hide drag selection.
	   * @private
	   */
	  _hideDragSelection: function _hideDragSelection() {
	    _domHandler2['default'].removeClass(this.dragSelectionElement, 'show');
	  },
	
	
	  /**
	   * On mouse drag.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   */
	  _onDrag: function _onDrag(e) {
	    var clientPos = this.startClientPosition;
	    var target = e.target || e.srcElement;
	
	    if (clientPos) {
	      var dataForZoomable = this._findDataForZoomable(clientPos.x, clientPos.y);
	
	      if (!_domHandler2['default'].hasClass(target, _const2['default'].CLASS_NAME_RESET_ZOOM_BTN)) {
	        if (_tuiCodeSnippet2['default'].isNull(this.dragStartIndexes)) {
	          this.dragStartIndexes = dataForZoomable ? dataForZoomable.indexes : {};
	        } else {
	          this._showDragSelection(e.clientX);
	        }
	      }
	    }
	  },
	
	
	  /**
	   * Adjust index range for ensure three indexes.
	   * @param {Array.<{startIndex: number, endIndex: number}>} indexRange - index range
	   * @returns {object} startIndex, endIndex
	   * @private
	   */
	  _changeIndexToHaveMinimumIndexes: function _changeIndexToHaveMinimumIndexes(_ref) {
	    var _ref2 = _slicedToArray(_ref, 2),
	        startIndex = _ref2[0],
	        endIndex = _ref2[1];
	
	    var distanceOfRange = endIndex - startIndex;
	
	    if (distanceOfRange === 0) {
	      if (startIndex === 0) {
	        endIndex += 2;
	      } else {
	        startIndex -= 1;
	        endIndex += 1;
	      }
	    } else if (distanceOfRange === 1) {
	      if (startIndex === 0) {
	        endIndex += 1;
	      } else {
	        startIndex -= 1;
	      }
	    }
	
	    return {
	      startIndex: startIndex,
	      endIndex: endIndex
	    };
	  },
	
	
	  /**
	   * Adjust index range for ensure three indexes.
	   * @param {number} startIndex - start index
	   * @param {number} endIndex - end index
	   * @returns {Array.<number>}
	   * @private
	   */
	  _adjustIndexRange: function _adjustIndexRange(startIndex, endIndex) {
	    var indexRange = [startIndex, endIndex].sort(function (a, b) {
	      return a - b;
	    });
	
	    return this._changeIndexToHaveMinimumIndexes(indexRange);
	  },
	
	
	  /**
	   * Fire zoom mouse event detector.
	   * @private
	   */
	  _fireZoom: function _fireZoom() {
	    if (this.dataProcessor.isLineCoordinateType()) {
	      this._fireZoomUsingValue(this.dragStartIndexes, this.dragEndIndexes);
	    } else {
	      this._fireZoomUsingIndex(this.dragStartIndexes.groupIndex, this.dragEndIndexes.groupIndex);
	    }
	  },
	
	
	  /**
	   * Fire zoom mouse event detector using Index.
	   * @param {number} startIndex - start index
	   * @param {number} endIndex - end index
	   * @private
	   */
	  _fireZoomUsingIndex: function _fireZoomUsingIndex(startIndex, endIndex) {
	    var reverseMove = startIndex > endIndex;
	
	    var _adjustIndexRange2 = this._adjustIndexRange(startIndex, endIndex),
	        adjustedStartIndex = _adjustIndexRange2.startIndex,
	        adjustedEndIndex = _adjustIndexRange2.endIndex;
	
	    var distanceOfRange = adjustedEndIndex - adjustedStartIndex;
	
	    if (this.prevDistanceOfRange === distanceOfRange) {
	      return;
	    }
	
	    this.prevDistanceOfRange = distanceOfRange;
	    this.reverseMove = reverseMove;
	    this.eventBus.fire('zoom', [adjustedStartIndex, adjustedEndIndex]);
	  },
	
	
	  /**
	   * Adjust value range for ensure three indexes.
	   * @param {number} startValue - start index
	   * @param {number} endValue - end index
	   * @returns {Array.<number>}
	   * @private
	   */
	  _adjustValueRange: function _adjustValueRange(startValue, endValue) {
	    var startValueIndex = void 0,
	        endValueIndex = void 0;
	    var _dataProcessor = this.dataProcessor,
	        integratedXAxisData = _dataProcessor.integratedXAxisData,
	        xAxisOptions = _dataProcessor.options.xAxis;
	
	    var isDatetime = _predicate2['default'].isDatetimeType(xAxisOptions.type);
	
	    if (isDatetime) {
	      startValueIndex = _arrayUtil2['default'].findIndexFromDateTypeArray(integratedXAxisData, new Date(startValue));
	      endValueIndex = _arrayUtil2['default'].findIndexFromDateTypeArray(integratedXAxisData, new Date(endValue));
	    } else {
	      startValueIndex = integratedXAxisData.indexOf(startValue);
	      endValueIndex = integratedXAxisData.indexOf(endValue);
	    }
	
	    var indexRange = [startValueIndex, endValueIndex].sort(function (a, b) {
	      return a - b;
	    });
	
	    var _changeIndexToHaveMin = this._changeIndexToHaveMinimumIndexes(indexRange),
	        startIndex = _changeIndexToHaveMin.startIndex,
	        endIndex = _changeIndexToHaveMin.endIndex;
	
	    return [integratedXAxisData[startIndex], integratedXAxisData[endIndex]];
	  },
	
	
	  /**
	   * Fire zoom mouse event detector for coordinateChart.
	   * @param {object} startIndexes - start index
	   * @param {object} endIndexes - end index
	   * @private
	   */
	  _fireZoomUsingValue: function _fireZoomUsingValue(startIndexes, endIndexes) {
	    var startIndex = startIndexes.index,
	        startGroupIndex = startIndexes.groupIndex;
	    var endIndex = endIndexes.index,
	        endGroupIndex = endIndexes.groupIndex;
	
	    var seriesData = this.dataProcessor.rawData.series.line;
	
	    var _seriesData$startInde = _slicedToArray(seriesData[startIndex].data[startGroupIndex], 1),
	        startValue = _seriesData$startInde[0];
	
	    var _seriesData$endIndex$ = _slicedToArray(seriesData[endIndex].data[endGroupIndex], 1),
	        endValue = _seriesData$endIndex$[0];
	
	    var valueRange = this._adjustValueRange(startValue, endValue);
	
	    this.eventBus.fire('zoom', valueRange);
	  },
	
	
	  /**
	   * Set flag about whether show tooltip after zoom or not.
	   * @param {number} clientX - clientX of mouse event
	   * @param {number} clientY - clientY of mouse event
	   * @private
	   */
	  _setIsShowTooltipAfterZoomFlag: function _setIsShowTooltipAfterZoomFlag(clientX, clientY) {
	    var layerX = this._calculateLayerPosition(clientX, clientY, false).x;
	    var limitLayerX = this._calculateLayerPosition(clientX, clientY).x;
	
	    this.isShowTooltipAfterZoom = layerX === limitLayerX;
	  },
	
	
	  /**
	   * On mouseup after drag event.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   */
	  _onMouseupAfterDrag: function _onMouseupAfterDrag(e) {
	    // @TODO: define zoomable policy, when there is no data
	    // To find dragEndIndex for zoom, data should not be null.
	    // To avoid zooming avoid zooming with no data, check dragStartIndexes first
	    // Becault chart without data returns invalid dragStartIndexes
	    var foundedDragEndData = this._findDataForZoomable(e.clientX, e.clientY);
	
	    this._unbindDragEvent();
	
	    if (_tuiCodeSnippet2['default'].isNull(this.dragStartIndexes)) {
	      var target = e.target || e.srcElement;
	      if (_domHandler2['default'].hasClass(target, _const2['default'].CLASS_NAME_RESET_ZOOM_BTN)) {
	        this._hideTooltip();
	        this.prevDistanceOfRange = null;
	        this.eventBus.fire('resetZoom');
	      } else {
	        _mouseEventDetectorBase2['default'].prototype._onClick.call(this, e);
	      }
	    } else if (this.dragStartIndexes && foundedDragEndData) {
	      this.dragEndIndexes = foundedDragEndData.indexes;
	      this._setIsShowTooltipAfterZoomFlag(e.clientX, e.clientY);
	      this._hideDragSelection();
	      this._fireZoom();
	    } else {
	      this._setIsShowTooltipAfterZoomFlag(e.clientX, e.clientY);
	      this._hideDragSelection();
	    }
	
	    this.startClientPosition = null;
	    this.dragStartIndexes = null;
	    this.startLayerX = null;
	    this.afterMouseup = true;
	  },
	
	
	  /**
	   * Render reset zoom button element.
	   * @returns {HTMLElement}
	   * @private
	   */
	  _renderResetZoomBtn: function _renderResetZoomBtn() {
	    var resetBtn = _domHandler2['default'].create('DIV', _const2['default'].CLASS_NAME_RESET_ZOOM_BTN);
	
	    return resetBtn;
	  },
	
	
	  /**
	   * Zoom.
	   * @param {object} data - data for rendering
	   */
	  zoom: function zoom(data) {
	    this.prevFoundData = null;
	    this.rerender(data);
	    this._updateDimensionForDragSelection(this.dragSelectionElement);
	
	    if (!this.resetZoomBtn) {
	      this.resetZoomBtn = this._renderResetZoomBtn();
	      _domHandler2['default'].append(this.mouseEventDetectorContainer, this.resetZoomBtn);
	    } else if (data.isResetZoom) {
	      this.mouseEventDetectorContainer.removeChild(this.resetZoomBtn);
	      this.resetZoomBtn = null;
	    }
	  }
	};

/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _arrayUtil = __webpack_require__(11);
	
	var _arrayUtil2 = _interopRequireDefault(_arrayUtil);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview AreaTypeDataModel is data model for mouse event detector of area type.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	
	var AreaTypeDataModel = function () {
	  /**
	   * AreaTypeDataModel is data mode for mouse event detector of area type.
	   * @constructs AreaTypeDataModel
	   * @private
	   * @param {Array} seriesItemBoundsData - series item bounds data
	   */
	  function AreaTypeDataModel(seriesItemBoundsData) {
	    _classCallCheck(this, AreaTypeDataModel);
	
	    this.data = this._makeData(seriesItemBoundsData);
	
	    /**
	     * last group index
	     * @type {number}
	     */
	    this.lastGroupIndex = 0;
	  }
	
	  /**
	   * Make data for detecting mouse event.
	   * @param {Array} seriesItemBoundsData - series item bounds data
	   * @returns {Array}
	   * @private
	   */
	
	
	  AreaTypeDataModel.prototype._makeData = function _makeData(seriesItemBoundsData) {
	    var _this = this,
	        _ref,
	        _ref2;
	
	    var seriesItemBoundsLength = seriesItemBoundsData.length;
	    var lastGroupIndex = 0;
	    var data = seriesItemBoundsData.map(function (seriesDatum, seriesIndex) {
	      var chartType = seriesDatum.chartType,
	          dotumData = seriesDatum.data;
	
	      var groupPositions = dotumData.groupPositions || dotumData.groupBounds;
	
	      if (_predicate2['default'].isLineTypeChart(chartType) || _predicate2['default'].isRadialChart(chartType)) {
	        groupPositions = _arrayUtil2['default'].pivot(groupPositions);
	      }
	
	      lastGroupIndex = Math.max(groupPositions.length - 1, lastGroupIndex);
	
	      var hasGroupPosition = groupPositions.length > 1 && groupPositions[1][0] && groupPositions[0][0];
	      _this.leftStepLength = hasGroupPosition ? groupPositions[1][0].left - groupPositions[0][0].left : 0;
	
	      return groupPositions.map(function (positions, groupIndex) {
	        return positions.map(function (position, index) {
	          var datum = null;
	
	          if (position) {
	            datum = {
	              chartType: chartType,
	              indexes: {
	                groupIndex: groupIndex,
	                index: index
	              },
	              bound: position
	            };
	          }
	
	          // Add legendIndex to datum on making multi series chart data, especially for LineScatterComboChart.
	          if (seriesItemBoundsLength > 1) {
	            datum.indexes.legendIndex = seriesIndex;
	          }
	
	          return datum;
	        });
	      });
	    });
	
	    data = (_ref = []).concat.apply(_ref, _toConsumableArray(data));
	    this.lastGroupIndex = lastGroupIndex;
	
	    return (_ref2 = []).concat.apply(_ref2, _toConsumableArray(data)).filter(function (datum) {
	      return !!datum;
	    });
	  };
	
	  /**
	   * Find Data by layer position.
	   * @param {{x: number, y: number}} layerPosition - layer position
	   * @param {number} [selectLegendIndex] select legend sereis index
	   * @param {object} [searchInfo] distance limitation to find data
	   *   @param {number} searchInfo.distanceLimit distance limitation to find data
	   *   @param {boolean} searchInfo.isCoordinateTypeChart whether coordinate type chart or not
	   * @returns {object}
	   */
	
	
	  AreaTypeDataModel.prototype.findData = function findData(layerPosition, selectLegendIndex) {
	    var _ref3 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
	        distanceLimit = _ref3.distanceLimit,
	        isCoordinateTypeChart = _ref3.isCoordinateTypeChart;
	
	    var isLooseDistancePosition = distanceLimit && distanceLimit < this.leftStepLength;
	    var useCoordinateDistanceSearch = isCoordinateTypeChart || isLooseDistancePosition;
	
	    if (useCoordinateDistanceSearch) {
	      return this._findDataForCoordinateDistance(layerPosition, distanceLimit, selectLegendIndex);
	    }
	
	    return this._findDataForFirstXPosition(layerPosition, selectLegendIndex);
	  };
	
	  /**
	   * Find Data by layer position at dense area.
	   * @param {{x: number, y: number}} layerPosition - layer position
	   * @param {number} selectLegendIndex select legend sereis index
	   * @returns {object}
	   * @private
	   */
	
	
	  AreaTypeDataModel.prototype._findDataForFirstXPosition = function _findDataForFirstXPosition(layerPosition, selectLegendIndex) {
	    var _data$reduce = this.data.reduce(function (findMinObj, datum) {
	      var xDiff = Math.abs(layerPosition.x - datum.bound.left);
	      if (xDiff <= findMinObj.xMin) {
	        findMinObj.xMin = xDiff;
	        findMinObj.xMinValue = datum.bound.left;
	      }
	
	      return findMinObj;
	    }, {
	      xMin: Number.MAX_VALUE,
	      xMinValue: 0
	    }),
	        xMinValue = _data$reduce.xMinValue;
	
	    var _data$reduce2 = this.data.reduce(function (findResultObj, datum) {
	      var yDiff = Math.abs(layerPosition.y - datum.bound.top);
	      var remakeFindObj = {};
	
	      if (datum.bound.left !== xMinValue) {
	        remakeFindObj = findResultObj;
	      } else if (!_tuiCodeSnippet2['default'].isNull(selectLegendIndex) && selectLegendIndex === datum.indexes.index) {
	        remakeFindObj.yMin = Number.MIN_VALUE;
	        remakeFindObj.findFound = datum;
	      } else if (yDiff <= findResultObj.yMin) {
	        remakeFindObj.yMin = yDiff;
	        remakeFindObj.findFound = datum;
	      } else {
	        remakeFindObj = findResultObj;
	      }
	
	      return remakeFindObj;
	    }, {
	      yMin: Number.MAX_VALUE,
	      findFound: null
	    }),
	        findFound = _data$reduce2.findFound;
	
	    return findFound;
	  };
	
	  /**
	   * Find Data by layer position at loose area.
	   * @param {{x: number, y: number}} layerPosition - layer position
	   * @param {number} [distanceLimit] distance limitation to find data
	   * @param {number} selectLegendIndex select legend sereis index
	   * @returns {object}
	   * @private
	   */
	
	
	  AreaTypeDataModel.prototype._findDataForCoordinateDistance = function _findDataForCoordinateDistance(layerPosition, distanceLimit, selectLegendIndex) {
	    var min = 100000;
	    var findFound = void 0;
	
	    distanceLimit = distanceLimit || Number.MAX_VALUE;
	
	    this.data.forEach(function (datum) {
	      var xDiff = layerPosition.x - datum.bound.left;
	      var yDiff = layerPosition.y - datum.bound.top;
	      var distance = Math.sqrt(Math.pow(xDiff, 2) + Math.pow(yDiff, 2));
	
	      if (distance > distanceLimit) {
	        return;
	      }
	
	      if (!_tuiCodeSnippet2['default'].isNull(selectLegendIndex) && selectLegendIndex !== datum.indexes.index) {
	        return;
	      }
	
	      if (distance <= min) {
	        min = distance;
	        findFound = datum;
	      }
	    });
	
	    return findFound;
	  };
	
	  /**
	   * Find data by indexes.
	   * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	   * @returns {object}
	   */
	
	
	  AreaTypeDataModel.prototype.findDataByIndexes = function findDataByIndexes(_ref4) {
	    var index = _ref4.index,
	        seriesIndex = _ref4.seriesIndex;
	
	    var foundData = null;
	
	    this.data.forEach(function (datum) {
	      if (datum.indexes.groupIndex === index && datum.indexes.index === seriesIndex) {
	        foundData = datum;
	      }
	
	      return !foundData;
	    });
	
	    return foundData;
	  };
	
	  /**
	   * Get first data.
	   * @param {number} index - index
	   * @returns {object}
	   */
	
	
	  AreaTypeDataModel.prototype.getFirstData = function getFirstData(index) {
	    var indexes = {
	      index: 0,
	      seriesIndex: index
	    };
	
	    return this.findDataByIndexes(indexes);
	  };
	
	  /**
	   * Get last data.
	   * @param {number} index - index
	   * @returns {object}
	   */
	
	
	  AreaTypeDataModel.prototype.getLastData = function getLastData(index) {
	    var indexes = {
	      index: this.lastGroupIndex,
	      seriesIndex: index
	    };
	
	    return this.findDataByIndexes(indexes);
	  };
	
	  return AreaTypeDataModel;
	}();
	
	exports['default'] = AreaTypeDataModel;

/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = simpleTypeEventDetectorFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview SimpleEventDetector is event handle layer for simply sending clientX, clientY.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var SimpleEventDetector = function (_MouseEventDetectorBa) {
	  _inherits(SimpleEventDetector, _MouseEventDetectorBa);
	
	  /**
	   * SimpleEventDetector is event handle layer for simply sending clientX, clientY.
	   * @constructs SimpleEventDetector
	   * @private
	   * @param {object} params parameters
	   *      @param {string} params.chartType - chart type
	   * @extends MouseEventDetectorBase
	   */
	  function SimpleEventDetector(params) {
	    _classCallCheck(this, SimpleEventDetector);
	
	    /**
	     * chart type
	     * @type {string}
	     */
	    var _this = _possibleConstructorReturn(this, _MouseEventDetectorBa.call(this));
	
	    _this.chartType = params.chartType;
	
	    _this.drawingType = _const2['default'].COMPONENT_TYPE_DOM;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    _this.eventBus = params.eventBus;
	    return _this;
	  }
	
	  /**
	   * Render mouse event detector area
	   * @param {HTMLElement} mouseEventDetectorContainer - container element for mouse event detector
	   * @private
	   */
	
	
	  SimpleEventDetector.prototype._renderMouseEventDetectorArea = function _renderMouseEventDetectorArea(mouseEventDetectorContainer) {
	    _renderUtil2['default'].renderDimension(mouseEventDetectorContainer, this.layout.dimension);
	    _renderUtil2['default'].renderPosition(mouseEventDetectorContainer, this.layout.position);
	  };
	
	  /**
	   * Initialize data of mouse event detector
	   * @override
	   */
	
	
	  SimpleEventDetector.prototype.onReceiveSeriesData = function onReceiveSeriesData() {};
	
	  /**
	   * On click.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  SimpleEventDetector.prototype._onClick = function _onClick(e) {
	    this._onMouseEvent('click', e);
	  };
	
	  /**
	   * On mouse move.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  SimpleEventDetector.prototype._onMousemove = function _onMousemove(e) {
	    this._onMouseEvent('move', e);
	  };
	
	  /**
	   * On mouse out.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  SimpleEventDetector.prototype._onMouseout = function _onMouseout(e) {
	    this._onMouseEvent('move', e);
	  };
	
	  return SimpleEventDetector;
	}(_mouseEventDetectorBase2['default']);
	
	/**
	 * simpleTypeEventDetectorFactory
	 * @param {object} params chart options
	 * @returns {object} simple type event detector instance
	 * @ignore
	 */
	
	
	function simpleTypeEventDetectorFactory(params) {
	  return new SimpleEventDetector(params);
	}
	
	simpleTypeEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = groupTypeEventDetectorFactory;
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _zoomMixer = __webpack_require__(76);
	
	var _zoomMixer2 = _interopRequireDefault(_zoomMixer);
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview GroupTypeEventDetector is mouse event detector for grouped tooltip.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	
	var GroupTypeEventDetector = function (_EventDetectorBase) {
	  _inherits(GroupTypeEventDetector, _EventDetectorBase);
	
	  /**
	   * GroupTypeEventDetector is mouse event detector for grouped tooltip.
	   * @param {object} params parameters
	   * @constructs GroupTypeEventDetector
	   * @private
	   * @extends EventDetectorBase
	   */
	  function GroupTypeEventDetector(params) {
	    _classCallCheck(this, GroupTypeEventDetector);
	
	    /**
	     * previous index of group data
	     * @type {null}
	     */
	    var _this = _possibleConstructorReturn(this, _EventDetectorBase.call(this, params));
	
	    _this.prevIndex = null;
	
	    /**
	     * whether zoomable or not
	     * @type {boolean}
	     */
	    _this.zoomable = params.zoomable;
	
	    /**
	     * type of size
	     * @type {string}
	     */
	    _this.sizeType = _this.isVertical ? 'height' : 'width';
	
	    if (_this.zoomable) {
	      _tuiCodeSnippet2['default'].extend(_this, _zoomMixer2['default']);
	      _this._initForZoom(params.zoomable);
	    }
	    return _this;
	  }
	
	  /**
	   * Initialize data of mouse event detector
	   * @param {Array.<object>} seriesInfos series infos
	   * @override
	   */
	
	
	  GroupTypeEventDetector.prototype.initMouseEventDetectorData = function initMouseEventDetectorData(seriesInfos) {
	    _mouseEventDetectorBase2['default'].prototype.initMouseEventDetectorData.call(this, seriesInfos);
	
	    if (this.zoomable) {
	      this._showTooltipAfterZoom();
	    }
	  };
	
	  /**
	   * Find data by client position.
	   * @param {number} clientX - clientX
	   * @param {number} clientY - clientY
	   * @returns {object}
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._findGroupData = function _findGroupData(clientX, clientY) {
	    var layerPosition = this._calculateLayerPosition(clientX, clientY, true);
	    var pointValue = void 0;
	
	    if (this.isVertical) {
	      pointValue = layerPosition.x;
	    } else {
	      pointValue = layerPosition.y;
	    }
	
	    return {
	      indexes: {
	        groupIndex: this.tickBaseCoordinateModel.findIndex(pointValue)
	      }
	    };
	  };
	
	  /**
	   * Find data by client position for zoomable
	   * @param {number} clientX - clientX
	   * @param {number} clientY - clientY
	   * @returns {object}
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._findDataForZoomable = function _findDataForZoomable(clientX, clientY) {
	    return this._findGroupData(clientX, clientY);
	  };
	
	  /**
	   * Get first data.
	   * @returns {{indexes: {groupIndex: number}}} - data
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._getFirstData = function _getFirstData() {
	    return {
	      indexes: {
	        groupIndex: 0
	      }
	    };
	  };
	
	  /**
	   * Get last data.
	   * @returns {{indexes: {groupIndex: number}}} - data
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._getLastData = function _getLastData() {
	    return {
	      indexes: {
	        groupIndex: this.tickBaseCoordinateModel.getLastIndex()
	      }
	    };
	  };
	
	  /**
	   * Whether outer position or not.
	   * @param {number} layerX layerX
	   * @param {number} layerY layerY
	   * @returns {boolean} result boolean
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._isOuterPosition = function _isOuterPosition(layerX, layerY) {
	    var _dimension = this.dimension,
	        width = _dimension.width,
	        height = _dimension.height;
	    var _layout$position = this.layout.position,
	        top = _layout$position.top,
	        left = _layout$position.left;
	
	
	    return layerX < left || layerX > left + width || layerY < top || layerY > top + height;
	  };
	
	  /**
	   * Show tooltip.
	   * @param {{indexes: {groupIndex: number}, silent: boolean}} foundData - data
	   * @param {boolean} [isMoving] - whether moving or not
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._showTooltip = function _showTooltip(foundData, isMoving) {
	    var index = foundData.indexes.groupIndex;
	    var positionValue = (this.isVertical ? this.layout.position.left : this.layout.position.top) - _const2['default'].CHART_PADDING;
	
	    /**
	     * Can be called with showTooltip function
	     * At this time, the index may be larger than the data size.
	     */
	    if (this.tickBaseCoordinateModel.data.length > index) {
	      this.eventBus.fire('showTooltip', {
	        index: index,
	        range: this.tickBaseCoordinateModel.makeRange(index, positionValue),
	        size: this.dimension[this.sizeType],
	        isVertical: this.isVertical,
	        isMoving: isMoving,
	        silent: foundData.silent
	      });
	      this.prevIndex = index;
	    }
	  };
	
	  /**
	   * Hide tooltip
	   * @param {{silent: {boolean}}} [options] - options for hiding tooltip
	   * @private
	   */
	
	
	  GroupTypeEventDetector.prototype._hideTooltip = function _hideTooltip(options) {
	    this.eventBus.fire('hideTooltip', this.prevIndex, options);
	    this.prevIndex = null;
	  };
	
	  /**
	   * If found position data by client position, show tooltip.
	   * And if not found, call onMouseout function.
	   * @param {MouseEvent} e mouse event object
	   * @private
	   * @override
	   */
	
	
	  GroupTypeEventDetector.prototype._onMousemove = function _onMousemove(e) {
	    if (this.zoomable && this._isAfterDragMouseup()) {
	      return;
	    }
	
	    var foundData = this._findGroupData(e.clientX, e.clientY);
	    var index = foundData.indexes.groupIndex;
	
	    if (index === -1) {
	      this._onMouseout(e);
	    } else if (this.prevIndex !== index) {
	      this._showTooltip(foundData);
	    }
	  };
	
	  /**
	   * If mouse position gets out mouse event detector area, hide tooltip.
	   * @override
	   */
	
	
	  GroupTypeEventDetector.prototype._onMouseout = function _onMouseout(e) {
	    var _calculateLayerPositi = this._calculateLayerPosition(e.clientX, e.clientY, false),
	        x = _calculateLayerPositi.x,
	        y = _calculateLayerPositi.y;
	
	    if (this._isOuterPosition(x, y) && !_tuiCodeSnippet2['default'].isNull(this.prevIndex)) {
	      this._hideTooltip();
	    }
	  };
	
	  return GroupTypeEventDetector;
	}(_mouseEventDetectorBase2['default']);
	
	/**
	 * groupTypeEventDetectorFactory
	 * @param {object} params chart options
	 * @returns {object} group type event detector instance
	 * @ignore
	 */
	
	
	function groupTypeEventDetectorFactory(params) {
	  return new GroupTypeEventDetector(params);
	}
	
	groupTypeEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = boundsTypeEventDetectorFactory;
	
	var _mouseEventDetectorBase = __webpack_require__(71);
	
	var _mouseEventDetectorBase2 = _interopRequireDefault(_mouseEventDetectorBase);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview BoundsTypeEventDetector is mouse event detector for bounds type charts
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *                                                                              like bar, column, heatmap, treemap.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	var BoundsTypeEventDetector = function (_EventDetectorBase) {
	  _inherits(BoundsTypeEventDetector, _EventDetectorBase);
	
	  /**
	   * BoundsTypeEventDetector is mouse event detector for bounds type charts like bar, column, heatmap, treemap.
	   * @constructs BoundsTypeEventDetector
	   * @private
	   * @extends EventDetectorBase
	   */
	  function BoundsTypeEventDetector() {
	    _classCallCheck(this, BoundsTypeEventDetector);
	
	    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }
	
	    /**
	     * previous found data
	     * @type {null | object}
	     */
	    var _this = _possibleConstructorReturn(this, _EventDetectorBase.call.apply(_EventDetectorBase, [this].concat(args)));
	
	    _this.prevFoundData = null;
	
	    /**
	     * history array for treemap chart.
	     * @type {array}
	     */
	    _this.zoomHistory = [-1];
	
	    /**
	     * button for zoom history back
	     * @type {null | HTMLElement}
	     */
	    _this.historyBackBtn = null;
	    return _this;
	  }
	
	  /**
	   * Attach to event bus.
	   * @private
	   * @override
	   */
	
	
	  BoundsTypeEventDetector.prototype._attachToEventBus = function _attachToEventBus() {
	    _mouseEventDetectorBase2['default'].prototype._attachToEventBus.call(this);
	
	    this.eventBus.on('afterZoom', this.onAfterZoom, this);
	  };
	
	  /**
	   * Show tooltip.
	   * @param {object} foundData - model data
	   * @private
	   */
	
	
	  BoundsTypeEventDetector.prototype._showTooltip = function _showTooltip(foundData) {
	    this.eventBus.fire('showTooltip', foundData);
	    this.prevFoundData = foundData;
	  };
	
	  /**
	   * Hide tooltip.
	   * @param {{silent: {boolean}}} [options] - options for hiding a tooltip
	   * @private
	   */
	
	
	  BoundsTypeEventDetector.prototype._hideTooltip = function _hideTooltip(options) {
	    this.eventBus.fire('hideTooltip', this.prevFoundData, options);
	    this.prevFoundData = null;
	    this.styleCursor(false);
	  };
	
	  /**
	   * Style css cursor.
	   * @param {boolean} hasChild - whether has child or not
	   */
	
	
	  BoundsTypeEventDetector.prototype.styleCursor = function styleCursor(hasChild) {
	    var container = this.mouseEventDetectorContainer;
	    if (hasChild) {
	      container.style.cursor = 'pointer';
	    } else {
	      container.style.cursor = 'default';
	    }
	  };
	
	  /**
	   * On mousemove.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  BoundsTypeEventDetector.prototype._onMousemove = function _onMousemove(_ref) {
	    var clientX = _ref.clientX,
	        clientY = _ref.clientY;
	
	    var layerPosition = this._calculateLayerPosition(clientX, clientY);
	    var foundData = this._findDataFromBoundsCoordinateModel(layerPosition);
	
	    if (!this._isChangedSelectData(this.prevFoundData, foundData)) {
	      return;
	    }
	
	    if (this.prevFoundData) {
	      this._hideTooltip();
	    }
	
	    this.prevFoundData = foundData;
	
	    if (!foundData) {
	      return;
	    }
	
	    if (_predicate2['default'].isTreemapChart(this.chartType)) {
	      var seriesItem = this._getSeriesItemByIndexes(foundData.indexes);
	      this.styleCursor(seriesItem.hasChild);
	    } else if (_predicate2['default'].isBulletChart(this.chartType)) {
	      foundData.mousePosition = {
	        left: clientX,
	        top: clientY
	      };
	    }
	    this._showTooltip(foundData);
	  };
	
	  /**
	   * Zoom history back.
	   * @private
	   */
	
	
	  BoundsTypeEventDetector.prototype._zoomHistoryBack = function _zoomHistoryBack() {
	    var index = this.zoomHistory[this.zoomHistory.length - 2];
	
	    this.zoomHistory.pop();
	    this.eventBus.fire('zoom', index);
	
	    if (this.zoomHistory.length === 1) {
	      this.mouseEventDetectorContainer.removeChild(this.historyBackBtn);
	      this.historyBackBtn = null;
	    }
	  };
	
	  /**
	   * Get seriesItem by indexes
	   * @param {{groupIndex: number, index: number}} indexes - indexes
	   * @returns {SeriesItem}
	   * @private
	   */
	
	
	  BoundsTypeEventDetector.prototype._getSeriesItemByIndexes = function _getSeriesItemByIndexes(indexes) {
	    var seriesDataModel = this.dataProcessor.getSeriesDataModel(_const2['default'].CHART_TYPE_TREEMAP);
	
	    return seriesDataModel.getSeriesItem(indexes.groupIndex, indexes.index, true);
	  };
	
	  /**
	   * On mousemove.
	   * @param {MouseEvent} e - mouse event
	   * @private
	   * @override
	   */
	
	
	  BoundsTypeEventDetector.prototype._onClick = function _onClick(e) {
	    var target = e.target || e.srcElement;
	
	    _mouseEventDetectorBase2['default'].prototype._onClick.call(this, e);
	
	    if (!_predicate2['default'].isTreemapChart(this.chartType)) {
	      return;
	    }
	
	    if (_domHandler2['default'].hasClass(target, _const2['default'].CLASS_NAME_RESET_ZOOM_BTN)) {
	      this._hideTooltip();
	      this._zoomHistoryBack();
	
	      return;
	    }
	
	    var layerPosition = this._calculateLayerPosition(e.clientX, e.clientY);
	    var foundData = this._findDataFromBoundsCoordinateModel(layerPosition);
	
	    if (foundData) {
	      var seriesItem = this._getSeriesItemByIndexes(foundData.indexes);
	
	      if (!seriesItem.hasChild) {
	        return;
	      }
	
	      this._hideTooltip();
	      this.eventBus.fire('zoom', foundData.indexes.index);
	    }
	  };
	
	  /**
	   * On mouseout.
	   * @override
	   */
	
	
	  BoundsTypeEventDetector.prototype._onMouseout = function _onMouseout(_ref2) {
	    var clientX = _ref2.clientX,
	        clientY = _ref2.clientY;
	
	    // do not cache getBoundingClientRect() - if not, it will cause error when chart location changed
	    var bound = this.mouseEventDetectorContainer.getBoundingClientRect();
	    var left = bound.left,
	        right = bound.right,
	        top = bound.top,
	        bottom = bound.bottom;
	
	
	    if (left <= clientX && top <= clientY && right >= clientX && bottom >= clientY) {
	      return;
	    }
	
	    if (this.prevFoundData) {
	      this._hideTooltip();
	    }
	
	    this.prevFoundData = null;
	  };
	
	  /**
	   * On after zoom.
	   * @param {number} index - index of target seriesItem
	   */
	
	
	  BoundsTypeEventDetector.prototype.onAfterZoom = function onAfterZoom(index) {
	    if (!this.historyBackBtn) {
	      this.historyBackBtn = _domHandler2['default'].create('DIV', _const2['default'].CLASS_NAME_RESET_ZOOM_BTN);
	      _domHandler2['default'].append(this.mouseEventDetectorContainer, this.historyBackBtn);
	    }
	
	    if (this.zoomHistory[this.zoomHistory.length - 1] !== index) {
	      this.zoomHistory.push(index);
	    }
	  };
	
	  /**
	   * Find data by indexes.
	   * @param {{index: {number}, seriesIndex: {number}}} indexes - indexe of series item displaying a tooltip
	   * @param {number} [indexes.outlierIndex] - index of outlier of boxplot series, it only exists in boxplot chart
	   * @returns {object} - series item data
	   */
	
	
	  BoundsTypeEventDetector.prototype.findDataByIndexes = function findDataByIndexes(indexes) {
	    return this.boundsBaseCoordinateModel.findDataByIndexes(indexes);
	  };
	
	  return BoundsTypeEventDetector;
	}(_mouseEventDetectorBase2['default']);
	
	/**
	 * boundsTypeEventDetectorFactory
	 * @param {object} params chart options
	 * @returns {object} event detect instance
	 * @ignore
	 */
	
	
	function boundsTypeEventDetectorFactory(params) {
	  return new BoundsTypeEventDetector(params);
	}
	
	boundsTypeEventDetectorFactory.componentType = 'mouseEventDetector';

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports['default'] = barSeriesFactory;
	
	var _series = __webpack_require__(82);
	
	var _series2 = _interopRequireDefault(_series);
	
	var _barTypeSeriesBase = __webpack_require__(83);
	
	var _barTypeSeriesBase2 = _interopRequireDefault(_barTypeSeriesBase);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
	
	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }
	
	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @fileoverview Bar chart series component.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @author NHN.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */
	
	
	var OVERLAPPING_WIDTH = _const2['default'].OVERLAPPING_WIDTH,
	    TEXT_PADDING = _const2['default'].TEXT_PADDING;
	
	var BarChartSeries = function (_Series) {
	  _inherits(BarChartSeries, _Series);
	
	  function BarChartSeries() {
	    _classCallCheck(this, BarChartSeries);
	
	    return _possibleConstructorReturn(this, _Series.apply(this, arguments));
	  }
	
	  /**
	   * Bar chart series component.
	   * @constructs BarChartSeries
	   * @private
	   * @extends Series
	   * @param {object} params parameters
	   *      @param {object} params.model series model
	   *      @param {object} params.options series options
	   *      @param {object} params.theme series theme
	   */
	
	  /**
	   * Make bound of bar chart.
	   * @param {number} width width
	   * @param {number} height height
	   * @param {number} top top position value
	   * @param {number} startLeft start left position value
	   * @param {number} endLeft end left position value
	   * @returns {{
	   *      start: {left: number, top: number, width: number, height: number},
	   *      end: {left: number, top: number, width: number, height: number}
	   * }} column chart bound
	   * @private
	   */
	  BarChartSeries.prototype._makeBound = function _makeBound(width, height, top, startLeft, endLeft) {
	    return {
	      start: {
	        top: top,
	        left: startLeft,
	        width: 0,
	        height: height
	      },
	      end: {
	        top: top,
	        left: endLeft,
	        width: width,
	        height: height
	      }
	    };
	  };
	
	  /**
	   * Calculate additional left for divided option.
	   * @param {number} value value
	   * @returns {number}
	   * @private
	   */
	
	
	  BarChartSeries.prototype._calculateAdditionalLeft = function _calculateAdditionalLeft(value) {
	    var additionalLeft = 0;
	
	    if (this.options.divided && value > 0) {
	      additionalLeft = this.dimensionMap.yAxis.width + OVERLAPPING_WIDTH;
	    }
	
	    return additionalLeft;
	  };
	
	  /**
	   * Make bar chart bound.
	   * @param {{
	   *      baseBarSize: number,
	   *      groupSize: number,
	   *      barSize: number,
	   *      pointInterval: number,
	   *      firstAdditionalPosition: number,
	   *      basePosition: number
	   * }} baseData base data for making bound
	   * @param {{
	   *      baseTop: number,
	   *      top: number,
	   *      plusLeft: number,
	   *      minusLeft: number,
	   *      prevStack: ?string
	   * }} iterationData iteration data
	   * @param {?boolean} isStackType whether stackType option or not.
	   * @param {SeriesItem} seriesItem series item
	   * @param {number} index index
	   * @returns {{
	   *      start: {left: number, top: number, width: number, height: number},
	   *      end: {left: number, top: number, width: number, height: number}
	   * }}
	   * @private
	   */
	
	
	  BarChartSeries.prototype._makeBarChartBound = function _makeBarChartBound(baseData, iterationData, isStackType, seriesItem, index) {
	    var baseBarSize = baseData.baseBarSize,
	        basePosition = baseData.basePosition,
	        barSize = baseData.barSize,
	        itemCount = baseData.itemCount,
	        groupSize = baseData.groupSize,
	        pointInterval = baseData.pointInterval;
	    var ratioDistance = seriesItem.ratioDistance,
	        value = seriesItem.value,
	        startRatio = seriesItem.startRatio,
	        stack = seriesItem.stack;
	
	
	    var barWidth = baseBarSize * ratioDistance;
	    var additionalLeft = this._calculateAdditionalLeft(value);
	    var barStartLeft = baseBarSize * startRatio;
	    var startLeft = basePosition + barStartLeft + additionalLeft;
	    var changedStack = stack !== iterationData.prevStack;
	    var isOverLapBar = barSize * itemCount > groupSize;
	    var barInterval = isOverLapBar ? pointInterval : barSize;
	    var endLeft = void 0;
	
	    if (!isStackType || !this.options.diverging && changedStack) {
	      var pointCount = isStackType ? this.dataProcessor.findStackIndex(stack) : index;
	      iterationData.top = iterationData.baseTop + barInterval * pointCount;
	      iterationData.plusLeft = 0;
	      iterationData.minusLeft = 0;
	    }
	
	    if (value >= 0) {
	      endLeft = startLeft + iterationData.plusLeft;
	      iterationData.plusLeft += barWidth;
	    } else {
	      iterationData.minusLeft -= barWidth;
	      endLeft = startLeft + iterationData.minusLeft;
	    }
	
	    iterationData.prevStack = stack;
	
	    var boundTop = iterationData.top + pointInterval - barSize / 2;
	    if (!isOverLapBar) {
	      boundTop += (pointInterval - barSize) / 2 * (itemCount - 1);
	    }
	
	    return this._makeBound(barWidth, barSize, boundTop, startLeft, endLeft);
	  };
	
	  /**
	   * Make series bounds for rendering
	   * @returns {Array.<Array.<object>>} bounds
	   * @private
	   */
	
	
	  BarChartSeries.prototype._makeBounds = function _makeBounds() {
	    var _this2 = this;
	
	    var seriesDataModel = this._getSeriesDataModel();
	    var isStacked = _predicate2['default'].isValidStackOption(this.options.stackType);
	    var _layout = this.layout,
	        _layout$dimension = _layout.dimension,
	        width = _layout$dimension.width,
	        height = _layout$dimension.height,
	        top = _layout.position.top;
	
	    var baseData = this._makeBaseDataForMakingBound(height, width);
	
	    return seriesDataModel.map(function (seriesGroup, groupIndex) {
	      var baseTop = groupIndex * baseData.groupSize + top;
	      var iterationData = {
	        baseTop: baseTop,
	        top: baseTop,
	        plusLeft: 0,
	        minusLeft: 0,
	        prevStack: null
	      };
	      var iteratee = _this2._makeBarChartBound.bind(_this2, baseData, iterationData, isStacked);
	
	      return seriesGroup.map(iteratee);
	    });
	  };
	
	  /**
	   * Calculate top position of sum label.
	   * @param {{left: number, top: number}} bound bound
	   * @param {number} labelHeight label height
	   * @returns {number} top position value
	   * @private
	   */
	
	
	  BarChartSeries.prototype._calculateTopPositionOfSumLabel = function _calculateTopPositionOfSumLabel(bound, labelHeight) {
	    return bound.top + (bound.height - labelHeight + TEXT_PADDING) / 2;
	  };
	
	  return BarChartSeries;
	}(_series2['default']);
	
	_barTypeSeriesBase2['default'].mixin(BarChartSeries);
	
	/**
	 * barSeriesFactory
	 * @param {object} params chart options
	 * @returns {object} bar series instance
	 * @ignore
	 */
	function barSeriesFactory(params) {
	  var chartTheme = params.chartTheme,
	      libType = params.chartOptions.libType;
	
	
	  params.libType = libType;
	  params.chartType = 'bar';
	  params.chartBackground = chartTheme.chart.background;
	
	  return new BarChartSeries(params);
	}
	
	// @todo let's find better way
	barSeriesFactory.componentType = 'series';
	barSeriesFactory.BarChartSeries = BarChartSeries;

/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _tuiCodeSnippet = __webpack_require__(7);
	
	var _tuiCodeSnippet2 = _interopRequireDefault(_tuiCodeSnippet);
	
	var _const = __webpack_require__(9);
	
	var _const2 = _interopRequireDefault(_const);
	
	var _domHandler = __webpack_require__(10);
	
	var _domHandler2 = _interopRequireDefault(_domHandler);
	
	var _predicate = __webpack_require__(16);
	
	var _predicate2 = _interopRequireDefault(_predicate);
	
	var _renderUtil = __webpack_require__(8);
	
	var _renderUtil2 = _interopRequireDefault(_renderUtil);
	
	var _pluginFactory = __webpack_require__(34);
	
	var _pluginFactory2 = _interopRequireDefault(_pluginFactory);
	
	var _raphaelRenderUtil = __webpack_require__(6);
	
	var _raphaelRenderUtil2 = _interopRequireDefault(_raphaelRenderUtil);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
	
	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } } /**
	                                                                                                                                                           * @fileoverview Series base component.
	                                                                                                                                                           * @author NHN.
	                                                                                                                                                           *         FE Development Lab <dl_javascript@nhn.com>
	                                                                                                                                                           */
	
	var browser = _tuiCodeSnippet2['default'].browser;
	
	var IS_IE7 = browser.msie && browser.version === 7;
	
	var COMPONENT_TYPE_RAPHAEL = _const2['default'].COMPONENT_TYPE_RAPHAEL,
	    PUBLIC_EVENT_PREFIX = _const2['default'].PUBLIC_EVENT_PREFIX,
	    CLASS_NAME_SERIES_LABEL = _const2['default'].CLASS_NAME_SERIES_LABEL;
	
	var Series = function () {
	  /*
	   * Series base component.
	   * @constructs Series
	   * @private
	   * @param {object} params parameters
	   *      @param {object} params.options series options
	   *      @param {object} params.theme series theme
	   */
	  function Series(params) {
	    _classCallCheck(this, Series);
	
	    var libType = params.libType;
	
	    /**
	     * Series component className
	     * @type {string}
	     */
	
	    this.className = 'tui-chart-series-area';
	
	    /**
	     * Chart type
	     * @type {string}
	     */
	    this.chartType = params.chartType;
	
	    /**
	     * Series name
	     * @tpye {string}
	     */
	    this.seriesType = params.seriesType || params.chartType;
	
	    /**
	     * Component type
	     * @type {string}
	     */
	    this.componentType = params.componentType;
	
	    /**
	     * Data processor
	     * @type {DataProcessor}
	     */
	    this.dataProcessor = params.dataProcessor;
	
	    /**
	     * event bus for transmitting message
	     * @type {object}
	     */
	    this.eventBus = params.eventBus;
	
	    /**
	     * chart background.
	     * @type {string}
	     */
	    this.chartBackground = params.chartBackground;
	
	    /**
	     * Options
	     * @type {object}
	     */
	    this.options = params.options || {};
	
	    /**
	     * Theme
	     * @type {object}
	     */
	    this.orgTheme = this.theme = params.theme;
	
	    /**
	     * Graph renderer
	     * @type {object}
	     */
	    this.graphRenderer = _pluginFactory2['default'].get(libType, params.chartType);
	
	    /**
	     * series container
	     * @type {HTMLElement}
	     */
	    this.seriesContainer = null;
	
	    /**
	     * series label container
	     * @type {HTMLElement}
	     */
	    this.seriesLabelContainer = null;
	
	    /**
	     * series data
	     * @type {object}
	     */
	    this.seriesData = {};
	
	    /**
	     * Selected legend index
	     * @type {?number}
	     */
	    this.selectedLegendIndex = null;
	
	    /**
	     * effector for show layer
	     * @type {object}
	     */
	    this.labelShowEffector = null;
	
	    /**
	     * raphael object
	     * @type {null|object}
	     */
	    this.paper = null;
	
	    /**
	     * limit(min, max) data for series
	     * @type {null|{min:number, max:number}}
	     */
	    this.limit = null;
	
	    /**
	     * aligned
	     * @type {null|boolean}
	     */
	    this.aligned = null;
	
	    /**
	     * layout bounds information for this components
	     * @type {null|