export const randomData = (count: number) => {
  const categories = [...Array(count).keys()].map((numb) => String(numb));
  const series = [
    {
      name: 'A',
      data: categories.map(() => parseInt(String(Math.random() * 100), 10)),
    },
    {
      name: 'B',
      data: categories.map(() => parseInt(String(Math.random() * 100), 10)),
    },
  ];

  return { categories, series };
};

export const temperatureData = {
  categories: [
    '01/01/2020',
    '02/01/2020',
    '03/01/2020',
    '04/01/2020',
    '05/01/2020',
    '06/01/2020',
    '07/01/2020',
    '08/01/2020',
    '09/01/2020',
    '10/01/2020',
    '11/01/2020',
    '12/01/2020',
  ],
  series: [
    {
      name: 'Seoul',
      data: [-3.5, -1.1, 4.0, 11.3, 17.5, 21.5, 25.9, 27.2, 24.4, 13.9, 6.6, -0.6],
    },
    {
      name: 'Seattle',
      data: [3.8, 5.6, 7.0, 9.1, 12.4, 15.3, 17.5, 17.8, 15.0, 10.6, 6.6, 3.7],
    },
    {
      name: 'Sydney',
      data: [22.1, 22.0, 20.9, 18.3, 15.2, 12.8, 11.8, 13.0, 15.2, 17.6, 19.4, 21.2],
    },
    {
      name: 'Moscow',
      data: [-10.3, -9.1, -4.1, 4.4, 12.2, 16.3, 18.5, 16.7, 10.9, 4.2, -2.0, -7.5],
    },
    {
      name: 'Jungfrau',
      data: [-13.2, -13.7, -13.1, -10.3, -6.1, -3.2, 0.0, -0.1, -1.8, -4.5, -9.0, -10.9],
    },
  ],
};

export const temperatureDataWithNull = {
  categories: [
    '01/01/2020',
    '02/01/2020',
    '03/01/2020',
    '04/01/2020',
    '05/01/2020',
    '06/01/2020',
    '07/01/2020',
    '08/01/2020',
    '09/01/2020',
    '10/01/2020',
    '11/01/2020',
    '12/01/2020',
  ],
  series: [
    {
      name: 'Seoul',
      data: [null, -1.1, 4.0, 14.6, 17.5, null, 25.9, null, 14.9, 13.9, 6.6, null],
    },
    {
      name: 'Sydney',
      data: [22.1, 22.0, 20.9, 18.3, 15.2, 12.8, 11.8, null, 17.2, 17.6, 19.4, 21.2],
    },
  ],
};

export const temperatureDataWithDateObject = {
  categories: [
    new Date('01/01/2020'),
    new Date('02/01/2020'),
    new Date('03/01/2020'),
    new Date('04/01/2020'),
    new Date('05/01/2020'),
    new Date('06/01/2020'),
    new Date('07/01/2020'),
    new Date('08/01/2020'),
    new Date('09/01/2020'),
    new Date('10/01/2020'),
    new Date('11/01/2020'),
    new Date('12/01/2020'),
  ],
  series: [
    {
      name: 'Seoul',
      data: [-3.5, -1.1, 4.0, 11.3, 17.5, 21.5, 24.9, 25.2, 20.4, 13.9, 6.6, -0.6],
    },
    {
      name: 'Seattle',
      data: [3.8, 5.6, 7.0, 9.1, 12.4, 15.3, 17.5, 17.8, 15.0, 10.6, 6.4, 3.7],
    },
    {
      name: 'Sydney',
      data: [22.1, 22.0, 20.9, 18.3, 15.2, 12.8, 11.8, 13.0, 15.2, 17.6, 19.4, 21.2],
    },
    {
      name: 'Moscow',
      data: [-10.3, -9.1, -4.1, 4.4, 12.2, 16.3, 18.5, 16.7, 10.9, 4.2, -2.0, -7.5],
    },
    {
      name: 'Jungfrau',
      data: [-13.2, -13.7, -13.1, -10.3, -6.1, -3.2, 0.0, -0.1, -1.8, -4.5, -9.0, -10.9],
    },
  ],
};

export const temperatureData2 = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
  series: [
    {
      name: 'Budget',
      data: [5000, 3000, 6000, 3000, 6000, 4000],
    },
    {
      name: 'Income',
      data: [8000, 1000, 7000, 2000, 5000, 3000],
    },
    {
      name: 'Outgo',
      data: [900, 6000, 1000, 9000, 3000, 1000],
    },
  ],
};

export const avgTemperatureData = {
  categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Seoul',
      data: [20, 40, 25, 50, 15, 45, 33, 34, 20, 30, 22, 13],
    },
    {
      name: 'Sydney',
      data: [5, 30, 21, 18, 59, 50, 28, 33, 7, 20, 10, 30],
    },
    {
      name: 'Moscow',
      data: [30, 5, 18, 21, 33, 41, 29, 15, 30, 10, 33, 5],
    },
  ],
};

export const avgTemperatureDataWithNull = {
  categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Seoul',
      data: [null, 40, 25, null, 15, 45, 33, 34, 24, 30, 22, null],
    },
    {
      name: 'Sydney',
      data: [5, 30, 21, 18, 59, null, 28, 10, null, 20, 10, 30],
    },
    {
      name: 'Moscow',
      data: [null, null, null, null, null, 41, 29, 15, 30, 10, 33, 5],
    },
  ],
};

export const budgetData = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Budget',
      data: [5000, 3000, 5000, 7000, 6000, 4000, 1000],
    },
    {
      name: 'Income',
      data: [8000, 4000, 7000, 2000, 6000, 3000, 5000],
    },
    {
      name: 'Expenses',
      data: [4000, 4000, 6000, 3000, 4000, 5000, 7000],
    },
    {
      name: 'Debt',
      data: [3000, 4000, 3000, 1000, 2000, 4000, 3000],
    },
  ],
};

export const budgetData2WithNull = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
  series: [
    {
      name: 'Budget',
      data: [null, 3000, 5000, 7000, 6000, 4000],
    },
    {
      name: 'Income',
      data: [8000, 4000, null, 2000, 6000, 3000],
    },
    {
      name: 'Expenses',
      data: [4000, 4000, null, 3000, null, 5000],
    },
    {
      name: 'Debt',
      data: [3000, 4000, 3000, 1000, 2000, null],
    },
  ],
};

export const budgetData2 = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
  series: [
    {
      name: 'Budget',
      data: [5000, 3000, 5000, 7000, 6000, 4000],
    },
    {
      name: 'Income',
      data: [8000, 4000, 7000, 2000, 6000, 3000],
    },
    {
      name: 'Expenses',
      data: [4000, 4000, 6000, 3000, 4000, 5000],
    },
    {
      name: 'Debt',
      data: [3000, 4000, 3000, 1000, 2000, 4000],
    },
  ],
};

export const negativeBudgetData = {
  categories: ['May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
  series: [
    {
      name: 'Budget',
      data: [4000, 5000, 3000, 5000, 7000, 6000],
    },
    {
      name: 'Income',
      data: [7000, 8000, 2000, 7000, 2500, 7000],
    },
    {
      name: 'Expenses',
      data: [-5000, -4000, -4000, -6000, -3000, -4000],
    },
    {
      name: 'Debt',
      data: [-3000, -6000, -3000, -5000, -2000, -1500],
    },
  ],
};

export const budgetDataForStack = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Budget',
      data: [5000, 3000, 5000, 7000, 6000, 4000, 1000],
    },
    {
      name: 'Income',
      data: [8000, 1000, 7000, 2000, 6000, 3000, 5000],
    },
    {
      name: 'Expenses',
      data: [4000, 4000, 6000, 3000, 4000, 5000, 7000],
    },
    {
      name: 'Debt',
      data: [6000, 3000, 3000, 1000, 2000, 4000, 3000],
    },
  ],
};

export const genderAgeGroupData = {
  categories: [
    '0 ~ 9',
    '10 ~ 19',
    '20 ~ 29',
    '30 ~ 39',
    '40 ~ 49',
    '50 ~ 59',
    '60 ~ 69',
    '70 ~ 79',
    '80 ~ 89',
    '90 ~ 99',
    '100 ~',
  ],
  series: [
    {
      name: 'Male - Seoul',
      data: [4007, 5067, 7221, 8358, 8500, 7730, 4962, 2670, 6700, 776, 131],
      stackGroup: 'Male',
    },
    {
      name: 'Female - Seoul',
      data: [3805, 4728, 7244, 8291, 8530, 8126, 5483, 3161, 1274, 2217, 377],
      stackGroup: 'Female',
    },
    {
      name: 'Male - Incheon',
      data: [1392, 1671, 2092, 2339, 2611, 2511, 1277, 6145, 1713, 1974, 194],
      stackGroup: 'Male',
    },
    {
      name: 'Female - Incheon',
      data: [1320, 1558, 1927, 2212, 2556, 2433, 1304, 8076, 3800, 6057, 523],
      stackGroup: 'Female',
    },
  ],
};

export const lossData = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
  series: [
    {
      name: 'Elviations',
      data: [-5000, -3000, -6000, -3000, -6000, -4000],
    },
    {
      name: 'Junglectics',
      data: [-8000, -1000, -7000, -2000, -5000, -3000],
    },
    {
      name: 'Amazonforce',
      data: [-900, -6000, -1000, -9000, -3000, -1000],
    },
  ],
};

export const lossDataForGroupStack = {
  categories: ['Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Elviations',
      data: [-5000, -3000, -5000, -7000, -6000, -4000, -1000],
      stackGroup: 'A',
    },
    {
      name: 'Junglectics',
      data: [-8000, -1000, -7000, -2000, -6000, -3000, -5000],
      stackGroup: 'B',
    },
    {
      name: 'Amazonforce',
      data: [-4000, -4000, -6000, -3000, -4000, -5000, -7000],
      stackGroup: 'A',
    },
    {
      name: 'Flowerbeat',
      data: [-6000, -3000, -3000, -1000, -2000, -4000, -3000],
      stackGroup: 'B',
    },
  ],
};

export const tupleCoordinateData = {
  series: [
    {
      name: 'SiteA',
      data: [
        [1, 202],
        [2, 212],
        [3, 222],
        [4, 351],
        [5, 412],
        [6, 420],
        [7, 300],
        [8, 213],
        [9, 230],
        [10, 220],
        [11, 234],
        [12, 210],
        [13, 220],
      ],
    },
    {
      name: 'SiteB',
      data: [
        [1, 312],
        [3, 320],
        [5, 295],
        [7, 300],
        [9, 320],
        [11, 30],
        [13, 20],
      ],
    },
  ],
};

export const coordinateData = {
  series: [
    {
      name: 'SiteA',
      data: [
        { x: 1, y: 202 },
        { x: 2, y: 212 },
        { x: 3, y: 222 },
        { x: 4, y: 351 },
        { x: 5, y: 412 },
        { x: 6, y: 420 },
        { x: 7, y: 300 },
        { x: 8, y: 213 },
        { x: 9, y: 230 },
        { x: 10, y: 220 },
        { x: 11, y: 234 },
        { x: 12, y: 210 },
        { x: 13, y: 220 },
      ],
    },
    {
      name: 'SiteB',
      data: [
        { x: 1, y: 312 },
        { x: 3, y: 320 },
        { x: 5, y: 295 },
        { x: 7, y: 300 },
        { x: 9, y: 320 },
        { x: 11, y: 30 },
        { x: 13, y: 20 },
      ],
    },
  ],
};

export const datetimeCoordinateData = {
  series: [
    {
      name: 'SiteA',
      data: [
        ['08/22/2020 10:00:00', 202],
        ['08/22/2020 10:05:00', 212],
        ['08/22/2020 10:10:00', 222],
        ['08/22/2020 10:15:00', 351],
        ['08/22/2020 10:20:00', 412],
        ['08/22/2020 10:25:00', 420],
        ['08/22/2020 10:30:00', 300],
        ['08/22/2020 10:35:00', 213],
        ['08/22/2020 10:40:00', 230],
        ['08/22/2020 10:45:00', 220],
        ['08/22/2020 10:50:00', 234],
        ['08/22/2020 10:55:00', 210],
        ['08/22/2020 11:00:00', 220],
      ],
    },
    {
      name: 'SiteB',
      data: [
        ['08/22/2020 10:00:00', 312],
        ['08/22/2020 10:10:00', 320],
        ['08/22/2020 10:20:00', 295],
        ['08/22/2020 10:30:00', 300],
        ['08/22/2020 10:40:00', 320],
        ['08/22/2020 10:50:00', 30],
        ['08/22/2020 11:00:00', 20],
      ],
    },
  ],
};

export const temperatureRangeData = {
  categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Seoul',
      data: [
        [-8.3, 0.3],
        [-5.8, 3.1],
        [-0.6, 9.1],
        [5.8, 16.9],
        [11.5, 22.6],
        [16.6, 26.6],
        [21.2, 28.8],
        [21.8, 30.0],
        [15.8, 25.6],
        [8.3, 19.6],
        [1.4, 11.1],
        [-5.2, 3.2],
      ],
    },
    {
      name: 'Busan',
      data: [
        [0, 10],
        [3.5, 13.1],
        [5.6, 13.1],
        [10.8, 16.9],
        [11.5, 18.6],
        [13.6, 20.6],
        [15.2, 20.8],
        [21.8, 26.0],
        [17.8, 23.6],
        [11.3, 16.6],
        [4.4, 11.1],
        [3.2, 11.2],
      ],
    },
  ],
};

export const temperatureRangeDataWithNull = {
  categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  series: [
    {
      name: 'Seoul',
      data: [
        [-8.3, 0.3],
        [-5.8, 3.1],
        null,
        [5.8, 16.9],
        [11.5, 22.6],
        [16.6, 26.6],
        [21.2, 28.8],
        [21.8, 30.0],
        [15.8, 25.6],
        [8.3, 19.6],
        [1.4, 11.1],
        [-5.2, 3.2],
      ],
    },
    {
      name: 'Busan',
      data: [
        [0, 10],
        [3.5, 13.1],
        null,
        [10.8, 16.9],
        [11.5, 18.6],
        [13.6, 20.6],
        null,
        [21.8, 26.0],
        [17.8, 23.6],
        null,
        [4.4, 11.1],
        [3.2, 11.2],
      ],
    },
  ],
};

export const genderHeightWeightData = {
  series: [
    {
      name: 'male',
      data: [
        { x: 174, y: 65.6 },
        { x: 175.3, y: 71.8 },
        { x: 193.5, y: 80.7 },
        { x: 186.5, y: 72.6 },
        { x: 187.2, y: 78.8 },
        { x: 181.5, y: 74.8 },
        { x: 184, y: 86.4 },
        { x: 184.5, y: 78.4 },
        { x: 175, y: 62 },
        { x: 184, y: 81.6 },
        { x: 180, y: 76.6 },
        { x: 177.8, y: 83.6 },
        { x: 192, y: 90 },
        { x: 176, y: 74.6 },
        { x: 174, y: 71 },
        { x: 184, y: 79.6 },
        { x: 192.7, y: 93.8 },
        { x: 171.5, y: 70 },
        { x: 173, y: 72.4 },
        { x: 176, y: 85.9 },
        { x: 176, y: 78.8 },
        { x: 180.5, y: 77.8 },
        { x: 172.7, y: 66.2 },
        { x: 176, y: 86.4 },
        { x: 173.5, y: 81.8 },
        { x: 178, y: 89.6 },
        { x: 180.3, y: 82.8 },
        { x: 180.3, y: 76.4 },
        { x: 164.5, y: 63.2 },
        { x: 173, y: 60.9 },
        { x: 183.5, y: 74.8 },
        { x: 175.5, y: 70 },
        { x: 188, y: 72.4 },
        { x: 189.2, y: 84.1 },
        { x: 172.8, y: 69.1 },
        { x: 170, y: 59.5 },
        { x: 182, y: 67.2 },
        { x: 170, y: 61.3 },
        { x: 177.8, y: 68.6 },
        { x: 184.2, y: 80.1 },
        { x: 186.7, y: 87.8 },
        { x: 171.4, y: 84.7 },
        { x: 172.7, y: 73.4 },
        { x: 175.3, y: 72.1 },
        { x: 180.3, y: 82.6 },
        { x: 182.9, y: 88.7 },
        { x: 188, y: 84.1 },
        { x: 177.2, y: 94.1 },
        { x: 172.1, y: 74.9 },
        { x: 167, y: 59.1 },
        { x: 169.5, y: 75.6 },
        { x: 174, y: 86.2 },
        { x: 172.7, y: 75.3 },
        { x: 182.2, y: 87.1 },
        { x: 164.1, y: 55.2 },
        { x: 163, y: 57 },
        { x: 171.5, y: 61.4 },
        { x: 184.2, y: 76.8 },
        { x: 174, y: 86.8 },
        { x: 174, y: 72.2 },
        { x: 177, y: 71.6 },
        { x: 186, y: 84.8 },
        { x: 167, y: 68.2 },
        { x: 171.8, y: 66.1 },
        { x: 182, y: 72 },
        { x: 167, y: 64.6 },
        { x: 177.8, y: 74.8 },
        { x: 164.5, y: 70 },
        { x: 192, y: 101.6 },
        { x: 175.5, y: 63.2 },
        { x: 171.2, y: 79.1 },
        { x: 181.6, y: 78.9 },
        { x: 167.4, y: 67.7 },
        { x: 181.1, y: 66 },
        { x: 177, y: 68.2 },
        { x: 174.5, y: 63.9 },
        { x: 177.5, y: 72 },
        { x: 170.5, y: 56.8 },
        { x: 182.4, y: 74.5 },
        { x: 197.1, y: 90.9 },
        { x: 180.1, y: 93 },
        { x: 175.5, y: 80.9 },
        { x: 180.6, y: 72.7 },
        { x: 184.4, y: 68 },
        { x: 175.5, y: 70.9 },
        { x: 180.6, y: 72.5 },
        { x: 177, y: 72.5 },
        { x: 177.1, y: 83.4 },
        { x: 181.6, y: 75.5 },
        { x: 176.5, y: 73 },
        { x: 175, y: 70.2 },
        { x: 174, y: 73.4 },
        { x: 165.1, y: 70.5 },
        { x: 177, y: 68.9 },
        { x: 192, y: 102.3 },
        { x: 176.5, y: 68.4 },
        { x: 169.4, y: 65.9 },
        { x: 182.1, y: 75.7 },
        { x: 179.8, y: 84.5 },
        { x: 175.3, y: 87.7 },
        { x: 184.9, y: 86.4 },
        { x: 177.3, y: 73.2 },
        { x: 167.4, y: 53.9 },
        { x: 178.1, y: 72 },
        { x: 168.9, y: 55.5 },
        { x: 157.2, y: 58.4 },
        { x: 180.3, y: 83.2 },
        { x: 170.2, y: 72.7 },
        { x: 177.8, y: 64.1 },
        { x: 172.7, y: 72.3 },
        { x: 165.1, y: 65 },
        { x: 186.7, y: 86.4 },
        { x: 165.1, y: 65 },
        { x: 174, y: 88.6 },
        { x: 175.3, y: 84.1 },
        { x: 185.4, y: 66.8 },
        { x: 177.8, y: 75.5 },
        { x: 180.3, y: 93.2 },
        { x: 180.3, y: 82.7 },
        { x: 177.8, y: 58 },
        { x: 177.8, y: 79.5 },
        { x: 177.8, y: 78.6 },
        { x: 177.8, y: 71.8 },
        { x: 177.8, y: 116.4 },
        { x: 163.8, y: 72.2 },
        { x: 188, y: 83.6 },
        { x: 198.1, y: 85.5 },
        { x: 175.3, y: 90.9 },
        { x: 166.4, y: 85.9 },
        { x: 190.5, y: 89.1 },
        { x: 166.4, y: 75 },
        { x: 177.8, y: 77.7 },
        { x: 179.7, y: 86.4 },
        { x: 172.7, y: 90.9 },
        { x: 190.5, y: 73.6 },
        { x: 185.4, y: 76.4 },
        { x: 168.9, y: 69.1 },
        { x: 167.6, y: 84.5 },
        { x: 175.3, y: 64.5 },
        { x: 170.2, y: 69.1 },
        { x: 190.5, y: 108.6 },
        { x: 177.8, y: 86.4 },
        { x: 190.5, y: 80.9 },
        { x: 177.8, y: 87.7 },
        { x: 184.2, y: 94.5 },
        { x: 176.5, y: 80.2 },
        { x: 177.8, y: 72 },
        { x: 180.3, y: 71.4 },
        { x: 171.4, y: 72.7 },
        { x: 172.7, y: 84.1 },
        { x: 172.7, y: 76.8 },
        { x: 177.8, y: 63.6 },
        { x: 177.8, y: 80.9 },
        { x: 182.9, y: 80.9 },
        { x: 170.2, y: 85.5 },
        { x: 167.6, y: 68.6 },
        { x: 175.3, y: 67.7 },
        { x: 165.1, y: 66.4 },
        { x: 185.4, y: 102.3 },
        { x: 181.6, y: 70.5 },
        { x: 172.7, y: 95.9 },
        { x: 190.5, y: 84.1 },
        { x: 179.1, y: 87.3 },
        { x: 175.3, y: 71.8 },
        { x: 170.2, y: 65.9 },
        { x: 193, y: 95.9 },
        { x: 171.4, y: 91.4 },
        { x: 177.8, y: 81.8 },
        { x: 177.8, y: 96.8 },
        { x: 167.6, y: 69.1 },
        { x: 167.6, y: 82.7 },
        { x: 180.3, y: 75.5 },
        { x: 182.9, y: 79.5 },
        { x: 176.5, y: 73.6 },
        { x: 186.7, y: 91.8 },
        { x: 188, y: 84.1 },
        { x: 188, y: 85.9 },
        { x: 177.8, y: 81.8 },
        { x: 174, y: 82.5 },
        { x: 177.8, y: 80.5 },
        { x: 171.4, y: 70 },
        { x: 185.4, y: 81.8 },
        { x: 185.4, y: 84.1 },
        { x: 188, y: 90.5 },
        { x: 188, y: 91.4 },
        { x: 182.9, y: 89.1 },
        { x: 176.5, y: 85 },
        { x: 175.3, y: 69.1 },
        { x: 175.3, y: 73.6 },
        { x: 188, y: 80.5 },
        { x: 188, y: 82.7 },
        { x: 175.3, y: 86.4 },
        { x: 170.5, y: 67.7 },
        { x: 179.1, y: 92.7 },
        { x: 177.8, y: 93.6 },
        { x: 175.3, y: 70.9 },
        { x: 182.9, y: 75 },
        { x: 170.8, y: 93.2 },
        { x: 188, y: 93.2 },
        { x: 180.3, y: 77.7 },
        { x: 177.8, y: 61.4 },
        { x: 185.4, y: 94.1 },
        { x: 168.9, y: 75 },
        { x: 185.4, y: 83.6 },
        { x: 180.3, y: 85.5 },
        { x: 174, y: 73.9 },
        { x: 167.6, y: 66.8 },
        { x: 182.9, y: 87.3 },
        { x: 160, y: 72.3 },
        { x: 180.3, y: 88.6 },
        { x: 167.6, y: 75.5 },
        { x: 186.7, y: 101.4 },
        { x: 175.3, y: 91.1 },
        { x: 175.3, y: 67.3 },
        { x: 175.9, y: 77.7 },
        { x: 175.3, y: 81.8 },
        { x: 179.1, y: 75.5 },
        { x: 181.6, y: 84.5 },
        { x: 177.8, y: 76.6 },
        { x: 182.9, y: 85 },
        { x: 177.8, y: 102.5 },
        { x: 184.2, y: 77.3 },
        { x: 179.1, y: 71.8 },
        { x: 176.5, y: 87.9 },
        { x: 188, y: 94.3 },
        { x: 174, y: 70.9 },
        { x: 167.6, y: 64.5 },
        { x: 170.2, y: 77.3 },
        { x: 167.6, y: 72.3 },
        { x: 188, y: 87.3 },
        { x: 174, y: 80 },
        { x: 176.5, y: 82.3 },
        { x: 180.3, y: 73.6 },
        { x: 167.6, y: 74.1 },
        { x: 188, y: 85.9 },
        { x: 180.3, y: 73.2 },
        { x: 167.6, y: 76.3 },
        { x: 183, y: 65.9 },
        { x: 183, y: 90.9 },
        { x: 179.1, y: 89.1 },
        { x: 170.2, y: 62.3 },
        { x: 177.8, y: 82.7 },
        { x: 179.1, y: 79.1 },
        { x: 190.5, y: 98.2 },
        { x: 177.8, y: 84.1 },
        { x: 180.3, y: 83.2 },
        { x: 180.3, y: 83.2 },
      ],
    },
    {
      name: 'female',
      data: [
        { x: 161.2, y: 51.6 },
        { x: 167.5, y: 59 },
        { x: 159.5, y: 49.2 },
        { x: 157, y: 63 },
        { x: 155.8, y: 53.6 },
        { x: 170, y: 59 },
        { x: 159.1, y: 47.6 },
        { x: 166, y: 69.8 },
        { x: 176.2, y: 66.8 },
        { x: 160.2, y: 75.2 },
        { x: 172.5, y: 55.2 },
        { x: 170.9, y: 54.2 },
        { x: 172.9, y: 62.5 },
        { x: 153.4, y: 42 },
        { x: 160, y: 50 },
        { x: 147.2, y: 49.8 },
        { x: 168.2, y: 49.2 },
        { x: 175, y: 73.2 },
        { x: 157, y: 47.8 },
        { x: 167.6, y: 68.8 },
        { x: 159.5, y: 50.6 },
        { x: 175, y: 82.5 },
        { x: 166.8, y: 57.2 },
        { x: 176.5, y: 87.8 },
        { x: 170.2, y: 72.8 },
        { x: 174, y: 54.5 },
        { x: 173, y: 59.8 },
        { x: 179.9, y: 67.3 },
        { x: 170.5, y: 67.8 },
        { x: 160, y: 47 },
        { x: 154.4, y: 46.2 },
        { x: 162, y: 55 },
        { x: 176.5, y: 83 },
        { x: 160, y: 54.4 },
        { x: 152, y: 45.8 },
        { x: 162.1, y: 53.6 },
        { x: 170, y: 73.2 },
        { x: 160.2, y: 52.1 },
        { x: 161.3, y: 67.9 },
        { x: 166.4, y: 56.6 },
        { x: 168.9, y: 62.3 },
        { x: 163.8, y: 58.5 },
        { x: 167.6, y: 54.5 },
        { x: 160, y: 50.2 },
        { x: 161.3, y: 60.3 },
        { x: 167.6, y: 58.3 },
        { x: 165.1, y: 56.2 },
        { x: 160, y: 50.2 },
        { x: 170, y: 72.9 },
        { x: 157.5, y: 59.8 },
        { x: 167.6, y: 61 },
        { x: 160.7, y: 69.1 },
        { x: 163.2, y: 55.9 },
        { x: 152.4, y: 46.5 },
        { x: 157.5, y: 54.3 },
        { x: 168.3, y: 54.8 },
        { x: 180.3, y: 60.7 },
        { x: 165.5, y: 60 },
        { x: 165, y: 62 },
        { x: 164.5, y: 60.3 },
        { x: 156, y: 52.7 },
        { x: 160, y: 74.3 },
        { x: 163, y: 62 },
        { x: 165.7, y: 73.1 },
        { x: 161, y: 80 },
        { x: 162, y: 54.7 },
        { x: 166, y: 53.2 },
        { x: 174, y: 75.7 },
        { x: 172.7, y: 61.1 },
        { x: 167.6, y: 55.7 },
        { x: 151.1, y: 48.7 },
        { x: 164.5, y: 52.3 },
        { x: 163.5, y: 50 },
        { x: 152, y: 59.3 },
        { x: 169, y: 62.5 },
        { x: 164, y: 55.7 },
        { x: 161.2, y: 54.8 },
        { x: 155, y: 45.9 },
        { x: 170, y: 70.6 },
        { x: 176.2, y: 67.2 },
        { x: 170, y: 69.4 },
        { x: 162.5, y: 58.2 },
        { x: 170.3, y: 64.8 },
        { x: 164.1, y: 71.6 },
        { x: 169.5, y: 52.8 },
        { x: 163.2, y: 59.8 },
        { x: 154.5, y: 49 },
        { x: 159.8, y: 50 },
        { x: 173.2, y: 69.2 },
        { x: 170, y: 55.9 },
        { x: 161.4, y: 63.4 },
        { x: 169, y: 58.2 },
        { x: 166.2, y: 58.6 },
        { x: 159.4, y: 45.7 },
        { x: 162.5, y: 52.2 },
        { x: 159, y: 48.6 },
        { x: 162.8, y: 57.8 },
        { x: 159, y: 55.6 },
        { x: 179.8, y: 66.8 },
        { x: 162.9, y: 59.4 },
        { x: 161, y: 53.6 },
        { x: 151.1, y: 73.2 },
        { x: 168.2, y: 53.4 },
        { x: 168.9, y: 69 },
        { x: 173.2, y: 58.4 },
        { x: 171.8, y: 56.2 },
        { x: 178, y: 70.6 },
        { x: 164.3, y: 59.8 },
        { x: 163, y: 72 },
        { x: 168.5, y: 65.2 },
        { x: 166.8, y: 56.6 },
        { x: 172.7, y: 105.2 },
        { x: 163.5, y: 51.8 },
        { x: 169.4, y: 63.4 },
        { x: 167.8, y: 59 },
        { x: 159.5, y: 47.6 },
        { x: 167.6, y: 63 },
        { x: 161.2, y: 55.2 },
        { x: 160, y: 45 },
        { x: 163.2, y: 54 },
        { x: 162.2, y: 50.2 },
        { x: 161.3, y: 60.2 },
        { x: 149.5, y: 44.8 },
        { x: 157.5, y: 58.8 },
        { x: 163.2, y: 56.4 },
        { x: 172.7, y: 62 },
        { x: 155, y: 49.2 },
        { x: 156.5, y: 67.2 },
        { x: 164, y: 53.8 },
        { x: 160.9, y: 54.4 },
        { x: 162.8, y: 58 },
        { x: 167, y: 59.8 },
        { x: 160, y: 54.8 },
        { x: 160, y: 43.2 },
        { x: 168.9, y: 60.5 },
        { x: 158.2, y: 46.4 },
        { x: 156, y: 64.4 },
        { x: 160, y: 48.8 },
        { x: 167.1, y: 62.2 },
        { x: 158, y: 55.5 },
        { x: 167.6, y: 57.8 },
        { x: 156, y: 54.6 },
        { x: 162.1, y: 59.2 },
        { x: 173.4, y: 52.7 },
        { x: 159.8, y: 53.2 },
        { x: 170.5, y: 64.5 },
        { x: 159.2, y: 51.8 },
        { x: 157.5, y: 56 },
        { x: 161.3, y: 63.6 },
        { x: 162.6, y: 63.2 },
        { x: 160, y: 59.5 },
        { x: 168.9, y: 56.8 },
        { x: 165.1, y: 64.1 },
        { x: 162.6, y: 50 },
        { x: 165.1, y: 72.3 },
        { x: 166.4, y: 55 },
        { x: 160, y: 55.9 },
        { x: 152.4, y: 60.4 },
        { x: 170.2, y: 69.1 },
        { x: 162.6, y: 84.5 },
        { x: 170.2, y: 55.9 },
        { x: 158.8, y: 55.5 },
        { x: 172.7, y: 69.5 },
        { x: 167.6, y: 76.4 },
        { x: 162.6, y: 61.4 },
        { x: 167.6, y: 65.9 },
        { x: 156.2, y: 58.6 },
        { x: 175.2, y: 66.8 },
        { x: 172.1, y: 56.6 },
        { x: 162.6, y: 58.6 },
        { x: 160, y: 55.9 },
        { x: 165.1, y: 59.1 },
        { x: 182.9, y: 81.8 },
        { x: 166.4, y: 70.7 },
        { x: 165.1, y: 56.8 },
        { x: 177.8, y: 60 },
        { x: 165.1, y: 58.2 },
        { x: 175.3, y: 72.7 },
        { x: 154.9, y: 54.1 },
        { x: 158.8, y: 49.1 },
        { x: 172.7, y: 75.9 },
        { x: 168.9, y: 55 },
        { x: 161.3, y: 57.3 },
        { x: 167.6, y: 55 },
        { x: 165.1, y: 65.5 },
        { x: 175.3, y: 65.5 },
        { x: 157.5, y: 48.6 },
        { x: 163.8, y: 58.6 },
        { x: 167.6, y: 63.6 },
        { x: 165.1, y: 55.2 },
        { x: 165.1, y: 62.7 },
        { x: 168.9, y: 56.6 },
        { x: 162.6, y: 53.9 },
        { x: 164.5, y: 63.2 },
        { x: 176.5, y: 73.6 },
        { x: 168.9, y: 62 },
        { x: 175.3, y: 63.6 },
        { x: 159.4, y: 53.2 },
        { x: 160, y: 53.4 },
        { x: 170.2, y: 55 },
        { x: 162.6, y: 70.5 },
        { x: 167.6, y: 54.5 },
        { x: 162.6, y: 54.5 },
        { x: 160.7, y: 55.9 },
        { x: 160, y: 59 },
        { x: 157.5, y: 63.6 },
        { x: 162.6, y: 54.5 },
        { x: 152.4, y: 47.3 },
        { x: 170.2, y: 67.7 },
        { x: 165.1, y: 80.9 },
        { x: 172.7, y: 70.5 },
        { x: 165.1, y: 60.9 },
        { x: 170.2, y: 63.6 },
        { x: 170.2, y: 54.5 },
        { x: 170.2, y: 59.1 },
        { x: 161.3, y: 70.5 },
        { x: 167.6, y: 52.7 },
        { x: 167.6, y: 62.7 },
        { x: 165.1, y: 86.3 },
        { x: 162.6, y: 66.4 },
        { x: 152.4, y: 67.3 },
        { x: 168.9, y: 63 },
        { x: 170.2, y: 73.6 },
        { x: 175.2, y: 62.3 },
        { x: 175.2, y: 57.7 },
        { x: 160, y: 55.4 },
        { x: 165.1, y: 104.1 },
        { x: 174, y: 55.5 },
        { x: 170.2, y: 77.3 },
        { x: 160, y: 80.5 },
        { x: 167.6, y: 64.5 },
        { x: 167.6, y: 72.3 },
        { x: 167.6, y: 61.4 },
        { x: 154.9, y: 58.2 },
        { x: 162.6, y: 81.8 },
        { x: 175.3, y: 63.6 },
        { x: 171.4, y: 53.4 },
        { x: 157.5, y: 54.5 },
        { x: 165.1, y: 53.6 },
        { x: 160, y: 60 },
        { x: 174, y: 73.6 },
        { x: 162.6, y: 61.4 },
        { x: 174, y: 55.5 },
        { x: 162.6, y: 63.6 },
        { x: 161.3, y: 60.9 },
        { x: 156.2, y: 60 },
        { x: 149.9, y: 46.8 },
        { x: 169.5, y: 57.3 },
        { x: 160, y: 64.1 },
        { x: 175.3, y: 63.6 },
        { x: 169.5, y: 67.3 },
        { x: 160, y: 75.5 },
        { x: 172.7, y: 68.2 },
        { x: 162.6, y: 61.4 },
        { x: 157.5, y: 76.8 },
        { x: 176.5, y: 71.8 },
        { x: 164.4, y: 55.5 },
        { x: 160.7, y: 48.6 },
        { x: 174, y: 66.4 },
        { x: 163.8, y: 67.3 },
      ],
    },
  ],
};

export const genderHeightWeightDataWithNull = {
  series: [
    {
      name: 'male',
      data: [{ x: 174, y: 65.6 }, { x: 175.3, y: 71.8 }, null, { x: 181.5, y: 74.8 }],
    },
  ],
};

export const currentUserCoordinateDatetimeData = {
  series: [
    {
      name: 'User1',
      data: [
        { x: new Date('08/22/2020 10:00:00'), y: 202 },
        { x: new Date('08/22/2020 10:05:00'), y: 211 },
        { x: new Date('08/22/2020 10:10:00'), y: 212 },
        { x: new Date('08/22/2020 11:00:00'), y: 220 },
      ],
    },
    {
      name: 'User2',
      data: [
        { x: '08/22/2020 10:00:00', y: 205 },
        { x: '08/22/2020 10:40:00', y: 320 },
        { x: '08/22/2020 10:50:00', y: 190 },
        { x: '08/22/2020 11:00:00', y: 156 },
      ],
    },
    {
      name: 'User3',
      data: [
        { x: new Date('08/22/2020 10:35:00'), y: 213 },
        { x: new Date('08/22/2020 10:40:00'), y: 230 },
        { x: new Date('08/22/2020 10:30:00'), y: 113 },
        { x: new Date('08/22/2020 10:55:00'), y: 210 },
      ],
    },
    {
      name: 'User4',
      data: [
        { x: '08/22/2020 10:00:00', y: 312 },
        { x: '08/22/2020 10:10:00', y: 320 },
        { x: '08/22/2020 10:20:00', y: 295 },
      ],
    },
    {
      name: 'User5',
      data: [
        { x: '08/22/2020 10:20:00', y: 112 },
        { x: '08/22/2020 10:30:00', y: 225 },
        { x: '08/22/2020 10:40:00', y: 220 },
      ],
    },
    {
      name: 'User6',
      data: [
        { x: '08/22/2020 10:30:00', y: 312 },
        { x: '08/22/2020 10:40:00', y: 255 },
        { x: '08/22/2020 10:50:00', y: 260 },
      ],
    },
    {
      name: 'User7',
      data: [
        { x: '08/22/2020 10:10:00', y: 182 },
        { x: '08/22/2020 10:20:00', y: 285 },
        { x: '08/22/2020 10:30:00', y: 280 },
      ],
    },
  ],
};

export const currentUserCoordinate = {
  series: [
    {
      name: 'User1',
      data: [
        { x: 10, y: 202 },
        { x: 50, y: 211 },
        { x: 70, y: 212 },
        { x: 80, y: 220 },
      ],
    },
    {
      name: 'User2',
      data: [
        { x: 50, y: 205 },
        { x: 100, y: 320 },
        { x: 120, y: 190 },
        { x: 140, y: 156 },
        { x: 150, y: 136 },
        { x: 160, y: 166 },
        { x: 170, y: 154 },
        { x: 180, y: 157 },
        { x: 190, y: 200 },
      ],
    },
    {
      name: 'User3',
      data: [
        { x: 30, y: 213 },
        { x: 40, y: 230 },
        { x: 120, y: 113 },
        { x: 130, y: 210 },
      ],
    },
    {
      name: 'User4',
      data: [
        { x: 30, y: 12 },
        { x: 60, y: 12 },
        { x: 90, y: 312 },
        { x: 100, y: 320 },
        { x: 110, y: 295 },
        { x: 120, y: 312 },
        { x: 130, y: 120 },
        { x: 140, y: 295 },
        { x: 150, y: 112 },
        { x: 160, y: 120 },
        { x: 170, y: 295 },
        { x: 180, y: 212 },
        { x: 190, y: 320 },
        { x: 200, y: 295 },
        { x: 210, y: 212 },
        { x: 120, y: 220 },
        { x: 230, y: 295 },
      ],
    },
    {
      name: 'User5',
      data: [
        { x: 100, y: 112 },
        { x: 130, y: 225 },
        { x: 140, y: 220 },
        { x: 200, y: 220 },
        { x: 210, y: 220 },
      ],
    },
    {
      name: 'User6',
      data: [
        { x: 10, y: 312 },
        { x: 20, y: 255 },
        { x: 30, y: 260 },
        { x: 70, y: 312 },
        { x: 80, y: 255 },
        { x: 100, y: 260 },
        { x: 110, y: 12 },
        { x: 120, y: 55 },
        { x: 130, y: 60 },
        { x: 140, y: 212 },
        { x: 150, y: 82 },
        { x: 180, y: 212 },
        { x: 200, y: 100 },
      ],
    },
    {
      name: 'User7',
      data: [
        { x: 40, y: 182 },
        { x: 50, y: 285 },
        { x: 60, y: 280 },
      ],
    },
  ],
};

export const lifeExpectancyPerGDPData = {
  series: [
    {
      name: 'Africa',
      data: [
        { x: 4200, y: 70.35, r: 32209101, label: 'Morocco' },
        { x: 4200, y: 70.71, r: 76117421, label: 'Egypt' },
        { x: 5900, y: 56.46, r: 1355246, label: 'Gabon' },
        { x: 6600, y: 72.74, r: 32129324, label: 'Algeria' },
        { x: 6700, y: 76.28, r: 5631585, label: 'Libya' },
        { x: 7100, y: 74.66, r: 9974722, label: 'Tunisia' },
        { x: 10500, y: 69.28, r: 1096585, label: 'Trinidad and Tobago' },
        { x: 12800, y: 72.09, r: 1220481, label: 'Mauritius' },
        { x: 18200, y: 78.68, r: 396851, label: 'Malta' },
      ],
    },
    {
      name: 'America',
      data: [
        { x: 4800, y: 74.64, r: 6191368, label: 'Paraguay' },
        { x: 4900, y: 70.92, r: 6587541, label: 'El Salvador' },
        { x: 5600, y: 69.22, r: 2754430, label: 'Peru' },
        { x: 5800, y: 74.06, r: 2501738, label: 'Venezuela' },
        { x: 6300, y: 67.63, r: 8833634, label: 'Dominican Republic' },
        { x: 6500, y: 67.43, r: 272945, label: 'Belize' },
        { x: 6600, y: 71.43, r: 4231077, label: 'Colombia' },
        { x: 6900, y: 72.14, r: 3000463, label: 'Panama' },
        { x: 8100, y: 71.41, r: 78410118, label: 'Brazil' },
        { x: 9600, y: 76.63, r: 3956507, label: 'Costa Rica' },
        { x: 9600, y: 74.94, r: 4495959, label: 'Mexico' },
        { x: 12400, y: 75.7, r: 6914475, label: 'Argentina' },
        { x: 14500, y: 75.92, r: 3399237, label: 'Uruguay' },
        { x: 16400, y: 71.64, r: 278289, label: 'Barbados' },
        { x: 17700, y: 65.63, r: 299697, label: 'Bahamas, The' },
        { x: 17700, y: 77.49, r: 3897960, label: 'Puerto Rico' },
        { x: 31500, y: 79.96, r: 32507874, label: 'Canada' },
        { x: 32100, y: 77.43, r: 89302754, label: 'United States' },
      ],
    },
    {
      name: 'Asia',
      data: [
        { x: 5600, y: 71.96, r: 92988000, label: 'China' },
        { x: 5700, y: 61.29, r: 4863169, label: 'Turkmenistan' },
        { x: 7700, y: 69.66, r: 19018924, label: 'Iran' },
        { x: 7800, y: 66.07, r: 1514370, label: 'Kazakhstan' },
        { x: 8100, y: 71.41, r: 14865523, label: 'Thailand' },
        { x: 9700, y: 71.95, r: 23522482, label: 'Malaysia' },
        { x: 12000, y: 75.23, r: 25795938, label: 'Saudi Arabia' },
        { x: 13100, y: 72.85, r: 2903165, label: 'Oman' },
        { x: 19200, y: 75.58, r: 48598170, label: 'Korea, South' },
        { x: 19200, y: 73.98, r: 677886, label: 'Bahrain' },
        { x: 20800, y: 79.17, r: 6199008, label: 'Israel' },
        { x: 21300, y: 76.84, r: 2257549, label: 'Kuwait' },
        { x: 23200, y: 73.4, r: 840290, label: 'Qatar' },
        { x: 25200, y: 74.99, r: 2523915, label: 'United Arab Emirates' },
        { x: 25300, y: 77.06, r: 22749838, label: 'Taiwan' },
        { x: 27800, y: 81.53, r: 4353893, label: 'Singapore' },
        { x: 29400, y: 81.04, r: 52733300, label: 'Japan' },
        { x: 34200, y: 81.39, r: 6855125, label: 'Hong Kong' },
      ],
    },
    {
      name: 'Europe',
      data: [
        { x: 7700, y: 71.12, r: 2235555, label: 'Romania' },
        { x: 8200, y: 71.75, r: 7517973, label: 'Bulgaria' },
        { x: 9800, y: 66.39, r: 54378233, label: 'Russia' },
        { x: 10700, y: 76.38, r: 1582395, label: 'Chile' },
        { x: 11200, y: 74.14, r: 4496869, label: 'Croatia' },
        { x: 11500, y: 70.86, r: 2306306, label: 'Latvia' },
        { x: 12000, y: 74.16, r: 38626349, label: 'Poland' },
        { x: 12500, y: 73.46, r: 3607899, label: 'Lithuania' },
        { x: 14300, y: 71.38, r: 1341664, label: 'Estonia' },
        { x: 14500, y: 74.19, r: 5423567, label: 'Slovakia' },
        { x: 14900, y: 72.25, r: 1003237, label: 'Hungary' },
        { x: 16800, y: 75.78, r: 1024617, label: 'Czech Republic' },
        { x: 17900, y: 77.35, r: 1052414, label: 'Portugal' },
        { x: 19600, y: 75.93, r: 2011473, label: 'Slovenia' },
        { x: 21300, y: 78.94, r: 10647529, label: 'Greece' },
        { x: 23300, y: 79.37, r: 40280780, label: 'Spain' },
        { x: 27700, y: 79.54, r: 58057477, label: 'Italy' },
        { x: 28400, y: 80.3, r: 898640, label: 'Sweden' },
        { x: 28700, y: 78.54, r: 22424609, label: 'Germany' },
        { x: 28700, y: 79.44, r: 30424213, label: 'France' },
        { x: 29000, y: 78.24, r: 5214512, label: 'Finland' },
        { x: 29500, y: 78.68, r: 16318199, label: 'Netherlands' },
        { x: 29600, y: 78.27, r: 60270708, label: 'United Kingdom' },
        { x: 30600, y: 78.44, r: 10348276, label: 'Belgium' },
        { x: 31300, y: 78.87, r: 8174762, label: 'Austria' },
        { x: 31900, y: 77.36, r: 3969558, label: 'Ireland' },
        { x: 31900, y: 80.18, r: 293966, label: 'Iceland' },
        { x: 32200, y: 77.44, r: 5413392, label: 'Denmark' },
        { x: 33800, y: 80.31, r: 7450867, label: 'Switzerland' },
      ],
    },
    {
      name: 'Oceania',
      data: [
        { x: 2200, y: 64.56, r: 5420280, label: 'Papua New Guinea' },
        { x: 2700, y: 61.32, r: 100798, label: 'Kiribati' },
        { x: 5900, y: 69.2, r: 880874, label: 'Fiji' },
        { x: 14500, y: 78.75, r: 108775, label: 'Virgin Islands' },
        { x: 23200, y: 78.49, r: 1993817, label: 'New Zealand' },
        { x: 30700, y: 80.26, r: 5991314, label: 'Australia' },
      ],
    },
  ],
};

export const circleLegendOverlapData = {
  series: [
    {
      name: 'AAAA',
      data: [{ x: 500, y: 50, r: 300, label: 'a' }],
    },
    {
      name: 'BBBB',
      data: [{ x: 1000, y: 70, r: 500, label: 'b' }],
    },
    {
      name: 'CCCC',
      data: [{ x: 3600, y: 100, r: 1000, label: 'c' }],
    },
    {
      name: 'DDDD',
      data: [{ x: 5700, y: 10, r: 3000, label: 'd' }],
    },
    {
      name: 'EEEEE',
      data: [{ x: 2200, y: 30, r: 10000, label: 'e' }],
    },
    {
      name: 'FFFFF',
      data: [{ x: 2200, y: 30, r: 25000, label: 'f' }],
    },
    {
      name: 'GGGGG',
      data: [{ x: 3200, y: 30, r: 3000, label: 'g' }],
    },
    {
      name: 'HHHHH',
      data: [{ x: 5200, y: 30, r: 45000, label: 'h' }],
    },
    {
      name: 'IIIII',
      data: [{ x: 7200, y: 30, r: 15000, label: 'i' }],
    },
    {
      name: 'JJJJJ',
      data: [{ x: 9200, y: 30, r: 5000, label: 'j' }],
    },
    {
      name: 'KKKK',
      data: [{ x: 1220, y: 30, r: 45000, label: 'k' }],
    },
    {
      name: 'LLLL',
      data: [{ x: 5220, y: 30, r: 15000, label: 'l' }],
    },
    {
      name: 'MMMM',
      data: [{ x: 2200, y: 130, r: 25000, label: 'm' }],
    },
  ],
};

export const lifeExpectancyPerGDPDataWithNull = {
  series: [
    {
      name: 'Africa',
      data: [
        { x: 4200, y: 70.35, r: 32209101, label: 'Morocco' },
        { x: 4200, y: 70.71, r: 76117421, label: 'Egypt' },
        { x: 5900, y: 56.46, r: 1355246, label: 'Gabon' },
        null,
        { x: 6600, y: 72.74, r: 32129324, label: 'Algeria' },
      ],
    },
  ],
};

export const lifeExpectancyPerGDPDataWithDatetime = {
  series: [
    {
      name: 'Africa',
      data: [
        { x: '08/22/2020 11:30:00', y: 70.35, r: 32209101, label: 'Morocco' },
        { x: '08/22/2020 11:30:00', y: 70.71, r: 76117421, label: 'Egypt' },
        { x: '08/22/2020 11:10:00', y: 56.46, r: 1355246, label: 'Gabon' },
        { x: '08/22/2020 11:20:00', y: 76.28, r: 5631585, label: 'Libya' },
        { x: '08/22/2020 11:30:00', y: 74.66, r: 9974722, label: 'Tunisia' },
      ],
    },
    {
      name: 'America',
      data: [
        { x: '08/22/2020 11:00:00', y: 74.64, r: 6191368, label: 'Paraguay' },
        { x: '08/22/2020 11:05:00', y: 70.92, r: 6587541, label: 'El Salvador' },
        { x: '08/22/2020 11:40:00', y: 69.22, r: 2754430, label: 'Peru' },
        { x: '08/22/2020 11:15:00', y: 74.06, r: 2501738, label: 'Venezuela' },
        { x: '08/22/2020 11:20:00', y: 67.63, r: 8833634, label: 'Dominican Republic' },
        { x: '08/22/2020 11:25:00', y: 67.43, r: 272945, label: 'Belize' },
        { x: '08/22/2020 11:10:00', y: 71.43, r: 4231077, label: 'Colombia' },
        { x: '08/22/2020 11:10:00', y: 71.41, r: 78410118, label: 'Brazil' },
        { x: '08/22/2020 11:15:00', y: 77.43, r: 89302754, label: 'United States' },
      ],
    },
  ],
};

export const genderAgeData = {
  categories: [
    '100 ~',
    '90 ~ 99',
    '80 ~ 89',
    '70 ~ 79',
    '60 ~ 69',
    '50 ~ 59',
    '40 ~ 49',
    '30 ~ 39',
    '20 ~ 29',
    '10 ~ 19',
    '0 ~ 9',
  ],
  series: [
    {
      name: 'Male',
      data: [383, 3869, 39590, 136673, 248265, 419886, 451052, 391113, 352632, 296612, 236243],
    },
    {
      name: 'Female',
      data: [1255, 12846, 83976, 180790, 263033, 412847, 435981, 374321, 317092, 272438, 223251],
    },
  ],
};

export const browserUsageDataWithNull = {
  categories: ['Browser'],
  series: [
    {
      name: 'Chrome',
      data: 46.02,
    },
    {
      name: 'IE',
      data: null,
    },
    {
      name: 'Firefox',
      data: 17.71,
    },
    {
      name: 'Safari',
      data: 5.45,
    },
    {
      name: 'Opera',
      data: 3.1,
    },
    {
      name: 'Etc',
      data: 7.25,
    },
  ],
};

export const browserUsageData = {
  categories: ['Browser'],
  series: [
    {
      name: 'Chrome',
      data: 46.02,
    },
    {
      name: 'IE',
      data: 20.47,
    },
    {
      name: 'Firefox',
      data: 17.71,
    },
    {
      name: 'Safari',
      data: 5.45,
    },
    {
      name: 'Opera',
      data: 3.1,
    },
    {
      name: 'Etc',
      data: 7.25,
    },
  ],
};

export const budgetDataForBoxPlotWithNull = {
  categories: ['Budget', 'Income', 'Expenses', 'Debt'],
  series: [
    {
      name: '2020',
      data: [
        [1000, 2500, 3714, 5500, 7000],
        null,
        [3000, 4000, 4714, 6000, 7000],
        [1000, 2250, 3142, 4750, 6000],
      ],
      outliers: null,
    },
    {
      name: '2021',
      data: [
        null,
        [3000, 5750, 7571, 8250, 9000],
        [5000, 8000, 8714, 9000, 10000],
        [7000, 9250, 10142, 11750, 12000],
      ],
    },
  ],
};

export const budgetDataForBoxPlot = {
  categories: ['Budget', 'Income', 'Expenses', 'Debt'],
  series: [
    {
      name: '2020',
      data: [
        [1000, 2500, 3714, 5500, 7000],
        [1000, 2750, 4571, 5250, 8000],
        [3000, 4000, 4714, 6000, 7000],
        [1000, 2250, 3142, 4750, 6000],
      ],
      outliers: [
        [0, 14000],
        [2, 10000],
        [3, 9600],
      ],
    },
    {
      name: '2021',
      data: [
        [2000, 4500, 6714, 11500, 13000],
        [3000, 5750, 7571, 8250, 9000],
        [5000, 8000, 8714, 9000, 10000],
        [7000, 9250, 10142, 11750, 12000],
      ],
      outliers: [[1, 14000]],
    },
  ],
};

export const budgetDataForBullet = {
  series: [
    {
      name: 'Budget',
      data: 25,
      markers: [28, 2, 15],
      ranges: [
        [-1, 10],
        [10, 20],
        [20, 30],
      ],
    },
    {
      name: 'Income',
      data: 11,
      markers: [20],
      ranges: [
        [0, 8],
        [8, 15],
      ],
    },
    {
      name: 'Expenses',
      data: 30,
      markers: [25],
      ranges: [
        [0, 10],
        [10, 19],
        [19, 28],
      ],
    },
    {
      name: 'Dept',
      data: 23,
      markers: [],
      ranges: [
        [19, 25],
        [13, 19],
        [0, 13],
      ],
    },
  ],
};

export const budgetDataForBulletWithNull = {
  series: [
    {
      name: 'Budget',
      data: null,
      markers: [28, 15],
      ranges: [[-1, 5], [5, 10], [10, 15], [15, 20], [20, 25], null],
    },
    {
      name: 'Income',
      data: 0,
      ranges: [[0, 10]],
    },
    {
      name: 'Expenses',
      data: 30,
      markers: [0],
      ranges: [
        [-2, 10],
        [10, 19],
        [19, 28],
      ],
    },
    {
      name: 'Dept',
      data: 23,
      markers: [],
      ranges: [
        [19, 25],
        [13, 19],
        [0, 13],
      ],
    },
  ],
};

export const budgetDataForBulletWithNegative = {
  series: [
    {
      name: 'Budget',
      data: -25,
      markers: [-28, -2, -15],
      ranges: [
        [-10, 10],
        [-10, -20],
        [-20, -30],
      ],
    },
    {
      name: 'Expenses',
      data: 30,
      markers: [25],
      ranges: [
        [0, 10],
        [10, 19],
        [19, 28],
      ],
    },
  ],
};

export const efficiencyAndExpensesData = {
  series: {
    scatter: [
      {
        name: 'Efficiency',
        data: [
          { x: 10, y: 20 },
          { x: 14, y: 30 },
          { x: 18, y: 10 },
          { x: 20, y: 30 },
          { x: 22, y: 50 },
          { x: 24, y: 15 },
          { x: 25, y: 25 },
          { x: 26, y: 55 },
          { x: 28, y: 45 },
          { x: 30, y: 35 },
          { x: 34, y: 55 },
          { x: 36, y: 35 },
          { x: 37, y: 55 },
          { x: 38, y: 40 },
          { x: 40, y: 50 },
          { x: 42, y: 50 },
          { x: 46, y: 40 },
          { x: 47, y: 34 },
          { x: 48, y: 25 },
          { x: 50, y: 29 },
          { x: 54, y: 15 },
          { x: 58, y: 30 },
          { x: 62, y: 40 },
          { x: 64, y: 50 },
          { x: 66, y: 20 },
          { x: 65, y: 25 },
          { x: 70, y: 65 },
          { x: 71, y: 70 },
          { x: 73, y: 55 },
          { x: 74, y: 71 },
          { x: 78, y: 58 },
          { x: 82, y: 73 },
          { x: 86, y: 80 },
          { x: 93, y: 95 },
        ],
      },
    ],
    line: [
      {
        name: 'Expenses',
        data: [
          { x: 5, y: 5 },
          { x: 30, y: 50 },
          { x: 55, y: 25 },
          { x: 90, y: 90 },
        ],
      },
    ],
  },
};

export const energyUsageData = {
  categories: [
    '2020.01',
    '2020.02',
    '2020.03',
    '2020.04',
    '2020.05',
    '2020.06',
    '2020.07',
    '2020.08',
    '2020.09',
    '2020.10',
    '2020.11',
    '2020.12',
    '2021.01',
    '2021.02',
    '2021.03',
    '2021.04',
    '2021.05',
    '2021.06',
    '2021.07',
    '2021.08',
    '2021.09',
    '2021.10',
    '2021.11',
    '2021.12',
  ],
  series: {
    area: [
      {
        name: 'Effective Load',
        data: [
          150,
          130,
          100,
          125,
          128,
          110,
          134,
          162,
          120,
          90,
          98,
          143,
          142,
          124,
          113,
          129,
          118,
          120,
          145,
          172,
          110,
          70,
          68,
          103,
        ],
      },
    ],
    line: [
      {
        name: 'Power Usage',
        data: [
          72,
          80,
          110,
          107,
          126,
          134,
          148,
          152,
          130,
          120,
          114,
          127,
          90,
          72,
          130,
          117,
          129,
          137,
          134,
          160,
          121,
          110,
          114,
          117,
        ],
      },
    ],
  },
};

export const energyUsageStackData = {
  categories: [
    '2020.01',
    '2020.02',
    '2020.03',
    '2020.04',
    '2020.05',
    '2020.06',
    '2020.07',
    '2020.08',
    '2020.09',
    '2020.10',
    '2020.11',
    '2020.12',
    '2021.01',
    '2021.02',
    '2021.03',
    '2021.04',
    '2021.05',
    '2021.06',
    '2021.07',
    '2021.08',
    '2021.09',
    '2021.10',
    '2021.11',
    '2021.12',
  ],
  series: {
    area: [
      {
        name: 'Effective Load',
        data: [
          150,
          130,
          100,
          125,
          128,
          110,
          134,
          162,
          120,
          90,
          98,
          143,
          142,
          124,
          113,
          129,
          118,
          120,
          145,
          172,
          110,
          70,
          68,
          103,
        ],
      },
      {
        name: 'Capacity Credit',
        data: [
          250,
          230,
          200,
          225,
          228,
          210,
          234,
          262,
          220,
          120,
          128,
          243,
          242,
          224,
          213,
          229,
          218,
          220,
          245,
          272,
          210,
          20,
          28,
          203,
        ],
      },
    ],
    line: [
      {
        name: 'Power Usage',
        data: [
          172,
          180,
          210,
          207,
          226,
          234,
          248,
          252,
          230,
          220,
          214,
          227,
          190,
          172,
          230,
          217,
          349,
          347,
          234,
          360,
          321,
          210,
          114,
          317,
        ],
      },
    ],
  },
};

export const usedDiskSpaceData = {
  series: [
    {
      label: 'Documents',
      children: [
        {
          label: 'docs',
          children: [
            {
              label: 'pages',
              data: 1.3,
            },
            {
              label: 'keynote',
              data: 2.5,
            },
            {
              label: 'numbers',
              data: 1.2,
            },
          ],
        },
        {
          label: 'photos',
          data: 5.5,
        },
        {
          label: 'videos',
          data: 20.7,
        },
      ],
    },
    {
      label: 'Downloads',
      children: [
        {
          label: 'recent',
          data: 5.3,
        },
        {
          label: '2020',
          data: 10.1,
        },
        {
          label: '2019',
          data: 8.2,
        },
      ],
    },
    {
      label: 'Application',
      data: 16.4,
    },
    {
      label: 'Desktop',
      data: 4.5,
    },
  ],
};

export const usedDiskSpaceDataWithNull = {
  series: [
    {
      label: 'Documents',
      children: [
        {
          label: 'docs',
          children: [
            {
              label: 'pages',
              data: null,
            },
            {
              label: 'keynote',
              data: 2.5,
            },
            {
              label: 'numbers',
              data: 1.2,
            },
          ],
        },
        {
          label: 'photos',
          data: 5.5,
        },
        {
          label: 'videos',
          data: 20.7,
        },
      ],
    },
    {
      label: 'Downloads',
      children: [
        {
          label: 'recent',
          data: 5.3,
        },
        {
          label: '2020',
          data: 10.1,
        },
        {
          label: '2019',
          data: 8.2,
        },
      ],
    },
    {
      label: 'Application',
      data: 16.4,
    },
    {
      label: 'Desktop',
      data: null,
    },
  ],
};

export const populationDensityData = {
  series: [
    {
      label: 'Asia',
      children: [
        {
          label: 'South Korea',
          data: 99909,
          colorValue: 499.81,
        },
        {
          label: 'Japan',
          data: 364485,
          colorValue: 335.61,
        },
        {
          label: 'Jordan',
          data: 88802,
          colorValue: 86.07,
        },
        {
          label: 'Iraq',
          data: 437367,
          colorValue: 81.6,
        },
      ],
    },
    {
      label: 'Europe',
      children: [
        {
          label: 'UK',
          data: 241930,
          colorValue: 262.84,
        },
        {
          label: 'France',
          data: 640427,
          colorValue: 117.83,
        },
        {
          label: 'Hungary',
          data: 89608,
          colorValue: 106.54,
        },
        {
          label: 'Portugal',
          data: 91470,
          colorValue: 115.35,
        },
      ],
    },
    {
      label: 'America',
      children: [
        {
          label: 'Panama',
          data: 74340,
          colorValue: 52.81,
        },
        {
          label: 'Honduras',
          data: 111890,
          colorValue: 75.15,
        },
        {
          label: 'Uruguay',
          data: 175015,
          colorValue: 19.6,
        },
        {
          label: 'Cuba',
          data: 109820,
          colorValue: 101.47,
        },
      ],
    },
    {
      label: 'Africa',
      children: [
        {
          label: 'Malawi',
          data: 94080,
          colorValue: 146.09,
        },
        {
          label: 'Ghana',
          data: 227533,
          colorValue: 113.13,
        },
        {
          label: 'Togo',
          data: 54385,
          colorValue: 126.28,
        },
        {
          label: 'Benin',
          data: 114305,
          colorValue: 96.61,
        },
      ],
    },
  ],
};

export const temperatureAverageData = {
  categories: ['Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
  series: {
    column: [
      {
        name: 'Seoul',
        data: [11.3, 17.0, 21.0, 24.4, 25.2, 20.4, 13.9],
      },
      {
        name: 'NewYork',
        data: [9.9, 16.0, 21.2, 24.2, 23.2, 19.4, 13.3],
      },
      {
        name: 'Sydney',
        data: [18.3, 15.2, 12.8, 11.8, 13.0, 15.2, 17.6],
      },
      {
        name: 'Moscow',
        data: [4.4, 12.2, 16.3, 18.5, 16.7, 10.9, 4.2],
      },
    ],
    line: [
      {
        name: 'Average',
        data: [11, 15.1, 17.8, 19.7, 19.5, 16.5, 12.3],
      },
    ],
  },
};

export const temperatureAverageDataForHeatmap = {
  categories: {
    x: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    y: ['Seoul', 'Seattle', 'Sydney', 'Moscow', 'Jungfrau'],
  },
  series: [
    [-3.5, -1.1, 4.0, 11.3, 17.5, 21.5, 24.9, 25.2, 20.4, 13.9, 6.6, -0.6],
    [3.8, 5.6, 7.0, 9.1, 12.4, 15.3, 17.5, 17.8, 15.0, 10.6, 6.4, 3.7],
    [22.1, 22.0, 20.9, 18.3, 15.2, 12.8, 11.8, 13.0, 15.2, 17.6, 19.4, 21.2],
    [-10.3, -9.1, -4.1, 4.4, 12.2, 16.3, 18.5, 16.7, 10.9, 4.2, -2.0, -7.5],
    [-13.2, -13.7, -13.1, -10.3, -6.1, -3.2, 0.0, -0.1, -1.8, -4.5, -9.0, -10.9],
  ],
};

export const temperatureAverageDataForHeatmapWithNull = {
  categories: {
    x: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
    y: ['Seoul', 'Seattle'],
  },
  series: [
    [-3.5, -1.1, null, 11.3, null, 21.5],
    [null, 17.8, null, 10.6, 6.4, 3.7],
  ],
};

export const contributionsData = {
  categories: {
    x: [
      '01/01/2020',
      '02/01/2020',
      '03/01/2020',
      '04/01/2020',
      '05/01/2020',
      '06/01/2020',
      '07/01/2020',
      '08/01/2020',
      '09/01/2020',
      '10/01/2020',
      '11/01/2020',
      '12/01/2020',
    ],
    y: ['MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT', 'SUN'],
  },
  series: [
    [1, 0, 3, 4, 11, 2, 10, 10, 3, 12, 4, 5],
    [10, 20, 21, 1, 4, 3, 10, 10, 8, 2, 3, 15],
    [9, 2, 3, 4, 5, 2, 10, 8, 3, 1, 14, 3],
    [1, 7, 5, 8, 3, 3, 3, 10, 13, 6, 9, 2],
    [4, 4, 9, 4, 5, 2, 8, 0, 3, 1, 4, 9],
    [10, 9, 8, 4, 8, 11, 0, 9, 13, 9, 3, 8],
    [8, 2, 11, 14, 5, 12, 19, 10, 3, 13, 4, 5],
  ],
};

export const groupedBrowserUsageDataWithNull = {
  categories: ['A', 'B'],
  series: [
    {
      name: 'browsers',
      data: [
        {
          name: 'Chrome',
          data: 50,
        },
        {
          name: 'Safari',
          data: 20,
        },
        {
          name: 'IE',
          data: null,
        },
        {
          name: 'Firefox',
          data: 10,
        },
        {
          name: 'Opera',
          data: 3,
        },
        {
          name: 'Etc',
          data: 7,
        },
      ],
    },
    {
      name: 'versions',
      data: [
        {
          name: 'Chrome 64',
          parentName: 'Chrome',
          data: 40,
        },
        {
          name: 'Chrome 63',
          parentName: 'Chrome',
          data: 10,
        },
        {
          name: 'Safari 13',
          parentName: 'Safari',
          data: 15,
        },
        {
          name: 'Safari 12',
          parentName: 'Safari',
          data: 0,
        },
        {
          name: 'IE 11',
          parentName: 'IE',
          data: null,
        },
        {
          name: 'IE 10',
          parentName: 'IE',
          data: null,
        },
        {
          name: 'IE 9',
          parentName: 'IE',
          data: null,
        },
        {
          name: 'IE 8',
          parentName: 'IE',
          data: null,
        },
        {
          name: 'Firefox 13',
          parentName: 'Firefox',
          data: 8,
        },
        {
          name: 'Firefox 12',
          parentName: 'Firefox',
          data: 2,
        },
        {
          name: 'Opera 15',
          parentName: 'Opera',
          data: 2,
        },
        {
          name: 'Opera 12',
          parentName: 'Opera',
          data: 1,
        },
        {
          name: 'Etc 1',
          parentName: 'Etc',
          data: 3,
        },
        {
          name: 'Etc 2',
          parentName: 'Etc',
          data: 2,
        },
        {
          name: 'Etc 3',
          parentName: 'Etc',
          data: 1,
        },
        {
          name: 'Etc 4',
          parentName: 'Etc',
          data: 1,
        },
      ],
    },
  ],
};

export const groupedBrowserUsageData = {
  categories: ['A', 'B'],
  series: [
    {
      name: 'browsers',
      data: [
        {
          name: 'Chrome',
          data: 50,
        },
        {
          name: 'Safari',
          data: 20,
        },
        {
          name: 'IE',
          data: 10,
        },
        {
          name: 'Firefox',
          data: 10,
        },
        {
          name: 'Opera',
          data: 3,
        },
        {
          name: 'Etc',
          data: 7,
        },
      ],
    },
    {
      name: 'versions',
      data: [
        {
          name: 'Chrome 64',
          parentName: 'Chrome',
          data: 40,
        },
        {
          name: 'Chrome 63',
          parentName: 'Chrome',
          data: 10,
        },
        {
          name: 'Safari 13',
          parentName: 'Safari',
          data: 15,
        },
        {
          name: 'Safari 12',
          parentName: 'Safari',
          data: 5,
        },
        {
          name: 'IE 11',
          parentName: 'IE',
          data: 4,
        },
        {
          name: 'IE 10',
          parentName: 'IE',
          data: 3,
        },
        {
          name: 'IE 9',
          parentName: 'IE',
          data: 2,
        },
        {
          name: 'IE 8',
          parentName: 'IE',
          data: 1,
        },
        {
          name: 'Firefox 13',
          parentName: 'Firefox',
          data: 8,
        },
        {
          name: 'Firefox 12',
          parentName: 'Firefox',
          data: 2,
        },
        {
          name: 'Opera 15',
          parentName: 'Opera',
          data: 2,
        },
        {
          name: 'Opera 12',
          parentName: 'Opera',
          data: 1,
        },
        {
          name: 'Etc 1',
          parentName: 'Etc',
          data: 3,
        },
        {
          name: 'Etc 2',
          parentName: 'Etc',
          data: 2,
        },
        {
          name: 'Etc 3',
          parentName: 'Etc',
          data: 1,
        },
        {
          name: 'Etc 4',
          parentName: 'Etc',
          data: 1,
        },
      ],
    },
  ],
};

export const browserUsageData2 = {
  series: [
    {
      name: 'browsers',
      data: [
        {
          name: 'Chrome',
          data: 50,
        },
        {
          name: 'Safari',
          data: 20,
        },
        {
          name: 'IE',
          data: 10,
        },
        {
          name: 'Firefox',
          data: 10,
        },
        {
          name: 'Opera',
          data: 3,
        },
        {
          name: 'Etc',
          data: 7,
        },
      ],
    },
    {
      name: 'versions',
      data: [
        {
          name: 'Chrome 64',
          data: 40,
        },
        {
          name: 'Chrome 63',
          data: 10,
        },
        {
          name: 'Safari 13',
          data: 15,
        },
        {
          name: 'Safari 12',
          data: 5,
        },
        {
          name: 'IE 11',
          data: 4,
        },
        {
          name: 'IE 10',
          data: 3,
        },
        {
          name: 'IE 9',
          data: 2,
        },
        {
          name: 'IE 8',
          data: 1,
        },
        {
          name: 'Firefox 13',
          data: 8,
        },
        {
          name: 'Firefox 12',
          data: 2,
        },
        {
          name: 'Opera 15',
          data: 2,
        },
        {
          name: 'Opera 12',
          data: 1,
        },
        {
          name: 'Etc - 2020',
          data: 7,
        },
      ],
    },
  ],
};

export const browserUsageData2WithNull = {
  series: [
    {
      name: 'browsers',
      data: [
        {
          name: 'Chrome',
          data: 50,
        },
        {
          name: 'Safari',
          data: 20,
        },
        {
          name: 'IE',
          data: null,
        },
        {
          name: 'Firefox',
          data: null,
        },
        {
          name: 'Opera',
          data: 3,
        },
        {
          name: 'Etc',
          data: 7,
        },
      ],
    },
    {
      name: 'versions',
      data: [
        {
          name: 'Chrome 64',
          data: 40,
        },
        {
          name: 'Chrome 63',
          data: 10,
        },
        {
          name: 'Safari 13',
          data: 15,
        },
        {
          name: 'Safari 12',
          data: 0,
        },
        {
          name: 'IE 11',
          data: null,
        },
        {
          name: 'IE 10',
          data: null,
        },
        {
          name: 'IE 9',
          data: null,
        },
        {
          name: 'IE 8',
          data: null,
        },
        {
          name: 'Firefox 13',
          data: 8,
        },
        {
          name: 'Firefox 12',
          data: 2,
        },
        {
          name: 'Opera 15',
          data: 2,
        },
        {
          name: 'Opera 12',
          data: 1,
        },
        {
          name: 'Etc - 2020',
          data: 7,
        },
      ],
    },
  ],
};

export const simpleBudgetData = {
  categories: ['May', 'Jun'],
  series: [
    {
      name: 'Budget',
      data: [4000, 5000],
    },
    {
      name: 'Income',
      data: [7000, 8000],
    },
    {
      name: 'Expenses',
      data: [-5000, -4000],
    },
    {
      name: 'Debt',
      data: [-3000, -6000],
    },
  ],
};

export const olympicMedalData = {
  categories: ['Korea', 'United States', 'Germany', 'Canada', 'Austria'],
  series: [
    {
      name: 'Gold medals',
      data: [132, 105, 92, 73, 64],
    },
    {
      name: 'Silver medals',
      data: [125, 110, 86, 64, 81],
    },
    {
      name: 'Bronze medals',
      data: [111, 90, 60, 62, 87],
    },
  ],
};

export const olympicMedalDataWithNull = {
  categories: ['Korea', 'United States', 'Germany', 'Canada', 'Austria'],
  series: [
    {
      name: 'Gold medals',
      data: [132, 105, 92, 73, 64],
    },
    {
      name: 'Silver medals',
      data: [125, null, 86, 64, 81],
    },
    {
      name: 'Bronze medals',
      data: [111, 90, 60, null, 87],
    },
  ],
};

export const gaugeData = {
  series: [
    {
      name: 'Speed',
      data: [80],
    },
  ],
};

export const categoryGaugeData = {
  categories: ['Apple', 'Watermelon', 'Blueberry', 'Grape', 'Orange'],
  series: [
    {
      name: 'Fruit',
      data: ['Orange'],
    },
  ],
};

export const concurrentUsers = {
  series: [
    {
      name: 'Today',
      data: [
        ['2021-03-17T00:00:00+09:00', '32238'],
        ['2021-03-17T00:01:00+09:00', '16069'],
        ['2021-03-17T00:02:00+09:00', '16153'],
        ['2021-03-17T00:03:00+09:00', '16095'],
        ['2021-03-17T00:04:00+09:00', '16040'],
        ['2021-03-17T00:05:00+09:00', '16007'],
        ['2021-03-17T00:06:00+09:00', '16195'],
        ['2021-03-17T00:07:00+09:00', '16040'],
        ['2021-03-17T00:08:00+09:00', '16242'],
        ['2021-03-17T00:09:00+09:00', '16007'],
        ['2021-03-17T00:10:00+09:00', '16148'],
        ['2021-03-17T00:11:00+09:00', '16166'],
        ['2021-03-17T00:12:00+09:00', '16002'],
        ['2021-03-17T00:13:00+09:00', '16025'],
        ['2021-03-17T00:14:00+09:00', '16132'],
        ['2021-03-17T00:15:00+09:00', '16035'],
        ['2021-03-17T00:16:00+09:00', '16018'],
        ['2021-03-17T00:17:00+09:00', '15880'],
        ['2021-03-17T00:18:00+09:00', '16102'],
        ['2021-03-17T00:19:00+09:00', '15956'],
        ['2021-03-17T00:20:00+09:00', '15886'],
        ['2021-03-17T00:21:00+09:00', '16092'],
        ['2021-03-17T00:22:00+09:00', '16040'],
        ['2021-03-17T00:23:00+09:00', '15816'],
        ['2021-03-17T00:24:00+09:00', '15894'],
        ['2021-03-17T00:25:00+09:00', '15896'],
        ['2021-03-17T00:26:00+09:00', '15858'],
        ['2021-03-17T00:27:00+09:00', '15967'],
        ['2021-03-17T00:28:00+09:00', '15822'],
        ['2021-03-17T00:29:00+09:00', '15831'],
        ['2021-03-17T00:30:00+09:00', '15847'],
        ['2021-03-17T00:31:00+09:00', '16014'],
        ['2021-03-17T00:32:00+09:00', '15937'],
        ['2021-03-17T00:33:00+09:00', '15969'],
        ['2021-03-17T00:34:00+09:00', '15774'],
        ['2021-03-17T00:35:00+09:00', '15944'],
        ['2021-03-17T00:36:00+09:00', '15757'],
        ['2021-03-17T00:37:00+09:00', '15880'],
        ['2021-03-17T00:38:00+09:00', '15731'],
        ['2021-03-17T00:39:00+09:00', '15817'],
        ['2021-03-17T00:40:00+09:00', '15758'],
        ['2021-03-17T00:41:00+09:00', '15602'],
        ['2021-03-17T00:42:00+09:00', '15804'],
        ['2021-03-17T00:43:00+09:00', '15694'],
        ['2021-03-17T00:44:00+09:00', '15726'],
        ['2021-03-17T00:45:00+09:00', '15687'],
        ['2021-03-17T00:46:00+09:00', '15759'],
        ['2021-03-17T00:47:00+09:00', '15737'],
        ['2021-03-17T00:48:00+09:00', '15671'],
        ['2021-03-17T00:49:00+09:00', '15705'],
        ['2021-03-17T00:50:00+09:00', '15705'],
        ['2021-03-17T00:51:00+09:00', '15872'],
        ['2021-03-17T00:52:00+09:00', '15842'],
        ['2021-03-17T00:53:00+09:00', '15772'],
        ['2021-03-17T00:54:00+09:00', '15570'],
        ['2021-03-17T00:55:00+09:00', '15709'],
        ['2021-03-17T00:56:00+09:00', '15530'],
        ['2021-03-17T00:57:00+09:00', '15513'],
        ['2021-03-17T00:58:00+09:00', '15615'],
        ['2021-03-17T00:59:00+09:00', '15510'],
        ['2021-03-17T01:00:00+09:00', '15641'],
        ['2021-03-17T01:01:00+09:00', '15685'],
        ['2021-03-17T01:02:00+09:00', '15660'],
        ['2021-03-17T01:03:00+09:00', '15733'],
        ['2021-03-17T01:04:00+09:00', '15675'],
        ['2021-03-17T01:05:00+09:00', '15484'],
        ['2021-03-17T01:06:00+09:00', '15701'],
        ['2021-03-17T01:07:00+09:00', '15682'],
        ['2021-03-17T01:08:00+09:00', '15417'],
        ['2021-03-17T01:09:00+09:00', '15466'],
        ['2021-03-17T01:10:00+09:00', '15555'],
        ['2021-03-17T01:11:00+09:00', '15475'],
        ['2021-03-17T01:12:00+09:00', '15439'],
        ['2021-03-17T01:13:00+09:00', '15501'],
        ['2021-03-17T01:14:00+09:00', '15456'],
        ['2021-03-17T01:15:00+09:00', '15339'],
        ['2021-03-17T01:16:00+09:00', '15632'],
        ['2021-03-17T01:17:00+09:00', '15396'],
        ['2021-03-17T01:18:00+09:00', '15392'],
        ['2021-03-17T01:19:00+09:00', '15370'],
        ['2021-03-17T01:20:00+09:00', '15329'],
        ['2021-03-17T01:21:00+09:00', '15339'],
        ['2021-03-17T01:22:00+09:00', '15472'],
        ['2021-03-17T01:23:00+09:00', '15532'],
        ['2021-03-17T01:24:00+09:00', '15477'],
        ['2021-03-17T01:25:00+09:00', '15499'],
        ['2021-03-17T01:26:00+09:00', '15327'],
        ['2021-03-17T01:27:00+09:00', '15550'],
        ['2021-03-17T01:28:00+09:00', '15379'],
        ['2021-03-17T01:29:00+09:00', '15377'],
        ['2021-03-17T01:30:00+09:00', '15678'],
        ['2021-03-17T01:31:00+09:00', '15525'],
        ['2021-03-17T01:32:00+09:00', '15607'],
        ['2021-03-17T01:33:00+09:00', '15524'],
        ['2021-03-17T01:34:00+09:00', '15479'],
        ['2021-03-17T01:35:00+09:00', '15617'],
        ['2021-03-17T01:36:00+09:00', '15489'],
        ['2021-03-17T01:37:00+09:00', '15493'],
        ['2021-03-17T01:38:00+09:00', '15629'],
        ['2021-03-17T01:39:00+09:00', '15440'],
        ['2021-03-17T01:40:00+09:00', '15362'],
        ['2021-03-17T01:41:00+09:00', '15570'],
        ['2021-03-17T01:42:00+09:00', '15597'],
        ['2021-03-17T01:43:00+09:00', '15354'],
        ['2021-03-17T01:44:00+09:00', '15466'],
        ['2021-03-17T01:45:00+09:00', '15561'],
        ['2021-03-17T01:46:00+09:00', '15319'],
        ['2021-03-17T01:47:00+09:00', '15487'],
        ['2021-03-17T01:48:00+09:00', '15353'],
        ['2021-03-17T01:49:00+09:00', '15522'],
        ['2021-03-17T01:50:00+09:00', '15516'],
        ['2021-03-17T01:51:00+09:00', '15361'],
        ['2021-03-17T01:52:00+09:00', '15343'],
        ['2021-03-17T01:53:00+09:00', '15416'],
        ['2021-03-17T01:54:00+09:00', '15548'],
        ['2021-03-17T01:55:00+09:00', '15533'],
        ['2021-03-17T01:56:00+09:00', '15417'],
        ['2021-03-17T01:57:00+09:00', '15633'],
        ['2021-03-17T01:58:00+09:00', '15605'],
        ['2021-03-17T01:59:00+09:00', '15550'],
        ['2021-03-17T02:00:00+09:00', '15591'],
        ['2021-03-17T02:01:00+09:00', '15445'],
        ['2021-03-17T02:02:00+09:00', '15358'],
        ['2021-03-17T02:03:00+09:00', '15477'],
        ['2021-03-17T02:04:00+09:00', '15554'],
        ['2021-03-17T02:05:00+09:00', '15530'],
        ['2021-03-17T02:06:00+09:00', '15543'],
        ['2021-03-17T02:07:00+09:00', '15469'],
        ['2021-03-17T02:08:00+09:00', '15545'],
        ['2021-03-17T02:09:00+09:00', '15473'],
        ['2021-03-17T02:10:00+09:00', '15323'],
        ['2021-03-17T02:11:00+09:00', '15328'],
        ['2021-03-17T02:12:00+09:00', '15490'],
        ['2021-03-17T02:13:00+09:00', '15384'],
        ['2021-03-17T02:14:00+09:00', '15475'],
        ['2021-03-17T02:15:00+09:00', '15465'],
        ['2021-03-17T02:16:00+09:00', '15515'],
        ['2021-03-17T02:17:00+09:00', '15550'],
        ['2021-03-17T02:18:00+09:00', '15564'],
        ['2021-03-17T02:19:00+09:00', '15383'],
        ['2021-03-17T02:20:00+09:00', '15647'],
        ['2021-03-17T02:21:00+09:00', '15363'],
        ['2021-03-17T02:22:00+09:00', '15571'],
        ['2021-03-17T02:23:00+09:00', '15658'],
        ['2021-03-17T02:24:00+09:00', '15684'],
        ['2021-03-17T02:25:00+09:00', '15472'],
        ['2021-03-17T02:26:00+09:00', '15533'],
        ['2021-03-17T02:27:00+09:00', '15625'],
        ['2021-03-17T02:28:00+09:00', '15619'],
        ['2021-03-17T02:29:00+09:00', '15486'],
        ['2021-03-17T02:30:00+09:00', '15427'],
        ['2021-03-17T02:31:00+09:00', '15677'],
        ['2021-03-17T02:32:00+09:00', '15519'],
        ['2021-03-17T02:33:00+09:00', '15457'],
        ['2021-03-17T02:34:00+09:00', '15574'],
        ['2021-03-17T02:35:00+09:00', '15402'],
        ['2021-03-17T02:36:00+09:00', '15532'],
        ['2021-03-17T02:37:00+09:00', '15425'],
        ['2021-03-17T02:38:00+09:00', '15477'],
        ['2021-03-17T02:39:00+09:00', '15483'],
        ['2021-03-17T02:40:00+09:00', '15554'],
        ['2021-03-17T02:41:00+09:00', '15342'],
        ['2021-03-17T02:42:00+09:00', '15308'],
        ['2021-03-17T02:43:00+09:00', '15445'],
        ['2021-03-17T02:44:00+09:00', '15252'],
        ['2021-03-17T02:45:00+09:00', '15285'],
        ['2021-03-17T02:46:00+09:00', '15235'],
        ['2021-03-17T02:47:00+09:00', '15263'],
        ['2021-03-17T02:48:00+09:00', '15258'],
        ['2021-03-17T02:49:00+09:00', '15282'],
        ['2021-03-17T02:50:00+09:00', '15495'],
        ['2021-03-17T02:51:00+09:00', '15184'],
        ['2021-03-17T02:52:00+09:00', '15475'],
        ['2021-03-17T02:53:00+09:00', '15359'],
        ['2021-03-17T02:54:00+09:00', '15404'],
        ['2021-03-17T02:55:00+09:00', '15274'],
        ['2021-03-17T02:56:00+09:00', '15328'],
        ['2021-03-17T02:57:00+09:00', '15224'],
        ['2021-03-17T02:58:00+09:00', '15280'],
        ['2021-03-17T02:59:00+09:00', '15366'],
        ['2021-03-17T03:00:00+09:00', '15368'],
        ['2021-03-17T03:01:00+09:00', '15281'],
        ['2021-03-17T03:02:00+09:00', '15366'],
        ['2021-03-17T03:03:00+09:00', '15292'],
        ['2021-03-17T03:04:00+09:00', '15123'],
        ['2021-03-17T03:05:00+09:00', '15220'],
        ['2021-03-17T03:06:00+09:00', '15308'],
        ['2021-03-17T03:07:00+09:00', '15282'],
        ['2021-03-17T03:08:00+09:00', '15195'],
        ['2021-03-17T03:09:00+09:00', '15279'],
        ['2021-03-17T03:10:00+09:00', '15263'],
        ['2021-03-17T03:11:00+09:00', '15276'],
        ['2021-03-17T03:12:00+09:00', '15224'],
        ['2021-03-17T03:13:00+09:00', '15211'],
        ['2021-03-17T03:14:00+09:00', '15340'],
        ['2021-03-17T03:15:00+09:00', '15236'],
        ['2021-03-17T03:16:00+09:00', '15254'],
        ['2021-03-17T03:17:00+09:00', '15094'],
        ['2021-03-17T03:18:00+09:00', '15320'],
        ['2021-03-17T03:19:00+09:00', '15112'],
        ['2021-03-17T03:20:00+09:00', '15340'],
        ['2021-03-17T03:21:00+09:00', '15112'],
        ['2021-03-17T03:22:00+09:00', '15322'],
        ['2021-03-17T03:23:00+09:00', '15221'],
        ['2021-03-17T03:24:00+09:00', '15147'],
        ['2021-03-17T03:25:00+09:00', '15313'],
        ['2021-03-17T03:26:00+09:00', '15039'],
        ['2021-03-17T03:27:00+09:00', '15111'],
        ['2021-03-17T03:28:00+09:00', '15103'],
        ['2021-03-17T03:29:00+09:00', '15028'],
        ['2021-03-17T03:30:00+09:00', '15105'],
        ['2021-03-17T03:31:00+09:00', '15175'],
        ['2021-03-17T03:32:00+09:00', '15134'],
        ['2021-03-17T03:33:00+09:00', '15196'],
        ['2021-03-17T03:34:00+09:00', '15182'],
        ['2021-03-17T03:35:00+09:00', '15066'],
        ['2021-03-17T03:36:00+09:00', '15264'],
        ['2021-03-17T03:37:00+09:00', '15044'],
        ['2021-03-17T03:38:00+09:00', '15052'],
        ['2021-03-17T03:39:00+09:00', '15027'],
        ['2021-03-17T03:40:00+09:00', '14994'],
        ['2021-03-17T03:41:00+09:00', '15023'],
        ['2021-03-17T03:42:00+09:00', '15047'],
        ['2021-03-17T03:43:00+09:00', '14977'],
        ['2021-03-17T03:44:00+09:00', '14924'],
        ['2021-03-17T03:45:00+09:00', '15205'],
        ['2021-03-17T03:46:00+09:00', '14928'],
        ['2021-03-17T03:47:00+09:00', '14943'],
        ['2021-03-17T03:48:00+09:00', '15103'],
        ['2021-03-17T03:49:00+09:00', '15066'],
        ['2021-03-17T03:50:00+09:00', '14948'],
        ['2021-03-17T03:51:00+09:00', '14904'],
        ['2021-03-17T03:52:00+09:00', '15049'],
        ['2021-03-17T03:53:00+09:00', '14918'],
        ['2021-03-17T03:54:00+09:00', '14838'],
        ['2021-03-17T03:55:00+09:00', '14968'],
        ['2021-03-17T03:56:00+09:00', '15003'],
        ['2021-03-17T03:57:00+09:00', '15026'],
        ['2021-03-17T03:58:00+09:00', '14966'],
        ['2021-03-17T03:59:00+09:00', '15000'],
        ['2021-03-17T04:00:00+09:00', '15003'],
        ['2021-03-17T04:01:00+09:00', '14889'],
        ['2021-03-17T04:02:00+09:00', '14919'],
        ['2021-03-17T04:03:00+09:00', '14643'],
        ['2021-03-17T04:04:00+09:00', '14943'],
        ['2021-03-17T04:05:00+09:00', '14626'],
        ['2021-03-17T04:06:00+09:00', '14881'],
        ['2021-03-17T04:07:00+09:00', '14860'],
        ['2021-03-17T04:08:00+09:00', '14773'],
        ['2021-03-17T04:09:00+09:00', '14746'],
        ['2021-03-17T04:10:00+09:00', '14586'],
        ['2021-03-17T04:11:00+09:00', '14621'],
        ['2021-03-17T04:12:00+09:00', '14751'],
        ['2021-03-17T04:13:00+09:00', '14491'],
        ['2021-03-17T04:14:00+09:00', '14694'],
        ['2021-03-17T04:15:00+09:00', '14655'],
        ['2021-03-17T04:16:00+09:00', '14462'],
        ['2021-03-17T04:17:00+09:00', '14590'],
        ['2021-03-17T04:18:00+09:00', '14578'],
        ['2021-03-17T04:19:00+09:00', '14405'],
        ['2021-03-17T04:20:00+09:00', '14552'],
        ['2021-03-17T04:21:00+09:00', '14469'],
        ['2021-03-17T04:22:00+09:00', '14420'],
        ['2021-03-17T04:23:00+09:00', '14547'],
        ['2021-03-17T04:24:00+09:00', '14460'],
        ['2021-03-17T04:25:00+09:00', '14537'],
        ['2021-03-17T04:26:00+09:00', '14338'],
        ['2021-03-17T04:27:00+09:00', '14279'],
        ['2021-03-17T04:28:00+09:00', '14256'],
        ['2021-03-17T04:29:00+09:00', '14292'],
        ['2021-03-17T04:30:00+09:00', '14446'],
        ['2021-03-17T04:31:00+09:00', '14155'],
        ['2021-03-17T04:32:00+09:00', '14432'],
        ['2021-03-17T04:33:00+09:00', '14259'],
        ['2021-03-17T04:34:00+09:00', '14358'],
        ['2021-03-17T04:35:00+09:00', '14109'],
        ['2021-03-17T04:36:00+09:00', '14135'],
        ['2021-03-17T04:37:00+09:00', '14154'],
        ['2021-03-17T04:38:00+09:00', '14156'],
        ['2021-03-17T04:39:00+09:00', '14269'],
        ['2021-03-17T04:40:00+09:00', '14290'],
        ['2021-03-17T04:41:00+09:00', '14065'],
        ['2021-03-17T04:42:00+09:00', '14066'],
        ['2021-03-17T04:43:00+09:00', '14091'],
        ['2021-03-17T04:44:00+09:00', '14054'],
        ['2021-03-17T04:45:00+09:00', '14240'],
        ['2021-03-17T04:46:00+09:00', '14174'],
        ['2021-03-17T04:47:00+09:00', '14062'],
        ['2021-03-17T04:48:00+09:00', '14012'],
        ['2021-03-17T04:49:00+09:00', '13952'],
        ['2021-03-17T04:50:00+09:00', '14174'],
        ['2021-03-17T04:51:00+09:00', '14033'],
        ['2021-03-17T04:52:00+09:00', '13869'],
        ['2021-03-17T04:53:00+09:00', '13910'],
        ['2021-03-17T04:54:00+09:00', '13943'],
        ['2021-03-17T04:55:00+09:00', '13861'],
        ['2021-03-17T04:56:00+09:00', '14019'],
        ['2021-03-17T04:57:00+09:00', '13994'],
        ['2021-03-17T04:58:00+09:00', '13735'],
        ['2021-03-17T04:59:00+09:00', '13805'],
        ['2021-03-17T05:00:00+09:00', '13785'],
        ['2021-03-17T05:01:00+09:00', '13925'],
        ['2021-03-17T05:02:00+09:00', '13668'],
        ['2021-03-17T05:03:00+09:00', '13867'],
        ['2021-03-17T05:04:00+09:00', '13609'],
        ['2021-03-17T05:05:00+09:00', '13799'],
        ['2021-03-17T05:06:00+09:00', '13755'],
        ['2021-03-17T05:07:00+09:00', '13499'],
        ['2021-03-17T05:08:00+09:00', '13537'],
        ['2021-03-17T05:09:00+09:00', '13473'],
        ['2021-03-17T05:10:00+09:00', '13587'],
        ['2021-03-17T05:11:00+09:00', '13437'],
        ['2021-03-17T05:12:00+09:00', '13521'],
        ['2021-03-17T05:13:00+09:00', '13433'],
        ['2021-03-17T05:14:00+09:00', '13627'],
        ['2021-03-17T05:15:00+09:00', '13489'],
        ['2021-03-17T05:16:00+09:00', '13402'],
        ['2021-03-17T05:17:00+09:00', '13524'],
        ['2021-03-17T05:18:00+09:00', '13538'],
        ['2021-03-17T05:19:00+09:00', '13386'],
        ['2021-03-17T05:20:00+09:00', '13500'],
        ['2021-03-17T05:21:00+09:00', '13467'],
        ['2021-03-17T05:22:00+09:00', '13381'],
        ['2021-03-17T05:23:00+09:00', '13275'],
        ['2021-03-17T05:24:00+09:00', '13367'],
        ['2021-03-17T05:25:00+09:00', '13134'],
        ['2021-03-17T05:26:00+09:00', '13305'],
        ['2021-03-17T05:27:00+09:00', '13135'],
        ['2021-03-17T05:28:00+09:00', '13104'],
        ['2021-03-17T05:29:00+09:00', '13025'],
        ['2021-03-17T05:30:00+09:00', '13150'],
        ['2021-03-17T05:31:00+09:00', '13011'],
        ['2021-03-17T05:32:00+09:00', '13126'],
        ['2021-03-17T05:33:00+09:00', '13149'],
        ['2021-03-17T05:34:00+09:00', '12939'],
        ['2021-03-17T05:35:00+09:00', '13068'],
        ['2021-03-17T05:36:00+09:00', '12736'],
        ['2021-03-17T05:37:00+09:00', '12911'],
        ['2021-03-17T05:38:00+09:00', '12912'],
        ['2021-03-17T05:39:00+09:00', '12732'],
        ['2021-03-17T05:40:00+09:00', '12636'],
        ['2021-03-17T05:41:00+09:00', '12608'],
        ['2021-03-17T05:42:00+09:00', '12626'],
        ['2021-03-17T05:43:00+09:00', '12811'],
        ['2021-03-17T05:44:00+09:00', '12705'],
        ['2021-03-17T05:45:00+09:00', '12613'],
        ['2021-03-17T05:46:00+09:00', '12617'],
        ['2021-03-17T05:47:00+09:00', '12564'],
        ['2021-03-17T05:48:00+09:00', '12599'],
        ['2021-03-17T05:49:00+09:00', '12626'],
        ['2021-03-17T05:50:00+09:00', '12537'],
        ['2021-03-17T05:51:00+09:00', '12469'],
        ['2021-03-17T05:52:00+09:00', '12416'],
        ['2021-03-17T05:53:00+09:00', '12358'],
        ['2021-03-17T05:54:00+09:00', '12196'],
        ['2021-03-17T05:55:00+09:00', '12259'],
        ['2021-03-17T05:56:00+09:00', '12083'],
        ['2021-03-17T05:57:00+09:00', '12261'],
        ['2021-03-17T05:58:00+09:00', '12099'],
        ['2021-03-17T05:59:00+09:00', '12234'],
        ['2021-03-17T06:00:00+09:00', '12028'],
        ['2021-03-17T06:01:00+09:00', '11993'],
        ['2021-03-17T06:02:00+09:00', '12009'],
        ['2021-03-17T06:03:00+09:00', '11916'],
        ['2021-03-17T06:04:00+09:00', '11983'],
        ['2021-03-17T06:05:00+09:00', '12093'],
        ['2021-03-17T06:06:00+09:00', '11854'],
        ['2021-03-17T06:07:00+09:00', '11976'],
        ['2021-03-17T06:08:00+09:00', '11792'],
        ['2021-03-17T06:09:00+09:00', '11715'],
        ['2021-03-17T06:10:00+09:00', '11742'],
        ['2021-03-17T06:11:00+09:00', '11633'],
        ['2021-03-17T06:12:00+09:00', '11829'],
        ['2021-03-17T06:13:00+09:00', '11564'],
        ['2021-03-17T06:14:00+09:00', '11832'],
        ['2021-03-17T06:15:00+09:00', '11624'],
        ['2021-03-17T06:16:00+09:00', '11512'],
        ['2021-03-17T06:17:00+09:00', '11583'],
        ['2021-03-17T06:18:00+09:00', '11628'],
        ['2021-03-17T06:19:00+09:00', '11432'],
        ['2021-03-17T06:20:00+09:00', '11513'],
        ['2021-03-17T06:21:00+09:00', '11406'],
        ['2021-03-17T06:22:00+09:00', '11489'],
        ['2021-03-17T06:23:00+09:00', '11572'],
        ['2021-03-17T06:24:00+09:00', '11447'],
        ['2021-03-17T06:25:00+09:00', '11416'],
        ['2021-03-17T06:26:00+09:00', '11510'],
        ['2021-03-17T06:27:00+09:00', '11514'],
        ['2021-03-17T06:28:00+09:00', '11481'],
        ['2021-03-17T06:29:00+09:00', '11296'],
        ['2021-03-17T06:30:00+09:00', '11467'],
        ['2021-03-17T06:31:00+09:00', '11225'],
        ['2021-03-17T06:32:00+09:00', '11165'],
        ['2021-03-17T06:33:00+09:00', '11170'],
        ['2021-03-17T06:34:00+09:00', '11311'],
        ['2021-03-17T06:35:00+09:00', '11358'],
        ['2021-03-17T06:36:00+09:00', '11374'],
        ['2021-03-17T06:37:00+09:00', '11350'],
        ['2021-03-17T06:38:00+09:00', '11254'],
        ['2021-03-17T06:39:00+09:00', '11248'],
        ['2021-03-17T06:40:00+09:00', '11088'],
        ['2021-03-17T06:41:00+09:00', '11135'],
        ['2021-03-17T06:42:00+09:00', '11156'],
        ['2021-03-17T06:43:00+09:00', '11026'],
        ['2021-03-17T06:44:00+09:00', '11124'],
        ['2021-03-17T06:45:00+09:00', '11089'],
        ['2021-03-17T06:46:00+09:00', '10972'],
        ['2021-03-17T06:47:00+09:00', '11022'],
        ['2021-03-17T06:48:00+09:00', '10945'],
        ['2021-03-17T06:49:00+09:00', '11020'],
        ['2021-03-17T06:50:00+09:00', '10871'],
        ['2021-03-17T06:51:00+09:00', '10996'],
        ['2021-03-17T06:52:00+09:00', '10942'],
        ['2021-03-17T06:53:00+09:00', '10920'],
        ['2021-03-17T06:54:00+09:00', '10965'],
        ['2021-03-17T06:55:00+09:00', '10956'],
        ['2021-03-17T06:56:00+09:00', '10742'],
        ['2021-03-17T06:57:00+09:00', '10670'],
        ['2021-03-17T06:58:00+09:00', '10715'],
        ['2021-03-17T06:59:00+09:00', '10570'],
        ['2021-03-17T07:00:00+09:00', '10618'],
        ['2021-03-17T07:01:00+09:00', '10526'],
        ['2021-03-17T07:02:00+09:00', '10507'],
        ['2021-03-17T07:03:00+09:00', '10663'],
        ['2021-03-17T07:04:00+09:00', '10523'],
        ['2021-03-17T07:05:00+09:00', '10565'],
        ['2021-03-17T07:06:00+09:00', '10424'],
        ['2021-03-17T07:07:00+09:00', '10510'],
        ['2021-03-17T07:08:00+09:00', '10591'],
        ['2021-03-17T07:09:00+09:00', '10352'],
        ['2021-03-17T07:10:00+09:00', '10516'],
        ['2021-03-17T07:11:00+09:00', '10334'],
        ['2021-03-17T07:12:00+09:00', '10453'],
        ['2021-03-17T07:13:00+09:00', '10470'],
        ['2021-03-17T07:14:00+09:00', '10250'],
        ['2021-03-17T07:15:00+09:00', '10392'],
        ['2021-03-17T07:16:00+09:00', '10161'],
        ['2021-03-17T07:17:00+09:00', '10389'],
        ['2021-03-17T07:18:00+09:00', '10332'],
        ['2021-03-17T07:19:00+09:00', '10116'],
        ['2021-03-17T07:20:00+09:00', '10121'],
        ['2021-03-17T07:21:00+09:00', '10033'],
        ['2021-03-17T07:22:00+09:00', '10188'],
        ['2021-03-17T07:23:00+09:00', '10012'],
        ['2021-03-17T07:24:00+09:00', '10304'],
        ['2021-03-17T07:25:00+09:00', '10224'],
        ['2021-03-17T07:26:00+09:00', '9973'],
        ['2021-03-17T07:27:00+09:00', '10245'],
        ['2021-03-17T07:28:00+09:00', '10041'],
        ['2021-03-17T07:29:00+09:00', '10119'],
        ['2021-03-17T07:30:00+09:00', '9979'],
        ['2021-03-17T07:31:00+09:00', '10179'],
        ['2021-03-17T07:32:00+09:00', '10091'],
        ['2021-03-17T07:33:00+09:00', '10177'],
        ['2021-03-17T07:34:00+09:00', '10096'],
        ['2021-03-17T07:35:00+09:00', '10112'],
        ['2021-03-17T07:36:00+09:00', '10168'],
        ['2021-03-17T07:37:00+09:00', '10000'],
        ['2021-03-17T07:38:00+09:00', '10123'],
        ['2021-03-17T07:39:00+09:00', '9927'],
        ['2021-03-17T07:40:00+09:00', '9884'],
        ['2021-03-17T07:41:00+09:00', '9909'],
        ['2021-03-17T07:42:00+09:00', '10051'],
        ['2021-03-17T07:43:00+09:00', '9836'],
        ['2021-03-17T07:44:00+09:00', '9942'],
        ['2021-03-17T07:45:00+09:00', '9785'],
        ['2021-03-17T07:46:00+09:00', '10008'],
        ['2021-03-17T07:47:00+09:00', '10025'],
        ['2021-03-17T07:48:00+09:00', '9854'],
        ['2021-03-17T07:49:00+09:00', '9953'],
        ['2021-03-17T07:50:00+09:00', '9717'],
        ['2021-03-17T07:51:00+09:00', '9969'],
        ['2021-03-17T07:52:00+09:00', '9885'],
        ['2021-03-17T07:53:00+09:00', '9849'],
        ['2021-03-17T07:54:00+09:00', '9655'],
        ['2021-03-17T07:55:00+09:00', '9809'],
        ['2021-03-17T07:56:00+09:00', '9770'],
        ['2021-03-17T07:57:00+09:00', '9758'],
        ['2021-03-17T07:58:00+09:00', '9656'],
        ['2021-03-17T07:59:00+09:00', '9575'],
        ['2021-03-17T08:00:00+09:00', '9699'],
        ['2021-03-17T08:01:00+09:00', '9591'],
        ['2021-03-17T08:02:00+09:00', '9702'],
        ['2021-03-17T08:03:00+09:00', '9489'],
        ['2021-03-17T08:04:00+09:00', '9752'],
        ['2021-03-17T08:05:00+09:00', '9761'],
        ['2021-03-17T08:06:00+09:00', '9579'],
        ['2021-03-17T08:07:00+09:00', '9608'],
        ['2021-03-17T08:08:00+09:00', '9724'],
        ['2021-03-17T08:09:00+09:00', '9680'],
        ['2021-03-17T08:10:00+09:00', '9646'],
        ['2021-03-17T08:11:00+09:00', '9702'],
        ['2021-03-17T08:12:00+09:00', '9639'],
        ['2021-03-17T08:13:00+09:00', '9689'],
        ['2021-03-17T08:14:00+09:00', '9766'],
        ['2021-03-17T08:15:00+09:00', '9624'],
        ['2021-03-17T08:16:00+09:00', '9642'],
        ['2021-03-17T08:17:00+09:00', '9551'],
        ['2021-03-17T08:18:00+09:00', '9741'],
        ['2021-03-17T08:19:00+09:00', '9455'],
        ['2021-03-17T08:20:00+09:00', '9477'],
        ['2021-03-17T08:21:00+09:00', '9643'],
        ['2021-03-17T08:22:00+09:00', '9583'],
        ['2021-03-17T08:23:00+09:00', '9724'],
        ['2021-03-17T08:24:00+09:00', '9463'],
        ['2021-03-17T08:25:00+09:00', '9417'],
        ['2021-03-17T08:26:00+09:00', '9677'],
        ['2021-03-17T08:27:00+09:00', '9682'],
        ['2021-03-17T08:28:00+09:00', '9708'],
        ['2021-03-17T08:29:00+09:00', '9633'],
        ['2021-03-17T08:30:00+09:00', '9595'],
        ['2021-03-17T08:31:00+09:00', '9572'],
        ['2021-03-17T08:32:00+09:00', '9462'],
        ['2021-03-17T08:33:00+09:00', '9513'],
        ['2021-03-17T08:34:00+09:00', '9444'],
        ['2021-03-17T08:35:00+09:00', '9403'],
        ['2021-03-17T08:36:00+09:00', '9406'],
        ['2021-03-17T08:37:00+09:00', '9373'],
        ['2021-03-17T08:38:00+09:00', '9367'],
        ['2021-03-17T08:39:00+09:00', '9581'],
        ['2021-03-17T08:40:00+09:00', '9480'],
        ['2021-03-17T08:41:00+09:00', '9499'],
        ['2021-03-17T08:42:00+09:00', '9423'],
        ['2021-03-17T08:43:00+09:00', '9572'],
        ['2021-03-17T08:44:00+09:00', '9460'],
        ['2021-03-17T08:45:00+09:00', '9531'],
        ['2021-03-17T08:46:00+09:00', '9352'],
        ['2021-03-17T08:47:00+09:00', '9565'],
        ['2021-03-17T08:48:00+09:00', '9305'],
        ['2021-03-17T08:49:00+09:00', '9310'],
        ['2021-03-17T08:50:00+09:00', '9428'],
        ['2021-03-17T08:51:00+09:00', '9378'],
        ['2021-03-17T08:52:00+09:00', '9324'],
        ['2021-03-17T08:53:00+09:00', '9463'],
        ['2021-03-17T08:54:00+09:00', '9249'],
        ['2021-03-17T08:55:00+09:00', '9290'],
        ['2021-03-17T08:56:00+09:00', '9290'],
        ['2021-03-17T08:57:00+09:00', '9553'],
        ['2021-03-17T08:58:00+09:00', '9354'],
        ['2021-03-17T08:59:00+09:00', '9278'],
        ['2021-03-17T09:00:00+09:00', '9317'],
        ['2021-03-17T09:01:00+09:00', '9294'],
        ['2021-03-17T09:02:00+09:00', '9412'],
        ['2021-03-17T09:03:00+09:00', '9550'],
        ['2021-03-17T09:04:00+09:00', '9482'],
        ['2021-03-17T09:05:00+09:00', '9533'],
        ['2021-03-17T09:06:00+09:00', '9456'],
        ['2021-03-17T09:07:00+09:00', '9337'],
        ['2021-03-17T09:08:00+09:00', '9249'],
        ['2021-03-17T09:09:00+09:00', '9306'],
        ['2021-03-17T09:10:00+09:00', '9372'],
        ['2021-03-17T09:11:00+09:00', '9396'],
        ['2021-03-17T09:12:00+09:00', '9225'],
        ['2021-03-17T09:13:00+09:00', '9342'],
        ['2021-03-17T09:14:00+09:00', '9245'],
        ['2021-03-17T09:15:00+09:00', '9268'],
        ['2021-03-17T09:16:00+09:00', '9399'],
        ['2021-03-17T09:17:00+09:00', '9364'],
        ['2021-03-17T09:18:00+09:00', '9533'],
        ['2021-03-17T09:19:00+09:00', '9502'],
        ['2021-03-17T09:20:00+09:00', '9344'],
        ['2021-03-17T09:21:00+09:00', '9416'],
        ['2021-03-17T09:22:00+09:00', '9298'],
        ['2021-03-17T09:23:00+09:00', '9306'],
        ['2021-03-17T09:24:00+09:00', '9408'],
        ['2021-03-17T09:25:00+09:00', '9266'],
        ['2021-03-17T09:26:00+09:00', '9559'],
        ['2021-03-17T09:27:00+09:00', '9566'],
        ['2021-03-17T09:28:00+09:00', '9413'],
        ['2021-03-17T09:29:00+09:00', '9301'],
        ['2021-03-17T09:30:00+09:00', '9337'],
        ['2021-03-17T09:31:00+09:00', '9290'],
        ['2021-03-17T09:32:00+09:00', '9480'],
        ['2021-03-17T09:33:00+09:00', '9360'],
        ['2021-03-17T09:34:00+09:00', '9315'],
        ['2021-03-17T09:35:00+09:00', '9479'],
        ['2021-03-17T09:36:00+09:00', '9471'],
        ['2021-03-17T09:37:00+09:00', '9517'],
        ['2021-03-17T09:38:00+09:00', '9300'],
        ['2021-03-17T09:39:00+09:00', '9292'],
        ['2021-03-17T09:40:00+09:00', '9523'],
        ['2021-03-17T09:41:00+09:00', '9524'],
        ['2021-03-17T09:42:00+09:00', '9309'],
        ['2021-03-17T09:43:00+09:00', '9313'],
        ['2021-03-17T09:44:00+09:00', '9368'],
        ['2021-03-17T09:45:00+09:00', '9631'],
        ['2021-03-17T09:46:00+09:00', '9546'],
        ['2021-03-17T09:47:00+09:00', '9421'],
        ['2021-03-17T09:48:00+09:00', '9387'],
        ['2021-03-17T09:49:00+09:00', '9588'],
        ['2021-03-17T09:50:00+09:00', '9483'],
        ['2021-03-17T09:51:00+09:00', '9616'],
        ['2021-03-17T09:52:00+09:00', '9468'],
        ['2021-03-17T09:53:00+09:00', '9435'],
        ['2021-03-17T09:54:00+09:00', '9528'],
        ['2021-03-17T09:55:00+09:00', '9336'],
        ['2021-03-17T09:56:00+09:00', '9622'],
        ['2021-03-17T09:57:00+09:00', '9340'],
        ['2021-03-17T09:58:00+09:00', '9361'],
        ['2021-03-17T09:59:00+09:00', '9618'],
        ['2021-03-17T10:00:00+09:00', '9608'],
        ['2021-03-17T10:01:00+09:00', '9419'],
        ['2021-03-17T10:02:00+09:00', '9345'],
        ['2021-03-17T10:03:00+09:00', '9598'],
        ['2021-03-17T10:04:00+09:00', '9663'],
        ['2021-03-17T10:05:00+09:00', '9485'],
        ['2021-03-17T10:06:00+09:00', '9681'],
        ['2021-03-17T10:07:00+09:00', '9621'],
        ['2021-03-17T10:08:00+09:00', '9477'],
        ['2021-03-17T10:09:00+09:00', '9411'],
        ['2021-03-17T10:10:00+09:00', '9652'],
        ['2021-03-17T10:11:00+09:00', '9532'],
        ['2021-03-17T10:12:00+09:00', '9526'],
        ['2021-03-17T10:13:00+09:00', '9652'],
        ['2021-03-17T10:14:00+09:00', '9503'],
        ['2021-03-17T10:15:00+09:00', '9426'],
        ['2021-03-17T10:16:00+09:00', '9688'],
        ['2021-03-17T10:17:00+09:00', '9585'],
        ['2021-03-17T10:18:00+09:00', '9527'],
        ['2021-03-17T10:19:00+09:00', '9623'],
        ['2021-03-17T10:20:00+09:00', '9703'],
        ['2021-03-17T10:21:00+09:00', '9712'],
        ['2021-03-17T10:22:00+09:00', '9715'],
        ['2021-03-17T10:23:00+09:00', '9724'],
        ['2021-03-17T10:24:00+09:00', '9667'],
        ['2021-03-17T10:25:00+09:00', '9544'],
        ['2021-03-17T10:26:00+09:00', '9728'],
        ['2021-03-17T10:27:00+09:00', '9662'],
        ['2021-03-17T10:28:00+09:00', '9703'],
        ['2021-03-17T10:29:00+09:00', '9776'],
        ['2021-03-17T10:30:00+09:00', '9577'],
        ['2021-03-17T10:31:00+09:00', '9771'],
        ['2021-03-17T10:32:00+09:00', '9749'],
        ['2021-03-17T10:33:00+09:00', '9699'],
        ['2021-03-17T10:34:00+09:00', '9847'],
        ['2021-03-17T10:35:00+09:00', '9826'],
        ['2021-03-17T10:36:00+09:00', '9854'],
        ['2021-03-17T10:37:00+09:00', '9880'],
        ['2021-03-17T10:38:00+09:00', '9909'],
        ['2021-03-17T10:39:00+09:00', '9776'],
        ['2021-03-17T10:40:00+09:00', '9770'],
        ['2021-03-17T10:41:00+09:00', '9934'],
        ['2021-03-17T10:42:00+09:00', '9804'],
        ['2021-03-17T10:43:00+09:00', '9832'],
        ['2021-03-17T10:44:00+09:00', '9775'],
        ['2021-03-17T10:45:00+09:00', '9963'],
        ['2021-03-17T10:46:00+09:00', '9980'],
        ['2021-03-17T10:47:00+09:00', '9938'],
        ['2021-03-17T10:48:00+09:00', '9985'],
        ['2021-03-17T10:49:00+09:00', '9731'],
        ['2021-03-17T10:50:00+09:00', '9809'],
        ['2021-03-17T10:51:00+09:00', '9998'],
        ['2021-03-17T10:52:00+09:00', '9995'],
        ['2021-03-17T10:53:00+09:00', '9844'],
        ['2021-03-17T10:54:00+09:00', '9961'],
        ['2021-03-17T10:55:00+09:00', '9904'],
        ['2021-03-17T10:56:00+09:00', '9825'],
        ['2021-03-17T10:57:00+09:00', '9964'],
        ['2021-03-17T10:58:00+09:00', '10038'],
        ['2021-03-17T10:59:00+09:00', '10041'],
        ['2021-03-17T11:00:00+09:00', '9839'],
        ['2021-03-17T11:01:00+09:00', '10113'],
        ['2021-03-17T11:02:00+09:00', '10017'],
        ['2021-03-17T11:03:00+09:00', '9830'],
        ['2021-03-17T11:04:00+09:00', '9993'],
        ['2021-03-17T11:05:00+09:00', '10085'],
        ['2021-03-17T11:06:00+09:00', '9893'],
        ['2021-03-17T11:07:00+09:00', '9933'],
        ['2021-03-17T11:08:00+09:00', '9952'],
        ['2021-03-17T11:09:00+09:00', '9975'],
        ['2021-03-17T11:10:00+09:00', '10197'],
        ['2021-03-17T11:11:00+09:00', '10190'],
        ['2021-03-17T11:12:00+09:00', '10143'],
        ['2021-03-17T11:13:00+09:00', '10226'],
        ['2021-03-17T11:14:00+09:00', '10095'],
        ['2021-03-17T11:15:00+09:00', '9988'],
        ['2021-03-17T11:16:00+09:00', '10114'],
        ['2021-03-17T11:17:00+09:00', '10288'],
        ['2021-03-17T11:18:00+09:00', '10313'],
        ['2021-03-17T11:19:00+09:00', '10214'],
        ['2021-03-17T11:20:00+09:00', '10290'],
        ['2021-03-17T11:21:00+09:00', '10182'],
        ['2021-03-17T11:22:00+09:00', '10207'],
        ['2021-03-17T11:23:00+09:00', '10211'],
        ['2021-03-17T11:24:00+09:00', '10362'],
        ['2021-03-17T11:25:00+09:00', '10149'],
        ['2021-03-17T11:26:00+09:00', '10253'],
        ['2021-03-17T11:27:00+09:00', '10342'],
        ['2021-03-17T11:28:00+09:00', '10165'],
        ['2021-03-17T11:29:00+09:00', '10268'],
        ['2021-03-17T11:30:00+09:00', '10262'],
        ['2021-03-17T11:31:00+09:00', '10213'],
        ['2021-03-17T11:32:00+09:00', '10333'],
        ['2021-03-17T11:33:00+09:00', '10262'],
        ['2021-03-17T11:34:00+09:00', '10298'],
        ['2021-03-17T11:35:00+09:00', '10483'],
        ['2021-03-17T11:36:00+09:00', '10466'],
        ['2021-03-17T11:37:00+09:00', '10263'],
        ['2021-03-17T11:38:00+09:00', '10479'],
        ['2021-03-17T11:39:00+09:00', '10587'],
        ['2021-03-17T11:40:00+09:00', '10309'],
        ['2021-03-17T11:41:00+09:00', '10438'],
        ['2021-03-17T11:42:00+09:00', '10389'],
        ['2021-03-17T11:43:00+09:00', '10442'],
        ['2021-03-17T11:44:00+09:00', '10654'],
        ['2021-03-17T11:45:00+09:00', '10429'],
        ['2021-03-17T11:46:00+09:00', '10491'],
        ['2021-03-17T11:47:00+09:00', '10664'],
        ['2021-03-17T11:48:00+09:00', '10691'],
        ['2021-03-17T11:49:00+09:00', '10528'],
        ['2021-03-17T11:50:00+09:00', '10718'],
        ['2021-03-17T11:51:00+09:00', '10830'],
        ['2021-03-17T11:52:00+09:00', '10589'],
        ['2021-03-17T11:53:00+09:00', '10648'],
        ['2021-03-17T11:54:00+09:00', '10678'],
        ['2021-03-17T11:55:00+09:00', '10897'],
        ['2021-03-17T11:56:00+09:00', '10763'],
        ['2021-03-17T11:57:00+09:00', '10788'],
        ['2021-03-17T11:58:00+09:00', '10679'],
        ['2021-03-17T11:59:00+09:00', '10842'],
        ['2021-03-17T12:00:00+09:00', '10720'],
        ['2021-03-17T12:01:00+09:00', '10837'],
        ['2021-03-17T12:02:00+09:00', '10884'],
        ['2021-03-17T12:03:00+09:00', '10900'],
        ['2021-03-17T12:04:00+09:00', '10904'],
        ['2021-03-17T12:05:00+09:00', '11050'],
        ['2021-03-17T12:06:00+09:00', '10844'],
        ['2021-03-17T12:07:00+09:00', '10987'],
        ['2021-03-17T12:08:00+09:00', '10929'],
        ['2021-03-17T12:09:00+09:00', '11005'],
        ['2021-03-17T12:10:00+09:00', '11008'],
        ['2021-03-17T12:11:00+09:00', '11164'],
        ['2021-03-17T12:12:00+09:00', '11103'],
        ['2021-03-17T12:13:00+09:00', '11052'],
        ['2021-03-17T12:14:00+09:00', '10959'],
        ['2021-03-17T12:15:00+09:00', '11043'],
        ['2021-03-17T12:16:00+09:00', '11042'],
        ['2021-03-17T12:17:00+09:00', '11257'],
        ['2021-03-17T12:18:00+09:00', '11044'],
        ['2021-03-17T12:19:00+09:00', '11148'],
        ['2021-03-17T12:20:00+09:00', '11268'],
        ['2021-03-17T12:21:00+09:00', '11203'],
        ['2021-03-17T12:22:00+09:00', '11192'],
        ['2021-03-17T12:23:00+09:00', '11286'],
        ['2021-03-17T12:24:00+09:00', '11240'],
        ['2021-03-17T12:25:00+09:00', '11310'],
        ['2021-03-17T12:26:00+09:00', '11327'],
        ['2021-03-17T12:27:00+09:00', '11299'],
        ['2021-03-17T12:28:00+09:00', '11301'],
        ['2021-03-17T12:29:00+09:00', '11457'],
        ['2021-03-17T12:30:00+09:00', '11260'],
        ['2021-03-17T12:31:00+09:00', '11378'],
        ['2021-03-17T12:32:00+09:00', '11498'],
        ['2021-03-17T12:33:00+09:00', '11264'],
        ['2021-03-17T12:34:00+09:00', '11359'],
        ['2021-03-17T12:35:00+09:00', '11254'],
        ['2021-03-17T12:36:00+09:00', '11505'],
        ['2021-03-17T12:37:00+09:00', '11305'],
        ['2021-03-17T12:38:00+09:00', '11473'],
        ['2021-03-17T12:39:00+09:00', '11626'],
        ['2021-03-17T12:40:00+09:00', '11414'],
        ['2021-03-17T12:41:00+09:00', '11485'],
        ['2021-03-17T12:42:00+09:00', '11537'],
        ['2021-03-17T12:43:00+09:00', '11487'],
        ['2021-03-17T12:44:00+09:00', '11668'],
        ['2021-03-17T12:45:00+09:00', '11586'],
        ['2021-03-17T12:46:00+09:00', '11640'],
        ['2021-03-17T12:47:00+09:00', '11750'],
        ['2021-03-17T12:48:00+09:00', '11718'],
        ['2021-03-17T12:49:00+09:00', '11593'],
        ['2021-03-17T12:50:00+09:00', '11551'],
        ['2021-03-17T12:51:00+09:00', '11633'],
        ['2021-03-17T12:52:00+09:00', '11665'],
        ['2021-03-17T12:53:00+09:00', '11865'],
        ['2021-03-17T12:54:00+09:00', '11875'],
        ['2021-03-17T12:55:00+09:00', '11676'],
        ['2021-03-17T12:56:00+09:00', '11761'],
        ['2021-03-17T12:57:00+09:00', '11823'],
        ['2021-03-17T12:58:00+09:00', '11763'],
        ['2021-03-17T12:59:00+09:00', '11671'],
        ['2021-03-17T13:00:00+09:00', '11910'],
        ['2021-03-17T13:01:00+09:00', '11751'],
        ['2021-03-17T13:02:00+09:00', '11762'],
        ['2021-03-17T13:03:00+09:00', '11778'],
        ['2021-03-17T13:04:00+09:00', '11903'],
        ['2021-03-17T13:05:00+09:00', '11855'],
        ['2021-03-17T13:06:00+09:00', '11781'],
        ['2021-03-17T13:07:00+09:00', '11804'],
        ['2021-03-17T13:08:00+09:00', '12051'],
        ['2021-03-17T13:09:00+09:00', '12079'],
        ['2021-03-17T13:10:00+09:00', '12081'],
        ['2021-03-17T13:11:00+09:00', '11877'],
        ['2021-03-17T13:12:00+09:00', '12046'],
        ['2021-03-17T13:13:00+09:00', '12129'],
        ['2021-03-17T13:14:00+09:00', '12114'],
        ['2021-03-17T13:15:00+09:00', '11976'],
        ['2021-03-17T13:16:00+09:00', '12236'],
        ['2021-03-17T13:17:00+09:00', '11967'],
        ['2021-03-17T13:18:00+09:00', '12252'],
        ['2021-03-17T13:19:00+09:00', '12200'],
        ['2021-03-17T13:20:00+09:00', '12236'],
        ['2021-03-17T13:21:00+09:00', '12127'],
        ['2021-03-17T13:22:00+09:00', '12101'],
        ['2021-03-17T13:23:00+09:00', '12094'],
        ['2021-03-17T13:24:00+09:00', '12083'],
        ['2021-03-17T13:25:00+09:00', '12095'],
        ['2021-03-17T13:26:00+09:00', '12161'],
        ['2021-03-17T13:27:00+09:00', '12394'],
        ['2021-03-17T13:28:00+09:00', '12330'],
        ['2021-03-17T13:29:00+09:00', '12397'],
        ['2021-03-17T13:30:00+09:00', '12470'],
        ['2021-03-17T13:31:00+09:00', '12190'],
        ['2021-03-17T13:32:00+09:00', '12297'],
        ['2021-03-17T13:33:00+09:00', '12255'],
        ['2021-03-17T13:34:00+09:00', '12390'],
        ['2021-03-17T13:35:00+09:00', '12390'],
        ['2021-03-17T13:36:00+09:00', '12458'],
        ['2021-03-17T13:37:00+09:00', '12385'],
        ['2021-03-17T13:38:00+09:00', '12485'],
        ['2021-03-17T13:39:00+09:00', '12296'],
        ['2021-03-17T13:40:00+09:00', '12422'],
        ['2021-03-17T13:41:00+09:00', '12497'],
        ['2021-03-17T13:42:00+09:00', '12261'],
        ['2021-03-17T13:43:00+09:00', '12444'],
        ['2021-03-17T13:44:00+09:00', '12360'],
        ['2021-03-17T13:45:00+09:00', '12321'],
        ['2021-03-17T13:46:00+09:00', '12563'],
        ['2021-03-17T13:47:00+09:00', '12405'],
        ['2021-03-17T13:48:00+09:00', '12544'],
        ['2021-03-17T13:49:00+09:00', '12481'],
        ['2021-03-17T13:50:00+09:00', '12419'],
        ['2021-03-17T13:51:00+09:00', '12477'],
        ['2021-03-17T13:52:00+09:00', '12600'],
        ['2021-03-17T13:53:00+09:00', '12572'],
        ['2021-03-17T13:54:00+09:00', '12471'],
        ['2021-03-17T13:55:00+09:00', '12634'],
        ['2021-03-17T13:56:00+09:00', '12604'],
        ['2021-03-17T13:57:00+09:00', '12579'],
        ['2021-03-17T13:58:00+09:00', '12645'],
        ['2021-03-17T13:59:00+09:00', '12568'],
        ['2021-03-17T14:00:00+09:00', '12745'],
        ['2021-03-17T14:01:00+09:00', '12702'],
        ['2021-03-17T14:02:00+09:00', '12774'],
        ['2021-03-17T14:03:00+09:00', '12625'],
        ['2021-03-17T14:04:00+09:00', '12664'],
        ['2021-03-17T14:05:00+09:00', '12655'],
        ['2021-03-17T14:06:00+09:00', '12542'],
        ['2021-03-17T14:07:00+09:00', '12602'],
        ['2021-03-17T14:08:00+09:00', '12828'],
        ['2021-03-17T14:09:00+09:00', '12712'],
        ['2021-03-17T14:10:00+09:00', '12729'],
        ['2021-03-17T14:11:00+09:00', '12732'],
        ['2021-03-17T14:12:00+09:00', '12672'],
        ['2021-03-17T14:13:00+09:00', '12850'],
        ['2021-03-17T14:14:00+09:00', '12772'],
        ['2021-03-17T14:15:00+09:00', '12797'],
        ['2021-03-17T14:16:00+09:00', '12878'],
        ['2021-03-17T14:17:00+09:00', '12940'],
        ['2021-03-17T14:18:00+09:00', '12826'],
        ['2021-03-17T14:19:00+09:00', '12826'],
        ['2021-03-17T14:20:00+09:00', '12876'],
        ['2021-03-17T14:21:00+09:00', '12873'],
        ['2021-03-17T14:22:00+09:00', '12953'],
        ['2021-03-17T14:23:00+09:00', '12925'],
        ['2021-03-17T14:24:00+09:00', '13024'],
        ['2021-03-17T14:25:00+09:00', '13107'],
        ['2021-03-17T14:26:00+09:00', '12916'],
        ['2021-03-17T14:27:00+09:00', '12950'],
        ['2021-03-17T14:28:00+09:00', '12984'],
        ['2021-03-17T14:29:00+09:00', '13161'],
        ['2021-03-17T14:30:00+09:00', '12926'],
        ['2021-03-17T14:31:00+09:00', '12967'],
        ['2021-03-17T14:32:00+09:00', '13228'],
        ['2021-03-17T14:33:00+09:00', '13172'],
        ['2021-03-17T14:34:00+09:00', '13251'],
        ['2021-03-17T14:35:00+09:00', '13245'],
        ['2021-03-17T14:36:00+09:00', '13062'],
        ['2021-03-17T14:37:00+09:00', '13305'],
        ['2021-03-17T14:38:00+09:00', '13146'],
        ['2021-03-17T14:39:00+09:00', '13158'],
        ['2021-03-17T14:40:00+09:00', '13230'],
        ['2021-03-17T14:41:00+09:00', '13129'],
        ['2021-03-17T14:42:00+09:00', '13168'],
        ['2021-03-17T14:43:00+09:00', '13078'],
        ['2021-03-17T14:44:00+09:00', '13331'],
        ['2021-03-17T14:45:00+09:00', '13317'],
        ['2021-03-17T14:46:00+09:00', '13102'],
        ['2021-03-17T14:47:00+09:00', '13308'],
        ['2021-03-17T14:48:00+09:00', '13144'],
        ['2021-03-17T14:49:00+09:00', '13191'],
        ['2021-03-17T14:50:00+09:00', '13224'],
        ['2021-03-17T14:51:00+09:00', '13411'],
        ['2021-03-17T14:52:00+09:00', '13215'],
        ['2021-03-17T14:53:00+09:00', '13319'],
        ['2021-03-17T14:54:00+09:00', '13285'],
        ['2021-03-17T14:55:00+09:00', '13295'],
        ['2021-03-17T14:56:00+09:00', '13285'],
        ['2021-03-17T14:57:00+09:00', '13445'],
        ['2021-03-17T14:58:00+09:00', '13255'],
        ['2021-03-17T14:59:00+09:00', '13267'],
        ['2021-03-17T15:00:00+09:00', '13227'],
        ['2021-03-17T15:01:00+09:00', '13228'],
        ['2021-03-17T15:02:00+09:00', '13311'],
        ['2021-03-17T15:03:00+09:00', '13292'],
        ['2021-03-17T15:04:00+09:00', '13263'],
        ['2021-03-17T15:05:00+09:00', '13290'],
        ['2021-03-17T15:06:00+09:00', '13284'],
        ['2021-03-17T15:07:00+09:00', '13488'],
        ['2021-03-17T15:08:00+09:00', '13368'],
        ['2021-03-17T15:09:00+09:00', '13270'],
        ['2021-03-17T15:10:00+09:00', '13376'],
        ['2021-03-17T15:11:00+09:00', '13275'],
        ['2021-03-17T15:12:00+09:00', '13452'],
        ['2021-03-17T15:13:00+09:00', '13240'],
        ['2021-03-17T15:14:00+09:00', '13238'],
        ['2021-03-17T15:15:00+09:00', '13419'],
        ['2021-03-17T15:16:00+09:00', '13402'],
        ['2021-03-17T15:17:00+09:00', '13245'],
        ['2021-03-17T15:18:00+09:00', '13497'],
        ['2021-03-17T15:19:00+09:00', '13557'],
        ['2021-03-17T15:20:00+09:00', '13298'],
        ['2021-03-17T15:21:00+09:00', '13544'],
        ['2021-03-17T15:22:00+09:00', '13258'],
        ['2021-03-17T15:23:00+09:00', '13261'],
        ['2021-03-17T15:24:00+09:00', '13537'],
        ['2021-03-17T15:25:00+09:00', '13225'],
        ['2021-03-17T15:26:00+09:00', '13272'],
        ['2021-03-17T15:27:00+09:00', '13378'],
        ['2021-03-17T15:28:00+09:00', '13433'],
        ['2021-03-17T15:29:00+09:00', '13263'],
        ['2021-03-17T15:30:00+09:00', '13396'],
        ['2021-03-17T15:31:00+09:00', '13288'],
        ['2021-03-17T15:32:00+09:00', '13213'],
        ['2021-03-17T15:33:00+09:00', '13326'],
        ['2021-03-17T15:34:00+09:00', '13359'],
        ['2021-03-17T15:35:00+09:00', '13240'],
        ['2021-03-17T15:36:00+09:00', '13491'],
        ['2021-03-17T15:37:00+09:00', '13331'],
        ['2021-03-17T15:38:00+09:00', '13272'],
        ['2021-03-17T15:39:00+09:00', '13504'],
        ['2021-03-17T15:40:00+09:00', '13595'],
        ['2021-03-17T15:41:00+09:00', '13446'],
        ['2021-03-17T15:42:00+09:00', '13336'],
        ['2021-03-17T15:43:00+09:00', '13370'],
        ['2021-03-17T15:44:00+09:00', '13564'],
        ['2021-03-17T15:45:00+09:00', '13548'],
        ['2021-03-17T15:46:00+09:00', '13523'],
        ['2021-03-17T15:47:00+09:00', '13606'],
        ['2021-03-17T15:48:00+09:00', '13446'],
        ['2021-03-17T15:49:00+09:00', '13616'],
        ['2021-03-17T15:50:00+09:00', '13588'],
        ['2021-03-17T15:51:00+09:00', '13524'],
        ['2021-03-17T15:52:00+09:00', '13570'],
        ['2021-03-17T15:53:00+09:00', '13481'],
        ['2021-03-17T15:54:00+09:00', '13644'],
        ['2021-03-17T15:55:00+09:00', '13472'],
        ['2021-03-17T15:56:00+09:00', '13637'],
        ['2021-03-17T15:57:00+09:00', '13605'],
        ['2021-03-17T15:58:00+09:00', '13511'],
        ['2021-03-17T15:59:00+09:00', '13524'],
        ['2021-03-17T16:00:00+09:00', '13610'],
        ['2021-03-17T16:01:00+09:00', '13391'],
        ['2021-03-17T16:02:00+09:00', '13512'],
        ['2021-03-17T16:03:00+09:00', '13490'],
        ['2021-03-17T16:04:00+09:00', '13566'],
        ['2021-03-17T16:05:00+09:00', '13621'],
        ['2021-03-17T16:06:00+09:00', '13534'],
        ['2021-03-17T16:07:00+09:00', '13435'],
        ['2021-03-17T16:08:00+09:00', '13521'],
        ['2021-03-17T16:09:00+09:00', '13606'],
        ['2021-03-17T16:10:00+09:00', '13678'],
        ['2021-03-17T16:11:00+09:00', '13702'],
        ['2021-03-17T16:12:00+09:00', '13425'],
        ['2021-03-17T16:13:00+09:00', '13581'],
        ['2021-03-17T16:14:00+09:00', '13542'],
        ['2021-03-17T16:15:00+09:00', '13523'],
        ['2021-03-17T16:16:00+09:00', '13469'],
        ['2021-03-17T16:17:00+09:00', '13394'],
        ['2021-03-17T16:18:00+09:00', '13402'],
        ['2021-03-17T16:19:00+09:00', '13429'],
        ['2021-03-17T16:20:00+09:00', '13408'],
        ['2021-03-17T16:21:00+09:00', '13474'],
        ['2021-03-17T16:22:00+09:00', '13583'],
        ['2021-03-17T16:23:00+09:00', '13593'],
        ['2021-03-17T16:24:00+09:00', '13465'],
        ['2021-03-17T16:25:00+09:00', '13690'],
        ['2021-03-17T16:26:00+09:00', '13606'],
        ['2021-03-17T16:27:00+09:00', '13734'],
        ['2021-03-17T16:28:00+09:00', '13542'],
        ['2021-03-17T16:29:00+09:00', '13735'],
        ['2021-03-17T16:30:00+09:00', '13593'],
        ['2021-03-17T16:31:00+09:00', '13619'],
        ['2021-03-17T16:32:00+09:00', '13532'],
        ['2021-03-17T16:33:00+09:00', '13776'],
        ['2021-03-17T16:34:00+09:00', '13677'],
        ['2021-03-17T16:35:00+09:00', '13766'],
        ['2021-03-17T16:36:00+09:00', '13762'],
        ['2021-03-17T16:37:00+09:00', '13578'],
        ['2021-03-17T16:38:00+09:00', '13835'],
        ['2021-03-17T16:39:00+09:00', '13731'],
        ['2021-03-17T16:40:00+09:00', '13537'],
        ['2021-03-17T16:41:00+09:00', '13596'],
        ['2021-03-17T16:42:00+09:00', '13743'],
        ['2021-03-17T16:43:00+09:00', '13628'],
        ['2021-03-17T16:44:00+09:00', '13768'],
        ['2021-03-17T16:45:00+09:00', '13653'],
        ['2021-03-17T16:46:00+09:00', '13837'],
        ['2021-03-17T16:47:00+09:00', '13870'],
        ['2021-03-17T16:48:00+09:00', '13761'],
        ['2021-03-17T16:49:00+09:00', '13626'],
        ['2021-03-17T16:50:00+09:00', '13651'],
        ['2021-03-17T16:51:00+09:00', '13645'],
        ['2021-03-17T16:52:00+09:00', '13651'],
        ['2021-03-17T16:53:00+09:00', '13859'],
        ['2021-03-17T16:54:00+09:00', '13673'],
        ['2021-03-17T16:55:00+09:00', '13702'],
        ['2021-03-17T16:56:00+09:00', '13849'],
        ['2021-03-17T16:57:00+09:00', '13677'],
        ['2021-03-17T16:58:00+09:00', '13907'],
        ['2021-03-17T16:59:00+09:00', '13674'],
        ['2021-03-17T17:00:00+09:00', '13728'],
        ['2021-03-17T17:01:00+09:00', '13914'],
        ['2021-03-17T17:02:00+09:00', '13739'],
        ['2021-03-17T17:03:00+09:00', '13782'],
        ['2021-03-17T17:04:00+09:00', '13826'],
        ['2021-03-17T17:05:00+09:00', '13805'],
        ['2021-03-17T17:06:00+09:00', '13999'],
        ['2021-03-17T17:07:00+09:00', '13966'],
        ['2021-03-17T17:08:00+09:00', '14018'],
        ['2021-03-17T17:09:00+09:00', '14014'],
        ['2021-03-17T17:10:00+09:00', '13955'],
        ['2021-03-17T17:11:00+09:00', '13777'],
        ['2021-03-17T17:12:00+09:00', '14004'],
        ['2021-03-17T17:13:00+09:00', '14031'],
        ['2021-03-17T17:14:00+09:00', '14112'],
        ['2021-03-17T17:15:00+09:00', '13876'],
        ['2021-03-17T17:16:00+09:00', '14096'],
        ['2021-03-17T17:17:00+09:00', '13837'],
        ['2021-03-17T17:18:00+09:00', '13881'],
        ['2021-03-17T17:19:00+09:00', '14140'],
        ['2021-03-17T17:20:00+09:00', '13980'],
        ['2021-03-17T17:21:00+09:00', '13949'],
        ['2021-03-17T17:22:00+09:00', '14138'],
        ['2021-03-17T17:23:00+09:00', '14203'],
        ['2021-03-17T17:24:00+09:00', '14140'],
        ['2021-03-17T17:25:00+09:00', '14070'],
        ['2021-03-17T17:26:00+09:00', '14266'],
        ['2021-03-17T17:27:00+09:00', '14018'],
        ['2021-03-17T17:28:00+09:00', '14230'],
        ['2021-03-17T17:29:00+09:00', '14308'],
        ['2021-03-17T17:30:00+09:00', '14046'],
        ['2021-03-17T17:31:00+09:00', '14295'],
        ['2021-03-17T17:32:00+09:00', '14052'],
        ['2021-03-17T17:33:00+09:00', '14123'],
        ['2021-03-17T17:34:00+09:00', '14095'],
        ['2021-03-17T17:35:00+09:00', '14301'],
        ['2021-03-17T17:36:00+09:00', '14319'],
        ['2021-03-17T17:37:00+09:00', '14271'],
        ['2021-03-17T17:38:00+09:00', '14284'],
        ['2021-03-17T17:39:00+09:00', '14170'],
        ['2021-03-17T17:40:00+09:00', '14239'],
        ['2021-03-17T17:41:00+09:00', '14467'],
        ['2021-03-17T17:42:00+09:00', '14378'],
        ['2021-03-17T17:43:00+09:00', '14221'],
        ['2021-03-17T17:44:00+09:00', '14500'],
        ['2021-03-17T17:45:00+09:00', '14328'],
        ['2021-03-17T17:46:00+09:00', '14447'],
        ['2021-03-17T17:47:00+09:00', '14432'],
        ['2021-03-17T17:48:00+09:00', '14331'],
        ['2021-03-17T17:49:00+09:00', '14449'],
        ['2021-03-17T17:50:00+09:00', '14320'],
        ['2021-03-17T17:51:00+09:00', '14383'],
        ['2021-03-17T17:52:00+09:00', '14619'],
        ['2021-03-17T17:53:00+09:00', '14530'],
        ['2021-03-17T17:54:00+09:00', '14611'],
        ['2021-03-17T17:55:00+09:00', '14415'],
        ['2021-03-17T17:56:00+09:00', '14628'],
        ['2021-03-17T17:57:00+09:00', '14675'],
        ['2021-03-17T17:58:00+09:00', '14680'],
        ['2021-03-17T17:59:00+09:00', '14534'],
        ['2021-03-17T18:00:00+09:00', '14543'],
        ['2021-03-17T18:01:00+09:00', '14459'],
        ['2021-03-17T18:02:00+09:00', '14656'],
        ['2021-03-17T18:03:00+09:00', '14638'],
        ['2021-03-17T18:04:00+09:00', '14583'],
        ['2021-03-17T18:05:00+09:00', '14655'],
        ['2021-03-17T18:06:00+09:00', '14525'],
        ['2021-03-17T18:07:00+09:00', '14604'],
        ['2021-03-17T18:08:00+09:00', '14511'],
        ['2021-03-17T18:09:00+09:00', '14652'],
        ['2021-03-17T18:10:00+09:00', '14685'],
        ['2021-03-17T18:11:00+09:00', '14737'],
        ['2021-03-17T18:12:00+09:00', '14723'],
        ['2021-03-17T18:13:00+09:00', '14613'],
        ['2021-03-17T18:14:00+09:00', '14711'],
        ['2021-03-17T18:15:00+09:00', '14793'],
        ['2021-03-17T18:16:00+09:00', '14656'],
        ['2021-03-17T18:17:00+09:00', '14678'],
        ['2021-03-17T18:18:00+09:00', '14767'],
        ['2021-03-17T18:19:00+09:00', '14926'],
        ['2021-03-17T18:20:00+09:00', '14913'],
        ['2021-03-17T18:21:00+09:00', '14791'],
        ['2021-03-17T18:22:00+09:00', '14651'],
        ['2021-03-17T18:23:00+09:00', '14843'],
        ['2021-03-17T18:24:00+09:00', '14876'],
        ['2021-03-17T18:25:00+09:00', '14763'],
        ['2021-03-17T18:26:00+09:00', '14909'],
        ['2021-03-17T18:27:00+09:00', '14908'],
        ['2021-03-17T18:28:00+09:00', '14692'],
        ['2021-03-17T18:29:00+09:00', '14665'],
        ['2021-03-17T18:30:00+09:00', '14937'],
        ['2021-03-17T18:31:00+09:00', '14768'],
        ['2021-03-17T18:32:00+09:00', '14886'],
        ['2021-03-17T18:33:00+09:00', '14812'],
        ['2021-03-17T18:34:00+09:00', '14754'],
        ['2021-03-17T18:35:00+09:00', '14738'],
        ['2021-03-17T18:36:00+09:00', '14751'],
        ['2021-03-17T18:37:00+09:00', '14931'],
        ['2021-03-17T18:38:00+09:00', '14769'],
        ['2021-03-17T18:39:00+09:00', '14932'],
        ['2021-03-17T18:40:00+09:00', '15029'],
        ['2021-03-17T18:41:00+09:00', '14865'],
        ['2021-03-17T18:42:00+09:00', '14787'],
        ['2021-03-17T18:43:00+09:00', '14956'],
        ['2021-03-17T18:44:00+09:00', '14951'],
        ['2021-03-17T18:45:00+09:00', '14925'],
        ['2021-03-17T18:46:00+09:00', '14890'],
        ['2021-03-17T18:47:00+09:00', '15003'],
        ['2021-03-17T18:48:00+09:00', '14876'],
        ['2021-03-17T18:49:00+09:00', '15040'],
        ['2021-03-17T18:50:00+09:00', '14897'],
        ['2021-03-17T18:51:00+09:00', '15102'],
        ['2021-03-17T18:52:00+09:00', '15008'],
        ['2021-03-17T18:53:00+09:00', '15157'],
        ['2021-03-17T18:54:00+09:00', '15093'],
        ['2021-03-17T18:55:00+09:00', '14974'],
        ['2021-03-17T18:56:00+09:00', '14931'],
        ['2021-03-17T18:57:00+09:00', '15134'],
        ['2021-03-17T18:58:00+09:00', '15132'],
        ['2021-03-17T18:59:00+09:00', '14980'],
        ['2021-03-17T19:00:00+09:00', '15092'],
        ['2021-03-17T19:01:00+09:00', '15087'],
        ['2021-03-17T19:02:00+09:00', '15043'],
        ['2021-03-17T19:03:00+09:00', '15000'],
        ['2021-03-17T19:04:00+09:00', '15103'],
        ['2021-03-17T19:05:00+09:00', '15084'],
        ['2021-03-17T19:06:00+09:00', '15245'],
        ['2021-03-17T19:07:00+09:00', '15162'],
        ['2021-03-17T19:08:00+09:00', '15312'],
        ['2021-03-17T19:09:00+09:00', '15098'],
        ['2021-03-17T19:10:00+09:00', '15121'],
        ['2021-03-17T19:11:00+09:00', '15155'],
        ['2021-03-17T19:12:00+09:00', '15121'],
        ['2021-03-17T19:13:00+09:00', '15249'],
        ['2021-03-17T19:14:00+09:00', '15233'],
        ['2021-03-17T19:15:00+09:00', '15365'],
        ['2021-03-17T19:16:00+09:00', '15271'],
        ['2021-03-17T19:17:00+09:00', '15145'],
        ['2021-03-17T19:18:00+09:00', '15124'],
        ['2021-03-17T19:19:00+09:00', '15241'],
        ['2021-03-17T19:20:00+09:00', '15387'],
        ['2021-03-17T19:21:00+09:00', '15405'],
        ['2021-03-17T19:22:00+09:00', '15243'],
        ['2021-03-17T19:23:00+09:00', '15404'],
        ['2021-03-17T19:24:00+09:00', '15219'],
        ['2021-03-17T19:25:00+09:00', '15325'],
        ['2021-03-17T19:26:00+09:00', '15328'],
        ['2021-03-17T19:27:00+09:00', '15136'],
        ['2021-03-17T19:28:00+09:00', '15404'],
        ['2021-03-17T19:29:00+09:00', '15274'],
        ['2021-03-17T19:30:00+09:00', '15155'],
        ['2021-03-17T19:31:00+09:00', '15193'],
        ['2021-03-17T19:32:00+09:00', '15439'],
        ['2021-03-17T19:33:00+09:00', '15404'],
        ['2021-03-17T19:34:00+09:00', '15468'],
        ['2021-03-17T19:35:00+09:00', '15424'],
        ['2021-03-17T19:36:00+09:00', '15381'],
        ['2021-03-17T19:37:00+09:00', '15301'],
        ['2021-03-17T19:38:00+09:00', '15424'],
        ['2021-03-17T19:39:00+09:00', '15587'],
        ['2021-03-17T19:40:00+09:00', '15433'],
        ['2021-03-17T19:41:00+09:00', '15495'],
        ['2021-03-17T19:42:00+09:00', '15512'],
        ['2021-03-17T19:43:00+09:00', '15412'],
        ['2021-03-17T19:44:00+09:00', '15429'],
        ['2021-03-17T19:45:00+09:00', '15477'],
        ['2021-03-17T19:46:00+09:00', '15449'],
        ['2021-03-17T19:47:00+09:00', '15516'],
        ['2021-03-17T19:48:00+09:00', '15595'],
        ['2021-03-17T19:49:00+09:00', '15725'],
        ['2021-03-17T19:50:00+09:00', '15668'],
        ['2021-03-17T19:51:00+09:00', '15599'],
        ['2021-03-17T19:52:00+09:00', '15811'],
        ['2021-03-17T19:53:00+09:00', '15609'],
        ['2021-03-17T19:54:00+09:00', '15735'],
        ['2021-03-17T19:55:00+09:00', '15550'],
        ['2021-03-17T19:56:00+09:00', '15727'],
        ['2021-03-17T19:57:00+09:00', '15754'],
        ['2021-03-17T19:58:00+09:00', '15602'],
        ['2021-03-17T19:59:00+09:00', '15680'],
        ['2021-03-17T20:00:00+09:00', '15656'],
        ['2021-03-17T20:01:00+09:00', '15622'],
        ['2021-03-17T20:02:00+09:00', '15735'],
        ['2021-03-17T20:03:00+09:00', '15795'],
        ['2021-03-17T20:04:00+09:00', '15774'],
        ['2021-03-17T20:05:00+09:00', '15626'],
        ['2021-03-17T20:06:00+09:00', '15841'],
        ['2021-03-17T20:07:00+09:00', '15924'],
        ['2021-03-17T20:08:00+09:00', '15728'],
        ['2021-03-17T20:09:00+09:00', '15635'],
        ['2021-03-17T20:10:00+09:00', '15933'],
        ['2021-03-17T20:11:00+09:00', '15800'],
        ['2021-03-17T20:12:00+09:00', '15902'],
        ['2021-03-17T20:13:00+09:00', '15685'],
        ['2021-03-17T20:14:00+09:00', '15756'],
        ['2021-03-17T20:15:00+09:00', '15879'],
        ['2021-03-17T20:16:00+09:00', '15769'],
        ['2021-03-17T20:17:00+09:00', '15817'],
        ['2021-03-17T20:18:00+09:00', '15739'],
        ['2021-03-17T20:19:00+09:00', '15787'],
        ['2021-03-17T20:20:00+09:00', '15718'],
        ['2021-03-17T20:21:00+09:00', '15716'],
        ['2021-03-17T20:22:00+09:00', '15856'],
        ['2021-03-17T20:23:00+09:00', '15902'],
        ['2021-03-17T20:24:00+09:00', '15893'],
        ['2021-03-17T20:25:00+09:00', '15765'],
        ['2021-03-17T20:26:00+09:00', '15895'],
        ['2021-03-17T20:27:00+09:00', '15991'],
        ['2021-03-17T20:28:00+09:00', '16098'],
        ['2021-03-17T20:29:00+09:00', '16043'],
        ['2021-03-17T20:30:00+09:00', '16016'],
        ['2021-03-17T20:31:00+09:00', '15994'],
        ['2021-03-17T20:32:00+09:00', '16125'],
        ['2021-03-17T20:33:00+09:00', '16027'],
        ['2021-03-17T20:34:00+09:00', '16081'],
        ['2021-03-17T20:35:00+09:00', '16034'],
        ['2021-03-17T20:36:00+09:00', '16028'],
        ['2021-03-17T20:37:00+09:00', '16092'],
        ['2021-03-17T20:38:00+09:00', '15898'],
        ['2021-03-17T20:39:00+09:00', '16098'],
        ['2021-03-17T20:40:00+09:00', '16091'],
        ['2021-03-17T20:41:00+09:00', '16069'],
        ['2021-03-17T20:42:00+09:00', '15966'],
        ['2021-03-17T20:43:00+09:00', '15916'],
        ['2021-03-17T20:44:00+09:00', '16160'],
        ['2021-03-17T20:45:00+09:00', '16143'],
        ['2021-03-17T20:46:00+09:00', '16167'],
        ['2021-03-17T20:47:00+09:00', '15869'],
        ['2021-03-17T20:48:00+09:00', '15917'],
        ['2021-03-17T20:49:00+09:00', '16011'],
        ['2021-03-17T20:50:00+09:00', '16074'],
        ['2021-03-17T20:51:00+09:00', '15974'],
        ['2021-03-17T20:52:00+09:00', '16019'],
        ['2021-03-17T20:53:00+09:00', '15916'],
        ['2021-03-17T20:54:00+09:00', '15864'],
        ['2021-03-17T20:55:00+09:00', '16010'],
        ['2021-03-17T20:56:00+09:00', '16079'],
        ['2021-03-17T20:57:00+09:00', '15992'],
        ['2021-03-17T20:58:00+09:00', '15887'],
        ['2021-03-17T20:59:00+09:00', '15851'],
        ['2021-03-17T21:00:00+09:00', '16135'],
        ['2021-03-17T21:01:00+09:00', '16092'],
        ['2021-03-17T21:02:00+09:00', '15858'],
        ['2021-03-17T21:03:00+09:00', '16101'],
        ['2021-03-17T21:04:00+09:00', '16078'],
        ['2021-03-17T21:05:00+09:00', '15822'],
        ['2021-03-17T21:06:00+09:00', '16023'],
        ['2021-03-17T21:07:00+09:00', '15826'],
        ['2021-03-17T21:08:00+09:00', '16064'],
        ['2021-03-17T21:09:00+09:00', '16013'],
        ['2021-03-17T21:10:00+09:00', '16026'],
        ['2021-03-17T21:11:00+09:00', '15899'],
        ['2021-03-17T21:12:00+09:00', '15869'],
        ['2021-03-17T21:13:00+09:00', '16050'],
        ['2021-03-17T21:14:00+09:00', '15926'],
        ['2021-03-17T21:15:00+09:00', '15888'],
        ['2021-03-17T21:16:00+09:00', '15900'],
        ['2021-03-17T21:17:00+09:00', '15812'],
        ['2021-03-17T21:18:00+09:00', '15955'],
        ['2021-03-17T21:19:00+09:00', '15955'],
        ['2021-03-17T21:20:00+09:00', '15975'],
        ['2021-03-17T21:21:00+09:00', '16035'],
        ['2021-03-17T21:22:00+09:00', '15751'],
        ['2021-03-17T21:23:00+09:00', '15973'],
        ['2021-03-17T21:24:00+09:00', '16017'],
        ['2021-03-17T21:25:00+09:00', '15997'],
        ['2021-03-17T21:26:00+09:00', '15957'],
        ['2021-03-17T21:27:00+09:00', '15968'],
        ['2021-03-17T21:28:00+09:00', '15934'],
        ['2021-03-17T21:29:00+09:00', '15812'],
        ['2021-03-17T21:30:00+09:00', '15947'],
        ['2021-03-17T21:31:00+09:00', '15757'],
        ['2021-03-17T21:32:00+09:00', '15684'],
        ['2021-03-17T21:33:00+09:00', '15807'],
        ['2021-03-17T21:34:00+09:00', '15910'],
        ['2021-03-17T21:35:00+09:00', '15794'],
        ['2021-03-17T21:36:00+09:00', '15889'],
        ['2021-03-17T21:37:00+09:00', '15747'],
        ['2021-03-17T21:38:00+09:00', '15973'],
        ['2021-03-17T21:39:00+09:00', '15912'],
        ['2021-03-17T21:40:00+09:00', '15840'],
        ['2021-03-17T21:41:00+09:00', '15933'],
        ['2021-03-17T21:42:00+09:00', '15792'],
        ['2021-03-17T21:43:00+09:00', '15941'],
        ['2021-03-17T21:44:00+09:00', '15782'],
        ['2021-03-17T21:45:00+09:00', '15876'],
        ['2021-03-17T21:46:00+09:00', '15773'],
        ['2021-03-17T21:47:00+09:00', '15858'],
        ['2021-03-17T21:48:00+09:00', '15728'],
        ['2021-03-17T21:49:00+09:00', '15913'],
        ['2021-03-17T21:50:00+09:00', '15829'],
        ['2021-03-17T21:51:00+09:00', '15801'],
        ['2021-03-17T21:52:00+09:00', '15640'],
        ['2021-03-17T21:53:00+09:00', '15718'],
        ['2021-03-17T21:54:00+09:00', '15594'],
        ['2021-03-17T21:55:00+09:00', '15594'],
        ['2021-03-17T21:56:00+09:00', '15785'],
        ['2021-03-17T21:57:00+09:00', '15749'],
        ['2021-03-17T21:58:00+09:00', '15636'],
        ['2021-03-17T21:59:00+09:00', '15493'],
        ['2021-03-17T22:00:00+09:00', '15652'],
        ['2021-03-17T22:01:00+09:00', '15576'],
        ['2021-03-17T22:02:00+09:00', '15642'],
        ['2021-03-17T22:03:00+09:00', '15444'],
        ['2021-03-17T22:04:00+09:00', '15683'],
        ['2021-03-17T22:05:00+09:00', '15607'],
        ['2021-03-17T22:06:00+09:00', '15674'],
        ['2021-03-17T22:07:00+09:00', '15408'],
        ['2021-03-17T22:08:00+09:00', '15491'],
        ['2021-03-17T22:09:00+09:00', '15379'],
        ['2021-03-17T22:10:00+09:00', '15659'],
        ['2021-03-17T22:11:00+09:00', '15622'],
        ['2021-03-17T22:12:00+09:00', '15388'],
        ['2021-03-17T22:13:00+09:00', '15494'],
        ['2021-03-17T22:14:00+09:00', '15534'],
        ['2021-03-17T22:15:00+09:00', '15450'],
        ['2021-03-17T22:16:00+09:00', '15610'],
        ['2021-03-17T22:17:00+09:00', '15389'],
        ['2021-03-17T22:18:00+09:00', '15602'],
        ['2021-03-17T22:19:00+09:00', '15556'],
        ['2021-03-17T22:20:00+09:00', '15514'],
        ['2021-03-17T22:21:00+09:00', '15572'],
        ['2021-03-17T22:22:00+09:00', '15526'],
        ['2021-03-17T22:23:00+09:00', '15416'],
        ['2021-03-17T22:24:00+09:00', '15408'],
        ['2021-03-17T22:25:00+09:00', '15328'],
        ['2021-03-17T22:26:00+09:00', '15542'],
        ['2021-03-17T22:27:00+09:00', '15512'],
        ['2021-03-17T22:28:00+09:00', '15520'],
        ['2021-03-17T22:29:00+09:00', '15371'],
        ['2021-03-17T22:30:00+09:00', '15490'],
        ['2021-03-17T22:31:00+09:00', '15254'],
        ['2021-03-17T22:32:00+09:00', '15349'],
        ['2021-03-17T22:33:00+09:00', '15489'],
        ['2021-03-17T22:34:00+09:00', '15252'],
        ['2021-03-17T22:35:00+09:00', '15409'],
        ['2021-03-17T22:36:00+09:00', '15202'],
        ['2021-03-17T22:37:00+09:00', '15178'],
        ['2021-03-17T22:38:00+09:00', '15287'],
        ['2021-03-17T22:39:00+09:00', '15260'],
        ['2021-03-17T22:40:00+09:00', '15309'],
        ['2021-03-17T22:41:00+09:00', '15255'],
        ['2021-03-17T22:42:00+09:00', '15118'],
        ['2021-03-17T22:43:00+09:00', '15181'],
        ['2021-03-17T22:44:00+09:00', '15169'],
        ['2021-03-17T22:45:00+09:00', '15172'],
        ['2021-03-17T22:46:00+09:00', '15318'],
        ['2021-03-17T22:47:00+09:00', '15284'],
        ['2021-03-17T22:48:00+09:00', '15117'],
        ['2021-03-17T22:49:00+09:00', '15283'],
        ['2021-03-17T22:50:00+09:00', '15140'],
        ['2021-03-17T22:51:00+09:00', '15108'],
        ['2021-03-17T22:52:00+09:00', '15350'],
        ['2021-03-17T22:53:00+09:00', '15158'],
        ['2021-03-17T22:54:00+09:00', '15103'],
        ['2021-03-17T22:55:00+09:00', '15269'],
        ['2021-03-17T22:56:00+09:00', '15133'],
        ['2021-03-17T22:57:00+09:00', '15121'],
        ['2021-03-17T22:58:00+09:00', '14993'],
        ['2021-03-17T22:59:00+09:00', '15288'],
        ['2021-03-17T23:00:00+09:00', '15031'],
        ['2021-03-17T23:01:00+09:00', '15014'],
        ['2021-03-17T23:02:00+09:00', '14931'],
        ['2021-03-17T23:03:00+09:00', '15121'],
        ['2021-03-17T23:04:00+09:00', '14991'],
        ['2021-03-17T23:05:00+09:00', '15000'],
        ['2021-03-17T23:06:00+09:00', '15084'],
        ['2021-03-17T23:07:00+09:00', '15129'],
        ['2021-03-17T23:08:00+09:00', '14964'],
        ['2021-03-17T23:09:00+09:00', '15020'],
        ['2021-03-17T23:10:00+09:00', '15066'],
        ['2021-03-17T23:11:00+09:00', '14946'],
        ['2021-03-17T23:12:00+09:00', '14971'],
        ['2021-03-17T23:13:00+09:00', '14821'],
        ['2021-03-17T23:14:00+09:00', '15044'],
        ['2021-03-17T23:15:00+09:00', '14883'],
        ['2021-03-17T23:16:00+09:00', '14935'],
        ['2021-03-17T23:17:00+09:00', '14749'],
        ['2021-03-17T23:18:00+09:00', '14728'],
        ['2021-03-17T23:19:00+09:00', '14710'],
        ['2021-03-17T23:20:00+09:00', '14673'],
        ['2021-03-17T23:21:00+09:00', '14879'],
        ['2021-03-17T23:22:00+09:00', '14679'],
        ['2021-03-17T23:23:00+09:00', '14866'],
        ['2021-03-17T23:24:00+09:00', '14738'],
        ['2021-03-17T23:25:00+09:00', '14912'],
        ['2021-03-17T23:26:00+09:00', '14859'],
        ['2021-03-17T23:27:00+09:00', '14633'],
        ['2021-03-17T23:28:00+09:00', '14767'],
        ['2021-03-17T23:29:00+09:00', '14801'],
        ['2021-03-17T23:30:00+09:00', '14800'],
        ['2021-03-17T23:31:00+09:00', '14796'],
        ['2021-03-17T23:32:00+09:00', '14837'],
        ['2021-03-17T23:33:00+09:00', '14573'],
        ['2021-03-17T23:34:00+09:00', '14651'],
        ['2021-03-17T23:35:00+09:00', '14777'],
        ['2021-03-17T23:36:00+09:00', '14573'],
        ['2021-03-17T23:37:00+09:00', '14586'],
        ['2021-03-17T23:38:00+09:00', '14526'],
        ['2021-03-17T23:39:00+09:00', '14672'],
        ['2021-03-17T23:40:00+09:00', '14397'],
        ['2021-03-17T23:41:00+09:00', '14585'],
        ['2021-03-17T23:42:00+09:00', '14478'],
        ['2021-03-17T23:43:00+09:00', '14520'],
        ['2021-03-17T23:44:00+09:00', '14536'],
        ['2021-03-17T23:45:00+09:00', '14473'],
        ['2021-03-17T23:46:00+09:00', '14381'],
        ['2021-03-17T23:47:00+09:00', '14447'],
        ['2021-03-17T23:48:00+09:00', '14416'],
        ['2021-03-17T23:49:00+09:00', '14520'],
        ['2021-03-17T23:50:00+09:00', '14349'],
        ['2021-03-17T23:51:00+09:00', '14584'],
        ['2021-03-17T23:52:00+09:00', '14341'],
        ['2021-03-17T23:53:00+09:00', '14578'],
        ['2021-03-17T23:54:00+09:00', '14302'],
        ['2021-03-17T23:55:00+09:00', '14430'],
        ['2021-03-17T23:56:00+09:00', '14277'],
        ['2021-03-17T23:57:00+09:00', '14495'],
        ['2021-03-17T23:58:00+09:00', '14418'],
        ['2021-03-17T23:59:00+09:00', '14339'],
        ['2021-03-18T00:00:00+09:00', '14339'],
      ],
    },
    {
      name: 'Yesterday',
      data: [
        ['2021-03-17T00:00:00+09:00', '4987'],
        ['2021-03-17T00:01:00+09:00', '4363'],
        ['2021-03-17T00:02:00+09:00', '6854'],
        ['2021-03-17T00:03:00+09:00', '5181'],
        ['2021-03-17T00:04:00+09:00', '5344'],
        ['2021-03-17T00:05:00+09:00', '7175'],
        ['2021-03-17T00:06:00+09:00', '7845'],
        ['2021-03-17T00:07:00+09:00', '5698'],
        ['2021-03-17T00:08:00+09:00', '4958'],
        ['2021-03-17T00:09:00+09:00', '7693'],
        ['2021-03-17T00:10:00+09:00', '7591'],
        ['2021-03-17T00:11:00+09:00', '6876'],
        ['2021-03-17T00:12:00+09:00', '7608'],
        ['2021-03-17T00:13:00+09:00', '5413'],
        ['2021-03-17T00:14:00+09:00', '4239'],
        ['2021-03-17T00:15:00+09:00', '4955'],
        ['2021-03-17T00:16:00+09:00', '4058'],
        ['2021-03-17T00:17:00+09:00', '5426'],
        ['2021-03-17T00:18:00+09:00', '6956'],
        ['2021-03-17T00:19:00+09:00', '6501'],
        ['2021-03-17T00:20:00+09:00', '7638'],
        ['2021-03-17T00:21:00+09:00', '6688'],
        ['2021-03-17T00:22:00+09:00', '6524'],
        ['2021-03-17T00:23:00+09:00', '4559'],
        ['2021-03-17T00:24:00+09:00', '7219'],
        ['2021-03-17T00:25:00+09:00', '6421'],
        ['2021-03-17T00:26:00+09:00', '6449'],
        ['2021-03-17T00:27:00+09:00', '4979'],
        ['2021-03-17T00:28:00+09:00', '5549'],
        ['2021-03-17T00:29:00+09:00', '4808'],
        ['2021-03-17T00:30:00+09:00', '7394'],
        ['2021-03-17T00:31:00+09:00', '6545'],
        ['2021-03-17T00:32:00+09:00', '6545'],
        ['2021-03-17T00:33:00+09:00', '5088'],
        ['2021-03-17T00:34:00+09:00', '5807'],
        ['2021-03-17T00:35:00+09:00', '5770'],
        ['2021-03-17T00:36:00+09:00', '7428'],
        ['2021-03-17T00:37:00+09:00', '7832'],
        ['2021-03-17T00:38:00+09:00', '4877'],
        ['2021-03-17T00:39:00+09:00', '4888'],
        ['2021-03-17T00:40:00+09:00', '5810'],
        ['2021-03-17T00:41:00+09:00', '6387'],
        ['2021-03-17T00:42:00+09:00', '6503'],
        ['2021-03-17T00:43:00+09:00', '5353'],
        ['2021-03-17T00:44:00+09:00', '7257'],
        ['2021-03-17T00:45:00+09:00', '4225'],
        ['2021-03-17T00:46:00+09:00', '7353'],
        ['2021-03-17T00:47:00+09:00', '4090'],
        ['2021-03-17T00:48:00+09:00', '6393'],
        ['2021-03-17T00:49:00+09:00', '7695'],
        ['2021-03-17T00:50:00+09:00', '7297'],
        ['2021-03-17T00:51:00+09:00', '5401'],
        ['2021-03-17T00:52:00+09:00', '5111'],
        ['2021-03-17T00:53:00+09:00', '5355'],
        ['2021-03-17T00:54:00+09:00', '7439'],
        ['2021-03-17T00:55:00+09:00', '5132'],
        ['2021-03-17T00:56:00+09:00', '7341'],
        ['2021-03-17T00:57:00+09:00', '5312'],
        ['2021-03-17T00:58:00+09:00', '4534'],
        ['2021-03-17T00:59:00+09:00', '6734'],
        ['2021-03-17T01:00:00+09:00', '4070'],
        ['2021-03-17T01:01:00+09:00', '4145'],
        ['2021-03-17T01:02:00+09:00', '4519'],
        ['2021-03-17T01:03:00+09:00', '6156'],
        ['2021-03-17T01:04:00+09:00', '5225'],
        ['2021-03-17T01:05:00+09:00', '7659'],
        ['2021-03-17T01:06:00+09:00', '6617'],
        ['2021-03-17T01:07:00+09:00', '6108'],
        ['2021-03-17T01:08:00+09:00', '6691'],
        ['2021-03-17T01:09:00+09:00', '7128'],
        ['2021-03-17T01:10:00+09:00', '7569'],
        ['2021-03-17T01:11:00+09:00', '4461'],
        ['2021-03-17T01:12:00+09:00', '7599'],
        ['2021-03-17T01:13:00+09:00', '4612'],
        ['2021-03-17T01:14:00+09:00', '4264'],
        ['2021-03-17T01:15:00+09:00', '7482'],
        ['2021-03-17T01:16:00+09:00', '4619'],
        ['2021-03-17T01:17:00+09:00', '4647'],
        ['2021-03-17T01:18:00+09:00', '5379'],
        ['2021-03-17T01:19:00+09:00', '4953'],
        ['2021-03-17T01:20:00+09:00', '4629'],
        ['2021-03-17T01:21:00+09:00', '4285'],
        ['2021-03-17T01:22:00+09:00', '7539'],
        ['2021-03-17T01:23:00+09:00', '4840'],
        ['2021-03-17T01:24:00+09:00', '5583'],
        ['2021-03-17T01:25:00+09:00', '5394'],
        ['2021-03-17T01:26:00+09:00', '6221'],
        ['2021-03-17T01:27:00+09:00', '6923'],
        ['2021-03-17T01:28:00+09:00', '7954'],
        ['2021-03-17T01:29:00+09:00', '6999'],
        ['2021-03-17T01:30:00+09:00', '7132'],
        ['2021-03-17T01:31:00+09:00', '6666'],
        ['2021-03-17T01:32:00+09:00', '7931'],
        ['2021-03-17T01:33:00+09:00', '7658'],
        ['2021-03-17T01:34:00+09:00', '6497'],
        ['2021-03-17T01:35:00+09:00', '5511'],
        ['2021-03-17T01:36:00+09:00', '4063'],
        ['2021-03-17T01:37:00+09:00', '7784'],
        ['2021-03-17T01:38:00+09:00', '6731'],
        ['2021-03-17T01:39:00+09:00', '6302'],
        ['2021-03-17T01:40:00+09:00', '7318'],
        ['2021-03-17T01:41:00+09:00', '5682'],
        ['2021-03-17T01:42:00+09:00', '6455'],
        ['2021-03-17T01:43:00+09:00', '7232'],
        ['2021-03-17T01:44:00+09:00', '4793'],
        ['2021-03-17T01:45:00+09:00', '6270'],
        ['2021-03-17T01:46:00+09:00', '4973'],
        ['2021-03-17T01:47:00+09:00', '6052'],
        ['2021-03-17T01:48:00+09:00', '7343'],
        ['2021-03-17T01:49:00+09:00', '6560'],
        ['2021-03-17T01:50:00+09:00', '6769'],
        ['2021-03-17T01:51:00+09:00', '6167'],
        ['2021-03-17T01:52:00+09:00', '6527'],
        ['2021-03-17T01:53:00+09:00', '6132'],
        ['2021-03-17T01:54:00+09:00', '7081'],
        ['2021-03-17T01:55:00+09:00', '5008'],
        ['2021-03-17T01:56:00+09:00', '7796'],
        ['2021-03-17T01:57:00+09:00', '7959'],
        ['2021-03-17T01:58:00+09:00', '4405'],
        ['2021-03-17T01:59:00+09:00', '6149'],
        ['2021-03-17T02:00:00+09:00', '5530'],
        ['2021-03-17T02:01:00+09:00', '5203'],
        ['2021-03-17T02:02:00+09:00', '5427'],
        ['2021-03-17T02:03:00+09:00', '7523'],
        ['2021-03-17T02:04:00+09:00', '5335'],
        ['2021-03-17T02:05:00+09:00', '4107'],
        ['2021-03-17T02:06:00+09:00', '4530'],
        ['2021-03-17T02:07:00+09:00', '6330'],
        ['2021-03-17T02:08:00+09:00', '6058'],
        ['2021-03-17T02:09:00+09:00', '7301'],
        ['2021-03-17T02:10:00+09:00', '6331'],
        ['2021-03-17T02:11:00+09:00', '5750'],
        ['2021-03-17T02:12:00+09:00', '5760'],
        ['2021-03-17T02:13:00+09:00', '7547'],
        ['2021-03-17T02:14:00+09:00', '4456'],
        ['2021-03-17T02:15:00+09:00', '7637'],
        ['2021-03-17T02:16:00+09:00', '4820'],
        ['2021-03-17T02:17:00+09:00', '5190'],
        ['2021-03-17T02:18:00+09:00', '7488'],
        ['2021-03-17T02:19:00+09:00', '5871'],
        ['2021-03-17T02:20:00+09:00', '6892'],
        ['2021-03-17T02:21:00+09:00', '4846'],
        ['2021-03-17T02:22:00+09:00', '7554'],
        ['2021-03-17T02:23:00+09:00', '7234'],
        ['2021-03-17T02:24:00+09:00', '5506'],
        ['2021-03-17T02:25:00+09:00', '5827'],
        ['2021-03-17T02:26:00+09:00', '4619'],
        ['2021-03-17T02:27:00+09:00', '5614'],
        ['2021-03-17T02:28:00+09:00', '6211'],
        ['2021-03-17T02:29:00+09:00', '6215'],
        ['2021-03-17T02:30:00+09:00', '4442'],
        ['2021-03-17T02:31:00+09:00', '7563'],
        ['2021-03-17T02:32:00+09:00', '4489'],
        ['2021-03-17T02:33:00+09:00', '7758'],
        ['2021-03-17T02:34:00+09:00', '5321'],
        ['2021-03-17T02:35:00+09:00', '7331'],
        ['2021-03-17T02:36:00+09:00', '4691'],
        ['2021-03-17T02:37:00+09:00', '5464'],
        ['2021-03-17T02:38:00+09:00', '5246'],
        ['2021-03-17T02:39:00+09:00', '5838'],
        ['2021-03-17T02:40:00+09:00', '5451'],
        ['2021-03-17T02:41:00+09:00', '5743'],
        ['2021-03-17T02:42:00+09:00', '4361'],
        ['2021-03-17T02:43:00+09:00', '4578'],
        ['2021-03-17T02:44:00+09:00', '5805'],
        ['2021-03-17T02:45:00+09:00', '7292'],
        ['2021-03-17T02:46:00+09:00', '7046'],
        ['2021-03-17T02:47:00+09:00', '5353'],
        ['2021-03-17T02:48:00+09:00', '5625'],
        ['2021-03-17T02:49:00+09:00', '4067'],
        ['2021-03-17T02:50:00+09:00', '7461'],
        ['2021-03-17T02:51:00+09:00', '5103'],
        ['2021-03-17T02:52:00+09:00', '7132'],
        ['2021-03-17T02:53:00+09:00', '4352'],
        ['2021-03-17T02:54:00+09:00', '4364'],
        ['2021-03-17T02:55:00+09:00', '4762'],
        ['2021-03-17T02:56:00+09:00', '6720'],
        ['2021-03-17T02:57:00+09:00', '7315'],
        ['2021-03-17T02:58:00+09:00', '4413'],
        ['2021-03-17T02:59:00+09:00', '4121'],
        ['2021-03-17T03:00:00+09:00', '7365'],
        ['2021-03-17T03:01:00+09:00', '4464'],
        ['2021-03-17T03:02:00+09:00', '4222'],
        ['2021-03-17T03:03:00+09:00', '7719'],
        ['2021-03-17T03:04:00+09:00', '5929'],
        ['2021-03-17T03:05:00+09:00', '6487'],
        ['2021-03-17T03:06:00+09:00', '6649'],
        ['2021-03-17T03:07:00+09:00', '5783'],
        ['2021-03-17T03:08:00+09:00', '4968'],
        ['2021-03-17T03:09:00+09:00', '7493'],
        ['2021-03-17T03:10:00+09:00', '6559'],
        ['2021-03-17T03:11:00+09:00', '6318'],
        ['2021-03-17T03:12:00+09:00', '7911'],
        ['2021-03-17T03:13:00+09:00', '4604'],
        ['2021-03-17T03:14:00+09:00', '7285'],
        ['2021-03-17T03:15:00+09:00', '6613'],
        ['2021-03-17T03:16:00+09:00', '7208'],
        ['2021-03-17T03:17:00+09:00', '4204'],
        ['2021-03-17T03:18:00+09:00', '7395'],
        ['2021-03-17T03:19:00+09:00', '4363'],
        ['2021-03-17T03:20:00+09:00', '7630'],
        ['2021-03-17T03:21:00+09:00', '5063'],
        ['2021-03-17T03:22:00+09:00', '6423'],
        ['2021-03-17T03:23:00+09:00', '4927'],
        ['2021-03-17T03:24:00+09:00', '5365'],
        ['2021-03-17T03:25:00+09:00', '4046'],
        ['2021-03-17T03:26:00+09:00', '4134'],
        ['2021-03-17T03:27:00+09:00', '4533'],
        ['2021-03-17T03:28:00+09:00', '6263'],
        ['2021-03-17T03:29:00+09:00', '5717'],
        ['2021-03-17T03:30:00+09:00', '5795'],
        ['2021-03-17T03:31:00+09:00', '7826'],
        ['2021-03-17T03:32:00+09:00', '5742'],
        ['2021-03-17T03:33:00+09:00', '5234'],
        ['2021-03-17T03:34:00+09:00', '4945'],
        ['2021-03-17T03:35:00+09:00', '5024'],
        ['2021-03-17T03:36:00+09:00', '6282'],
        ['2021-03-17T03:37:00+09:00', '4338'],
        ['2021-03-17T03:38:00+09:00', '6847'],
        ['2021-03-17T03:39:00+09:00', '5218'],
        ['2021-03-17T03:40:00+09:00', '5548'],
        ['2021-03-17T03:41:00+09:00', '4088'],
        ['2021-03-17T03:42:00+09:00', '7797'],
        ['2021-03-17T03:43:00+09:00', '6722'],
        ['2021-03-17T03:44:00+09:00', '6216'],
        ['2021-03-17T03:45:00+09:00', '6916'],
        ['2021-03-17T03:46:00+09:00', '7930'],
        ['2021-03-17T03:47:00+09:00', '6904'],
        ['2021-03-17T03:48:00+09:00', '6728'],
        ['2021-03-17T03:49:00+09:00', '4929'],
        ['2021-03-17T03:50:00+09:00', '4462'],
        ['2021-03-17T03:51:00+09:00', '7521'],
        ['2021-03-17T03:52:00+09:00', '4218'],
        ['2021-03-17T03:53:00+09:00', '6530'],
        ['2021-03-17T03:54:00+09:00', '7994'],
        ['2021-03-17T03:55:00+09:00', '4379'],
        ['2021-03-17T03:56:00+09:00', '5913'],
        ['2021-03-17T03:57:00+09:00', '4429'],
        ['2021-03-17T03:58:00+09:00', '4405'],
        ['2021-03-17T03:59:00+09:00', '4739'],
        ['2021-03-17T04:00:00+09:00', '6478'],
        ['2021-03-17T04:01:00+09:00', '6173'],
        ['2021-03-17T04:02:00+09:00', '7431'],
        ['2021-03-17T04:03:00+09:00', '6635'],
        ['2021-03-17T04:04:00+09:00', '6884'],
        ['2021-03-17T04:05:00+09:00', '6515'],
        ['2021-03-17T04:06:00+09:00', '7921'],
        ['2021-03-17T04:07:00+09:00', '4063'],
        ['2021-03-17T04:08:00+09:00', '4552'],
        ['2021-03-17T04:09:00+09:00', '6569'],
        ['2021-03-17T04:10:00+09:00', '7189'],
        ['2021-03-17T04:11:00+09:00', '4236'],
        ['2021-03-17T04:12:00+09:00', '7616'],
        ['2021-03-17T04:13:00+09:00', '5373'],
        ['2021-03-17T04:14:00+09:00', '4015'],
        ['2021-03-17T04:15:00+09:00', '7955'],
        ['2021-03-17T04:16:00+09:00', '7729'],
        ['2021-03-17T04:17:00+09:00', '6783'],
        ['2021-03-17T04:18:00+09:00', '6729'],
        ['2021-03-17T04:19:00+09:00', '5293'],
        ['2021-03-17T04:20:00+09:00', '6280'],
        ['2021-03-17T04:21:00+09:00', '7520'],
        ['2021-03-17T04:22:00+09:00', '6760'],
        ['2021-03-17T04:23:00+09:00', '7239'],
        ['2021-03-17T04:24:00+09:00', '7918'],
        ['2021-03-17T04:25:00+09:00', '5871'],
        ['2021-03-17T04:26:00+09:00', '5603'],
        ['2021-03-17T04:27:00+09:00', '6399'],
        ['2021-03-17T04:28:00+09:00', '7187'],
        ['2021-03-17T04:29:00+09:00', '4738'],
        ['2021-03-17T04:30:00+09:00', '6129'],
        ['2021-03-17T04:31:00+09:00', '4430'],
        ['2021-03-17T04:32:00+09:00', '7764'],
        ['2021-03-17T04:33:00+09:00', '5531'],
        ['2021-03-17T04:34:00+09:00', '4364'],
        ['2021-03-17T04:35:00+09:00', '5226'],
        ['2021-03-17T04:36:00+09:00', '5039'],
        ['2021-03-17T04:37:00+09:00', '5517'],
        ['2021-03-17T04:38:00+09:00', '4467'],
        ['2021-03-17T04:39:00+09:00', '5786'],
        ['2021-03-17T04:40:00+09:00', '7526'],
        ['2021-03-17T04:41:00+09:00', '4275'],
        ['2021-03-17T04:42:00+09:00', '6796'],
        ['2021-03-17T04:43:00+09:00', '5155'],
        ['2021-03-17T04:44:00+09:00', '5389'],
        ['2021-03-17T04:45:00+09:00', '7478'],
        ['2021-03-17T04:46:00+09:00', '5223'],
        ['2021-03-17T04:47:00+09:00', '7682'],
        ['2021-03-17T04:48:00+09:00', '6742'],
        ['2021-03-17T04:49:00+09:00', '6663'],
        ['2021-03-17T04:50:00+09:00', '5088'],
        ['2021-03-17T04:51:00+09:00', '5450'],
        ['2021-03-17T04:52:00+09:00', '7989'],
        ['2021-03-17T04:53:00+09:00', '7592'],
        ['2021-03-17T04:54:00+09:00', '5996'],
        ['2021-03-17T04:55:00+09:00', '7203'],
        ['2021-03-17T04:56:00+09:00', '6029'],
        ['2021-03-17T04:57:00+09:00', '4534'],
        ['2021-03-17T04:58:00+09:00', '4582'],
        ['2021-03-17T04:59:00+09:00', '5311'],
        ['2021-03-17T05:00:00+09:00', '4807'],
        ['2021-03-17T05:01:00+09:00', '4104'],
        ['2021-03-17T05:02:00+09:00', '6096'],
        ['2021-03-17T05:03:00+09:00', '6170'],
        ['2021-03-17T05:04:00+09:00', '4562'],
        ['2021-03-17T05:05:00+09:00', '4298'],
        ['2021-03-17T05:06:00+09:00', '7805'],
        ['2021-03-17T05:07:00+09:00', '6131'],
        ['2021-03-17T05:08:00+09:00', '7241'],
        ['2021-03-17T05:09:00+09:00', '5813'],
        ['2021-03-17T05:10:00+09:00', '7341'],
        ['2021-03-17T05:11:00+09:00', '7267'],
        ['2021-03-17T05:12:00+09:00', '6309'],
        ['2021-03-17T05:13:00+09:00', '5746'],
        ['2021-03-17T05:14:00+09:00', '5803'],
        ['2021-03-17T05:15:00+09:00', '7778'],
        ['2021-03-17T05:16:00+09:00', '5482'],
        ['2021-03-17T05:17:00+09:00', '4074'],
        ['2021-03-17T05:18:00+09:00', '7923'],
        ['2021-03-17T05:19:00+09:00', '7393'],
        ['2021-03-17T05:20:00+09:00', '5198'],
        ['2021-03-17T05:21:00+09:00', '7811'],
        ['2021-03-17T05:22:00+09:00', '7462'],
        ['2021-03-17T05:23:00+09:00', '5874'],
        ['2021-03-17T05:24:00+09:00', '6985'],
        ['2021-03-17T05:25:00+09:00', '5305'],
        ['2021-03-17T05:26:00+09:00', '5569'],
        ['2021-03-17T05:27:00+09:00', '7928'],
        ['2021-03-17T05:28:00+09:00', '6933'],
        ['2021-03-17T05:29:00+09:00', '6882'],
        ['2021-03-17T05:30:00+09:00', '5609'],
        ['2021-03-17T05:31:00+09:00', '7402'],
        ['2021-03-17T05:32:00+09:00', '4183'],
        ['2021-03-17T05:33:00+09:00', '6707'],
        ['2021-03-17T05:34:00+09:00', '4987'],
        ['2021-03-17T05:35:00+09:00', '4815'],
        ['2021-03-17T05:36:00+09:00', '5112'],
        ['2021-03-17T05:37:00+09:00', '7115'],
        ['2021-03-17T05:38:00+09:00', '4237'],
        ['2021-03-17T05:39:00+09:00', '7844'],
        ['2021-03-17T05:40:00+09:00', '6507'],
        ['2021-03-17T05:41:00+09:00', '5001'],
        ['2021-03-17T05:42:00+09:00', '5487'],
        ['2021-03-17T05:43:00+09:00', '4429'],
        ['2021-03-17T05:44:00+09:00', '5686'],
        ['2021-03-17T05:45:00+09:00', '7144'],
        ['2021-03-17T05:46:00+09:00', '6660'],
        ['2021-03-17T05:47:00+09:00', '7868'],
        ['2021-03-17T05:48:00+09:00', '7360'],
        ['2021-03-17T05:49:00+09:00', '5195'],
        ['2021-03-17T05:50:00+09:00', '7896'],
        ['2021-03-17T05:51:00+09:00', '7893'],
        ['2021-03-17T05:52:00+09:00', '7778'],
        ['2021-03-17T05:53:00+09:00', '7213'],
        ['2021-03-17T05:54:00+09:00', '4731'],
        ['2021-03-17T05:55:00+09:00', '6016'],
        ['2021-03-17T05:56:00+09:00', '7885'],
        ['2021-03-17T05:57:00+09:00', '5379'],
        ['2021-03-17T05:58:00+09:00', '7238'],
        ['2021-03-17T05:59:00+09:00', '4056'],
        ['2021-03-17T06:00:00+09:00', '6564'],
        ['2021-03-17T06:01:00+09:00', '4650'],
        ['2021-03-17T06:02:00+09:00', '7562'],
        ['2021-03-17T06:03:00+09:00', '7857'],
        ['2021-03-17T06:04:00+09:00', '4601'],
        ['2021-03-17T06:05:00+09:00', '7434'],
        ['2021-03-17T06:06:00+09:00', '7367'],
        ['2021-03-17T06:07:00+09:00', '6533'],
        ['2021-03-17T06:08:00+09:00', '6564'],
        ['2021-03-17T06:09:00+09:00', '5219'],
        ['2021-03-17T06:10:00+09:00', '6405'],
        ['2021-03-17T06:11:00+09:00', '4369'],
        ['2021-03-17T06:12:00+09:00', '6629'],
        ['2021-03-17T06:13:00+09:00', '4037'],
        ['2021-03-17T06:14:00+09:00', '4300'],
        ['2021-03-17T06:15:00+09:00', '5388'],
        ['2021-03-17T06:16:00+09:00', '6040'],
        ['2021-03-17T06:17:00+09:00', '6035'],
        ['2021-03-17T06:18:00+09:00', '4057'],
        ['2021-03-17T06:19:00+09:00', '6178'],
        ['2021-03-17T06:20:00+09:00', '6719'],
        ['2021-03-17T06:21:00+09:00', '7060'],
        ['2021-03-17T06:22:00+09:00', '7146'],
        ['2021-03-17T06:23:00+09:00', '6549'],
        ['2021-03-17T06:24:00+09:00', '7306'],
        ['2021-03-17T06:25:00+09:00', '4882'],
        ['2021-03-17T06:26:00+09:00', '6494'],
        ['2021-03-17T06:27:00+09:00', '5824'],
        ['2021-03-17T06:28:00+09:00', '5639'],
        ['2021-03-17T06:29:00+09:00', '6723'],
        ['2021-03-17T06:30:00+09:00', '4696'],
        ['2021-03-17T06:31:00+09:00', '7310'],
        ['2021-03-17T06:32:00+09:00', '6465'],
        ['2021-03-17T06:33:00+09:00', '6392'],
        ['2021-03-17T06:34:00+09:00', '4566'],
        ['2021-03-17T06:35:00+09:00', '7655'],
        ['2021-03-17T06:36:00+09:00', '4577'],
        ['2021-03-17T06:37:00+09:00', '7919'],
        ['2021-03-17T06:38:00+09:00', '5866'],
        ['2021-03-17T06:39:00+09:00', '5572'],
        ['2021-03-17T06:40:00+09:00', '6261'],
        ['2021-03-17T06:41:00+09:00', '6589'],
        ['2021-03-17T06:42:00+09:00', '6161'],
        ['2021-03-17T06:43:00+09:00', '7038'],
        ['2021-03-17T06:44:00+09:00', '4706'],
        ['2021-03-17T06:45:00+09:00', '6418'],
        ['2021-03-17T06:46:00+09:00', '5971'],
        ['2021-03-17T06:47:00+09:00', '6601'],
        ['2021-03-17T06:48:00+09:00', '7092'],
        ['2021-03-17T06:49:00+09:00', '7657'],
        ['2021-03-17T06:50:00+09:00', '5010'],
        ['2021-03-17T06:51:00+09:00', '6079'],
        ['2021-03-17T06:52:00+09:00', '7363'],
        ['2021-03-17T06:53:00+09:00', '6580'],
        ['2021-03-17T06:54:00+09:00', '6809'],
        ['2021-03-17T06:55:00+09:00', '6306'],
        ['2021-03-17T06:56:00+09:00', '7103'],
        ['2021-03-17T06:57:00+09:00', '4598'],
        ['2021-03-17T06:58:00+09:00', '5679'],
        ['2021-03-17T06:59:00+09:00', '6601'],
        ['2021-03-17T07:00:00+09:00', '7969'],
        ['2021-03-17T07:01:00+09:00', '4044'],
        ['2021-03-17T07:02:00+09:00', '4310'],
        ['2021-03-17T07:03:00+09:00', '5419'],
        ['2021-03-17T07:04:00+09:00', '6166'],
        ['2021-03-17T07:05:00+09:00', '6571'],
        ['2021-03-17T07:06:00+09:00', '6357'],
        ['2021-03-17T07:07:00+09:00', '4074'],
        ['2021-03-17T07:08:00+09:00', '5298'],
        ['2021-03-17T07:09:00+09:00', '6267'],
        ['2021-03-17T07:10:00+09:00', '7442'],
        ['2021-03-17T07:11:00+09:00', '6408'],
        ['2021-03-17T07:12:00+09:00', '5715'],
        ['2021-03-17T07:13:00+09:00', '5350'],
        ['2021-03-17T07:14:00+09:00', '5607'],
        ['2021-03-17T07:15:00+09:00', '7985'],
        ['2021-03-17T07:16:00+09:00', '7105'],
        ['2021-03-17T07:17:00+09:00', '7567'],
        ['2021-03-17T07:18:00+09:00', '4522'],
        ['2021-03-17T07:19:00+09:00', '7909'],
        ['2021-03-17T07:20:00+09:00', '5980'],
        ['2021-03-17T07:21:00+09:00', '6174'],
        ['2021-03-17T07:22:00+09:00', '4927'],
        ['2021-03-17T07:23:00+09:00', '6113'],
        ['2021-03-17T07:24:00+09:00', '7786'],
        ['2021-03-17T07:25:00+09:00', '4588'],
        ['2021-03-17T07:26:00+09:00', '7584'],
        ['2021-03-17T07:27:00+09:00', '4157'],
        ['2021-03-17T07:28:00+09:00', '6033'],
        ['2021-03-17T07:29:00+09:00', '5693'],
        ['2021-03-17T07:30:00+09:00', '6368'],
        ['2021-03-17T07:31:00+09:00', '6761'],
        ['2021-03-17T07:32:00+09:00', '6700'],
        ['2021-03-17T07:33:00+09:00', '5219'],
        ['2021-03-17T07:34:00+09:00', '5994'],
        ['2021-03-17T07:35:00+09:00', '6315'],
        ['2021-03-17T07:36:00+09:00', '5591'],
        ['2021-03-17T07:37:00+09:00', '5009'],
        ['2021-03-17T07:38:00+09:00', '4275'],
        ['2021-03-17T07:39:00+09:00', '6345'],
        ['2021-03-17T07:40:00+09:00', '6901'],
        ['2021-03-17T07:41:00+09:00', '7468'],
        ['2021-03-17T07:42:00+09:00', '4640'],
        ['2021-03-17T07:43:00+09:00', '4794'],
        ['2021-03-17T07:44:00+09:00', '6052'],
        ['2021-03-17T07:45:00+09:00', '7876'],
        ['2021-03-17T07:46:00+09:00', '5225'],
        ['2021-03-17T07:47:00+09:00', '6498'],
        ['2021-03-17T07:48:00+09:00', '4814'],
        ['2021-03-17T07:49:00+09:00', '4574'],
        ['2021-03-17T07:50:00+09:00', '4430'],
        ['2021-03-17T07:51:00+09:00', '4428'],
        ['2021-03-17T07:52:00+09:00', '4848'],
        ['2021-03-17T07:53:00+09:00', '6956'],
        ['2021-03-17T07:54:00+09:00', '4235'],
        ['2021-03-17T07:55:00+09:00', '4309'],
        ['2021-03-17T07:56:00+09:00', '4839'],
        ['2021-03-17T07:57:00+09:00', '7267'],
        ['2021-03-17T07:58:00+09:00', '5821'],
        ['2021-03-17T07:59:00+09:00', '7301'],
        ['2021-03-17T08:00:00+09:00', '7045'],
        ['2021-03-17T08:01:00+09:00', '5319'],
        ['2021-03-17T08:02:00+09:00', '5460'],
        ['2021-03-17T08:03:00+09:00', '7343'],
        ['2021-03-17T08:04:00+09:00', '4334'],
        ['2021-03-17T08:05:00+09:00', '7643'],
        ['2021-03-17T08:06:00+09:00', '5211'],
        ['2021-03-17T08:07:00+09:00', '7126'],
        ['2021-03-17T08:08:00+09:00', '7997'],
        ['2021-03-17T08:09:00+09:00', '6607'],
        ['2021-03-17T08:10:00+09:00', '5044'],
        ['2021-03-17T08:11:00+09:00', '5401'],
        ['2021-03-17T08:12:00+09:00', '7872'],
        ['2021-03-17T08:13:00+09:00', '7156'],
        ['2021-03-17T08:14:00+09:00', '4165'],
        ['2021-03-17T08:15:00+09:00', '7358'],
        ['2021-03-17T08:16:00+09:00', '4294'],
        ['2021-03-17T08:17:00+09:00', '7397'],
        ['2021-03-17T08:18:00+09:00', '4103'],
        ['2021-03-17T08:19:00+09:00', '6323'],
        ['2021-03-17T08:20:00+09:00', '7306'],
        ['2021-03-17T08:21:00+09:00', '5562'],
        ['2021-03-17T08:22:00+09:00', '5890'],
        ['2021-03-17T08:23:00+09:00', '4764'],
        ['2021-03-17T08:24:00+09:00', '6153'],
        ['2021-03-17T08:25:00+09:00', '4470'],
        ['2021-03-17T08:26:00+09:00', '7891'],
        ['2021-03-17T08:27:00+09:00', '6046'],
        ['2021-03-17T08:28:00+09:00', '6555'],
        ['2021-03-17T08:29:00+09:00', '6640'],
        ['2021-03-17T08:30:00+09:00', '5534'],
        ['2021-03-17T08:31:00+09:00', '7748'],
        ['2021-03-17T08:32:00+09:00', '6139'],
        ['2021-03-17T08:33:00+09:00', '7452'],
        ['2021-03-17T08:34:00+09:00', '6841'],
        ['2021-03-17T08:35:00+09:00', '7849'],
        ['2021-03-17T08:36:00+09:00', '6722'],
        ['2021-03-17T08:37:00+09:00', '6062'],
        ['2021-03-17T08:38:00+09:00', '6143'],
        ['2021-03-17T08:39:00+09:00', '4531'],
        ['2021-03-17T08:40:00+09:00', '4228'],
        ['2021-03-17T08:41:00+09:00', '7544'],
        ['2021-03-17T08:42:00+09:00', '5035'],
        ['2021-03-17T08:43:00+09:00', '6545'],
        ['2021-03-17T08:44:00+09:00', '5622'],
        ['2021-03-17T08:45:00+09:00', '4471'],
        ['2021-03-17T08:46:00+09:00', '5492'],
        ['2021-03-17T08:47:00+09:00', '6048'],
        ['2021-03-17T08:48:00+09:00', '5761'],
        ['2021-03-17T08:49:00+09:00', '6661'],
        ['2021-03-17T08:50:00+09:00', '4022'],
        ['2021-03-17T08:51:00+09:00', '4129'],
        ['2021-03-17T08:52:00+09:00', '4576'],
        ['2021-03-17T08:53:00+09:00', '6494'],
        ['2021-03-17T08:54:00+09:00', '6744'],
        ['2021-03-17T08:55:00+09:00', '6236'],
        ['2021-03-17T08:56:00+09:00', '6950'],
        ['2021-03-17T08:57:00+09:00', '4041'],
        ['2021-03-17T08:58:00+09:00', '7356'],
        ['2021-03-17T08:59:00+09:00', '4658'],
        ['2021-03-17T09:00:00+09:00', '5219'],
        ['2021-03-17T09:01:00+09:00', '4124'],
        ['2021-03-17T09:02:00+09:00', '4963'],
        ['2021-03-17T09:03:00+09:00', '4442'],
        ['2021-03-17T09:04:00+09:00', '7320'],
        ['2021-03-17T09:05:00+09:00', '7276'],
        ['2021-03-17T09:06:00+09:00', '6420'],
        ['2021-03-17T09:07:00+09:00', '6272'],
        ['2021-03-17T09:08:00+09:00', '4099'],
        ['2021-03-17T09:09:00+09:00', '5681'],
        ['2021-03-17T09:10:00+09:00', '4106'],
        ['2021-03-17T09:11:00+09:00', '7487'],
        ['2021-03-17T09:12:00+09:00', '5119'],
        ['2021-03-17T09:13:00+09:00', '7132'],
        ['2021-03-17T09:14:00+09:00', '4304'],
        ['2021-03-17T09:15:00+09:00', '4122'],
        ['2021-03-17T09:16:00+09:00', '7700'],
        ['2021-03-17T09:17:00+09:00', '6131'],
        ['2021-03-17T09:18:00+09:00', '7559'],
        ['2021-03-17T09:19:00+09:00', '7398'],
        ['2021-03-17T09:20:00+09:00', '6316'],
        ['2021-03-17T09:21:00+09:00', '5385'],
        ['2021-03-17T09:22:00+09:00', '7978'],
        ['2021-03-17T09:23:00+09:00', '7733'],
        ['2021-03-17T09:24:00+09:00', '6734'],
        ['2021-03-17T09:25:00+09:00', '6468'],
        ['2021-03-17T09:26:00+09:00', '4140'],
        ['2021-03-17T09:27:00+09:00', '5297'],
        ['2021-03-17T09:28:00+09:00', '6065'],
        ['2021-03-17T09:29:00+09:00', '6434'],
        ['2021-03-17T09:30:00+09:00', '5976'],
        ['2021-03-17T09:31:00+09:00', '6576'],
        ['2021-03-17T09:32:00+09:00', '6955'],
        ['2021-03-17T09:33:00+09:00', '7044'],
        ['2021-03-17T09:34:00+09:00', '6357'],
        ['2021-03-17T09:35:00+09:00', '6653'],
        ['2021-03-17T09:36:00+09:00', '6194'],
        ['2021-03-17T09:37:00+09:00', '7009'],
        ['2021-03-17T09:38:00+09:00', '4464'],
        ['2021-03-17T09:39:00+09:00', '5294'],
        ['2021-03-17T09:40:00+09:00', '5079'],
        ['2021-03-17T09:41:00+09:00', '5510'],
        ['2021-03-17T09:42:00+09:00', '4316'],
        ['2021-03-17T09:43:00+09:00', '5050'],
        ['2021-03-17T09:44:00+09:00', '4301'],
        ['2021-03-17T09:45:00+09:00', '6354'],
        ['2021-03-17T09:46:00+09:00', '6868'],
        ['2021-03-17T09:47:00+09:00', '7278'],
        ['2021-03-17T09:48:00+09:00', '7786'],
        ['2021-03-17T09:49:00+09:00', '5098'],
        ['2021-03-17T09:50:00+09:00', '6131'],
        ['2021-03-17T09:51:00+09:00', '7359'],
        ['2021-03-17T09:52:00+09:00', '6404'],
        ['2021-03-17T09:53:00+09:00', '5941'],
        ['2021-03-17T09:54:00+09:00', '6494'],
        ['2021-03-17T09:55:00+09:00', '6649'],
        ['2021-03-17T09:56:00+09:00', '5762'],
        ['2021-03-17T09:57:00+09:00', '4863'],
        ['2021-03-17T09:58:00+09:00', '7031'],
        ['2021-03-17T09:59:00+09:00', '4563'],
        ['2021-03-17T10:00:00+09:00', '5721'],
        ['2021-03-17T10:01:00+09:00', '6919'],
        ['2021-03-17T10:02:00+09:00', '5429'],
        ['2021-03-17T10:03:00+09:00', '6389'],
        ['2021-03-17T10:04:00+09:00', '7659'],
        ['2021-03-17T10:05:00+09:00', '7127'],
        ['2021-03-17T10:06:00+09:00', '4659'],
        ['2021-03-17T10:07:00+09:00', '5912'],
        ['2021-03-17T10:08:00+09:00', '7586'],
        ['2021-03-17T10:09:00+09:00', '4191'],
        ['2021-03-17T10:10:00+09:00', '6199'],
        ['2021-03-17T10:11:00+09:00', '6420'],
        ['2021-03-17T10:12:00+09:00', '5504'],
        ['2021-03-17T10:13:00+09:00', '4260'],
        ['2021-03-17T10:14:00+09:00', '4787'],
        ['2021-03-17T10:15:00+09:00', '7157'],
        ['2021-03-17T10:16:00+09:00', '5425'],
        ['2021-03-17T10:17:00+09:00', '5653'],
        ['2021-03-17T10:18:00+09:00', '7991'],
        ['2021-03-17T10:19:00+09:00', '6993'],
        ['2021-03-17T10:20:00+09:00', '6996'],
        ['2021-03-17T10:21:00+09:00', '5998'],
        ['2021-03-17T10:22:00+09:00', '5001'],
        ['2021-03-17T10:23:00+09:00', '7014'],
        ['2021-03-17T10:24:00+09:00', '4065'],
        ['2021-03-17T10:25:00+09:00', '7284'],
        ['2021-03-17T10:26:00+09:00', '4224'],
        ['2021-03-17T10:27:00+09:00', '7268'],
        ['2021-03-17T10:28:00+09:00', '7668'],
        ['2021-03-17T10:29:00+09:00', '4535'],
        ['2021-03-17T10:30:00+09:00', '7674'],
        ['2021-03-17T10:31:00+09:00', '4762'],
        ['2021-03-17T10:32:00+09:00', '4787'],
        ['2021-03-17T10:33:00+09:00', '5650'],
        ['2021-03-17T10:34:00+09:00', '5890'],
        ['2021-03-17T10:35:00+09:00', '4502'],
        ['2021-03-17T10:36:00+09:00', '4836'],
        ['2021-03-17T10:37:00+09:00', '6677'],
        ['2021-03-17T10:38:00+09:00', '6874'],
        ['2021-03-17T10:39:00+09:00', '6340'],
        ['2021-03-17T10:40:00+09:00', '7078'],
        ['2021-03-17T10:41:00+09:00', '4372'],
        ['2021-03-17T10:42:00+09:00', '4625'],
        ['2021-03-17T10:43:00+09:00', '6007'],
        ['2021-03-17T10:44:00+09:00', '4162'],
        ['2021-03-17T10:45:00+09:00', '6790'],
        ['2021-03-17T10:46:00+09:00', '5463'],
        ['2021-03-17T10:47:00+09:00', '6947'],
        ['2021-03-17T10:48:00+09:00', '6343'],
        ['2021-03-17T10:49:00+09:00', '6875'],
        ['2021-03-17T10:50:00+09:00', '7345'],
        ['2021-03-17T10:51:00+09:00', '4102'],
        ['2021-03-17T10:52:00+09:00', '6473'],
        ['2021-03-17T10:53:00+09:00', '4059'],
        ['2021-03-17T10:54:00+09:00', '4878'],
        ['2021-03-17T10:55:00+09:00', '4211'],
        ['2021-03-17T10:56:00+09:00', '6422'],
        ['2021-03-17T10:57:00+09:00', '7475'],
        ['2021-03-17T10:58:00+09:00', '6109'],
        ['2021-03-17T10:59:00+09:00', '4121'],
        ['2021-03-17T11:00:00+09:00', '6276'],
        ['2021-03-17T11:01:00+09:00', '7018'],
        ['2021-03-17T11:02:00+09:00', '4263'],
        ['2021-03-17T11:03:00+09:00', '4262'],
        ['2021-03-17T11:04:00+09:00', '4521'],
        ['2021-03-17T11:05:00+09:00', '5817'],
        ['2021-03-17T11:06:00+09:00', '7523'],
        ['2021-03-17T11:07:00+09:00', '4162'],
        ['2021-03-17T11:08:00+09:00', '6242'],
        ['2021-03-17T11:09:00+09:00', '6722'],
        ['2021-03-17T11:10:00+09:00', '6887'],
        ['2021-03-17T11:11:00+09:00', '6269'],
        ['2021-03-17T11:12:00+09:00', '6684'],
        ['2021-03-17T11:13:00+09:00', '6615'],
        ['2021-03-17T11:14:00+09:00', '5019'],
        ['2021-03-17T11:15:00+09:00', '5253'],
        ['2021-03-17T11:16:00+09:00', '7207'],
        ['2021-03-17T11:17:00+09:00', '4278'],
        ['2021-03-17T11:18:00+09:00', '7768'],
        ['2021-03-17T11:19:00+09:00', '6004'],
        ['2021-03-17T11:20:00+09:00', '6715'],
        ['2021-03-17T11:21:00+09:00', '7566'],
        ['2021-03-17T11:22:00+09:00', '5686'],
        ['2021-03-17T11:23:00+09:00', '5729'],
        ['2021-03-17T11:24:00+09:00', '7587'],
        ['2021-03-17T11:25:00+09:00', '4747'],
        ['2021-03-17T11:26:00+09:00', '4975'],
        ['2021-03-17T11:27:00+09:00', '6636'],
        ['2021-03-17T11:28:00+09:00', '6253'],
        ['2021-03-17T11:29:00+09:00', '7358'],
        ['2021-03-17T11:30:00+09:00', '6031'],
        ['2021-03-17T11:31:00+09:00', '4079'],
        ['2021-03-17T11:32:00+09:00', '6305'],
        ['2021-03-17T11:33:00+09:00', '7286'],
        ['2021-03-17T11:34:00+09:00', '5516'],
        ['2021-03-17T11:35:00+09:00', '5720'],
        ['2021-03-17T11:36:00+09:00', '4055'],
        ['2021-03-17T11:37:00+09:00', '7114'],
        ['2021-03-17T11:38:00+09:00', '7405'],
        ['2021-03-17T11:39:00+09:00', '7682'],
        ['2021-03-17T11:40:00+09:00', '4198'],
        ['2021-03-17T11:41:00+09:00', '5941'],
        ['2021-03-17T11:42:00+09:00', '5112'],
        ['2021-03-17T11:43:00+09:00', '7736'],
        ['2021-03-17T11:44:00+09:00', '7345'],
        ['2021-03-17T11:45:00+09:00', '5515'],
        ['2021-03-17T11:46:00+09:00', '5541'],
        ['2021-03-17T11:47:00+09:00', '7161'],
        ['2021-03-17T11:48:00+09:00', '7180'],
        ['2021-03-17T11:49:00+09:00', '6416'],
        ['2021-03-17T11:50:00+09:00', '6542'],
        ['2021-03-17T11:51:00+09:00', '5462'],
        ['2021-03-17T11:52:00+09:00', '7684'],
        ['2021-03-17T11:53:00+09:00', '6035'],
        ['2021-03-17T11:54:00+09:00', '7124'],
        ['2021-03-17T11:55:00+09:00', '8512'],
        ['2021-03-17T11:56:00+09:00', '9189'],
        ['2021-03-17T11:57:00+09:00', '9414'],
        ['2021-03-17T11:58:00+09:00', '5482'],
        ['2021-03-17T11:59:00+09:00', '4179'],
      ],
    },
  ],
};
