There have been **five changes** in this major version update.

## 1\. Naming change

TUI (Toast UI) product naming is unified by rule.
The naming of the four areas is changed, please check the changes in the table below.

### Changes

|  | Before | After |
| --- | ------ | ----- |
| Namespace | tui.component.Datepicker | tui.DatePicker |
| Repository name | tui.component.date-picker | tui.date-picker |
| Package name | tui-component-datepicker | tui-date-picker |
| Bundle file's name | tui-component-datepicker | tui-date-picker |

## 2\. APIs change

The API of creating instance of `DatePicker` is changed by naming change.

``` js
// create instance of DatePicker
// before using 'tui.component.Datepicker' namespace
var instance = new tui.DatePicker(selector, options);
```

Also, the API of creating each instance of `Calendar` and `DateRangePicker` is changed.

Previously, using `tui.component` namespace to create instance.

``` js
// create instance of Calendar
var instance = new tui.component.Calendar(selector, options);
```

``` js
// create instance of DateRangePicker
var instance = new tui.component.DateRangePicker(options);
```

Now, It has been changed to call `static` method of `DatePicker` component as follows.

``` js
// create instance of Calendar
var instance = tui.DatePicker.createCalendar(selector, options);
```

``` js
// create instance of DateRangePicker
var instance = tui.DatePicker.createRangePicker(options);
```

You can see the detail information of these events at the [API](https://nhn.github.io/tui.date-picker/3.0.0/) and the [example page](https://nhn.github.io/tui.date-picker/latest/tutorial-example01-basic.html).

## 3\. Separating TimePicker component

The repository of `TimePicker` component is separated.

Using the feature that select time in `DatePicker` component is the same as the previous version.
But you must add the files with reference to the new repository below.

### New repository of TimePicker component

* [https://github.com/nhn/tui.time-picker](https://github.com/nhn/tui.time-picker)

### Files to add

``` html
// browser enviroment
...
<link href="../bower_components/tui-time-picker/dist/tui-time-picker.css" rel="stylesheet">
<link href="../dist/tui-date-picker.css" rel="stylesheet">
...
...
<script type="text/javascript" src="../bower_components/tui-time-picker/dist/tui-time-picker.js"></script>
<script type="text/javascript" src="../dist/tui-date-picker.js"></script>
...
```

## 4\. New branches

The two branches are added on the repository.

* `production` : A branch that contains the bundle file folder(`dist`)
* `develop` : A branch for getting public PR(Pull Request) on develop environment

## 5\. Using npm

The component is registered in [npm](https://www.npmjs.com/package/tui-date-picker).
So, It is possible to develop in the `nodejs` environment.

```
$ npm install tui-date-picker
$ npm install tui-date-picker@<version>
```

You can use the component by calling `require` function as follows, and it is recommended to develop by`CommonJS` method instead of namespace.

``` js
var DatePicker = require('tui-date-picker');
var instance = new DatePicker(options);
```
