## 개요

해당 문서는 TOAST UI Editor 2.0 버전 업데이트에 대한 마이그레이션 가이드로, 1.x 버전을 사용하는 사용자가 2.0 버전으로 업데이트할 때 필요한 모든 변경 사항을 기술한다.

TOAST UI Editor(이하 '에디터'로 표기)는 2.0 버전에서 자체 마크다운 파서 구현, 모노레포 적용, 번들 파일 용량 최적화를 목표로 크고 작은 작업을 진행하였다. 많은 변화가 있었던 만큼, 업데이트 시 주의해야 할 사항들이 많으므로 마이그레이션 가이드의 전체 내용을 숙지하길 바란다. 목차는 다음과 같으며, 실제 적용 시에는 '변경 사항' 항목의 내용을 순서대로 진행하길 권장한다.

## 목차

- 변경 사항
  1. 에디터 사용 방식
  2. 확장 기능(익스텐션 -> 플러그인) 변경
  3. 구문 강조 기능 사용 방식
  4. 다국어(i18n) 파일 분리
  5. jQuery 플러그인 사용 방식
  6. 그 외
- 제거된 기능
  1. Bower 지원 중단
  2. markdown-it 제거
  3. jQuery 제거
  4. 제거된 API 목록

## 변경 사항

### 1. 에디터 사용 방식

이번 메이저 버전 업데이트에서 가장 큰 변화로, 에디터를 사용할 때 필요한 이름 및 의존성 정보가 변경되었다. 앱에서 사용하고 있는 에디터의 버전만 업데이트해서는 안 되며, 아래 변경 사항들을 숙지하여 마이그레이션을 진행해야 한다.

#### 패키지 이름 변경

에디터는 npm과 CDN 두 가지 방식으로 사용할 수 있다. 이때 사용하는 패키지 이름이 변경되었다. 에디터 2.0 버전에서 [스코프드 패키지(Scoped package)](https://docs.npmjs.com/using-npm/scope.html)를 적용하여 다음과 같이 `tui-editor`에서 `@toast-ui/editor`로 패키지 이름이 변경되었다. 아래는 npm 커맨드를 사용한 에디터 설치 예제이다.

**v1.x**

```sh
$ npm install tui-editor
$ npm install tui-editor@<version>
```

**v2.0**

```sh
$ npm install @toast-ui/editor
$ npm install @toast-ui/editor@<version>
```

에디터 1.x 버전은 `tui-editor`, 2.0 이상 버전은 `@toast-ui/editor`로만 사용할 수 있으므로, 특정 버전을 사용해 설치할 때 주의해야 한다. 또한 에디터 중복 사용을 방지하기 위해, 반드시 기존에 설치된 `tui-editor`는 제거한 다음 2.0 버전을 설치해야 한다. 설치가 정상적으로 완료되면 다음과 같이 `package.json` 파일의 의존 정보가 업데이트된다.

```diff
{
  "dependencies": {
-  "tui-editor": "^1.4.10",
+  "@toast-ui/editor": "^2.0.0"
  }
}
```

패키지 이름이 변경되면서 모듈을 가져오는 방식도 변경되었다. 변경된 패키지 이름으로 에디터 모듈을 가져와야 한다.

**v1.x**

```js
const Editor = require('tui-editor'); /* CommonJS 방식 */
```

```js
import Editor from 'tui-editor'; /* ES6 모듈 방식 */
```

**v2.0**

```js
const Editor = require('@toast-ui/editor'); /* CommonJS 방식 */
```

```js
import Editor from '@toast-ui/editor'; /* ES6 모듈 방식 */
```

에디터에서 제공하는 모든 번들 파일(자바스크립트, CSS)은 변경된 패키지 이름이 포함된 경로로 가져와야 한다. 예를 들어, 에디터의 뷰어(Viewer)만 제공하는 번들 파일을 가져올 경우에 `@toast-ui/editor` 이하 경로로 가져온다.

```js
// ...
import Viewer from '@toast-ui/editor/dist/toastui-editor-viewer';
```

#### 네임스페이스 변경

TOAST UI 제품군의 네임스페이스 정책이 변경됨에 따라, 에디터도 2.0 버전부터는 기존에 사용하던 `tui` 대신 `toastui`를 네임스페이스로 사용한다.

브라우저 환경에서 네임스페이스로 에디터를 사용하는 경우, 다음과 같이 변경된 네임스페이스로 에디터 생성자 함수(`toastui.Editor`)를 가져와야 한다.

**v1.x**

```js
const editor = new tui.Editor(/* */);
```

**v2.0**

```js
const editor = new toastui.Editor(/* */);
```

네임스페이스 변경과 관련해 에디터의 번들 파일명 및 CDN 경로 정보도 변경되었는데, 자세한 설명은 아래 내용에서 설명한다.

#### 번들 파일 변경

에디터는 여러 개발 상황을 고려하여 다양한 종류의 번들 파일을 제공하는데, 2.0 버전에서 기능을 분리하고 의존성을 정리하면서 번들 파일 종류가 변경되었다. 개발 환경에 따라서도 파일을 다르게 제공하므로, 아래 내용을 참조해 조건에 맞는 번들 파일을 선택하면 된다. 네임스페이스와 마찬가지로 번들 파일명의 프리픽스도 `tui-`에서 `toastui`로 변경된 것에 유의한다.

아래는 자바스크립트 번들 파일에 대한 변경 정보다.

**v1.x**

> 참고 : https://github.com/nhn/tui.editor/tree/v1.4.10/dist

| 에디터 종류        | 기본 파일                                                | 전체 의존성 모듈 포함 파일  | 최소화 버전(`*.min`) 제공 여부 |
| ------------------ | -------------------------------------------------------- | --------------------------- | ------------------------------ |
| 에디터             | `tui-editor-Editor.js`                                   | `tui-editor-Editor-full.js` | Y                              |
| 뷰어               | `tui-editor-Viewer.js`                                   | `tui-editor-Viewer-full.js` | Y                              |
| 익스텐션 (5종류)   | `tui-editor-ext${ExtensionName}.js`                      | -                           | Y                              |
| 익스텐션 전체 묶음 | `tui-editor-Editor-all.js`<br>`tui-editor-Viewer-all.js` | -                           | Y                              |

**v2.0**

| 에디터 종류 | 기본 파일                        | 전체 의존성 모듈 포함 파일           | 최소화 버전(`*.min`) 제공 여부 |
| ----------- | -------------------------------- | ------------------------------------ | ------------------------------ |
| 에디터      | `toastui-editor.js` (npm만 제공) | `toastui-editor-all.js` (CDN만 제공) | Y                              |
| 뷰어        | `toastui-editor-viewer.js`       | -                                    | Y                              |

에디터 스타일을 적용할 때 필요한 CSS 파일 정보도 변경되었다. 기존에는 에디터 UI와 에디팅 영역에 대한 스타일 파일을 제공했는데, 에디터/뷰어에 따라 사용법이 혼란스러웠다. 2.0 버전에서는 에디터와 뷰어를 구분하여 CSS 파일을 사용할 수 있도록 변경되었다.

**v1.x**

- 에디터 사용

```js
import 'tui-editor/dist/tui-editor.css';
import 'tui-editor/dist/tui-editor-contents.css';
```

- 뷰어 사용

```js
import 'tui-editor/dist/tui-editor.css';
```

**v2.0**

- 에디터 사용

```js
import '@toast-ui/editor/dist/toastui-editor.css';
```

- 뷰어 사용

```js
import '@toast-ui/editor/dist/toastui-editor-viewer.css';
```

제공하는 CSS 파일은 위와 같이 `toastui-editor.css`, `toastui-editor-viewer.css` 두 가지이며, 각각 최소화 버전을 제공한다. npm과 CDN으로 제공되는 파일 종류는 동일하다. 마지막으로 CSS 파일에서 이미지는 상대 경로 대신 Data URI로 변환하여 포함되기 때문에 기존에 제공하던 이미지 파일은 제거되었다.

#### 의존성 정보 변경

에디터 2.0에서는 의존성 모듈들을 정리하였다. CDN을 사용하여 개발하는 경우에는 불필요한 의존성을 제거해야 한다.

이제 에디터 2.0에서 주입해야 할 외부 의존성 모듈은 [CodeMirror](https://codemirror.net/) 뿐으로, 이 경우에도 에디터/뷰어 사용에 따라 상황에 맞는 CDN 파일만 추가하면 된다.

**v1.x**

- [브라우저 개발 환경에서 추가해야 할 의존성 파일 목록](https://github.com/nhn/tui.editor/blob/v1.4.10/docs/getting-started-with-bower.md)

**v2.0**

- 에디터 사용

```html
<head>
  ...
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.48.4/codemirror.min.css"
  />
  ...
</head>
<body>
  ...
  <script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
  ...
</body>
```

- 뷰어 사용

```html
<head>
  ...
</head>
<body>
  ...
  <script src="https://uicdn.toast.com/editor/latest/tui-editor-viewer.min.js"></script>
  ...
</body>
```

### 2. 확장 기능 (익스텐션 -> 플러그인) 변경

에디터 1.x 버전에서는 '익스텐션(Extension)'이라는 이름으로 다양한 확장 기능을 제공하고 있었다. 익스텐션은 기능 면에서 에디터와 분리된 형태로 제공되어야 하며, 불필요하게 번들 파일에 전체 익스텐션의 코드가 포함되는 이슈가 있었다. 이를 해결하기 위해 **2.0 버전에서 '플러그인(Plugin)'으로 명칭과 사용 방법이 변경**되었다. 변경된 사용 방법은 npm과 CDN 사용의 경우로 나누어서 설명하며 각 개발 환경에 맞게 참고하면 된다.

#### npm 사용

기존에 에디터의 확장 기능을 사용하기 위해서는, 에디터의 번들 파일 중 익스텐션과 관련된 파일(`tui-editor-ext${ExtensionName}`)을 추가해 사용했다. 2.0 버전부터는 에디터의 확장 기능들이 npm에 개별 패키지로 등록되므로, 다른 모듈처럼 npm으로 설치하여 사용한다. 다음 예제들은 '차트' 확장 기능을 사용하여 설명한다.

**v1.x**

```js
import 'tui-editor/dist/tui-editor-extChart';
```

**v2.0**

```sh
$ npm install @toast-ui/editor-plugin-chart
```

```js
import chart from '@toast-ui/editor-plugin-chart';
```

확장 기능에 대한 모듈을 추가한 다음에는 에디터의 인스턴스를 생성할 때 옵션을 사용해 확장 기능을 활성화해야 한다. 1.x 버전에서는 `exts` 옵션을 사용하였으나, 2.0 버전부터는 `plugins` 옵션을 사용한다. 옵션명 외 설정값도 변경되었으며, 각 플러그인 모듈이 반환하는 플러그인 함수(`chart`)를 가져와서 옵션값으로 사용한다.

**v1.x**

```js
// ...
import 'tui-editor/dist/tui-editor-extChart';

const editor = new Editor({
  // ...
  exts: ['chart']
});
```

**v2.0**

```js
// ...
import chart from '@toast-ui/editor-plugin-chart';

const editor = new Editor({
  // ...
  plugins: [chart]
});
```

만약 사용하려는 확장 기능에 옵션이 필요한 경우, 옵션값에 다른 타입의 값을 지정하면 된다. 2.0 버전에서는 `plugins` 옵션에 플러그인 함수와 옵션 객체를 배열에 담아 추가한다.

**v1.x**

```js
// ...
import 'tui-editor/dist/tui-editor-extChart';

const options = {
  // ...
};

const editor = new Editor({
  // ...
  exts: [
    {
      name: 'chart',
      ...options
    }
  ]
});
```

**v2.0**

```js
// ...
import chart from '@toast-ui/editor-plugin-chart';

const options = {
  // ...
};

const editor = new Editor({
  // ...
  plugins: [[chart, options]]
});
```

#### CDN 사용

CDN으로 사용할 때 각 확장 기능에 대한 번들 파일을 추가해야 하는데, 이때 사용하는 파일의 CDN 경로가 변경되었다. 기존에는 `tui-editor` 폴더 하위에 익스텐션의 번들 파일이 위치했으나, 2.0 버전부터는 플러그인마다 다른 경로(`editor-plugin-${pluginName}`)에 위치한다.

**v1.x**

```html
<script src="https://uicdn.toast.com/tui-editor/latest/tui-editor-extChart.js"></script>
```

**v2.0**

```html
<script src="https://uicdn.toast.com/editor-plugin-chart/latest/toastui-editor-plugin-chart.js"></script>
```

플러그인을 사용할 때는 `toastui.Editor`에 플러그인 함수를 가져와서 옵션값으로 설정한다.

**v1.x**

```js
const editor = new tui.Editor({
  // ...
  exts: ['chart']
});
```

**v2.0**

```js
const { Editor } = toastui;
const { chart } = Editor.plugin;

const editor = new Editor({
  // ...
  plugins: [chart]
});
```

#### 기본 제공 확장 기능

에디터 1.x 버전에서는 아래와 같이 5개의 익스텐션을 제공했는데, 2.0에서 플러그인으로 변경되면서 일부 확장 기능의 명칭이 변경되거나 제거되었다. `table` 익스텐션은 '셀 병합' 기능을 구체적으로 드러낼 수 있도록 이름이 변경되어 `table-merged-cell` 플러그인으로 제공된다. 그리고 `scrollSync` 익스텐션은 스크롤 싱크 기능이 에디터의 기본 기능으로 내장되어서 별도의 플러그인으로 제공되지 않는다. 그 외에 신규로 추가된 `code-syntax-highlight` 플러그인을 포함해, 에디터 2.0에서는 5개 플러그인을 기본으로 사용할 수 있다.

| 익스텐션 이름 (v1.x) | 플러그인 이름 (v2.0)                                                                                   | 패키지 이름                                                                                                                    | 버전   | 비고      |
| -------------------- | ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------ | ------ | --------- |
| `chart`              | [`chart`](https://github.com/nhn/tui.editor/tree/master/plugins/chart)                                 | [`@toast-ui/editor-plugin-chart`](https://www.npmjs.com/package/@toast-ui/editor-plugin-chart)                                 | v1.0.0 |           |
|                      | [`code-syntax-highlight`](https://github.com/nhn/tui.editor/tree/master/plugins/code-syntax-highlight) | [`@toast-ui/editor-plugin-code-syntax-highlight`](https://www.npmjs.com/package/@toast-ui/editor-plugin-code-syntax-highlight) | v1.0.0 |           |
| `colorSyntax`        | [`color-syntax`](https://github.com/nhn/tui.editor/tree/master/plugins/color-syntax)                   | [`@toast-ui/editor-plugin-color-syntax`](https://www.npmjs.com/package/@toast-ui/editor-plugin-color-syntax)                   | v1.0.0 |           |
| `scrollSync`         |                                                                                                        |                                                                                                                                |        | 제거      |
| `table`              | [`table-merged-cell`](https://github.com/nhn/tui.editor/tree/master/plugins/table-merged-cell)         | [`@toast-ui/editor-plugin-table-merged-cell`](https://www.npmjs.com/package/@toast-ui/editor-plugin-table-merged-cell)         | v1.0.0 | 이름 변경 |
| `uml`                | [`uml`](https://github.com/nhn/tui.editor/tree/master/plugins/uml)                                     | [`@toast-ui/editor-plugin-uml`](https://www.npmjs.com/package/@toast-ui/editor-plugin-uml)                                     | v1.0.0 |           |

새롭게 제공되는 플러그인들에 대한 사용 방법은 이전에 설명했던 것과 동일하며, 각 플러그인에 대한 자세한 정보는 위에 링크된 페이지에서 확인할 수 있다.

#### 사용자 플러그인 사용

에디터에서 기본적으로 제공하는 확장 기능 외, 사용자가 직접 개발한 확장 기능을 추가해 사용할 수 있다. 1.x 버전에서는 스태틱 메서드인 `defineExtension()` API를 사용해 익스텐션 함수를 등록하고 `exts` 옵션에 등록한 익스텐션 함수에 해당하는 키 값을 설정하여 사용했었다.

2.0 버전에서는 `plugins` 옵션을 사용해 플9러그인 함수를 등록하도록 변경되었다. 사용자 플러그인 함수 생성 및 옵션 설정과 관련된 자세한 사용 방법은 [문서](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/plugins.md)를 참고한다.

**v1.x**

```js
import Editor from 'tui-editor';

function customPlugin() {
  // ...
}

Editor.defineExtension('customPlugin', customPlugin);

const editor = new Editor({
  // ...
  exts: ['customPlugin']
});
```

**v2.0**

```js
import Editor from '@toast-ui/editor';

function customPlugin() {
  // ...
}

const editor = new Editor({
  // ...
  plugins: [customPlugin]
});
```

### 3. 구문 강조 기능 사용 방식

에디터는 코드에 대한 구문 강조(Syntax Highlighting) 기능을 제공하며, 2.0 버전부터 이 기능의 사용 방식이 변경되었다. 에디터에서는 [`highlight.js`](https://highlightjs.org/)를 사용하여 구문 강조 기능을 처리하는데, 기본 내장되어 있어 번들 파일 용량이 커지는 문제가 발생했다. 이를 해결하기 위해 2.0 버전에서 구문 강조 기능을 옵셔널하게 사용할 수 있도록 변경되었다.

#### npm 사용

**2.0 버전부터는 구문 강조가 기본 기능에서 제외되었기 때문에, 구문 강조 기능을 사용하려면 `code-syntax-highlight` 플러그인을 설치**해야 한다. 플러그인 기본 사용 방식은 이전 목차에서 설명한 것과 동일하다. `code-syntax-highlight` 플러그인은 `highlight.js` 모듈을 직접 갖고 있지 않기 때문에, `hljs` 옵션을 사용해서 `highlight.js`의 인스턴스를 넘겨주어야 한다. 아래와 같이 사용하면 `highlight.js`에서 제공하는 모든 언어를 사용할 수 있다.

**v2.0**

```sh
$ npm install @toast-ui/editor-plugin-code-syntax-highlight
```

```js
import Editor from '@toast-ui/editor';
import codeSyntaxHighlight from '@toast-ui/editor-plugin-code-syntax-highlight';

import hljs from 'highlight.js';

const editor = new Editor({
  // ...
  plugins: [[codeSyntaxHighlight, { hljs }]]
});
```

특정 언어만 하이라이팅하려는 경우에는 다음과 같이 플러그인과 언어 모듈을 가져와서 사용한다. 1.x 버전에서 사용되던 `codeBlockLanguages` 옵션은 번들링 시에 전체 언어 파일이 포함되는 문제로 인해 제거되고, 다음과 같이 직접 `highlight.js`의 인스턴스를 생성해서 원하는 언어 파일만 설정하는 방식으로 변경되었다.

**v1.x**

```js
const editor = new Editor({
  // ...
  codeBlockLanguages: ['javascript', 'clojure']
});
```

**v2.0**

```js
import Editor from '@toast-ui/editor';
import codeSyntaxHighlight from '@toast-ui/editor-plugin-code-syntax-highlight';

// 1. highlight.js 인스턴스 가져오기
import hljs from 'highlight.js/lib/highlight';

// 2. 하이라이팅 언어 모듈 가져오기
import javascript from 'highlight.js/lib/languages/javascript';
import clojure from 'highlight.js/lib/languages/clojure';

// 3. 하이라이팅 언어 등록하기
hljs.registerLanguage('javascript', javascript);
hljs.registerLanguage('clojure', clojure);

const editor = new Editor({
  // ...
  plugins: [[codeSyntaxHighlight, { hljs }]]
});
```

#### CDN 사용

CDN으로 사용할 때는 추가하는 파일 사용에 주의해야 한다. 플러그인을 사용해 인스턴스를 생성하는 방법은, npm 사용 예제와 동일하다.

`highlight.js`에서 제공하는 언어 파일을 모두 포함하려는 경우, `code-syntax-highlight` 플러그인의 CDN 파일 중 `code-syntax-highlight-all.js`를 추가해야 한다.

```html
<!-- 에디터 번들 파일 -->
<script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
<!-- code-syntax-highlight 플러그인 파일 -->
<script src="https://uicdn.toast.com/editor-plugin-code-syntax-highlight/latest/toastui-editor-plugin-code-syntax-highlight-all.min.js"></script>
```

특정 언어만 사용할 경우에는 `code-syntax-highlight.js` 및 [사용하려는 언어만 번들링한 파일](https://highlightjs.org/download/)을 추가해야 한다.

```html
<!-- 에디터 번들 파일 -->
<script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
<!-- highlight.js 언어 파일 -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.18.1/highlight.min.js"></script>
<!-- code-syntax-highlight 플러그인 파일 -->
<script src="https://uicdn.toast.com/editor-plugin-code-syntax-highlight/latest/toastui-editor-plugin-code-syntax-highlight.min.js"></script>
```

### 4. 다국어(i18n) 파일 분리

현재 에디터에서 지원하는 언어는 총 20개로, 1.x 버전에서는 20개 다국어 파일을 모두 내장하고 있어서 언어가 추가될 때마다 번들 파일의 용량이 같이 증가하는 문제가 있었다. 2.0 버전에서는 필요한 언어만 가져와서 사용할 수 있도록 다국어 파일이 개별 번들 파일로 제공된다.

다국어 파일은 번들 폴더 내 `i18n` 폴더 하위에 위치한다.

- npm으로 제공되는 번들 파일

```
- tui.editor/apps/editor/dist/
  - i18n/
    - ko-kr.js
    - ...
```

- CDN으로 제공되는 번들 파일

```
- uicdn.toast.com/editor/latest/
  - i18n/
    - ko-kr.js
    - ko-kr.min.js
    - ...
```

그리고 인스턴스마다 언어를 다르게 설정할 때 인스턴스 생성 옵션 중 `language`을 사용하는데, 이때 설정하는 언어 코드 값 포맷이 변경되었다. 1.x 버전에서는 언더스코어(`_`)를 사용하였으나, 2.0 버전에서는 [IETF 언어 태그](https://en.wikipedia.org/wiki/IETF_language_tag) 컨벤션에 따라 하이픈(`-`)을 사용한다. 옵션으로 설정할 수 있는 전체 코드 값은 [문서](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/i18n.md#supported-languages)를 참조한다.

**v1.x**

```js
const editor = new Editor({
  // ...
  language: 'ko_KR'
});
```

**v2.0**

```js
const editor = new Editor({
  // ...
  language: 'ko-KR'
});
```

npm과 CDN으로 언어 파일을 사용하는 방법은 다음과 같다.

#### npm 사용

```js
import Editor from '@toast-ui/editor';

// 1. 다국어 파일 가져오기
import '@toast-ui/editor/dist/i18n/ko-kr';
import '@toast-ui/editor/dist/i18n/de-de';

// 2. 언어 설정
const editor = new Editor({
  // ...
  language: 'ko-KR'
});
```

#### CDN 사용

```html
<script src="https://uicdn.toast.com/editor/latest/i18n/ko-kr.js"></script>
<script src="https://uicdn.toast.com/editor/latest/i18n/de-de.js"></script>
...
```

```js
const editor = new toastui.Editor({
  // ...
  language: 'ko-KR'
});
```

다국어 파일 사용과 관련된 더 자세한 설명은 [다국어(i18n) 문서](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/i18n.md)에서 확인할 수 있다.

### 5. jQuery 플러그인 사용 방식

에디터 1.x에서 내장된 형태로 제공되었던 jQuery 플러그인은, 2.0 버전에서 서브 패키지로 분리되고 'jQuery 랩퍼(Wrapper)'로 기능 명칭이 변경되었다. React 랩퍼 또는 Vue 랩퍼처럼 npm으로 설치하여 사용할 수 있다.

#### npm 사용

**v1.x**

- 에디터 사용

```js
import $ from 'jquery';
import Editor from 'tui-editor';

$('#editor').tuiEditor({
  // ...
});
```

- 뷰어 사용

```js
import $ from 'jquery';
import Viewer from 'tui-editor/dist/tui-editor-Viewer.js';

$('#viewer').tuiEditor({
  // ...
});
```

**v2.0**

- 에디터 사용

```sh
$ npm install @toast-ui/jquery-editor
```

```js
import $ from 'jquery';
import '@toast-ui/jquery-editor';

$('#editor').toastuiEditor({
  // ...
});
```

- 뷰어 사용

```sh
$ npm install @toast-ui/jquery-editor
```

```js
import $ from 'jquery';
import '@toast-ui/jquery-editor/dist/toastui-jquery-editor-viewer';

$('#viewer').toastuiEditor({
  // ...
});
```

#### CDN 사용

CDN으로 사용할 때는 jQuery 파일과 에디터/뷰어 사용에 맞는 랩퍼 번들 파일만 추가하면 된다. jQuery 랩퍼로 에디터 인스턴스를 생성하는 방법은, npm 사용 예제와 동일하다.

- 에디터 사용

```html
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://uicdn.toast.com/editor/latest/toastui-jquery-editor.min.js"></script>
```

- 뷰어 사용

```html
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://uicdn.toast.com/editor/latest/toastui-jquery-editor-viewer.min.js"></script>
```

더 자세한 jQuery 랩퍼 사용 방법은 리포지터리에서 확인할 수 있다.

### 6. 그 외

#### CDN 경로 변경

다음과 같이 CDN 경로에서 2뎁스(프로젝트명), 3뎁스(버전) 정보가 변경되었으므로, 2.0 버전의 CDN 파일을 사용할 때 주의해서 사용해야 한다.

- 프로젝트명 : `tui-` 프리픽스 제거
- 버전 : `v` 프리픽스 제거

**v1.x**

```
- uicdn.toast.com/
   ├─ tui-editor/
   │     ├─ latest/
   │     │    ├─ tui-editor-Editor-full.js
   │     │    └─ ...
   │     ├─ v1.4.10/
   │     │    └─ ...
```

```html
<script src="https://uicdn.toast.com/tui-editor/v1.4.10/tui-editor-Editor-full.js"></script>
```

**v2.0**

```
- uicdn.toast.com/
   ├─ editor/
   │     ├─ latest/
   │     │    ├─ toastui-editor-all.js
   │     │    └─ ...
   │     ├─ 2.0.0/
   │     │    └─ ...
   │     └─ ...
   ├─ editor-plugin-${pluginName}/
   │     ├─ latest/
   │     │    └─ ...
   │     ├─ 1.0.0/
   │     │    └─ ...
```

```html
<script src="https://uicdn.toast.com/editor/2.0.0/toastui-editor-all.js"></script>
```

#### 랩퍼 버저닝

에디터 2.0 버전부터 [모노레포(Monorepo)](https://github.com/lerna/lerna)로 관리되기 때문에, React 랩퍼 및 Vue 랩퍼의 버전은 에디터의 배포 버전과 동일하게 업데이트 된다.

## 제거된 기능

### 1. Bower 지원 중단

에디터 2.0 버전부터는 [Bower](https://bower.io/)를 지원하지 않는다. Bower 지원 중단과 함께 깃헙 리포지터리에서 `production` 브랜치도 제거되었다. 기존에 `production` 브랜치의 `dist` 폴더에서 번들 파일을 직접 가져와 사용했던 경우 주의해야 한다. 노드 환경에서 개발을 권장하나, 이전과 같이 Bower를 사용하던 방식으로 개발하고 싶은 경우 CDN을 사용하면 된다.

### 2. markdown-it 제거

에디터 2.0 버전에서 [markdown-it](https://github.com/markdown-it/markdown-it) 의존성 모듈이 제거되었다. markdown-it은 마크다운 파서로, 에디터에서 마크다운 에디터를 위해서 사용되었던 라이브러리였으나 2.0 버전부터 [직접 개발한 커스텀 마크다운 파서(ToastMark)](https://github.com/nhn/tui.editor/tree/master/libs/toastmark)로 대체되었다.

markdown-it이 제거되면서 에디터에서 API로 제공되었던 markdown-it 관련 정적 속성(Static Property)들도 제거되었다. 기존에 이 정적 속성을 사용해 markdown-it을 확장해서 사용하던 기능들은 더이상 사용할 수 없다. 대신 다음 업데이트에서 ToastMark를 확장할 수 있는 API가 추가될 예정이다.

**v1.x**

```js
const editor = new Editor(/* */);

console.log(Editor.markdownit); // MarkdownIt 인스턴스
console.log(Editor.markdownitHighlight); // MarkdownIt 인스턴스
```

**v2.0**

```js
const editor = new Editor(/* */);

console.log(Editor.markdownit); // undefined
console.log(Editor.markdownitHighlight); // undefined
```

### 3. jQuery 제거

에디터 2.0 버전에서 [jQuery](https://jquery.com/) 의존성 모듈이 제거되었다. 기존에 jQuery 파일을 추가하여 사용한 경우, 의존성 파일을 제거해야 한다. npm을 사용하는 경우는 고려하지 않아도 되며, jQuery 랩퍼를 사용하는 경우에도 해당하지 않는다.

또한 커스텀 툴바 버튼을 생성할 때 사용하는 인스턴스 생성 옵션 및 API 옵션에서 jQuery 엘리먼트를 지정했던 옵션명도 변경되었다. `$el`에서 `el`로 변경되었으며, DOM 엘리먼트를 해당 옵션값으로 지정해야 한다.

**v1.x**

```js
const editor = new Editor({
  // ...
  toolbarItems: [
    {
      type: 'button',
      options: {
        $el: $('<button class="my-custom-button"></button>')
        // ...
      }
    }
  ]
});

toolbar.insertItem(0, {
  type: 'button',
  options: {
    $el: $('<button class="your-custom-button"></button>')
    // ...
  }
});
```

**v2.0**

```js
const editor = new Editor({
  // ...
  toolbarItems: [
    {
      type: 'button',
      options: {
        el: document.querySelector('.my-custom-button')
        // ...
      }
    }
  ]
});

toolbar.insertItem(0, {
  type: 'button',
  options: {
    el: document.querySelector('.your-custom-button')
    // ...
  }
});
```

### 4. 제거된 API 목록

마지막으로, 에디터 2.0 버전에서 제거된 API를 정리한 목록이다.

#### 정적 속성

| 이름                  | 타입               |
| --------------------- | ------------------ |
| `Button`              | `{Class.<Button>}` |
| `i18n`                | `{I18n}`           |
| `markdownit`          | `{MarkdownIt}`     |
| `markdownitHighlight` | `{MarkdownIt}`     |

#### 정적 메서드

| 이름              | 타입         | 비고                         |
| ----------------- | ------------ | ---------------------------- |
| `defineExtension` | `{function}` | `plugins` 옵션 사용으로 변경 |

#### 인스턴스 생성 옵션

| 이름                 | 타입                       | 비고                    |
| -------------------- | -------------------------- | ----------------------- |
| `codeBlockLanguages` | `{Array.<string>}`         |                         |
| `exts`               | `{Array.<string\|Object>}` | `plugins` 옵션으로 변경 |
| `previewDelayTime`   | `{string}`                 |

#### 인스턴스 메서드

| 이름       | 타입         |
| ---------- | ------------ |
| `setVaue`  | `{function}` |
| `getValue` | `{function}` |
