## Introduction

The following document is a TOAST UI Editor version 2.0 migration guide that serves to document every change that a user may required when updating from version 1.x to version 2.0.

TOAST UI Editor (henceforth referred to as 'Editor') has been updated with goals of implementation of its own markdown parser, application of monorepo structure, optimization of bundle file size. As a lot has been changed, resulting in numerous items that require the users' attentions during updates, it is recommended that a user thoroughly study the entirety of the migration guide. The table of contents is as listed below, and when applying the update, it is advised to strictly adhere to the order enumerated in 'Changes'.

## Table of Contents

- Changes
  1. Editor Usage
  2. Changes in Extensible Features (Extension -> Plugin)
  3. Syntax Highlighting Feature Usage
  4. Internationalization (i18n) File Separation
  5. jQuery Plugin Usage
  6. Others
- Removed Features
  1. Bower Support Termination
  2. Removal of markdown-it
  3. Removal of jQuery
  4. Removed APIs List

## Changes

### 1. Editor Usage

As one of the biggest part of this major version update, the required naming and dependency information have been changed. It is not enough to update just the version of the editor that is used within the app, and it is required to proceed with the migration with an understanding of the following changes.

#### Package Name Change

The Editor can be used in the following two ways: npm and CDN. The name of the package under both circumstances have been changed. In Editor 2.0, [scoped package](https://docs.npmjs.com/using-npm/scope.html) has been applied to change the name of the package from `tui-editor` to `@toast-ui/editor`.

Below is an example of installing the editor using npm commands.

**v1.x**

```sh
$ npm install tui-editor
$ npm install tui-editor@<version>
```

**v2.0**

```sh
$ npm install @toast-ui/editor
$ npm install @toast-ui/editor@<version>
```

Since Editor version 1.x can be used only with `tui-editor`, and version 2.0 and above can be used only with `@toast-ui/editor`, make sure when installing and using a specific version of the Editor. Furthermore, in order to prevent duplicative uses of the Editor, it is required to uninstall the original `tui-editor` and install the version 2.0. If the installation is successful, the `package.json` file's dependency information will be updated as follows.

```diff
{
  "dependencies": {
-  "tui-editor": "^1.4.10",
+  "@toast-ui/editor": "^2.0.0"
  }
}
```

With the change in the package name, importing the module is also affected. The newly changed package name must be used to import the Editor module.

**v1.x**

```js
const Editor = require('tui-editor'); /* Using CommonJS Syntax */
```

```js
import Editor from 'tui-editor'; /* Using ES6 Syntax */
```

**v2.0**

```js
const Editor = require('@toast-ui/editor'); /* Using CommonJS Syntax */
```

```js
import Editor from '@toast-ui/editor'; /* Using ES6 Syntax */
```

All of the bundle files (JavaScript and CSS) provided by the Editor must be imported using the path that includes the new package name. For example, when using the bundle files solely provided by Viewer, import from the path following `@toast-ui/editor`.

```js
// ...
import Viewer from '@toast-ui/editor/dist/toastui-editor-viewer';
```

#### Namespace Change

According to the changes in TOAST UI products' namespace policy, the Editor version 2.0 will use the `toastui` namespace instead of the original `tui` namespace.

If you are using the Editor in the browser environment, you must import the Editor constructor function (`toastui.Editor`) like the following using the changed namespace.

**v1.x**

```js
const editor = new tui.Editor(/* */);
```

**v2.0**

```js
const editor = new toastui.Editor(/* */);
```

With respect to the namespace changes, the Editor's bundle file names and CDN path information have also changed. Such changes are illustrated in greated detail in following sections.

#### Bundle File Change

Editor provides various bundle files to satisfy diverse development environments. Since version 2.0, the types of bundle files have been changed with reorganization of the features and dependencies. As different bundle files are provided for different development environments, note the following information to select the bundle file that best suits the conditions. Be aware that the prefixes for the bundle names, like namespaces, have been changed from `tui-` to `toastui-`.

Listed below is the changed information regarding the JavaScript bundle file.

**v1.x**

> Note : https://github.com/nhn/tui.editor/tree/v1.4.10/dist

| Editor Type                   | Base File                                                | Complete File with All Dependency Files | Minified Version (`*.min`) Provided |
| ----------------------------- | -------------------------------------------------------- | --------------------------------------- | ----------------------------------- |
| Editor                        | `tui-editor-Editor.js`                                   | `tui-editor-Editor-full.js`             | Y                                   |
| Viewer                        | `tui-editor-Viewer.js`                                   | `tui-editor-Viewer-full.js`             | Y                                   |
| Extensions (5 Types)          | `tui-editor-ext${ExtensionName}.js`                      | -                                       | Y                                   |
| Complete Extension Collection | `tui-editor-Editor-all.js`<br>`tui-editor-Viewer-all.js` | -                                       | Y                                   |

**v2.0**

| Editor Type | Base File                              | Complete File with All Dependency Files    | Minified Version (`*.min`) Provided |
| ----------- | -------------------------------------- | ------------------------------------------ | ----------------------------------- |
| Editor      | `toastui-editor.js` (only through npm) | `toastui-editor-all.js` (only through CDN) | Y                                   |
| Viewer      | `toastui-editor-viewer.js`             | -                                          | Y                                   |

Information regarding the CSS file needed to apply Editor's styles have been changed as well. Originally, a style file was provided to handle Editor UI as well as the editing area, but it was confusing to use with given Editor/Viewers. With v2.0, CSS files are provided separately for the Editor and the Viewer.

**v1.x**

- Using the Editor

```js
import 'tui-editor/dist/tui-editor.css';
import 'tui-editor/dist/tui-editor-contents.css';
```

- Using the Viewer

```js
import 'tui-editor/dist/tui-editor.css';
```

**v2.0**

- Using the Editor

```js
import '@toast-ui/editor/dist/toastui-editor.css';
```

- Using the Viewer

```js
import '@toast-ui/editor/dist/toastui-editor-viewer.css';
```

The provided CSS files are `toastui-editor.css` and `toastui-editor-viewer.css` as shown above, and both are provided as minified versions. The file types provided through npm and CDN are identical. Lastly, images with CSS files are now included as Data URI instead of relative paths, so the originally provided image files have been removed.

#### Dependecy Information Change

Dependency modules have been reorganized in Editor 2.0. When using the CDN for development, unnecessary dependencies must be removed.

Now, the only external dependency module needed for Editor 2.0 is the [CodeMirror](https://codemirror.net/), and even this can be included as a CDN file situationally with respect to Editor/Viewer usage.

**v1.x**

- [List of Dependencies Needed for Browser Development Environment](https://github.com/nhn/tui.editor/blob/v1.4.10/docs/getting-started-with-bower.md)

**v2.0**

- Using the Editor

```html
<head>
  ...
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.48.4/codemirror.min.css"
  />
  ...
</head>
<body>
  ...
  <script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
  ...
</body>
```

- Using the Viewer

```html
<head>
  ...
</head>
<body>
  ...
  <script src="https://uicdn.toast.com/editor/latest/toastui-editor-viewer.min.js"></script>
  ...
</body>
```

### 2. Changes in Extensible Features (Extension -> Plugin)

In Editor v1.x, diverse extensible features were provided under the 'Extension' paradigm. Extensions, in terms of functionalities, had to be provided separately from the Editor, and had to be unnecessarily included in the bundle. In order to address the issue, in **v2.0, such features will be newly implemented as 'Plugins,' and there have been changes in its usages as well.** The changes will be explained separately for npm and CDN, and users can refer to the appropriate sections.

#### Using npm

In order to use the original Editor, users had to include the file related to the extension (`tui-editor-ext${ExtensionName}`) from the Editor's bundle file. From v2.0, Editor's extensible features will simply be registered on the npm by individual packages, so it can be used as other modules by installing it from the npm. The following examples will be explained using the 'chart' feature.

**v1.x**

```js
import 'tui-editor/dist/tui-editor-extChart';
```

**v2.0**

```sh
$ npm install @toast-ui/editor-plugin-chart
```

```js
import chart from '@toast-ui/editor-plugin-chart';
```

The module that contains the extensible feature must be included, and then, the the feature must be activated through the options during the process of creating the Editor's instance. In v1.x, the option `exts` was used, but from v2.0, the option `plugins` will be used. Aside from the option name, the set value has also changed, and the plugin functions (`chart` in this case,) returned from the plugin module, will be used as the option value.

**v1.x**

```js
// ...
import 'tui-editor/dist/tui-editor-extChart';

const editor = new Editor({
  // ...
  exts: ['chart']
});
```

**v2.0**

```js
// ...
import chart from '@toast-ui/editor-plugin-chart';

const editor = new Editor({
  // ...
  plugins: [chart]
});
```

If the extensible feature requires additional options, it can be achieved by designating a different type value in place of the option value. In v2.0, the option `plugins` takes the plugin functions and the option objects in an array.

**v1.x**

```js
// ...
import 'tui-editor/dist/tui-editor-extChart';

const options = {
  // ...
};

const editor = new Editor({
  // ...
  exts: [
    {
      name: 'chart',
      ...options
    }
  ]
});
```

**v2.0**

```js
// ...
import chart from '@toast-ui/editor-plugin-chart';

const options = {
  // ...
};

const editor = new Editor({
  // ...
  plugins: [[chart, options]]
});
```

#### Using CDN

When using the Editor through the CDN, a separate bundle for each extensible feature must be included, and this file's CDN path has also changed. Originally, the extension bundle files were located under the `tui-editor` folder, but from v2.0, different plugins will be located under different folders by the path that follows (`editor-plugin-${pluginName}`).

**v1.x**

```html
<script src="https://uicdn.toast.com/tui-editor/latest/tui-editor-extChart.js"></script>
```

**v2.0**

```html
<script src="https://uicdn.toast.com/editor-plugin-chart/latest/toastui-editor-plugin-chart.js"></script>
```

When using plugins, set the plugin function to be the `toastui.Editor`'s option value.

**v1.x**

```js
const editor = new tui.Editor({
  // ...
  exts: ['chart']
});
```

**v2.0**

```js
const { Editor } = toastui;
const { chart } = Editor.plugin;

const editor = new Editor({
  // ...
  plugins: [chart]
});
```

#### Originally Provided Extensible Features

In Editor v1.x, the following five extensions were provided, but as extensions were changed to plugins in v2.0, some originally provided extensible features were either renamed or removed. The `table` extension has been renamed to better reflect the 'cell merge' feature to `table-merged-cell` plugin. Secondly, the `scrollSync` extension has been implemented as a default functionality in the Editor v2.0 so, the extension has been removed. In Editor v2.0, total of five plugins, including the newly introduced `code-syntax-highlight` plugin can be used as defaults.

| Extension Name (v1.x) | Plugin Name (v2.0)                                                                                     | Package Name                                                                                                                   | Version | Note    |
| --------------------- | ------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------ | ------- | ------- |
| `chart`               | [`chart`](https://github.com/nhn/tui.editor/tree/master/plugins/chart)                                 | [`@toast-ui/editor-plugin-chart`](https://www.npmjs.com/package/@toast-ui/editor-plugin-chart)                                 | v1.0.0  |         |
|                       | [`code-syntax-highlight`](https://github.com/nhn/tui.editor/tree/master/plugins/code-syntax-highlight) | [`@toast-ui/editor-plugin-code-syntax-highlight`](https://www.npmjs.com/package/@toast-ui/editor-plugin-code-syntax-highlight) | v1.0.0  |         |
| `colorSyntax`         | [`color-syntax`](https://github.com/nhn/tui.editor/tree/master/plugins/color-syntax)                   | [`@toast-ui/editor-plugin-color-syntax`](https://www.npmjs.com/package/@toast-ui/editor-plugin-color-syntax)                   | v1.0.0  |         |
| `scrollSync`          |                                                                                                        |                                                                                                                                |         | Removed |
| `table`               | [`table-merged-cell`](https://github.com/nhn/tui.editor/tree/master/plugins/table-merged-cell)         | [`@toast-ui/editor-plugin-table-merged-cell`](https://www.npmjs.com/package/@toast-ui/editor-plugin-table-merged-cell)         | v1.0.0  | Renamed |
| `uml`                 | [`uml`](https://github.com/nhn/tui.editor/tree/master/plugins/uml)                                     | [`@toast-ui/editor-plugin-uml`](https://www.npmjs.com/package/@toast-ui/editor-plugin-uml)                                     | v1.0.0  |         |

Newly introduced plugins and its use are as explained in the previous sections, and detailed information about each plugin can be found in the provided links above.

#### Using Custom Plugins

Users can choose to use custom plugins that they have developed aside from the default provided plugins. With v1.x, you had to use the static method `defineExtension()` API to register an extension function and configure a key value that corresponds to the registered extension function to the `exts` option.

In v2.0, the `plugins` option can be used to register a plugin function. Refer to this [document](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/plugins.md) for more information regarding building custom plugin functions and its related options configuration.

**v1.x**

```js
import Editor from 'tui-editor';

function customPlugin() {
  // ...
}

Editor.defineExtension('customPlugin', customPlugin);

const editor = new Editor({
  // ...
  exts: ['customPlugin']
});
```

**v2.0**

```js
import Editor from '@toast-ui/editor';

function customPlugin() {
  // ...
}

const editor = new Editor({
  // ...
  plugins: [customPlugin]
});
```

### 3. Syntax Highlighting Feature Usage

Editor offers a syntax highlighting feature, and from v2.0, its usage has been updated. The syntax highlighting feature is implemented through the [`highlight.js`](https://highlightjs.org/), and because it was included as a default, it increased the bundle size. In order to address this issue, from v2.0, this feature has been made optional.

#### Using npm

**Because from v2.0, the syntax highlighting feature has been removed from the default features list, in order to use the feature, the `code-syntax-highlight` plugin must be installed.** Using the plugin is as explained in the previous section. Because the `code-syntax-highlight` plugin does not contain the `highlight.js` module entirely, the `hljs` option must be used to pass the `highlight.js` instance. By following the steps shown below, user can access every language provided by the `highlight.js`.

**v2.0**

```sh
$ npm install @toast-ui/editor-plugin-code-syntax-highlight
```

```js
import Editor from '@toast-ui/editor';
import codeSyntaxHighlight from '@toast-ui/editor-plugin-code-syntax-highlight';

import hljs from 'highlight.js';

const editor = new Editor({
  // ...
  plugins: [[codeSyntaxHighlight, { hljs }]]
});
```

If only a certain language needs to be highlighted, import the plugin and the language module like the following. The `codeBlockLanguages` option used in v1.x has been removed because of the problem that included the entire language file when bundling. Now, the user can directly create the `highlight.js` instance in order to configure the desired languages.

**v1.x**

```js
const editor = new Editor({
  // ...
  codeBlockLanguages: ['javascript', 'clojure']
});
```

**v2.0**

```js
import Editor from '@toast-ui/editor';
import codeSyntaxHighlight from '@toast-ui/editor-plugin-code-syntax-highlight';

// 1. Importing the highlight.js instance
import hljs from 'highlight.js/lib/highlight';

// 2. Importing the highlighting language modules
import javascript from 'highlight.js/lib/languages/javascript';
import clojure from 'highlight.js/lib/languages/clojure';

// 3. Registering highlighting languages
hljs.registerLanguage('javascript', javascript);
hljs.registerLanguage('clojure', clojure);

const editor = new Editor({
  // ...
  plugins: [[codeSyntaxHighlight, { hljs }]]
});
```

#### Using CDN

When using the CDN, users must be careful if also using additional files. The method of creating the instance using the plugin is identical to using npm.

When trying to include all language files provided by the `highlight.js`, user must choose the `code-syntax-highlight-all` from the `code-syntax-highlight` plugin CDN files.

```html
<!--Editor Bundle File-->
<script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
<!-- code-syntax-highlight Plugin File-->
<script src="https://uicdn.toast.com/editor-plugin-code-syntax-highlight/latest/toastui-editor-plugin-code-syntax-highlight-all.min.js"></script>
```

If only using a specific language, user must include the `code-syntax-highlight.js` as well as the [specific bundle file for the language](https://highlightjs.org/download/).

```html
<!--Editor Bundle File-->
<script src="https://uicdn.toast.com/editor/latest/toastui-editor-all.min.js"></script>
<!--highlight.js Language File-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.18.1/highlight.min.js"></script>
<!-- code-syntax-highlight Plugin File-->
<script src="https://uicdn.toast.com/editor-plugin-code-syntax-highlight/latest/toastui-editor-plugin-code-syntax-highlight.min.js"></script>
```

### 4. Internationalization (i18n) File Separation

Currently, the Editor supports a total of twenty different languages, and in v1.x, Editor had a problem of increasing size as all twenty internationalization files were included in the bundle as a default. From v2.0, the internationalization files will be provided as separate files so that users can choose which languages to use.

Internationalization files are located under the bundle file's `i18n` folder.

- Bundle files provided through the npm

```
- tui.editor/apps/editor/dist/
  - i18n/
    - ko-kr.js
    - ...
```

- Bundle files provided through the CDN

```
- uicdn.toast.com/editor/latest/
  - i18n/
    - ko-kr.js
    - ko-kr.min.js
    - ...
```

The `language` option is used whenever the instance language is configured differently, and this language tag format has been changed. In v1.x, the underscores (`_`) were used, but from v2.0, the hyphen (`-`) will be used in accordance to the [IETF Language Tag](https://en.wikipedia.org/wiki/IETF_language_tag). For all of the language tags available for the option configuration, refer to this [document](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/i18n.md#supported-languages).

**v1.x**

```js
const editor = new Editor({
  // ...
  language: 'ko_KR'
});
```

**v2.0**

```js
const editor = new Editor({
  // ...
  language: 'ko-KR'
});
```

Using the language files through npm and CDN are as shown below.

#### Using npm

```js
import Editor from '@toast-ui/editor';

// 1. Importing internationalization files
import '@toast-ui/editor/dist/i18n/ko-kr';
import '@toast-ui/editor/dist/i18n/de-de';

// 2. Language Configuration
const editor = new Editor({
  // ...
  language: 'ko-KR'
});
```

#### Using CDN

```html
<script src="https://uicdn.toast.com/editor/latest/i18n/ko-kr.js"></script>
<script src="https://uicdn.toast.com/editor/latest/i18n/de-de.js"></script>
...
```

```js
const editor = new toastui.Editor({
  // ...
  language: 'ko-KR'
});
```

More detailed explanation regarding the internationalization files can be found in the [Internationalization (i18n) Document](https://github.com/nhn/tui.editor/blob/master/apps/editor/docs/i18n.md).

### 5. jQuery Plugin Usage

The internal jQuery plugin that was used included in Editor v1.x has been separated as a subpackage in v2.0, and has been renamed to `jQuery Wrapper`. It can be installed through npm and can be used like a React or a Vue wrapper.

#### Using npm

**v1.x**

- Using the Editor

```js
import $ from 'jquery';
import Editor from 'tui-editor';

$('#editor').tuiEditor({
  // ...
});
```

- Using the Viewer

```js
import $ from 'jquery';
import Viewer from 'tui-editor/dist/tui-editor-Viewer.js';

$('#viewer').tuiEditor({
  // ...
});
```

**v2.0**

- Using the Editor

```sh
$ npm install @toast-ui/jquery-editor
```

```js
import $ from 'jquery';
import '@toast-ui/jquery-editor';

$('#editor').toastuiEditor({
  // ...
});
```

- Using the Viewer

```sh
$ npm install @toast-ui/jquery-editor
```

```js
import $ from 'jquery';
import '@toast-ui/jquery-editor/dist/toastui-jquery-editor-viewer';

$('#viewer').toastuiEditor({
  // ...
});
```

#### Using CDN

When using CDN, it is enough to include the jQuery files and the corresponding wrapper bundle. The method of creating the Editor instance using jQuery wrapper is identical as explained in the using npm section.

- Using the Editor

```html
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://uicdn.toast.com/editor/latest/toastui-jquery-editor.min.js"></script>
```

- Using the Viewer

```html
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://uicdn.toast.com/editor/latest/toastui-jquery-editor-viewer.min.js"></script>
```

More detailed information regarding jQuery wrapper usage can be found in the repository.

### 6. Others

#### CDN Path Change

The information regarding the project name (second depth) and the version (third depth) information has bee changed, so pay necessary caution when using the v2.0 CDN files.

**v1.x**

```
- uicdn.toast.com/
   ├─ tui-editor/
   │     ├─ latest/
   │     │    ├─ tui-editor-Editor-full.js
   │     │    └─ ...
   │     ├─ v1.4.10/
   │     │    └─ ...
```

```html
<script src="https://uicdn.toast.com/tui-editor/v1.4.10/tui-editor-Editor-full.js"></script>
```

**v2.0**

```
- uicdn.toast.com/
   ├─ editor/
   │     ├─ latest/
   │     │    ├─ toastui-editor-all.js
   │     │    └─ ...
   │     ├─ 2.0.0/
   │     │    └─ ...
   │     └─ ...
   ├─ editor-plugin-${pluginName}/
   │     ├─ latest/
   │     │    └─ ...
   │     ├─ 1.0.0/
   │     │    └─ ...
```

```html
<script src="https://uicdn.toast.com/editor/2.0.0/toastui-editor-all.js"></script>
```

#### Wrapper Version Control

Since the Editor will be managed as a [Monorepo](https://github.com/lerna/lerna) structure, React and Vue wrappers versions will be updated in accordance to the Editor's version distribution.

## Removed Features

### 1. Bower Support Termination

The Editor v2.0 will no longer support [Bower](https://bower.io/). With the termination of Bower support, the `production` branch on the Github Repository has been removed as well. Pay necessary precaution when using the bundle file directly from the `production` branch's `dist` folder. While development in the Node environment is encouraged, CDN can be used to continue developing in a way that was used to develop using Bower.

### 2. Removal of markdown-it

From Editor v2.0, the [markdown-it](https://github.com/markdown-it/markdown-it) dependency module has been removed. While markdown-it, a markdown parser library, was used as the markdown editor for the Editor, [ToastMark, our own markdown parser](https://github.com/nhn/tui.editor/tree/master/libs/toastmark), will be used from v2.0.

With the removal of markdown-it, the static properties related to markdown-it provided by the Editor as APIs have been removed as well. The previous features that used such static properties to extend the markdown-it are no longer available. Instead, the next update will include APIs that can extend upon the ToastMark.

**v1.x**

```js
const editor = new Editor(/* */);

console.log(Editor.markdownit); // MarkdownIt Instance
console.log(Editor.markdownitHighlight); // MarkdownIt Instance
```

**v2.0**

```js
const editor = new Editor(/* */);

console.log(Editor.markdownit); // undefined
console.log(Editor.markdownitHighlight); // undefined
```

### 3. Removal of jQuery

Starting from Editor v2.0, [jQuery](https://jquery.com/) dependency modules have been removed. If a user used jQuery with the Editor, the dependency files must be removed. This change does not matter if using the npm, and it also does not matter if using the jQuery wrapper.

Furthermore, the names of instance constructor option and option used to select jQuery elements from the API option that was used when creating the custom toolbar buttons were changed. They were changed from `$el` to `el`, and the DOM element must be set to be the corresponding option.

**v1.x**

```js
const editor = new Editor({
  // ...
  toolbarItems: [
    {
      type: 'button',
      options: {
        $el: $('<button class="my-custom-button"></button>')
        // ...
      }
    }
  ]
});

toolbar.insertItem(0, {
  type: 'button',
  options: {
    $el: $('<button class="your-custom-button"></button>')
    // ...
  }
});
```

**v2.0**

```js
const editor = new Editor({
  // ...
  toolbarItems: [
    {
      type: 'button',
      options: {
        el: document.querySelector('.my-custom-button')
        // ...
      }
    }
  ]
});

toolbar.insertItem(0, {
  type: 'button',
  options: {
    el: document.querySelector('.your-custom-button')
    // ...
  }
});
```

### 4. Removed APIs List

Finally, the following is a list of APIs that have been removed from the Editor v2.0

#### Static Properties

| Name                  | Type               |
| --------------------- | ------------------ |
| `Button`              | `{Class.<Button>}` |
| `i18n`                | `{I18n}`           |
| `markdownit`          | `{MarkdownIt}`     |
| `markdownitHighlight` | `{MarkdownIt}`     |

#### Static Method

| Name              | Type         | Note                                  |
| ----------------- | ------------ | ------------------------------------- |
| `defineExtension` | `{function}` | changed to using the `plugins` option |

#### Instance Constructor Options

| Name                 | Type                       | Note                 |
| -------------------- | -------------------------- | -------------------- |
| `codeBlockLanguages` | `{Array.<string>}`         |                      |
| `exts`               | `{Array.<string\|Object>}` | Renamed as `plugins` |
| `previewDelayTime`   | `{string}`                 |

#### Instance Method

| Name       | Type         |
| ---------- | ------------ |
| `setVaue`  | `{function}` |
| `getValue` | `{function}` |
