# 🌏 국제화 (i18n)

TOASE UI Editor는 다양한 언어로 UI의 텍스트를 설정할 수 있는 기능을 제공한다. 기본적으로 제공되는 언어 파일이 있으며, 인스턴스를 만들 때 이 파일들을 가져와 사용할 언어를 설정할 수 있다.

## 파일 구조

### 소스 파일 (기여 용)

[기본으로 지원하는 언어](#supported-languages) 외에 언어 파일을 추가하려면 아래 경로에 추가해야 한다. 기여 프로세스에 대한 자세한 내용은 [기여](#contributing) 섹션을 참조 바란다.

```
- tui.editor/apps/editor/src/
  - i18n/
    - en-us.ts
    - ko-kr.ts
    - ...
```

### 빌드 (메인테이너 용)

```
- tui.editor/apps/editor/dist/
  - i18n/
    - ko-kr.js
    - ...
```

### npm에 배포된 파일 구조

```
- node_modules/@toast-ui/editor/dist/
  - i18n/
    - ko-kr.js
    - ...
```

### CDN에 배포된 파일 구조

```
- uicdn.toast.com/editor/latest/
  - i18n/
    - ko-kr.js
    - ko-kr.min.js
    - ...
```

## 지원 언어

아래는 TOAST UI Editor에서 제공하는 i18n 파일의 언어 코드 표다. 이 언어 코드는 [IETF 언어 태그](https://en.wikipedia.org/wiki/IETF_language_tag)를 기반으로 한다. 언어 파일을 가져오면 자동으로 언어 코드가 등록되고 옵션으로 사용할 언어를 설정할 수 있다.

> 참고 : 기본 설정 언어는 영어이므로 `en-us.js` 언어 파일을 가져올 필요가 없다.

| 언어명              | i18n 파일 | 등록 코드 |
| -------------------------- | --------- | --------------- |
| Arabic                     | ar.js     | `ar`            |
| Chinese (S)                | zh-cn.js  | `zh-CN`         |
| Chinese (T)                | zh-tw.js  | `zh-TW`         |
| Croatian (Croatia)         | hr-hr.js  | `hr` \| `hr-HR` |
| Czech (Czech Republic)     | cs-cz.js  | `cs` \| `cs-CZ` |
| Dutch (Netherlands)        | nl-nl.js  | `nl` \| `nl-NL` |
| English (United States)    | en-us.js  | `en` \| `en-US` |
| Finnish (Finland)          | fi-fi.js  | `fi` \| `fi-FI` |
| French (France)            | fr-fr.js  | `fr` \| `fr-FR` |
| Galician (Spain)           | gl-es.js  | `gl` \| `gl-ES` |
| German (Germany)           | de-de.js  | `de` \| `de-DE` |
| Italian (Italy)            | it-it.js  | `it` \| `it-IT` |
| Japanese (Japan)           | ja-jp.js  | `ja` \| `ja-JP` |
| Korean (Korea)             | ko-kr.js  | `ko` \| `ko-KR` |
| Norwegian Bokmål (Norway)  | nb-no.js  | `nb` \| `nb-NO` |
| Polish (Poland)            | pl-pl.js  | `pl` \| `pl-PL` |
| Portuguese (Brazil)        | pt-br.js  | `pt` \| `pt-BR` |
| Russian (Russia)           | ru-ru.js  | `ru` \| `ru-RU` |
| Spanish (Castilian, Spain) | es-es.js  | `es` \| `es-ES` |
| Swedish (Sweden)           | sv-se.js  | `sv` \| `sv-SE` |
| Turkish (Turkey)           | tr-tr.js  | `tr` \| `tr-TR` |
| Ukrainian (Ukraine)        | uk-ua.js  | `uk` \| `uk-UA` |

## 언어 파일 가져오기

사용할 언어 파일을 가져와 언어를 등록해야 한다. `${fileName}`은 [지원 언어](#supported-languages)의 'i18n 파일' 컬럼에 해당한다 (확장자 없이 사용할 수 있음).

### ES 모듈

```js
import '@toast-ui/editor/dist/i18n/${fileName}';
```

### CommonJS

```js
require('@toast-ui/editor/dist/i18n/${fileName}');
```

### CDN

CDN에서는 각 언어 파일 별로 최소화 처리한 파일도 제공한다.

```html
<script src="https://uicdn.toast.com/editor/latest/i18n/${fileName}"></script>
```

## 사용하기

> 참고 : npm 사용을 기반으로 설명한다.

### 사용 사례 1 : 기본 사용

특정 언어를 설정하려면 `language` 옵션을 사용하여 에디터 인스턴스를 만들어야 한다. 이 옵션의 값은 [지원 언어](#supported-languages)의 '등록 코드' 컬럼에 해당한다. 기본값은 `en`과 `en-US`다.

```js
import Editor from '@toast-ui/editor';

// 1단계 : 언어 파일을 가져온다.
import '@toast-ui/editor/dist/i18n/ko-kr';

// 2딘계 : 각 에디터에 언어를 설정한다.
const foo = new Editor({
  // 기본 언어 사용(영어)
  // ...
});

const bar = new Editor({
  // 다른 언어 사용(한국어)
  // ...
  language: 'ko-KR',
});
```

### 사용 사례 2 : 언어 값 재정의

`setLanguage` 정적 메서드를 사용하여 특정 언어 코드에 대한 값을 재정의할 수 있다. 기본값은 [여기](https://github.com/nhn/tui.editor/tree/master/apps/editor/src/i18n/en-us.ts)를 참조 바란다.

```js
import Editor from '@toast-ui/editor';

// 1단계 : 언어 파일을 가져온다.
import '@toast-ui/editor/dist/i18n/ko-kr';

// 2단계 : 언어 값을 재정의한다.
Editor.setLanguage('en-US', {
  'Add row': '[Add Row]', // 기본값은 'Add row'이다.
});

Editor.setLanguage('ko-KR', {
  'Add row': '[로우 추가]', // 기본값은 '행 추가'이다.
});

// 3단계 : 각 에디터에 언어를 설정한다.
const foo = new Editor({
  // 기본 언어 사용(영어)
  // ...
});

const bar = new Editor({
  // 다른 언어 사용(한국어)
  // ...
  language: 'ko-KR',
});
```

### 사용 사례 3 : 새로운 언어 등록

사용할 언어가 기본적으로 제공되지 않는 경우 `setLanguage` 정적 메서드를 사용하여 등록할 수 있다.

```js
import Editor from '@toast-ui/editor';

// 1단계 : 새로운 언어를 등록한다.
Editor.setLanguage('en-GB', {
  Markdown: '...',
  WYSIWYG: '...',
  // ...
});

// 2단계 : 새로 등록한 언어를 설정한다.
const bar = new Editor({
  // ...
  language: 'en-GB',
});
```

## 기여

다른 언어 파일을 제공하는 데 기여하고 싶다면 다음 절차를 따라야 한다.

### 1단계

저장소를 포크한 후 아래 경로에 언어 파일을 추가한다. 언어 파일의 이름은 `${languageCode}-${countryCode}.js` 규칙을 따라야 한다. `languageCode`와 `countryCode`는 반드시 소문자로 표기해야 한다. (예. `en-gb.ts`)

> 참조 : [Nominatim/Country Codes](https://wiki.openstreetmap.org/wiki/Nominatim/Country_Codes)

```
- tui.editor/apps/editor/src/
  - i18n/
    - en-us.ts
    - ko-kr.ts
    - ...
```

### 2단계

[이 파일](https://github.com/nhn/tui.editor/tree/master/apps/editor/src/i18n/en-us.ts)을 참조하여 `setLanguage` 메서드를 호출할 때 사용되는 각 매개 변수 값을 작성한다.

첫 번째 매개 변수는 등록할 언어 파일에 매핑되는 코드 값이다. 코드 값은 [`${languageCode}-${countryCode}` 컨벤션](https://en.wikipedia.org/wiki/IETF_language_tag)을 따른다. `languageCode`는 소문자, `countryCode`는 대문자여야 한다.

```js
// th-th.js
// ...

Editor.setLanguage('th-TH', {
  Markdown: '...',
  WYSIWYG: '...',
  // ...
});
```

다음 조건이 충족되면 국가 코드를 제외한 언어 코드를 추가할 수 있다.

> IETF 언어 태그 참조 : 언어 태그에 구별되는 정보를 추가하지 않을 경우 지역 하위 태그를 생략하는 것이 좋다. 예를 들어, 스페인어는 라틴어일 것이기 때문에 es-latn보다 es가 더 선호되고, 일본에서 사용되는 일본어는 다른 곳에서 사용되는 일본어와 크게 다르지 않기 때문에 ja-JP보다 ja가 더 선호된다.
>
> 모든 언어 영역이 유효한 지역의 하위 태그로 표현될 수 있는 것은 아니다: 주 언어의 하위 지역 방언은 하위 태그로 등록된다. 예를 들어, 카탈루냐어의 발렌시아 방언에 대한 발렌시아 하위 태그는 접두사 ca로 언어 하위 태그 에 등록된다. 이 방언은 스페인에서 거의 독점적으로 사용되기 때문에, 일반적으로 지역 하위 태그 ES는 생략할 수 있다.

```js
// th-th.js
// ...

Editor.setLanguage(['th', 'th-TH'], {
  Markdown: '...',
  WYSIWYG: '...',
  // ...
});
```

## 예제

예제는 [여기](https://nhn.github.io/tui.editor/latest/tutorial-example16-i18n)서 확인할 수 있다.
