# Keymap ⌨️

The TOAST UI Grid makes it easy to use the grid by providing several keyboard events.

## Editor

| Action | Shortcut |
| --- | --- |
| Start or stop editing | `Enter` |
| Stop editing | `Esc` |
| Delete data | `Delete` / `Backspace` |

## Clipboard

| Action | Shortcut |
| --- | --- |
| Copy to clipboard | `Cmd(Ctrl)` + `c` |
| Paste from clipboard | `Cmd(Ctrl)` + `v` |

## Focus

| Action | Shortcut |
| --- | --- |
| Move | `→` `←` `↑` `↓`|
| Move to the first cell in row | `Home`|
| Move to the last cell in row | `End`|
| Move to the previous page cell in column | `PageUp`|
| Move to the next page cell in column | `PageDown`|
| Move to the first cell of the first column | `Cmd(Ctrl)` + `Home`|
| Move to the last cell of the last column | `Cmd(Ctrl)` + `End`|


![focus_1](https://user-images.githubusercontent.com/35371660/59552260-91411d80-8fbf-11e9-95f6-d01bd796329b.gif)
* `Cmd(Ctrl)` + `Home` / `Cmd(Ctrl)` + `End` Screenshot

## Selection

| Action | Shortcut |
| --- | --- |
| Select | `Shift` + `→` `←` `↑` `↓` |
| Select to the first cell of row based on focus | `Shift` + `Home` |
| Select to the last cell of row based on focus | `Shift` + `End` |
| Select to the first cell of column based on focus | `Shift` + `PageUp` |
| Select to the last cell of column based on focus | `Shift` + `PageDown` |
| Select to the first cell of first column based on focus | `Cmd(Ctrl)` + `Shift` + `Home` |
| Select to the last cell of last column based on focus | `Cmd(Ctrl)` + `Shift` + `End` |
| Select all cells | `Cmd(Ctrl)` + `A` |

![focus2](https://user-images.githubusercontent.com/35371660/59552787-21826100-8fc6-11e9-8749-43aebf3e1eff.gif)
* `Cmd(Ctrl)` + `Shift` + `Home` / `Cmd(Ctrl)` + `Shift` + `End` screenshot

## Example

You can see the example that keymap [here](https://nhn.github.io/tui.grid/latest/tutorial-example01-basic).


