# TOAST UI Grid v4.0 마이그레이션 가이드 ✈️

## 목차
* [개요](#개요)
* [설치하기](#설치하기)
* [API 마이그레이션](#API-마이그레이션)
    * [기능 개선](#기능-개선)
    * [변경](#변경)
    * [제거](#제거)

## 개요

가볍고 디펜던시 없는 깔끔한 TOAST UI Grid v4.0이 출시되었다. 이번 버전에서는 사용자가 TOAST UI Grid를 확장성 있게 사용할 수 있도록 새로운 API가 추가되었으며, 이름 변경 등 기존 API가 정리되었다.

v4.0을 사용하기 위해서는 API 마이그레이션이 필요하다. API 종류는 다음과 같다.

* 옵션
* 메서드
* 커스텀 이벤트

마이그레이션 진행 단위는 크게 **기능 개선, 변경, 제거**로 구분된다.

* 기능 개선 : 기능이 개선되고 추가된 API 목록
* 변경 : 기능은 유지되고 이름, 타입 등이 변경된 API 목록
* 제거 : 불필요하거나 스펙 아웃으로 제거된 API 목록

API 마이그레이션을 진행하기에 앞서, TOAST UI Grid 새 버전을 설치하여 사용할 때 주의할 사항이 있으므로 이를 먼저 숙지하고 다음 단계로 넘어간다.

## 설치하기

npm을 사용하면 커맨드로 v4.0을 간단하게 설치할 수 있다.

``` sh
npm install tui-grid@next
```

v4.0에서 가장 큰 변경 사항은 디펜던시 제거다. 브라우저에서 로드하여 사용하는 경우, 반드시 다음 디펜던시들을 제거한다(단, 데이트 피커 또는 페이지네이션을 사용할 때 `tui-code-snippet`은 제거하지 않고 기존과 같이 사용한다).

* `jquery`
* `underscore`
* `backbone`
* `tui-code-snippet`

또한 디펜던시를 포함한 번들 파일도 더 이상 제공하지 않으므로 CDN 등 파일 사용에 주의한다.

```
// v3
- dist
    - tui.grid.comb.js
    - tui.grid.full.js
    - tui-grid.js
```

```
// v4
- dist
    - tui-grid.js
```

새 버전 설치를 완료했다면 API 마이그레이션을 진행해보자.

## API 마이그레이션

### 기능 개선

#### 커스텀 에디터 & 커스텀 렌더러

이전 버전에서는 셀을 커스터마이징할 때 우회적으로 `formatter` 옵션을 사용하는 등 기능 구현에 제한이 많았다. 이러한 문제를 해결하기 위해 v4.0에 **커스텀 에디터** 및 **커스텀 렌더러**를 도입하였다. 이제 사용자가 원하는 방식으로 자유롭게 셀을 커스터마이징할 수 있다.

##### 커스텀 에디터

TOAST UI Grid는 다양한 종류의 기본 에디터를 제공한다.

* 텍스트 : `<input type="text" />`
* 비밀번호 : `<input type="password" />`
* 체크박스 : `<input type="checkbox" />` 및 `<label>`
* 라디오 버튼 : `<input type="radio" />` 및 `<label>`
* 셀렉트 박스 : `<select>` 및 `<options>`

기본 에디터는 `editOptions` 옵션을 사용해 생성했으나, v4.0부터 네이밍이 변경되어 `editor` 옵션을 사용해야 한다. 다음은 체크박스 에디터를 생성하는 예제다.

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      editOptions: {
        type: 'checkbox',
        listItems: [
          { text: 'Pop', value: '1' },
          { text: 'Rock', value: '2' },
          { text: 'R&B', value: '3' }
        ]
      }
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      editor: {
        type: 'checkbox',
        options: {
          listItems: [
            { text: 'Pop', value: '1' },
            { text: 'Rock', value: '2' },
            { text: 'R&B', value: '3' }
          ]
        }
      }
    }
  ]
});
```

TOAST UI Grid의 내장 에디터는 `CellEditor` 타입의 생성자 함수를 통해 생성되며, `CellEditor`는 다음 메서드를 포함한 인터페이스로 구현(참조 : [텍스트 에디터 생성자 함수](https://github.com/nhn/tui.grid/blob/master/src/editor/text.ts))되어 있다.

| 이름 | 반환값 타입 | 기능 | 비고 |
| --- | ------ | --- | --- |
| `getElement` | `HTMLElement` | 에디터에 해당하는 엘리먼트를 반환하는 메서드 | 필수 |
| `getValue` | `string \| number \| boolean` | 셀 데이터를 반환하는 메서드 | 필수 |
| `mounted` | `void` | `getElement`에서 반환한 엘리먼트가 렌더링 된 후 실행되는 메서드 | 옵셔널 |
| `beforeDestroy` | `void` | `getElement`에서 반환한 엘리먼트가 제거되기 전에 실행되는 메서드 | 옵셔널 |

기본 에디터 외 다른 종류의 에디터를 생성하거나 확장이 필요한 경우에는 `CellEditor` 인터페이스를 기반으로 한 **사용자 정의 커스텀 에디터 생성자 함수**를 사용한다. 다음은 사용자 정의 커스텀 에디터 생성자 함수를 사용하는 예제다.

``` js
class CustomTextEditor {
  constructor(props) {
    const el = document.createElement('input');

    el.type = 'text';
    el.value = String(props.value);

    this.el = el;
  }

  getElement() {
    return this.el;
  }

  getValue() {
    return this.el.value;
  }

  mounted() {
    this.el.select();
  }
}
```

먼저, `CellEditor` 인터페이스에 맞게 생성자 함수를 선언한다. 이 때 생성자 함수는 TOAST UI Grid에서 사용하는 속성에 접근할 수 있는 객체(`props` 해당)를 받을 수 있으며, 이 객체를 통해 여러 형태로 커스터마이징할 수 있다. 객체 속성 정보는 다음과 같다(`columnInfo` 속성의 상세 값은 [types.ts](https://github.com/nhn/tui.grid/blob/master/src/store/types.ts) 파일을 참고한다).

| 이름 | 타입 |
| --- | --- |
| `grid` | `Grid` |
| `rowKey` | `string \| number` |
| `value` | `number \| boolean` |
| `columnInfo` | `ColumnInfo` |

위에서 생성한 `CustomTextEditor` 생성자 함수를 `editor.type`의 옵션 값으로 설정하면 된다. `props`에서 제공하는 속성 외 다른 속성을 설정할 때 `editor.options` 옵션을 사용할 수 있다.

``` js
class CustomTextEditor {
  constructor(props) {
    const options = props.columnInfo.editor.myCustomOptions;
    // ...
  }
  // ...
}

const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      editor: {
        type: CustomTextEditor,
        options: {
          myCustomOptions: {
            // ...
          }
        }
      }
    }
  ]
});
```

##### 커스텀 렌더러

커스텀 렌더러는 커스텀 에디터와 비슷한 기능을 하는 생성자 함수다. TOAST UI Grid의 셀 컨텐츠는 `CellRenderer` 타입의 생성자 함수를 통해 생성되며, `CellRenderer`는 다음 메서드를 포함한 인터페이스로 구현(참조 : [디폴트 렌더러 생성자 함수](https://github.com/nhn/tui.grid/blob/master/src/renderer/default.ts))되어 있다.

| 이름 | 반환값 타입 | 기능 | 비고 |
| --- | ------ | --- | --- |
| `getElement` | `HTMLElement` | 셀 컨텐츠에 해당하는 엘리먼트를 반환하는 메서드 | 필수 |
| `mounted` | `void` | `getElement`에서 반환한 엘리먼트가 렌더링 된 후 실행되는 메서드 | 옵셔널 |
| `render` | `void` | 셀 데이터가 변경되었을 때 실행되는 메서드 | 필수 |
| `beforeDestroy` | `void` | `getElement`에서 반환한 엘리먼트가 제거되기 전에 실행되는 메서드 | 옵셔널 |
| `focused` | `string \| number \| boolean` | 셀에 포커스가 발생했을 때 실행되는 메서드 | 옵셔널 |

이전 버전에서는 `formatter`를 사용하여 셀 컨텐츠를 커스터마이징 하였으나 이 옵션의 사용 목적과 맞지 않는다. 그러므로 v4.0부터는 `CellRenderer` 인터페이스를 기반으로 한 **사용자 정의 커스텀 렌더러 생성자 함수**를 사용하는 것을 권장한다. 다음은 사용자 정의 커스텀 렌더러 생성자 함수를 사용하는 예제다.

``` js
class SliderRenderer {
  constructor(props) {
    const el = document.createElement('input');
    const { grid, rowKey, columnInfo } = props;

    el.type = 'range';

    el.addEventListener('mousedown', (ev) => {
      ev.stopPropagation();
    });

    el.addEventListener('change', () => {
      grid.setValue(rowKey, columnInfo.name, Number(el.value));
    });

    this.el = el;
    this.render(props);
  }

  getElement() {
    return this.el;
  }

  render(props) {
    this.el.value = String(props.value);
  }
}
```

사용 방식은 `CellEditor`와 동일하다. `CellRenderer` 인터페이스에 맞게 생성자 함수를 선언하고, TOAST UI Grid에서 사용하는 속성에 접근할 수 있는 객체(`props` 해당)를 사용해 커스터마이징한다. 객체 속성 정보는 다음과 같다(`columnInfo` 속성의 상세 값은 [types.ts](https://github.com/nhn/tui.grid/blob/master/src/store/types.ts) 파일을 참고한다).

| 이름 | 타입 |
| --- | --- |
| `grid` | `Grid` |
| `rowKey` | `number \| string` |
| `columnInfo` | `object` |
| `editable` | `boolean` |
| `disabled` | `boolean` |
| `invalidState` | `'REQUIRED' \| 'TYPE_STRING' \| 'TYPE_NUMBER'` |
| `formattedValue` | `string` |
| `value` | `string \| boolean` |
| `className` | `string` |

커스텀 렌더러는 v4.0에 신규로 추가된 `renderer` 옵션을 사용한다. 위에서 생성한 `SliderRenderer` 생성자 함수를 `renderer.type`의 옵션 값으로 설정한다. `props`에서 제공하는 속성 외 다른 속성을 설정할 때는 `renderer.options` 옵션을 사용한다.

``` js
class SliderRenderer {
  constructor(props) {
    const { min, max } = props.columnInfo.renderer.options;

    el.min = String(min);
    el.max = String(max);

    // ...
  }
  // ...
}

const grid = new Grid({
  columns: [
    // ...
    {
      name: 'score',
      renderer: {
        type: SliderRenderer,
        options: {
          min: 10,
          max: 30
        }
      }
    } 
  ]
});
```

#### 데이터 소스

이전 버전에서는 서버 통신 및 데이터 동기화를 위해 `Net` 애드온을 사용했으나 기능을 활성화하고 사용성이 떨어졌다. v4.0부터 `Net`이 **데이터 소스(Data Source)** 라는 데이터 타입으로 변경되어 보다 편리하게 서버 통신 로직을 구현할 수 있게 되었다. `Net` 사용 방식과 비교하면서 데이터 소스로 마이그레이션을 진행해본다.

데이터 소스는 `Net` 옵션 객체가 편집된 형태로, `data` 옵션을 사용하여 설정한다. 데이터 소스의 특징으로 각 CRUD 설정 옵션에 요청 메소드(`method`) 값을 다르게 지정할 수 있다. 이전 버전에서는 페이지네이션 기능을 사용할 때 인스턴스 생성 옵션 `pagination` 과 `Net` 하위 옵션인 `perPage`을 사용하여 복잡한 설정 과정을 거쳤으나, v4.0부터는 `pageOptions` 옵션을 사용해 설정을 한 번에 처리할 수 있다.

``` js
// v3
const options = {
  el: $('#data_form'),
  initialRequest: true,
  readDataMethod: 'GET', // deprecated
  perPage: 500, // deprecated
  enableAjaxHistory: true, // deprecated
  withCredentials: false,
  api: {
    readData: './api/read', // changed
    createData: './api/create', // changed
    updateData: './api/update', // changed
    deleteData: './api/delete', // changed
    modifyData: './api/modify', // changed
    downloadExcel: './api/download/excel', // deprecated
    downloadExcelAll: './api/download/excelAll' // deprecated
  }
};

const grid = new Grid({
  // ...
  pagination: true
});

grid.use('Net', options);
```

``` js
// v4
const dataSource = {
  withCredentials: false,
  initialRequest: true,
  api: {
    readData: { url: '/api/read', method: 'GET' },
    createData: { url: '/api/create', method: 'POST' },
    updateData: { url: '/api/update', method: 'PUT' },
    deleteData: { url: '/api/delete', method: 'DELETE' },
    modifyData: { url: '/api/modify', method: 'POST' }
  }
};

const grid = new Grid({
  // ...
  data: dataSource,
  pageOptions: {
    perPage: 500
  }
});
```

데이터 소스를 통한 서버 요청 시에는 인스턴스의 메서드로 `request` 를호출한다. 또한 호출 파라미터 속성 중 `hasDataParam`, `updateOriginal`가 제거되었으며 `checkedOnly` 속성의 기본 값이 `false`로 변경되었다. `updateOriginal` 옵션을 제거하고 `resetData`, `reloadData`, `readData` 메서드 호출 시 데이터가 갱신되도록 변경되었다. 다음은 '데이터 생성' 요청을 처리하는 로직을 비교한 것이다. 데이터 소스를 사용함으로써 이전 버전과 비교하여 서버 통신을 구현하는 과정이 간편해졌다.

``` js
// v3
const net = grid.getAddOn('Net');

net.request('createData', {
  hasDataParam: true, // deprecated
  checkedOnly: true, // changed
  modifiedOnly: true,
  showConfirm: true,
  updateOriginal: true, // deprecated
  withCredentials: false
});
```

``` js
// v4
grid.request('createData', {
  checkedOnly: false,
  modifiedOnly: true,
  showConfirm: true,
  withCredentials: false
});
```

### 변경

#### 지원 브라우저 범위 (IE > 9)

v4.0부터 지원 브라우저 범위가 **인터넷 익스플로러 9 이상**으로 변경된다. 이전 버전에서는 인터넷 익스플로러 8을 지원하였으나 낮은 브라우저 점유율 및 webpack 4와 같은 최신 개발 환경 사용을 위해 지원 범위를 변경하게 되었다.

#### header 네이밍

TOAST UI Grid는 테이블로 구성되어 있다. 테이블의 기능에 맞게 헤더 영역에 표시되는 요소 이름에 `header`를 사용하도록 변경되었다.

* 컬럼 옵션

| v3 | v4 |
| --- | --- |
| `columns[].title` | `columns[].header` |

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      title: 'Genre',
      // ...
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      header: 'Genre',
      // ...
    }
  ]
});
```

* 로우 헤더 옵션

| v3 | v4 |
| --- | --- |
| `rowHeaders[].title` | `rowHeaders[].header` |

``` js
// v3
const grid = new Grid({
  // ...
  rowHeaders: [
    {
      type: 'rowNum',
      title: 'No.',
      // ...
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  rowHeaders: [
    {
      type: 'rowNum',
      header: 'No.',
      // ...
    }
  ]
});
```

* 테마 옵션

| v3 | v4 |
| --- | --- |
| `cell.head` | `cell.header` |
| `cell.selectedHead` | `cell.selectedHeader` |
| `cell.rowHead` | `cell.rowHeader` |
| `cell.selectedRowHead` | `cell.selectedRowHeader` |

``` js
// v3
const extOptions = {
  cell: {
    head: '#333'
  }
};
Grid.applyTheme('default', extOptions);
```

``` js
// v4
const extOptions = {
  cell: {
    header: '#333'
  }
};
Grid.applyTheme('default', extOptions);
```

* 메서드

| v3 | v4 |
| --- | --- |
| `setColumnTitles` | `setColumnHeaders` |

#### _extraData 속성

이전 버전에서는 데이터에서 각 컬럼에 해당하는 속성 외 나머지 속성을 설정하는 속성으로 `_extraData`가 사용되었다. 사용 기능을 명확하게 하기 위해 `_attributes`로 이름이 변경되고 하위 옵션도 개별 속성으로 분리되었다.

* 데이터 옵션

| v3 | v4 |
| --- | --- |
| `data[]._extraData` | `data[]._attributes` |

* 하위 옵션

| v3 | v4 |
| --- | --- |
| `_extraData.rowState: 'DISABLED'` | `_attributes.disabled` |
| `_extraData.rowState: 'DISABLED_CHECK'` | `_attributes.checkDisabled` |
| `_extraData.rowState: 'CHECKED'` | `_attributes.checked` |
| `_extraData.treeState: 'EXPAND'` | `_attributes.expanded: true` |
| `_extraData.treeState: 'COLLAPSE'` | `_attributes.expanded: false` |

``` js
// v3
const grid = new Grid({
  // ...
  data: [
    {
      name: 'X',
      artist: 'Ed Sheeran',
      _extraData: {
        rowState: 'DISABLED',
        // ...
      }
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  data: [
    {
      name: 'X',
      artist: 'Ed Sheeran',
      _attributes: {
        disabled: true,
        // ...
      }
    }
  ]
});
```

#### formatter 옵션
`formatter` 옵션으로 설정한 콜백 함수가 실행될 때 넘어오는 파라미터 타입이 변경되었다. 기존에는 `value`, `rowData` 2개 값이 각 파라미터로 넘어왔으나, v4.0부터는 아래와 같은 객체 정보로 넘어온다.

* `row`: 셀이 포함된 로우의 정보
* `column`: 셀이 포함된 컬럼의 정보
* `value`: 셀의 값

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'artist',
      title: 'Artist',
      formatter(value, rowData) {
        // ...
      }
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'artist',
      header: 'Artist',
      formatter({ row, column, value }) {
        // ...
      }
    }
  ]
});
```

#### columns[].editOptions 옵션

사용자 정의 에디터를 제공하기 위해 `editOptions` 옵션이 `editor` 옵션으로 변경되면서 하위 및 관련 옵션이 변경되었다.

* `editOptions.listItem` -> `editor.options.listItem` : 체크박스, 라디오 버튼, 셀렉트 박스의 아이템 요소 값을 설정하는 옵션이며 `options`하위로 뎁스가 변경되었다.
* `editOptions.useViewMode` 제거 : 기존의 `useViewMode: false` 동작을 커스텀 렌더러로 구현할 수 있으며 확장성을 위해 제거되었다.
* `formatter: 'listItemText'` 내장 값 추가 : `editor.options.listItem` 옵션에 설정된 값을 문자열 형태로 출력할 수 있다.

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      editOptions: {
        type: 'checkbox',
        listItem: [
          { text: 'Pop', value: '1' },
          { text: 'Rock', value: '2' }
        ],
        useViewMode: true
      }
    }
  ]
});
```
``` js
// v4
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      formatter: 'listItemText',
      editor: {
        type: 'checkbox',
        options: {
          listItem: [
            { text: 'Pop', value: '1' },
            { text: 'Rock', value: '2' }
          ]
        }
      }
    }
  ]
});
```

#### columns[].relations 옵션

릴레이션 컬럼 기능을 사용할 때 `columns[].relations` 옵션을 사용하는데, 하위 및 관련 옵션이 변경되어 사용에 주의한다. 릴레이션 컬럼에서는 셀렉트 박스 내장 에디터를 사용하고 `relations.listItems` 옵션에 설정된 콜백 함수에서 반환한 값으로 셀렉트 박스 아이템을 생성하는데, 이 콜백 함수가 실행될 때 넘어오는 파라미터 타입이 변경되었다. 기존에는 `value`, `rowData` 2개 값이 각 파라미터로 넘어왔으나, v4.0부터는 객체에 포함되어 넘어온다.

또한 `editOptions` 옵션이 변경되었으므로 연관된 컬럼의 에디터를 생성할 때 `editor` 옵션을 사용하며, 반드시 `editor.options.listItems` 옵션을 빈 배열(`[]`)로 초기화해야 한다.


``` js
// v3
grid.setColumns([
  {
    title: 'col1',
    name: 'col1',
    relations: [
      targetNames: ['col2'],
      listItems(value, rowData) {
        let items;

        if (value === '1') {
          items = [
           { text: 'opt1', value: '1' }
           { text: 'opt2', value: '2' }
          ];
        } else {
          items = [
            { text: 'opt3', value: '3' }
            { text: 'opt4', value: '4' }
          ];
        }

        return items;
     }
  ]
},
{
  title: 'col2',
  name: 'col2',
    editOptions: {
      type: 'select'
    }
  }
]);
```

``` js
// v4
grid.setColumns([
  {
    header: 'col1',
    name: 'col1',
    formatter: 'listItemText',
    editor: {
      type: 'select',
      options: {
        listItems: []
      }
    },
    relations: [
      targetNames: ['col2'],
      listItems({ value }) {
        let items;

        if (value === '1') {
          items = [
            { text: 'opt1', value: '1' }
            { text: 'opt2', value: '2' }
          ];
        } else {
          items = [
            { text: 'opt3', value: '3' }
            { text: 'opt4', value: '4' }
          ]
        }
        return items;
      }
    ]
  },
  {
    header: 'col2',
    name: 'col2',
    formatter: 'listItemText',
    editor: {
      type: 'select',
      options: {
        listItems: []
      }
    }
  }
]);
```

#### rowHeaders 옵션

로우 헤더 컬럼을 커스터마이징하는 방식이 변경되었다. 일반 컬럼에서 사용하는 방식과 동일하게 커스텀 렌더러를 사용하며, 다음과 같이 관련 옵션이 변경되었다.

* `template` 제거 : `renderer` 옵션을 사용하여 셀 요소를 커스터마이징한다.
* `header` 사용 : 전체 체크박스를 커스터마이징할 때 `template` 옵션에 지정된 값을 동일하게 사용하였으나 해당 옵션이 제거되어 `header` 옵션에 설정된 템플릿 문자열(기본 템플릿 문자열 - 하단 예제 참조)을 사용하도록 변경되었다.
* `type: radio` 제거 : 로우 헤더 컬럼에 행 번호, 체크박스, 라디오 버튼을 지정할 수 있었으나 커스텀 렌더러를 활용하는 방안으로 생성 옵션에서 라디오 버튼을 제거하였다.

``` js
// v3
const grid = new Grid({
  // ...
  rowHeaders: [
    {
      type: 'checkbox',
      template: (props) => {
        // ...
        return tmpl;
      }
    }
  ]
});
```

``` js
// v4
class SingleCheckRenderer {
  // ...
}

const grid = new Grid({
  // ...
  rowHeaders: [
    {
      type: 'checkbox',
      header: `
        <label for="all-checkbox" class="checkbox">
          <input type="checkbox" id="all-checkbox" class="hidden-input" name="_checked" />
          <span class="custom-input"></span>
        </label>
      `,
      renderer: SingleCheckRenderer
    }
  ]
});
```

#### 트리 이벤트

이벤트명 및 핸들러 함수의 이벤트 객체 정보가 변경되었다.

| v3 | v4 |
| --- | --- |
| `expanded` | `expand` |
| `collapsed` | `collapse` |

``` js
// v3
grid.on('expanded', (rowKey, descendantRowKeys) => {
  console.log(rowKey, descendantRowKeys);
});
```

``` js
// v4
grid.on('expand', (ev) => {
  const rowKey = ev.rowKey;
  const descendantRowKeys = grid.getDescendantRows();

  console.log(rowKey, descendantRowKeys);
});
```

#### 메서드명

표기가 잘못되거나 기능이 명확하지 않은 메서드명이 변경되었다.

| v3 | v4 |
| --- | --- |
| `getRows` | `getData` |
| `setData` | `resetData` |
| `unSort` | `unsort` |
| `selection` | `setSelectionRange` |
| `enableCheck` | `enableRowCheck` |
| `disableCheck` | `disableRowCheck` |
| `focusIn` | `startEditing` |
| `focusInAt` | `startEditingAt` |
| `getAncestors` | `getAncestorRows` |
| `getDescendants` | `getDescendantRows` |
| `getParent` | `getParentRow` |
| `getChildren` | `getChildRows` |

### 제거

#### setData

데이터를 설정할 때 사용되었던 `setData` 메서드가 `resetData`로 이름이 변경되면서 제거되었다. v4.0부터 반드시 `resetData`를 호출하여 데이터를 설정한다.

```js
// v4
grid.resetData([ ... ]);
```

#### Net

`DataSoucre` 신규 지원으로 `Net`과 관련된 API가 제거되었다.

* `use`
* `getAddOn`

``` js
// v3
const grid = new Grid({
  // ...
  pagination: true
});

grid.use('Net', {
  // ...
});

const net = grid.getAddOn('Net'); // deprecated
net.request('createData');
```

#### columns[].prefix / columns[].postfix 옵션

셀 데이터를 커스터마이징할 수 있는 옵션으로 `columns[].formatter`, `columns[].prefix`, `columns[].postfix` 옵션을 제공하였다. v4.0부터 커스텀 렌더러를 이용하여 커스터마이징이 가능하므로 `columns[].prefix`, `columns[].postfix` 옵션이 제거되었다.

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'genre',
      formatter: (value) => {
        return `<a href="#">${value}</a>`;
      },
      prefix: 'pre text', // deprecated
      postfix: 'post text' // deprecated
    }
  ]
});
```

#### columns[].component 옵션

외부 컴포넌트를 설정하는 용도의 `columns[].component` 옵션이 제거되었다. 데이트 피커 기능이 컴포넌트에서 커스텀 에디터로 변경되었으므로 데이트 피커를 사용할 때 다음과 같이 설정한다.

``` js
// v3
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'release',
      editOptions: {
        type: 'text'
      },
      component: {
        name: 'datePicker',
        options: {
          date: new Date(2017, 3, 10)
          format: 'yyyy/MM/dd'
        }
      }
    }
  ]
});
```

``` js
// v4
const grid = new Grid({
  // ...
  columns: [
    {
      name: 'release',
      editor: {
        type: 'datePicker',
        options: {
          format: 'yyyy/MM/dd',
        }
      }
    }
  ]
});
```

#### toJSON 파라미터

메서드 호출 시 JSON 문자열을 반환하도록 설정하는 파라미터 값이 제거되었다.

* `getCheckedRowKeys`
* `getCheckedRows`
* `getRow`
* `getRowAt`
* `getData`

``` js
// v3
/**
 * Returns a list of the checked rows.
 * @param {boolean} [useJson=false] - If set to true, return value will be converted to JSON string.
 * @returns {Array|string} - A list of the checked rows. (or JSON string of the list)
 */
getCheckedRows: function(useJson) { ... }
```

``` js
// v4
/**
 * Returns a list of the checked rows.
 * @param {boolean} [useJson=false] - If set to true, return value will be converted to JSON string.
 */
public getCheckedRowKeys(): RowKey[] { ... }
```

#### 트리 이벤트

`expand`, `collapse` 이벤트로 대체 가능하여 제거되었다.

* `expandedAll`
* `collapsedAll` 